///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

/** 
 * \file SettingsDialog.h 
 * \brief Contains the definition of the Core::SettingsDialog class. 
 */

#ifndef __OVITO_SETTINGS_DIALOG_H
#define __OVITO_SETTINGS_DIALOG_H

#include <core/Core.h>

namespace Core {
	
class SettingsDialog;		// defined below	

/**
 * \brief Abstract base class for plugins that want to insert a new tab into the
 *        application's settings dialog.
 * 
 * \author Alexander Stukowski
 */
class CORE_DLLEXPORT ApplicationSettingsPage : public PluginClass
{
protected:

	/// Base class constructor.
	ApplicationSettingsPage() : PluginClass() {}

public:

	/// \brief Creates the widget that contains the plugin specific setting controls.
	/// \param settingsDialog The settings dialog box. 
	/// \param tabWidget The QTabWidget into which the method should insert the settings page.
	virtual void insertSettingsDialogPage(SettingsDialog* settingsDialog, QTabWidget* tabWidget) = 0;

	/// \brief Lets the settings page to save all values entered by the user.
	/// \param settingsDialog The settings dialog box. 
	virtual void saveValues(SettingsDialog* settingsDialog) {}

private:

	Q_OBJECT
	DECLARE_ABSTRACT_PLUGIN_CLASS(ApplicationSettingsPage)
};
	
/**
 * \brief The dialog window that lets the user change the global application settings.
 * 
 * Plugins can add additional pages to this dialog by deriving new classes from
 * the ApplicationSettingsPage class.
 * 
 * \author Alexander Stukowski
 */
class CORE_DLLEXPORT SettingsDialog : public QDialog
{
	Q_OBJECT
	
public:

	/// \brief Constructs the dialog window.
	/// \param parent The parent window of the settings dialog.
	SettingsDialog(QWidget* parent);
	
protected Q_SLOTS:

	/// This is called when the user has pressed the OK button of the settings dialog.
	/// Validates and saves all settings made by the user and closes the dialog box.
	void onOk();

private:

	QVector<ApplicationSettingsPage::SmartPtr> pages;
};

};

#endif // __OVITO_SETTINGS_DIALOG_H
