# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-719-1 (libpam-krb5)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64166);
 script_cve_id("CVE-2009-0360", "CVE-2009-0361", "CVE-2007-3996", "CVE-2007-5900", "CVE-2008-3658", "CVE-2008-3659", "CVE-2008-3660", "CVE-2008-5557", "CVE-2008-5624", "CVE-2008-5625", "CVE-2008-5658", "CVE-2007-5625", "CVE-2007-6420", "CVE-2008-1232", "CVE-2008-1947", "CVE-2008-2364", "CVE-2008-2370", "CVE-2008-2938", "CVE-2008-2939");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Ubuntu USN-719-1 (libpam-krb5)";
 script_name(name);

 desc = "The remote host is missing an update to libpam-krb5
announced via advisory USN-719-1.

Details follow:

It was discovered that pam_krb5 parsed environment variables when run with
setuid applications. A local attacker could exploit this flaw to bypass
authentication checks and gain root privileges. (CVE-2009-0360)

Derek Chan discovered that pam_krb5 incorrectly handled refreshing existing
credentials when used with setuid applications. A local attacker could exploit
this to create or overwrite arbitrary files, and possibly gain root privileges.
(CVE-2009-0361)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 8.04 LTS:
  libpam-krb5                     3.10-1ubuntu0.8.04.1

Ubuntu 8.10:
  libpam-krb5                     3.10-1ubuntu0.8.10.1

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-719-1

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-719-1 (libpam-krb5)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libpam-krb5", ver:"3.10-1ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpam-krb5", ver:"3.10-1ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php-pear", ver:"5.1.2-1ubuntu3.13", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5", ver:"5.1.2-1ubuntu3.13", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.1.2-1ubuntu3.13", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cgi", ver:"5.1.2-1ubuntu3.13", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cli", ver:"5.1.2-1ubuntu3.13", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-common", ver:"5.1.2-1ubuntu3.13", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-curl", ver:"5.1.2-1ubuntu3.13", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-dev", ver:"5.1.2-1ubuntu3.13", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-gd", ver:"5.1.2-1ubuntu3.13", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-ldap", ver:"5.1.2-1ubuntu3.13", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mhash", ver:"5.1.2-1ubuntu3.13", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mysql", ver:"5.1.2-1ubuntu3.13", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mysqli", ver:"5.1.2-1ubuntu3.13", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-odbc", ver:"5.1.2-1ubuntu3.13", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.1.2-1ubuntu3.13", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-recode", ver:"5.1.2-1ubuntu3.13", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-snmp", ver:"5.1.2-1ubuntu3.13", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.1.2-1ubuntu3.13", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sybase", ver:"5.1.2-1ubuntu3.13", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.1.2-1ubuntu3.13", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xsl", ver:"5.1.2-1ubuntu3.13", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php-pear", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cgi", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cli", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-common", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-curl", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-dev", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-gd", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-ldap", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mhash", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mysql", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-odbc", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pspell", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-recode", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-snmp", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sybase", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-tidy", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xsl", ver:"5.2.3-1ubuntu6.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php-pear", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cgi", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cli", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-common", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-curl", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-dev", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-gd", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-gmp", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-ldap", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mhash", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mysql", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-odbc", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pspell", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-recode", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-snmp", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sybase", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-tidy", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xsl", ver:"5.2.4-2ubuntu5.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php-pear", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php5filter", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cgi", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cli", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-common", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-curl", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-dbg", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-dev", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-gd", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-gmp", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-ldap", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mhash", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mysql", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-odbc", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pspell", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-recode", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-snmp", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sybase", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-tidy", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xsl", ver:"5.2.6-2ubuntu4.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
