###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_sdp_downloader_bof_vuln.nasl 2283 2009-05-19 10:07:05Z may $
#
# SDP Downloader ASX File Heap Buffer Overflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
##############################################################################

if(description)
{
  script_id(900642);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1627");
  script_bugtraq_id(34712);
  script_name("SDP Downloader ASX File Heap Buffer Overflow Vulnerability");
  desc = "

  Overview: This host is installed with SDP Downloader and is prone to Buffer
  Overflow vulnerability.

  Vulnerability Insight:
  A boundary error exists while processing an HREF attribute of a REF element
  in ASX files, due to which application fails to check user supplied input
  before copying it into an insufficiently sized buffer.

  Impact:
  Successful exploits will allow attackers to execute arbitrary code and can
  cause application crash via a long .asf URL.

  Impact Level: Application

  Affected Software/OS:
  SDP Downloader version 2.3.0 and prior

  Fix: No solution or patch is available as on 19th May, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://sdp.ppona.com

  References:
  http://secunia.com/advisories/34883
  http://www.milw0rm.com/exploits/8536
  http://www.vupen.com/english/advisories/2009/1171

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Checks for the version of SDP Downloader");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_sdp_downloader_detect.nasl");
  script_require_keys("SDP/Downloader/Ver");
  exit(0);
}


include("version_func.inc");

sdpVer = get_kb_item("SDP/Downloader/Ver");

if(sdpVer != NULL)
{
  if(version_is_less_equal(version:sdpVer,test_version:"2.3.0")){
    security_hole(0);
  }
}
