###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_php_icalendar_mult_vuln.nasl 895 2009-01-28 14:33:29Z jan $
#
# Multiple Vulnerabilities in PHP iCalendar
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900199);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2008-5967", "CVE-2008-5968");
  script_name("Multiple Vulnerabilities in PHP iCalendar");
  desc = "

  Overview: This host is running PHP iCalendar and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  - Error in admin/index.php file allows remote attackers to upload
    .ics file with arbitrary contents to the calendars/directory.
  - print.php file allows to include and execute arbitrary local files via
    a '../' in the cookie_language parameter in phpicalendar_* cookie.

  Impact:
  Successful exploitation could result in Security Bypass or Directory
  Traversal attack on the affected web application.

  Impact Level: Application

  Affected Software/OS:
  PHP iCalendar version 2.34 and prior on all running platform.

  Workaround:
  Restrict access to 'admin' area by adding security policies in '.htaccess'

  Fix: No solution or patch is available as on 29th January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://phpicalendar.net

  References:
  http://milw0rm.com/exploits/6519
  http://secunia.com/advisories/31944

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of PHP iCalendar");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_php_icalendar_detect.nasl");
  script_require_keys("PHP/iCalendar/Ver");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

icalendarVer = get_kb_item("PHP/iCalendar/Ver");
if(!icalendarVer){
  exit(0);
}

#Check for version 2.34 and prior
if(version_is_less_equal(version:icalendarVer, test_version:"2.34"))
{
  security_hole(port);
  security_hole(data:string(desc, "\nPlease Ignore the warning, if"+
                           " version is greater than 2.24, as later versions\n"+
                           "are not affected by Directory Traversal attack."), port);
}
