###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-070.nasl 6095 2009-12-09 03:48:09Z dec $
#
# Microsoft Windows ADFS Remote Code Execution Vulnerability (971726)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901064);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-2508", "CVE-2009-2509");
  script_name("Microsoft Windows ADFS Remote Code Execution Vulnerability (971726)");
  desc = "
  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-070.

  Vulnerability Insight:
  The vulnerability is due to incorrect validation of request headers when an
  authenticated user connects to an ADFS enabled Web Server. An attacker who
  successfully exploited this vulnerability could take complete control of an
  affected system

  Impact:
  Successful exploitation will let the remote attackers to take complete control
  of the victim's system.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2K3 Service Pack 2 and prior.

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms09-070.mspx

  References:
  http://secunia.com/advisories/37542/
  http://support.microsoft.com/kb/971726
  http://www.vupen.com/english/advisories/2009/3434
  http://www.microsoft.com/technet/security/bulletin/MS09-070.mspx

  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Adfsreg.exe file");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2003:3) <= 0){
  exit(0);
}

# MS09-070 Hotfix check
if(hotfix_missing(name:"971726") == 0){
  exit(0);
}

dllPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!dllPath){
  exit(0);
}

dllPath = dllPath - "\system32" + "\adfs\Adfsreg.exe";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllPath);

dllVer = GetVer(file:file, share:share);
if(!dllVer){
  exit(0);
}

# Windows 2003
if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Adfsreg.exe version < 5.2.3790.4578
    if(version_is_less(version:dllVer, test_version:"5.2.3790.4578")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
