###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_php_dos_vuln_apr09.nasl 1603 2009-04-17 18:42:56Z apr $
#
# Denial Of Service Vulnerability in PHP April-09
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800393);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-1272");
  script_name("Denial Of Service Vulnerability in PHP April-09");
  desc = "

  Overview: The host is installed with PHP and is prone to Denial of
  Service vulnerability.

  Vulnerability Insight:
  Improper handling of .zip file while doing extraction via
  php_zip_make_relative_path function in php_zip.c file.

  Impact:
  Successful exploitation could result in denial of service condition.

  Impact Level: Application

  Affected Software/OS:
  PHP version prior to 5.2.9

  Fix:
  Upgrade to PHP version 5.2.9 or above,
  http://www.php.net/downloads.php

  Workaround:
  For workaround refer below link,
  http://cvs.php.net/viewvc.cgi/php-src/ext/json/JSON_parser.c?r1=1.1.2.14&r2=1.1.2.15

  References:
  http://www.php.net/releases/5_2_9.php
  http://www.openwall.com/lists/oss-security/2009/04/01/9

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of PHP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_php_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("version_func.inc");

phpPort = get_kb_item("Services/www");
if(!phpPort){
  exit(0);
}

phpVer = get_kb_item("www/" + phpPort + "/PHP");
if(!phpVer){
  exit(0);
}

# Match PHP version < 5.2.9
if(version_is_less(version:phpVer, test_version:"5.2.9")){
  security_warning(phpPort);
}
