###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_openpro_file_inc_vuln.nasl 4317 2009-09-03 10:34:11Z sep $
#
# OpenPro Remote File Inclusion Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800929);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2008-7087");
  script_bugtraq_id(30264);
  script_name("OpenPro Remote File Inclusion Vulnerability");
  desc = "
  Overview: This host is installed with OpenPro and is prone to Remote File
  Inclusion vulnerability.

  Vulnerability Insight:
  The user supplied input passed into 'LIBPATH' parameter in the 'search_wA.php'
  script is not properly sanitised before being returned to the user.

  Impact:
  Attackers can exploit this issue to execute arbitrary code by including remote
  PHP files via malicious URLs.

  Impact Level: Application

  Affected Software/OS:
  OpenPro version 1.3.1 and prior.

  Fix: No solution or patch is available as on 03rd September, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://sourceforge.net/projects/openpro/

  References:
  http://osvdb.org/51466
  http://www.securityfocus.com/archive/1/archive/1/494426/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of OpenPro");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_openpro_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

openPort = get_http_port(default:80);
if(!openPort){
  exit(0);
}

openproVer = get_kb_item("www/" + openPort + "/OpenPro");
openproVer = eregmatch(pattern:"^(.+) under (/.*)$", string:openproVer);

if(openproVer[1] != NULL)
{
  if(version_is_less_equal(version:openproVer[1], test_version:"1.3.1")){
    security_hole(openPort);
  }
}
