###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_clicknet_cms_detect.nasl 3290 2009-07-08 12:28:24Z jul $
#
# Clicknet CMS Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800901);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("Clicknet CMS Version Detection");
  desc = "

  Overview: This script detects the installed version of Clicknet CMS and
  sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets the KB for the version of Clicknet CMS");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

clickPort = get_http_port(default:80);
if(!clickPort){
  clickPort = 80;
}

if(!get_port_state(clickPort)){
  exit(0);
}

foreach dir (make_list("/clicknet", "/cms", "/clicknetcms", cgi_dirs()))
{
  sndReq = http_get(item:string(dir + "/index.php"), port:clickPort);
  rcvRes = http_send_recv(port:clickPort, data:sndReq);
  if("Powered by" >< rcvRes && "Clicknet CMS" >< rcvRes)
  {
    clickVer = eregmatch(pattern:"Clicknet CMS v([0-9.]+)", string:rcvRes);
    if(clickVer[1] != NULL)
    {
      set_kb_item(name:"www/" + clickPort + "/Clicknet-CMS",
                  value:clickVer[1] + " under " + dir);
      security_note(data:"Clicknet CMS version " + clickVer[1] + " running at" + 
                         " location " + dir +  " was detected on the host");
    }
  }
}
