# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 165-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53421);
 script_cve_id("CVE-2002-0972");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 165-1 (postgresql)";
 script_name(name);

 desc = "The remote host is missing an update to postgresql
announced via advisory DSA 165-1.

Mordred Labs and others found several vulnerabilities in PostgreSQL,
an object-relational SQL database.  They are inherited from several
buffer overflows and integer overflows.  Specially crafted long date
and time input, currency, repeat data and long timezone names could
cause the PostgreSQL server to crash as well as specially crafted
input data for lpad() and rpad().  More buffer/integer overflows were
found in circle_poly(), path_encode() and path_addr().

Except for the last three, these problems are fixed in the upstream
release 7.2.2 of PostgreSQL which is the recommended version to use.

Most of these problems do not exist in the version of PostgreSQL that
Debian ships in the potato release since the corresponding
functionality is not yet implemented.  However, PostgreSQL 6.5.3 is
quite old and may bear more risks than we are aware of, which may
include further buffer overflows, and certainly include bugs that
threaten the integrity of your data.

You are strongly advised not to use this release but to upgrade your
system to Debian 3.0 (stable) including PostgreSQL release 7.2.1
instead, where many bugs have been fixed and new features introduced
to increase compatibility with the SQL standards.

If you consider an upgrade, please make sure to dump the entire
database system using the pg_dumpall utility.  Please take into
consideration that the newer PostgreSQL is more strict in its input
handling.  This means that tests line foo = NULL which are not valid
won't be accepted anymore.  It also means that when using UNICODE
encoding, ISO 8859-1 and ISO 8859-15 are no longer valid incoding to
use when inserting data into the relation.  In such a case you are
advised to convert the dump in question using recode latin1..utf-16.

These problems have been fixed in version 7.2.1-2woody2 for the
current stable distribution (woody) and in version 7.2.2-2 for the
unstable distribution (sid).  The old stable distribution (potato) is
partially affected and we ship a fixed version 6.5.3-27.2 for it.

We recommend that you upgrade your PostgreSQL packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20165-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 165-1 (postgresql)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"postgresql-doc", ver:"6.5.3-27.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql", ver:"6.5.3-27.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client", ver:"6.5.3-27.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib", ver:"6.5.3-27.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-dev", ver:"6.5.3-27.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-doc", ver:"7.2.1-2woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql", ver:"7.2.1-2woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client", ver:"7.2.1-2woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib", ver:"7.2.1-2woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-dev", ver:"7.2.1-2woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
