# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1533-1 (exiftags)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60654);
 script_cve_id("CVE-2007-6354", "CVE-2007-6355", "CVE-2007-6356");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1533-1 (exiftags)";
 script_name(name);

 desc = "The remote host is missing an update to exiftags
announced via advisory DSA 1533-1.

Christian Schmid and Meder Kydyraliev (Google Security) discovered a
number of vulnerabilities in exiftags, a utility for extracting EXIF
metadata from JPEG images. The Common Vulnerabilities and Exposures
project identified the following three problems:

CVE-2007-6354

Inadequate EXIF property validation could lead to invalid memory
accesses if executed on a maliciously crafted image, potentially
including heap corruption and the execution of arbitrary code.

CVE-2007-6355

Flawed data validation could lead to integer overflows, causing
other invalid memory accesses, also with the potential for memory
corruption or arbitrary code execution.

CVE-2007-6356

Cyclical EXIF image file directory (IFD) references could cause
a denial of service (infinite loop).

For the stable distribution (etch), these problems have been fixed in
version 0.98-1.1+etch1.

The old stable distribution (sarge) cannot be fixed synchronously
with the Etch version due to a technical limitation in the Debian
archive management scripts.

For the unstable distribution (sid), these problems have been fixed in
version 1.01-0.1.

We recommend that you upgrade your exiftags package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201533-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1533-1 (exiftags)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"exiftags", ver:"0.98-1.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
