/*  sjis.h - Unicode to Shift JIS lookup table

    libzint - the open source barcode library
    Copyright (C) 2009 Robin Stuart <robin@zint.org.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

/* Derived from :
## Shift_JIS (JIS X 0208:1997 Appendix 1) vs Unicode mapping table
## 
## Date: 06 Mar 2002 06:01:22 GMT
## License:
## 	Copyright (C) 2001 earthian@tama.or.jp, All Rights Reserved.
## 	Copyright (C) 2001 I'O, All Rights Reserved.
## 	You can use, modify, distribute this table freely.
*/

const unsigned long int sjis_lookup[] = {
      0x005C,0x815F,      // REVERSE SOLIDUS
      0x00A2,0x8191,      // CENT SIGN
      0x00A3,0x8192,      // POUND SIGN
      0x00A7,0x8198,      // SECTION SIGN
      0x00A8,0x814E,      // DIAERESIS
      0x00AC,0x81CA,      // NOT SIGN
      0x00B0,0x818B,      // DEGREE SIGN
      0x00B1,0x817D,      // PLUS-MINUS SIGN
      0x00B4,0x814C,      // ACUTE ACCENT
      0x00B6,0x81F7,      // PILCROW SIGN
      0x00D7,0x817E,      // MULTIPLICATION SIGN
      0x00F7,0x8180,      // DIVISION SIGN
      0x0391,0x839F,      // GREEK CAPITAL LETTER ALPHA
      0x0392,0x83A0,      // GREEK CAPITAL LETTER BETA
      0x0393,0x83A1,      // GREEK CAPITAL LETTER GAMMA
      0x0394,0x83A2,      // GREEK CAPITAL LETTER DELTA
      0x0395,0x83A3,      // GREEK CAPITAL LETTER EPSILON
      0x0396,0x83A4,      // GREEK CAPITAL LETTER ZETA
      0x0397,0x83A5,      // GREEK CAPITAL LETTER ETA
      0x0398,0x83A6,      // GREEK CAPITAL LETTER THETA
      0x0399,0x83A7,      // GREEK CAPITAL LETTER IOTA
      0x039A,0x83A8,      // GREEK CAPITAL LETTER KAPPA
      0x039B,0x83A9,      // GREEK CAPITAL LETTER LAMDA
      0x039C,0x83AA,      // GREEK CAPITAL LETTER MU
      0x039D,0x83AB,      // GREEK CAPITAL LETTER NU
      0x039E,0x83AC,      // GREEK CAPITAL LETTER XI
      0x039F,0x83AD,      // GREEK CAPITAL LETTER OMICRON
      0x03A0,0x83AE,      // GREEK CAPITAL LETTER PI
      0x03A1,0x83AF,      // GREEK CAPITAL LETTER RHO
      0x03A3,0x83B0,      // GREEK CAPITAL LETTER SIGMA
      0x03A4,0x83B1,      // GREEK CAPITAL LETTER TAU
      0x03A5,0x83B2,      // GREEK CAPITAL LETTER UPSILON
      0x03A6,0x83B3,      // GREEK CAPITAL LETTER PHI
      0x03A7,0x83B4,      // GREEK CAPITAL LETTER CHI
      0x03A8,0x83B5,      // GREEK CAPITAL LETTER PSI
      0x03A9,0x83B6,      // GREEK CAPITAL LETTER OMEGA
      0x03B1,0x83BF,      // GREEK SMALL LETTER ALPHA
      0x03B2,0x83C0,      // GREEK SMALL LETTER BETA
      0x03B3,0x83C1,      // GREEK SMALL LETTER GAMMA
      0x03B4,0x83C2,      // GREEK SMALL LETTER DELTA
      0x03B5,0x83C3,      // GREEK SMALL LETTER EPSILON
      0x03B6,0x83C4,      // GREEK SMALL LETTER ZETA
      0x03B7,0x83C5,      // GREEK SMALL LETTER ETA
      0x03B8,0x83C6,      // GREEK SMALL LETTER THETA
      0x03B9,0x83C7,      // GREEK SMALL LETTER IOTA
      0x03BA,0x83C8,      // GREEK SMALL LETTER KAPPA
      0x03BB,0x83C9,      // GREEK SMALL LETTER LAMDA
      0x03BC,0x83CA,      // GREEK SMALL LETTER MU
      0x03BD,0x83CB,      // GREEK SMALL LETTER NU
      0x03BE,0x83CC,      // GREEK SMALL LETTER XI
      0x03BF,0x83CD,      // GREEK SMALL LETTER OMICRON
      0x03C0,0x83CE,      // GREEK SMALL LETTER PI
      0x03C1,0x83CF,      // GREEK SMALL LETTER RHO
      0x03C3,0x83D0,      // GREEK SMALL LETTER SIGMA
      0x03C4,0x83D1,      // GREEK SMALL LETTER TAU
      0x03C5,0x83D2,      // GREEK SMALL LETTER UPSILON
      0x03C6,0x83D3,      // GREEK SMALL LETTER PHI
      0x03C7,0x83D4,      // GREEK SMALL LETTER CHI
      0x03C8,0x83D5,      // GREEK SMALL LETTER PSI
      0x03C9,0x83D6,      // GREEK SMALL LETTER OMEGA
      0x0401,0x8446,      // CYRILLIC CAPITAL LETTER IO
      0x0410,0x8440,      // CYRILLIC CAPITAL LETTER A
      0x0411,0x8441,      // CYRILLIC CAPITAL LETTER BE
      0x0412,0x8442,      // CYRILLIC CAPITAL LETTER VE
      0x0413,0x8443,      // CYRILLIC CAPITAL LETTER GHE
      0x0414,0x8444,      // CYRILLIC CAPITAL LETTER DE
      0x0415,0x8445,      // CYRILLIC CAPITAL LETTER IE
      0x0416,0x8447,      // CYRILLIC CAPITAL LETTER ZHE
      0x0417,0x8448,      // CYRILLIC CAPITAL LETTER ZE
      0x0418,0x8449,      // CYRILLIC CAPITAL LETTER I
      0x0419,0x844A,      // CYRILLIC CAPITAL LETTER SHORT I
      0x041A,0x844B,      // CYRILLIC CAPITAL LETTER KA
      0x041B,0x844C,      // CYRILLIC CAPITAL LETTER EL
      0x041C,0x844D,      // CYRILLIC CAPITAL LETTER EM
      0x041D,0x844E,      // CYRILLIC CAPITAL LETTER EN
      0x041E,0x844F,      // CYRILLIC CAPITAL LETTER O
      0x041F,0x8450,      // CYRILLIC CAPITAL LETTER PE
      0x0420,0x8451,      // CYRILLIC CAPITAL LETTER ER
      0x0421,0x8452,      // CYRILLIC CAPITAL LETTER ES
      0x0422,0x8453,      // CYRILLIC CAPITAL LETTER TE
      0x0423,0x8454,      // CYRILLIC CAPITAL LETTER U
      0x0424,0x8455,      // CYRILLIC CAPITAL LETTER EF
      0x0425,0x8456,      // CYRILLIC CAPITAL LETTER HA
      0x0426,0x8457,      // CYRILLIC CAPITAL LETTER TSE
      0x0427,0x8458,      // CYRILLIC CAPITAL LETTER CHE
      0x0428,0x8459,      // CYRILLIC CAPITAL LETTER SHA
      0x0429,0x845A,      // CYRILLIC CAPITAL LETTER SHCHA
      0x042B,0x845C,      // CYRILLIC CAPITAL LETTER YERU
      0x042C,0x845D,      // CYRILLIC CAPITAL LETTER SOFT SIGN
      0x042D,0x845E,      // CYRILLIC CAPITAL LETTER E
      0x042E,0x845F,      // CYRILLIC CAPITAL LETTER YU
      0x042F,0x8460,      // CYRILLIC CAPITAL LETTER YA
      0x0430,0x8470,      // CYRILLIC SMALL LETTER A
      0x0431,0x8471,      // CYRILLIC SMALL LETTER BE
      0x0432,0x8472,      // CYRILLIC SMALL LETTER VE
      0x0433,0x8473,      // CYRILLIC SMALL LETTER GHE
      0x0434,0x8474,      // CYRILLIC SMALL LETTER DE
      0x0435,0x8475,      // CYRILLIC SMALL LETTER IE
      0x0436,0x8477,      // CYRILLIC SMALL LETTER ZHE
      0x0437,0x8478,      // CYRILLIC SMALL LETTER ZE
      0x0438,0x8479,      // CYRILLIC SMALL LETTER I
      0x0439,0x847A,      // CYRILLIC SMALL LETTER SHORT I
      0x043A,0x847B,      // CYRILLIC SMALL LETTER KA
      0x043B,0x847C,      // CYRILLIC SMALL LETTER EL
      0x043C,0x847D,      // CYRILLIC SMALL LETTER EM
      0x043D,0x847E,      // CYRILLIC SMALL LETTER EN
      0x043E,0x8480,      // CYRILLIC SMALL LETTER O
      0x043F,0x8481,      // CYRILLIC SMALL LETTER PE
      0x0440,0x8482,      // CYRILLIC SMALL LETTER ER
      0x0441,0x8483,      // CYRILLIC SMALL LETTER ES
      0x0442,0x8484,      // CYRILLIC SMALL LETTER TE
      0x0443,0x8485,      // CYRILLIC SMALL LETTER U
      0x0444,0x8486,      // CYRILLIC SMALL LETTER EF
      0x0445,0x8487,      // CYRILLIC SMALL LETTER HA
      0x0446,0x8488,      // CYRILLIC SMALL LETTER TSE
      0x0447,0x8489,      // CYRILLIC SMALL LETTER CHE
      0x0448,0x848A,      // CYRILLIC SMALL LETTER SHA
      0x0449,0x848B,      // CYRILLIC SMALL LETTER SHCHA
      0x044A,0x848C,      // CYRILLIC SMALL LETTER HARD SIGN
      0x044B,0x848D,      // CYRILLIC SMALL LETTER YERU
      0x044C,0x848E,      // CYRILLIC SMALL LETTER SOFT SIGN
      0x044D,0x848F,      // CYRILLIC SMALL LETTER E
      0x044E,0x8490,      // CYRILLIC SMALL LETTER YU
      0x044F,0x8491,      // CYRILLIC SMALL LETTER YA
      0x0451,0x8476,      // CYRILLIC SMALL LETTER IO
      0x2010,0x815D,      // HYPHEN
      0x2014,0x815C,      // EM DASH
      0x2016,0x8161,      // DOUBLE VERTICAL LINE
      0x2018,0x8165,      // LEFT SINGLE QUOTATION MARK
      0x2019,0x8166,      // RIGHT SINGLE QUOTATION MARK
      0x201C,0x8167,      // LEFT DOUBLE QUOTATION MARK
      0x201D,0x8168,      // RIGHT DOUBLE QUOTATION MARK
      0x2020,0x81F5,      // DAGGER
      0x2021,0x81F6,      // DOUBLE DAGGER
      0x2025,0x8164,      // TWO DOT LEADER
      0x2026,0x8163,      // HORIZONTAL ELLIPSIS
      0x2030,0x81F1,      // PER MILLE SIGN
      0x2032,0x818C,      // PRIME
      0x2033,0x818D,      // DOUBLE PRIME
      0x203B,0x81A6,      // REFERENCE MARK
      0x2103,0x818E,      // DEGREE CELSIUS
      0x212B,0x81F0,      // ANGSTROM SIGN
      0x2190,0x81A9,      // LEFTWARDS ARROW
      0x2191,0x81AA,      // UPWARDS ARROW
      0x2192,0x81A8,      // RIGHTWARDS ARROW
      0x2193,0x81AB,      // DOWNWARDS ARROW
      0x21D2,0x81CB,      // RIGHTWARDS DOUBLE ARROW
      0x21D4,0x81CC,      // LEFT RIGHT DOUBLE ARROW
      0x2200,0x81CD,      // FOR ALL
      0x2202,0x81DD,      // PARTIAL DIFFERENTIAL
      0x2203,0x81CE,      // THERE EXISTS
      0x2207,0x81DE,      // NABLA
      0x2208,0x81B8,      // ELEMENT OF
      0x220B,0x81B9,      // CONTAINS AS MEMBER
      0x2212,0x817C,      // MINUS SIGN
      0x221A,0x81E3,      // SQUARE ROOT
      0x221D,0x81E5,      // PROPORTIONAL TO
      0x221E,0x8187,      // INFINITY
      0x2220,0x81DA,      // ANGLE
      0x2227,0x81C8,      // LOGICAL AND
      0x2228,0x81C9,      // LOGICAL OR
      0x2229,0x81BF,      // INTERSECTION
      0x222A,0x81BE,      // UNION
      0x222B,0x81E7,      // INTEGRAL
      0x222C,0x81E8,      // DOUBLE INTEGRAL
      0x2234,0x8188,      // THEREFORE
      0x2235,0x81E6,      // BECAUSE
      0x223D,0x81E4,      // REVERSED TILDE 
      0x2252,0x81E0,      // APPROXIMATELY EQUAL TO OR THE IMAGE OF
      0x2260,0x8182,      // NOT EQUAL TO
      0x2261,0x81DF,      // IDENTICAL TO
      0x2266,0x8185,      // LESS-THAN OVER EQUAL TO
      0x2267,0x8186,      // GREATER-THAN OVER EQUAL TO
      0x226A,0x81E1,      // MUCH LESS-THAN
      0x226B,0x81E2,      // MUCH GREATER-THAN
      0x2282,0x81BC,      // SUBSET OF
      0x2283,0x81BD,      // SUPERSET OF
      0x2286,0x81BA,      // SUBSET OF OR EQUAL TO
      0x2287,0x81BB,      // SUPERSET OF OR EQUAL TO
      0x22A5,0x81DB,      // UP TACK
      0x2312,0x81DC,      // ARC
      0x2500,0x849F,      // BOX DRAWINGS LIGHT HORIZONTAL
      0x2501,0x84AA,      // BOX DRAWINGS HEAVY HORIZONTAL
      0x2502,0x84A0,      // BOX DRAWINGS LIGHT VERTICAL
      0x2503,0x84AB,      // BOX DRAWINGS HEAVY VERTICAL
      0x250C,0x84A1,      // BOX DRAWINGS LIGHT DOWN AND RIGHT
      0x250F,0x84AC,      // BOX DRAWINGS HEAVY DOWN AND RIGHT
      0x2510,0x84A2,      // BOX DRAWINGS LIGHT DOWN AND LEFT
      0x2513,0x84AD,      // BOX DRAWINGS HEAVY DOWN AND LEFT
      0x2514,0x84A4,      // BOX DRAWINGS LIGHT UP AND RIGHT
      0x2517,0x84AF,      // BOX DRAWINGS HEAVY UP AND RIGHT
      0x2518,0x84A3,      // BOX DRAWINGS LIGHT UP AND LEFT
      0x251B,0x84AE,      // BOX DRAWINGS HEAVY UP AND LEFT
      0x251C,0x84A5,      // BOX DRAWINGS LIGHT VERTICAL AND RIGHT
      0x251D,0x84BA,      // BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
      0x2520,0x84B5,      // BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
      0x2523,0x84B0,      // BOX DRAWINGS HEAVY VERTICAL AND RIGHT
      0x2524,0x84A7,      // BOX DRAWINGS LIGHT VERTICAL AND LEFT
      0x2525,0x84BC,      // BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
      0x2528,0x84B7,      // BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
      0x252B,0x84B2,      // BOX DRAWINGS HEAVY VERTICAL AND LEFT
      0x252C,0x84A6,      // BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
      0x252F,0x84B6,      // BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
      0x2530,0x84BB,      // BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
      0x2533,0x84B1,      // BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
      0x2534,0x84A8,      // BOX DRAWINGS LIGHT UP AND HORIZONTAL
      0x2537,0x84B8,      // BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
      0x2538,0x84BD,      // BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
      0x253B,0x84B3,      // BOX DRAWINGS HEAVY UP AND HORIZONTAL
      0x253C,0x84A9,      // BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
      0x253F,0x84B9,      // BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
      0x2542,0x84BE,      // BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
      0x254B,0x84B4,      // BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
      0x25A0,0x81A1,      // BLACK SQUARE
      0x25A1,0x81A0,      // WHITE SQUARE
      0x25B2,0x81A3,      // BLACK UP-POINTING TRIANGLE
      0x25B3,0x81A2,      // WHITE UP-POINTING TRIANGLE
      0x25BC,0x81A5,      // BLACK DOWN-POINTING TRIANGLE
      0x25BD,0x81A4,      // WHITE DOWN-POINTING TRIANGLE
      0x25C6,0x819F,      // BLACK DIAMOND
      0x25C7,0x819E,      // WHITE DIAMOND
      0x25CB,0x819B,      // WHITE CIRCLE
      0x25CE,0x819D,      // BULLSEYE
      0x25CF,0x819C,      // BLACK CIRCLE
      0x25EF,0x81FC,      // LARGE CIRCLE
      0x2605,0x819A,      // BLACK STAR
      0x2606,0x8199,      // WHITE STAR
      0x2640,0x818A,      // FEMALE SIGN
      0x2642,0x8189,      // MALE SIGN
      0x266A,0x81F4,      // EIGHTH NOTE
      0x266D,0x81F3,      // MUSIC FLAT SIGN
      0x266F,0x81F2,      // MUSIC SHARP SIGN
      0x3000,0x8140,      // IDEOGRAPHIC SPACE
      0x3001,0x8141,      // IDEOGRAPHIC COMMA
      0x3002,0x8142,      // IDEOGRAPHIC FULL STOP
      0x3003,0x8156,      // DITTO MARK
      0x3005,0x8158,      // IDEOGRAPHIC ITERATION MARK
      0x3006,0x8159,      // IDEOGRAPHIC CLOSING MARK
      0x3007,0x815A,      // IDEOGRAPHIC NUMBER ZERO
      0x3008,0x8171,      // LEFT ANGLE BRACKET
      0x3009,0x8172,      // RIGHT ANGLE BRACKET
      0x300A,0x8173,      // LEFT DOUBLE ANGLE BRACKET
      0x300B,0x8174,      // RIGHT DOUBLE ANGLE BRACKET
      0x300C,0x8175,      // LEFT CORNER BRACKET
      0x300D,0x8176,      // RIGHT CORNER BRACKET
      0x300E,0x8177,      // LEFT WHITE CORNER BRACKET
      0x300F,0x8178,      // RIGHT WHITE CORNER BRACKET
      0x3010,0x8179,      // LEFT BLACK LENTICULAR BRACKET
      0x3011,0x817A,      // RIGHT BLACK LENTICULAR BRACKET
      0x3012,0x81A7,      // POSTAL MARK
      0x3013,0x81AC,      // GETA MARK
      0x3014,0x816B,      // LEFT TORTOISE SHELL BRACKET
      0x3015,0x816C,      // RIGHT TORTOISE SHELL BRACKET
      0x301C,0x8160,      // WAVE DASH
      0x3041,0x829F,      // HIRAGANA LETTER SMALL A
      0x3042,0x82A0,      // HIRAGANA LETTER A
      0x3043,0x82A1,      // HIRAGANA LETTER SMALL I
      0x3044,0x82A2,      // HIRAGANA LETTER I
      0x3045,0x82A3,      // HIRAGANA LETTER SMALL U
      0x3046,0x82A4,      // HIRAGANA LETTER U
      0x3047,0x82A5,      // HIRAGANA LETTER SMALL E
      0x3048,0x82A6,      // HIRAGANA LETTER E
      0x3049,0x82A7,      // HIRAGANA LETTER SMALL O
      0x304A,0x82A8,      // HIRAGANA LETTER O
      0x304B,0x82A9,      // HIRAGANA LETTER KA
      0x304C,0x82AA,      // HIRAGANA LETTER GA
      0x304D,0x82AB,      // HIRAGANA LETTER KI
      0x304E,0x82AC,      // HIRAGANA LETTER GI
      0x304F,0x82AD,      // HIRAGANA LETTER KU
      0x3050,0x82AE,      // HIRAGANA LETTER GU
      0x3051,0x82AF,      // HIRAGANA LETTER KE
      0x3052,0x82B0,      // HIRAGANA LETTER GE
      0x3053,0x82B1,      // HIRAGANA LETTER KO
      0x3054,0x82B2,      // HIRAGANA LETTER GO
      0x3055,0x82B3,      // HIRAGANA LETTER SA
      0x3056,0x82B4,      // HIRAGANA LETTER ZA
      0x3057,0x82B5,      // HIRAGANA LETTER SI
      0x3058,0x82B6,      // HIRAGANA LETTER ZI
      0x3059,0x82B7,      // HIRAGANA LETTER SU
      0x305A,0x82B8,      // HIRAGANA LETTER ZU
      0x305B,0x82B9,      // HIRAGANA LETTER SE
      0x305C,0x82BA,      // HIRAGANA LETTER ZE
      0x305D,0x82BB,      // HIRAGANA LETTER SO
      0x305E,0x82BC,      // HIRAGANA LETTER ZO
      0x305F,0x82BD,      // HIRAGANA LETTER TA
      0x3060,0x82BE,      // HIRAGANA LETTER DA
      0x3061,0x82BF,      // HIRAGANA LETTER TI
      0x3062,0x82C0,      // HIRAGANA LETTER DI
      0x3063,0x82C1,      // HIRAGANA LETTER SMALL TU
      0x3064,0x82C2,      // HIRAGANA LETTER TU
      0x3065,0x82C3,      // HIRAGANA LETTER DU
      0x3066,0x82C4,      // HIRAGANA LETTER TE
      0x3067,0x82C5,      // HIRAGANA LETTER DE
      0x3068,0x82C6,      // HIRAGANA LETTER TO
      0x3069,0x82C7,      // HIRAGANA LETTER DO
      0x306A,0x82C8,      // HIRAGANA LETTER NA
      0x306B,0x82C9,      // HIRAGANA LETTER NI
      0x306C,0x82CA,      // HIRAGANA LETTER NU
      0x306D,0x82CB,      // HIRAGANA LETTER NE
      0x306E,0x82CC,      // HIRAGANA LETTER NO
      0x306F,0x82CD,      // HIRAGANA LETTER HA
      0x3070,0x82CE,      // HIRAGANA LETTER BA
      0x3071,0x82CF,      // HIRAGANA LETTER PA
      0x3072,0x82D0,      // HIRAGANA LETTER HI
      0x3073,0x82D1,      // HIRAGANA LETTER BI
      0x3074,0x82D2,      // HIRAGANA LETTER PI
      0x3075,0x82D3,      // HIRAGANA LETTER HU
      0x3076,0x82D4,      // HIRAGANA LETTER BU
      0x3077,0x82D5,      // HIRAGANA LETTER PU
      0x3078,0x82D6,      // HIRAGANA LETTER HE
      0x3079,0x82D7,      // HIRAGANA LETTER BE
      0x307A,0x82D8,      // HIRAGANA LETTER PE
      0x307B,0x82D9,      // HIRAGANA LETTER HO
      0x307C,0x82DA,      // HIRAGANA LETTER BO
      0x307D,0x82DB,      // HIRAGANA LETTER PO
      0x307E,0x82DC,      // HIRAGANA LETTER MA
      0x307F,0x82DD,      // HIRAGANA LETTER MI
      0x3080,0x82DE,      // HIRAGANA LETTER MU
      0x3081,0x82DF,      // HIRAGANA LETTER ME
      0x3082,0x82E0,      // HIRAGANA LETTER MO
      0x3083,0x82E1,      // HIRAGANA LETTER SMALL YA
      0x3084,0x82E2,      // HIRAGANA LETTER YA
      0x3085,0x82E3,      // HIRAGANA LETTER SMALL YU
      0x3086,0x82E4,      // HIRAGANA LETTER YU
      0x3087,0x82E5,      // HIRAGANA LETTER SMALL YO
      0x3088,0x82E6,      // HIRAGANA LETTER YO
      0x3089,0x82E7,      // HIRAGANA LETTER RA
      0x308A,0x82E8,      // HIRAGANA LETTER RI
      0x308B,0x82E9,      // HIRAGANA LETTER RU
      0x308C,0x82EA,      // HIRAGANA LETTER RE
      0x308D,0x82EB,      // HIRAGANA LETTER RO
      0x308E,0x82EC,      // HIRAGANA LETTER SMALL WA
      0x308F,0x82ED,      // HIRAGANA LETTER WA
      0x3090,0x82EE,      // HIRAGANA LETTER WI
      0x3091,0x82EF,      // HIRAGANA LETTER WE
      0x3092,0x82F0,      // HIRAGANA LETTER WO
      0x3093,0x82F1,      // HIRAGANA LETTER N
      0x309B,0x814A,      // KATAKANA-HIRAGANA VOICED SOUND MARK
      0x309C,0x814B,      // KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
      0x309D,0x8154,      // HIRAGANA ITERATION MARK
      0x309E,0x8155,      // HIRAGANA VOICED ITERATION MARK
      0x30A1,0x8340,      // KATAKANA LETTER SMALL A
      0x30A2,0x8341,      // KATAKANA LETTER A
      0x30A3,0x8342,      // KATAKANA LETTER SMALL I
      0x30A4,0x8343,      // KATAKANA LETTER I
      0x30A5,0x8344,      // KATAKANA LETTER SMALL U
      0x30A6,0x8345,      // KATAKANA LETTER U
      0x30A7,0x8346,      // KATAKANA LETTER SMALL E
      0x30A8,0x8347,      // KATAKANA LETTER E
      0x30A9,0x8348,      // KATAKANA LETTER SMALL O
      0x30AA,0x8349,      // KATAKANA LETTER O
      0x30AB,0x834A,      // KATAKANA LETTER KA
      0x30AC,0x834B,      // KATAKANA LETTER GA
      0x30AD,0x834C,      // KATAKANA LETTER KI
      0x30AE,0x834D,      // KATAKANA LETTER GI
      0x30AF,0x834E,      // KATAKANA LETTER KU
      0x30B0,0x834F,      // KATAKANA LETTER GU
      0x30B1,0x8350,      // KATAKANA LETTER KE
      0x30B2,0x8351,      // KATAKANA LETTER GE
      0x30B3,0x8352,      // KATAKANA LETTER KO
      0x30B4,0x8353,      // KATAKANA LETTER GO
      0x30B5,0x8354,      // KATAKANA LETTER SA
      0x30B6,0x8355,      // KATAKANA LETTER ZA
      0x30B7,0x8356,      // KATAKANA LETTER SI
      0x30B8,0x8357,      // KATAKANA LETTER ZI
      0x30B9,0x8358,      // KATAKANA LETTER SU
      0x30BA,0x8359,      // KATAKANA LETTER ZU
      0x30BB,0x835A,      // KATAKANA LETTER SE
      0x30BD,0x835C,      // KATAKANA LETTER SO
      0x30BE,0x835D,      // KATAKANA LETTER ZO
      0x30BF,0x835E,      // KATAKANA LETTER TA
      0x30C0,0x835F,      // KATAKANA LETTER DA
      0x30C1,0x8360,      // KATAKANA LETTER TI
      0x30C2,0x8361,      // KATAKANA LETTER DI
      0x30C3,0x8362,      // KATAKANA LETTER SMALL TU
      0x30C4,0x8363,      // KATAKANA LETTER TU
      0x30C5,0x8364,      // KATAKANA LETTER DU
      0x30C6,0x8365,      // KATAKANA LETTER TE
      0x30C7,0x8366,      // KATAKANA LETTER DE
      0x30C8,0x8367,      // KATAKANA LETTER TO
      0x30C9,0x8368,      // KATAKANA LETTER DO
      0x30CA,0x8369,      // KATAKANA LETTER NA
      0x30CB,0x836A,      // KATAKANA LETTER NI
      0x30CC,0x836B,      // KATAKANA LETTER NU
      0x30CD,0x836C,      // KATAKANA LETTER NE
      0x30CE,0x836D,      // KATAKANA LETTER NO
      0x30CF,0x836E,      // KATAKANA LETTER HA
      0x30D0,0x836F,      // KATAKANA LETTER BA
      0x30D1,0x8370,      // KATAKANA LETTER PA
      0x30D2,0x8371,      // KATAKANA LETTER HI
      0x30D3,0x8372,      // KATAKANA LETTER BI
      0x30D4,0x8373,      // KATAKANA LETTER PI
      0x30D5,0x8374,      // KATAKANA LETTER HU
      0x30D6,0x8375,      // KATAKANA LETTER BU
      0x30D7,0x8376,      // KATAKANA LETTER PU
      0x30D8,0x8377,      // KATAKANA LETTER HE
      0x30D9,0x8378,      // KATAKANA LETTER BE
      0x30DA,0x8379,      // KATAKANA LETTER PE
      0x30DB,0x837A,      // KATAKANA LETTER HO
      0x30DC,0x837B,      // KATAKANA LETTER BO
      0x30DD,0x837C,      // KATAKANA LETTER PO
      0x30DE,0x837D,      // KATAKANA LETTER MA
      0x30DF,0x837E,      // KATAKANA LETTER MI
      0x30E0,0x8380,      // KATAKANA LETTER MU
      0x30E1,0x8381,      // KATAKANA LETTER ME
      0x30E2,0x8382,      // KATAKANA LETTER MO
      0x30E3,0x8383,      // KATAKANA LETTER SMALL YA
      0x30E4,0x8384,      // KATAKANA LETTER YA
      0x30E5,0x8385,      // KATAKANA LETTER SMALL YU
      0x30E6,0x8386,      // KATAKANA LETTER YU
      0x30E7,0x8387,      // KATAKANA LETTER SMALL YO
      0x30E8,0x8388,      // KATAKANA LETTER YO
      0x30E9,0x8389,      // KATAKANA LETTER RA
      0x30EA,0x838A,      // KATAKANA LETTER RI
      0x30EB,0x838B,      // KATAKANA LETTER RU
      0x30EC,0x838C,      // KATAKANA LETTER RE
      0x30ED,0x838D,      // KATAKANA LETTER RO
      0x30EE,0x838E,      // KATAKANA LETTER SMALL WA
      0x30EF,0x838F,      // KATAKANA LETTER WA
      0x30F0,0x8390,      // KATAKANA LETTER WI
      0x30F1,0x8391,      // KATAKANA LETTER WE
      0x30F2,0x8392,      // KATAKANA LETTER WO
      0x30F3,0x8393,      // KATAKANA LETTER N
      0x30F4,0x8394,      // KATAKANA LETTER VU
      0x30F5,0x8395,      // KATAKANA LETTER SMALL KA
      0x30F6,0x8396,      // KATAKANA LETTER SMALL KE
      0x30FB,0x8145,      // KATAKANA MIDDLE DOT
      0x30FD,0x8152,      // KATAKANA ITERATION MARK
      0x30FE,0x8153,      // KATAKANA VOICED ITERATION MARK
      0x4E00,0x88EA,      // <cjk>
      0x4E01,0x929A,      // <cjk>
      0x4E03,0x8EB5,      // <cjk>
      0x4E07,0x969C,      // <cjk>
      0x4E08,0x8FE4,      // <cjk>
      0x4E09,0x8E4F,      // <cjk>
      0x4E0A,0x8FE3,      // <cjk>
      0x4E0B,0x89BA,      // <cjk>
      0x4E0D,0x9573,      // <cjk>
      0x4E0E,0x975E,      // <cjk>
      0x4E10,0x98A0,      // <cjk>
      0x4E11,0x894E,      // <cjk>
      0x4E14,0x8A8E,      // <cjk>
      0x4E15,0x98A1,      // <cjk>
      0x4E16,0x90A2,      // <cjk>
      0x4E17,0x99C0,      // <cjk>
      0x4E18,0x8B75,      // <cjk>
      0x4E19,0x95B8,      // <cjk>
      0x4E1E,0x8FE5,      // <cjk>
      0x4E21,0x97BC,      // <cjk>
      0x4E26,0x95C0,      // <cjk>
      0x4E2A,0x98A2,      // <cjk>
      0x4E2D,0x9286,      // <cjk>
      0x4E31,0x98A3,      // <cjk>
      0x4E32,0x8BF8,      // <cjk>
      0x4E36,0x98A4,      // <cjk>
      0x4E38,0x8ADB,      // <cjk>
      0x4E39,0x924F,      // <cjk>
      0x4E3B,0x8EE5,      // <cjk>
      0x4E3C,0x98A5,      // <cjk>
      0x4E3F,0x98A6,      // <cjk>
      0x4E42,0x98A7,      // <cjk>
      0x4E43,0x9454,      // <cjk>
      0x4E45,0x8B76,      // <cjk>
      0x4E4B,0x9456,      // <cjk>
      0x4E4D,0x93E1,      // <cjk>
      0x4E4E,0x8CC1,      // <cjk>
      0x4E4F,0x9652,      // <cjk>
      0x4E55,0xE568,      // <cjk>
      0x4E56,0x98A8,      // <cjk>
      0x4E57,0x8FE6,      // <cjk>
      0x4E58,0x98A9,      // <cjk>
      0x4E59,0x89B3,      // <cjk>
      0x4E5D,0x8BE3,      // <cjk>
      0x4E5E,0x8CEE,      // <cjk>
      0x4E5F,0x96E7,      // <cjk>
      0x4E62,0x9BA4,      // <cjk>
      0x4E71,0x9790,      // <cjk>
      0x4E73,0x93FB,      // <cjk>
      0x4E7E,0x8AA3,      // <cjk>
      0x4E80,0x8B54,      // <cjk>
      0x4E82,0x98AA,      // <cjk>
      0x4E85,0x98AB,      // <cjk>
      0x4E86,0x97B9,      // <cjk>
      0x4E88,0x975C,      // <cjk>
      0x4E89,0x9188,      // <cjk>
      0x4E8A,0x98AD,      // <cjk>
      0x4E8B,0x8E96,      // <cjk>
      0x4E8C,0x93F1,      // <cjk>
      0x4E8E,0x98B0,      // <cjk>
      0x4E91,0x895D,      // <cjk>
      0x4E92,0x8CDD,      // <cjk>
      0x4E94,0x8CDC,      // <cjk>
      0x4E95,0x88E4,      // <cjk>
      0x4E98,0x986A,      // <cjk>
      0x4E99,0x9869,      // <cjk>
      0x4E9B,0x8DB1,      // <cjk>
      0x4E9C,0x889F,      // <cjk>
      0x4E9E,0x98B1,      // <cjk>
      0x4E9F,0x98B2,      // <cjk>
      0x4EA0,0x98B3,      // <cjk>
      0x4EA1,0x9653,      // <cjk>
      0x4EA2,0x98B4,      // <cjk>
      0x4EA4,0x8CF0,      // <cjk>
      0x4EA5,0x88E5,      // <cjk>
      0x4EA6,0x9692,      // <cjk>
      0x4EA8,0x8B9C,      // <cjk>
      0x4EAB,0x8B9D,      // <cjk>
      0x4EAC,0x8B9E,      // <cjk>
      0x4EAD,0x92E0,      // <cjk>
      0x4EAE,0x97BA,      // <cjk>
      0x4EB0,0x98B5,      // <cjk>
      0x4EB3,0x98B6,      // <cjk>
      0x4EB6,0x98B7,      // <cjk>
      0x4EBA,0x906C,      // <cjk>
      0x4EC0,0x8F59,      // <cjk>
      0x4EC1,0x906D,      // <cjk>
      0x4EC2,0x98BC,      // <cjk>
      0x4EC4,0x98BA,      // <cjk>
      0x4EC6,0x98BB,      // <cjk>
      0x4EC7,0x8B77,      // <cjk>
      0x4ECA,0x8DA1,      // <cjk>
      0x4ECB,0x89EE,      // <cjk>
      0x4ECD,0x98B9,      // <cjk>
      0x4ECE,0x98B8,      // <cjk>
      0x4ECF,0x95A7,      // <cjk>
      0x4ED4,0x8E65,      // <cjk>
      0x4ED5,0x8E64,      // <cjk>
      0x4ED6,0x91BC,      // <cjk>
      0x4ED7,0x98BD,      // <cjk>
      0x4ED8,0x9574,      // <cjk>
      0x4ED9,0x90E5,      // <cjk>
      0x4EDD,0x8157,      // <cjk>
      0x4EDE,0x98BE,      // <cjk>
      0x4EDF,0x98C0,      // <cjk>
      0x4EE3,0x91E3,      // <cjk>
      0x4EE4,0x97DF,      // <cjk>
      0x4EE5,0x88C8,      // <cjk>
      0x4EED,0x98BF,      // <cjk>
      0x4EEE,0x89BC,      // <cjk>
      0x4EF0,0x8BC2,      // <cjk>
      0x4EF2,0x9287,      // <cjk>
      0x4EF6,0x8C8F,      // <cjk>
      0x4EF7,0x98C1,      // <cjk>
      0x4EFB,0x9443,      // <cjk>
      0x4F01,0x8AE9,      // <cjk>
      0x4F09,0x98C2,      // <cjk>
      0x4F0A,0x88C9,      // <cjk>
      0x4F0D,0x8CDE,      // <cjk>
      0x4F0E,0x8AEA,      // <cjk>
      0x4F0F,0x959A,      // <cjk>
      0x4F10,0x94B0,      // <cjk>
      0x4F11,0x8B78,      // <cjk>
      0x4F1A,0x89EF,      // <cjk>
      0x4F1C,0x98E5,      // <cjk>
      0x4F1D,0x9360,      // <cjk>
      0x4F2F,0x948C,      // <cjk>
      0x4F30,0x98C4,      // <cjk>
      0x4F34,0x94BA,      // <cjk>
      0x4F36,0x97E0,      // <cjk>
      0x4F38,0x904C,      // <cjk>
      0x4F3A,0x8E66,      // <cjk>
      0x4F3C,0x8E97,      // <cjk>
      0x4F3D,0x89BE,      // <cjk>
      0x4F43,0x92CF,      // <cjk>
      0x4F46,0x9241,      // <cjk>
      0x4F47,0x98C8,      // <cjk>
      0x4F4D,0x88CA,      // <cjk>
      0x4F4E,0x92E1,      // <cjk>
      0x4F4F,0x8F5A,      // <cjk>
      0x4F50,0x8DB2,      // <cjk>
      0x4F51,0x9743,      // <cjk>
      0x4F53,0x91CC,      // <cjk>
      0x4F55,0x89BD,      // <cjk>
      0x4F57,0x98C7,      // <cjk>
      0x4F59,0x975D,      // <cjk>
      0x4F5A,0x98C3,      // <cjk>
      0x4F5B,0x98C5,      // <cjk>
      0x4F5C,0x8DEC,      // <cjk>
      0x4F5D,0x98C6,      // <cjk>
      0x4F5E,0x9B43,      // <cjk>
      0x4F69,0x98CE,      // <cjk>
      0x4F6F,0x98D1,      // <cjk>
      0x4F70,0x98CF,      // <cjk>
      0x4F73,0x89C0,      // <cjk>
      0x4F75,0x95B9,      // <cjk>
      0x4F76,0x98C9,      // <cjk>
      0x4F7B,0x98CD,      // <cjk>
      0x4F7C,0x8CF1,      // <cjk>
      0x4F7F,0x8E67,      // <cjk>
      0x4F83,0x8AA4,      // <cjk>
      0x4F86,0x98D2,      // <cjk>
      0x4F88,0x98CA,      // <cjk>
      0x4F8B,0x97E1,      // <cjk>
      0x4F8D,0x8E98,      // <cjk>
      0x4F8F,0x98CB,      // <cjk>
      0x4F91,0x98D0,      // <cjk>
      0x4F96,0x98D3,      // <cjk>
      0x4F98,0x98CC,      // <cjk>
      0x4F9B,0x8B9F,      // <cjk>
      0x4F9D,0x88CB,      // <cjk>
      0x4FA0,0x8BA0,      // <cjk>
      0x4FA1,0x89BF,      // <cjk>
      0x4FAB,0x9B44,      // <cjk>
      0x4FAD,0x9699,      // <cjk>
      0x4FAE,0x958E,      // <cjk>
      0x4FAF,0x8CF2,      // <cjk>
      0x4FB5,0x904E,      // <cjk>
      0x4FB6,0x97B5,      // <cjk>
      0x4FBF,0x95D6,      // <cjk>
      0x4FC2,0x8C57,      // <cjk>
      0x4FC3,0x91A3,      // <cjk>
      0x4FC4,0x89E2,      // <cjk>
      0x4FCA,0x8F72,      // <cjk>
      0x4FCE,0x98D7,      // <cjk>
      0x4FD0,0x98DC,      // <cjk>
      0x4FD1,0x98DA,      // <cjk>
      0x4FD4,0x98D5,      // <cjk>
      0x4FD7,0x91AD,      // <cjk>
      0x4FD8,0x98D8,      // <cjk>
      0x4FDA,0x98DB,      // <cjk>
      0x4FDB,0x98D9,      // <cjk>
      0x4FDD,0x95DB,      // <cjk>
      0x4FDF,0x98D6,      // <cjk>
      0x4FE1,0x904D,      // <cjk>
      0x4FE3,0x9693,      // <cjk>
      0x4FE4,0x98DD,      // <cjk>
      0x4FE5,0x98DE,      // <cjk>
      0x4FEE,0x8F43,      // <cjk>
      0x4FEF,0x98EB,      // <cjk>
      0x4FF3,0x946F,      // <cjk>
      0x4FF5,0x9555,      // <cjk>
      0x4FF6,0x98E6,      // <cjk>
      0x4FF8,0x95EE,      // <cjk>
      0x4FFA,0x89B4,      // <cjk>
      0x4FFE,0x98EA,      // <cjk>
      0x5005,0x98E4,      // <cjk>
      0x5006,0x98ED,      // <cjk>
      0x5009,0x9171,      // <cjk>
      0x500B,0x8CC2,      // <cjk>
      0x500D,0x947B,      // <cjk>
      0x500F,0xE0C5,      // <cjk>
      0x5011,0x98EC,      // <cjk>
      0x5012,0x937C,      // <cjk>
      0x5014,0x98E1,      // <cjk>
      0x5016,0x8CF4,      // <cjk>
      0x5019,0x8CF3,      // <cjk>
      0x501A,0x98DF,      // <cjk>
      0x501F,0x8ED8,      // <cjk>
      0x5021,0x98E7,      // <cjk>
      0x5023,0x95ED,      // <cjk>
      0x5024,0x926C,      // <cjk>
      0x5025,0x98E3,      // <cjk>
      0x5026,0x8C91,      // <cjk>
      0x5028,0x98E0,      // <cjk>
      0x5029,0x98E8,      // <cjk>
      0x502A,0x98E2,      // <cjk>
      0x502B,0x97CF,      // <cjk>
      0x502C,0x98E9,      // <cjk>
      0x502D,0x9860,      // <cjk>
      0x5036,0x8BE4,      // <cjk>
      0x5039,0x8C90,      // <cjk>
      0x5043,0x98EE,      // <cjk>
      0x5047,0x98EF,      // <cjk>
      0x5048,0x98F3,      // <cjk>
      0x5049,0x88CC,      // <cjk>
      0x504F,0x95CE,      // <cjk>
      0x5050,0x98F2,      // <cjk>
      0x5055,0x98F1,      // <cjk>
      0x5056,0x98F5,      // <cjk>
      0x505A,0x98F4,      // <cjk>
      0x505C,0x92E2,      // <cjk>
      0x5065,0x8C92,      // <cjk>
      0x506C,0x98F6,      // <cjk>
      0x5072,0x8EC3,      // <cjk>
      0x5074,0x91A4,      // <cjk>
      0x5075,0x92E3,      // <cjk>
      0x5076,0x8BF4,      // <cjk>
      0x5078,0x98F7,      // <cjk>
      0x507D,0x8B55,      // <cjk>
      0x5080,0x98F8,      // <cjk>
      0x5085,0x98FA,      // <cjk>
      0x508D,0x9654,      // <cjk>
      0x5091,0x8C86,      // <cjk>
      0x5098,0x8E50,      // <cjk>
      0x5099,0x94F5,      // <cjk>
      0x509A,0x98F9,      // <cjk>
      0x50AC,0x8DC3,      // <cjk>
      0x50AD,0x9762,      // <cjk>
      0x50B2,0x98FC,      // <cjk>
      0x50B3,0x9942,      // <cjk>
      0x50B4,0x98FB,      // <cjk>
      0x50B5,0x8DC2,      // <cjk>
      0x50B7,0x8F9D,      // <cjk>
      0x50BE,0x8C58,      // <cjk>
      0x50C2,0x9943,      // <cjk>
      0x50C5,0x8BCD,      // <cjk>
      0x50C9,0x9940,      // <cjk>
      0x50CA,0x9941,      // <cjk>
      0x50CD,0x93AD,      // <cjk>
      0x50CF,0x919C,      // <cjk>
      0x50D1,0x8BA1,      // <cjk>
      0x50D5,0x966C,      // <cjk>
      0x50D6,0x9944,      // <cjk>
      0x50DA,0x97BB,      // <cjk>
      0x50DE,0x9945,      // <cjk>
      0x50E3,0x9948,      // <cjk>
      0x50E5,0x9946,      // <cjk>
      0x50E7,0x916D,      // <cjk>
      0x50ED,0x9947,      // <cjk>
      0x50EE,0x9949,      // <cjk>
      0x50F5,0x994B,      // <cjk>
      0x50F9,0x994A,      // <cjk>
      0x50FB,0x95C6,      // <cjk>
      0x5100,0x8B56,      // <cjk>
      0x5101,0x994D,      // <cjk>
      0x5102,0x994E,      // <cjk>
      0x5104,0x89AD,      // <cjk>
      0x5109,0x994C,      // <cjk>
      0x5112,0x8EF2,      // <cjk>
      0x5114,0x9951,      // <cjk>
      0x5115,0x9950,      // <cjk>
      0x5116,0x994F,      // <cjk>
      0x5118,0x98D4,      // <cjk>
      0x511A,0x9952,      // <cjk>
      0x511F,0x8F9E,      // <cjk>
      0x5121,0x9953,      // <cjk>
      0x512A,0x9744,      // <cjk>
      0x5132,0x96D7,      // <cjk>
      0x5137,0x9955,      // <cjk>
      0x513A,0x9954,      // <cjk>
      0x513B,0x9957,      // <cjk>
      0x513C,0x9956,      // <cjk>
      0x513F,0x9958,      // <cjk>
      0x5140,0x9959,      // <cjk>
      0x5141,0x88F2,      // <cjk>
      0x5143,0x8CB3,      // <cjk>
      0x5144,0x8C5A,      // <cjk>
      0x5146,0x929B,      // <cjk>
      0x5147,0x8BA2,      // <cjk>
      0x5148,0x90E6,      // <cjk>
      0x5149,0x8CF5,      // <cjk>
      0x514B,0x8D8E,      // <cjk>
      0x514D,0x96C6,      // <cjk>
      0x514E,0x9365,      // <cjk>
      0x5150,0x8E99,      // <cjk>
      0x5152,0x995A,      // <cjk>
      0x5154,0x995C,      // <cjk>
      0x515A,0x937D,      // <cjk>
      0x515C,0x8A95,      // <cjk>
      0x5162,0x995D,      // <cjk>
      0x5165,0x93FC,      // <cjk>
      0x5168,0x9153,      // <cjk>
      0x5169,0x995F,      // <cjk>
      0x516A,0x9960,      // <cjk>
      0x516B,0x94AA,      // <cjk>
      0x516C,0x8CF6,      // <cjk>
      0x516D,0x985A,      // <cjk>
      0x516E,0x9961,      // <cjk>
      0x5171,0x8BA4,      // <cjk>
      0x5175,0x95BA,      // <cjk>
      0x5176,0x91B4,      // <cjk>
      0x5177,0x8BEF,      // <cjk>
      0x5178,0x9354,      // <cjk>
      0x517C,0x8C93,      // <cjk>
      0x5180,0x9962,      // <cjk>
      0x5182,0x9963,      // <cjk>
      0x5185,0x93E0,      // <cjk>
      0x5186,0x897E,      // <cjk>
      0x5189,0x9966,      // <cjk>
      0x518A,0x8DFB,      // <cjk>
      0x518C,0x9965,      // <cjk>
      0x518D,0x8DC4,      // <cjk>
      0x518F,0x9967,      // <cjk>
      0x5190,0xE3EC,      // <cjk>
      0x5191,0x9968,      // <cjk>
      0x5192,0x9660,      // <cjk>
      0x5193,0x9969,      // <cjk>
      0x5195,0x996A,      // <cjk>
      0x5196,0x996B,      // <cjk>
      0x5197,0x8FE7,      // <cjk>
      0x5199,0x8ECA,      // <cjk>
      0x51A0,0x8AA5,      // <cjk>
      0x51A2,0x996E,      // <cjk>
      0x51A4,0x996C,      // <cjk>
      0x51A5,0x96BB,      // <cjk>
      0x51A6,0x996D,      // <cjk>
      0x51A8,0x9579,      // <cjk>
      0x51A9,0x996F,      // <cjk>
      0x51AA,0x9970,      // <cjk>
      0x51AB,0x9971,      // <cjk>
      0x51AC,0x937E,      // <cjk>
      0x51B0,0x9975,      // <cjk>
      0x51B1,0x9973,      // <cjk>
      0x51B2,0x9974,      // <cjk>
      0x51B3,0x9972,      // <cjk>
      0x51B4,0x8DE1,      // <cjk>
      0x51B5,0x9976,      // <cjk>
      0x51B6,0x96E8,      // <cjk>
      0x51B7,0x97E2,      // <cjk>
      0x51BD,0x9977,      // <cjk>
      0x51C4,0x90A6,      // <cjk>
      0x51C5,0x9978,      // <cjk>
      0x51C6,0x8F79,      // <cjk>
      0x51C9,0x9979,      // <cjk>
      0x51CB,0x929C,      // <cjk>
      0x51CC,0x97BD,      // <cjk>
      0x51CD,0x9380,      // <cjk>
      0x51D6,0x99C3,      // <cjk>
      0x51DB,0x997A,      // <cjk>
      0x51DC,0xEAA3,      // <cjk>
      0x51DD,0x8BC3,      // <cjk>
      0x51E0,0x997B,      // <cjk>
      0x51E1,0x967D,      // <cjk>
      0x51E6,0x8F88,      // <cjk>
      0x51E7,0x91FA,      // <cjk>
      0x51E9,0x997D,      // <cjk>
      0x51EA,0x93E2,      // <cjk>
      0x51ED,0x997E,      // <cjk>
      0x51F0,0x9980,      // <cjk>
      0x51F1,0x8A4D,      // <cjk>
      0x51F5,0x9981,      // <cjk>
      0x51F6,0x8BA5,      // <cjk>
      0x51F8,0x93CA,      // <cjk>
      0x51F9,0x899A,      // <cjk>
      0x51FA,0x8F6F,      // <cjk>
      0x51FD,0x949F,      // <cjk>
      0x51FE,0x9982,      // <cjk>
      0x5200,0x9381,      // <cjk>
      0x5203,0x906E,      // <cjk>
      0x5204,0x9983,      // <cjk>
      0x5206,0x95AA,      // <cjk>
      0x5207,0x90D8,      // <cjk>
      0x5208,0x8AA0,      // <cjk>
      0x520A,0x8AA7,      // <cjk>
      0x520B,0x9984,      // <cjk>
      0x520E,0x9986,      // <cjk>
      0x5211,0x8C59,      // <cjk>
      0x5214,0x9985,      // <cjk>
      0x5217,0x97F1,      // <cjk>
      0x521D,0x8F89,      // <cjk>
      0x5224,0x94BB,      // <cjk>
      0x5225,0x95CA,      // <cjk>
      0x5227,0x9987,      // <cjk>
      0x5229,0x9798,      // <cjk>
      0x522A,0x9988,      // <cjk>
      0x522E,0x9989,      // <cjk>
      0x5230,0x939E,      // <cjk>
      0x5233,0x998A,      // <cjk>
      0x5236,0x90A7,      // <cjk>
      0x5237,0x8DFC,      // <cjk>
      0x5238,0x8C94,      // <cjk>
      0x5239,0x998B,      // <cjk>
      0x523A,0x8E68,      // <cjk>
      0x523B,0x8D8F,      // <cjk>
      0x5243,0x92E4,      // <cjk>
      0x5244,0x998D,      // <cjk>
      0x5247,0x91A5,      // <cjk>
      0x524A,0x8DED,      // <cjk>
      0x524B,0x998E,      // <cjk>
      0x524C,0x998F,      // <cjk>
      0x524D,0x914F,      // <cjk>
      0x524F,0x998C,      // <cjk>
      0x5254,0x9991,      // <cjk>
      0x5256,0x9655,      // <cjk>
      0x525B,0x8D84,      // <cjk>
      0x525E,0x9990,      // <cjk>
      0x5263,0x8C95,      // <cjk>
      0x5264,0x8DDC,      // <cjk>
      0x5265,0x948D,      // <cjk>
      0x5269,0x9994,      // <cjk>
      0x526A,0x9992,      // <cjk>
      0x526F,0x959B,      // <cjk>
      0x5270,0x8FE8,      // <cjk>
      0x5271,0x999B,      // <cjk>
      0x5272,0x8A84,      // <cjk>
      0x5273,0x9995,      // <cjk>
      0x5274,0x9993,      // <cjk>
      0x5275,0x916E,      // <cjk>
      0x527D,0x9997,      // <cjk>
      0x527F,0x9996,      // <cjk>
      0x5283,0x8A63,      // <cjk>
      0x5287,0x8C80,      // <cjk>
      0x5288,0x999C,      // <cjk>
      0x5289,0x97AB,      // <cjk>
      0x528D,0x9998,      // <cjk>
      0x5291,0x999D,      // <cjk>
      0x5292,0x999A,      // <cjk>
      0x5294,0x9999,      // <cjk>
      0x529B,0x97CD,      // <cjk>
      0x529F,0x8CF7,      // <cjk>
      0x52A0,0x89C1,      // <cjk>
      0x52A3,0x97F2,      // <cjk>
      0x52A9,0x8F95,      // <cjk>
      0x52AA,0x9377,      // <cjk>
      0x52AB,0x8D85,      // <cjk>
      0x52AC,0x99A0,      // <cjk>
      0x52AD,0x99A1,      // <cjk>
      0x52B1,0x97E3,      // <cjk>
      0x52B4,0x984A,      // <cjk>
      0x52B5,0x99A3,      // <cjk>
      0x52B9,0x8CF8,      // <cjk>
      0x52BC,0x99A2,      // <cjk>
      0x52BE,0x8A4E,      // <cjk>
      0x52C1,0x99A4,      // <cjk>
      0x52C3,0x9675,      // <cjk>
      0x52C5,0x92BA,      // <cjk>
      0x52C7,0x9745,      // <cjk>
      0x52C9,0x95D7,      // <cjk>
      0x52CD,0x99A5,      // <cjk>
      0x52D2,0xE8D3,      // <cjk>
      0x52D5,0x93AE,      // <cjk>
      0x52D7,0x99A6,      // <cjk>
      0x52D8,0x8AA8,      // <cjk>
      0x52D9,0x96B1,      // <cjk>
      0x52DD,0x8F9F,      // <cjk>
      0x52DE,0x99A7,      // <cjk>
      0x52DF,0x95E5,      // <cjk>
      0x52E0,0x99AB,      // <cjk>
      0x52E2,0x90A8,      // <cjk>
      0x52E3,0x99A8,      // <cjk>
      0x52E4,0x8BCE,      // <cjk>
      0x52E6,0x99A9,      // <cjk>
      0x52E7,0x8AA9,      // <cjk>
      0x52F2,0x8C4D,      // <cjk>
      0x52F3,0x99AC,      // <cjk>
      0x52F5,0x99AD,      // <cjk>
      0x52F8,0x99AE,      // <cjk>
      0x52F9,0x99AF,      // <cjk>
      0x52FA,0x8ED9,      // <cjk>
      0x52FE,0x8CF9,      // <cjk>
      0x52FF,0x96DC,      // <cjk>
      0x5301,0x96E6,      // <cjk>
      0x5302,0x93F5,      // <cjk>
      0x5305,0x95EF,      // <cjk>
      0x5306,0x99B0,      // <cjk>
      0x5308,0x99B1,      // <cjk>
      0x530D,0x99B3,      // <cjk>
      0x530F,0x99B5,      // <cjk>
      0x5310,0x99B4,      // <cjk>
      0x5315,0x99B6,      // <cjk>
      0x5316,0x89BB,      // <cjk>
      0x5317,0x966B,      // <cjk>
      0x5319,0x8DFA,      // <cjk>
      0x531A,0x99B7,      // <cjk>
      0x531D,0x9178,      // <cjk>
      0x5320,0x8FA0,      // <cjk>
      0x5321,0x8BA7,      // <cjk>
      0x5323,0x99B8,      // <cjk>
      0x532A,0x94D9,      // <cjk>
      0x532F,0x99B9,      // <cjk>
      0x5331,0x99BA,      // <cjk>
      0x5333,0x99BB,      // <cjk>
      0x5338,0x99BC,      // <cjk>
      0x5339,0x9543,      // <cjk>
      0x533A,0x8BE6,      // <cjk>
      0x533B,0x88E3,      // <cjk>
      0x533F,0x93BD,      // <cjk>
      0x5340,0x99BD,      // <cjk>
      0x5341,0x8F5C,      // <cjk>
      0x5343,0x90E7,      // <cjk>
      0x5345,0x99BF,      // <cjk>
      0x5346,0x99BE,      // <cjk>
      0x5347,0x8FA1,      // <cjk>
      0x5348,0x8CDF,      // <cjk>
      0x5349,0x99C1,      // <cjk>
      0x534A,0x94BC,      // <cjk>
      0x534D,0x99C2,      // <cjk>
      0x5351,0x94DA,      // <cjk>
      0x5352,0x91B2,      // <cjk>
      0x5353,0x91EC,      // <cjk>
      0x5354,0x8BA6,      // <cjk>
      0x5357,0x93EC,      // <cjk>
      0x5358,0x9250,      // <cjk>
      0x535A,0x948E,      // <cjk>
      0x535C,0x966D,      // <cjk>
      0x535E,0x99C4,      // <cjk>
      0x5360,0x90E8,      // <cjk>
      0x5366,0x8C54,      // <cjk>
      0x5369,0x99C5,      // <cjk>
      0x536E,0x99C6,      // <cjk>
      0x536F,0x894B,      // <cjk>
      0x5370,0x88F3,      // <cjk>
      0x5371,0x8AEB,      // <cjk>
      0x5373,0x91A6,      // <cjk>
      0x5374,0x8B70,      // <cjk>
      0x5375,0x9791,      // <cjk>
      0x5377,0x99C9,      // <cjk>
      0x5378,0x89B5,      // <cjk>
      0x537B,0x99C8,      // <cjk>
      0x537F,0x8BA8,      // <cjk>
      0x5382,0x99CA,      // <cjk>
      0x5384,0x96EF,      // <cjk>
      0x5396,0x99CB,      // <cjk>
      0x5398,0x97D0,      // <cjk>
      0x539A,0x8CFA,      // <cjk>
      0x539F,0x8CB4,      // <cjk>
      0x53A0,0x99CC,      // <cjk>
      0x53A5,0x99CE,      // <cjk>
      0x53A6,0x99CD,      // <cjk>
      0x53A8,0x907E,      // <cjk>
      0x53A9,0x8958,      // <cjk>
      0x53AD,0x897D,      // <cjk>
      0x53AE,0x99CF,      // <cjk>
      0x53B0,0x99D0,      // <cjk>
      0x53B3,0x8CB5,      // <cjk>
      0x53B6,0x99D1,      // <cjk>
      0x53BB,0x8B8E,      // <cjk>
      0x53C2,0x8E51,      // <cjk>
      0x53C3,0x99D2,      // <cjk>
      0x53C8,0x9694,      // <cjk>
      0x53C9,0x8DB3,      // <cjk>
      0x53CA,0x8B79,      // <cjk>
      0x53CB,0x9746,      // <cjk>
      0x53CC,0x916F,      // <cjk>
      0x53CD,0x94BD,      // <cjk>
      0x53CE,0x8EFB,      // <cjk>
      0x53D4,0x8F66,      // <cjk>
      0x53D6,0x8EE6,      // <cjk>
      0x53D7,0x8EF3,      // <cjk>
      0x53D9,0x8F96,      // <cjk>
      0x53DB,0x94BE,      // <cjk>
      0x53DF,0x99D5,      // <cjk>
      0x53E1,0x8962,      // <cjk>
      0x53E2,0x9170,      // <cjk>
      0x53E3,0x8CFB,      // <cjk>
      0x53E4,0x8CC3,      // <cjk>
      0x53E5,0x8BE5,      // <cjk>
      0x53E8,0x99D9,      // <cjk>
      0x53E9,0x9240,      // <cjk>
      0x53EA,0x91FC,      // <cjk>
      0x53EB,0x8BA9,      // <cjk>
      0x53EC,0x8FA2,      // <cjk>
      0x53ED,0x99DA,      // <cjk>
      0x53EE,0x99D8,      // <cjk>
      0x53EF,0x89C2,      // <cjk>
      0x53F0,0x91E4,      // <cjk>
      0x53F1,0x8EB6,      // <cjk>
      0x53F2,0x8E6A,      // <cjk>
      0x53F3,0x8945,      // <cjk>
      0x53F6,0x8A90,      // <cjk>
      0x53F7,0x8D86,      // <cjk>
      0x53F8,0x8E69,      // <cjk>
      0x53FA,0x99DB,      // <cjk>
      0x5401,0x99DC,      // <cjk>
      0x5403,0x8B68,      // <cjk>
      0x5404,0x8A65,      // <cjk>
      0x5408,0x8D87,      // <cjk>
      0x5409,0x8B67,      // <cjk>
      0x540A,0x92DD,      // <cjk>
      0x540B,0x8944,      // <cjk>
      0x540C,0x93AF,      // <cjk>
      0x540D,0x96BC,      // <cjk>
      0x540E,0x8D40,      // <cjk>
      0x540F,0x9799,      // <cjk>
      0x5410,0x9366,      // <cjk>
      0x5411,0x8CFC,      // <cjk>
      0x541B,0x8C4E,      // <cjk>
      0x541D,0x99E5,      // <cjk>
      0x541F,0x8BE1,      // <cjk>
      0x5420,0x9669,      // <cjk>
      0x5426,0x94DB,      // <cjk>
      0x5429,0x99E4,      // <cjk>
      0x542B,0x8ADC,      // <cjk>
      0x542C,0x99DF,      // <cjk>
      0x542D,0x99E0,      // <cjk>
      0x542E,0x99E2,      // <cjk>
      0x5436,0x99E3,      // <cjk>
      0x5438,0x8B7A,      // <cjk>
      0x5439,0x9081,      // <cjk>
      0x543B,0x95AB,      // <cjk>
      0x543C,0x99E1,      // <cjk>
      0x543D,0x99DD,      // <cjk>
      0x543E,0x8CE1,      // <cjk>
      0x5440,0x99DE,      // <cjk>
      0x5442,0x9843,      // <cjk>
      0x5446,0x95F0,      // <cjk>
      0x5448,0x92E6,      // <cjk>
      0x5449,0x8CE0,      // <cjk>
      0x544A,0x8D90,      // <cjk>
      0x544E,0x99E6,      // <cjk>
      0x5451,0x93DB,      // <cjk>
      0x545F,0x99EA,      // <cjk>
      0x5468,0x8EFC,      // <cjk>
      0x546A,0x8EF4,      // <cjk>
      0x5470,0x99ED,      // <cjk>
      0x5471,0x99EB,      // <cjk>
      0x5473,0x96A1,      // <cjk>
      0x5475,0x99E8,      // <cjk>
      0x5476,0x99F1,      // <cjk>
      0x5477,0x99EC,      // <cjk>
      0x547B,0x99EF,      // <cjk>
      0x547C,0x8CC4,      // <cjk>
      0x547D,0x96BD,      // <cjk>
      0x5480,0x99F0,      // <cjk>
      0x5484,0x99F2,      // <cjk>
      0x5486,0x99F4,      // <cjk>
      0x548B,0x8DEE,      // <cjk>
      0x548C,0x9861,      // <cjk>
      0x548E,0x99E9,      // <cjk>
      0x548F,0x99E7,      // <cjk>
      0x5490,0x99F3,      // <cjk>
      0x5492,0x99EE,      // <cjk>
      0x54A2,0x99F6,      // <cjk>
      0x54A4,0x9A42,      // <cjk>
      0x54A5,0x99F8,      // <cjk>
      0x54A8,0x99FC,      // <cjk>
      0x54AB,0x9A40,      // <cjk>
      0x54AC,0x99F9,      // <cjk>
      0x54AF,0x9A5D,      // <cjk>
      0x54B2,0x8DE7,      // <cjk>
      0x54B3,0x8A50,      // <cjk>
      0x54B8,0x99F7,      // <cjk>
      0x54BC,0x9A44,      // <cjk>
      0x54BD,0x88F4,      // <cjk>
      0x54BE,0x9A43,      // <cjk>
      0x54C0,0x88A3,      // <cjk>
      0x54C1,0x9569,      // <cjk>
      0x54C2,0x9A41,      // <cjk>
      0x54C4,0x99FA,      // <cjk>
      0x54C7,0x99F5,      // <cjk>
      0x54C8,0x99FB,      // <cjk>
      0x54C9,0x8DC6,      // <cjk>
      0x54D8,0x9A45,      // <cjk>
      0x54E1,0x88F5,      // <cjk>
      0x54E2,0x9A4E,      // <cjk>
      0x54E5,0x9A46,      // <cjk>
      0x54E6,0x9A47,      // <cjk>
      0x54E8,0x8FA3,      // <cjk>
      0x54E9,0x9689,      // <cjk>
      0x54ED,0x9A4C,      // <cjk>
      0x54EE,0x9A4B,      // <cjk>
      0x54F2,0x934E,      // <cjk>
      0x54FA,0x9A4D,      // <cjk>
      0x54FD,0x9A4A,      // <cjk>
      0x5504,0x8953,      // <cjk>
      0x5506,0x8DB4,      // <cjk>
      0x5507,0x904F,      // <cjk>
      0x550F,0x9A48,      // <cjk>
      0x5510,0x9382,      // <cjk>
      0x5514,0x9A49,      // <cjk>
      0x5516,0x88A0,      // <cjk>
      0x552E,0x9A53,      // <cjk>
      0x552F,0x9742,      // <cjk>
      0x5531,0x8FA5,      // <cjk>
      0x5533,0x9A59,      // <cjk>
      0x5538,0x9A58,      // <cjk>
      0x5539,0x9A4F,      // <cjk>
      0x553E,0x91C1,      // <cjk>
      0x5540,0x9A50,      // <cjk>
      0x5544,0x91ED,      // <cjk>
      0x5545,0x9A55,      // <cjk>
      0x5546,0x8FA4,      // <cjk>
      0x554C,0x9A52,      // <cjk>
      0x554F,0x96E2,      // <cjk>
      0x5556,0x9A56,      // <cjk>
      0x5557,0x9A57,      // <cjk>
      0x555C,0x9A54,      // <cjk>
      0x555D,0x9A5A,      // <cjk>
      0x5563,0x9A51,      // <cjk>
      0x557B,0x9A60,      // <cjk>
      0x557C,0x9A65,      // <cjk>
      0x557E,0x9A61,      // <cjk>
      0x5580,0x9A5C,      // <cjk>
      0x5583,0x9A66,      // <cjk>
      0x5584,0x9150,      // <cjk>
      0x5587,0x9A68,      // <cjk>
      0x5589,0x8D41,      // <cjk>
      0x558A,0x9A5E,      // <cjk>
      0x558B,0x929D,      // <cjk>
      0x5598,0x9A62,      // <cjk>
      0x559A,0x8AAB,      // <cjk>
      0x559C,0x8AEC,      // <cjk>
      0x559D,0x8A85,      // <cjk>
      0x559E,0x9A63,      // <cjk>
      0x559F,0x9A5F,      // <cjk>
      0x55A7,0x8C96,      // <cjk>
      0x55A8,0x9A69,      // <cjk>
      0x55A9,0x9A67,      // <cjk>
      0x55AA,0x9172,      // <cjk>
      0x55AB,0x8B69,      // <cjk>
      0x55AC,0x8BAA,      // <cjk>
      0x55AE,0x9A64,      // <cjk>
      0x55B0,0x8BF2,      // <cjk>
      0x55B6,0x8963,      // <cjk>
      0x55C4,0x9A6D,      // <cjk>
      0x55C5,0x9A6B,      // <cjk>
      0x55C7,0x9AA5,      // <cjk>
      0x55D4,0x9A70,      // <cjk>
      0x55DA,0x9A6A,      // <cjk>
      0x55DC,0x9A6E,      // <cjk>
      0x55DF,0x9A6C,      // <cjk>
      0x55E3,0x8E6B,      // <cjk>
      0x55E4,0x9A6F,      // <cjk>
      0x55F7,0x9A72,      // <cjk>
      0x55F9,0x9A77,      // <cjk>
      0x55FD,0x9A75,      // <cjk>
      0x55FE,0x9A74,      // <cjk>
      0x5606,0x9251,      // <cjk>
      0x5609,0x89C3,      // <cjk>
      0x5614,0x9A71,      // <cjk>
      0x5616,0x9A73,      // <cjk>
      0x5617,0x8FA6,      // <cjk>
      0x5618,0x8952,      // <cjk>
      0x561B,0x9A76,      // <cjk>
      0x5629,0x89DC,      // <cjk>
      0x562F,0x9A82,      // <cjk>
      0x5631,0x8FFA,      // <cjk>
      0x5632,0x9A7D,      // <cjk>
      0x5634,0x9A7B,      // <cjk>
      0x5636,0x9A7C,      // <cjk>
      0x5638,0x9A7E,      // <cjk>
      0x5642,0x895C,      // <cjk>
      0x564C,0x9158,      // <cjk>
      0x564E,0x9A78,      // <cjk>
      0x5650,0x9A79,      // <cjk>
      0x565B,0x8A9A,      // <cjk>
      0x5664,0x9A81,      // <cjk>
      0x5668,0x8AED,      // <cjk>
      0x566A,0x9A84,      // <cjk>
      0x566B,0x9A80,      // <cjk>
      0x566C,0x9A83,      // <cjk>
      0x5674,0x95AC,      // <cjk>
      0x5678,0x93D3,      // <cjk>
      0x567A,0x94B6,      // <cjk>
      0x5680,0x9A86,      // <cjk>
      0x5686,0x9A85,      // <cjk>
      0x5687,0x8A64,      // <cjk>
      0x568A,0x9A87,      // <cjk>
      0x568F,0x9A8A,      // <cjk>
      0x5694,0x9A89,      // <cjk>
      0x56A0,0x9A88,      // <cjk>
      0x56A2,0x9458,      // <cjk>
      0x56A5,0x9A8B,      // <cjk>
      0x56AE,0x9A8C,      // <cjk>
      0x56B4,0x9A8E,      // <cjk>
      0x56B6,0x9A8D,      // <cjk>
      0x56BC,0x9A90,      // <cjk>
      0x56C0,0x9A93,      // <cjk>
      0x56C1,0x9A91,      // <cjk>
      0x56C2,0x9A8F,      // <cjk>
      0x56C3,0x9A92,      // <cjk>
      0x56C8,0x9A94,      // <cjk>
      0x56CE,0x9A95,      // <cjk>
      0x56D1,0x9A96,      // <cjk>
      0x56D3,0x9A97,      // <cjk>
      0x56D7,0x9A98,      // <cjk>
      0x56D8,0x9964,      // <cjk>
      0x56DA,0x8EFA,      // <cjk>
      0x56DB,0x8E6C,      // <cjk>
      0x56DE,0x89F1,      // <cjk>
      0x56E0,0x88F6,      // <cjk>
      0x56E3,0x9263,      // <cjk>
      0x56EE,0x9A99,      // <cjk>
      0x56F0,0x8DA2,      // <cjk>
      0x56F2,0x88CD,      // <cjk>
      0x56F3,0x907D,      // <cjk>
      0x56F9,0x9A9A,      // <cjk>
      0x56FA,0x8CC5,      // <cjk>
      0x56FD,0x8D91,      // <cjk>
      0x56FF,0x9A9C,      // <cjk>
      0x5700,0x9A9B,      // <cjk>
      0x5703,0x95DE,      // <cjk>
      0x5704,0x9A9D,      // <cjk>
      0x5708,0x9A9F,      // <cjk>
      0x5709,0x9A9E,      // <cjk>
      0x570B,0x9AA0,      // <cjk>
      0x570D,0x9AA1,      // <cjk>
      0x570F,0x8C97,      // <cjk>
      0x5712,0x8980,      // <cjk>
      0x5713,0x9AA2,      // <cjk>
      0x5716,0x9AA4,      // <cjk>
      0x5718,0x9AA3,      // <cjk>
      0x571C,0x9AA6,      // <cjk>
      0x571F,0x9379,      // <cjk>
      0x5726,0x9AA7,      // <cjk>
      0x5727,0x88B3,      // <cjk>
      0x5728,0x8DDD,      // <cjk>
      0x572D,0x8C5C,      // <cjk>
      0x5730,0x926E,      // <cjk>
      0x5737,0x9AA8,      // <cjk>
      0x5738,0x9AA9,      // <cjk>
      0x573B,0x9AAB,      // <cjk>
      0x5740,0x9AAC,      // <cjk>
      0x5742,0x8DE2,      // <cjk>
      0x5747,0x8BCF,      // <cjk>
      0x574A,0x9656,      // <cjk>
      0x574E,0x9AAA,      // <cjk>
      0x574F,0x9AAD,      // <cjk>
      0x5750,0x8DBF,      // <cjk>
      0x5751,0x8D42,      // <cjk>
      0x5761,0x9AB1,      // <cjk>
      0x5764,0x8DA3,      // <cjk>
      0x5766,0x9252,      // <cjk>
      0x5769,0x9AAE,      // <cjk>
      0x576A,0x92D8,      // <cjk>
      0x577F,0x9AB2,      // <cjk>
      0x5782,0x9082,      // <cjk>
      0x5788,0x9AB0,      // <cjk>
      0x5789,0x9AB3,      // <cjk>
      0x578B,0x8C5E,      // <cjk>
      0x5793,0x9AB4,      // <cjk>
      0x57A0,0x9AB5,      // <cjk>
      0x57A2,0x8D43,      // <cjk>
      0x57A3,0x8A5F,      // <cjk>
      0x57A4,0x9AB7,      // <cjk>
      0x57AA,0x9AB8,      // <cjk>
      0x57B0,0x9AB9,      // <cjk>
      0x57B3,0x9AB6,      // <cjk>
      0x57C0,0x9AAF,      // <cjk>
      0x57C3,0x9ABA,      // <cjk>
      0x57C6,0x9ABB,      // <cjk>
      0x57CB,0x9684,      // <cjk>
      0x57CE,0x8FE9,      // <cjk>
      0x57D2,0x9ABD,      // <cjk>
      0x57D3,0x9ABE,      // <cjk>
      0x57D4,0x9ABC,      // <cjk>
      0x57D6,0x9AC0,      // <cjk>
      0x57DC,0x9457,      // <cjk>
      0x57DF,0x88E6,      // <cjk>
      0x57E0,0x9575,      // <cjk>
      0x57E3,0x9AC1,      // <cjk>
      0x57F4,0x8FFB,      // <cjk>
      0x57F7,0x8EB7,      // <cjk>
      0x57F9,0x947C,      // <cjk>
      0x57FA,0x8AEE,      // <cjk>
      0x57FC,0x8DE9,      // <cjk>
      0x5800,0x9678,      // <cjk>
      0x5802,0x93B0,      // <cjk>
      0x5805,0x8C98,      // <cjk>
      0x5806,0x91CD,      // <cjk>
      0x580A,0x9ABF,      // <cjk>
      0x580B,0x9AC2,      // <cjk>
      0x5815,0x91C2,      // <cjk>
      0x5819,0x9AC3,      // <cjk>
      0x581D,0x9AC4,      // <cjk>
      0x5821,0x9AC6,      // <cjk>
      0x5824,0x92E7,      // <cjk>
      0x582A,0x8AAC,      // <cjk>
      0x582F,0xEA9F,      // <cjk>
      0x5830,0x8981,      // <cjk>
      0x5831,0x95F1,      // <cjk>
      0x5834,0x8FEA,      // <cjk>
      0x5835,0x9367,      // <cjk>
      0x583A,0x8DE4,      // <cjk>
      0x583D,0x9ACC,      // <cjk>
      0x5840,0x95BB,      // <cjk>
      0x5841,0x97DB,      // <cjk>
      0x584A,0x89F2,      // <cjk>
      0x584B,0x9AC8,      // <cjk>
      0x5851,0x9159,      // <cjk>
      0x5852,0x9ACB,      // <cjk>
      0x5854,0x9383,      // <cjk>
      0x5857,0x9368,      // <cjk>
      0x5858,0x9384,      // <cjk>
      0x5859,0x94B7,      // <cjk>
      0x585A,0x92CB,      // <cjk>
      0x585E,0x8DC7,      // <cjk>
      0x5862,0x9AC7,      // <cjk>
      0x5869,0x8996,      // <cjk>
      0x586B,0x9355,      // <cjk>
      0x5870,0x9AC9,      // <cjk>
      0x5872,0x9AC5,      // <cjk>
      0x5875,0x906F,      // <cjk>
      0x5879,0x9ACD,      // <cjk>
      0x587E,0x8F6D,      // <cjk>
      0x5883,0x8BAB,      // <cjk>
      0x5885,0x9ACE,      // <cjk>
      0x5893,0x95E6,      // <cjk>
      0x5897,0x919D,      // <cjk>
      0x589C,0x92C4,      // <cjk>
      0x589F,0x9AD0,      // <cjk>
      0x58A8,0x966E,      // <cjk>
      0x58AB,0x9AD1,      // <cjk>
      0x58AE,0x9AD6,      // <cjk>
      0x58B3,0x95AD,      // <cjk>
      0x58B8,0x9AD5,      // <cjk>
      0x58B9,0x9ACF,      // <cjk>
      0x58BA,0x9AD2,      // <cjk>
      0x58BB,0x9AD4,      // <cjk>
      0x58BE,0x8DA4,      // <cjk>
      0x58C1,0x95C7,      // <cjk>
      0x58C5,0x9AD7,      // <cjk>
      0x58C7,0x9264,      // <cjk>
      0x58CA,0x89F3,      // <cjk>
      0x58CC,0x8FEB,      // <cjk>
      0x58D1,0x9AD9,      // <cjk>
      0x58D3,0x9AD8,      // <cjk>
      0x58D5,0x8D88,      // <cjk>
      0x58D7,0x9ADA,      // <cjk>
      0x58D8,0x9ADC,      // <cjk>
      0x58D9,0x9ADB,      // <cjk>
      0x58DC,0x9ADE,      // <cjk>
      0x58DE,0x9AD3,      // <cjk>
      0x58DF,0x9AE0,      // <cjk>
      0x58E4,0x9ADF,      // <cjk>
      0x58E5,0x9ADD,      // <cjk>
      0x58EB,0x8E6D,      // <cjk>
      0x58EC,0x9070,      // <cjk>
      0x58EE,0x9173,      // <cjk>
      0x58EF,0x9AE1,      // <cjk>
      0x58F0,0x90BA,      // <cjk>
      0x58F1,0x88EB,      // <cjk>
      0x58F2,0x9484,      // <cjk>
      0x58F7,0x92D9,      // <cjk>
      0x58F9,0x9AE3,      // <cjk>
      0x58FA,0x9AE2,      // <cjk>
      0x58FB,0x9AE4,      // <cjk>
      0x58FC,0x9AE5,      // <cjk>
      0x58FD,0x9AE6,      // <cjk>
      0x5902,0x9AE7,      // <cjk>
      0x5909,0x95CF,      // <cjk>
      0x590A,0x9AE8,      // <cjk>
      0x590F,0x89C4,      // <cjk>
      0x5910,0x9AE9,      // <cjk>
      0x5916,0x8A4F,      // <cjk>
      0x5918,0x99C7,      // <cjk>
      0x5919,0x8F67,      // <cjk>
      0x591A,0x91BD,      // <cjk>
      0x591B,0x9AEA,      // <cjk>
      0x591C,0x96E9,      // <cjk>
      0x5922,0x96B2,      // <cjk>
      0x5925,0x9AEC,      // <cjk>
      0x5927,0x91E5,      // <cjk>
      0x5929,0x9356,      // <cjk>
      0x592A,0x91BE,      // <cjk>
      0x592B,0x9576,      // <cjk>
      0x592C,0x9AED,      // <cjk>
      0x592D,0x9AEE,      // <cjk>
      0x592E,0x899B,      // <cjk>
      0x5931,0x8EB8,      // <cjk>
      0x5932,0x9AEF,      // <cjk>
      0x5937,0x88CE,      // <cjk>
      0x5938,0x9AF0,      // <cjk>
      0x593E,0x9AF1,      // <cjk>
      0x5944,0x8982,      // <cjk>
      0x5947,0x8AEF,      // <cjk>
      0x5948,0x93DE,      // <cjk>
      0x5949,0x95F2,      // <cjk>
      0x594E,0x9AF5,      // <cjk>
      0x594F,0x9174,      // <cjk>
      0x5950,0x9AF4,      // <cjk>
      0x5951,0x8C5F,      // <cjk>
      0x5954,0x967A,      // <cjk>
      0x5955,0x9AF3,      // <cjk>
      0x5957,0x9385,      // <cjk>
      0x5958,0x9AF7,      // <cjk>
      0x595A,0x9AF6,      // <cjk>
      0x5960,0x9AF9,      // <cjk>
      0x5962,0x9AF8,      // <cjk>
      0x5965,0x899C,      // <cjk>
      0x5967,0x9AFA,      // <cjk>
      0x5968,0x8FA7,      // <cjk>
      0x5969,0x9AFC,      // <cjk>
      0x596A,0x9244,      // <cjk>
      0x596C,0x9AFB,      // <cjk>
      0x596E,0x95B1,      // <cjk>
      0x5973,0x8F97,      // <cjk>
      0x5974,0x937A,      // <cjk>
      0x5978,0x9B40,      // <cjk>
      0x597D,0x8D44,      // <cjk>
      0x5981,0x9B41,      // <cjk>
      0x5982,0x9440,      // <cjk>
      0x5983,0x94DC,      // <cjk>
      0x5984,0x96CF,      // <cjk>
      0x598A,0x9444,      // <cjk>
      0x598D,0x9B4A,      // <cjk>
      0x5993,0x8B57,      // <cjk>
      0x5996,0x9764,      // <cjk>
      0x5999,0x96AD,      // <cjk>
      0x599B,0x9BAA,      // <cjk>
      0x599D,0x9B42,      // <cjk>
      0x59A3,0x9B45,      // <cjk>
      0x59A5,0x91C3,      // <cjk>
      0x59A8,0x9657,      // <cjk>
      0x59AC,0x9369,      // <cjk>
      0x59B2,0x9B46,      // <cjk>
      0x59B9,0x9685,      // <cjk>
      0x59BB,0x8DC8,      // <cjk>
      0x59BE,0x8FA8,      // <cjk>
      0x59C6,0x9B47,      // <cjk>
      0x59C9,0x8E6F,      // <cjk>
      0x59CB,0x8E6E,      // <cjk>
      0x59D0,0x88B7,      // <cjk>
      0x59D1,0x8CC6,      // <cjk>
      0x59D3,0x90A9,      // <cjk>
      0x59D4,0x88CF,      // <cjk>
      0x59D9,0x9B4B,      // <cjk>
      0x59DA,0x9B4C,      // <cjk>
      0x59DC,0x9B49,      // <cjk>
      0x59E5,0x8957,      // <cjk>
      0x59E6,0x8AAD,      // <cjk>
      0x59E8,0x9B48,      // <cjk>
      0x59EA,0x96C3,      // <cjk>
      0x59EB,0x9550,      // <cjk>
      0x59F6,0x88A6,      // <cjk>
      0x59FB,0x88F7,      // <cjk>
      0x59FF,0x8E70,      // <cjk>
      0x5A01,0x88D0,      // <cjk>
      0x5A03,0x88A1,      // <cjk>
      0x5A09,0x9B51,      // <cjk>
      0x5A11,0x9B4F,      // <cjk>
      0x5A18,0x96BA,      // <cjk>
      0x5A1A,0x9B52,      // <cjk>
      0x5A1C,0x9B50,      // <cjk>
      0x5A1F,0x9B4E,      // <cjk>
      0x5A20,0x9050,      // <cjk>
      0x5A25,0x9B4D,      // <cjk>
      0x5A29,0x95D8,      // <cjk>
      0x5A2F,0x8CE2,      // <cjk>
      0x5A35,0x9B56,      // <cjk>
      0x5A36,0x9B57,      // <cjk>
      0x5A3C,0x8FA9,      // <cjk>
      0x5A40,0x9B53,      // <cjk>
      0x5A41,0x984B,      // <cjk>
      0x5A46,0x946B,      // <cjk>
      0x5A49,0x9B55,      // <cjk>
      0x5A5A,0x8DA5,      // <cjk>
      0x5A62,0x9B58,      // <cjk>
      0x5A66,0x9577,      // <cjk>
      0x5A6A,0x9B59,      // <cjk>
      0x5A6C,0x9B54,      // <cjk>
      0x5A7F,0x96B9,      // <cjk>
      0x5A92,0x947D,      // <cjk>
      0x5A9A,0x9B5A,      // <cjk>
      0x5A9B,0x9551,      // <cjk>
      0x5ABD,0x9B5F,      // <cjk>
      0x5ABE,0x9B5C,      // <cjk>
      0x5AC1,0x89C5,      // <cjk>
      0x5AC2,0x9B5E,      // <cjk>
      0x5AC9,0x8EB9,      // <cjk>
      0x5ACB,0x9B5D,      // <cjk>
      0x5ACC,0x8C99,      // <cjk>
      0x5AD0,0x9B6B,      // <cjk>
      0x5AD6,0x9B64,      // <cjk>
      0x5AD7,0x9B61,      // <cjk>
      0x5AE1,0x9284,      // <cjk>
      0x5AE3,0x9B60,      // <cjk>
      0x5AE6,0x9B62,      // <cjk>
      0x5AE9,0x9B63,      // <cjk>
      0x5AFA,0x9B65,      // <cjk>
      0x5AFB,0x9B66,      // <cjk>
      0x5B09,0x8AF0,      // <cjk>
      0x5B0B,0x9B68,      // <cjk>
      0x5B0C,0x9B67,      // <cjk>
      0x5B16,0x9B69,      // <cjk>
      0x5B22,0x8FEC,      // <cjk>
      0x5B2A,0x9B6C,      // <cjk>
      0x5B2C,0x92DA,      // <cjk>
      0x5B30,0x8964,      // <cjk>
      0x5B32,0x9B6A,      // <cjk>
      0x5B36,0x9B6D,      // <cjk>
      0x5B3E,0x9B6E,      // <cjk>
      0x5B40,0x9B71,      // <cjk>
      0x5B43,0x9B6F,      // <cjk>
      0x5B45,0x9B70,      // <cjk>
      0x5B50,0x8E71,      // <cjk>
      0x5B51,0x9B72,      // <cjk>
      0x5B54,0x8D45,      // <cjk>
      0x5B55,0x9B73,      // <cjk>
      0x5B57,0x8E9A,      // <cjk>
      0x5B58,0x91B6,      // <cjk>
      0x5B5A,0x9B74,      // <cjk>
      0x5B5B,0x9B75,      // <cjk>
      0x5B5C,0x8E79,      // <cjk>
      0x5B5D,0x8D46,      // <cjk>
      0x5B5F,0x96D0,      // <cjk>
      0x5B63,0x8B47,      // <cjk>
      0x5B64,0x8CC7,      // <cjk>
      0x5B65,0x9B76,      // <cjk>
      0x5B66,0x8A77,      // <cjk>
      0x5B69,0x9B77,      // <cjk>
      0x5B6B,0x91B7,      // <cjk>
      0x5B70,0x9B78,      // <cjk>
      0x5B71,0x9BA1,      // <cjk>
      0x5B73,0x9B79,      // <cjk>
      0x5B75,0x9B7A,      // <cjk>
      0x5B78,0x9B7B,      // <cjk>
      0x5B7A,0x9B7D,      // <cjk>
      0x5B80,0x9B7E,      // <cjk>
      0x5B83,0x9B80,      // <cjk>
      0x5B85,0x91EE,      // <cjk>
      0x5B87,0x8946,      // <cjk>
      0x5B88,0x8EE7,      // <cjk>
      0x5B89,0x88C0,      // <cjk>
      0x5B8B,0x9176,      // <cjk>
      0x5B8C,0x8AAE,      // <cjk>
      0x5B8D,0x8EB3,      // <cjk>
      0x5B8F,0x8D47,      // <cjk>
      0x5B95,0x9386,      // <cjk>
      0x5B97,0x8F40,      // <cjk>
      0x5B98,0x8AAF,      // <cjk>
      0x5B99,0x9288,      // <cjk>
      0x5B9A,0x92E8,      // <cjk>
      0x5B9B,0x88B6,      // <cjk>
      0x5B9C,0x8B58,      // <cjk>
      0x5B9D,0x95F3,      // <cjk>
      0x5B9F,0x8EC0,      // <cjk>
      0x5BA2,0x8B71,      // <cjk>
      0x5BA3,0x90E9,      // <cjk>
      0x5BA4,0x8EBA,      // <cjk>
      0x5BA5,0x9747,      // <cjk>
      0x5BA6,0x9B81,      // <cjk>
      0x5BAE,0x8B7B,      // <cjk>
      0x5BB0,0x8DC9,      // <cjk>
      0x5BB3,0x8A51,      // <cjk>
      0x5BB4,0x8983,      // <cjk>
      0x5BB5,0x8FAA,      // <cjk>
      0x5BB6,0x89C6,      // <cjk>
      0x5BB8,0x9B82,      // <cjk>
      0x5BB9,0x9765,      // <cjk>
      0x5BBF,0x8F68,      // <cjk>
      0x5BC2,0x8EE2,      // <cjk>
      0x5BC3,0x9B83,      // <cjk>
      0x5BC4,0x8AF1,      // <cjk>
      0x5BC5,0x93D0,      // <cjk>
      0x5BC6,0x96A7,      // <cjk>
      0x5BC7,0x9B84,      // <cjk>
      0x5BC9,0x9B85,      // <cjk>
      0x5BCC,0x9578,      // <cjk>
      0x5BD0,0x9B87,      // <cjk>
      0x5BD2,0x8AA6,      // <cjk>
      0x5BD3,0x8BF5,      // <cjk>
      0x5BD4,0x9B86,      // <cjk>
      0x5BDB,0x8AB0,      // <cjk>
      0x5BDD,0x9051,      // <cjk>
      0x5BDE,0x9B8B,      // <cjk>
      0x5BDF,0x8E40,      // <cjk>
      0x5BE1,0x89C7,      // <cjk>
      0x5BE2,0x9B8A,      // <cjk>
      0x5BE4,0x9B88,      // <cjk>
      0x5BE5,0x9B8C,      // <cjk>
      0x5BE6,0x9B89,      // <cjk>
      0x5BE7,0x944A,      // <cjk>
      0x5BE8,0x9ECB,      // <cjk>
      0x5BE9,0x9052,      // <cjk>
      0x5BEB,0x9B8D,      // <cjk>
      0x5BEE,0x97BE,      // <cjk>
      0x5BF0,0x9B8E,      // <cjk>
      0x5BF3,0x9B90,      // <cjk>
      0x5BF5,0x929E,      // <cjk>
      0x5BF6,0x9B8F,      // <cjk>
      0x5BF8,0x90A1,      // <cjk>
      0x5BFA,0x8E9B,      // <cjk>
      0x5BFE,0x91CE,      // <cjk>
      0x5BFF,0x8EF5,      // <cjk>
      0x5C01,0x9595,      // <cjk>
      0x5C02,0x90EA,      // <cjk>
      0x5C04,0x8ECB,      // <cjk>
      0x5C05,0x9B91,      // <cjk>
      0x5C06,0x8FAB,      // <cjk>
      0x5C07,0x9B92,      // <cjk>
      0x5C08,0x9B93,      // <cjk>
      0x5C09,0x88D1,      // <cjk>
      0x5C0A,0x91B8,      // <cjk>
      0x5C0B,0x9071,      // <cjk>
      0x5C0D,0x9B94,      // <cjk>
      0x5C0E,0x93B1,      // <cjk>
      0x5C0F,0x8FAC,      // <cjk>
      0x5C11,0x8FAD,      // <cjk>
      0x5C13,0x9B95,      // <cjk>
      0x5C16,0x90EB,      // <cjk>
      0x5C1A,0x8FAE,      // <cjk>
      0x5C20,0x9B96,      // <cjk>
      0x5C22,0x9B97,      // <cjk>
      0x5C24,0x96DE,      // <cjk>
      0x5C28,0x9B98,      // <cjk>
      0x5C2D,0x8BC4,      // <cjk>
      0x5C31,0x8F41,      // <cjk>
      0x5C38,0x9B99,      // <cjk>
      0x5C39,0x9B9A,      // <cjk>
      0x5C3A,0x8EDA,      // <cjk>
      0x5C3B,0x904B,      // <cjk>
      0x5C3C,0x93F2,      // <cjk>
      0x5C3D,0x9073,      // <cjk>
      0x5C3E,0x94F6,      // <cjk>
      0x5C3F,0x9441,      // <cjk>
      0x5C40,0x8BC7,      // <cjk>
      0x5C41,0x9B9B,      // <cjk>
      0x5C45,0x8B8F,      // <cjk>
      0x5C46,0x9B9C,      // <cjk>
      0x5C48,0x8BFC,      // <cjk>
      0x5C4A,0x93CD,      // <cjk>
      0x5C4B,0x89AE,      // <cjk>
      0x5C4D,0x8E72,      // <cjk>
      0x5C4E,0x9B9D,      // <cjk>
      0x5C4F,0x9BA0,      // <cjk>
      0x5C50,0x9B9F,      // <cjk>
      0x5C51,0x8BFB,      // <cjk>
      0x5C53,0x9B9E,      // <cjk>
      0x5C55,0x9357,      // <cjk>
      0x5C5E,0x91AE,      // <cjk>
      0x5C60,0x936A,      // <cjk>
      0x5C61,0x8EC6,      // <cjk>
      0x5C64,0x9177,      // <cjk>
      0x5C65,0x979A,      // <cjk>
      0x5C6C,0x9BA2,      // <cjk>
      0x5C6E,0x9BA3,      // <cjk>
      0x5C6F,0x93D4,      // <cjk>
      0x5C71,0x8E52,      // <cjk>
      0x5C76,0x9BA5,      // <cjk>
      0x5C79,0x9BA6,      // <cjk>
      0x5C8C,0x9BA7,      // <cjk>
      0x5C90,0x8AF2,      // <cjk>
      0x5C91,0x9BA8,      // <cjk>
      0x5C94,0x9BA9,      // <cjk>
      0x5CA1,0x89AA,      // <cjk>
      0x5CA8,0x915A,      // <cjk>
      0x5CA9,0x8AE2,      // <cjk>
      0x5CAB,0x9BAB,      // <cjk>
      0x5CAC,0x96A6,      // <cjk>
      0x5CB1,0x91D0,      // <cjk>
      0x5CB3,0x8A78,      // <cjk>
      0x5CB6,0x9BAD,      // <cjk>
      0x5CB7,0x9BAF,      // <cjk>
      0x5CB8,0x8ADD,      // <cjk>
      0x5CBB,0x9BAC,      // <cjk>
      0x5CBC,0x9BAE,      // <cjk>
      0x5CBE,0x9BB1,      // <cjk>
      0x5CC5,0x9BB0,      // <cjk>
      0x5CC7,0x9BB2,      // <cjk>
      0x5CD9,0x9BB3,      // <cjk>
      0x5CE0,0x93BB,      // <cjk>
      0x5CE1,0x8BAC,      // <cjk>
      0x5CE8,0x89E3,      // <cjk>
      0x5CE9,0x9BB4,      // <cjk>
      0x5CEA,0x9BB9,      // <cjk>
      0x5CED,0x9BB7,      // <cjk>
      0x5CEF,0x95F5,      // <cjk>
      0x5CF0,0x95F4,      // <cjk>
      0x5CF6,0x9387,      // <cjk>
      0x5CFA,0x9BB6,      // <cjk>
      0x5CFB,0x8F73,      // <cjk>
      0x5CFD,0x9BB5,      // <cjk>
      0x5D07,0x9092,      // <cjk>
      0x5D0B,0x9BBA,      // <cjk>
      0x5D0E,0x8DE8,      // <cjk>
      0x5D11,0x9BC0,      // <cjk>
      0x5D14,0x9BC1,      // <cjk>
      0x5D15,0x9BBB,      // <cjk>
      0x5D16,0x8A52,      // <cjk>
      0x5D17,0x9BBC,      // <cjk>
      0x5D18,0x9BC5,      // <cjk>
      0x5D19,0x9BC4,      // <cjk>
      0x5D1A,0x9BC3,      // <cjk>
      0x5D1B,0x9BBF,      // <cjk>
      0x5D1F,0x9BBE,      // <cjk>
      0x5D22,0x9BC2,      // <cjk>
      0x5D29,0x95F6,      // <cjk>
      0x5D4B,0x9BC9,      // <cjk>
      0x5D4C,0x9BC6,      // <cjk>
      0x5D4E,0x9BC8,      // <cjk>
      0x5D50,0x9792,      // <cjk>
      0x5D52,0x9BC7,      // <cjk>
      0x5D5C,0x9BBD,      // <cjk>
      0x5D69,0x9093,      // <cjk>
      0x5D6C,0x9BCA,      // <cjk>
      0x5D6F,0x8DB5,      // <cjk>
      0x5D73,0x9BCB,      // <cjk>
      0x5D76,0x9BCC,      // <cjk>
      0x5D82,0x9BCF,      // <cjk>
      0x5D84,0x9BCE,      // <cjk>
      0x5D87,0x9BCD,      // <cjk>
      0x5D8B,0x9388,      // <cjk>
      0x5D8C,0x9BB8,      // <cjk>
      0x5D90,0x9BD5,      // <cjk>
      0x5D9D,0x9BD1,      // <cjk>
      0x5DA2,0x9BD0,      // <cjk>
      0x5DAC,0x9BD2,      // <cjk>
      0x5DAE,0x9BD3,      // <cjk>
      0x5DB7,0x9BD6,      // <cjk>
      0x5DBA,0x97E4,      // <cjk>
      0x5DBC,0x9BD7,      // <cjk>
      0x5DBD,0x9BD4,      // <cjk>
      0x5DC9,0x9BD8,      // <cjk>
      0x5DCC,0x8ADE,      // <cjk>
      0x5DCD,0x9BD9,      // <cjk>
      0x5DD2,0x9BDB,      // <cjk>
      0x5DD3,0x9BDA,      // <cjk>
      0x5DD6,0x9BDC,      // <cjk>
      0x5DDB,0x9BDD,      // <cjk>
      0x5DDD,0x90EC,      // <cjk>
      0x5DDE,0x8F42,      // <cjk>
      0x5DE1,0x8F84,      // <cjk>
      0x5DE3,0x9183,      // <cjk>
      0x5DE5,0x8D48,      // <cjk>
      0x5DE6,0x8DB6,      // <cjk>
      0x5DE7,0x8D49,      // <cjk>
      0x5DE8,0x8B90,      // <cjk>
      0x5DEB,0x9BDE,      // <cjk>
      0x5DEE,0x8DB7,      // <cjk>
      0x5DF1,0x8CC8,      // <cjk>
      0x5DF2,0x9BDF,      // <cjk>
      0x5DF3,0x96A4,      // <cjk>
      0x5DF4,0x9462,      // <cjk>
      0x5DF5,0x9BE0,      // <cjk>
      0x5DF7,0x8D4A,      // <cjk>
      0x5DFB,0x8AAA,      // <cjk>
      0x5DFD,0x9246,      // <cjk>
      0x5DFE,0x8BD0,      // <cjk>
      0x5E02,0x8E73,      // <cjk>
      0x5E03,0x957A,      // <cjk>
      0x5E06,0x94BF,      // <cjk>
      0x5E0B,0x9BE1,      // <cjk>
      0x5E0C,0x8AF3,      // <cjk>
      0x5E11,0x9BE4,      // <cjk>
      0x5E16,0x929F,      // <cjk>
      0x5E19,0x9BE3,      // <cjk>
      0x5E1A,0x9BE2,      // <cjk>
      0x5E1B,0x9BE5,      // <cjk>
      0x5E1D,0x92E9,      // <cjk>
      0x5E25,0x9083,      // <cjk>
      0x5E2B,0x8E74,      // <cjk>
      0x5E2D,0x90C8,      // <cjk>
      0x5E2F,0x91D1,      // <cjk>
      0x5E30,0x8B41,      // <cjk>
      0x5E33,0x92A0,      // <cjk>
      0x5E36,0x9BE6,      // <cjk>
      0x5E37,0x9BE7,      // <cjk>
      0x5E38,0x8FED,      // <cjk>
      0x5E3D,0x9658,      // <cjk>
      0x5E40,0x9BEA,      // <cjk>
      0x5E43,0x9BE9,      // <cjk>
      0x5E44,0x9BE8,      // <cjk>
      0x5E45,0x959D,      // <cjk>
      0x5E47,0x9BF1,      // <cjk>
      0x5E4C,0x9679,      // <cjk>
      0x5E4E,0x9BEB,      // <cjk>
      0x5E54,0x9BED,      // <cjk>
      0x5E55,0x968B,      // <cjk>
      0x5E57,0x9BEC,      // <cjk>
      0x5E5F,0x9BEE,      // <cjk>
      0x5E61,0x94A6,      // <cjk>
      0x5E62,0x9BEF,      // <cjk>
      0x5E63,0x95BC,      // <cjk>
      0x5E64,0x9BF0,      // <cjk>
      0x5E72,0x8AB1,      // <cjk>
      0x5E73,0x95BD,      // <cjk>
      0x5E74,0x944E,      // <cjk>
      0x5E75,0x9BF2,      // <cjk>
      0x5E76,0x9BF3,      // <cjk>
      0x5E78,0x8D4B,      // <cjk>
      0x5E79,0x8AB2,      // <cjk>
      0x5E7A,0x9BF4,      // <cjk>
      0x5E7B,0x8CB6,      // <cjk>
      0x5E7C,0x9763,      // <cjk>
      0x5E7D,0x9748,      // <cjk>
      0x5E7E,0x8AF4,      // <cjk>
      0x5E7F,0x9BF6,      // <cjk>
      0x5E81,0x92A1,      // <cjk>
      0x5E83,0x8D4C,      // <cjk>
      0x5E84,0x8FAF,      // <cjk>
      0x5E87,0x94DD,      // <cjk>
      0x5E8A,0x8FB0,      // <cjk>
      0x5E8F,0x8F98,      // <cjk>
      0x5E95,0x92EA,      // <cjk>
      0x5E96,0x95F7,      // <cjk>
      0x5E97,0x9358,      // <cjk>
      0x5E9A,0x8D4D,      // <cjk>
      0x5E9C,0x957B,      // <cjk>
      0x5EA0,0x9BF7,      // <cjk>
      0x5EA6,0x9378,      // <cjk>
      0x5EA7,0x8DC0,      // <cjk>
      0x5EAB,0x8CC9,      // <cjk>
      0x5EAD,0x92EB,      // <cjk>
      0x5EB5,0x88C1,      // <cjk>
      0x5EB6,0x8F8E,      // <cjk>
      0x5EB7,0x8D4E,      // <cjk>
      0x5EB8,0x9766,      // <cjk>
      0x5EC1,0x9BF8,      // <cjk>
      0x5EC2,0x9BF9,      // <cjk>
      0x5EC3,0x9470,      // <cjk>
      0x5EC8,0x9BFA,      // <cjk>
      0x5EC9,0x97F5,      // <cjk>
      0x5ECA,0x984C,      // <cjk>
      0x5ECF,0x9BFC,      // <cjk>
      0x5ED0,0x9BFB,      // <cjk>
      0x5ED3,0x8A66,      // <cjk>
      0x5ED6,0x9C40,      // <cjk>
      0x5EDA,0x9C43,      // <cjk>
      0x5EDB,0x9C44,      // <cjk>
      0x5EDD,0x9C42,      // <cjk>
      0x5EDF,0x955F,      // <cjk>
      0x5EE0,0x8FB1,      // <cjk>
      0x5EE1,0x9C46,      // <cjk>
      0x5EE2,0x9C45,      // <cjk>
      0x5EE3,0x9C41,      // <cjk>
      0x5EE8,0x9C47,      // <cjk>
      0x5EE9,0x9C48,      // <cjk>
      0x5EEC,0x9C49,      // <cjk>
      0x5EF0,0x9C4C,      // <cjk>
      0x5EF1,0x9C4A,      // <cjk>
      0x5EF3,0x9C4B,      // <cjk>
      0x5EF4,0x9C4D,      // <cjk>
      0x5EF6,0x8984,      // <cjk>
      0x5EF7,0x92EC,      // <cjk>
      0x5EF8,0x9C4E,      // <cjk>
      0x5EFA,0x8C9A,      // <cjk>
      0x5EFB,0x89F4,      // <cjk>
      0x5EFC,0x9455,      // <cjk>
      0x5EFE,0x9C4F,      // <cjk>
      0x5EFF,0x93F9,      // <cjk>
      0x5F01,0x95D9,      // <cjk>
      0x5F03,0x9C50,      // <cjk>
      0x5F04,0x984D,      // <cjk>
      0x5F09,0x9C51,      // <cjk>
      0x5F0A,0x95BE,      // <cjk>
      0x5F0B,0x9C54,      // <cjk>
      0x5F0C,0x989F,      // <cjk>
      0x5F0D,0x98AF,      // <cjk>
      0x5F0F,0x8EAE,      // <cjk>
      0x5F10,0x93F3,      // <cjk>
      0x5F11,0x9C55,      // <cjk>
      0x5F13,0x8B7C,      // <cjk>
      0x5F14,0x92A2,      // <cjk>
      0x5F15,0x88F8,      // <cjk>
      0x5F16,0x9C56,      // <cjk>
      0x5F17,0x95A4,      // <cjk>
      0x5F18,0x8D4F,      // <cjk>
      0x5F1B,0x926F,      // <cjk>
      0x5F1F,0x92ED,      // <cjk>
      0x5F25,0x96ED,      // <cjk>
      0x5F26,0x8CB7,      // <cjk>
      0x5F27,0x8CCA,      // <cjk>
      0x5F29,0x9C57,      // <cjk>
      0x5F2D,0x9C58,      // <cjk>
      0x5F2F,0x9C5E,      // <cjk>
      0x5F31,0x8EE3,      // <cjk>
      0x5F35,0x92A3,      // <cjk>
      0x5F37,0x8BAD,      // <cjk>
      0x5F38,0x9C59,      // <cjk>
      0x5F3C,0x954A,      // <cjk>
      0x5F3E,0x9265,      // <cjk>
      0x5F41,0x9C5A,      // <cjk>
      0x5F4A,0x8BAE,      // <cjk>
      0x5F4C,0x9C5C,      // <cjk>
      0x5F4E,0x9C5D,      // <cjk>
      0x5F51,0x9C5F,      // <cjk>
      0x5F53,0x9396,      // <cjk>
      0x5F56,0x9C60,      // <cjk>
      0x5F57,0x9C61,      // <cjk>
      0x5F59,0x9C62,      // <cjk>
      0x5F5C,0x9C53,      // <cjk>
      0x5F5D,0x9C52,      // <cjk>
      0x5F61,0x9C63,      // <cjk>
      0x5F62,0x8C60,      // <cjk>
      0x5F66,0x9546,      // <cjk>
      0x5F69,0x8DCA,      // <cjk>
      0x5F6A,0x9556,      // <cjk>
      0x5F6B,0x92A4,      // <cjk>
      0x5F6C,0x956A,      // <cjk>
      0x5F6D,0x9C64,      // <cjk>
      0x5F70,0x8FB2,      // <cjk>
      0x5F71,0x8965,      // <cjk>
      0x5F73,0x9C65,      // <cjk>
      0x5F77,0x9C66,      // <cjk>
      0x5F79,0x96F0,      // <cjk>
      0x5F7C,0x94DE,      // <cjk>
      0x5F7F,0x9C69,      // <cjk>
      0x5F80,0x899D,      // <cjk>
      0x5F81,0x90AA,      // <cjk>
      0x5F82,0x9C68,      // <cjk>
      0x5F83,0x9C67,      // <cjk>
      0x5F84,0x8C61,      // <cjk>
      0x5F85,0x91D2,      // <cjk>
      0x5F87,0x9C6D,      // <cjk>
      0x5F88,0x9C6B,      // <cjk>
      0x5F8A,0x9C6A,      // <cjk>
      0x5F8B,0x97A5,      // <cjk>
      0x5F8C,0x8CE3,      // <cjk>
      0x5F90,0x8F99,      // <cjk>
      0x5F91,0x9C6C,      // <cjk>
      0x5F92,0x936B,      // <cjk>
      0x5F93,0x8F5D,      // <cjk>
      0x5F97,0x93BE,      // <cjk>
      0x5F98,0x9C70,      // <cjk>
      0x5F99,0x9C6F,      // <cjk>
      0x5F9E,0x9C6E,      // <cjk>
      0x5FA0,0x9C71,      // <cjk>
      0x5FA1,0x8CE4,      // <cjk>
      0x5FA8,0x9C72,      // <cjk>
      0x5FA9,0x959C,      // <cjk>
      0x5FAA,0x8F7A,      // <cjk>
      0x5FAD,0x9C73,      // <cjk>
      0x5FAE,0x94F7,      // <cjk>
      0x5FB3,0x93BF,      // <cjk>
      0x5FB4,0x92A5,      // <cjk>
      0x5FB9,0x934F,      // <cjk>
      0x5FBC,0x9C74,      // <cjk>
      0x5FBD,0x8B4A,      // <cjk>
      0x5FC3,0x9053,      // <cjk>
      0x5FC5,0x954B,      // <cjk>
      0x5FCC,0x8AF5,      // <cjk>
      0x5FCD,0x9445,      // <cjk>
      0x5FD6,0x9C75,      // <cjk>
      0x5FD7,0x8E75,      // <cjk>
      0x5FD8,0x9659,      // <cjk>
      0x5FD9,0x965A,      // <cjk>
      0x5FDC,0x899E,      // <cjk>
      0x5FDD,0x9C7A,      // <cjk>
      0x5FE0,0x9289,      // <cjk>
      0x5FE4,0x9C77,      // <cjk>
      0x5FEB,0x89F5,      // <cjk>
      0x5FF0,0x9CAB,      // <cjk>
      0x5FF1,0x9C79,      // <cjk>
      0x5FF5,0x944F,      // <cjk>
      0x5FF8,0x9C78,      // <cjk>
      0x5FFB,0x9C76,      // <cjk>
      0x5FFD,0x8D9A,      // <cjk>
      0x5FFF,0x9C7C,      // <cjk>
      0x600E,0x9C83,      // <cjk>
      0x600F,0x9C89,      // <cjk>
      0x6010,0x9C81,      // <cjk>
      0x6012,0x937B,      // <cjk>
      0x6015,0x9C86,      // <cjk>
      0x6016,0x957C,      // <cjk>
      0x6019,0x9C80,      // <cjk>
      0x601B,0x9C85,      // <cjk>
      0x601C,0x97E5,      // <cjk>
      0x601D,0x8E76,      // <cjk>
      0x6020,0x91D3,      // <cjk>
      0x6021,0x9C7D,      // <cjk>
      0x6025,0x8B7D,      // <cjk>
      0x6026,0x9C88,      // <cjk>
      0x6027,0x90AB,      // <cjk>
      0x6028,0x8985,      // <cjk>
      0x6029,0x9C82,      // <cjk>
      0x602A,0x89F6,      // <cjk>
      0x602B,0x9C87,      // <cjk>
      0x602F,0x8BAF,      // <cjk>
      0x6031,0x9C84,      // <cjk>
      0x603A,0x9C8A,      // <cjk>
      0x6041,0x9C8C,      // <cjk>
      0x6042,0x9C96,      // <cjk>
      0x6043,0x9C94,      // <cjk>
      0x6046,0x9C91,      // <cjk>
      0x604A,0x9C90,      // <cjk>
      0x604B,0x97F6,      // <cjk>
      0x604D,0x9C92,      // <cjk>
      0x6050,0x8BB0,      // <cjk>
      0x6052,0x8D50,      // <cjk>
      0x6055,0x8F9A,      // <cjk>
      0x6059,0x9C99,      // <cjk>
      0x605A,0x9C8B,      // <cjk>
      0x605F,0x9C8F,      // <cjk>
      0x6060,0x9C7E,      // <cjk>
      0x6062,0x89F8,      // <cjk>
      0x6063,0x9C93,      // <cjk>
      0x6064,0x9C95,      // <cjk>
      0x6065,0x9270,      // <cjk>
      0x6068,0x8DA6,      // <cjk>
      0x6069,0x89B6,      // <cjk>
      0x606A,0x9C8D,      // <cjk>
      0x606B,0x9C98,      // <cjk>
      0x606C,0x9C97,      // <cjk>
      0x606D,0x8BB1,      // <cjk>
      0x606F,0x91A7,      // <cjk>
      0x6070,0x8A86,      // <cjk>
      0x6075,0x8C62,      // <cjk>
      0x6077,0x9C8E,      // <cjk>
      0x6081,0x9C9A,      // <cjk>
      0x6083,0x9C9D,      // <cjk>
      0x6084,0x9C9F,      // <cjk>
      0x6089,0x8EBB,      // <cjk>
      0x608B,0x9CA5,      // <cjk>
      0x608C,0x92EE,      // <cjk>
      0x608D,0x9C9B,      // <cjk>
      0x6092,0x9CA3,      // <cjk>
      0x6094,0x89F7,      // <cjk>
      0x6096,0x9CA1,      // <cjk>
      0x6097,0x9CA2,      // <cjk>
      0x609A,0x9C9E,      // <cjk>
      0x609B,0x9CA0,      // <cjk>
      0x609F,0x8CE5,      // <cjk>
      0x60A0,0x9749,      // <cjk>
      0x60A3,0x8AB3,      // <cjk>
      0x60A6,0x8978,      // <cjk>
      0x60A7,0x9CA4,      // <cjk>
      0x60A9,0x9459,      // <cjk>
      0x60AA,0x88AB,      // <cjk>
      0x60B2,0x94DF,      // <cjk>
      0x60B3,0x9C7B,      // <cjk>
      0x60B4,0x9CAA,      // <cjk>
      0x60B5,0x9CAE,      // <cjk>
      0x60B6,0x96E3,      // <cjk>
      0x60B8,0x9CA7,      // <cjk>
      0x60BC,0x9389,      // <cjk>
      0x60BD,0x9CAC,      // <cjk>
      0x60C5,0x8FEE,      // <cjk>
      0x60C6,0x9CAD,      // <cjk>
      0x60C7,0x93D5,      // <cjk>
      0x60D1,0x9866,      // <cjk>
      0x60D3,0x9CA9,      // <cjk>
      0x60D8,0x9CAF,      // <cjk>
      0x60DA,0x8D9B,      // <cjk>
      0x60DC,0x90C9,      // <cjk>
      0x60DF,0x88D2,      // <cjk>
      0x60E0,0x9CA8,      // <cjk>
      0x60E1,0x9CA6,      // <cjk>
      0x60E3,0x9179,      // <cjk>
      0x60E7,0x9C9C,      // <cjk>
      0x60E8,0x8E53,      // <cjk>
      0x60F0,0x91C4,      // <cjk>
      0x60F1,0x9CBB,      // <cjk>
      0x60F3,0x917A,      // <cjk>
      0x60F4,0x9CB6,      // <cjk>
      0x60F6,0x9CB3,      // <cjk>
      0x60F7,0x9CB4,      // <cjk>
      0x60F9,0x8EE4,      // <cjk>
      0x60FA,0x9CB7,      // <cjk>
      0x60FB,0x9CBA,      // <cjk>
      0x6100,0x9CB5,      // <cjk>
      0x6101,0x8F44,      // <cjk>
      0x6103,0x9CB8,      // <cjk>
      0x6106,0x9CB2,      // <cjk>
      0x6108,0x96FA,      // <cjk>
      0x6109,0x96F9,      // <cjk>
      0x610D,0x9CBC,      // <cjk>
      0x610E,0x9CBD,      // <cjk>
      0x610F,0x88D3,      // <cjk>
      0x6115,0x9CB1,      // <cjk>
      0x611A,0x8BF0,      // <cjk>
      0x611B,0x88A4,      // <cjk>
      0x611F,0x8AB4,      // <cjk>
      0x6121,0x9CB9,      // <cjk>
      0x6127,0x9CC1,      // <cjk>
      0x6128,0x9CC0,      // <cjk>
      0x612C,0x9CC5,      // <cjk>
      0x6134,0x9CC6,      // <cjk>
      0x613C,0x9CC4,      // <cjk>
      0x613D,0x9CC7,      // <cjk>
      0x613E,0x9CBF,      // <cjk>
      0x613F,0x9CC3,      // <cjk>
      0x6142,0x9CC8,      // <cjk>
      0x6144,0x9CC9,      // <cjk>
      0x6147,0x9CBE,      // <cjk>
      0x6148,0x8E9C,      // <cjk>
      0x614A,0x9CC2,      // <cjk>
      0x614B,0x91D4,      // <cjk>
      0x614C,0x8D51,      // <cjk>
      0x614D,0x9CB0,      // <cjk>
      0x614E,0x9054,      // <cjk>
      0x6153,0x9CD6,      // <cjk>
      0x6155,0x95E7,      // <cjk>
      0x6158,0x9CCC,      // <cjk>
      0x6159,0x9CCD,      // <cjk>
      0x615A,0x9CCE,      // <cjk>
      0x615D,0x9CD5,      // <cjk>
      0x615F,0x9CD4,      // <cjk>
      0x6162,0x969D,      // <cjk>
      0x6163,0x8AB5,      // <cjk>
      0x6165,0x9CD2,      // <cjk>
      0x6167,0x8C64,      // <cjk>
      0x6168,0x8A53,      // <cjk>
      0x616B,0x9CCF,      // <cjk>
      0x616E,0x97B6,      // <cjk>
      0x616F,0x9CD1,      // <cjk>
      0x6170,0x88D4,      // <cjk>
      0x6171,0x9CD3,      // <cjk>
      0x6173,0x9CCA,      // <cjk>
      0x6174,0x9CD0,      // <cjk>
      0x6175,0x9CD7,      // <cjk>
      0x6176,0x8C63,      // <cjk>
      0x6177,0x9CCB,      // <cjk>
      0x617E,0x977C,      // <cjk>
      0x6182,0x974A,      // <cjk>
      0x6187,0x9CDA,      // <cjk>
      0x618A,0x9CDE,      // <cjk>
      0x618E,0x919E,      // <cjk>
      0x6190,0x97F7,      // <cjk>
      0x6191,0x9CDF,      // <cjk>
      0x6194,0x9CDC,      // <cjk>
      0x6196,0x9CD9,      // <cjk>
      0x6199,0x9CD8,      // <cjk>
      0x619A,0x9CDD,      // <cjk>
      0x61A4,0x95AE,      // <cjk>
      0x61A7,0x93B2,      // <cjk>
      0x61A9,0x8C65,      // <cjk>
      0x61AB,0x9CE0,      // <cjk>
      0x61AC,0x9CDB,      // <cjk>
      0x61AE,0x9CE1,      // <cjk>
      0x61B2,0x8C9B,      // <cjk>
      0x61B6,0x89AF,      // <cjk>
      0x61BA,0x9CE9,      // <cjk>
      0x61BE,0x8AB6,      // <cjk>
      0x61C3,0x9CE7,      // <cjk>
      0x61C6,0x9CE8,      // <cjk>
      0x61C7,0x8DA7,      // <cjk>
      0x61C8,0x9CE6,      // <cjk>
      0x61C9,0x9CE4,      // <cjk>
      0x61CA,0x9CE3,      // <cjk>
      0x61CB,0x9CEA,      // <cjk>
      0x61CC,0x9CE2,      // <cjk>
      0x61CD,0x9CEC,      // <cjk>
      0x61D0,0x89F9,      // <cjk>
      0x61E3,0x9CEE,      // <cjk>
      0x61E6,0x9CED,      // <cjk>
      0x61F2,0x92A6,      // <cjk>
      0x61F4,0x9CF1,      // <cjk>
      0x61F6,0x9CEF,      // <cjk>
      0x61F7,0x9CE5,      // <cjk>
      0x61F8,0x8C9C,      // <cjk>
      0x61FA,0x9CF0,      // <cjk>
      0x61FC,0x9CF4,      // <cjk>
      0x61FD,0x9CF3,      // <cjk>
      0x61FE,0x9CF5,      // <cjk>
      0x61FF,0x9CF2,      // <cjk>
      0x6200,0x9CF6,      // <cjk>
      0x6208,0x9CF7,      // <cjk>
      0x6209,0x9CF8,      // <cjk>
      0x620A,0x95E8,      // <cjk>
      0x620C,0x9CFA,      // <cjk>
      0x620D,0x9CF9,      // <cjk>
      0x620E,0x8F5E,      // <cjk>
      0x6210,0x90AC,      // <cjk>
      0x6211,0x89E4,      // <cjk>
      0x6212,0x89FA,      // <cjk>
      0x6214,0x9CFB,      // <cjk>
      0x6216,0x88BD,      // <cjk>
      0x621A,0x90CA,      // <cjk>
      0x621B,0x9CFC,      // <cjk>
      0x621D,0xE6C1,      // <cjk>
      0x621E,0x9D40,      // <cjk>
      0x621F,0x8C81,      // <cjk>
      0x6221,0x9D41,      // <cjk>
      0x6226,0x90ED,      // <cjk>
      0x622A,0x9D42,      // <cjk>
      0x622E,0x9D43,      // <cjk>
      0x622F,0x8B59,      // <cjk>
      0x6230,0x9D44,      // <cjk>
      0x6232,0x9D45,      // <cjk>
      0x6233,0x9D46,      // <cjk>
      0x6234,0x91D5,      // <cjk>
      0x6238,0x8CCB,      // <cjk>
      0x623B,0x96DF,      // <cjk>
      0x6240,0x8F8A,      // <cjk>
      0x6241,0x9D47,      // <cjk>
      0x6247,0x90EE,      // <cjk>
      0x6248,0xE7BB,      // <cjk>
      0x6249,0x94E0,      // <cjk>
      0x624B,0x8EE8,      // <cjk>
      0x624D,0x8DCB,      // <cjk>
      0x624E,0x9D48,      // <cjk>
      0x6253,0x91C5,      // <cjk>
      0x6255,0x95A5,      // <cjk>
      0x6258,0x91EF,      // <cjk>
      0x625B,0x9D4B,      // <cjk>
      0x625E,0x9D49,      // <cjk>
      0x6260,0x9D4C,      // <cjk>
      0x6263,0x9D4A,      // <cjk>
      0x6268,0x9D4D,      // <cjk>
      0x626E,0x95AF,      // <cjk>
      0x6271,0x88B5,      // <cjk>
      0x6276,0x957D,      // <cjk>
      0x6279,0x94E1,      // <cjk>
      0x627C,0x9D4E,      // <cjk>
      0x627E,0x9D51,      // <cjk>
      0x627F,0x8FB3,      // <cjk>
      0x6280,0x8B5A,      // <cjk>
      0x6282,0x9D4F,      // <cjk>
      0x6283,0x9D56,      // <cjk>
      0x6284,0x8FB4,      // <cjk>
      0x6289,0x9D50,      // <cjk>
      0x628A,0x9463,      // <cjk>
      0x6291,0x977D,      // <cjk>
      0x6292,0x9D52,      // <cjk>
      0x6293,0x9D53,      // <cjk>
      0x6294,0x9D57,      // <cjk>
      0x6295,0x938A,      // <cjk>
      0x6296,0x9D54,      // <cjk>
      0x6297,0x8D52,      // <cjk>
      0x6298,0x90DC,      // <cjk>
      0x629B,0x9D65,      // <cjk>
      0x629C,0x94B2,      // <cjk>
      0x629E,0x91F0,      // <cjk>
      0x62AB,0x94E2,      // <cjk>
      0x62AC,0x9DAB,      // <cjk>
      0x62B1,0x95F8,      // <cjk>
      0x62B5,0x92EF,      // <cjk>
      0x62B9,0x9695,      // <cjk>
      0x62BB,0x9D5A,      // <cjk>
      0x62BC,0x899F,      // <cjk>
      0x62BD,0x928A,      // <cjk>
      0x62C2,0x9D63,      // <cjk>
      0x62C5,0x9253,      // <cjk>
      0x62C6,0x9D5D,      // <cjk>
      0x62C7,0x9D64,      // <cjk>
      0x62C8,0x9D5F,      // <cjk>
      0x62C9,0x9D66,      // <cjk>
      0x62CA,0x9D62,      // <cjk>
      0x62CC,0x9D61,      // <cjk>
      0x62CD,0x948F,      // <cjk>
      0x62D0,0x89FB,      // <cjk>
      0x62D1,0x9D59,      // <cjk>
      0x62D2,0x8B91,      // <cjk>
      0x62D3,0x91F1,      // <cjk>
      0x62D4,0x9D55,      // <cjk>
      0x62D7,0x9D58,      // <cjk>
      0x62D8,0x8D53,      // <cjk>
      0x62D9,0x90D9,      // <cjk>
      0x62DB,0x8FB5,      // <cjk>
      0x62DC,0x9D60,      // <cjk>
      0x62DD,0x9471,      // <cjk>
      0x62E0,0x8B92,      // <cjk>
      0x62E1,0x8A67,      // <cjk>
      0x62EC,0x8A87,      // <cjk>
      0x62ED,0x9040,      // <cjk>
      0x62EE,0x9D68,      // <cjk>
      0x62EF,0x9D6D,      // <cjk>
      0x62F1,0x9D69,      // <cjk>
      0x62F3,0x8C9D,      // <cjk>
      0x62F5,0x9D6E,      // <cjk>
      0x62F6,0x8E41,      // <cjk>
      0x62F7,0x8D89,      // <cjk>
      0x62FE,0x8F45,      // <cjk>
      0x62FF,0x9D5C,      // <cjk>
      0x6301,0x8E9D,      // <cjk>
      0x6302,0x9D6B,      // <cjk>
      0x6307,0x8E77,      // <cjk>
      0x6308,0x9D6C,      // <cjk>
      0x6309,0x88C2,      // <cjk>
      0x630C,0x9D67,      // <cjk>
      0x6311,0x92A7,      // <cjk>
      0x6319,0x8B93,      // <cjk>
      0x631F,0x8BB2,      // <cjk>
      0x6327,0x9D6A,      // <cjk>
      0x6328,0x88A5,      // <cjk>
      0x632B,0x8DC1,      // <cjk>
      0x632F,0x9055,      // <cjk>
      0x633A,0x92F0,      // <cjk>
      0x633D,0x94D2,      // <cjk>
      0x633E,0x9D70,      // <cjk>
      0x633F,0x917D,      // <cjk>
      0x6349,0x91A8,      // <cjk>
      0x634C,0x8E4A,      // <cjk>
      0x634D,0x9D71,      // <cjk>
      0x634F,0x9D73,      // <cjk>
      0x6350,0x9D6F,      // <cjk>
      0x6355,0x95DF,      // <cjk>
      0x6357,0x92BB,      // <cjk>
      0x635C,0x917B,      // <cjk>
      0x6367,0x95F9,      // <cjk>
      0x6368,0x8ECC,      // <cjk>
      0x6369,0x9D80,      // <cjk>
      0x636B,0x9D7E,      // <cjk>
      0x636E,0x9098,      // <cjk>
      0x6372,0x8C9E,      // <cjk>
      0x6376,0x9D78,      // <cjk>
      0x6377,0x8FB7,      // <cjk>
      0x637A,0x93E6,      // <cjk>
      0x637B,0x9450,      // <cjk>
      0x6380,0x9D76,      // <cjk>
      0x6383,0x917C,      // <cjk>
      0x6388,0x8EF6,      // <cjk>
      0x6389,0x9D7B,      // <cjk>
      0x638C,0x8FB6,      // <cjk>
      0x638E,0x9D75,      // <cjk>
      0x638F,0x9D7A,      // <cjk>
      0x6392,0x9472,      // <cjk>
      0x6396,0x9D74,      // <cjk>
      0x6398,0x8C40,      // <cjk>
      0x639B,0x8A7C,      // <cjk>
      0x639F,0x9D7C,      // <cjk>
      0x63A0,0x97A9,      // <cjk>
      0x63A1,0x8DCC,      // <cjk>
      0x63A2,0x9254,      // <cjk>
      0x63A3,0x9D79,      // <cjk>
      0x63A5,0x90DA,      // <cjk>
      0x63A7,0x8D54,      // <cjk>
      0x63A8,0x9084,      // <cjk>
      0x63A9,0x8986,      // <cjk>
      0x63AB,0x9D77,      // <cjk>
      0x63AC,0x8B64,      // <cjk>
      0x63B2,0x8C66,      // <cjk>
      0x63B4,0x92CD,      // <cjk>
      0x63B5,0x9D7D,      // <cjk>
      0x63BB,0x917E,      // <cjk>
      0x63BE,0x9D81,      // <cjk>
      0x63C0,0x9D83,      // <cjk>
      0x63C3,0x91B5,      // <cjk>
      0x63C4,0x9D89,      // <cjk>
      0x63C6,0x9D84,      // <cjk>
      0x63C9,0x9D86,      // <cjk>
      0x63CF,0x9560,      // <cjk>
      0x63D0,0x92F1,      // <cjk>
      0x63D2,0x9D87,      // <cjk>
      0x63D6,0x974B,      // <cjk>
      0x63DA,0x9767,      // <cjk>
      0x63DB,0x8AB7,      // <cjk>
      0x63E1,0x88AC,      // <cjk>
      0x63E3,0x9D85,      // <cjk>
      0x63E9,0x9D82,      // <cjk>
      0x63EE,0x8AF6,      // <cjk>
      0x63F4,0x8987,      // <cjk>
      0x63F6,0x9D88,      // <cjk>
      0x63FA,0x9768,      // <cjk>
      0x6406,0x9D8C,      // <cjk>
      0x640D,0x91B9,      // <cjk>
      0x640F,0x9D93,      // <cjk>
      0x6413,0x9D8D,      // <cjk>
      0x6416,0x9D8A,      // <cjk>
      0x6417,0x9D91,      // <cjk>
      0x641C,0x9D72,      // <cjk>
      0x6426,0x9D8E,      // <cjk>
      0x6428,0x9D92,      // <cjk>
      0x642C,0x94C0,      // <cjk>
      0x642D,0x938B,      // <cjk>
      0x6434,0x9D8B,      // <cjk>
      0x6436,0x9D8F,      // <cjk>
      0x643A,0x8C67,      // <cjk>
      0x643E,0x8DEF,      // <cjk>
      0x6442,0x90DB,      // <cjk>
      0x644E,0x9D97,      // <cjk>
      0x6458,0x9345,      // <cjk>
      0x6467,0x9D94,      // <cjk>
      0x6469,0x9680,      // <cjk>
      0x646F,0x9D95,      // <cjk>
      0x6476,0x9D96,      // <cjk>
      0x6478,0x96CC,      // <cjk>
      0x647A,0x90A0,      // <cjk>
      0x6483,0x8C82,      // <cjk>
      0x6488,0x9D9D,      // <cjk>
      0x6492,0x8E54,      // <cjk>
      0x6493,0x9D9A,      // <cjk>
      0x6495,0x9D99,      // <cjk>
      0x649A,0x9451,      // <cjk>
      0x649E,0x93B3,      // <cjk>
      0x64A4,0x9350,      // <cjk>
      0x64A5,0x9D9B,      // <cjk>
      0x64A9,0x9D9C,      // <cjk>
      0x64AB,0x958F,      // <cjk>
      0x64AD,0x9464,      // <cjk>
      0x64AE,0x8E42,      // <cjk>
      0x64B0,0x90EF,      // <cjk>
      0x64B2,0x966F,      // <cjk>
      0x64B9,0x8A68,      // <cjk>
      0x64BB,0x9DA3,      // <cjk>
      0x64BC,0x9D9E,      // <cjk>
      0x64C1,0x9769,      // <cjk>
      0x64C2,0x9DA5,      // <cjk>
      0x64C5,0x9DA1,      // <cjk>
      0x64C7,0x9DA2,      // <cjk>
      0x64CD,0x9180,      // <cjk>
      0x64D2,0x9DA0,      // <cjk>
      0x64D4,0x9D5E,      // <cjk>
      0x64D8,0x9DA4,      // <cjk>
      0x64DA,0x9D9F,      // <cjk>
      0x64E0,0x9DA9,      // <cjk>
      0x64E1,0x9DAA,      // <cjk>
      0x64E2,0x9346,      // <cjk>
      0x64E3,0x9DAC,      // <cjk>
      0x64E6,0x8E43,      // <cjk>
      0x64E7,0x9DA7,      // <cjk>
      0x64EF,0x9DAD,      // <cjk>
      0x64F1,0x9DA6,      // <cjk>
      0x64F2,0x9DB1,      // <cjk>
      0x64F4,0x9DB0,      // <cjk>
      0x64F6,0x9DAF,      // <cjk>
      0x64FA,0x9DB2,      // <cjk>
      0x64FD,0x9DB4,      // <cjk>
      0x64FE,0x8FEF,      // <cjk>
      0x6500,0x9DB3,      // <cjk>
      0x6505,0x9DB7,      // <cjk>
      0x6518,0x9DB5,      // <cjk>
      0x651C,0x9DB6,      // <cjk>
      0x651D,0x9D90,      // <cjk>
      0x6523,0x9DB9,      // <cjk>
      0x6524,0x9DB8,      // <cjk>
      0x652A,0x9D98,      // <cjk>
      0x652B,0x9DBA,      // <cjk>
      0x652C,0x9DAE,      // <cjk>
      0x652F,0x8E78,      // <cjk>
      0x6534,0x9DBB,      // <cjk>
      0x6535,0x9DBC,      // <cjk>
      0x6536,0x9DBE,      // <cjk>
      0x6537,0x9DBD,      // <cjk>
      0x6538,0x9DBF,      // <cjk>
      0x6539,0x89FC,      // <cjk>
      0x653B,0x8D55,      // <cjk>
      0x653E,0x95FA,      // <cjk>
      0x653F,0x90AD,      // <cjk>
      0x6545,0x8CCC,      // <cjk>
      0x6548,0x9DC1,      // <cjk>
      0x654D,0x9DC4,      // <cjk>
      0x654F,0x9571,      // <cjk>
      0x6551,0x8B7E,      // <cjk>
      0x6555,0x9DC3,      // <cjk>
      0x6556,0x9DC2,      // <cjk>
      0x6557,0x9473,      // <cjk>
      0x6558,0x9DC5,      // <cjk>
      0x6559,0x8BB3,      // <cjk>
      0x655D,0x9DC7,      // <cjk>
      0x655E,0x9DC6,      // <cjk>
      0x6562,0x8AB8,      // <cjk>
      0x6563,0x8E55,      // <cjk>
      0x6566,0x93D6,      // <cjk>
      0x656C,0x8C68,      // <cjk>
      0x6570,0x9094,      // <cjk>
      0x6572,0x9DC8,      // <cjk>
      0x6574,0x90AE,      // <cjk>
      0x6575,0x9347,      // <cjk>
      0x6577,0x957E,      // <cjk>
      0x6578,0x9DC9,      // <cjk>
      0x6582,0x9DCA,      // <cjk>
      0x6583,0x9DCB,      // <cjk>
      0x6587,0x95B6,      // <cjk>
      0x6588,0x9B7C,      // <cjk>
      0x6589,0x90C4,      // <cjk>
      0x658C,0x956B,      // <cjk>
      0x658E,0x8DD6,      // <cjk>
      0x6590,0x94E3,      // <cjk>
      0x6591,0x94C1,      // <cjk>
      0x6597,0x936C,      // <cjk>
      0x6599,0x97BF,      // <cjk>
      0x659B,0x9DCD,      // <cjk>
      0x659C,0x8ECE,      // <cjk>
      0x659F,0x9DCE,      // <cjk>
      0x65A1,0x88B4,      // <cjk>
      0x65A4,0x8BD2,      // <cjk>
      0x65A5,0x90CB,      // <cjk>
      0x65A7,0x9580,      // <cjk>
      0x65AB,0x9DCF,      // <cjk>
      0x65AC,0x8E61,      // <cjk>
      0x65AD,0x9266,      // <cjk>
      0x65AF,0x8E7A,      // <cjk>
      0x65B0,0x9056,      // <cjk>
      0x65B7,0x9DD0,      // <cjk>
      0x65B9,0x95FB,      // <cjk>
      0x65BC,0x8997,      // <cjk>
      0x65BD,0x8E7B,      // <cjk>
      0x65C1,0x9DD3,      // <cjk>
      0x65C3,0x9DD1,      // <cjk>
      0x65C4,0x9DD4,      // <cjk>
      0x65C5,0x97B7,      // <cjk>
      0x65C6,0x9DD2,      // <cjk>
      0x65CB,0x90F9,      // <cjk>
      0x65CC,0x9DD5,      // <cjk>
      0x65CF,0x91B0,      // <cjk>
      0x65D2,0x9DD6,      // <cjk>
      0x65D7,0x8AF8,      // <cjk>
      0x65D9,0x9DD8,      // <cjk>
      0x65DB,0x9DD7,      // <cjk>
      0x65E0,0x9DD9,      // <cjk>
      0x65E1,0x9DDA,      // <cjk>
      0x65E2,0x8AF9,      // <cjk>
      0x65E5,0x93FA,      // <cjk>
      0x65E6,0x9255,      // <cjk>
      0x65E7,0x8B8C,      // <cjk>
      0x65E8,0x8E7C,      // <cjk>
      0x65E9,0x9181,      // <cjk>
      0x65EC,0x8F7B,      // <cjk>
      0x65ED,0x88AE,      // <cjk>
      0x65F1,0x9DDB,      // <cjk>
      0x65FA,0x89A0,      // <cjk>
      0x65FB,0x9DDF,      // <cjk>
      0x6602,0x8D56,      // <cjk>
      0x6603,0x9DDE,      // <cjk>
      0x6606,0x8DA9,      // <cjk>
      0x6607,0x8FB8,      // <cjk>
      0x660A,0x9DDD,      // <cjk>
      0x660C,0x8FB9,      // <cjk>
      0x660E,0x96BE,      // <cjk>
      0x660F,0x8DA8,      // <cjk>
      0x6613,0x88D5,      // <cjk>
      0x6614,0x90CC,      // <cjk>
      0x661C,0x9DE4,      // <cjk>
      0x661F,0x90AF,      // <cjk>
      0x6620,0x8966,      // <cjk>
      0x6625,0x8F74,      // <cjk>
      0x6627,0x9686,      // <cjk>
      0x6628,0x8DF0,      // <cjk>
      0x662D,0x8FBA,      // <cjk>
      0x662F,0x90A5,      // <cjk>
      0x6634,0x9DE3,      // <cjk>
      0x6635,0x9DE1,      // <cjk>
      0x6636,0x9DE2,      // <cjk>
      0x663C,0x928B,      // <cjk>
      0x663F,0x9E45,      // <cjk>
      0x6641,0x9DE8,      // <cjk>
      0x6642,0x8E9E,      // <cjk>
      0x6643,0x8D57,      // <cjk>
      0x6644,0x9DE6,      // <cjk>
      0x6649,0x9DE7,      // <cjk>
      0x664B,0x9057,      // <cjk>
      0x664F,0x9DE5,      // <cjk>
      0x6652,0x8E4E,      // <cjk>
      0x665D,0x9DEA,      // <cjk>
      0x665E,0x9DE9,      // <cjk>
      0x665F,0x9DEE,      // <cjk>
      0x6662,0x9DEF,      // <cjk>
      0x6664,0x9DEB,      // <cjk>
      0x6666,0x8A41,      // <cjk>
      0x6667,0x9DEC,      // <cjk>
      0x6668,0x9DED,      // <cjk>
      0x6669,0x94D3,      // <cjk>
      0x666E,0x9581,      // <cjk>
      0x666F,0x8C69,      // <cjk>
      0x6670,0x9DF0,      // <cjk>
      0x6674,0x90B0,      // <cjk>
      0x6676,0x8FBB,      // <cjk>
      0x667A,0x9271,      // <cjk>
      0x6681,0x8BC5,      // <cjk>
      0x6683,0x9DF1,      // <cjk>
      0x6684,0x9DF5,      // <cjk>
      0x6687,0x89C9,      // <cjk>
      0x6688,0x9DF2,      // <cjk>
      0x6689,0x9DF4,      // <cjk>
      0x668E,0x9DF3,      // <cjk>
      0x6691,0x8F8B,      // <cjk>
      0x6696,0x9267,      // <cjk>
      0x6697,0x88C3,      // <cjk>
      0x6698,0x9DF6,      // <cjk>
      0x669D,0x9DF7,      // <cjk>
      0x66A2,0x92A8,      // <cjk>
      0x66A6,0x97EF,      // <cjk>
      0x66AB,0x8E62,      // <cjk>
      0x66AE,0x95E9,      // <cjk>
      0x66B4,0x965C,      // <cjk>
      0x66B8,0x9E41,      // <cjk>
      0x66B9,0x9DF9,      // <cjk>
      0x66BC,0x9DFC,      // <cjk>
      0x66BE,0x9DFB,      // <cjk>
      0x66C1,0x9DF8,      // <cjk>
      0x66C4,0x9E40,      // <cjk>
      0x66C7,0x93DC,      // <cjk>
      0x66C9,0x9DFA,      // <cjk>
      0x66D6,0x9E42,      // <cjk>
      0x66D9,0x8F8C,      // <cjk>
      0x66DA,0x9E43,      // <cjk>
      0x66DC,0x976A,      // <cjk>
      0x66DD,0x9498,      // <cjk>
      0x66E0,0x9E44,      // <cjk>
      0x66E6,0x9E46,      // <cjk>
      0x66E9,0x9E47,      // <cjk>
      0x66F0,0x9E48,      // <cjk>
      0x66F2,0x8BC8,      // <cjk>
      0x66F3,0x8967,      // <cjk>
      0x66F4,0x8D58,      // <cjk>
      0x66F5,0x9E49,      // <cjk>
      0x66F7,0x9E4A,      // <cjk>
      0x66F8,0x8F91,      // <cjk>
      0x66F9,0x9182,      // <cjk>
      0x66FC,0x99D6,      // <cjk>
      0x66FD,0x915D,      // <cjk>
      0x66FE,0x915C,      // <cjk>
      0x66FF,0x91D6,      // <cjk>
      0x6700,0x8DC5,      // <cjk>
      0x6703,0x98F0,      // <cjk>
      0x6708,0x8C8E,      // <cjk>
      0x6709,0x974C,      // <cjk>
      0x670B,0x95FC,      // <cjk>
      0x670D,0x959E,      // <cjk>
      0x670F,0x9E4B,      // <cjk>
      0x6714,0x8DF1,      // <cjk>
      0x6715,0x92BD,      // <cjk>
      0x6716,0x9E4C,      // <cjk>
      0x6717,0x984E,      // <cjk>
      0x671B,0x965D,      // <cjk>
      0x671D,0x92A9,      // <cjk>
      0x671E,0x9E4D,      // <cjk>
      0x671F,0x8AFA,      // <cjk>
      0x6726,0x9E4E,      // <cjk>
      0x6727,0x9E4F,      // <cjk>
      0x6728,0x96D8,      // <cjk>
      0x672A,0x96A2,      // <cjk>
      0x672B,0x9696,      // <cjk>
      0x672C,0x967B,      // <cjk>
      0x672D,0x8E44,      // <cjk>
      0x672E,0x9E51,      // <cjk>
      0x6731,0x8EE9,      // <cjk>
      0x6734,0x9670,      // <cjk>
      0x6736,0x9E53,      // <cjk>
      0x6737,0x9E56,      // <cjk>
      0x6738,0x9E55,      // <cjk>
      0x673A,0x8AF7,      // <cjk>
      0x673D,0x8B80,      // <cjk>
      0x673F,0x9E52,      // <cjk>
      0x6741,0x9E54,      // <cjk>
      0x6746,0x9E57,      // <cjk>
      0x6749,0x9099,      // <cjk>
      0x674E,0x979B,      // <cjk>
      0x674F,0x88C7,      // <cjk>
      0x6750,0x8DDE,      // <cjk>
      0x6751,0x91BA,      // <cjk>
      0x6753,0x8EDB,      // <cjk>
      0x6756,0x8FF1,      // <cjk>
      0x6759,0x9E5A,      // <cjk>
      0x675C,0x936D,      // <cjk>
      0x675E,0x9E58,      // <cjk>
      0x675F,0x91A9,      // <cjk>
      0x6760,0x9E59,      // <cjk>
      0x6761,0x8FF0,      // <cjk>
      0x6762,0x96DB,      // <cjk>
      0x6764,0x9E5C,      // <cjk>
      0x6765,0x9788,      // <cjk>
      0x676A,0x9E61,      // <cjk>
      0x676D,0x8D59,      // <cjk>
      0x676F,0x9474,      // <cjk>
      0x6770,0x9E5E,      // <cjk>
      0x6771,0x938C,      // <cjk>
      0x6772,0x9DDC,      // <cjk>
      0x6773,0x9DE0,      // <cjk>
      0x6775,0x8B6E,      // <cjk>
      0x6777,0x9466,      // <cjk>
      0x677C,0x9E60,      // <cjk>
      0x677E,0x8FBC,      // <cjk>
      0x677F,0x94C2,      // <cjk>
      0x6785,0x9E66,      // <cjk>
      0x6787,0x94F8,      // <cjk>
      0x6789,0x9E5D,      // <cjk>
      0x678B,0x9E63,      // <cjk>
      0x678C,0x9E62,      // <cjk>
      0x6790,0x90CD,      // <cjk>
      0x6795,0x968D,      // <cjk>
      0x6797,0x97D1,      // <cjk>
      0x679A,0x9687,      // <cjk>
      0x679C,0x89CA,      // <cjk>
      0x679D,0x8E7D,      // <cjk>
      0x67A0,0x9867,      // <cjk>
      0x67A1,0x9E65,      // <cjk>
      0x67A2,0x9095,      // <cjk>
      0x67A6,0x9E64,      // <cjk>
      0x67A9,0x9E5F,      // <cjk>
      0x67AF,0x8CCD,      // <cjk>
      0x67B3,0x9E6B,      // <cjk>
      0x67B4,0x9E69,      // <cjk>
      0x67B6,0x89CB,      // <cjk>
      0x67B7,0x9E67,      // <cjk>
      0x67B8,0x9E6D,      // <cjk>
      0x67B9,0x9E73,      // <cjk>
      0x67C1,0x91C6,      // <cjk>
      0x67C4,0x95BF,      // <cjk>
      0x67C6,0x9E75,      // <cjk>
      0x67CA,0x9541,      // <cjk>
      0x67CE,0x9E74,      // <cjk>
      0x67CF,0x9490,      // <cjk>
      0x67D0,0x965E,      // <cjk>
      0x67D1,0x8AB9,      // <cjk>
      0x67D3,0x90F5,      // <cjk>
      0x67D4,0x8F5F,      // <cjk>
      0x67D8,0x92D1,      // <cjk>
      0x67DA,0x974D,      // <cjk>
      0x67DD,0x9E70,      // <cjk>
      0x67DE,0x9E6F,      // <cjk>
      0x67E2,0x9E71,      // <cjk>
      0x67E4,0x9E6E,      // <cjk>
      0x67E7,0x9E76,      // <cjk>
      0x67E9,0x9E6C,      // <cjk>
      0x67EC,0x9E6A,      // <cjk>
      0x67EE,0x9E72,      // <cjk>
      0x67EF,0x9E68,      // <cjk>
      0x67F1,0x928C,      // <cjk>
      0x67F3,0x96F6,      // <cjk>
      0x67F4,0x8EC4,      // <cjk>
      0x67F5,0x8DF2,      // <cjk>
      0x67FB,0x8DB8,      // <cjk>
      0x67FE,0x968F,      // <cjk>
      0x67FF,0x8A60,      // <cjk>
      0x6802,0x92CC,      // <cjk>
      0x6803,0x93C8,      // <cjk>
      0x6804,0x8968,      // <cjk>
      0x6813,0x90F0,      // <cjk>
      0x6816,0x90B2,      // <cjk>
      0x6817,0x8C49,      // <cjk>
      0x681E,0x9E78,      // <cjk>
      0x6821,0x8D5A,      // <cjk>
      0x6822,0x8A9C,      // <cjk>
      0x6829,0x9E7A,      // <cjk>
      0x682A,0x8A94,      // <cjk>
      0x682B,0x9E81,      // <cjk>
      0x6832,0x9E7D,      // <cjk>
      0x6834,0x90F1,      // <cjk>
      0x6838,0x8A6A,      // <cjk>
      0x6839,0x8DAA,      // <cjk>
      0x683C,0x8A69,      // <cjk>
      0x683D,0x8DCD,      // <cjk>
      0x6840,0x9E7B,      // <cjk>
      0x6841,0x8C85,      // <cjk>
      0x6842,0x8C6A,      // <cjk>
      0x6843,0x938D,      // <cjk>
      0x6846,0x9E79,      // <cjk>
      0x6848,0x88C4,      // <cjk>
      0x684D,0x9E7C,      // <cjk>
      0x684E,0x9E7E,      // <cjk>
      0x6850,0x8BCB,      // <cjk>
      0x6851,0x8C4B,      // <cjk>
      0x6853,0x8ABA,      // <cjk>
      0x6854,0x8B6A,      // <cjk>
      0x6859,0x9E82,      // <cjk>
      0x685C,0x8DF7,      // <cjk>
      0x685D,0x9691,      // <cjk>
      0x685F,0x8E56,      // <cjk>
      0x6863,0x9E83,      // <cjk>
      0x6867,0x954F,      // <cjk>
      0x6874,0x9E8F,      // <cjk>
      0x6876,0x89B1,      // <cjk>
      0x6877,0x9E84,      // <cjk>
      0x687E,0x9E95,      // <cjk>
      0x687F,0x9E85,      // <cjk>
      0x6881,0x97C0,      // <cjk>
      0x6883,0x9E8C,      // <cjk>
      0x6885,0x947E,      // <cjk>
      0x688D,0x9E94,      // <cjk>
      0x688F,0x9E87,      // <cjk>
      0x6893,0x88B2,      // <cjk>
      0x6894,0x9E89,      // <cjk>
      0x689B,0x9E8B,      // <cjk>
      0x689D,0x9E8A,      // <cjk>
      0x689F,0x9E86,      // <cjk>
      0x68A0,0x9E91,      // <cjk>
      0x68A2,0x8FBD,      // <cjk>
      0x68A6,0x9AEB,      // <cjk>
      0x68A7,0x8CE6,      // <cjk>
      0x68A8,0x979C,      // <cjk>
      0x68AD,0x9E88,      // <cjk>
      0x68AF,0x92F2,      // <cjk>
      0x68B0,0x8A42,      // <cjk>
      0x68B1,0x8DAB,      // <cjk>
      0x68B3,0x9E80,      // <cjk>
      0x68B5,0x9E90,      // <cjk>
      0x68B6,0x8A81,      // <cjk>
      0x68B9,0x9E8E,      // <cjk>
      0x68BA,0x9E92,      // <cjk>
      0x68BC,0x938E,      // <cjk>
      0x68C4,0x8AFC,      // <cjk>
      0x68C6,0x9EB0,      // <cjk>
      0x68C9,0x96C7,      // <cjk>
      0x68CA,0x9E97,      // <cjk>
      0x68CB,0x8AFB,      // <cjk>
      0x68CD,0x9E9E,      // <cjk>
      0x68D2,0x965F,      // <cjk>
      0x68D4,0x9E9F,      // <cjk>
      0x68D5,0x9EA1,      // <cjk>
      0x68D7,0x9EA5,      // <cjk>
      0x68D8,0x9E99,      // <cjk>
      0x68DA,0x9249,      // <cjk>
      0x68DF,0x938F,      // <cjk>
      0x68E0,0x9EA9,      // <cjk>
      0x68E1,0x9E9C,      // <cjk>
      0x68E3,0x9EA6,      // <cjk>
      0x68E7,0x9EA0,      // <cjk>
      0x68EE,0x9058,      // <cjk>
      0x68EF,0x9EAA,      // <cjk>
      0x68F2,0x90B1,      // <cjk>
      0x68F9,0x9EA8,      // <cjk>
      0x68FA,0x8ABB,      // <cjk>
      0x6900,0x986F,      // <cjk>
      0x6901,0x9E96,      // <cjk>
      0x6904,0x9EA4,      // <cjk>
      0x6905,0x88D6,      // <cjk>
      0x6908,0x9E98,      // <cjk>
      0x690B,0x96B8,      // <cjk>
      0x690C,0x9E9D,      // <cjk>
      0x690D,0x9041,      // <cjk>
      0x690E,0x92C5,      // <cjk>
      0x690F,0x9E93,      // <cjk>
      0x6912,0x9EA3,      // <cjk>
      0x6919,0x909A,      // <cjk>
      0x691A,0x9EAD,      // <cjk>
      0x691B,0x8A91,      // <cjk>
      0x691C,0x8C9F,      // <cjk>
      0x6921,0x9EAF,      // <cjk>
      0x6922,0x9E9A,      // <cjk>
      0x6923,0x9EAE,      // <cjk>
      0x6925,0x9EA7,      // <cjk>
      0x6926,0x9E9B,      // <cjk>
      0x6928,0x9EAB,      // <cjk>
      0x692A,0x9EAC,      // <cjk>
      0x6930,0x9EBD,      // <cjk>
      0x6934,0x93CC,      // <cjk>
      0x6936,0x9EA2,      // <cjk>
      0x6939,0x9EB9,      // <cjk>
      0x693D,0x9EBB,      // <cjk>
      0x693F,0x92D6,      // <cjk>
      0x694A,0x976B,      // <cjk>
      0x6953,0x9596,      // <cjk>
      0x6954,0x9EB6,      // <cjk>
      0x6955,0x91C8,      // <cjk>
      0x6959,0x9EBC,      // <cjk>
      0x695A,0x915E,      // <cjk>
      0x695C,0x9EB3,      // <cjk>
      0x695D,0x9EC0,      // <cjk>
      0x695E,0x9EBF,      // <cjk>
      0x6960,0x93ED,      // <cjk>
      0x6961,0x9EBE,      // <cjk>
      0x6962,0x93E8,      // <cjk>
      0x696A,0x9EC2,      // <cjk>
      0x696B,0x9EB5,      // <cjk>
      0x696D,0x8BC6,      // <cjk>
      0x696E,0x9EB8,      // <cjk>
      0x696F,0x8F7C,      // <cjk>
      0x6973,0x9480,      // <cjk>
      0x6974,0x9EBA,      // <cjk>
      0x6975,0x8BC9,      // <cjk>
      0x6977,0x9EB2,      // <cjk>
      0x6978,0x9EB4,      // <cjk>
      0x6979,0x9EB1,      // <cjk>
      0x697C,0x984F,      // <cjk>
      0x697D,0x8A79,      // <cjk>
      0x697E,0x9EB7,      // <cjk>
      0x6981,0x9EC1,      // <cjk>
      0x6982,0x8A54,      // <cjk>
      0x698A,0x8DE5,      // <cjk>
      0x698E,0x897C,      // <cjk>
      0x6991,0x9ED2,      // <cjk>
      0x6994,0x9850,      // <cjk>
      0x6995,0x9ED5,      // <cjk>
      0x699B,0x9059,      // <cjk>
      0x699C,0x9ED4,      // <cjk>
      0x69A0,0x9ED3,      // <cjk>
      0x69A7,0x9ED0,      // <cjk>
      0x69AE,0x9EC4,      // <cjk>
      0x69B1,0x9EE1,      // <cjk>
      0x69B2,0x9EC3,      // <cjk>
      0x69B4,0x9ED6,      // <cjk>
      0x69BB,0x9ECE,      // <cjk>
      0x69BE,0x9EC9,      // <cjk>
      0x69BF,0x9EC6,      // <cjk>
      0x69C1,0x9EC7,      // <cjk>
      0x69C3,0x9ECF,      // <cjk>
      0x69C7,0xEAA0,      // <cjk>
      0x69CA,0x9ECC,      // <cjk>
      0x69CB,0x8D5C,      // <cjk>
      0x69CC,0x92C6,      // <cjk>
      0x69CD,0x9184,      // <cjk>
      0x69CE,0x9ECA,      // <cjk>
      0x69D0,0x9EC5,      // <cjk>
      0x69D3,0x9EC8,      // <cjk>
      0x69D8,0x976C,      // <cjk>
      0x69D9,0x968A,      // <cjk>
      0x69DD,0x9ECD,      // <cjk>
      0x69DE,0x9ED7,      // <cjk>
      0x69E7,0x9EDF,      // <cjk>
      0x69E8,0x9ED8,      // <cjk>
      0x69EB,0x9EE5,      // <cjk>
      0x69ED,0x9EE3,      // <cjk>
      0x69F2,0x9EDE,      // <cjk>
      0x69F9,0x9EDD,      // <cjk>
      0x69FB,0x92CE,      // <cjk>
      0x69FD,0x9185,      // <cjk>
      0x69FF,0x9EDB,      // <cjk>
      0x6A02,0x9ED9,      // <cjk>
      0x6A05,0x9EE0,      // <cjk>
      0x6A0A,0x9EE6,      // <cjk>
      0x6A0B,0x94F3,      // <cjk>
      0x6A0C,0x9EEC,      // <cjk>
      0x6A12,0x9EE7,      // <cjk>
      0x6A13,0x9EEA,      // <cjk>
      0x6A14,0x9EE4,      // <cjk>
      0x6A17,0x9294,      // <cjk>
      0x6A19,0x9557,      // <cjk>
      0x6A1B,0x9EDA,      // <cjk>
      0x6A1E,0x9EE2,      // <cjk>
      0x6A1F,0x8FBE,      // <cjk>
      0x6A21,0x96CD,      // <cjk>
      0x6A22,0x9EF6,      // <cjk>
      0x6A23,0x9EE9,      // <cjk>
      0x6A29,0x8CA0,      // <cjk>
      0x6A2A,0x89A1,      // <cjk>
      0x6A2B,0x8A7E,      // <cjk>
      0x6A2E,0x9ED1,      // <cjk>
      0x6A35,0x8FBF,      // <cjk>
      0x6A36,0x9EEE,      // <cjk>
      0x6A38,0x9EF5,      // <cjk>
      0x6A39,0x8EF7,      // <cjk>
      0x6A3A,0x8A92,      // <cjk>
      0x6A3D,0x924D,      // <cjk>
      0x6A44,0x9EEB,      // <cjk>
      0x6A47,0x9EF0,      // <cjk>
      0x6A48,0x9EF4,      // <cjk>
      0x6A4B,0x8BB4,      // <cjk>
      0x6A58,0x8B6B,      // <cjk>
      0x6A59,0x9EF2,      // <cjk>
      0x6A5F,0x8B40,      // <cjk>
      0x6A61,0x93C9,      // <cjk>
      0x6A62,0x9EF1,      // <cjk>
      0x6A66,0x9EF3,      // <cjk>
      0x6A72,0x9EED,      // <cjk>
      0x6A78,0x9EEF,      // <cjk>
      0x6A7F,0x8A80,      // <cjk>
      0x6A80,0x9268,      // <cjk>
      0x6A84,0x9EFA,      // <cjk>
      0x6A8D,0x9EF8,      // <cjk>
      0x6A8E,0x8CE7,      // <cjk>
      0x6A90,0x9EF7,      // <cjk>
      0x6A97,0x9F40,      // <cjk>
      0x6A9C,0x9E77,      // <cjk>
      0x6AA0,0x9EF9,      // <cjk>
      0x6AA2,0x9EFB,      // <cjk>
      0x6AA3,0x9EFC,      // <cjk>
      0x6AAA,0x9F4B,      // <cjk>
      0x6AAC,0x9F47,      // <cjk>
      0x6AAE,0x9E8D,      // <cjk>
      0x6AB3,0x9F46,      // <cjk>
      0x6AB8,0x9F45,      // <cjk>
      0x6ABB,0x9F42,      // <cjk>
      0x6AC1,0x9EE8,      // <cjk>
      0x6AC2,0x9F44,      // <cjk>
      0x6AC3,0x9F43,      // <cjk>
      0x6AD1,0x9F49,      // <cjk>
      0x6AD3,0x9845,      // <cjk>
      0x6ADA,0x9F4C,      // <cjk>
      0x6ADB,0x8BF9,      // <cjk>
      0x6ADE,0x9F48,      // <cjk>
      0x6ADF,0x9F4A,      // <cjk>
      0x6AE8,0x94A5,      // <cjk>
      0x6AEA,0x9F4D,      // <cjk>
      0x6AFA,0x9F51,      // <cjk>
      0x6AFB,0x9F4E,      // <cjk>
      0x6B04,0x9793,      // <cjk>
      0x6B05,0x9F4F,      // <cjk>
      0x6B0A,0x9EDC,      // <cjk>
      0x6B12,0x9F52,      // <cjk>
      0x6B16,0x9F53,      // <cjk>
      0x6B1D,0x8954,      // <cjk>
      0x6B1F,0x9F55,      // <cjk>
      0x6B20,0x8C87,      // <cjk>
      0x6B21,0x8E9F,      // <cjk>
      0x6B23,0x8BD3,      // <cjk>
      0x6B27,0x89A2,      // <cjk>
      0x6B32,0x977E,      // <cjk>
      0x6B37,0x9F57,      // <cjk>
      0x6B38,0x9F56,      // <cjk>
      0x6B39,0x9F59,      // <cjk>
      0x6B3A,0x8B5C,      // <cjk>
      0x6B3D,0x8BD4,      // <cjk>
      0x6B3E,0x8ABC,      // <cjk>
      0x6B43,0x9F5C,      // <cjk>
      0x6B49,0x9F5D,      // <cjk>
      0x6B4C,0x89CC,      // <cjk>
      0x6B4E,0x9256,      // <cjk>
      0x6B50,0x9F5E,      // <cjk>
      0x6B53,0x8ABD,      // <cjk>
      0x6B54,0x9F60,      // <cjk>
      0x6B59,0x9F5F,      // <cjk>
      0x6B5B,0x9F61,      // <cjk>
      0x6B5F,0x9F62,      // <cjk>
      0x6B61,0x9F63,      // <cjk>
      0x6B62,0x8E7E,      // <cjk>
      0x6B63,0x90B3,      // <cjk>
      0x6B64,0x8D9F,      // <cjk>
      0x6B66,0x9590,      // <cjk>
      0x6B69,0x95E0,      // <cjk>
      0x6B6A,0x9863,      // <cjk>
      0x6B6F,0x8E95,      // <cjk>
      0x6B73,0x8DCE,      // <cjk>
      0x6B74,0x97F0,      // <cjk>
      0x6B78,0x9F64,      // <cjk>
      0x6B79,0x9F65,      // <cjk>
      0x6B7B,0x8E80,      // <cjk>
      0x6B7F,0x9F66,      // <cjk>
      0x6B80,0x9F67,      // <cjk>
      0x6B83,0x9F69,      // <cjk>
      0x6B84,0x9F68,      // <cjk>
      0x6B86,0x9677,      // <cjk>
      0x6B89,0x8F7D,      // <cjk>
      0x6B8A,0x8EEA,      // <cjk>
      0x6B8B,0x8E63,      // <cjk>
      0x6B8D,0x9F6A,      // <cjk>
      0x6B95,0x9F6C,      // <cjk>
      0x6B96,0x9042,      // <cjk>
      0x6B98,0x9F6B,      // <cjk>
      0x6B9E,0x9F6D,      // <cjk>
      0x6BA4,0x9F6E,      // <cjk>
      0x6BAA,0x9F6F,      // <cjk>
      0x6BAB,0x9F70,      // <cjk>
      0x6BAF,0x9F71,      // <cjk>
      0x6BB1,0x9F73,      // <cjk>
      0x6BB2,0x9F72,      // <cjk>
      0x6BB3,0x9F74,      // <cjk>
      0x6BB4,0x89A3,      // <cjk>
      0x6BB5,0x9269,      // <cjk>
      0x6BB7,0x9F75,      // <cjk>
      0x6BBA,0x8E45,      // <cjk>
      0x6BBB,0x8A6B,      // <cjk>
      0x6BBC,0x9F76,      // <cjk>
      0x6BBF,0x9361,      // <cjk>
      0x6BC0,0x9ACA,      // <cjk>
      0x6BC5,0x8B42,      // <cjk>
      0x6BC6,0x9F77,      // <cjk>
      0x6BCB,0x9F78,      // <cjk>
      0x6BCD,0x95EA,      // <cjk>
      0x6BCE,0x9688,      // <cjk>
      0x6BD2,0x93C5,      // <cjk>
      0x6BD3,0x9F79,      // <cjk>
      0x6BD4,0x94E4,      // <cjk>
      0x6BD8,0x94F9,      // <cjk>
      0x6BDB,0x96D1,      // <cjk>
      0x6BDF,0x9F7A,      // <cjk>
      0x6BEB,0x9F7C,      // <cjk>
      0x6BEC,0x9F7B,      // <cjk>
      0x6BEF,0x9F7E,      // <cjk>
      0x6BF3,0x9F7D,      // <cjk>
      0x6C08,0x9F81,      // <cjk>
      0x6C0F,0x8E81,      // <cjk>
      0x6C11,0x96AF,      // <cjk>
      0x6C13,0x9F82,      // <cjk>
      0x6C14,0x9F83,      // <cjk>
      0x6C17,0x8B43,      // <cjk>
      0x6C1B,0x9F84,      // <cjk>
      0x6C23,0x9F86,      // <cjk>
      0x6C24,0x9F85,      // <cjk>
      0x6C34,0x9085,      // <cjk>
      0x6C37,0x9558,      // <cjk>
      0x6C38,0x8969,      // <cjk>
      0x6C3E,0x94C3,      // <cjk>
      0x6C40,0x92F3,      // <cjk>
      0x6C41,0x8F60,      // <cjk>
      0x6C42,0x8B81,      // <cjk>
      0x6C4E,0x94C4,      // <cjk>
      0x6C50,0x8EAC,      // <cjk>
      0x6C55,0x9F88,      // <cjk>
      0x6C57,0x8ABE,      // <cjk>
      0x6C5A,0x8998,      // <cjk>
      0x6C5D,0x93F0,      // <cjk>
      0x6C5E,0x9F87,      // <cjk>
      0x6C5F,0x8D5D,      // <cjk>
      0x6C60,0x9272,      // <cjk>
      0x6C62,0x9F89,      // <cjk>
      0x6C68,0x9F91,      // <cjk>
      0x6C6A,0x9F8A,      // <cjk>
      0x6C70,0x91BF,      // <cjk>
      0x6C72,0x8B82,      // <cjk>
      0x6C73,0x9F92,      // <cjk>
      0x6C7A,0x8C88,      // <cjk>
      0x6C7D,0x8B44,      // <cjk>
      0x6C7E,0x9F90,      // <cjk>
      0x6C81,0x9F8E,      // <cjk>
      0x6C82,0x9F8B,      // <cjk>
      0x6C83,0x9780,      // <cjk>
      0x6C88,0x92BE,      // <cjk>
      0x6C8C,0x93D7,      // <cjk>
      0x6C8D,0x9F8C,      // <cjk>
      0x6C90,0x9F94,      // <cjk>
      0x6C92,0x9F93,      // <cjk>
      0x6C93,0x8C42,      // <cjk>
      0x6C96,0x89AB,      // <cjk>
      0x6C99,0x8DB9,      // <cjk>
      0x6C9A,0x9F8D,      // <cjk>
      0x6C9B,0x9F8F,      // <cjk>
      0x6CA1,0x9676,      // <cjk>
      0x6CA2,0x91F2,      // <cjk>
      0x6CAB,0x9697,      // <cjk>
      0x6CAE,0x9F9C,      // <cjk>
      0x6CB1,0x9F9D,      // <cjk>
      0x6CB3,0x89CD,      // <cjk>
      0x6CB8,0x95A6,      // <cjk>
      0x6CB9,0x96FB,      // <cjk>
      0x6CBA,0x9F9F,      // <cjk>
      0x6CBB,0x8EA1,      // <cjk>
      0x6CBC,0x8FC0,      // <cjk>
      0x6CBD,0x9F98,      // <cjk>
      0x6CBE,0x9F9E,      // <cjk>
      0x6CBF,0x8988,      // <cjk>
      0x6CC1,0x8BB5,      // <cjk>
      0x6CC4,0x9F95,      // <cjk>
      0x6CC5,0x9F9A,      // <cjk>
      0x6CC9,0x90F2,      // <cjk>
      0x6CCA,0x9491,      // <cjk>
      0x6CCC,0x94E5,      // <cjk>
      0x6CD3,0x9F97,      // <cjk>
      0x6CD5,0x9640,      // <cjk>
      0x6CD7,0x9F99,      // <cjk>
      0x6CD9,0x9FA2,      // <cjk>
      0x6CDB,0x9FA0,      // <cjk>
      0x6CDD,0x9F9B,      // <cjk>
      0x6CE1,0x9641,      // <cjk>
      0x6CE2,0x9467,      // <cjk>
      0x6CE3,0x8B83,      // <cjk>
      0x6CE5,0x9344,      // <cjk>
      0x6CE8,0x928D,      // <cjk>
      0x6CEA,0x9FA3,      // <cjk>
      0x6CEF,0x9FA1,      // <cjk>
      0x6CF0,0x91D7,      // <cjk>
      0x6CF1,0x9F96,      // <cjk>
      0x6CF3,0x896A,      // <cjk>
      0x6D0B,0x976D,      // <cjk>
      0x6D0C,0x9FAE,      // <cjk>
      0x6D12,0x9FAD,      // <cjk>
      0x6D17,0x90F4,      // <cjk>
      0x6D19,0x9FAA,      // <cjk>
      0x6D1B,0x978C,      // <cjk>
      0x6D1E,0x93B4,      // <cjk>
      0x6D1F,0x9FA4,      // <cjk>
      0x6D25,0x92C3,      // <cjk>
      0x6D29,0x896B,      // <cjk>
      0x6D2A,0x8D5E,      // <cjk>
      0x6D2B,0x9FA7,      // <cjk>
      0x6D32,0x8F46,      // <cjk>
      0x6D33,0x9FAC,      // <cjk>
      0x6D35,0x9FAB,      // <cjk>
      0x6D36,0x9FA6,      // <cjk>
      0x6D38,0x9FA9,      // <cjk>
      0x6D3B,0x8A88,      // <cjk>
      0x6D3D,0x9FA8,      // <cjk>
      0x6D3E,0x9468,      // <cjk>
      0x6D41,0x97AC,      // <cjk>
      0x6D44,0x8FF2,      // <cjk>
      0x6D45,0x90F3,      // <cjk>
      0x6D59,0x9FB4,      // <cjk>
      0x6D5A,0x9FB2,      // <cjk>
      0x6D5C,0x956C,      // <cjk>
      0x6D63,0x9FAF,      // <cjk>
      0x6D64,0x9FB1,      // <cjk>
      0x6D66,0x8959,      // <cjk>
      0x6D69,0x8D5F,      // <cjk>
      0x6D6A,0x9851,      // <cjk>
      0x6D6C,0x8A5C,      // <cjk>
      0x6D6E,0x9582,      // <cjk>
      0x6D74,0x9781,      // <cjk>
      0x6D77,0x8A43,      // <cjk>
      0x6D78,0x905A,      // <cjk>
      0x6D79,0x9FB3,      // <cjk>
      0x6D85,0x9FB8,      // <cjk>
      0x6D88,0x8FC1,      // <cjk>
      0x6D8C,0x974F,      // <cjk>
      0x6D8E,0x9FB5,      // <cjk>
      0x6D93,0x9FB0,      // <cjk>
      0x6D95,0x9FB6,      // <cjk>
      0x6D99,0x97DC,      // <cjk>
      0x6D9B,0x9393,      // <cjk>
      0x6D9C,0x93C0,      // <cjk>
      0x6DAF,0x8A55,      // <cjk>
      0x6DB2,0x8974,      // <cjk>
      0x6DB5,0x9FBC,      // <cjk>
      0x6DB8,0x9FBF,      // <cjk>
      0x6DBC,0x97C1,      // <cjk>
      0x6DC0,0x9784,      // <cjk>
      0x6DC5,0x9FC6,      // <cjk>
      0x6DC6,0x9FC0,      // <cjk>
      0x6DC7,0x9FBD,      // <cjk>
      0x6DCB,0x97D2,      // <cjk>
      0x6DCC,0x9FC3,      // <cjk>
      0x6DD1,0x8F69,      // <cjk>
      0x6DD2,0x9FC5,      // <cjk>
      0x6DD5,0x9FCA,      // <cjk>
      0x6DD8,0x9391,      // <cjk>
      0x6DD9,0x9FC8,      // <cjk>
      0x6DDE,0x9FC2,      // <cjk>
      0x6DE1,0x9257,      // <cjk>
      0x6DE4,0x9FC9,      // <cjk>
      0x6DE6,0x9FBE,      // <cjk>
      0x6DE8,0x9FC4,      // <cjk>
      0x6DEA,0x9FCB,      // <cjk>
      0x6DEB,0x88FA,      // <cjk>
      0x6DEC,0x9FC1,      // <cjk>
      0x6DEE,0x9FCC,      // <cjk>
      0x6DF3,0x8F7E,      // <cjk>
      0x6DF5,0x95A3,      // <cjk>
      0x6DF7,0x8DAC,      // <cjk>
      0x6DF9,0x9FB9,      // <cjk>
      0x6DFA,0x9FC7,      // <cjk>
      0x6DFB,0x9359,      // <cjk>
      0x6E05,0x90B4,      // <cjk>
      0x6E07,0x8A89,      // <cjk>
      0x6E08,0x8DCF,      // <cjk>
      0x6E09,0x8FC2,      // <cjk>
      0x6E0A,0x9FBB,      // <cjk>
      0x6E0B,0x8F61,      // <cjk>
      0x6E13,0x8C6B,      // <cjk>
      0x6E15,0x9FBA,      // <cjk>
      0x6E19,0x9FD0,      // <cjk>
      0x6E1A,0x8F8D,      // <cjk>
      0x6E1B,0x8CB8,      // <cjk>
      0x6E1D,0x9FDF,      // <cjk>
      0x6E1F,0x9FD9,      // <cjk>
      0x6E20,0x8B94,      // <cjk>
      0x6E21,0x936E,      // <cjk>
      0x6E23,0x9FD4,      // <cjk>
      0x6E24,0x9FDD,      // <cjk>
      0x6E25,0x88AD,      // <cjk>
      0x6E26,0x8951,      // <cjk>
      0x6E29,0x89B7,      // <cjk>
      0x6E2B,0x9FD6,      // <cjk>
      0x6E2C,0x91AA,      // <cjk>
      0x6E2D,0x9FCD,      // <cjk>
      0x6E2E,0x9FCF,      // <cjk>
      0x6E2F,0x8D60,      // <cjk>
      0x6E38,0x9FE0,      // <cjk>
      0x6E3A,0x9FDB,      // <cjk>
      0x6E3E,0x9FD3,      // <cjk>
      0x6E43,0x9FDA,      // <cjk>
      0x6E4A,0x96A9,      // <cjk>
      0x6E4D,0x9FD8,      // <cjk>
      0x6E4E,0x9FDC,      // <cjk>
      0x6E56,0x8CCE,      // <cjk>
      0x6E58,0x8FC3,      // <cjk>
      0x6E5B,0x9258,      // <cjk>
      0x6E5F,0x9FD2,      // <cjk>
      0x6E67,0x974E,      // <cjk>
      0x6E6B,0x9FD5,      // <cjk>
      0x6E6E,0x9FCE,      // <cjk>
      0x6E6F,0x9392,      // <cjk>
      0x6E72,0x9FD1,      // <cjk>
      0x6E76,0x9FD7,      // <cjk>
      0x6E7E,0x9870,      // <cjk>
      0x6E7F,0x8EBC,      // <cjk>
      0x6E80,0x969E,      // <cjk>
      0x6E82,0x9FE1,      // <cjk>
      0x6E8C,0x94AC,      // <cjk>
      0x6E8F,0x9FED,      // <cjk>
      0x6E90,0x8CB9,      // <cjk>
      0x6E96,0x8F80,      // <cjk>
      0x6E98,0x9FE3,      // <cjk>
      0x6E9C,0x97AD,      // <cjk>
      0x6E9D,0x8D61,      // <cjk>
      0x6E9F,0x9FF0,      // <cjk>
      0x6EA2,0x88EC,      // <cjk>
      0x6EA5,0x9FEE,      // <cjk>
      0x6EAA,0x9FE2,      // <cjk>
      0x6EAF,0x9FE8,      // <cjk>
      0x6EB2,0x9FEA,      // <cjk>
      0x6EB6,0x976E,      // <cjk>
      0x6EB7,0x9FE5,      // <cjk>
      0x6EBA,0x934D,      // <cjk>
      0x6EBD,0x9FE7,      // <cjk>
      0x6EC2,0x9FEF,      // <cjk>
      0x6EC4,0x9FE9,      // <cjk>
      0x6EC5,0x96C5,      // <cjk>
      0x6EC9,0x9FE4,      // <cjk>
      0x6ECB,0x8EA0,      // <cjk>
      0x6ECC,0x9FFC,      // <cjk>
      0x6ED1,0x8A8A,      // <cjk>
      0x6ED3,0x9FE6,      // <cjk>
      0x6ED4,0x9FEB,      // <cjk>
      0x6ED5,0x9FEC,      // <cjk>
      0x6EDD,0x91EA,      // <cjk>
      0x6EDE,0x91D8,      // <cjk>
      0x6EEC,0x9FF4,      // <cjk>
      0x6EEF,0x9FFA,      // <cjk>
      0x6EF2,0x9FF8,      // <cjk>
      0x6EF4,0x9348,      // <cjk>
      0x6EF7,0xE042,      // <cjk>
      0x6EF8,0x9FF5,      // <cjk>
      0x6EFE,0x9FF6,      // <cjk>
      0x6EFF,0x9FDE,      // <cjk>
      0x6F01,0x8B99,      // <cjk>
      0x6F02,0x9559,      // <cjk>
      0x6F06,0x8EBD,      // <cjk>
      0x6F09,0x8D97,      // <cjk>
      0x6F0F,0x9852,      // <cjk>
      0x6F11,0x9FF2,      // <cjk>
      0x6F13,0xE041,      // <cjk>
      0x6F14,0x8989,      // <cjk>
      0x6F15,0x9186,      // <cjk>
      0x6F20,0x9499,      // <cjk>
      0x6F22,0x8ABF,      // <cjk>
      0x6F23,0x97F8,      // <cjk>
      0x6F2B,0x969F,      // <cjk>
      0x6F2C,0x92D0,      // <cjk>
      0x6F31,0x9FF9,      // <cjk>
      0x6F32,0x9FFB,      // <cjk>
      0x6F38,0x9151,      // <cjk>
      0x6F3E,0xE040,      // <cjk>
      0x6F3F,0x9FF7,      // <cjk>
      0x6F41,0x9FF1,      // <cjk>
      0x6F45,0x8AC1,      // <cjk>
      0x6F54,0x8C89,      // <cjk>
      0x6F58,0xE04E,      // <cjk>
      0x6F5B,0xE049,      // <cjk>
      0x6F5C,0x90F6,      // <cjk>
      0x6F5F,0x8A83,      // <cjk>
      0x6F64,0x8F81,      // <cjk>
      0x6F66,0xE052,      // <cjk>
      0x6F6D,0xE04B,      // <cjk>
      0x6F6E,0x92AA,      // <cjk>
      0x6F6F,0xE048,      // <cjk>
      0x6F70,0x92D7,      // <cjk>
      0x6F74,0xE06B,      // <cjk>
      0x6F78,0xE045,      // <cjk>
      0x6F7A,0xE044,      // <cjk>
      0x6F7C,0xE04D,      // <cjk>
      0x6F80,0xE047,      // <cjk>
      0x6F81,0xE046,      // <cjk>
      0x6F82,0xE04C,      // <cjk>
      0x6F84,0x909F,      // <cjk>
      0x6F86,0xE043,      // <cjk>
      0x6F8E,0xE04F,      // <cjk>
      0x6F91,0xE050,      // <cjk>
      0x6F97,0x8AC0,      // <cjk>
      0x6FA1,0xE055,      // <cjk>
      0x6FA3,0xE054,      // <cjk>
      0x6FA4,0xE056,      // <cjk>
      0x6FAA,0xE059,      // <cjk>
      0x6FB1,0x9362,      // <cjk>
      0x6FB3,0xE053,      // <cjk>
      0x6FB9,0xE057,      // <cjk>
      0x6FC0,0x8C83,      // <cjk>
      0x6FC1,0x91F7,      // <cjk>
      0x6FC2,0xE051,      // <cjk>
      0x6FC3,0x945A,      // <cjk>
      0x6FC6,0xE058,      // <cjk>
      0x6FD4,0xE05D,      // <cjk>
      0x6FD8,0xE05E,      // <cjk>
      0x6FDB,0xE061,      // <cjk>
      0x6FDF,0xE05A,      // <cjk>
      0x6FE0,0x8D8A,      // <cjk>
      0x6FE1,0x9447,      // <cjk>
      0x6FE4,0x9FB7,      // <cjk>
      0x6FEB,0x9794,      // <cjk>
      0x6FEC,0xE05C,      // <cjk>
      0x6FEE,0xE060,      // <cjk>
      0x6FEF,0x91F3,      // <cjk>
      0x6FF1,0xE05F,      // <cjk>
      0x6FF3,0xE04A,      // <cjk>
      0x6FF6,0xE889,      // <cjk>
      0x6FFA,0xE064,      // <cjk>
      0x6FFE,0xE068,      // <cjk>
      0x7001,0xE066,      // <cjk>
      0x7009,0xE062,      // <cjk>
      0x700B,0xE063,      // <cjk>
      0x700F,0xE067,      // <cjk>
      0x7011,0xE065,      // <cjk>
      0x7015,0x956D,      // <cjk>
      0x7018,0xE06D,      // <cjk>
      0x701A,0xE06A,      // <cjk>
      0x701B,0xE069,      // <cjk>
      0x701D,0xE06C,      // <cjk>
      0x701E,0x93D2,      // <cjk>
      0x701F,0xE06E,      // <cjk>
      0x7026,0x9295,      // <cjk>
      0x7027,0x91EB,      // <cjk>
      0x702C,0x90A3,      // <cjk>
      0x7030,0xE06F,      // <cjk>
      0x7032,0xE071,      // <cjk>
      0x703E,0xE070,      // <cjk>
      0x704C,0x9FF3,      // <cjk>
      0x7051,0xE072,      // <cjk>
      0x7058,0x93E5,      // <cjk>
      0x7063,0xE073,      // <cjk>
      0x706B,0x89CE,      // <cjk>
      0x706F,0x9394,      // <cjk>
      0x7070,0x8A44,      // <cjk>
      0x7078,0x8B84,      // <cjk>
      0x707C,0x8EDC,      // <cjk>
      0x707D,0x8DD0,      // <cjk>
      0x7089,0x9846,      // <cjk>
      0x708A,0x9086,      // <cjk>
      0x708E,0x898A,      // <cjk>
      0x7092,0xE075,      // <cjk>
      0x7099,0xE074,      // <cjk>
      0x70AC,0xE078,      // <cjk>
      0x70AD,0x9259,      // <cjk>
      0x70AE,0xE07B,      // <cjk>
      0x70AF,0xE076,      // <cjk>
      0x70B3,0xE07A,      // <cjk>
      0x70B8,0xE079,      // <cjk>
      0x70B9,0x935F,      // <cjk>
      0x70BA,0x88D7,      // <cjk>
      0x70C8,0x97F3,      // <cjk>
      0x70CB,0xE07D,      // <cjk>
      0x70CF,0x8947,      // <cjk>
      0x70D9,0xE080,      // <cjk>
      0x70DD,0xE07E,      // <cjk>
      0x70DF,0xE07C,      // <cjk>
      0x70F1,0xE077,      // <cjk>
      0x70F9,0x9642,      // <cjk>
      0x70FD,0xE082,      // <cjk>
      0x7109,0xE081,      // <cjk>
      0x7114,0x898B,      // <cjk>
      0x7119,0xE084,      // <cjk>
      0x711A,0x95B0,      // <cjk>
      0x711C,0xE083,      // <cjk>
      0x7121,0x96B3,      // <cjk>
      0x7126,0x8FC5,      // <cjk>
      0x7136,0x9152,      // <cjk>
      0x713C,0x8FC4,      // <cjk>
      0x7149,0x97F9,      // <cjk>
      0x714C,0xE08A,      // <cjk>
      0x714E,0x90F7,      // <cjk>
      0x7155,0xE086,      // <cjk>
      0x7156,0xE08B,      // <cjk>
      0x7159,0x898C,      // <cjk>
      0x7162,0xE089,      // <cjk>
      0x7164,0x9481,      // <cjk>
      0x7165,0xE085,      // <cjk>
      0x7166,0xE088,      // <cjk>
      0x7167,0x8FC6,      // <cjk>
      0x7169,0x94CF,      // <cjk>
      0x716C,0xE08C,      // <cjk>
      0x716E,0x8ECF,      // <cjk>
      0x717D,0x90F8,      // <cjk>
      0x7184,0xE08F,      // <cjk>
      0x7188,0xE087,      // <cjk>
      0x718A,0x8C46,      // <cjk>
      0x718F,0xE08D,      // <cjk>
      0x7194,0x976F,      // <cjk>
      0x7195,0xE090,      // <cjk>
      0x7199,0xEAA4,      // <cjk>
      0x719F,0x8F6E,      // <cjk>
      0x71A8,0xE091,      // <cjk>
      0x71AC,0xE092,      // <cjk>
      0x71B1,0x944D,      // <cjk>
      0x71B9,0xE094,      // <cjk>
      0x71BE,0xE095,      // <cjk>
      0x71C3,0x9452,      // <cjk>
      0x71C8,0x9395,      // <cjk>
      0x71C9,0xE097,      // <cjk>
      0x71CE,0xE099,      // <cjk>
      0x71D0,0x97D3,      // <cjk>
      0x71D2,0xE096,      // <cjk>
      0x71D4,0xE098,      // <cjk>
      0x71D5,0x898D,      // <cjk>
      0x71D7,0xE093,      // <cjk>
      0x71DF,0x9A7A,      // <cjk>
      0x71E0,0xE09A,      // <cjk>
      0x71E5,0x9187,      // <cjk>
      0x71E6,0x8E57,      // <cjk>
      0x71E7,0xE09C,      // <cjk>
      0x71EC,0xE09B,      // <cjk>
      0x71ED,0x9043,      // <cjk>
      0x71EE,0x99D7,      // <cjk>
      0x71F5,0xE09D,      // <cjk>
      0x71F9,0xE09F,      // <cjk>
      0x71FB,0xE08E,      // <cjk>
      0x71FC,0xE09E,      // <cjk>
      0x71FF,0xE0A0,      // <cjk>
      0x7206,0x949A,      // <cjk>
      0x720D,0xE0A1,      // <cjk>
      0x7210,0xE0A2,      // <cjk>
      0x721B,0xE0A3,      // <cjk>
      0x7228,0xE0A4,      // <cjk>
      0x722A,0x92DC,      // <cjk>
      0x722C,0xE0A6,      // <cjk>
      0x722D,0xE0A5,      // <cjk>
      0x7230,0xE0A7,      // <cjk>
      0x7232,0xE0A8,      // <cjk>
      0x7235,0x8EDD,      // <cjk>
      0x7236,0x9583,      // <cjk>
      0x723A,0x96EA,      // <cjk>
      0x723B,0xE0A9,      // <cjk>
      0x723C,0xE0AA,      // <cjk>
      0x723D,0x9175,      // <cjk>
      0x723E,0x8EA2,      // <cjk>
      0x723F,0xE0AB,      // <cjk>
      0x7240,0xE0AC,      // <cjk>
      0x7246,0xE0AD,      // <cjk>
      0x7247,0x95D0,      // <cjk>
      0x7248,0x94C5,      // <cjk>
      0x724B,0xE0AE,      // <cjk>
      0x724C,0x9476,      // <cjk>
      0x7252,0x92AB,      // <cjk>
      0x7258,0xE0AF,      // <cjk>
      0x7259,0x89E5,      // <cjk>
      0x725B,0x8B8D,      // <cjk>
      0x725D,0x96C4,      // <cjk>
      0x725F,0x96B4,      // <cjk>
      0x7261,0x89B2,      // <cjk>
      0x7262,0x9853,      // <cjk>
      0x7267,0x9671,      // <cjk>
      0x7269,0x95A8,      // <cjk>
      0x7272,0x90B5,      // <cjk>
      0x7274,0xE0B0,      // <cjk>
      0x7279,0x93C1,      // <cjk>
      0x727D,0x8CA1,      // <cjk>
      0x727E,0xE0B1,      // <cjk>
      0x7280,0x8DD2,      // <cjk>
      0x7281,0xE0B3,      // <cjk>
      0x7282,0xE0B2,      // <cjk>
      0x7287,0xE0B4,      // <cjk>
      0x7292,0xE0B5,      // <cjk>
      0x7296,0xE0B6,      // <cjk>
      0x72A0,0x8B5D,      // <cjk>
      0x72A2,0xE0B7,      // <cjk>
      0x72A7,0xE0B8,      // <cjk>
      0x72AC,0x8CA2,      // <cjk>
      0x72AF,0x94C6,      // <cjk>
      0x72B2,0xE0BA,      // <cjk>
      0x72B6,0x8FF3,      // <cjk>
      0x72B9,0xE0B9,      // <cjk>
      0x72C2,0x8BB6,      // <cjk>
      0x72C3,0xE0BB,      // <cjk>
      0x72C4,0xE0BD,      // <cjk>
      0x72C6,0xE0BC,      // <cjk>
      0x72CE,0xE0BE,      // <cjk>
      0x72D0,0x8CCF,      // <cjk>
      0x72D2,0xE0BF,      // <cjk>
      0x72D7,0x8BE7,      // <cjk>
      0x72D9,0x915F,      // <cjk>
      0x72DB,0x8D9D,      // <cjk>
      0x72E0,0xE0C1,      // <cjk>
      0x72E1,0xE0C2,      // <cjk>
      0x72E2,0xE0C0,      // <cjk>
      0x72E9,0x8EEB,      // <cjk>
      0x72EC,0x93C6,      // <cjk>
      0x72ED,0x8BB7,      // <cjk>
      0x72F7,0xE0C4,      // <cjk>
      0x72F8,0x924B,      // <cjk>
      0x72F9,0xE0C3,      // <cjk>
      0x72FC,0x9854,      // <cjk>
      0x72FD,0x9482,      // <cjk>
      0x730A,0xE0C7,      // <cjk>
      0x7316,0xE0C9,      // <cjk>
      0x7317,0xE0C6,      // <cjk>
      0x731B,0x96D2,      // <cjk>
      0x731C,0xE0C8,      // <cjk>
      0x731D,0xE0CA,      // <cjk>
      0x731F,0x97C2,      // <cjk>
      0x7325,0xE0CE,      // <cjk>
      0x7329,0xE0CD,      // <cjk>
      0x732A,0x9296,      // <cjk>
      0x732B,0x944C,      // <cjk>
      0x732E,0x8CA3,      // <cjk>
      0x732F,0xE0CC,      // <cjk>
      0x7334,0xE0CB,      // <cjk>
      0x7336,0x9750,      // <cjk>
      0x7337,0x9751,      // <cjk>
      0x733E,0xE0CF,      // <cjk>
      0x733F,0x898E,      // <cjk>
      0x7344,0x8D96,      // <cjk>
      0x7345,0x8E82,      // <cjk>
      0x734E,0xE0D0,      // <cjk>
      0x734F,0xE0D1,      // <cjk>
      0x7357,0xE0D3,      // <cjk>
      0x7363,0x8F62,      // <cjk>
      0x7368,0xE0D5,      // <cjk>
      0x736A,0xE0D4,      // <cjk>
      0x7370,0xE0D6,      // <cjk>
      0x7372,0x8A6C,      // <cjk>
      0x7375,0xE0D8,      // <cjk>
      0x7378,0xE0D7,      // <cjk>
      0x737A,0xE0DA,      // <cjk>
      0x737B,0xE0D9,      // <cjk>
      0x7384,0x8CBA,      // <cjk>
      0x7387,0x97A6,      // <cjk>
      0x7389,0x8BCA,      // <cjk>
      0x738B,0x89A4,      // <cjk>
      0x7396,0x8BE8,      // <cjk>
      0x73A9,0x8ADF,      // <cjk>
      0x73B2,0x97E6,      // <cjk>
      0x73B3,0xE0DC,      // <cjk>
      0x73BB,0xE0DE,      // <cjk>
      0x73C0,0xE0DF,      // <cjk>
      0x73C2,0x89CF,      // <cjk>
      0x73C8,0xE0DB,      // <cjk>
      0x73CA,0x8E58,      // <cjk>
      0x73CD,0x92BF,      // <cjk>
      0x73CE,0xE0DD,      // <cjk>
      0x73DE,0xE0E2,      // <cjk>
      0x73E0,0x8EEC,      // <cjk>
      0x73E5,0xE0E0,      // <cjk>
      0x73EA,0x8C5D,      // <cjk>
      0x73ED,0x94C7,      // <cjk>
      0x73EE,0xE0E1,      // <cjk>
      0x73F1,0xE0FC,      // <cjk>
      0x73F8,0xE0E7,      // <cjk>
      0x73FE,0x8CBB,      // <cjk>
      0x7403,0x8B85,      // <cjk>
      0x7405,0xE0E4,      // <cjk>
      0x7406,0x979D,      // <cjk>
      0x7409,0x97AE,      // <cjk>
      0x7422,0x91F4,      // <cjk>
      0x7425,0xE0E6,      // <cjk>
      0x7432,0xE0E8,      // <cjk>
      0x7433,0x97D4,      // <cjk>
      0x7434,0x8BD5,      // <cjk>
      0x7435,0x94FA,      // <cjk>
      0x7436,0x9469,      // <cjk>
      0x743A,0xE0E9,      // <cjk>
      0x743F,0xE0EB,      // <cjk>
      0x7441,0xE0EE,      // <cjk>
      0x7455,0xE0EA,      // <cjk>
      0x7459,0xE0ED,      // <cjk>
      0x745A,0x8CE8,      // <cjk>
      0x745B,0x896C,      // <cjk>
      0x745C,0xE0EF,      // <cjk>
      0x745E,0x9090,      // <cjk>
      0x745F,0xE0EC,      // <cjk>
      0x7460,0x97DA,      // <cjk>
      0x7463,0xE0F2,      // <cjk>
      0x7464,0xEAA2,      // <cjk>
      0x7469,0xE0F0,      // <cjk>
      0x746A,0xE0F3,      // <cjk>
      0x746F,0xE0E5,      // <cjk>
      0x7470,0xE0F1,      // <cjk>
      0x7473,0x8DBA,      // <cjk>
      0x7476,0xE0F4,      // <cjk>
      0x747E,0xE0F5,      // <cjk>
      0x7483,0x979E,      // <cjk>
      0x748B,0xE0F6,      // <cjk>
      0x749E,0xE0F7,      // <cjk>
      0x74A2,0xE0E3,      // <cjk>
      0x74A7,0xE0F8,      // <cjk>
      0x74B0,0x8AC2,      // <cjk>
      0x74BD,0x8EA3,      // <cjk>
      0x74CA,0xE0F9,      // <cjk>
      0x74CF,0xE0FA,      // <cjk>
      0x74D4,0xE0FB,      // <cjk>
      0x74DC,0x895A,      // <cjk>
      0x74E0,0xE140,      // <cjk>
      0x74E2,0x955A,      // <cjk>
      0x74E3,0xE141,      // <cjk>
      0x74E6,0x8AA2,      // <cjk>
      0x74E7,0xE142,      // <cjk>
      0x74E9,0xE143,      // <cjk>
      0x74EE,0xE144,      // <cjk>
      0x74F0,0xE146,      // <cjk>
      0x74F1,0xE147,      // <cjk>
      0x74F2,0xE145,      // <cjk>
      0x74F6,0x9572,      // <cjk>
      0x74F7,0xE149,      // <cjk>
      0x74F8,0xE148,      // <cjk>
      0x7503,0xE14B,      // <cjk>
      0x7504,0xE14A,      // <cjk>
      0x7505,0xE14C,      // <cjk>
      0x750C,0xE14D,      // <cjk>
      0x750D,0xE14F,      // <cjk>
      0x750E,0xE14E,      // <cjk>
      0x7511,0x8D99,      // <cjk>
      0x7513,0xE151,      // <cjk>
      0x7515,0xE150,      // <cjk>
      0x7518,0x8AC3,      // <cjk>
      0x751A,0x9072,      // <cjk>
      0x751E,0xE152,      // <cjk>
      0x751F,0x90B6,      // <cjk>
      0x7523,0x8E59,      // <cjk>
      0x7525,0x8999,      // <cjk>
      0x7526,0xE153,      // <cjk>
      0x7528,0x9770,      // <cjk>
      0x752B,0x95E1,      // <cjk>
      0x752C,0xE154,      // <cjk>
      0x7530,0x9363,      // <cjk>
      0x7531,0x9752,      // <cjk>
      0x7532,0x8D62,      // <cjk>
      0x7533,0x905C,      // <cjk>
      0x7537,0x926A,      // <cjk>
      0x7538,0x99B2,      // <cjk>
      0x753A,0x92AC,      // <cjk>
      0x753B,0x89E6,      // <cjk>
      0x753C,0xE155,      // <cjk>
      0x7544,0xE156,      // <cjk>
      0x7549,0xE159,      // <cjk>
      0x754A,0xE158,      // <cjk>
      0x754B,0x9DC0,      // <cjk>
      0x754C,0x8A45,      // <cjk>
      0x754D,0xE157,      // <cjk>
      0x754F,0x88D8,      // <cjk>
      0x7551,0x94A8,      // <cjk>
      0x7554,0x94C8,      // <cjk>
      0x7559,0x97AF,      // <cjk>
      0x755A,0xE15C,      // <cjk>
      0x755B,0xE15A,      // <cjk>
      0x755C,0x927B,      // <cjk>
      0x755D,0x90A4,      // <cjk>
      0x7560,0x94A9,      // <cjk>
      0x7562,0x954C,      // <cjk>
      0x7564,0xE15E,      // <cjk>
      0x7565,0x97AA,      // <cjk>
      0x7566,0x8C6C,      // <cjk>
      0x7567,0xE15F,      // <cjk>
      0x7569,0xE15D,      // <cjk>
      0x756A,0x94D4,      // <cjk>
      0x756B,0xE160,      // <cjk>
      0x756D,0xE161,      // <cjk>
      0x7570,0x88D9,      // <cjk>
      0x7573,0x8FF4,      // <cjk>
      0x7574,0xE166,      // <cjk>
      0x7576,0xE163,      // <cjk>
      0x7577,0x93EB,      // <cjk>
      0x7578,0xE162,      // <cjk>
      0x757F,0x8B45,      // <cjk>
      0x7582,0xE169,      // <cjk>
      0x7586,0xE164,      // <cjk>
      0x7587,0xE165,      // <cjk>
      0x7589,0xE168,      // <cjk>
      0x758A,0xE167,      // <cjk>
      0x758B,0x9544,      // <cjk>
      0x758E,0x9161,      // <cjk>
      0x758F,0x9160,      // <cjk>
      0x7591,0x8B5E,      // <cjk>
      0x7594,0xE16A,      // <cjk>
      0x759A,0xE16B,      // <cjk>
      0x759D,0xE16C,      // <cjk>
      0x75A3,0xE16E,      // <cjk>
      0x75A5,0xE16D,      // <cjk>
      0x75AB,0x8975,      // <cjk>
      0x75B1,0xE176,      // <cjk>
      0x75B2,0x94E6,      // <cjk>
      0x75B3,0xE170,      // <cjk>
      0x75B5,0xE172,      // <cjk>
      0x75B8,0xE174,      // <cjk>
      0x75B9,0x905D,      // <cjk>
      0x75BC,0xE175,      // <cjk>
      0x75BD,0xE173,      // <cjk>
      0x75BE,0x8EBE,      // <cjk>
      0x75C2,0xE16F,      // <cjk>
      0x75C3,0xE171,      // <cjk>
      0x75C5,0x9561,      // <cjk>
      0x75C7,0x8FC7,      // <cjk>
      0x75CA,0xE178,      // <cjk>
      0x75CD,0xE177,      // <cjk>
      0x75D2,0xE179,      // <cjk>
      0x75D4,0x8EA4,      // <cjk>
      0x75D5,0x8DAD,      // <cjk>
      0x75D8,0x9397,      // <cjk>
      0x75D9,0xE17A,      // <cjk>
      0x75DB,0x92C9,      // <cjk>
      0x75DE,0xE17C,      // <cjk>
      0x75E2,0x979F,      // <cjk>
      0x75E3,0xE17B,      // <cjk>
      0x75E9,0x9189,      // <cjk>
      0x75F0,0xE182,      // <cjk>
      0x75F2,0xE184,      // <cjk>
      0x75F3,0xE185,      // <cjk>
      0x75F4,0x9273,      // <cjk>
      0x75FA,0xE183,      // <cjk>
      0x75FC,0xE180,      // <cjk>
      0x75FE,0xE17D,      // <cjk>
      0x75FF,0xE17E,      // <cjk>
      0x7601,0xE181,      // <cjk>
      0x7609,0xE188,      // <cjk>
      0x760B,0xE186,      // <cjk>
      0x760D,0xE187,      // <cjk>
      0x761F,0xE189,      // <cjk>
      0x7620,0xE18B,      // <cjk>
      0x7621,0xE18C,      // <cjk>
      0x7622,0xE18D,      // <cjk>
      0x7624,0xE18E,      // <cjk>
      0x7627,0xE18A,      // <cjk>
      0x7630,0xE190,      // <cjk>
      0x7634,0xE18F,      // <cjk>
      0x763B,0xE191,      // <cjk>
      0x7642,0x97C3,      // <cjk>
      0x7646,0xE194,      // <cjk>
      0x7647,0xE192,      // <cjk>
      0x7648,0xE193,      // <cjk>
      0x764C,0x8AE0,      // <cjk>
      0x7652,0x96FC,      // <cjk>
      0x7656,0x95C8,      // <cjk>
      0x7658,0xE196,      // <cjk>
      0x765C,0xE195,      // <cjk>
      0x7661,0xE197,      // <cjk>
      0x7662,0xE198,      // <cjk>
      0x7667,0xE19C,      // <cjk>
      0x7668,0xE199,      // <cjk>
      0x7669,0xE19A,      // <cjk>
      0x766A,0xE19B,      // <cjk>
      0x766C,0xE19D,      // <cjk>
      0x7670,0xE19E,      // <cjk>
      0x7672,0xE19F,      // <cjk>
      0x7676,0xE1A0,      // <cjk>
      0x7678,0xE1A1,      // <cjk>
      0x767A,0x94AD,      // <cjk>
      0x767B,0x936F,      // <cjk>
      0x767C,0xE1A2,      // <cjk>
      0x767D,0x9492,      // <cjk>
      0x767E,0x9553,      // <cjk>
      0x7680,0xE1A3,      // <cjk>
      0x7683,0xE1A4,      // <cjk>
      0x7684,0x9349,      // <cjk>
      0x7686,0x8A46,      // <cjk>
      0x7687,0x8D63,      // <cjk>
      0x7688,0xE1A5,      // <cjk>
      0x768B,0xE1A6,      // <cjk>
      0x768E,0xE1A7,      // <cjk>
      0x7690,0x8E48,      // <cjk>
      0x7693,0xE1A9,      // <cjk>
      0x7696,0xE1A8,      // <cjk>
      0x7699,0xE1AA,      // <cjk>
      0x769A,0xE1AB,      // <cjk>
      0x76AE,0x94E7,      // <cjk>
      0x76B0,0xE1AC,      // <cjk>
      0x76B4,0xE1AD,      // <cjk>
      0x76B7,0xEA89,      // <cjk>
      0x76B8,0xE1AE,      // <cjk>
      0x76B9,0xE1AF,      // <cjk>
      0x76BA,0xE1B0,      // <cjk>
      0x76BF,0x8E4D,      // <cjk>
      0x76C2,0xE1B1,      // <cjk>
      0x76C3,0x9475,      // <cjk>
      0x76C6,0x967E,      // <cjk>
      0x76C8,0x896D,      // <cjk>
      0x76CA,0x8976,      // <cjk>
      0x76CD,0xE1B2,      // <cjk>
      0x76D2,0xE1B4,      // <cjk>
      0x76D6,0xE1B3,      // <cjk>
      0x76D7,0x9390,      // <cjk>
      0x76DB,0x90B7,      // <cjk>
      0x76DC,0x9F58,      // <cjk>
      0x76DE,0xE1B5,      // <cjk>
      0x76DF,0x96BF,      // <cjk>
      0x76E1,0xE1B6,      // <cjk>
      0x76E3,0x8AC4,      // <cjk>
      0x76E4,0x94D5,      // <cjk>
      0x76E5,0xE1B7,      // <cjk>
      0x76E7,0xE1B8,      // <cjk>
      0x76EA,0xE1B9,      // <cjk>
      0x76EE,0x96DA,      // <cjk>
      0x76F2,0x96D3,      // <cjk>
      0x76F4,0x92BC,      // <cjk>
      0x76F8,0x918A,      // <cjk>
      0x76FB,0xE1BB,      // <cjk>
      0x76FE,0x8F82,      // <cjk>
      0x7701,0x8FC8,      // <cjk>
      0x7704,0xE1BE,      // <cjk>
      0x7707,0xE1BD,      // <cjk>
      0x7708,0xE1BC,      // <cjk>
      0x7709,0x94FB,      // <cjk>
      0x770B,0x8AC5,      // <cjk>
      0x770C,0x8CA7,      // <cjk>
      0x771B,0xE1C4,      // <cjk>
      0x771E,0xE1C1,      // <cjk>
      0x771F,0x905E,      // <cjk>
      0x7720,0x96B0,      // <cjk>
      0x7724,0xE1C0,      // <cjk>
      0x7725,0xE1C2,      // <cjk>
      0x7726,0xE1C3,      // <cjk>
      0x7729,0xE1BF,      // <cjk>
      0x7737,0xE1C5,      // <cjk>
      0x7738,0xE1C6,      // <cjk>
      0x773A,0x92AD,      // <cjk>
      0x773C,0x8AE1,      // <cjk>
      0x7740,0x9285,      // <cjk>
      0x7747,0xE1C7,      // <cjk>
      0x775A,0xE1C8,      // <cjk>
      0x775B,0xE1CB,      // <cjk>
      0x7761,0x9087,      // <cjk>
      0x7763,0x93C2,      // <cjk>
      0x7765,0xE1CC,      // <cjk>
      0x7766,0x9672,      // <cjk>
      0x7768,0xE1C9,      // <cjk>
      0x776B,0xE1CA,      // <cjk>
      0x7779,0xE1CF,      // <cjk>
      0x777E,0xE1CE,      // <cjk>
      0x777F,0xE1CD,      // <cjk>
      0x778B,0xE1D1,      // <cjk>
      0x778E,0xE1D0,      // <cjk>
      0x7791,0xE1D2,      // <cjk>
      0x779E,0xE1D4,      // <cjk>
      0x77A0,0xE1D3,      // <cjk>
      0x77A5,0x95CB,      // <cjk>
      0x77AC,0x8F75,      // <cjk>
      0x77AD,0x97C4,      // <cjk>
      0x77B0,0xE1D5,      // <cjk>
      0x77B3,0x93B5,      // <cjk>
      0x77B6,0xE1D6,      // <cjk>
      0x77B9,0xE1D7,      // <cjk>
      0x77BB,0xE1DB,      // <cjk>
      0x77BC,0xE1D9,      // <cjk>
      0x77BD,0xE1DA,      // <cjk>
      0x77BF,0xE1D8,      // <cjk>
      0x77C7,0xE1DC,      // <cjk>
      0x77CD,0xE1DD,      // <cjk>
      0x77D7,0xE1DE,      // <cjk>
      0x77DA,0xE1DF,      // <cjk>
      0x77DB,0x96B5,      // <cjk>
      0x77DC,0xE1E0,      // <cjk>
      0x77E2,0x96EE,      // <cjk>
      0x77E3,0xE1E1,      // <cjk>
      0x77E5,0x926D,      // <cjk>
      0x77E7,0x948A,      // <cjk>
      0x77E9,0x8BE9,      // <cjk>
      0x77ED,0x925A,      // <cjk>
      0x77EE,0xE1E2,      // <cjk>
      0x77EF,0x8BB8,      // <cjk>
      0x77F3,0x90CE,      // <cjk>
      0x77FC,0xE1E3,      // <cjk>
      0x7802,0x8DBB,      // <cjk>
      0x780C,0xE1E4,      // <cjk>
      0x7812,0xE1E5,      // <cjk>
      0x7814,0x8CA4,      // <cjk>
      0x7815,0x8DD3,      // <cjk>
      0x7820,0xE1E7,      // <cjk>
      0x7825,0x9375,      // <cjk>
      0x7826,0x8DD4,      // <cjk>
      0x7827,0x8B6D,      // <cjk>
      0x7832,0x9643,      // <cjk>
      0x7834,0x946A,      // <cjk>
      0x783A,0x9376,      // <cjk>
      0x783F,0x8D7B,      // <cjk>
      0x7845,0xE1E9,      // <cjk>
      0x785D,0x8FC9,      // <cjk>
      0x786B,0x97B0,      // <cjk>
      0x786C,0x8D64,      // <cjk>
      0x786F,0x8CA5,      // <cjk>
      0x7872,0x94A1,      // <cjk>
      0x7874,0xE1EB,      // <cjk>
      0x787C,0xE1ED,      // <cjk>
      0x7881,0x8CE9,      // <cjk>
      0x7886,0xE1EC,      // <cjk>
      0x7887,0x92F4,      // <cjk>
      0x788C,0xE1EF,      // <cjk>
      0x788D,0x8A56,      // <cjk>
      0x788E,0xE1EA,      // <cjk>
      0x7891,0x94E8,      // <cjk>
      0x7893,0x894F,      // <cjk>
      0x7895,0x8DEA,      // <cjk>
      0x7897,0x9871,      // <cjk>
      0x789A,0xE1EE,      // <cjk>
      0x78A3,0xE1F0,      // <cjk>
      0x78A7,0x95C9,      // <cjk>
      0x78A9,0x90D7,      // <cjk>
      0x78AA,0xE1F2,      // <cjk>
      0x78AF,0xE1F3,      // <cjk>
      0x78B5,0xE1F1,      // <cjk>
      0x78BA,0x8A6D,      // <cjk>
      0x78BC,0xE1F9,      // <cjk>
      0x78BE,0xE1F8,      // <cjk>
      0x78C1,0x8EA5,      // <cjk>
      0x78C5,0xE1FA,      // <cjk>
      0x78C6,0xE1F5,      // <cjk>
      0x78CA,0xE1FB,      // <cjk>
      0x78CB,0xE1F6,      // <cjk>
      0x78D0,0x94D6,      // <cjk>
      0x78D1,0xE1F4,      // <cjk>
      0x78D4,0xE1F7,      // <cjk>
      0x78DA,0xE241,      // <cjk>
      0x78E7,0xE240,      // <cjk>
      0x78E8,0x9681,      // <cjk>
      0x78EC,0xE1FC,      // <cjk>
      0x78EF,0x88E9,      // <cjk>
      0x78F4,0xE243,      // <cjk>
      0x78FD,0xE242,      // <cjk>
      0x7901,0x8FCA,      // <cjk>
      0x7907,0xE244,      // <cjk>
      0x790E,0x9162,      // <cjk>
      0x7911,0xE246,      // <cjk>
      0x7912,0xE245,      // <cjk>
      0x7919,0xE247,      // <cjk>
      0x7926,0xE1E6,      // <cjk>
      0x792A,0xE1E8,      // <cjk>
      0x792B,0xE249,      // <cjk>
      0x792C,0xE248,      // <cjk>
      0x793A,0x8EA6,      // <cjk>
      0x793C,0x97E7,      // <cjk>
      0x793E,0x8ED0,      // <cjk>
      0x7940,0xE24A,      // <cjk>
      0x7941,0x8C56,      // <cjk>
      0x7947,0x8B5F,      // <cjk>
      0x7948,0x8B46,      // <cjk>
      0x7949,0x8E83,      // <cjk>
      0x7950,0x9753,      // <cjk>
      0x7953,0xE250,      // <cjk>
      0x7955,0xE24F,      // <cjk>
      0x7956,0x9163,      // <cjk>
      0x7957,0xE24C,      // <cjk>
      0x795A,0xE24E,      // <cjk>
      0x795D,0x8F6A,      // <cjk>
      0x795E,0x905F,      // <cjk>
      0x795F,0xE24D,      // <cjk>
      0x7960,0xE24B,      // <cjk>
      0x7962,0x9449,      // <cjk>
      0x7965,0x8FCB,      // <cjk>
      0x796D,0x8DD5,      // <cjk>
      0x7977,0x9398,      // <cjk>
      0x797A,0xE251,      // <cjk>
      0x797F,0xE252,      // <cjk>
      0x7980,0xE268,      // <cjk>
      0x7981,0x8BD6,      // <cjk>
      0x7984,0x985C,      // <cjk>
      0x7985,0x9154,      // <cjk>
      0x798A,0xE253,      // <cjk>
      0x798D,0x89D0,      // <cjk>
      0x798E,0x92F5,      // <cjk>
      0x798F,0x959F,      // <cjk>
      0x799D,0xE254,      // <cjk>
      0x79A6,0x8B9A,      // <cjk>
      0x79A7,0xE255,      // <cjk>
      0x79AA,0xE257,      // <cjk>
      0x79AE,0xE258,      // <cjk>
      0x79B0,0x9448,      // <cjk>
      0x79B3,0xE259,      // <cjk>
      0x79B9,0xE25A,      // <cjk>
      0x79BD,0x8BD7,      // <cjk>
      0x79BE,0x89D1,      // <cjk>
      0x79BF,0x93C3,      // <cjk>
      0x79C0,0x8F47,      // <cjk>
      0x79C1,0x8E84,      // <cjk>
      0x79C9,0xE25C,      // <cjk>
      0x79CB,0x8F48,      // <cjk>
      0x79D1,0x89C8,      // <cjk>
      0x79D2,0x9562,      // <cjk>
      0x79D5,0xE25D,      // <cjk>
      0x79D8,0x94E9,      // <cjk>
      0x79DF,0x9164,      // <cjk>
      0x79E1,0xE260,      // <cjk>
      0x79E3,0xE261,      // <cjk>
      0x79E4,0x9489,      // <cjk>
      0x79E6,0x9060,      // <cjk>
      0x79E7,0xE25E,      // <cjk>
      0x79E9,0x9281,      // <cjk>
      0x79EC,0xE25F,      // <cjk>
      0x79F0,0x8FCC,      // <cjk>
      0x79FB,0x88DA,      // <cjk>
      0x7A00,0x8B48,      // <cjk>
      0x7A08,0xE262,      // <cjk>
      0x7A0B,0x92F6,      // <cjk>
      0x7A0D,0xE263,      // <cjk>
      0x7A0E,0x90C5,      // <cjk>
      0x7A14,0x96AB,      // <cjk>
      0x7A17,0x9542,      // <cjk>
      0x7A18,0xE264,      // <cjk>
      0x7A19,0xE265,      // <cjk>
      0x7A1A,0x9274,      // <cjk>
      0x7A1C,0x97C5,      // <cjk>
      0x7A1F,0xE267,      // <cjk>
      0x7A20,0xE266,      // <cjk>
      0x7A2E,0x8EED,      // <cjk>
      0x7A31,0xE269,      // <cjk>
      0x7A32,0x88EE,      // <cjk>
      0x7A37,0xE26C,      // <cjk>
      0x7A3B,0xE26A,      // <cjk>
      0x7A3C,0x89D2,      // <cjk>
      0x7A3D,0x8C6D,      // <cjk>
      0x7A3E,0xE26B,      // <cjk>
      0x7A3F,0x8D65,      // <cjk>
      0x7A40,0x8D92,      // <cjk>
      0x7A42,0x95E4,      // <cjk>
      0x7A43,0xE26D,      // <cjk>
      0x7A46,0x9673,      // <cjk>
      0x7A49,0xE26F,      // <cjk>
      0x7A4D,0x90CF,      // <cjk>
      0x7A4E,0x896E,      // <cjk>
      0x7A4F,0x89B8,      // <cjk>
      0x7A50,0x88AA,      // <cjk>
      0x7A57,0xE26E,      // <cjk>
      0x7A61,0xE270,      // <cjk>
      0x7A62,0xE271,      // <cjk>
      0x7A63,0x8FF5,      // <cjk>
      0x7A69,0xE272,      // <cjk>
      0x7A6B,0x8A6E,      // <cjk>
      0x7A70,0xE274,      // <cjk>
      0x7A74,0x8C8A,      // <cjk>
      0x7A76,0x8B86,      // <cjk>
      0x7A79,0xE275,      // <cjk>
      0x7A7A,0x8BF3,      // <cjk>
      0x7A7D,0xE276,      // <cjk>
      0x7A7F,0x90FA,      // <cjk>
      0x7A81,0x93CB,      // <cjk>
      0x7A83,0x90DE,      // <cjk>
      0x7A84,0x8DF3,      // <cjk>
      0x7A88,0xE277,      // <cjk>
      0x7A92,0x9282,      // <cjk>
      0x7A93,0x918B,      // <cjk>
      0x7A95,0xE279,      // <cjk>
      0x7A96,0xE27B,      // <cjk>
      0x7A97,0xE278,      // <cjk>
      0x7A98,0xE27A,      // <cjk>
      0x7A9F,0x8C41,      // <cjk>
      0x7AA9,0xE27C,      // <cjk>
      0x7AAA,0x8C45,      // <cjk>
      0x7AAE,0x8B87,      // <cjk>
      0x7AAF,0x9771,      // <cjk>
      0x7AB0,0xE27E,      // <cjk>
      0x7AB6,0xE280,      // <cjk>
      0x7ABA,0x894D,      // <cjk>
      0x7ABF,0xE283,      // <cjk>
      0x7AC3,0x8A96,      // <cjk>
      0x7AC4,0xE282,      // <cjk>
      0x7AC5,0xE281,      // <cjk>
      0x7AC7,0xE285,      // <cjk>
      0x7AC8,0xE27D,      // <cjk>
      0x7ACA,0xE286,      // <cjk>
      0x7ACB,0x97A7,      // <cjk>
      0x7ACD,0xE287,      // <cjk>
      0x7ACF,0xE288,      // <cjk>
      0x7AD2,0x9AF2,      // <cjk>
      0x7AD3,0xE28A,      // <cjk>
      0x7AD5,0xE289,      // <cjk>
      0x7AD9,0xE28B,      // <cjk>
      0x7ADA,0xE28C,      // <cjk>
      0x7ADC,0x97B3,      // <cjk>
      0x7ADD,0xE28D,      // <cjk>
      0x7ADF,0xE8ED,      // <cjk>
      0x7AE0,0x8FCD,      // <cjk>
      0x7AE1,0xE28E,      // <cjk>
      0x7AE2,0xE28F,      // <cjk>
      0x7AE3,0x8F76,      // <cjk>
      0x7AE5,0x93B6,      // <cjk>
      0x7AE6,0xE290,      // <cjk>
      0x7AEA,0x9247,      // <cjk>
      0x7AED,0xE291,      // <cjk>
      0x7AF0,0xE292,      // <cjk>
      0x7AF6,0x8BA3,      // <cjk>
      0x7AF8,0x995E,      // <cjk>
      0x7AF9,0x927C,      // <cjk>
      0x7AFA,0x8EB1,      // <cjk>
      0x7AFF,0x8AC6,      // <cjk>
      0x7B02,0xE293,      // <cjk>
      0x7B04,0xE2A0,      // <cjk>
      0x7B06,0xE296,      // <cjk>
      0x7B08,0x8B88,      // <cjk>
      0x7B0A,0xE295,      // <cjk>
      0x7B0B,0xE2A2,      // <cjk>
      0x7B0F,0xE294,      // <cjk>
      0x7B11,0x8FCE,      // <cjk>
      0x7B18,0xE298,      // <cjk>
      0x7B19,0xE299,      // <cjk>
      0x7B1B,0x934A,      // <cjk>
      0x7B1E,0xE29A,      // <cjk>
      0x7B20,0x8A7D,      // <cjk>
      0x7B25,0x9079,      // <cjk>
      0x7B26,0x9584,      // <cjk>
      0x7B28,0xE29C,      // <cjk>
      0x7B2C,0x91E6,      // <cjk>
      0x7B33,0xE297,      // <cjk>
      0x7B35,0xE29B,      // <cjk>
      0x7B36,0xE29D,      // <cjk>
      0x7B39,0x8DF9,      // <cjk>
      0x7B45,0xE2A4,      // <cjk>
      0x7B46,0x954D,      // <cjk>
      0x7B48,0x94A4,      // <cjk>
      0x7B49,0x9399,      // <cjk>
      0x7B4B,0x8BD8,      // <cjk>
      0x7B4C,0xE2A3,      // <cjk>
      0x7B4D,0xE2A1,      // <cjk>
      0x7B4F,0x94B3,      // <cjk>
      0x7B50,0xE29E,      // <cjk>
      0x7B51,0x927D,      // <cjk>
      0x7B52,0x939B,      // <cjk>
      0x7B54,0x939A,      // <cjk>
      0x7B56,0x8DF4,      // <cjk>
      0x7B5D,0xE2B6,      // <cjk>
      0x7B65,0xE2A6,      // <cjk>
      0x7B67,0xE2A8,      // <cjk>
      0x7B6C,0xE2AB,      // <cjk>
      0x7B6E,0xE2AC,      // <cjk>
      0x7B70,0xE2A9,      // <cjk>
      0x7B71,0xE2AA,      // <cjk>
      0x7B74,0xE2A7,      // <cjk>
      0x7B75,0xE2A5,      // <cjk>
      0x7B7A,0xE29F,      // <cjk>
      0x7B86,0x95CD,      // <cjk>
      0x7B87,0x89D3,      // <cjk>
      0x7B8B,0xE2B3,      // <cjk>
      0x7B8D,0xE2B0,      // <cjk>
      0x7B8F,0xE2B5,      // <cjk>
      0x7B92,0xE2B4,      // <cjk>
      0x7B94,0x9493,      // <cjk>
      0x7B95,0x96A5,      // <cjk>
      0x7B97,0x8E5A,      // <cjk>
      0x7B98,0xE2AE,      // <cjk>
      0x7B99,0xE2B7,      // <cjk>
      0x7B9A,0xE2B2,      // <cjk>
      0x7B9C,0xE2B1,      // <cjk>
      0x7B9D,0xE2AD,      // <cjk>
      0x7B9F,0xE2AF,      // <cjk>
      0x7BA1,0x8AC7,      // <cjk>
      0x7BAA,0x925C,      // <cjk>
      0x7BAD,0x90FB,      // <cjk>
      0x7BB1,0x94A0,      // <cjk>
      0x7BB4,0xE2BC,      // <cjk>
      0x7BB8,0x94A2,      // <cjk>
      0x7BC0,0x90DF,      // <cjk>
      0x7BC1,0xE2B9,      // <cjk>
      0x7BC4,0x94CD,      // <cjk>
      0x7BC6,0xE2BD,      // <cjk>
      0x7BC7,0x95D1,      // <cjk>
      0x7BC9,0x927A,      // <cjk>
      0x7BCB,0xE2B8,      // <cjk>
      0x7BCC,0xE2BA,      // <cjk>
      0x7BCF,0xE2BB,      // <cjk>
      0x7BDD,0xE2BE,      // <cjk>
      0x7BE0,0x8EC2,      // <cjk>
      0x7BE4,0x93C4,      // <cjk>
      0x7BE5,0xE2C3,      // <cjk>
      0x7BE6,0xE2C2,      // <cjk>
      0x7BE9,0xE2BF,      // <cjk>
      0x7BED,0x9855,      // <cjk>
      0x7BF3,0xE2C8,      // <cjk>
      0x7BF6,0xE2CC,      // <cjk>
      0x7BF7,0xE2C9,      // <cjk>
      0x7C00,0xE2C5,      // <cjk>
      0x7C07,0xE2C6,      // <cjk>
      0x7C0D,0xE2CB,      // <cjk>
      0x7C11,0xE2C0,      // <cjk>
      0x7C12,0x99D3,      // <cjk>
      0x7C13,0xE2C7,      // <cjk>
      0x7C14,0xE2C1,      // <cjk>
      0x7C17,0xE2CA,      // <cjk>
      0x7C1F,0xE2D0,      // <cjk>
      0x7C21,0x8AC8,      // <cjk>
      0x7C23,0xE2CD,      // <cjk>
      0x7C27,0xE2CE,      // <cjk>
      0x7C2A,0xE2CF,      // <cjk>
      0x7C2B,0xE2D2,      // <cjk>
      0x7C37,0xE2D1,      // <cjk>
      0x7C38,0x94F4,      // <cjk>
      0x7C3D,0xE2D3,      // <cjk>
      0x7C3E,0x97FA,      // <cjk>
      0x7C3F,0x95EB,      // <cjk>
      0x7C40,0xE2D8,      // <cjk>
      0x7C43,0xE2D5,      // <cjk>
      0x7C4C,0xE2D4,      // <cjk>
      0x7C4D,0x90D0,      // <cjk>
      0x7C4F,0xE2D7,      // <cjk>
      0x7C50,0xE2D9,      // <cjk>
      0x7C54,0xE2D6,      // <cjk>
      0x7C56,0xE2DD,      // <cjk>
      0x7C58,0xE2DA,      // <cjk>
      0x7C5F,0xE2DB,      // <cjk>
      0x7C60,0xE2C4,      // <cjk>
      0x7C64,0xE2DC,      // <cjk>
      0x7C65,0xE2DE,      // <cjk>
      0x7C6C,0xE2DF,      // <cjk>
      0x7C73,0x95C4,      // <cjk>
      0x7C75,0xE2E0,      // <cjk>
      0x7C7E,0x96E0,      // <cjk>
      0x7C81,0x8BCC,      // <cjk>
      0x7C82,0x8C48,      // <cjk>
      0x7C83,0xE2E1,      // <cjk>
      0x7C89,0x95B2,      // <cjk>
      0x7C8B,0x9088,      // <cjk>
      0x7C8D,0x96AE,      // <cjk>
      0x7C90,0xE2E2,      // <cjk>
      0x7C92,0x97B1,      // <cjk>
      0x7C95,0x9494,      // <cjk>
      0x7C97,0x9165,      // <cjk>
      0x7C98,0x9453,      // <cjk>
      0x7C9B,0x8F6C,      // <cjk>
      0x7C9F,0x88BE,      // <cjk>
      0x7CA1,0xE2E7,      // <cjk>
      0x7CA2,0xE2E5,      // <cjk>
      0x7CA4,0xE2E3,      // <cjk>
      0x7CA5,0x8A9F,      // <cjk>
      0x7CA7,0x8FCF,      // <cjk>
      0x7CA8,0xE2E8,      // <cjk>
      0x7CAB,0xE2E6,      // <cjk>
      0x7CAD,0xE2E4,      // <cjk>
      0x7CAE,0xE2EC,      // <cjk>
      0x7CB1,0xE2EB,      // <cjk>
      0x7CB2,0xE2EA,      // <cjk>
      0x7CB3,0xE2E9,      // <cjk>
      0x7CB9,0xE2ED,      // <cjk>
      0x7CBD,0xE2EE,      // <cjk>
      0x7CBE,0x90B8,      // <cjk>
      0x7CC0,0xE2EF,      // <cjk>
      0x7CC2,0xE2F1,      // <cjk>
      0x7CC5,0xE2F0,      // <cjk>
      0x7CCA,0x8CD0,      // <cjk>
      0x7CCE,0x9157,      // <cjk>
      0x7CD2,0xE2F3,      // <cjk>
      0x7CD6,0x939C,      // <cjk>
      0x7CD8,0xE2F2,      // <cjk>
      0x7CDC,0xE2F4,      // <cjk>
      0x7CDE,0x95B3,      // <cjk>
      0x7CDF,0x918C,      // <cjk>
      0x7CE0,0x8D66,      // <cjk>
      0x7CE2,0xE2F5,      // <cjk>
      0x7CE7,0x97C6,      // <cjk>
      0x7CEF,0xE2F7,      // <cjk>
      0x7CF2,0xE2F8,      // <cjk>
      0x7CF4,0xE2F9,      // <cjk>
      0x7CF6,0xE2FA,      // <cjk>
      0x7CF8,0x8E85,      // <cjk>
      0x7CFA,0xE2FB,      // <cjk>
      0x7CFB,0x8C6E,      // <cjk>
      0x7CFE,0x8B8A,      // <cjk>
      0x7D00,0x8B49,      // <cjk>
      0x7D02,0xE340,      // <cjk>
      0x7D04,0x96F1,      // <cjk>
      0x7D05,0x8D67,      // <cjk>
      0x7D06,0xE2FC,      // <cjk>
      0x7D0A,0xE343,      // <cjk>
      0x7D0B,0x96E4,      // <cjk>
      0x7D10,0x9552,      // <cjk>
      0x7D14,0x8F83,      // <cjk>
      0x7D15,0xE342,      // <cjk>
      0x7D17,0x8ED1,      // <cjk>
      0x7D18,0x8D68,      // <cjk>
      0x7D19,0x8E86,      // <cjk>
      0x7D1A,0x8B89,      // <cjk>
      0x7D1B,0x95B4,      // <cjk>
      0x7D1C,0xE341,      // <cjk>
      0x7D20,0x9166,      // <cjk>
      0x7D21,0x9661,      // <cjk>
      0x7D22,0x8DF5,      // <cjk>
      0x7D2B,0x8E87,      // <cjk>
      0x7D2C,0x92DB,      // <cjk>
      0x7D2E,0xE346,      // <cjk>
      0x7D2F,0x97DD,      // <cjk>
      0x7D30,0x8DD7,      // <cjk>
      0x7D32,0xE347,      // <cjk>
      0x7D33,0x9061,      // <cjk>
      0x7D35,0xE349,      // <cjk>
      0x7D39,0x8FD0,      // <cjk>
      0x7D3A,0x8DAE,      // <cjk>
      0x7D3F,0xE348,      // <cjk>
      0x7D42,0x8F49,      // <cjk>
      0x7D43,0x8CBC,      // <cjk>
      0x7D44,0x9167,      // <cjk>
      0x7D45,0xE344,      // <cjk>
      0x7D46,0xE34A,      // <cjk>
      0x7D4B,0xE345,      // <cjk>
      0x7D4C,0x8C6F,      // <cjk>
      0x7D4E,0xE34D,      // <cjk>
      0x7D4F,0xE351,      // <cjk>
      0x7D50,0x8C8B,      // <cjk>
      0x7D56,0xE34C,      // <cjk>
      0x7D5B,0xE355,      // <cjk>
      0x7D5E,0x8D69,      // <cjk>
      0x7D61,0x978D,      // <cjk>
      0x7D62,0x88BA,      // <cjk>
      0x7D63,0xE352,      // <cjk>
      0x7D66,0x8B8B,      // <cjk>
      0x7D68,0xE34F,      // <cjk>
      0x7D6E,0xE350,      // <cjk>
      0x7D71,0x939D,      // <cjk>
      0x7D72,0xE34E,      // <cjk>
      0x7D73,0xE34B,      // <cjk>
      0x7D75,0x8A47,      // <cjk>
      0x7D76,0x90E2,      // <cjk>
      0x7D79,0x8CA6,      // <cjk>
      0x7D7D,0xE357,      // <cjk>
      0x7D89,0xE354,      // <cjk>
      0x7D8F,0xE356,      // <cjk>
      0x7D93,0xE353,      // <cjk>
      0x7D99,0x8C70,      // <cjk>
      0x7D9A,0x91B1,      // <cjk>
      0x7D9B,0xE358,      // <cjk>
      0x7D9C,0x918E,      // <cjk>
      0x7D9F,0xE365,      // <cjk>
      0x7DA2,0xE361,      // <cjk>
      0x7DAB,0xE35F,      // <cjk>
      0x7DAC,0x8EF8,      // <cjk>
      0x7DAD,0x88DB,      // <cjk>
      0x7DAE,0xE35A,      // <cjk>
      0x7DAF,0xE362,      // <cjk>
      0x7DB0,0xE366,      // <cjk>
      0x7DB1,0x8D6A,      // <cjk>
      0x7DB2,0x96D4,      // <cjk>
      0x7DB4,0x92D4,      // <cjk>
      0x7DB5,0xE35C,      // <cjk>
      0x7DB8,0xE364,      // <cjk>
      0x7DBA,0xE359,      // <cjk>
      0x7DBB,0x925D,      // <cjk>
      0x7DBD,0xE35E,      // <cjk>
      0x7DBE,0x88BB,      // <cjk>
      0x7DBF,0x96C8,      // <cjk>
      0x7DC7,0xE35D,      // <cjk>
      0x7DCA,0x8BD9,      // <cjk>
      0x7DCB,0x94EA,      // <cjk>
      0x7DCF,0x918D,      // <cjk>
      0x7DD1,0x97CE,      // <cjk>
      0x7DD2,0x8F8F,      // <cjk>
      0x7DD5,0xE38E,      // <cjk>
      0x7DD8,0xE367,      // <cjk>
      0x7DDA,0x90FC,      // <cjk>
      0x7DDC,0xE363,      // <cjk>
      0x7DDD,0xE368,      // <cjk>
      0x7DDE,0xE36A,      // <cjk>
      0x7DE0,0x92F7,      // <cjk>
      0x7DE1,0xE36D,      // <cjk>
      0x7DE4,0xE369,      // <cjk>
      0x7DE8,0x95D2,      // <cjk>
      0x7DE9,0x8AC9,      // <cjk>
      0x7DEC,0x96C9,      // <cjk>
      0x7DEF,0x88DC,      // <cjk>
      0x7DF2,0xE36C,      // <cjk>
      0x7DF4,0x97FB,      // <cjk>
      0x7DFB,0xE36B,      // <cjk>
      0x7E01,0x898F,      // <cjk>
      0x7E04,0x93EA,      // <cjk>
      0x7E05,0xE36E,      // <cjk>
      0x7E09,0xE375,      // <cjk>
      0x7E0A,0xE36F,      // <cjk>
      0x7E0B,0xE376,      // <cjk>
      0x7E12,0xE372,      // <cjk>
      0x7E1B,0x949B,      // <cjk>
      0x7E1E,0x8EC8,      // <cjk>
      0x7E1F,0xE374,      // <cjk>
      0x7E21,0xE371,      // <cjk>
      0x7E22,0xE377,      // <cjk>
      0x7E23,0xE370,      // <cjk>
      0x7E26,0x8F63,      // <cjk>
      0x7E2B,0x9644,      // <cjk>
      0x7E2E,0x8F6B,      // <cjk>
      0x7E31,0xE373,      // <cjk>
      0x7E32,0xE380,      // <cjk>
      0x7E35,0xE37B,      // <cjk>
      0x7E37,0xE37E,      // <cjk>
      0x7E39,0xE37C,      // <cjk>
      0x7E3A,0xE381,      // <cjk>
      0x7E3B,0xE37A,      // <cjk>
      0x7E3D,0xE360,      // <cjk>
      0x7E3E,0x90D1,      // <cjk>
      0x7E41,0x94C9,      // <cjk>
      0x7E43,0xE37D,      // <cjk>
      0x7E46,0xE378,      // <cjk>
      0x7E4A,0x9140,      // <cjk>
      0x7E4B,0x8C71,      // <cjk>
      0x7E4D,0x8F4A,      // <cjk>
      0x7E54,0x9044,      // <cjk>
      0x7E55,0x9155,      // <cjk>
      0x7E56,0xE384,      // <cjk>
      0x7E59,0xE386,      // <cjk>
      0x7E5A,0xE387,      // <cjk>
      0x7E5D,0xE383,      // <cjk>
      0x7E5E,0xE385,      // <cjk>
      0x7E66,0xE379,      // <cjk>
      0x7E67,0xE382,      // <cjk>
      0x7E69,0xE38A,      // <cjk>
      0x7E6A,0xE389,      // <cjk>
      0x7E6D,0x969A,      // <cjk>
      0x7E70,0x8C4A,      // <cjk>
      0x7E79,0xE388,      // <cjk>
      0x7E7B,0xE38C,      // <cjk>
      0x7E7C,0xE38B,      // <cjk>
      0x7E7D,0xE38F,      // <cjk>
      0x7E7F,0xE391,      // <cjk>
      0x7E83,0xE38D,      // <cjk>
      0x7E88,0xE392,      // <cjk>
      0x7E89,0xE393,      // <cjk>
      0x7E8C,0xE394,      // <cjk>
      0x7E8E,0xE39A,      // <cjk>
      0x7E8F,0x935A,      // <cjk>
      0x7E90,0xE396,      // <cjk>
      0x7E92,0xE395,      // <cjk>
      0x7E93,0xE397,      // <cjk>
      0x7E94,0xE398,      // <cjk>
      0x7E96,0xE399,      // <cjk>
      0x7E9B,0xE39B,      // <cjk>
      0x7E9C,0xE39C,      // <cjk>
      0x7F36,0x8ACA,      // <cjk>
      0x7F38,0xE39D,      // <cjk>
      0x7F3A,0xE39E,      // <cjk>
      0x7F45,0xE39F,      // <cjk>
      0x7F4C,0xE3A0,      // <cjk>
      0x7F4D,0xE3A1,      // <cjk>
      0x7F4E,0xE3A2,      // <cjk>
      0x7F50,0xE3A3,      // <cjk>
      0x7F51,0xE3A4,      // <cjk>
      0x7F54,0xE3A6,      // <cjk>
      0x7F55,0xE3A5,      // <cjk>
      0x7F58,0xE3A7,      // <cjk>
      0x7F5F,0xE3A8,      // <cjk>
      0x7F60,0xE3A9,      // <cjk>
      0x7F67,0xE3AC,      // <cjk>
      0x7F68,0xE3AA,      // <cjk>
      0x7F69,0xE3AB,      // <cjk>
      0x7F6A,0x8DDF,      // <cjk>
      0x7F6B,0x8C72,      // <cjk>
      0x7F6E,0x9275,      // <cjk>
      0x7F70,0x94B1,      // <cjk>
      0x7F72,0x8F90,      // <cjk>
      0x7F75,0x946C,      // <cjk>
      0x7F77,0x94EB,      // <cjk>
      0x7F78,0xE3AD,      // <cjk>
      0x7F79,0x9CEB,      // <cjk>
      0x7F82,0xE3AE,      // <cjk>
      0x7F83,0xE3B0,      // <cjk>
      0x7F85,0x9785,      // <cjk>
      0x7F86,0xE3AF,      // <cjk>
      0x7F87,0xE3B2,      // <cjk>
      0x7F88,0xE3B1,      // <cjk>
      0x7F8A,0x9772,      // <cjk>
      0x7F8C,0xE3B3,      // <cjk>
      0x7F8E,0x94FC,      // <cjk>
      0x7F94,0xE3B4,      // <cjk>
      0x7F9A,0xE3B7,      // <cjk>
      0x7F9D,0xE3B6,      // <cjk>
      0x7F9E,0xE3B5,      // <cjk>
      0x7FA3,0xE3B8,      // <cjk>
      0x7FA4,0x8C51,      // <cjk>
      0x7FA8,0x9141,      // <cjk>
      0x7FA9,0x8B60,      // <cjk>
      0x7FAE,0xE3BC,      // <cjk>
      0x7FAF,0xE3B9,      // <cjk>
      0x7FB2,0xE3BA,      // <cjk>
      0x7FB6,0xE3BD,      // <cjk>
      0x7FB8,0xE3BE,      // <cjk>
      0x7FB9,0xE3BB,      // <cjk>
      0x7FBD,0x8948,      // <cjk>
      0x7FC1,0x89A5,      // <cjk>
      0x7FC5,0xE3C0,      // <cjk>
      0x7FC6,0xE3C1,      // <cjk>
      0x7FCA,0xE3C2,      // <cjk>
      0x7FCC,0x9782,      // <cjk>
      0x7FD2,0x8F4B,      // <cjk>
      0x7FD4,0xE3C4,      // <cjk>
      0x7FD5,0xE3C3,      // <cjk>
      0x7FE0,0x9089,      // <cjk>
      0x7FE1,0xE3C5,      // <cjk>
      0x7FE6,0xE3C6,      // <cjk>
      0x7FE9,0xE3C7,      // <cjk>
      0x7FEB,0x8AE3,      // <cjk>
      0x7FF0,0x8ACB,      // <cjk>
      0x7FF3,0xE3C8,      // <cjk>
      0x7FF9,0xE3C9,      // <cjk>
      0x7FFB,0x967C,      // <cjk>
      0x7FFC,0x9783,      // <cjk>
      0x8000,0x9773,      // <cjk>
      0x8001,0x9856,      // <cjk>
      0x8003,0x8D6C,      // <cjk>
      0x8004,0xE3CC,      // <cjk>
      0x8005,0x8ED2,      // <cjk>
      0x8006,0xE3CB,      // <cjk>
      0x800B,0xE3CD,      // <cjk>
      0x800C,0x8EA7,      // <cjk>
      0x8010,0x91CF,      // <cjk>
      0x8012,0xE3CE,      // <cjk>
      0x8015,0x8D6B,      // <cjk>
      0x8017,0x96D5,      // <cjk>
      0x8018,0xE3CF,      // <cjk>
      0x8019,0xE3D0,      // <cjk>
      0x801C,0xE3D1,      // <cjk>
      0x8021,0xE3D2,      // <cjk>
      0x8028,0xE3D3,      // <cjk>
      0x8033,0x8EA8,      // <cjk>
      0x8036,0x96EB,      // <cjk>
      0x803B,0xE3D5,      // <cjk>
      0x803D,0x925E,      // <cjk>
      0x803F,0xE3D4,      // <cjk>
      0x8046,0xE3D7,      // <cjk>
      0x804A,0xE3D6,      // <cjk>
      0x8052,0xE3D8,      // <cjk>
      0x8056,0x90B9,      // <cjk>
      0x8058,0xE3D9,      // <cjk>
      0x805A,0xE3DA,      // <cjk>
      0x805E,0x95B7,      // <cjk>
      0x805F,0xE3DB,      // <cjk>
      0x8061,0x918F,      // <cjk>
      0x8062,0xE3DC,      // <cjk>
      0x8068,0xE3DD,      // <cjk>
      0x806F,0x97FC,      // <cjk>
      0x8070,0xE3E0,      // <cjk>
      0x8072,0xE3DF,      // <cjk>
      0x8073,0xE3DE,      // <cjk>
      0x8074,0x92AE,      // <cjk>
      0x8076,0xE3E1,      // <cjk>
      0x8077,0x9045,      // <cjk>
      0x8079,0xE3E2,      // <cjk>
      0x807D,0xE3E3,      // <cjk>
      0x807E,0x9857,      // <cjk>
      0x807F,0xE3E4,      // <cjk>
      0x8084,0xE3E5,      // <cjk>
      0x8085,0xE3E7,      // <cjk>
      0x8086,0xE3E6,      // <cjk>
      0x8087,0x94A3,      // <cjk>
      0x8089,0x93F7,      // <cjk>
      0x808B,0x985D,      // <cjk>
      0x808C,0x94A7,      // <cjk>
      0x8093,0xE3E9,      // <cjk>
      0x8096,0x8FD1,      // <cjk>
      0x8098,0x9549,      // <cjk>
      0x809A,0xE3EA,      // <cjk>
      0x809B,0xE3E8,      // <cjk>
      0x809D,0x8ACC,      // <cjk>
      0x80A1,0x8CD2,      // <cjk>
      0x80A2,0x8E88,      // <cjk>
      0x80A5,0x94EC,      // <cjk>
      0x80A9,0x8CA8,      // <cjk>
      0x80AA,0x9662,      // <cjk>
      0x80AC,0xE3ED,      // <cjk>
      0x80AD,0xE3EB,      // <cjk>
      0x80AF,0x8D6D,      // <cjk>
      0x80B1,0x8D6E,      // <cjk>
      0x80B2,0x88E7,      // <cjk>
      0x80B4,0x8DE6,      // <cjk>
      0x80BA,0x9478,      // <cjk>
      0x80C3,0x88DD,      // <cjk>
      0x80C4,0xE3F2,      // <cjk>
      0x80C6,0x925F,      // <cjk>
      0x80CC,0x9477,      // <cjk>
      0x80CE,0x91D9,      // <cjk>
      0x80D6,0xE3F4,      // <cjk>
      0x80D9,0xE3F0,      // <cjk>
      0x80DA,0xE3F3,      // <cjk>
      0x80DB,0xE3EE,      // <cjk>
      0x80DD,0xE3F1,      // <cjk>
      0x80DE,0x9645,      // <cjk>
      0x80E1,0x8CD3,      // <cjk>
      0x80E4,0x88FB,      // <cjk>
      0x80E5,0xE3EF,      // <cjk>
      0x80EF,0xE3F6,      // <cjk>
      0x80F1,0xE3F7,      // <cjk>
      0x80F4,0x93B7,      // <cjk>
      0x80F8,0x8BB9,      // <cjk>
      0x80FC,0xE445,      // <cjk>
      0x80FD,0x945C,      // <cjk>
      0x8102,0x8E89,      // <cjk>
      0x8105,0x8BBA,      // <cjk>
      0x8106,0x90C6,      // <cjk>
      0x8107,0x9865,      // <cjk>
      0x8108,0x96AC,      // <cjk>
      0x8109,0xE3F5,      // <cjk>
      0x810A,0x90D2,      // <cjk>
      0x811A,0x8B72,      // <cjk>
      0x811B,0xE3F8,      // <cjk>
      0x8123,0xE3FA,      // <cjk>
      0x8129,0xE3F9,      // <cjk>
      0x812F,0xE3FB,      // <cjk>
      0x8131,0x9245,      // <cjk>
      0x8133,0x945D,      // <cjk>
      0x8139,0x92AF,      // <cjk>
      0x813E,0xE442,      // <cjk>
      0x8146,0xE441,      // <cjk>
      0x814B,0xE3FC,      // <cjk>
      0x814E,0x9074,      // <cjk>
      0x8150,0x9585,      // <cjk>
      0x8151,0xE444,      // <cjk>
      0x8153,0xE443,      // <cjk>
      0x8154,0x8D6F,      // <cjk>
      0x8155,0x9872,      // <cjk>
      0x815F,0xE454,      // <cjk>
      0x8165,0xE448,      // <cjk>
      0x8166,0xE449,      // <cjk>
      0x816B,0x8EEE,      // <cjk>
      0x816E,0xE447,      // <cjk>
      0x8170,0x8D98,      // <cjk>
      0x8171,0xE446,      // <cjk>
      0x8174,0xE44A,      // <cjk>
      0x8178,0x92B0,      // <cjk>
      0x8179,0x95A0,      // <cjk>
      0x817A,0x9142,      // <cjk>
      0x817F,0x91DA,      // <cjk>
      0x8180,0xE44E,      // <cjk>
      0x8182,0xE44F,      // <cjk>
      0x8183,0xE44B,      // <cjk>
      0x8188,0xE44C,      // <cjk>
      0x818A,0xE44D,      // <cjk>
      0x818F,0x8D70,      // <cjk>
      0x8193,0xE455,      // <cjk>
      0x8195,0xE451,      // <cjk>
      0x819A,0x9586,      // <cjk>
      0x819C,0x968C,      // <cjk>
      0x819D,0x9547,      // <cjk>
      0x81A0,0xE450,      // <cjk>
      0x81A3,0xE453,      // <cjk>
      0x81A4,0xE452,      // <cjk>
      0x81A8,0x9663,      // <cjk>
      0x81A9,0xE456,      // <cjk>
      0x81B0,0xE457,      // <cjk>
      0x81B3,0x9156,      // <cjk>
      0x81B5,0xE458,      // <cjk>
      0x81B8,0xE45A,      // <cjk>
      0x81BA,0xE45E,      // <cjk>
      0x81BE,0xE459,      // <cjk>
      0x81BF,0x945E,      // <cjk>
      0x81C0,0xE45C,      // <cjk>
      0x81C2,0xE45D,      // <cjk>
      0x81C6,0x89B0,      // <cjk>
      0x81C8,0xE464,      // <cjk>
      0x81C9,0xE45F,      // <cjk>
      0x81CD,0xE460,      // <cjk>
      0x81D1,0xE461,      // <cjk>
      0x81D3,0x919F,      // <cjk>
      0x81D8,0xE463,      // <cjk>
      0x81D9,0xE462,      // <cjk>
      0x81DA,0xE465,      // <cjk>
      0x81DF,0xE466,      // <cjk>
      0x81E0,0xE467,      // <cjk>
      0x81E3,0x9062,      // <cjk>
      0x81E5,0x89E7,      // <cjk>
      0x81E7,0xE468,      // <cjk>
      0x81E8,0x97D5,      // <cjk>
      0x81EA,0x8EA9,      // <cjk>
      0x81ED,0x8F4C,      // <cjk>
      0x81F3,0x8E8A,      // <cjk>
      0x81F4,0x9276,      // <cjk>
      0x81FA,0xE469,      // <cjk>
      0x81FB,0xE46A,      // <cjk>
      0x81FC,0x8950,      // <cjk>
      0x81FE,0xE46B,      // <cjk>
      0x8201,0xE46C,      // <cjk>
      0x8202,0xE46D,      // <cjk>
      0x8205,0xE46E,      // <cjk>
      0x8207,0xE46F,      // <cjk>
      0x8208,0x8BBB,      // <cjk>
      0x8209,0x9DA8,      // <cjk>
      0x820A,0xE470,      // <cjk>
      0x820C,0x90E3,      // <cjk>
      0x820D,0xE471,      // <cjk>
      0x820E,0x8EC9,      // <cjk>
      0x8210,0xE472,      // <cjk>
      0x8212,0x98AE,      // <cjk>
      0x8216,0xE473,      // <cjk>
      0x8217,0x95DC,      // <cjk>
      0x8218,0x8ADA,      // <cjk>
      0x821B,0x9143,      // <cjk>
      0x821C,0x8F77,      // <cjk>
      0x821E,0x9591,      // <cjk>
      0x821F,0x8F4D,      // <cjk>
      0x8229,0xE474,      // <cjk>
      0x822A,0x8D71,      // <cjk>
      0x822B,0xE475,      // <cjk>
      0x822C,0x94CA,      // <cjk>
      0x822E,0xE484,      // <cjk>
      0x8233,0xE477,      // <cjk>
      0x8235,0x91C7,      // <cjk>
      0x8236,0x9495,      // <cjk>
      0x8237,0x8CBD,      // <cjk>
      0x8238,0xE476,      // <cjk>
      0x8239,0x9144,      // <cjk>
      0x8240,0xE478,      // <cjk>
      0x8247,0x92F8,      // <cjk>
      0x8258,0xE47A,      // <cjk>
      0x8259,0xE479,      // <cjk>
      0x825A,0xE47C,      // <cjk>
      0x825D,0xE47B,      // <cjk>
      0x825F,0xE47D,      // <cjk>
      0x8262,0xE480,      // <cjk>
      0x8264,0xE47E,      // <cjk>
      0x8266,0x8ACD,      // <cjk>
      0x8268,0xE481,      // <cjk>
      0x826A,0xE482,      // <cjk>
      0x826B,0xE483,      // <cjk>
      0x826E,0x8DAF,      // <cjk>
      0x826F,0x97C7,      // <cjk>
      0x8271,0xE485,      // <cjk>
      0x8272,0x9046,      // <cjk>
      0x8276,0x8990,      // <cjk>
      0x8277,0xE486,      // <cjk>
      0x8278,0xE487,      // <cjk>
      0x827E,0xE488,      // <cjk>
      0x828B,0x88F0,      // <cjk>
      0x828D,0xE489,      // <cjk>
      0x8292,0xE48A,      // <cjk>
      0x8299,0x9587,      // <cjk>
      0x829D,0x8EC5,      // <cjk>
      0x829F,0xE48C,      // <cjk>
      0x82A5,0x8A48,      // <cjk>
      0x82A6,0x88B0,      // <cjk>
      0x82AB,0xE48B,      // <cjk>
      0x82AC,0xE48E,      // <cjk>
      0x82AD,0x946D,      // <cjk>
      0x82AF,0x9063,      // <cjk>
      0x82B1,0x89D4,      // <cjk>
      0x82B3,0x9646,      // <cjk>
      0x82B8,0x8C7C,      // <cjk>
      0x82B9,0x8BDA,      // <cjk>
      0x82BB,0xE48D,      // <cjk>
      0x82BD,0x89E8,      // <cjk>
      0x82C5,0x8AA1,      // <cjk>
      0x82D1,0x8991,      // <cjk>
      0x82D2,0xE492,      // <cjk>
      0x82D3,0x97E8,      // <cjk>
      0x82D4,0x91DB,      // <cjk>
      0x82D7,0x9563,      // <cjk>
      0x82D9,0xE49E,      // <cjk>
      0x82DB,0x89D5,      // <cjk>
      0x82DC,0xE49C,      // <cjk>
      0x82DE,0xE49A,      // <cjk>
      0x82DF,0xE491,      // <cjk>
      0x82E1,0xE48F,      // <cjk>
      0x82E3,0xE490,      // <cjk>
      0x82E5,0x8EE1,      // <cjk>
      0x82E6,0x8BEA,      // <cjk>
      0x82E7,0x9297,      // <cjk>
      0x82EB,0x93CF,      // <cjk>
      0x82F1,0x8970,      // <cjk>
      0x82F3,0xE494,      // <cjk>
      0x82F4,0xE493,      // <cjk>
      0x82F9,0xE499,      // <cjk>
      0x82FA,0xE495,      // <cjk>
      0x82FB,0xE498,      // <cjk>
      0x8302,0x96CE,      // <cjk>
      0x8303,0xE497,      // <cjk>
      0x8304,0x89D6,      // <cjk>
      0x8305,0x8A9D,      // <cjk>
      0x8306,0xE49B,      // <cjk>
      0x8309,0xE49D,      // <cjk>
      0x830E,0x8C73,      // <cjk>
      0x8316,0xE4A1,      // <cjk>
      0x8317,0xE4AA,      // <cjk>
      0x8318,0xE4AB,      // <cjk>
      0x831C,0x88A9,      // <cjk>
      0x8323,0xE4B2,      // <cjk>
      0x8328,0x88EF,      // <cjk>
      0x832B,0xE4A9,      // <cjk>
      0x832F,0xE4A8,      // <cjk>
      0x8331,0xE4A3,      // <cjk>
      0x8332,0xE4A2,      // <cjk>
      0x8334,0xE4A0,      // <cjk>
      0x8335,0xE49F,      // <cjk>
      0x8336,0x9283,      // <cjk>
      0x8338,0x91F9,      // <cjk>
      0x8339,0xE4A5,      // <cjk>
      0x8340,0xE4A4,      // <cjk>
      0x8345,0xE4A7,      // <cjk>
      0x8349,0x9190,      // <cjk>
      0x834A,0x8C74,      // <cjk>
      0x834F,0x8960,      // <cjk>
      0x8350,0xE4A6,      // <cjk>
      0x8352,0x8D72,      // <cjk>
      0x8358,0x9191,      // <cjk>
      0x8373,0xE4B8,      // <cjk>
      0x8375,0xE4B9,      // <cjk>
      0x8377,0x89D7,      // <cjk>
      0x837B,0x89AC,      // <cjk>
      0x837C,0xE4B6,      // <cjk>
      0x8385,0xE4AC,      // <cjk>
      0x8387,0xE4B4,      // <cjk>
      0x8389,0xE4BB,      // <cjk>
      0x838A,0xE4B5,      // <cjk>
      0x838E,0xE4B3,      // <cjk>
      0x8393,0xE496,      // <cjk>
      0x8396,0xE4B1,      // <cjk>
      0x839A,0xE4AD,      // <cjk>
      0x839E,0x8ACE,      // <cjk>
      0x839F,0xE4AF,      // <cjk>
      0x83A0,0xE4BA,      // <cjk>
      0x83A2,0xE4B0,      // <cjk>
      0x83A8,0xE4BC,      // <cjk>
      0x83AA,0xE4AE,      // <cjk>
      0x83AB,0x949C,      // <cjk>
      0x83B1,0x9789,      // <cjk>
      0x83B5,0xE4B7,      // <cjk>
      0x83BD,0xE4CD,      // <cjk>
      0x83C1,0xE4C5,      // <cjk>
      0x83C5,0x909B,      // <cjk>
      0x83CA,0x8B65,      // <cjk>
      0x83CC,0x8BDB,      // <cjk>
      0x83CE,0xE4C0,      // <cjk>
      0x83D3,0x89D9,      // <cjk>
      0x83D6,0x8FD2,      // <cjk>
      0x83D8,0xE4C3,      // <cjk>
      0x83DC,0x8DD8,      // <cjk>
      0x83DF,0x9370,      // <cjk>
      0x83E0,0xE4C8,      // <cjk>
      0x83E9,0x95EC,      // <cjk>
      0x83EB,0xE4BF,      // <cjk>
      0x83EF,0x89D8,      // <cjk>
      0x83F0,0x8CD4,      // <cjk>
      0x83F1,0x9548,      // <cjk>
      0x83F2,0xE4C9,      // <cjk>
      0x83F4,0xE4BD,      // <cjk>
      0x83F7,0xE4C6,      // <cjk>
      0x83FB,0xE4D0,      // <cjk>
      0x83FD,0xE4C1,      // <cjk>
      0x8403,0xE4C2,      // <cjk>
      0x8404,0x93B8,      // <cjk>
      0x8407,0xE4C7,      // <cjk>
      0x840B,0xE4C4,      // <cjk>
      0x840C,0x9647,      // <cjk>
      0x840D,0xE4CA,      // <cjk>
      0x840E,0x88DE,      // <cjk>
      0x8413,0xE4BE,      // <cjk>
      0x8420,0xE4CC,      // <cjk>
      0x8422,0xE4CB,      // <cjk>
      0x8429,0x948B,      // <cjk>
      0x842A,0xE4D2,      // <cjk>
      0x842C,0xE4DD,      // <cjk>
      0x8431,0x8A9E,      // <cjk>
      0x8435,0xE4E0,      // <cjk>
      0x8438,0xE4CE,      // <cjk>
      0x843C,0xE4D3,      // <cjk>
      0x843D,0x978E,      // <cjk>
      0x8446,0xE4DC,      // <cjk>
      0x8449,0x9774,      // <cjk>
      0x844E,0x97A8,      // <cjk>
      0x8457,0x9298,      // <cjk>
      0x845B,0x8A8B,      // <cjk>
      0x8461,0x9592,      // <cjk>
      0x8462,0xE4E2,      // <cjk>
      0x8463,0x939F,      // <cjk>
      0x8466,0x88AF,      // <cjk>
      0x8469,0xE4DB,      // <cjk>
      0x846B,0xE4D7,      // <cjk>
      0x846C,0x9192,      // <cjk>
      0x846D,0xE4D1,      // <cjk>
      0x846E,0xE4D9,      // <cjk>
      0x846F,0xE4DE,      // <cjk>
      0x8471,0x944B,      // <cjk>
      0x8475,0x88A8,      // <cjk>
      0x8477,0xE4D6,      // <cjk>
      0x8479,0xE4DF,      // <cjk>
      0x847A,0x9598,      // <cjk>
      0x8482,0xE4DA,      // <cjk>
      0x8484,0xE4D5,      // <cjk>
      0x848B,0x8FD3,      // <cjk>
      0x8490,0x8F4E,      // <cjk>
      0x8494,0x8EAA,      // <cjk>
      0x8499,0x96D6,      // <cjk>
      0x849C,0x9566,      // <cjk>
      0x849F,0xE4E5,      // <cjk>
      0x84A1,0xE4EE,      // <cjk>
      0x84AD,0xE4D8,      // <cjk>
      0x84B2,0x8A97,      // <cjk>
      0x84B8,0x8FF6,      // <cjk>
      0x84B9,0xE4E3,      // <cjk>
      0x84BB,0xE4E8,      // <cjk>
      0x84BC,0x9193,      // <cjk>
      0x84BF,0xE4E4,      // <cjk>
      0x84C1,0xE4EB,      // <cjk>
      0x84C4,0x927E,      // <cjk>
      0x84C6,0xE4EC,      // <cjk>
      0x84C9,0x9775,      // <cjk>
      0x84CA,0xE4E1,      // <cjk>
      0x84CB,0x8A57,      // <cjk>
      0x84CD,0xE4E7,      // <cjk>
      0x84D0,0xE4EA,      // <cjk>
      0x84D1,0x96AA,      // <cjk>
      0x84D6,0xE4ED,      // <cjk>
      0x84D9,0xE4E6,      // <cjk>
      0x84DA,0xE4E9,      // <cjk>
      0x84EC,0x9648,      // <cjk>
      0x84EE,0x9840,      // <cjk>
      0x84F4,0xE4F1,      // <cjk>
      0x84FC,0xE4F8,      // <cjk>
      0x84FF,0xE4F0,      // <cjk>
      0x8500,0x8EC1,      // <cjk>
      0x8506,0xE4CF,      // <cjk>
      0x8511,0x95CC,      // <cjk>
      0x8513,0x96A0,      // <cjk>
      0x8514,0xE4F7,      // <cjk>
      0x8515,0xE4F6,      // <cjk>
      0x8517,0xE4F2,      // <cjk>
      0x8518,0xE4F3,      // <cjk>
      0x851A,0x8955,      // <cjk>
      0x851F,0xE4F5,      // <cjk>
      0x8521,0xE4EF,      // <cjk>
      0x8526,0x92D3,      // <cjk>
      0x852C,0xE4F4,      // <cjk>
      0x852D,0x88FC,      // <cjk>
      0x8535,0x91A0,      // <cjk>
      0x853D,0x95C1,      // <cjk>
      0x8540,0xE4F9,      // <cjk>
      0x8541,0xE540,      // <cjk>
      0x8543,0x94D7,      // <cjk>
      0x8548,0xE4FC,      // <cjk>
      0x8549,0x8FD4,      // <cjk>
      0x854A,0x8EC7,      // <cjk>
      0x854B,0xE542,      // <cjk>
      0x854E,0x8BBC,      // <cjk>
      0x8555,0xE543,      // <cjk>
      0x8557,0x9599,      // <cjk>
      0x8558,0xE4FB,      // <cjk>
      0x855A,0xE4D4,      // <cjk>
      0x8563,0xE4FA,      // <cjk>
      0x8568,0x986E,      // <cjk>
      0x8569,0x93A0,      // <cjk>
      0x856A,0x9593,      // <cjk>
      0x856D,0xE54A,      // <cjk>
      0x8577,0xE550,      // <cjk>
      0x857E,0xE551,      // <cjk>
      0x8580,0xE544,      // <cjk>
      0x8584,0x9496,      // <cjk>
      0x8587,0xE54E,      // <cjk>
      0x8588,0xE546,      // <cjk>
      0x858A,0xE548,      // <cjk>
      0x8590,0xE552,      // <cjk>
      0x8591,0xE547,      // <cjk>
      0x8594,0xE54B,      // <cjk>
      0x8597,0x8992,      // <cjk>
      0x8599,0x93E3,      // <cjk>
      0x859B,0xE54C,      // <cjk>
      0x859C,0xE54F,      // <cjk>
      0x85A4,0xE545,      // <cjk>
      0x85A6,0x9145,      // <cjk>
      0x85A8,0xE549,      // <cjk>
      0x85A9,0x8E46,      // <cjk>
      0x85AA,0x9064,      // <cjk>
      0x85AB,0x8C4F,      // <cjk>
      0x85AC,0x96F2,      // <cjk>
      0x85AE,0x96F7,      // <cjk>
      0x85AF,0x8F92,      // <cjk>
      0x85B9,0xE556,      // <cjk>
      0x85BA,0xE554,      // <cjk>
      0x85C1,0x986D,      // <cjk>
      0x85C9,0xE553,      // <cjk>
      0x85CD,0x9795,      // <cjk>
      0x85CF,0xE555,      // <cjk>
      0x85D0,0xE557,      // <cjk>
      0x85D5,0xE558,      // <cjk>
      0x85DD,0xE559,      // <cjk>
      0x85E4,0x93A1,      // <cjk>
      0x85E5,0xE55A,      // <cjk>
      0x85E9,0x94CB,      // <cjk>
      0x85EA,0xE54D,      // <cjk>
      0x85F7,0x8F93,      // <cjk>
      0x85F9,0xE55C,      // <cjk>
      0x85FA,0xE561,      // <cjk>
      0x85FB,0x9194,      // <cjk>
      0x85FE,0xE560,      // <cjk>
      0x8602,0xE541,      // <cjk>
      0x8606,0xE562,      // <cjk>
      0x8607,0x9168,      // <cjk>
      0x860A,0xE55D,      // <cjk>
      0x860B,0xE55F,      // <cjk>
      0x8613,0xE55E,      // <cjk>
      0x8616,0x9F50,      // <cjk>
      0x8617,0x9F41,      // <cjk>
      0x861A,0xE564,      // <cjk>
      0x8622,0xE563,      // <cjk>
      0x862D,0x9796,      // <cjk>
      0x862F,0xE1BA,      // <cjk>
      0x8630,0xE565,      // <cjk>
      0x863F,0xE566,      // <cjk>
      0x864D,0xE567,      // <cjk>
      0x864E,0x8CD5,      // <cjk>
      0x8650,0x8B73,      // <cjk>
      0x8654,0xE569,      // <cjk>
      0x8655,0x997C,      // <cjk>
      0x865A,0x8B95,      // <cjk>
      0x865C,0x97B8,      // <cjk>
      0x865E,0x8BF1,      // <cjk>
      0x865F,0xE56A,      // <cjk>
      0x8667,0xE56B,      // <cjk>
      0x866B,0x928E,      // <cjk>
      0x8671,0xE56C,      // <cjk>
      0x8679,0x93F8,      // <cjk>
      0x867B,0x88B8,      // <cjk>
      0x868A,0x89E1,      // <cjk>
      0x868B,0xE571,      // <cjk>
      0x868C,0xE572,      // <cjk>
      0x8693,0xE56D,      // <cjk>
      0x8695,0x8E5C,      // <cjk>
      0x86A3,0xE56E,      // <cjk>
      0x86A4,0x9461,      // <cjk>
      0x86A9,0xE56F,      // <cjk>
      0x86AA,0xE570,      // <cjk>
      0x86AB,0xE57A,      // <cjk>
      0x86AF,0xE574,      // <cjk>
      0x86B0,0xE577,      // <cjk>
      0x86B6,0xE573,      // <cjk>
      0x86C4,0xE575,      // <cjk>
      0x86C6,0xE576,      // <cjk>
      0x86C7,0x8ED6,      // <cjk>
      0x86C9,0xE578,      // <cjk>
      0x86CB,0x9260,      // <cjk>
      0x86CD,0x8C75,      // <cjk>
      0x86CE,0x8A61,      // <cjk>
      0x86D4,0xE57B,      // <cjk>
      0x86D9,0x8A5E,      // <cjk>
      0x86DB,0xE581,      // <cjk>
      0x86DE,0xE57C,      // <cjk>
      0x86DF,0xE580,      // <cjk>
      0x86E4,0x94B8,      // <cjk>
      0x86E9,0xE57D,      // <cjk>
      0x86EC,0xE57E,      // <cjk>
      0x86ED,0x9567,      // <cjk>
      0x86EE,0x94D8,      // <cjk>
      0x86EF,0xE582,      // <cjk>
      0x86F8,0x91FB,      // <cjk>
      0x86F9,0xE58C,      // <cjk>
      0x86FB,0xE588,      // <cjk>
      0x86FE,0x89E9,      // <cjk>
      0x8700,0xE586,      // <cjk>
      0x8702,0x9649,      // <cjk>
      0x8703,0xE587,      // <cjk>
      0x8706,0xE584,      // <cjk>
      0x8708,0xE585,      // <cjk>
      0x8709,0xE58A,      // <cjk>
      0x870A,0xE58D,      // <cjk>
      0x870D,0xE58B,      // <cjk>
      0x8711,0xE589,      // <cjk>
      0x8712,0xE583,      // <cjk>
      0x8718,0x9277,      // <cjk>
      0x871A,0xE594,      // <cjk>
      0x871C,0x96A8,      // <cjk>
      0x8725,0xE592,      // <cjk>
      0x8729,0xE593,      // <cjk>
      0x8734,0xE58E,      // <cjk>
      0x8737,0xE590,      // <cjk>
      0x873B,0xE591,      // <cjk>
      0x873F,0xE58F,      // <cjk>
      0x8749,0x90E4,      // <cjk>
      0x874B,0x9858,      // <cjk>
      0x874C,0xE598,      // <cjk>
      0x874E,0xE599,      // <cjk>
      0x8753,0xE59F,      // <cjk>
      0x8755,0x9049,      // <cjk>
      0x8757,0xE59B,      // <cjk>
      0x8759,0xE59E,      // <cjk>
      0x875F,0xE596,      // <cjk>
      0x8760,0xE595,      // <cjk>
      0x8763,0xE5A0,      // <cjk>
      0x8766,0x89DA,      // <cjk>
      0x8768,0xE59C,      // <cjk>
      0x876A,0xE5A1,      // <cjk>
      0x876E,0xE59D,      // <cjk>
      0x8774,0xE59A,      // <cjk>
      0x8776,0x92B1,      // <cjk>
      0x8778,0xE597,      // <cjk>
      0x877F,0x9488,      // <cjk>
      0x8782,0xE5A5,      // <cjk>
      0x878D,0x975A,      // <cjk>
      0x879F,0xE5A4,      // <cjk>
      0x87A2,0xE5A3,      // <cjk>
      0x87AB,0xE5AC,      // <cjk>
      0x87AF,0xE5A6,      // <cjk>
      0x87B3,0xE5AE,      // <cjk>
      0x87BA,0x9786,      // <cjk>
      0x87BB,0xE5B1,      // <cjk>
      0x87BD,0xE5A8,      // <cjk>
      0x87C0,0xE5A9,      // <cjk>
      0x87C4,0xE5AD,      // <cjk>
      0x87C6,0xE5B0,      // <cjk>
      0x87C7,0xE5AF,      // <cjk>
      0x87CB,0xE5A7,      // <cjk>
      0x87D0,0xE5AA,      // <cjk>
      0x87D2,0xE5BB,      // <cjk>
      0x87E0,0xE5B4,      // <cjk>
      0x87EF,0xE5B2,      // <cjk>
      0x87F2,0xE5B3,      // <cjk>
      0x87F6,0xE5B8,      // <cjk>
      0x87F7,0xE5B9,      // <cjk>
      0x87F9,0x8A49,      // <cjk>
      0x87FB,0x8B61,      // <cjk>
      0x87FE,0xE5B7,      // <cjk>
      0x8805,0xE5A2,      // <cjk>
      0x880D,0xE5B6,      // <cjk>
      0x880E,0xE5BA,      // <cjk>
      0x880F,0xE5B5,      // <cjk>
      0x8811,0xE5BC,      // <cjk>
      0x8815,0xE5BE,      // <cjk>
      0x8816,0xE5BD,      // <cjk>
      0x8821,0xE5C0,      // <cjk>
      0x8822,0xE5BF,      // <cjk>
      0x8823,0xE579,      // <cjk>
      0x8827,0xE5C4,      // <cjk>
      0x8831,0xE5C1,      // <cjk>
      0x8836,0xE5C2,      // <cjk>
      0x8839,0xE5C3,      // <cjk>
      0x883B,0xE5C5,      // <cjk>
      0x8840,0x8C8C,      // <cjk>
      0x8842,0xE5C7,      // <cjk>
      0x8844,0xE5C6,      // <cjk>
      0x8846,0x8F4F,      // <cjk>
      0x884C,0x8D73,      // <cjk>
      0x884D,0x9FA5,      // <cjk>
      0x8852,0xE5C8,      // <cjk>
      0x8853,0x8F70,      // <cjk>
      0x8857,0x8A58,      // <cjk>
      0x8859,0xE5C9,      // <cjk>
      0x885B,0x8971,      // <cjk>
      0x885D,0x8FD5,      // <cjk>
      0x885E,0xE5CA,      // <cjk>
      0x8861,0x8D74,      // <cjk>
      0x8862,0xE5CB,      // <cjk>
      0x8863,0x88DF,      // <cjk>
      0x8868,0x955C,      // <cjk>
      0x886B,0xE5CC,      // <cjk>
      0x8870,0x908A,      // <cjk>
      0x8872,0xE5D3,      // <cjk>
      0x8875,0xE5D0,      // <cjk>
      0x8877,0x928F,      // <cjk>
      0x887D,0xE5D1,      // <cjk>
      0x887E,0xE5CE,      // <cjk>
      0x887F,0x8BDC,      // <cjk>
      0x8881,0xE5CD,      // <cjk>
      0x8882,0xE5D4,      // <cjk>
      0x8888,0x8C55,      // <cjk>
      0x888B,0x91DC,      // <cjk>
      0x888D,0xE5DA,      // <cjk>
      0x8892,0xE5D6,      // <cjk>
      0x8896,0x91B3,      // <cjk>
      0x8897,0xE5D5,      // <cjk>
      0x8899,0xE5D8,      // <cjk>
      0x889E,0xE5CF,      // <cjk>
      0x88A2,0xE5D9,      // <cjk>
      0x88A4,0xE5DB,      // <cjk>
      0x88AB,0x94ED,      // <cjk>
      0x88AE,0xE5D7,      // <cjk>
      0x88B0,0xE5DC,      // <cjk>
      0x88B1,0xE5DE,      // <cjk>
      0x88B4,0x8CD1,      // <cjk>
      0x88B5,0xE5D2,      // <cjk>
      0x88B7,0x88BF,      // <cjk>
      0x88BF,0xE5DD,      // <cjk>
      0x88C1,0x8DD9,      // <cjk>
      0x88C2,0x97F4,      // <cjk>
      0x88C3,0xE5DF,      // <cjk>
      0x88C4,0xE5E0,      // <cjk>
      0x88C5,0x9195,      // <cjk>
      0x88CF,0x97A0,      // <cjk>
      0x88D4,0xE5E1,      // <cjk>
      0x88D5,0x9754,      // <cjk>
      0x88D8,0xE5E2,      // <cjk>
      0x88D9,0xE5E3,      // <cjk>
      0x88DC,0x95E2,      // <cjk>
      0x88DD,0xE5E4,      // <cjk>
      0x88DF,0x8DBE,      // <cjk>
      0x88E1,0x97A1,      // <cjk>
      0x88E8,0xE5E9,      // <cjk>
      0x88F2,0xE5EA,      // <cjk>
      0x88F3,0x8FD6,      // <cjk>
      0x88F4,0xE5E8,      // <cjk>
      0x88F8,0x9787,      // <cjk>
      0x88F9,0xE5E5,      // <cjk>
      0x88FC,0xE5E7,      // <cjk>
      0x88FD,0x90BB,      // <cjk>
      0x88FE,0x909E,      // <cjk>
      0x8902,0xE5E6,      // <cjk>
      0x8904,0xE5EB,      // <cjk>
      0x8907,0x95A1,      // <cjk>
      0x890A,0xE5ED,      // <cjk>
      0x890C,0xE5EC,      // <cjk>
      0x8910,0x8A8C,      // <cjk>
      0x8912,0x964A,      // <cjk>
      0x8913,0xE5EE,      // <cjk>
      0x891D,0xE5FA,      // <cjk>
      0x891E,0xE5F0,      // <cjk>
      0x8925,0xE5F1,      // <cjk>
      0x892A,0xE5F2,      // <cjk>
      0x892B,0xE5F3,      // <cjk>
      0x8936,0xE5F7,      // <cjk>
      0x8938,0xE5F8,      // <cjk>
      0x893B,0xE5F6,      // <cjk>
      0x8941,0xE5F4,      // <cjk>
      0x8943,0xE5EF,      // <cjk>
      0x8944,0xE5F5,      // <cjk>
      0x894C,0xE5F9,      // <cjk>
      0x894D,0xE8B5,      // <cjk>
      0x8956,0x89A6,      // <cjk>
      0x895E,0xE5FC,      // <cjk>
      0x895F,0x8BDD,      // <cjk>
      0x8960,0xE5FB,      // <cjk>
      0x8964,0xE641,      // <cjk>
      0x8966,0xE640,      // <cjk>
      0x896A,0xE643,      // <cjk>
      0x896D,0xE642,      // <cjk>
      0x896F,0xE644,      // <cjk>
      0x8972,0x8F50,      // <cjk>
      0x8974,0xE645,      // <cjk>
      0x8977,0xE646,      // <cjk>
      0x897E,0xE647,      // <cjk>
      0x897F,0x90BC,      // <cjk>
      0x8981,0x9776,      // <cjk>
      0x8983,0xE648,      // <cjk>
      0x8986,0x95A2,      // <cjk>
      0x8987,0x9465,      // <cjk>
      0x8988,0xE649,      // <cjk>
      0x898A,0xE64A,      // <cjk>
      0x898B,0x8CA9,      // <cjk>
      0x898F,0x8B4B,      // <cjk>
      0x8993,0xE64B,      // <cjk>
      0x8996,0x8E8B,      // <cjk>
      0x8997,0x9460,      // <cjk>
      0x8998,0xE64C,      // <cjk>
      0x899A,0x8A6F,      // <cjk>
      0x89A1,0xE64D,      // <cjk>
      0x89A6,0xE64F,      // <cjk>
      0x89A7,0x9797,      // <cjk>
      0x89A9,0xE64E,      // <cjk>
      0x89AA,0x9065,      // <cjk>
      0x89AC,0xE650,      // <cjk>
      0x89AF,0xE651,      // <cjk>
      0x89B2,0xE652,      // <cjk>
      0x89B3,0x8ACF,      // <cjk>
      0x89BA,0xE653,      // <cjk>
      0x89BD,0xE654,      // <cjk>
      0x89BF,0xE655,      // <cjk>
      0x89C0,0xE656,      // <cjk>
      0x89D2,0x8A70,      // <cjk>
      0x89DA,0xE657,      // <cjk>
      0x89DC,0xE658,      // <cjk>
      0x89DD,0xE659,      // <cjk>
      0x89E3,0x89F0,      // <cjk>
      0x89E6,0x9047,      // <cjk>
      0x89E7,0xE65A,      // <cjk>
      0x89F8,0xE65C,      // <cjk>
      0x8A00,0x8CBE,      // <cjk>
      0x8A02,0x92F9,      // <cjk>
      0x8A03,0xE65D,      // <cjk>
      0x8A08,0x8C76,      // <cjk>
      0x8A0A,0x9075,      // <cjk>
      0x8A0C,0xE660,      // <cjk>
      0x8A0E,0x93A2,      // <cjk>
      0x8A10,0xE65F,      // <cjk>
      0x8A13,0x8C50,      // <cjk>
      0x8A16,0xE65E,      // <cjk>
      0x8A17,0x91F5,      // <cjk>
      0x8A18,0x8B4C,      // <cjk>
      0x8A1B,0xE661,      // <cjk>
      0x8A1D,0xE662,      // <cjk>
      0x8A1F,0x8FD7,      // <cjk>
      0x8A23,0x8C8D,      // <cjk>
      0x8A25,0xE663,      // <cjk>
      0x8A2A,0x964B,      // <cjk>
      0x8A2D,0x90DD,      // <cjk>
      0x8A31,0x8B96,      // <cjk>
      0x8A33,0x96F3,      // <cjk>
      0x8A34,0x9169,      // <cjk>
      0x8A36,0xE664,      // <cjk>
      0x8A3A,0x9066,      // <cjk>
      0x8A3B,0x9290,      // <cjk>
      0x8A3C,0x8FD8,      // <cjk>
      0x8A41,0xE665,      // <cjk>
      0x8A46,0xE668,      // <cjk>
      0x8A48,0xE669,      // <cjk>
      0x8A50,0x8DBC,      // <cjk>
      0x8A51,0x91C0,      // <cjk>
      0x8A52,0xE667,      // <cjk>
      0x8A54,0x8FD9,      // <cjk>
      0x8A55,0x955D,      // <cjk>
      0x8A5B,0xE666,      // <cjk>
      0x8A5E,0x8E8C,      // <cjk>
      0x8A60,0x8972,      // <cjk>
      0x8A62,0xE66D,      // <cjk>
      0x8A63,0x8C77,      // <cjk>
      0x8A66,0x8E8E,      // <cjk>
      0x8A69,0x8E8D,      // <cjk>
      0x8A6B,0x986C,      // <cjk>
      0x8A6C,0xE66C,      // <cjk>
      0x8A6D,0xE66B,      // <cjk>
      0x8A6E,0x9146,      // <cjk>
      0x8A70,0x8B6C,      // <cjk>
      0x8A71,0x9862,      // <cjk>
      0x8A72,0x8A59,      // <cjk>
      0x8A73,0x8FDA,      // <cjk>
      0x8A7C,0xE66A,      // <cjk>
      0x8A82,0xE66F,      // <cjk>
      0x8A84,0xE670,      // <cjk>
      0x8A85,0xE66E,      // <cjk>
      0x8A87,0x8CD6,      // <cjk>
      0x8A89,0x975F,      // <cjk>
      0x8A8C,0x8E8F,      // <cjk>
      0x8A8D,0x9446,      // <cjk>
      0x8A91,0xE673,      // <cjk>
      0x8A93,0x90BE,      // <cjk>
      0x8A95,0x9261,      // <cjk>
      0x8A98,0x9755,      // <cjk>
      0x8A9A,0xE676,      // <cjk>
      0x8A9E,0x8CEA,      // <cjk>
      0x8AA0,0x90BD,      // <cjk>
      0x8AA1,0xE672,      // <cjk>
      0x8AA3,0xE677,      // <cjk>
      0x8AA4,0x8CEB,      // <cjk>
      0x8AA5,0xE674,      // <cjk>
      0x8AA6,0xE675,      // <cjk>
      0x8AA8,0xE671,      // <cjk>
      0x8AAC,0x90E0,      // <cjk>
      0x8AAD,0x93C7,      // <cjk>
      0x8AB0,0x924E,      // <cjk>
      0x8AB2,0x89DB,      // <cjk>
      0x8AB9,0x94EE,      // <cjk>
      0x8ABC,0x8B62,      // <cjk>
      0x8ABF,0x92B2,      // <cjk>
      0x8AC2,0xE67A,      // <cjk>
      0x8AC4,0xE678,      // <cjk>
      0x8AC7,0x926B,      // <cjk>
      0x8ACB,0x90BF,      // <cjk>
      0x8ACC,0x8AD0,      // <cjk>
      0x8ACD,0xE679,      // <cjk>
      0x8ACF,0x907A,      // <cjk>
      0x8AD2,0x97C8,      // <cjk>
      0x8AD6,0x985F,      // <cjk>
      0x8ADA,0xE67B,      // <cjk>
      0x8ADB,0xE687,      // <cjk>
      0x8ADC,0x92B3,      // <cjk>
      0x8ADE,0xE686,      // <cjk>
      0x8AE0,0xE683,      // <cjk>
      0x8AE1,0xE68B,      // <cjk>
      0x8AE2,0xE684,      // <cjk>
      0x8AE4,0xE680,      // <cjk>
      0x8AE6,0x92FA,      // <cjk>
      0x8AE7,0xE67E,      // <cjk>
      0x8AEB,0xE67C,      // <cjk>
      0x8AED,0x9740,      // <cjk>
      0x8AEE,0x8E90,      // <cjk>
      0x8AF1,0xE681,      // <cjk>
      0x8AF3,0xE67D,      // <cjk>
      0x8AF7,0xE685,      // <cjk>
      0x8AF8,0x8F94,      // <cjk>
      0x8AFA,0x8CBF,      // <cjk>
      0x8AFE,0x91F8,      // <cjk>
      0x8B00,0x9664,      // <cjk>
      0x8B01,0x8979,      // <cjk>
      0x8B02,0x88E0,      // <cjk>
      0x8B04,0x93A3,      // <cjk>
      0x8B07,0xE689,      // <cjk>
      0x8B0C,0xE688,      // <cjk>
      0x8B0E,0x93E4,      // <cjk>
      0x8B10,0xE68D,      // <cjk>
      0x8B14,0xE682,      // <cjk>
      0x8B16,0xE68C,      // <cjk>
      0x8B17,0xE68E,      // <cjk>
      0x8B19,0x8CAA,      // <cjk>
      0x8B1A,0xE68A,      // <cjk>
      0x8B1B,0x8D75,      // <cjk>
      0x8B1D,0x8ED3,      // <cjk>
      0x8B20,0xE68F,      // <cjk>
      0x8B21,0x9777,      // <cjk>
      0x8B26,0xE692,      // <cjk>
      0x8B28,0xE695,      // <cjk>
      0x8B2B,0xE693,      // <cjk>
      0x8B2C,0x9554,      // <cjk>
      0x8B33,0xE690,      // <cjk>
      0x8B39,0x8BDE,      // <cjk>
      0x8B3E,0xE694,      // <cjk>
      0x8B41,0xE696,      // <cjk>
      0x8B49,0xE69A,      // <cjk>
      0x8B4C,0xE697,      // <cjk>
      0x8B4E,0xE699,      // <cjk>
      0x8B4F,0xE698,      // <cjk>
      0x8B56,0xE69B,      // <cjk>
      0x8B58,0x8EAF,      // <cjk>
      0x8B5A,0xE69D,      // <cjk>
      0x8B5B,0xE69C,      // <cjk>
      0x8B5C,0x9588,      // <cjk>
      0x8B5F,0xE69F,      // <cjk>
      0x8B66,0x8C78,      // <cjk>
      0x8B6B,0xE69E,      // <cjk>
      0x8B6C,0xE6A0,      // <cjk>
      0x8B6F,0xE6A1,      // <cjk>
      0x8B70,0x8B63,      // <cjk>
      0x8B71,0xE3BF,      // <cjk>
      0x8B72,0x8FF7,      // <cjk>
      0x8B74,0xE6A2,      // <cjk>
      0x8B77,0x8CEC,      // <cjk>
      0x8B7D,0xE6A3,      // <cjk>
      0x8B80,0xE6A4,      // <cjk>
      0x8B83,0x8E5D,      // <cjk>
      0x8B8A,0x9DCC,      // <cjk>
      0x8B8C,0xE6A5,      // <cjk>
      0x8B8E,0xE6A6,      // <cjk>
      0x8B90,0x8F51,      // <cjk>
      0x8B92,0xE6A7,      // <cjk>
      0x8B93,0xE6A8,      // <cjk>
      0x8B96,0xE6A9,      // <cjk>
      0x8B99,0xE6AA,      // <cjk>
      0x8B9A,0xE6AB,      // <cjk>
      0x8C37,0x924A,      // <cjk>
      0x8C3A,0xE6AC,      // <cjk>
      0x8C3F,0xE6AE,      // <cjk>
      0x8C41,0xE6AD,      // <cjk>
      0x8C46,0x93A4,      // <cjk>
      0x8C48,0xE6AF,      // <cjk>
      0x8C4A,0x964C,      // <cjk>
      0x8C4C,0xE6B0,      // <cjk>
      0x8C4E,0xE6B1,      // <cjk>
      0x8C50,0xE6B2,      // <cjk>
      0x8C55,0xE6B3,      // <cjk>
      0x8C5A,0x93D8,      // <cjk>
      0x8C61,0x8FDB,      // <cjk>
      0x8C62,0xE6B4,      // <cjk>
      0x8C6A,0x8D8B,      // <cjk>
      0x8C6B,0x98AC,      // <cjk>
      0x8C6C,0xE6B5,      // <cjk>
      0x8C78,0xE6B6,      // <cjk>
      0x8C79,0x955E,      // <cjk>
      0x8C7A,0xE6B7,      // <cjk>
      0x8C7C,0xE6BF,      // <cjk>
      0x8C82,0xE6B8,      // <cjk>
      0x8C85,0xE6BA,      // <cjk>
      0x8C89,0xE6B9,      // <cjk>
      0x8C8A,0xE6BB,      // <cjk>
      0x8C8C,0x9665,      // <cjk>
      0x8C8D,0xE6BC,      // <cjk>
      0x8C8E,0xE6BD,      // <cjk>
      0x8C94,0xE6BE,      // <cjk>
      0x8C98,0xE6C0,      // <cjk>
      0x8C9D,0x8A4C,      // <cjk>
      0x8C9E,0x92E5,      // <cjk>
      0x8CA0,0x9589,      // <cjk>
      0x8CA1,0x8DE0,      // <cjk>
      0x8CA2,0x8D76,      // <cjk>
      0x8CA7,0x956E,      // <cjk>
      0x8CA8,0x89DD,      // <cjk>
      0x8CA9,0x94CC,      // <cjk>
      0x8CAA,0xE6C3,      // <cjk>
      0x8CAB,0x8AD1,      // <cjk>
      0x8CAC,0x90D3,      // <cjk>
      0x8CAD,0xE6C2,      // <cjk>
      0x8CAE,0xE6C7,      // <cjk>
      0x8CAF,0x9299,      // <cjk>
      0x8CB0,0x96E1,      // <cjk>
      0x8CB2,0xE6C5,      // <cjk>
      0x8CB3,0xE6C6,      // <cjk>
      0x8CB4,0x8B4D,      // <cjk>
      0x8CB6,0xE6C8,      // <cjk>
      0x8CB7,0x9483,      // <cjk>
      0x8CB8,0x91DD,      // <cjk>
      0x8CBB,0x94EF,      // <cjk>
      0x8CBC,0x935C,      // <cjk>
      0x8CBD,0xE6C4,      // <cjk>
      0x8CBF,0x9666,      // <cjk>
      0x8CC0,0x89EA,      // <cjk>
      0x8CC1,0xE6CA,      // <cjk>
      0x8CC2,0x9847,      // <cjk>
      0x8CC3,0x92C0,      // <cjk>
      0x8CC4,0x9864,      // <cjk>
      0x8CC7,0x8E91,      // <cjk>
      0x8CC8,0xE6C9,      // <cjk>
      0x8CCA,0x91AF,      // <cjk>
      0x8CCD,0xE6DA,      // <cjk>
      0x8CCE,0x9147,      // <cjk>
      0x8CD1,0x93F6,      // <cjk>
      0x8CD3,0x956F,      // <cjk>
      0x8CDA,0xE6CD,      // <cjk>
      0x8CDB,0x8E5E,      // <cjk>
      0x8CDC,0x8E92,      // <cjk>
      0x8CDE,0x8FDC,      // <cjk>
      0x8CE0,0x9485,      // <cjk>
      0x8CE2,0x8CAB,      // <cjk>
      0x8CE3,0xE6CC,      // <cjk>
      0x8CE4,0xE6CB,      // <cjk>
      0x8CE6,0x958A,      // <cjk>
      0x8CEA,0x8EBF,      // <cjk>
      0x8CED,0x9371,      // <cjk>
      0x8CFA,0xE6CF,      // <cjk>
      0x8CFB,0xE6D0,      // <cjk>
      0x8CFC,0x8D77,      // <cjk>
      0x8CFD,0xE6CE,      // <cjk>
      0x8D04,0xE6D1,      // <cjk>
      0x8D05,0xE6D2,      // <cjk>
      0x8D07,0xE6D4,      // <cjk>
      0x8D08,0x91A1,      // <cjk>
      0x8D0A,0xE6D3,      // <cjk>
      0x8D0B,0x8AE4,      // <cjk>
      0x8D0D,0xE6D6,      // <cjk>
      0x8D0F,0xE6D5,      // <cjk>
      0x8D10,0xE6D7,      // <cjk>
      0x8D13,0xE6D9,      // <cjk>
      0x8D14,0xE6DB,      // <cjk>
      0x8D16,0xE6DC,      // <cjk>
      0x8D64,0x90D4,      // <cjk>
      0x8D66,0x8ECD,      // <cjk>
      0x8D67,0xE6DD,      // <cjk>
      0x8D6B,0x8A71,      // <cjk>
      0x8D6D,0xE6DE,      // <cjk>
      0x8D70,0x9196,      // <cjk>
      0x8D71,0xE6DF,      // <cjk>
      0x8D73,0xE6E0,      // <cjk>
      0x8D74,0x958B,      // <cjk>
      0x8D77,0x8B4E,      // <cjk>
      0x8D81,0xE6E1,      // <cjk>
      0x8D85,0x92B4,      // <cjk>
      0x8D8A,0x897A,      // <cjk>
      0x8D99,0xE6E2,      // <cjk>
      0x8DA3,0x8EEF,      // <cjk>
      0x8DA8,0x9096,      // <cjk>
      0x8DB3,0x91AB,      // <cjk>
      0x8DBA,0xE6E5,      // <cjk>
      0x8DBE,0xE6E4,      // <cjk>
      0x8DC2,0xE6E3,      // <cjk>
      0x8DCB,0xE6EB,      // <cjk>
      0x8DCC,0xE6E9,      // <cjk>
      0x8DCF,0xE6E6,      // <cjk>
      0x8DD6,0xE6E8,      // <cjk>
      0x8DDA,0xE6E7,      // <cjk>
      0x8DDB,0xE6EA,      // <cjk>
      0x8DDD,0x8B97,      // <cjk>
      0x8DDF,0xE6EE,      // <cjk>
      0x8DE1,0x90D5,      // <cjk>
      0x8DE3,0xE6EF,      // <cjk>
      0x8DE8,0x8CD7,      // <cjk>
      0x8DEA,0xE6EC,      // <cjk>
      0x8DEB,0xE6ED,      // <cjk>
      0x8DEF,0x9848,      // <cjk>
      0x8DF3,0x92B5,      // <cjk>
      0x8DF5,0x9148,      // <cjk>
      0x8DFC,0xE6F0,      // <cjk>
      0x8DFF,0xE6F3,      // <cjk>
      0x8E08,0xE6F1,      // <cjk>
      0x8E09,0xE6F2,      // <cjk>
      0x8E0A,0x9778,      // <cjk>
      0x8E0F,0x93A5,      // <cjk>
      0x8E10,0xE6F6,      // <cjk>
      0x8E1D,0xE6F4,      // <cjk>
      0x8E1E,0xE6F5,      // <cjk>
      0x8E1F,0xE6F7,      // <cjk>
      0x8E2A,0xE748,      // <cjk>
      0x8E30,0xE6FA,      // <cjk>
      0x8E34,0xE6FB,      // <cjk>
      0x8E35,0xE6F9,      // <cjk>
      0x8E42,0xE6F8,      // <cjk>
      0x8E44,0x92FB,      // <cjk>
      0x8E47,0xE740,      // <cjk>
      0x8E48,0xE744,      // <cjk>
      0x8E49,0xE741,      // <cjk>
      0x8E4A,0xE6FC,      // <cjk>
      0x8E4C,0xE742,      // <cjk>
      0x8E50,0xE743,      // <cjk>
      0x8E55,0xE74A,      // <cjk>
      0x8E59,0xE745,      // <cjk>
      0x8E5F,0x90D6,      // <cjk>
      0x8E60,0xE747,      // <cjk>
      0x8E63,0xE749,      // <cjk>
      0x8E64,0xE746,      // <cjk>
      0x8E72,0xE74C,      // <cjk>
      0x8E74,0x8F52,      // <cjk>
      0x8E76,0xE74B,      // <cjk>
      0x8E7C,0xE74D,      // <cjk>
      0x8E81,0xE74E,      // <cjk>
      0x8E84,0xE751,      // <cjk>
      0x8E85,0xE750,      // <cjk>
      0x8E87,0xE74F,      // <cjk>
      0x8E8A,0xE753,      // <cjk>
      0x8E8B,0xE752,      // <cjk>
      0x8E8D,0x96F4,      // <cjk>
      0x8E91,0xE755,      // <cjk>
      0x8E93,0xE754,      // <cjk>
      0x8E94,0xE756,      // <cjk>
      0x8E99,0xE757,      // <cjk>
      0x8EA1,0xE759,      // <cjk>
      0x8EAA,0xE758,      // <cjk>
      0x8EAB,0x9067,      // <cjk>
      0x8EAC,0xE75A,      // <cjk>
      0x8EAF,0x8BEB,      // <cjk>
      0x8EB1,0xE75D,      // <cjk>
      0x8EBE,0xE75E,      // <cjk>
      0x8EC5,0xE75F,      // <cjk>
      0x8EC6,0xE75C,      // <cjk>
      0x8EC8,0xE760,      // <cjk>
      0x8ECA,0x8ED4,      // <cjk>
      0x8ECB,0xE761,      // <cjk>
      0x8ECC,0x8B4F,      // <cjk>
      0x8ECD,0x8C52,      // <cjk>
      0x8ED2,0x8CAC,      // <cjk>
      0x8EDB,0xE762,      // <cjk>
      0x8EDF,0x93EE,      // <cjk>
      0x8EE2,0x935D,      // <cjk>
      0x8EE3,0xE763,      // <cjk>
      0x8EEB,0xE766,      // <cjk>
      0x8EF8,0x8EB2,      // <cjk>
      0x8EFB,0xE765,      // <cjk>
      0x8EFC,0xE764,      // <cjk>
      0x8EFD,0x8C79,      // <cjk>
      0x8EFE,0xE767,      // <cjk>
      0x8F03,0x8A72,      // <cjk>
      0x8F05,0xE769,      // <cjk>
      0x8F09,0x8DDA,      // <cjk>
      0x8F0A,0xE768,      // <cjk>
      0x8F0C,0xE771,      // <cjk>
      0x8F12,0xE76B,      // <cjk>
      0x8F13,0xE76D,      // <cjk>
      0x8F14,0x95E3,      // <cjk>
      0x8F15,0xE76A,      // <cjk>
      0x8F19,0xE76C,      // <cjk>
      0x8F1B,0xE770,      // <cjk>
      0x8F1C,0xE76E,      // <cjk>
      0x8F1D,0x8B50,      // <cjk>
      0x8F1F,0xE76F,      // <cjk>
      0x8F26,0xE772,      // <cjk>
      0x8F29,0x9479,      // <cjk>
      0x8F2A,0x97D6,      // <cjk>
      0x8F2F,0x8F53,      // <cjk>
      0x8F33,0xE773,      // <cjk>
      0x8F38,0x9741,      // <cjk>
      0x8F39,0xE775,      // <cjk>
      0x8F3B,0xE774,      // <cjk>
      0x8F3E,0xE778,      // <cjk>
      0x8F3F,0x9760,      // <cjk>
      0x8F42,0xE777,      // <cjk>
      0x8F44,0x8A8D,      // <cjk>
      0x8F45,0xE776,      // <cjk>
      0x8F46,0xE77B,      // <cjk>
      0x8F49,0xE77A,      // <cjk>
      0x8F4C,0xE779,      // <cjk>
      0x8F4D,0x9351,      // <cjk>
      0x8F4E,0xE77C,      // <cjk>
      0x8F57,0xE77D,      // <cjk>
      0x8F5C,0xE77E,      // <cjk>
      0x8F5F,0x8D8C,      // <cjk>
      0x8F61,0x8C44,      // <cjk>
      0x8F62,0xE780,      // <cjk>
      0x8F63,0xE781,      // <cjk>
      0x8F64,0xE782,      // <cjk>
      0x8F9B,0x9068,      // <cjk>
      0x8F9C,0xE783,      // <cjk>
      0x8F9E,0x8EAB,      // <cjk>
      0x8F9F,0xE784,      // <cjk>
      0x8FA3,0xE785,      // <cjk>
      0x8FA7,0x999F,      // <cjk>
      0x8FA8,0x999E,      // <cjk>
      0x8FAD,0xE786,      // <cjk>
      0x8FAE,0xE390,      // <cjk>
      0x8FAF,0xE787,      // <cjk>
      0x8FB0,0x9243,      // <cjk>
      0x8FB1,0x904A,      // <cjk>
      0x8FB2,0x945F,      // <cjk>
      0x8FB7,0xE788,      // <cjk>
      0x8FBA,0x95D3,      // <cjk>
      0x8FBB,0x92D2,      // <cjk>
      0x8FBC,0x8D9E,      // <cjk>
      0x8FBF,0x9248,      // <cjk>
      0x8FC2,0x8949,      // <cjk>
      0x8FC4,0x9698,      // <cjk>
      0x8FC5,0x9076,      // <cjk>
      0x8FCE,0x8C7D,      // <cjk>
      0x8FD1,0x8BDF,      // <cjk>
      0x8FD4,0x95D4,      // <cjk>
      0x8FDA,0xE789,      // <cjk>
      0x8FE2,0xE78B,      // <cjk>
      0x8FE5,0xE78A,      // <cjk>
      0x8FE6,0x89DE,      // <cjk>
      0x8FE9,0x93F4,      // <cjk>
      0x8FEA,0xE78C,      // <cjk>
      0x8FEB,0x9497,      // <cjk>
      0x8FED,0x9352,      // <cjk>
      0x8FEF,0xE78D,      // <cjk>
      0x8FF0,0x8F71,      // <cjk>
      0x8FF4,0xE78F,      // <cjk>
      0x8FF7,0x96C0,      // <cjk>
      0x8FF8,0xE79E,      // <cjk>
      0x8FF9,0xE791,      // <cjk>
      0x8FFA,0xE792,      // <cjk>
      0x8FFD,0x92C7,      // <cjk>
      0x9000,0x91DE,      // <cjk>
      0x9001,0x9197,      // <cjk>
      0x9003,0x93A6,      // <cjk>
      0x9005,0xE790,      // <cjk>
      0x9006,0x8B74,      // <cjk>
      0x900B,0xE799,      // <cjk>
      0x900D,0xE796,      // <cjk>
      0x900E,0xE7A3,      // <cjk>
      0x900F,0x93A7,      // <cjk>
      0x9010,0x9280,      // <cjk>
      0x9011,0xE793,      // <cjk>
      0x9013,0x92FC,      // <cjk>
      0x9014,0x9372,      // <cjk>
      0x9015,0xE794,      // <cjk>
      0x9016,0xE798,      // <cjk>
      0x9017,0x9080,      // <cjk>
      0x9019,0x9487,      // <cjk>
      0x901A,0x92CA,      // <cjk>
      0x901D,0x90C0,      // <cjk>
      0x901E,0xE797,      // <cjk>
      0x901F,0x91AC,      // <cjk>
      0x9020,0x91A2,      // <cjk>
      0x9021,0xE795,      // <cjk>
      0x9022,0x88A7,      // <cjk>
      0x9023,0x9841,      // <cjk>
      0x9027,0xE79A,      // <cjk>
      0x902E,0x91DF,      // <cjk>
      0x9031,0x8F54,      // <cjk>
      0x9032,0x9069,      // <cjk>
      0x9035,0xE79C,      // <cjk>
      0x9036,0xE79B,      // <cjk>
      0x9038,0x88ED,      // <cjk>
      0x9039,0xE79D,      // <cjk>
      0x903C,0x954E,      // <cjk>
      0x903E,0xE7A5,      // <cjk>
      0x9041,0x93D9,      // <cjk>
      0x9042,0x908B,      // <cjk>
      0x9045,0x9278,      // <cjk>
      0x9047,0x8BF6,      // <cjk>
      0x9049,0xE7A4,      // <cjk>
      0x904A,0x9756,      // <cjk>
      0x904B,0x895E,      // <cjk>
      0x904D,0x95D5,      // <cjk>
      0x904E,0x89DF,      // <cjk>
      0x904F,0xE79F,      // <cjk>
      0x9050,0xE7A0,      // <cjk>
      0x9051,0xE7A1,      // <cjk>
      0x9052,0xE7A2,      // <cjk>
      0x9053,0x93B9,      // <cjk>
      0x9054,0x9242,      // <cjk>
      0x9055,0x88E1,      // <cjk>
      0x9056,0xE7A6,      // <cjk>
      0x9058,0xE7A7,      // <cjk>
      0x9059,0xEAA1,      // <cjk>
      0x905C,0x91BB,      // <cjk>
      0x905E,0xE7A8,      // <cjk>
      0x9060,0x8993,      // <cjk>
      0x9061,0x916B,      // <cjk>
      0x9063,0x8CAD,      // <cjk>
      0x9065,0x9779,      // <cjk>
      0x9068,0xE7A9,      // <cjk>
      0x9069,0x934B,      // <cjk>
      0x906D,0x9198,      // <cjk>
      0x906E,0x8ED5,      // <cjk>
      0x906F,0xE7AA,      // <cjk>
      0x9072,0xE7AD,      // <cjk>
      0x9075,0x8F85,      // <cjk>
      0x9076,0xE7AB,      // <cjk>
      0x9077,0x914A,      // <cjk>
      0x9078,0x9149,      // <cjk>
      0x907A,0x88E2,      // <cjk>
      0x907C,0x97C9,      // <cjk>
      0x907D,0xE7AF,      // <cjk>
      0x907F,0x94F0,      // <cjk>
      0x9080,0xE7B1,      // <cjk>
      0x9081,0xE7B0,      // <cjk>
      0x9082,0xE7AE,      // <cjk>
      0x9083,0xE284,      // <cjk>
      0x9084,0x8AD2,      // <cjk>
      0x9087,0xE78E,      // <cjk>
      0x9089,0xE7B3,      // <cjk>
      0x908A,0xE7B2,      // <cjk>
      0x908F,0xE7B4,      // <cjk>
      0x9091,0x9757,      // <cjk>
      0x90A3,0x93DF,      // <cjk>
      0x90A6,0x964D,      // <cjk>
      0x90A8,0xE7B5,      // <cjk>
      0x90AA,0x8ED7,      // <cjk>
      0x90AF,0xE7B6,      // <cjk>
      0x90B1,0xE7B7,      // <cjk>
      0x90B5,0xE7B8,      // <cjk>
      0x90B8,0x9340,      // <cjk>
      0x90C1,0x88E8,      // <cjk>
      0x90CA,0x8D78,      // <cjk>
      0x90CE,0x9859,      // <cjk>
      0x90DB,0xE7BC,      // <cjk>
      0x90E1,0x8C53,      // <cjk>
      0x90E2,0xE7B9,      // <cjk>
      0x90E4,0xE7BA,      // <cjk>
      0x90E8,0x9594,      // <cjk>
      0x90ED,0x8A73,      // <cjk>
      0x90F5,0x9758,      // <cjk>
      0x90F7,0x8BBD,      // <cjk>
      0x90FD,0x9373,      // <cjk>
      0x9102,0xE7BD,      // <cjk>
      0x9112,0xE7BE,      // <cjk>
      0x9119,0xE7BF,      // <cjk>
      0x912D,0x9341,      // <cjk>
      0x9130,0xE7C1,      // <cjk>
      0x9132,0xE7C0,      // <cjk>
      0x9149,0x93D1,      // <cjk>
      0x914A,0xE7C2,      // <cjk>
      0x914B,0x8F55,      // <cjk>
      0x914C,0x8EDE,      // <cjk>
      0x914D,0x947A,      // <cjk>
      0x914E,0x9291,      // <cjk>
      0x9152,0x8EF0,      // <cjk>
      0x9154,0x908C,      // <cjk>
      0x9156,0xE7C3,      // <cjk>
      0x9158,0xE7C4,      // <cjk>
      0x9162,0x907C,      // <cjk>
      0x9163,0xE7C5,      // <cjk>
      0x9165,0xE7C6,      // <cjk>
      0x9169,0xE7C7,      // <cjk>
      0x916A,0x978F,      // <cjk>
      0x916C,0x8F56,      // <cjk>
      0x9172,0xE7C9,      // <cjk>
      0x9173,0xE7C8,      // <cjk>
      0x9175,0x8D79,      // <cjk>
      0x9177,0x8D93,      // <cjk>
      0x9178,0x8E5F,      // <cjk>
      0x9182,0xE7CC,      // <cjk>
      0x9187,0x8F86,      // <cjk>
      0x9189,0xE7CB,      // <cjk>
      0x918B,0xE7CA,      // <cjk>
      0x918D,0x91E7,      // <cjk>
      0x9190,0x8CED,      // <cjk>
      0x9192,0x90C1,      // <cjk>
      0x9197,0x94AE,      // <cjk>
      0x919C,0x8F58,      // <cjk>
      0x91A2,0xE7CD,      // <cjk>
      0x91A4,0x8FDD,      // <cjk>
      0x91AA,0xE7D0,      // <cjk>
      0x91AB,0xE7CE,      // <cjk>
      0x91AF,0xE7CF,      // <cjk>
      0x91B4,0xE7D2,      // <cjk>
      0x91B5,0xE7D1,      // <cjk>
      0x91B8,0x8FF8,      // <cjk>
      0x91BA,0xE7D3,      // <cjk>
      0x91C0,0xE7D4,      // <cjk>
      0x91C1,0xE7D5,      // <cjk>
      0x91C6,0x94CE,      // <cjk>
      0x91C7,0x8DD1,      // <cjk>
      0x91C8,0x8EDF,      // <cjk>
      0x91C9,0xE7D6,      // <cjk>
      0x91CB,0xE7D7,      // <cjk>
      0x91CC,0x97A2,      // <cjk>
      0x91CD,0x8F64,      // <cjk>
      0x91CE,0x96EC,      // <cjk>
      0x91CF,0x97CA,      // <cjk>
      0x91D0,0xE7D8,      // <cjk>
      0x91D1,0x8BE0,      // <cjk>
      0x91D6,0xE7D9,      // <cjk>
      0x91D8,0x9342,      // <cjk>
      0x91DB,0xE7DC,      // <cjk>
      0x91DC,0x8A98,      // <cjk>
      0x91DD,0x906A,      // <cjk>
      0x91DF,0xE7DA,      // <cjk>
      0x91E1,0xE7DB,      // <cjk>
      0x91E3,0x92DE,      // <cjk>
      0x91E6,0x9674,      // <cjk>
      0x91E7,0x8BFA,      // <cjk>
      0x91F5,0xE7DE,      // <cjk>
      0x91F6,0xE7DF,      // <cjk>
      0x91FC,0xE7DD,      // <cjk>
      0x91FF,0xE7E1,      // <cjk>
      0x920D,0x93DD,      // <cjk>
      0x920E,0x8A62,      // <cjk>
      0x9211,0xE7E5,      // <cjk>
      0x9214,0xE7E2,      // <cjk>
      0x9215,0xE7E4,      // <cjk>
      0x921E,0xE7E0,      // <cjk>
      0x9229,0xE86E,      // <cjk>
      0x922C,0xE7E3,      // <cjk>
      0x9234,0x97E9,      // <cjk>
      0x9237,0x8CD8,      // <cjk>
      0x923F,0xE7ED,      // <cjk>
      0x9244,0x9353,      // <cjk>
      0x9245,0xE7E8,      // <cjk>
      0x9248,0xE7EB,      // <cjk>
      0x9249,0xE7E9,      // <cjk>
      0x924B,0xE7EE,      // <cjk>
      0x9250,0xE7EF,      // <cjk>
      0x9257,0xE7E7,      // <cjk>
      0x925A,0xE7F4,      // <cjk>
      0x925B,0x8994,      // <cjk>
      0x925E,0xE7E6,      // <cjk>
      0x9262,0x94AB,      // <cjk>
      0x9264,0xE7EA,      // <cjk>
      0x9266,0x8FDE,      // <cjk>
      0x9271,0x8D7A,      // <cjk>
      0x927E,0x9667,      // <cjk>
      0x9280,0x8BE2,      // <cjk>
      0x9283,0x8F65,      // <cjk>
      0x9285,0x93BA,      // <cjk>
      0x9291,0x914C,      // <cjk>
      0x9293,0xE7F2,      // <cjk>
      0x9295,0xE7EC,      // <cjk>
      0x9296,0xE7F1,      // <cjk>
      0x9298,0x96C1,      // <cjk>
      0x929A,0x92B6,      // <cjk>
      0x929B,0xE7F3,      // <cjk>
      0x929C,0xE7F0,      // <cjk>
      0x92AD,0x914B,      // <cjk>
      0x92B7,0xE7F7,      // <cjk>
      0x92B9,0xE7F6,      // <cjk>
      0x92CF,0xE7F5,      // <cjk>
      0x92D2,0x964E,      // <cjk>
      0x92E4,0x8F9B,      // <cjk>
      0x92E9,0xE7F8,      // <cjk>
      0x92EA,0x95DD,      // <cjk>
      0x92ED,0x8973,      // <cjk>
      0x92F2,0x9565,      // <cjk>
      0x92F3,0x9292,      // <cjk>
      0x92F8,0x8B98,      // <cjk>
      0x92FA,0xE7FA,      // <cjk>
      0x92FC,0x8D7C,      // <cjk>
      0x9306,0x8E4B,      // <cjk>
      0x930F,0xE7F9,      // <cjk>
      0x9310,0x908D,      // <cjk>
      0x9318,0x908E,      // <cjk>
      0x9319,0xE840,      // <cjk>
      0x931A,0xE842,      // <cjk>
      0x9320,0x8FF9,      // <cjk>
      0x9322,0xE841,      // <cjk>
      0x9323,0xE843,      // <cjk>
      0x9326,0x8BD1,      // <cjk>
      0x9328,0x9564,      // <cjk>
      0x932B,0x8EE0,      // <cjk>
      0x932C,0x9842,      // <cjk>
      0x932E,0xE7FC,      // <cjk>
      0x932F,0x8DF6,      // <cjk>
      0x9332,0x985E,      // <cjk>
      0x9335,0xE845,      // <cjk>
      0x933A,0xE844,      // <cjk>
      0x933B,0xE846,      // <cjk>
      0x9344,0xE7FB,      // <cjk>
      0x934B,0x93E7,      // <cjk>
      0x934D,0x9374,      // <cjk>
      0x9354,0x92D5,      // <cjk>
      0x9356,0xE84B,      // <cjk>
      0x935B,0x9262,      // <cjk>
      0x935C,0xE847,      // <cjk>
      0x9360,0xE848,      // <cjk>
      0x936C,0x8C4C,      // <cjk>
      0x936E,0xE84A,      // <cjk>
      0x9375,0x8CAE,      // <cjk>
      0x937C,0xE849,      // <cjk>
      0x937E,0x8FDF,      // <cjk>
      0x938C,0x8A99,      // <cjk>
      0x9394,0xE84F,      // <cjk>
      0x9396,0x8DBD,      // <cjk>
      0x9397,0x9199,      // <cjk>
      0x939A,0x92C8,      // <cjk>
      0x93A7,0x8A5A,      // <cjk>
      0x93AC,0xE84D,      // <cjk>
      0x93AD,0xE84E,      // <cjk>
      0x93AE,0x92C1,      // <cjk>
      0x93B0,0xE84C,      // <cjk>
      0x93B9,0xE850,      // <cjk>
      0x93C3,0xE856,      // <cjk>
      0x93C8,0xE859,      // <cjk>
      0x93D0,0xE858,      // <cjk>
      0x93D1,0x934C,      // <cjk>
      0x93D6,0xE851,      // <cjk>
      0x93D7,0xE852,      // <cjk>
      0x93D8,0xE855,      // <cjk>
      0x93DD,0xE857,      // <cjk>
      0x93E1,0x8BBE,      // <cjk>
      0x93E4,0xE85A,      // <cjk>
      0x93E5,0xE854,      // <cjk>
      0x93E8,0xE853,      // <cjk>
      0x9403,0xE85E,      // <cjk>
      0x9407,0xE85F,      // <cjk>
      0x9410,0xE860,      // <cjk>
      0x9413,0xE85D,      // <cjk>
      0x9414,0xE85C,      // <cjk>
      0x9418,0x8FE0,      // <cjk>
      0x9419,0x93A8,      // <cjk>
      0x9421,0xE864,      // <cjk>
      0x942B,0xE862,      // <cjk>
      0x9435,0xE863,      // <cjk>
      0x9436,0xE861,      // <cjk>
      0x9438,0x91F6,      // <cjk>
      0x943A,0xE865,      // <cjk>
      0x9441,0xE866,      // <cjk>
      0x9444,0xE868,      // <cjk>
      0x9451,0x8AD3,      // <cjk>
      0x9452,0xE867,      // <cjk>
      0x9453,0x96F8,      // <cjk>
      0x945A,0xE873,      // <cjk>
      0x945B,0xE869,      // <cjk>
      0x945E,0xE86C,      // <cjk>
      0x9460,0xE86A,      // <cjk>
      0x9462,0xE86B,      // <cjk>
      0x946A,0xE86D,      // <cjk>
      0x9470,0xE86F,      // <cjk>
      0x9475,0xE870,      // <cjk>
      0x9477,0xE871,      // <cjk>
      0x947C,0xE874,      // <cjk>
      0x947D,0xE872,      // <cjk>
      0x947E,0xE875,      // <cjk>
      0x947F,0xE877,      // <cjk>
      0x9481,0xE876,      // <cjk>
      0x9577,0x92B7,      // <cjk>
      0x9580,0x96E5,      // <cjk>
      0x9582,0xE878,      // <cjk>
      0x9583,0x914D,      // <cjk>
      0x9587,0xE879,      // <cjk>
      0x9589,0x95C2,      // <cjk>
      0x958A,0xE87A,      // <cjk>
      0x958B,0x8A4A,      // <cjk>
      0x9591,0x8AD5,      // <cjk>
      0x9593,0x8AD4,      // <cjk>
      0x9594,0xE87B,      // <cjk>
      0x9596,0xE87C,      // <cjk>
      0x9598,0xE87D,      // <cjk>
      0x9599,0xE87E,      // <cjk>
      0x95A0,0xE880,      // <cjk>
      0x95A2,0x8AD6,      // <cjk>
      0x95A3,0x8A74,      // <cjk>
      0x95A4,0x8D7D,      // <cjk>
      0x95A5,0x94B4,      // <cjk>
      0x95A7,0xE882,      // <cjk>
      0x95A8,0xE881,      // <cjk>
      0x95AD,0xE883,      // <cjk>
      0x95B2,0x897B,      // <cjk>
      0x95B9,0xE886,      // <cjk>
      0x95BB,0xE885,      // <cjk>
      0x95BC,0xE884,      // <cjk>
      0x95BE,0xE887,      // <cjk>
      0x95C3,0xE88A,      // <cjk>
      0x95C7,0x88C5,      // <cjk>
      0x95CA,0xE888,      // <cjk>
      0x95CC,0xE88C,      // <cjk>
      0x95CD,0xE88B,      // <cjk>
      0x95D4,0xE88E,      // <cjk>
      0x95D5,0xE88D,      // <cjk>
      0x95D6,0xE88F,      // <cjk>
      0x95D8,0x93AC,      // <cjk>
      0x95DC,0xE890,      // <cjk>
      0x95E1,0xE891,      // <cjk>
      0x95E2,0xE893,      // <cjk>
      0x95E5,0xE892,      // <cjk>
      0x961C,0x958C,      // <cjk>
      0x9621,0xE894,      // <cjk>
      0x9628,0xE895,      // <cjk>
      0x962A,0x8DE3,      // <cjk>
      0x962E,0xE896,      // <cjk>
      0x962F,0xE897,      // <cjk>
      0x9632,0x9668,      // <cjk>
      0x963B,0x916A,      // <cjk>
      0x963F,0x88A2,      // <cjk>
      0x9640,0x91C9,      // <cjk>
      0x9642,0xE898,      // <cjk>
      0x9644,0x958D,      // <cjk>
      0x964B,0xE89B,      // <cjk>
      0x964C,0xE899,      // <cjk>
      0x964D,0x8D7E,      // <cjk>
      0x964F,0xE89A,      // <cjk>
      0x9650,0x8CC0,      // <cjk>
      0x965B,0x95C3,      // <cjk>
      0x965C,0xE89D,      // <cjk>
      0x965D,0xE89F,      // <cjk>
      0x965E,0xE89E,      // <cjk>
      0x965F,0xE8A0,      // <cjk>
      0x9662,0x8940,      // <cjk>
      0x9663,0x9077,      // <cjk>
      0x9664,0x8F9C,      // <cjk>
      0x9665,0x8AD7,      // <cjk>
      0x9666,0xE8A1,      // <cjk>
      0x966A,0x9486,      // <cjk>
      0x966C,0xE8A3,      // <cjk>
      0x9670,0x8941,      // <cjk>
      0x9672,0xE8A2,      // <cjk>
      0x9673,0x92C2,      // <cjk>
      0x9675,0x97CB,      // <cjk>
      0x9676,0x93A9,      // <cjk>
      0x9677,0xE89C,      // <cjk>
      0x9678,0x97A4,      // <cjk>
      0x967A,0x8CAF,      // <cjk>
      0x967D,0x977A,      // <cjk>
      0x9685,0x8BF7,      // <cjk>
      0x9686,0x97B2,      // <cjk>
      0x9688,0x8C47,      // <cjk>
      0x968A,0x91E0,      // <cjk>
      0x968B,0xE440,      // <cjk>
      0x968D,0xE8A4,      // <cjk>
      0x968E,0x8A4B,      // <cjk>
      0x968F,0x908F,      // <cjk>
      0x9694,0x8A75,      // <cjk>
      0x9695,0xE8A6,      // <cjk>
      0x9697,0xE8A7,      // <cjk>
      0x9698,0xE8A5,      // <cjk>
      0x9699,0x8C84,      // <cjk>
      0x969B,0x8DDB,      // <cjk>
      0x969C,0x8FE1,      // <cjk>
      0x96A0,0x8942,      // <cjk>
      0x96A3,0x97D7,      // <cjk>
      0x96A7,0xE8A9,      // <cjk>
      0x96A8,0xE7AC,      // <cjk>
      0x96AA,0xE8A8,      // <cjk>
      0x96B0,0xE8AC,      // <cjk>
      0x96B1,0xE8AA,      // <cjk>
      0x96B2,0xE8AB,      // <cjk>
      0x96B4,0xE8AD,      // <cjk>
      0x96B6,0xE8AE,      // <cjk>
      0x96B7,0x97EA,      // <cjk>
      0x96B8,0xE8AF,      // <cjk>
      0x96B9,0xE8B0,      // <cjk>
      0x96BB,0x90C7,      // <cjk>
      0x96BC,0x94B9,      // <cjk>
      0x96C0,0x909D,      // <cjk>
      0x96C1,0x8AE5,      // <cjk>
      0x96C4,0x9759,      // <cjk>
      0x96C5,0x89EB,      // <cjk>
      0x96C6,0x8F57,      // <cjk>
      0x96C7,0x8CD9,      // <cjk>
      0x96C9,0xE8B3,      // <cjk>
      0x96CB,0xE8B2,      // <cjk>
      0x96CC,0x8E93,      // <cjk>
      0x96CD,0xE8B4,      // <cjk>
      0x96CE,0xE8B1,      // <cjk>
      0x96D1,0x8E47,      // <cjk>
      0x96D5,0xE8B8,      // <cjk>
      0x96D6,0xE5AB,      // <cjk>
      0x96D9,0x99D4,      // <cjk>
      0x96DB,0x9097,      // <cjk>
      0x96DC,0xE8B6,      // <cjk>
      0x96E2,0x97A3,      // <cjk>
      0x96E3,0x93EF,      // <cjk>
      0x96E8,0x894A,      // <cjk>
      0x96EA,0x90E1,      // <cjk>
      0x96EB,0x8EB4,      // <cjk>
      0x96F0,0x95B5,      // <cjk>
      0x96F2,0x895F,      // <cjk>
      0x96F6,0x97EB,      // <cjk>
      0x96F7,0x978B,      // <cjk>
      0x96F9,0xE8B9,      // <cjk>
      0x96FB,0x9364,      // <cjk>
      0x9700,0x8EF9,      // <cjk>
      0x9704,0xE8BA,      // <cjk>
      0x9706,0xE8BB,      // <cjk>
      0x9707,0x906B,      // <cjk>
      0x9708,0xE8BC,      // <cjk>
      0x970A,0x97EC,      // <cjk>
      0x970D,0xE8B7,      // <cjk>
      0x970E,0xE8BE,      // <cjk>
      0x970F,0xE8C0,      // <cjk>
      0x9711,0xE8BF,      // <cjk>
      0x9713,0xE8BD,      // <cjk>
      0x9716,0xE8C1,      // <cjk>
      0x9719,0xE8C2,      // <cjk>
      0x971C,0x919A,      // <cjk>
      0x971E,0x89E0,      // <cjk>
      0x9724,0xE8C3,      // <cjk>
      0x9727,0x96B6,      // <cjk>
      0x972A,0xE8C4,      // <cjk>
      0x9730,0xE8C5,      // <cjk>
      0x9732,0x9849,      // <cjk>
      0x9738,0x9E50,      // <cjk>
      0x9739,0xE8C6,      // <cjk>
      0x973D,0xE8C7,      // <cjk>
      0x973E,0xE8C8,      // <cjk>
      0x9742,0xE8CC,      // <cjk>
      0x9744,0xE8C9,      // <cjk>
      0x9746,0xE8CA,      // <cjk>
      0x9748,0xE8CB,      // <cjk>
      0x9749,0xE8CD,      // <cjk>
      0x9752,0x90C2,      // <cjk>
      0x9756,0x96F5,      // <cjk>
      0x9759,0x90C3,      // <cjk>
      0x975C,0xE8CE,      // <cjk>
      0x975E,0x94F1,      // <cjk>
      0x9760,0xE8CF,      // <cjk>
      0x9761,0xEA72,      // <cjk>
      0x9762,0x96CA,      // <cjk>
      0x9764,0xE8D0,      // <cjk>
      0x9766,0xE8D1,      // <cjk>
      0x9768,0xE8D2,      // <cjk>
      0x9769,0x8A76,      // <cjk>
      0x976B,0xE8D4,      // <cjk>
      0x976D,0x9078,      // <cjk>
      0x9771,0xE8D5,      // <cjk>
      0x9774,0x8C43,      // <cjk>
      0x9779,0xE8D6,      // <cjk>
      0x977A,0xE8DA,      // <cjk>
      0x977C,0xE8D8,      // <cjk>
      0x9781,0xE8D9,      // <cjk>
      0x9784,0x8A93,      // <cjk>
      0x9785,0xE8D7,      // <cjk>
      0x9786,0xE8DB,      // <cjk>
      0x978B,0xE8DC,      // <cjk>
      0x978D,0x88C6,      // <cjk>
      0x978F,0xE8DD,      // <cjk>
      0x9790,0xE8DE,      // <cjk>
      0x9798,0x8FE2,      // <cjk>
      0x979C,0xE8DF,      // <cjk>
      0x97A0,0x8B66,      // <cjk>
      0x97A3,0xE8E2,      // <cjk>
      0x97A6,0xE8E1,      // <cjk>
      0x97A8,0xE8E0,      // <cjk>
      0x97AB,0xE691,      // <cjk>
      0x97AD,0x95DA,      // <cjk>
      0x97B3,0xE8E3,      // <cjk>
      0x97B4,0xE8E4,      // <cjk>
      0x97C3,0xE8E5,      // <cjk>
      0x97C6,0xE8E6,      // <cjk>
      0x97C8,0xE8E7,      // <cjk>
      0x97CB,0xE8E8,      // <cjk>
      0x97D3,0x8AD8,      // <cjk>
      0x97DC,0xE8E9,      // <cjk>
      0x97ED,0xE8EA,      // <cjk>
      0x97EE,0x9442,      // <cjk>
      0x97F2,0xE8EC,      // <cjk>
      0x97F3,0x89B9,      // <cjk>
      0x97F5,0xE8EF,      // <cjk>
      0x97F6,0xE8EE,      // <cjk>
      0x97FB,0x8943,      // <cjk>
      0x97FF,0x8BBF,      // <cjk>
      0x9801,0x95C5,      // <cjk>
      0x9802,0x92B8,      // <cjk>
      0x9803,0x8DA0,      // <cjk>
      0x9805,0x8D80,      // <cjk>
      0x9806,0x8F87,      // <cjk>
      0x9808,0x907B,      // <cjk>
      0x980C,0xE8F1,      // <cjk>
      0x980F,0xE8F0,      // <cjk>
      0x9810,0x9761,      // <cjk>
      0x9811,0x8AE6,      // <cjk>
      0x9812,0x94D0,      // <cjk>
      0x9813,0x93DA,      // <cjk>
      0x9817,0x909C,      // <cjk>
      0x9818,0x97CC,      // <cjk>
      0x981A,0x8C7A,      // <cjk>
      0x9821,0xE8F4,      // <cjk>
      0x9824,0xE8F3,      // <cjk>
      0x982C,0x966A,      // <cjk>
      0x982D,0x93AA,      // <cjk>
      0x9834,0x896F,      // <cjk>
      0x9837,0xE8F5,      // <cjk>
      0x9838,0xE8F2,      // <cjk>
      0x983B,0x9570,      // <cjk>
      0x983C,0x978A,      // <cjk>
      0x983D,0xE8F6,      // <cjk>
      0x9846,0xE8F7,      // <cjk>
      0x984B,0xE8F9,      // <cjk>
      0x984C,0x91E8,      // <cjk>
      0x984D,0x8A7A,      // <cjk>
      0x984E,0x8A7B,      // <cjk>
      0x984F,0xE8F8,      // <cjk>
      0x9854,0x8AE7,      // <cjk>
      0x9855,0x8CB0,      // <cjk>
      0x9858,0x8AE8,      // <cjk>
      0x985B,0x935E,      // <cjk>
      0x985E,0x97DE,      // <cjk>
      0x9867,0x8CDA,      // <cjk>
      0x986B,0xE8FA,      // <cjk>
      0x986F,0xE8FB,      // <cjk>
      0x9870,0xE8FC,      // <cjk>
      0x9871,0xE940,      // <cjk>
      0x9873,0xE942,      // <cjk>
      0x9874,0xE941,      // <cjk>
      0x98A8,0x9597,      // <cjk>
      0x98AA,0xE943,      // <cjk>
      0x98AF,0xE944,      // <cjk>
      0x98B1,0xE945,      // <cjk>
      0x98B6,0xE946,      // <cjk>
      0x98C3,0xE948,      // <cjk>
      0x98C4,0xE947,      // <cjk>
      0x98C6,0xE949,      // <cjk>
      0x98DB,0x94F2,      // <cjk>
      0x98DC,0xE3CA,      // <cjk>
      0x98DF,0x9048,      // <cjk>
      0x98E2,0x8B51,      // <cjk>
      0x98E9,0xE94A,      // <cjk>
      0x98EB,0xE94B,      // <cjk>
      0x98ED,0x99AA,      // <cjk>
      0x98EE,0x9F5A,      // <cjk>
      0x98EF,0x94D1,      // <cjk>
      0x98F2,0x88F9,      // <cjk>
      0x98F4,0x88B9,      // <cjk>
      0x98FC,0x8E94,      // <cjk>
      0x98FD,0x964F,      // <cjk>
      0x98FE,0x8FFC,      // <cjk>
      0x9903,0xE94C,      // <cjk>
      0x9905,0x96DD,      // <cjk>
      0x9909,0xE94D,      // <cjk>
      0x990A,0x977B,      // <cjk>
      0x990C,0x8961,      // <cjk>
      0x9910,0x8E60,      // <cjk>
      0x9912,0xE94E,      // <cjk>
      0x9913,0x89EC,      // <cjk>
      0x9914,0xE94F,      // <cjk>
      0x9918,0xE950,      // <cjk>
      0x991D,0xE952,      // <cjk>
      0x991E,0xE953,      // <cjk>
      0x9920,0xE955,      // <cjk>
      0x9921,0xE951,      // <cjk>
      0x9924,0xE954,      // <cjk>
      0x9928,0x8AD9,      // <cjk>
      0x992C,0xE956,      // <cjk>
      0x992E,0xE957,      // <cjk>
      0x993D,0xE958,      // <cjk>
      0x993E,0xE959,      // <cjk>
      0x9942,0xE95A,      // <cjk>
      0x9945,0xE95C,      // <cjk>
      0x994B,0xE95E,      // <cjk>
      0x994C,0xE961,      // <cjk>
      0x9950,0xE95D,      // <cjk>
      0x9951,0xE95F,      // <cjk>
      0x9952,0xE960,      // <cjk>
      0x9955,0xE962,      // <cjk>
      0x9957,0x8BC0,      // <cjk>
      0x9996,0x8EF1,      // <cjk>
      0x9997,0xE963,      // <cjk>
      0x9998,0xE964,      // <cjk>
      0x9999,0x8D81,      // <cjk>
      0x99A5,0xE965,      // <cjk>
      0x99A8,0x8A5D,      // <cjk>
      0x99AC,0x946E,      // <cjk>
      0x99AD,0xE966,      // <cjk>
      0x99AE,0xE967,      // <cjk>
      0x99B3,0x9279,      // <cjk>
      0x99B4,0x93E9,      // <cjk>
      0x99BC,0xE968,      // <cjk>
      0x99C1,0x949D,      // <cjk>
      0x99C4,0x91CA,      // <cjk>
      0x99C5,0x8977,      // <cjk>
      0x99C6,0x8BEC,      // <cjk>
      0x99C8,0x8BED,      // <cjk>
      0x99D0,0x9293,      // <cjk>
      0x99D1,0xE96D,      // <cjk>
      0x99D2,0x8BEE,      // <cjk>
      0x99D5,0x89ED,      // <cjk>
      0x99D8,0xE96C,      // <cjk>
      0x99DB,0xE96A,      // <cjk>
      0x99DD,0xE96B,      // <cjk>
      0x99DF,0xE969,      // <cjk>
      0x99E2,0xE977,      // <cjk>
      0x99ED,0xE96E,      // <cjk>
      0x99EE,0xE96F,      // <cjk>
      0x99F1,0xE970,      // <cjk>
      0x99F2,0xE971,      // <cjk>
      0x99F8,0xE973,      // <cjk>
      0x99FB,0xE972,      // <cjk>
      0x99FF,0x8F78,      // <cjk>
      0x9A01,0xE974,      // <cjk>
      0x9A05,0xE976,      // <cjk>
      0x9A0E,0x8B52,      // <cjk>
      0x9A0F,0xE975,      // <cjk>
      0x9A12,0x919B,      // <cjk>
      0x9A13,0x8CB1,      // <cjk>
      0x9A19,0xE978,      // <cjk>
      0x9A28,0x91CB,      // <cjk>
      0x9A2B,0xE979,      // <cjk>
      0x9A30,0x93AB,      // <cjk>
      0x9A37,0xE97A,      // <cjk>
      0x9A3E,0xE980,      // <cjk>
      0x9A40,0xE97D,      // <cjk>
      0x9A42,0xE97C,      // <cjk>
      0x9A43,0xE97E,      // <cjk>
      0x9A45,0xE97B,      // <cjk>
      0x9A4D,0xE982,      // <cjk>
      0x9A55,0xE981,      // <cjk>
      0x9A57,0xE984,      // <cjk>
      0x9A5A,0x8BC1,      // <cjk>
      0x9A5B,0xE983,      // <cjk>
      0x9A5F,0xE985,      // <cjk>
      0x9A62,0xE986,      // <cjk>
      0x9A64,0xE988,      // <cjk>
      0x9A65,0xE987,      // <cjk>
      0x9A69,0xE989,      // <cjk>
      0x9A6A,0xE98B,      // <cjk>
      0x9A6B,0xE98A,      // <cjk>
      0x9AA8,0x8D9C,      // <cjk>
      0x9AAD,0xE98C,      // <cjk>
      0x9AB0,0xE98D,      // <cjk>
      0x9ABC,0xE98E,      // <cjk>
      0x9AC0,0xE98F,      // <cjk>
      0x9AC4,0x9091,      // <cjk>
      0x9ACF,0xE990,      // <cjk>
      0x9AD1,0xE991,      // <cjk>
      0x9AD3,0xE992,      // <cjk>
      0x9AD4,0xE993,      // <cjk>
      0x9AD8,0x8D82,      // <cjk>
      0x9ADE,0xE994,      // <cjk>
      0x9ADF,0xE995,      // <cjk>
      0x9AE2,0xE996,      // <cjk>
      0x9AE3,0xE997,      // <cjk>
      0x9AE6,0xE998,      // <cjk>
      0x9AEA,0x94AF,      // <cjk>
      0x9AEB,0xE99A,      // <cjk>
      0x9AED,0x9545,      // <cjk>
      0x9AEE,0xE99B,      // <cjk>
      0x9AEF,0xE999,      // <cjk>
      0x9AF1,0xE99D,      // <cjk>
      0x9AF4,0xE99C,      // <cjk>
      0x9AF7,0xE99E,      // <cjk>
      0x9AFB,0xE99F,      // <cjk>
      0x9B06,0xE9A0,      // <cjk>
      0x9B18,0xE9A1,      // <cjk>
      0x9B1A,0xE9A2,      // <cjk>
      0x9B1F,0xE9A3,      // <cjk>
      0x9B22,0xE9A4,      // <cjk>
      0x9B23,0xE9A5,      // <cjk>
      0x9B25,0xE9A6,      // <cjk>
      0x9B27,0xE9A7,      // <cjk>
      0x9B28,0xE9A8,      // <cjk>
      0x9B29,0xE9A9,      // <cjk>
      0x9B2A,0xE9AA,      // <cjk>
      0x9B2E,0xE9AB,      // <cjk>
      0x9B2F,0xE9AC,      // <cjk>
      0x9B31,0x9F54,      // <cjk>
      0x9B32,0xE9AD,      // <cjk>
      0x9B3B,0xE2F6,      // <cjk>
      0x9B3C,0x8B53,      // <cjk>
      0x9B41,0x8A40,      // <cjk>
      0x9B42,0x8DB0,      // <cjk>
      0x9B43,0xE9AF,      // <cjk>
      0x9B44,0xE9AE,      // <cjk>
      0x9B45,0x96A3,      // <cjk>
      0x9B4D,0xE9B1,      // <cjk>
      0x9B4E,0xE9B2,      // <cjk>
      0x9B4F,0xE9B0,      // <cjk>
      0x9B51,0xE9B3,      // <cjk>
      0x9B54,0x9682,      // <cjk>
      0x9B58,0xE9B4,      // <cjk>
      0x9B5A,0x8B9B,      // <cjk>
      0x9B6F,0x9844,      // <cjk>
      0x9B74,0xE9B5,      // <cjk>
      0x9B83,0xE9B7,      // <cjk>
      0x9B8E,0x88BC,      // <cjk>
      0x9B91,0xE9B8,      // <cjk>
      0x9B92,0x95A9,      // <cjk>
      0x9B93,0xE9B6,      // <cjk>
      0x9B96,0xE9B9,      // <cjk>
      0x9B97,0xE9BA,      // <cjk>
      0x9B9F,0xE9BB,      // <cjk>
      0x9BA0,0xE9BC,      // <cjk>
      0x9BA8,0xE9BD,      // <cjk>
      0x9BAA,0x968E,      // <cjk>
      0x9BAB,0x8E4C,      // <cjk>
      0x9BAD,0x8DF8,      // <cjk>
      0x9BAE,0x914E,      // <cjk>
      0x9BB4,0xE9BE,      // <cjk>
      0x9BB9,0xE9C1,      // <cjk>
      0x9BC0,0xE9BF,      // <cjk>
      0x9BC6,0xE9C2,      // <cjk>
      0x9BC9,0x8CEF,      // <cjk>
      0x9BCA,0xE9C0,      // <cjk>
      0x9BCF,0xE9C3,      // <cjk>
      0x9BD1,0xE9C4,      // <cjk>
      0x9BD2,0xE9C5,      // <cjk>
      0x9BD4,0xE9C9,      // <cjk>
      0x9BD6,0x8E49,      // <cjk>
      0x9BDB,0x91E2,      // <cjk>
      0x9BE1,0xE9CA,      // <cjk>
      0x9BE2,0xE9C7,      // <cjk>
      0x9BE3,0xE9C6,      // <cjk>
      0x9BE4,0xE9C8,      // <cjk>
      0x9BE8,0x8C7E,      // <cjk>
      0x9BF0,0xE9CE,      // <cjk>
      0x9BF1,0xE9CD,      // <cjk>
      0x9BF2,0xE9CC,      // <cjk>
      0x9BF5,0x88B1,      // <cjk>
      0x9C04,0xE9D8,      // <cjk>
      0x9C06,0xE9D4,      // <cjk>
      0x9C08,0xE9D5,      // <cjk>
      0x9C09,0xE9D1,      // <cjk>
      0x9C0A,0xE9D7,      // <cjk>
      0x9C0C,0xE9D3,      // <cjk>
      0x9C0D,0x8A82,      // <cjk>
      0x9C10,0x986B,      // <cjk>
      0x9C12,0xE9D6,      // <cjk>
      0x9C13,0xE9D2,      // <cjk>
      0x9C14,0xE9D0,      // <cjk>
      0x9C15,0xE9CF,      // <cjk>
      0x9C1B,0xE9DA,      // <cjk>
      0x9C21,0xE9DD,      // <cjk>
      0x9C24,0xE9DC,      // <cjk>
      0x9C25,0xE9DB,      // <cjk>
      0x9C2D,0x9568,      // <cjk>
      0x9C2E,0xE9D9,      // <cjk>
      0x9C2F,0x88F1,      // <cjk>
      0x9C30,0xE9DE,      // <cjk>
      0x9C32,0xE9E0,      // <cjk>
      0x9C39,0x8A8F,      // <cjk>
      0x9C3A,0xE9CB,      // <cjk>
      0x9C3B,0x8956,      // <cjk>
      0x9C3E,0xE9E2,      // <cjk>
      0x9C46,0xE9E1,      // <cjk>
      0x9C47,0xE9DF,      // <cjk>
      0x9C48,0x924C,      // <cjk>
      0x9C52,0x9690,      // <cjk>
      0x9C57,0x97D8,      // <cjk>
      0x9C5A,0xE9E3,      // <cjk>
      0x9C60,0xE9E4,      // <cjk>
      0x9C67,0xE9E5,      // <cjk>
      0x9C76,0xE9E6,      // <cjk>
      0x9C78,0xE9E7,      // <cjk>
      0x9CE5,0x92B9,      // <cjk>
      0x9CE7,0xE9E8,      // <cjk>
      0x9CE9,0x94B5,      // <cjk>
      0x9CEB,0xE9ED,      // <cjk>
      0x9CEC,0xE9E9,      // <cjk>
      0x9CF0,0xE9EA,      // <cjk>
      0x9CF3,0x9650,      // <cjk>
      0x9CF4,0x96C2,      // <cjk>
      0x9CF6,0x93CE,      // <cjk>
      0x9D03,0xE9EE,      // <cjk>
      0x9D06,0xE9EF,      // <cjk>
      0x9D07,0x93BC,      // <cjk>
      0x9D08,0xE9EC,      // <cjk>
      0x9D09,0xE9EB,      // <cjk>
      0x9D0E,0x89A8,      // <cjk>
      0x9D12,0xE9F7,      // <cjk>
      0x9D15,0xE9F6,      // <cjk>
      0x9D1B,0x8995,      // <cjk>
      0x9D1F,0xE9F4,      // <cjk>
      0x9D23,0xE9F3,      // <cjk>
      0x9D26,0xE9F1,      // <cjk>
      0x9D28,0x8A9B,      // <cjk>
      0x9D2A,0xE9F0,      // <cjk>
      0x9D2B,0x8EB0,      // <cjk>
      0x9D2C,0x89A7,      // <cjk>
      0x9D3B,0x8D83,      // <cjk>
      0x9D3E,0xE9FA,      // <cjk>
      0x9D3F,0xE9F9,      // <cjk>
      0x9D41,0xE9F8,      // <cjk>
      0x9D44,0xE9F5,      // <cjk>
      0x9D46,0xE9FB,      // <cjk>
      0x9D48,0xE9FC,      // <cjk>
      0x9D50,0xEA44,      // <cjk>
      0x9D51,0xEA43,      // <cjk>
      0x9D59,0xEA45,      // <cjk>
      0x9D5C,0x894C,      // <cjk>
      0x9D5D,0xEA40,      // <cjk>
      0x9D5E,0xEA41,      // <cjk>
      0x9D60,0x8D94,      // <cjk>
      0x9D61,0x96B7,      // <cjk>
      0x9D64,0xEA42,      // <cjk>
      0x9D6C,0x9651,      // <cjk>
      0x9D6F,0xEA4A,      // <cjk>
      0x9D72,0xEA46,      // <cjk>
      0x9D7A,0xEA4B,      // <cjk>
      0x9D87,0xEA48,      // <cjk>
      0x9D89,0xEA47,      // <cjk>
      0x9D8F,0x8C7B,      // <cjk>
      0x9D9A,0xEA4C,      // <cjk>
      0x9DA4,0xEA4D,      // <cjk>
      0x9DA9,0xEA4E,      // <cjk>
      0x9DAB,0xEA49,      // <cjk>
      0x9DAF,0xE9F2,      // <cjk>
      0x9DB2,0xEA4F,      // <cjk>
      0x9DB4,0x92DF,      // <cjk>
      0x9DB8,0xEA53,      // <cjk>
      0x9DBA,0xEA54,      // <cjk>
      0x9DBB,0xEA52,      // <cjk>
      0x9DC1,0xEA51,      // <cjk>
      0x9DC2,0xEA57,      // <cjk>
      0x9DC4,0xEA50,      // <cjk>
      0x9DC6,0xEA55,      // <cjk>
      0x9DCF,0xEA56,      // <cjk>
      0x9DD3,0xEA59,      // <cjk>
      0x9DD9,0xEA58,      // <cjk>
      0x9DED,0xEA5C,      // <cjk>
      0x9DEF,0xEA5D,      // <cjk>
      0x9DF2,0x9868,      // <cjk>
      0x9DF8,0xEA5A,      // <cjk>
      0x9DF9,0x91E9,      // <cjk>
      0x9DFA,0x8DEB,      // <cjk>
      0x9DFD,0xEA5E,      // <cjk>
      0x9E1A,0xEA5F,      // <cjk>
      0x9E1B,0xEA60,      // <cjk>
      0x9E1E,0xEA61,      // <cjk>
      0x9E75,0xEA62,      // <cjk>
      0x9E78,0x8CB2,      // <cjk>
      0x9E79,0xEA63,      // <cjk>
      0x9E7D,0xEA64,      // <cjk>
      0x9E7F,0x8EAD,      // <cjk>
      0x9E81,0xEA65,      // <cjk>
      0x9E88,0xEA66,      // <cjk>
      0x9E8B,0xEA67,      // <cjk>
      0x9E8C,0xEA68,      // <cjk>
      0x9E91,0xEA6B,      // <cjk>
      0x9E92,0xEA69,      // <cjk>
      0x9E95,0xEA6A,      // <cjk>
      0x9E97,0x97ED,      // <cjk>
      0x9E9D,0xEA6C,      // <cjk>
      0x9E9F,0x97D9,      // <cjk>
      0x9EA5,0xEA6D,      // <cjk>
      0x9EA6,0x949E,      // <cjk>
      0x9EA9,0xEA6E,      // <cjk>
      0x9EAA,0xEA70,      // <cjk>
      0x9EAD,0xEA71,      // <cjk>
      0x9EB8,0xEA6F,      // <cjk>
      0x9EB9,0x8D8D,      // <cjk>
      0x9EBA,0x96CB,      // <cjk>
      0x9EBB,0x9683,      // <cjk>
      0x9EBC,0x9BF5,      // <cjk>
      0x9EBE,0x9F80,      // <cjk>
      0x9EBF,0x969B,      // <cjk>
      0x9EC4,0x89A9,      // <cjk>
      0x9ECC,0xEA73,      // <cjk>
      0x9ECD,0x8B6F,      // <cjk>
      0x9ECE,0xEA74,      // <cjk>
      0x9ECF,0xEA75,      // <cjk>
      0x9ED0,0xEA76,      // <cjk>
      0x9ED2,0x8D95,      // <cjk>
      0x9ED4,0xEA77,      // <cjk>
      0x9ED8,0xE0D2,      // <cjk>
      0x9ED9,0x96D9,      // <cjk>
      0x9EDB,0x91E1,      // <cjk>
      0x9EDC,0xEA78,      // <cjk>
      0x9EDD,0xEA7A,      // <cjk>
      0x9EDE,0xEA79,      // <cjk>
      0x9EE0,0xEA7B,      // <cjk>
      0x9EE5,0xEA7C,      // <cjk>
      0x9EE8,0xEA7D,      // <cjk>
      0x9EEF,0xEA7E,      // <cjk>
      0x9EF4,0xEA80,      // <cjk>
      0x9EF6,0xEA81,      // <cjk>
      0x9EF7,0xEA82,      // <cjk>
      0x9EF9,0xEA83,      // <cjk>
      0x9EFB,0xEA84,      // <cjk>
      0x9EFC,0xEA85,      // <cjk>
      0x9EFD,0xEA86,      // <cjk>
      0x9F07,0xEA87,      // <cjk>
      0x9F08,0xEA88,      // <cjk>
      0x9F0E,0x9343,      // <cjk>
      0x9F13,0x8CDB,      // <cjk>
      0x9F15,0xEA8A,      // <cjk>
      0x9F20,0x916C,      // <cjk>
      0x9F21,0xEA8B,      // <cjk>
      0x9F2C,0xEA8C,      // <cjk>
      0x9F3B,0x9540,      // <cjk>
      0x9F3E,0xEA8D,      // <cjk>
      0x9F4A,0xEA8E,      // <cjk>
      0x9F4B,0xE256,      // <cjk>
      0x9F4E,0xE6D8,      // <cjk>
      0x9F4F,0xE8EB,      // <cjk>
      0x9F52,0xEA8F,      // <cjk>
      0x9F54,0xEA90,      // <cjk>
      0x9F5F,0xEA92,      // <cjk>
      0x9F60,0xEA93,      // <cjk>
      0x9F61,0xEA94,      // <cjk>
      0x9F62,0x97EE,      // <cjk>
      0x9F63,0xEA91,      // <cjk>
      0x9F66,0xEA95,      // <cjk>
      0x9F67,0xEA96,      // <cjk>
      0x9F6A,0xEA98,      // <cjk>
      0x9F6C,0xEA97,      // <cjk>
      0x9F72,0xEA9A,      // <cjk>
      0x9F76,0xEA9B,      // <cjk>
      0x9F77,0xEA99,      // <cjk>
      0x9F8D,0x97B4,      // <cjk>
      0x9F95,0xEA9C,      // <cjk>
      0x9F9C,0xEA9D,      // <cjk>
      0x9F9D,0xE273,      // <cjk>
      0x9FA0,0xEA9E,      // <cjk>
      0xFF01,0x8149,      // FULLWIDTH EXCLAMATION MARK
      0xFF03,0x8194,      // FULLWIDTH NUMBER SIGN
      0xFF04,0x8190,      // FULLWIDTH DOLLAR SIGN
      0xFF05,0x8193,      // FULLWIDTH PERCENT SIGN
      0xFF06,0x8195,      // FULLWIDTH AMPERSAND
      0xFF07,0x81AD,      // FULLWIDTH APOSTROPHE
      0xFF08,0x8169,      // FULLWIDTH LEFT PARENTHESIS
      0xFF09,0x816A,      // FULLWIDTH RIGHT PARENTHESIS
      0xFF0A,0x8196,      // FULLWIDTH ASTERISK
      0xFF0B,0x817B,      // FULLWIDTH PLUS SIGN
      0xFF0C,0x8143,      // FULLWIDTH COMMA
      0xFF0E,0x8144,      // FULLWIDTH FULL STOP
      0xFF0F,0x815E,      // FULLWIDTH SOLIDUS
      0xFF10,0x824F,      // FULLWIDTH DIGIT ZERO
      0xFF11,0x8250,      // FULLWIDTH DIGIT ONE
      0xFF12,0x8251,      // FULLWIDTH DIGIT TWO
      0xFF13,0x8252,      // FULLWIDTH DIGIT THREE
      0xFF14,0x8253,      // FULLWIDTH DIGIT FOUR
      0xFF15,0x8254,      // FULLWIDTH DIGIT FIVE
      0xFF16,0x8255,      // FULLWIDTH DIGIT SIX
      0xFF17,0x8256,      // FULLWIDTH DIGIT SEVEN
      0xFF18,0x8257,      // FULLWIDTH DIGIT EIGHT
      0xFF19,0x8258,      // FULLWIDTH DIGIT NINE
      0xFF1A,0x8146,      // FULLWIDTH COLON
      0xFF1B,0x8147,      // FULLWIDTH SEMICOLON
      0xFF1C,0x8183,      // FULLWIDTH LESS-THAN SIGN
      0xFF1D,0x8181,      // FULLWIDTH EQUALS SIGN
      0xFF1E,0x8184,      // FULLWIDTH GREATER-THAN SIGN
      0xFF1F,0x8148,      // FULLWIDTH QUESTION MARK
      0xFF20,0x8197,      // FULLWIDTH COMMERCIAL AT
      0xFF21,0x8260,      // FULLWIDTH LATIN CAPITAL LETTER A
      0xFF22,0x8261,      // FULLWIDTH LATIN CAPITAL LETTER B
      0xFF23,0x8262,      // FULLWIDTH LATIN CAPITAL LETTER C
      0xFF24,0x8263,      // FULLWIDTH LATIN CAPITAL LETTER D
      0xFF25,0x8264,      // FULLWIDTH LATIN CAPITAL LETTER E
      0xFF26,0x8265,      // FULLWIDTH LATIN CAPITAL LETTER F
      0xFF27,0x8266,      // FULLWIDTH LATIN CAPITAL LETTER G
      0xFF28,0x8267,      // FULLWIDTH LATIN CAPITAL LETTER H
      0xFF29,0x8268,      // FULLWIDTH LATIN CAPITAL LETTER I
      0xFF2A,0x8269,      // FULLWIDTH LATIN CAPITAL LETTER J
      0xFF2B,0x826A,      // FULLWIDTH LATIN CAPITAL LETTER K
      0xFF2C,0x826B,      // FULLWIDTH LATIN CAPITAL LETTER L
      0xFF2D,0x826C,      // FULLWIDTH LATIN CAPITAL LETTER M
      0xFF2E,0x826D,      // FULLWIDTH LATIN CAPITAL LETTER N
      0xFF2F,0x826E,      // FULLWIDTH LATIN CAPITAL LETTER O
      0xFF30,0x826F,      // FULLWIDTH LATIN CAPITAL LETTER P
      0xFF31,0x8270,      // FULLWIDTH LATIN CAPITAL LETTER Q
      0xFF32,0x8271,      // FULLWIDTH LATIN CAPITAL LETTER R
      0xFF33,0x8272,      // FULLWIDTH LATIN CAPITAL LETTER S
      0xFF34,0x8273,      // FULLWIDTH LATIN CAPITAL LETTER T
      0xFF35,0x8274,      // FULLWIDTH LATIN CAPITAL LETTER U
      0xFF36,0x8275,      // FULLWIDTH LATIN CAPITAL LETTER V
      0xFF37,0x8276,      // FULLWIDTH LATIN CAPITAL LETTER W
      0xFF38,0x8277,      // FULLWIDTH LATIN CAPITAL LETTER X
      0xFF39,0x8278,      // FULLWIDTH LATIN CAPITAL LETTER Y
      0xFF3A,0x8279,      // FULLWIDTH LATIN CAPITAL LETTER Z
      0xFF3B,0x816D,      // FULLWIDTH LEFT SQUARE BRACKET
      0xFF3D,0x816E,      // FULLWIDTH RIGHT SQUARE BRACKET
      0xFF3E,0x814F,      // FULLWIDTH CIRCUMFLEX ACCENT
      0xFF3F,0x8151,      // FULLWIDTH LOW LINE
      0xFF40,0x814D,      // FULLWIDTH GRAVE ACCENT
      0xFF41,0x8281,      // FULLWIDTH LATIN SMALL LETTER A
      0xFF42,0x8282,      // FULLWIDTH LATIN SMALL LETTER B
      0xFF43,0x8283,      // FULLWIDTH LATIN SMALL LETTER C
      0xFF44,0x8284,      // FULLWIDTH LATIN SMALL LETTER D
      0xFF45,0x8285,      // FULLWIDTH LATIN SMALL LETTER E
      0xFF46,0x8286,      // FULLWIDTH LATIN SMALL LETTER F
      0xFF47,0x8287,      // FULLWIDTH LATIN SMALL LETTER G
      0xFF48,0x8288,      // FULLWIDTH LATIN SMALL LETTER H
      0xFF49,0x8289,      // FULLWIDTH LATIN SMALL LETTER I
      0xFF4A,0x828A,      // FULLWIDTH LATIN SMALL LETTER J
      0xFF4B,0x828B,      // FULLWIDTH LATIN SMALL LETTER K
      0xFF4C,0x828C,      // FULLWIDTH LATIN SMALL LETTER L
      0xFF4D,0x828D,      // FULLWIDTH LATIN SMALL LETTER M
      0xFF4E,0x828E,      // FULLWIDTH LATIN SMALL LETTER N
      0xFF4F,0x828F,      // FULLWIDTH LATIN SMALL LETTER O
      0xFF50,0x8290,      // FULLWIDTH LATIN SMALL LETTER P
      0xFF51,0x8291,      // FULLWIDTH LATIN SMALL LETTER Q
      0xFF52,0x8292,      // FULLWIDTH LATIN SMALL LETTER R
      0xFF53,0x8293,      // FULLWIDTH LATIN SMALL LETTER S
      0xFF54,0x8294,      // FULLWIDTH LATIN SMALL LETTER T
      0xFF55,0x8295,      // FULLWIDTH LATIN SMALL LETTER U
      0xFF56,0x8296,      // FULLWIDTH LATIN SMALL LETTER V
      0xFF57,0x8297,      // FULLWIDTH LATIN SMALL LETTER W
      0xFF58,0x8298,      // FULLWIDTH LATIN SMALL LETTER X
      0xFF59,0x8299,      // FULLWIDTH LATIN SMALL LETTER Y
      0xFF5A,0x829A,      // FULLWIDTH LATIN SMALL LETTER Z
      0xFF5B,0x816F,      // FULLWIDTH LEFT CURLY BRACKET
      0xFF5C,0x8162,      // FULLWIDTH VERTICAL LINE
      0xFF5D,0x8170,      // FULLWIDTH RIGHT CURLY BRACKET
      0xFFE3,0x8150,      // FULLWIDTH MACRON 
      0xFFE5,0x818F       // FULLWIDTH YEN SIGN
};