/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2011 NoMachine (http://www.nomachine.com)          */
/* Copyright (c) 2008-2017 Oleksandr Shneyder <o.shneyder@phoca-gmbh.de>  */
/* Copyright (c) 2011-2022 Mike Gabriel <mike.gabriel@das-netzwerkteam.de>*/
/* Copyright (c) 2014-2019 Mihai Moldovan <ionic@ionic.de>                */
/* Copyright (c) 2014-2022 Ulrich Sibiller <uli42@gmx.de>                 */
/* Copyright (c) 2015-2016 Qindel Group (http://www.qindel.com)           */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of the aforementioned persons and companies.             */
/*                                                                        */
/* Redistribution and use of the present software is allowed according    */
/* to terms specified in the file LICENSE which comes in the source       */
/* distribution.                                                          */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/* NOTE: This software has received contributions from various other      */
/* contributors, only the core maintainers and supporters are listed as   */
/* copyright holders. Please contact us, if you feel you should be listed */
/* as copyright holder, as well.                                          */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#ifndef __Visual_H__
#define __Visual_H__

Visual *nxagentVisual(VisualPtr pVisual);
Visual *nxagentVisualFromID(ScreenPtr pScreen, VisualID visual);

#if 0
Visual *nxagentVisualFromDepth(ScreenPtr pScreen, int depth);
#endif

Colormap nxagentDefaultVisualColormap(Visual *visual);

#define nxagentDefaultVisual(pScreen) \
    nxagentVisualFromID((pScreen), (pScreen) -> rootVisual)

/*
 * Visual generated by Xorg and Xfree86 at 16-bit depth differs on the
 * bits_per_rgb value, so we avoid checking it.
 */

/*
 * Some Solaris X servers uses the color masks inverted, so that the
 * red and the blue mask are switched. To reconnect the session on
 * this displays, we do a double check, as workaround.
 */

#define nxagentCompareVisuals(v1, v2)           \
    ((v1).depth         == (v2).depth &&        \
     /*(v1).bits_per_rgb  == (v2).bits_per_rgb &&*/ \
     (v1).class         == (v2).class &&        \
     ((v1).red_mask      == (v2).red_mask ||    \
      (v1).red_mask      == (v2).blue_mask) &&  \
     (v1).green_mask    == (v2).green_mask &&   \
     ((v1).blue_mask     == (v2).blue_mask ||   \
      (v1).blue_mask     == (v2).red_mask) &&   \
     (v1).colormap_size == (v2).colormap_size)

extern Visual nxagentAlphaVisual;

void nxagentInitAlphaVisual();

#endif /* __Visual_H__ */
