/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Vector;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.AbstractBasisSetToXml;
import org.scidac.cmcs.tools.pertable.PerTable;

public class GamessInputToBasisXml
extends AbstractBasisSetToXml {
    protected PerTable mPertable = PerTable.getPerTable();

    @Override
    public Vector convert(String title, String xmlFileName, String harmonicType, String description, InputStream inputStream) throws IOException, FormatException {
        Vector<Document> ret = new Vector<Document>();
        boolean hasBasisSet = false;
        boolean hasEcp = false;
        boolean hasSo = false;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String line = null;
        while ((line = reader.readLine()) != null) {
            line = line.trim().toUpperCase();
            Document doc = null;
            if (line.equals("$DATA")) {
                if (hasBasisSet) {
                    throw new FormatException("Can not have more than two basis set sections in one file.");
                }
                doc = this.loadBasisSet(reader, line, title, xmlFileName, harmonicType, description);
                if (doc != null) {
                    String[] types = this.getContractionTypes(doc);
                    hasBasisSet = true;
                }
            } else if (line.startsWith("$ECP")) {
                if (hasEcp) {
                    throw new FormatException("Can not have more than two ecp sections in one file.");
                }
                doc = this.loadECPs(reader, line, title, xmlFileName);
                if (doc != null) {
                    hasEcp = true;
                }
            }
            if (doc == null) continue;
            ret.add(doc);
        }
        if (ret.size() == 0) {
            throw new FormatException("Unable to find start of basis set data.  Make sure you have specified the correct file type.");
        }
        for (Document doc : ret) {
            String docType = doc.getRootElement().getName().toLowerCase();
            if (!docType.equals("basisset")) continue;
            if (hasEcp) {
                doc.getRootElement().addContent(this.createEcpLink(xmlFileName));
            }
            if (!hasSo) continue;
            doc.getRootElement().addContent(this.createSoLink(xmlFileName));
        }
        return ret;
    }

    protected Document loadBasisSet(BufferedReader reader, String options, String name, String xmlFileName, String harmonicType, String description) throws IOException, FormatException {
        Element root = this.createBasisRoot();
        root.addContent(this.createBasisMime());
        root.addContent(this.createTitle(name));
        root.addContent(this.createHarmonicType(harmonicType));
        root.addContent(this.createContractionType("segmented"));
        root.addContent(this.createRefLink(xmlFileName + "-BS-REF.xml"));
        root.addContent(this.createDescription(description));
        String line = options;
        String lastElement = "";
        Element contractions = null;
        block0: while (!line.equals("$END") && (line = reader.readLine()) != null) {
            if ((line = line.trim().toUpperCase()).length() == 0) continue;
            Vector columns = this.tokenize(line);
            String element = (String)columns.get(0);
            if (element.length() > 2) {
                element = this.mPertable.formatSymbol(element);
                if ((element = this.mPertable.atomicSymbol(element)) == null) {
                    continue;
                }
            } else {
                element = this.mPertable.formatSymbol(element);
            }
            if (!this.mPertable.isValid(element)) continue;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim().toUpperCase()).length() == 0) continue;
                columns = this.tokenize(line);
                if (line.equals("$END") || columns.size() != 2) {
                    reader.reset();
                    continue block0;
                }
                String shell = (String)columns.get(0);
                if (shell.equals("L")) {
                    shell = "SP";
                }
                if (!element.equals(lastElement)) {
                    contractions = this.createContractions(element);
                    root.addContent(contractions);
                    lastElement = element;
                }
                Element contraction = this.createContraction(shell);
                contractions.addContent(contraction);
                int nRows = Integer.parseInt((String)columns.get(1));
                this.readMatrix(reader, contraction, nRows, true);
            }
        }
        return new Document(root);
    }

    protected Element createMatrixECP(Vector matrix, int rows, int columns) {
        Element ret = new Element("matrix", mCmlNs);
        ret.setAttribute("rows", "" + rows);
        ret.setAttribute("columns", "" + columns);
        ret.setAttribute("dataType", "xs:double");
        StringBuffer text = new StringBuffer();
        for (int idx = 0; idx < matrix.size(); idx += 3) {
            String val1 = (String)matrix.get(idx);
            String val2 = (String)matrix.get(idx + 1);
            String val3 = (String)matrix.get(idx + 2);
            text.append(val2 + " " + val3 + " " + val1 + " ");
        }
        ret.setText(new String(text));
        return ret;
    }

    protected boolean readMatrix(BufferedReader reader, Element parent, int nRows, boolean isBasisSet) throws IOException {
        boolean ret = true;
        Vector matrix = new Vector();
        int nColumns = 0;
        for (int i = 0; i < nRows; ++i) {
            String line = reader.readLine();
            if (line == null) {
                ret = false;
            }
            if ((line = line.trim().toUpperCase()).length() == 0) continue;
            Vector data = this.tokenize(line);
            if (isBasisSet) {
                data.remove(0);
            }
            reader.mark(80);
            nColumns = data.size();
            matrix.addAll(data);
        }
        Element matrixEl = isBasisSet ? this.createMatrix(matrix, nRows, nColumns) : this.createMatrixECP(matrix, nRows, nColumns);
        parent.addContent(matrixEl);
        reader.reset();
        return ret;
    }

    protected Document loadECPs(BufferedReader reader, String options, String name, String xmlFileName) throws IOException, FormatException {
        return this.loadECPFormattedData(reader, options, "scalar", name, xmlFileName);
    }

    protected Document loadSpinOrbitals(BufferedReader reader, String options, String name, String xmlFileName) throws IOException, FormatException {
        return this.loadECPFormattedData(reader, options, "spin", name + "-so", xmlFileName);
    }

    protected Document loadECPFormattedData(BufferedReader reader, String options, String type, String name, String xmlFileName) throws IOException, FormatException {
        Element root = this.createEcpRoot();
        root.addContent(this.createEcpMime());
        root.addContent(this.createTitle(name));
        root.addContent(this.createEcpType("type"));
        if (xmlFileName.endsWith("-ECP")) {
            root.addContent(this.createRefLink(xmlFileName + "-REF.xml"));
        } else {
            root.addContent(this.createRefLink(xmlFileName + "-ECP-REF.xml"));
        }
        String line = options;
        while (!line.equals("$END") && (line = reader.readLine()) != null && (line = line.trim().toUpperCase()).length() != 0) {
            Vector columns = this.tokenize(line);
            String ecpWord = (String)columns.get(0);
            if (ecpWord.indexOf("-ECP") == -1) {
                throw new FormatException("Missing ECP line: " + line);
            }
            String[] elements = ecpWord.split("-");
            String element = elements[0];
            if (!this.mPertable.isValid(element = this.mPertable.formatSymbol(element))) break;
            if (columns.size() != 4) {
                throw new FormatException("Missing L values: " + line);
            }
            String nElectrons = (String)columns.get(columns.size() - 1);
            String maxShell = this.getMinimumShell();
            Element potentials = this.createPotentials(element, nElectrons);
            root.addContent(potentials);
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim().toUpperCase()).length() == 0) continue;
                if (line.indexOf("POTENTIAL") == -1) {
                    reader.reset();
                    break;
                }
                columns = this.tokenize(line);
                int nRows = Integer.parseInt((String)columns.get(0));
                String[] temp = ((String)columns.get(2)).split("-");
                String shell = temp[0];
                if (!this.isValidShell(shell)) {
                    throw new FormatException("Unrecognized shell type " + shell);
                }
                maxShell = this.selectMaxShell(shell, maxShell);
                Element potential = this.createPotential(shell.toLowerCase() + " potential", shell);
                potentials.addContent(potential);
                this.readMatrix(reader, potential, nRows, false);
            }
            maxShell = maxShell.toLowerCase();
            List potentialEls = potentials.getChildren("potential", mEmslNs);
            for (Element p : potentialEls) {
                Attribute attribute = p.getAttribute("potentialType");
                String shell = p.getAttribute("shell").getValue().toLowerCase();
                if (shell.equals(maxShell)) {
                    attribute.setValue(shell + " potential");
                    continue;
                }
                attribute.setValue(shell + "-" + maxShell + " potential");
            }
        }
        return new Document(root);
    }
}

