/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.om.security.peer;

import com.workingdogs.village.Record;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.apache.turbine.om.BaseObject;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.om.security.Permission;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.om.security.SecurityObject;
import org.apache.turbine.om.security.TurbineRole;
import org.apache.turbine.om.security.peer.RolePermissionPeer;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.db.map.TurbineMapBuilder;
import org.apache.turbine.util.security.DataBackendException;
import org.apache.turbine.util.security.PermissionSet;

public class PermissionPeer
extends BasePeer {
    private static final TurbineMapBuilder mapBuilder = (TurbineMapBuilder)BasePeer.getMapBuilder();
    private static final String TABLE_NAME = mapBuilder.getTablePermission();
    public static final String PERMISSION_ID = mapBuilder.getPermission_PermissionId();
    public static final String NAME = mapBuilder.getPermission_Name();
    public static final String OBJECTDATA = mapBuilder.getPermission_ObjectData();
    private static final String SEQUENCE_NAME = mapBuilder.getSequencePermission();

    public static PermissionSet retrieveSet(Criteria criteria) throws Exception {
        Vector results = PermissionPeer.doSelect(criteria);
        PermissionSet ps = new PermissionSet();
        int i = 0;
        while (i < results.size()) {
            ps.add((Permission)results.elementAt(i));
            ++i;
        }
        return ps;
    }

    public static PermissionSet retrieveSet(Role role) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(RolePermissionPeer.ROLE_ID, ((TurbineRole)role).getPrimaryKey());
        criteria.addJoin(RolePermissionPeer.PERMISSION_ID, PERMISSION_ID);
        return PermissionPeer.retrieveSet(criteria);
    }

    public static Vector doSelect(Criteria criteria) throws Exception {
        criteria.addSelectColumn(PERMISSION_ID).addSelectColumn(NAME).addSelectColumn(OBJECTDATA);
        if (criteria.getOrderByColumns() == null || criteria.getOrderByColumns().size() == 0) {
            criteria.addAscendingOrderByColumn(NAME);
        }
        Vector rows = BasePeer.doSelect(criteria);
        Vector<Permission> results = new Vector<Permission>();
        int i = 0;
        while (i < rows.size()) {
            Permission obj = TurbineSecurity.getNewPermission(null);
            Record row = (Record)rows.elementAt(i);
            ((SecurityObject)((Object)obj)).setPrimaryKey(row.getValue(1).asInt());
            ((SecurityObject)((Object)obj)).setName(row.getValue(2).asString());
            byte[] objectData = row.getValue(3).asBytes();
            Map temp = (Map)ObjectUtils.deserialize(objectData);
            if (temp != null) {
                ((SecurityObject)((Object)obj)).setAttributes(temp);
            }
            results.addElement(obj);
            ++i;
        }
        return results;
    }

    public static Criteria buildCriteria(Permission permission) {
        Criteria criteria = new Criteria();
        if (!((BaseObject)((Object)permission)).isNew()) {
            criteria.add(PERMISSION_ID, ((BaseObject)((Object)permission)).getPrimaryKey());
        }
        criteria.add(NAME, ((SecurityObject)((Object)permission)).getName());
        return criteria;
    }

    public static void doUpdate(Criteria criteria) throws Exception {
        Criteria selectCriteria = new Criteria(2);
        selectCriteria.put(PERMISSION_ID, criteria.remove(PERMISSION_ID));
        BasePeer.doUpdate(selectCriteria, criteria);
    }

    public static boolean checkExists(Permission permission) throws DataBackendException, Exception {
        Criteria criteria = new Criteria();
        criteria.addSelectColumn(PERMISSION_ID);
        criteria.add(NAME, ((SecurityObject)((Object)permission)).getName());
        Vector results = BasePeer.doSelect(criteria);
        if (results.size() > 1) {
            throw new DataBackendException("Multiple permissions named '" + ((SecurityObject)((Object)permission)).getName() + "' exist!");
        }
        return results.size() == 1;
    }

    public static String getTableName() {
        return TABLE_NAME;
    }

    public static String getColumnName(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(TABLE_NAME);
        sb.append(".");
        sb.append(name);
        return sb.toString();
    }

    public static final Vector getDifference(Vector some, Vector all) {
        Vector clone = (Vector)all.clone();
        Enumeration e = some.elements();
        block0: while (e.hasMoreElements()) {
            Permission tmp = (Permission)e.nextElement();
            Enumeration f = clone.elements();
            while (f.hasMoreElements()) {
                Permission tmp2 = (Permission)f.nextElement();
                if (((BaseObject)((Object)tmp)).getPrimaryKey() != ((BaseObject)((Object)tmp2)).getPrimaryKey()) continue;
                clone.removeElement(tmp2);
                continue block0;
            }
        }
        return clone;
    }
}

