## Usage

```js
var posix = require('{%= name %}');
console.log(posix.alpha);
//=> 'A-Za-z'
```

## POSIX Character classes

The POSIX standard supports the following classes or categories of charactersh (note that classes must be defined within brackets)[^wiki]:

| **POSIX class** | **Equivalent to** | **Matches** |
| --- | --- | --- |
| `[:alnum:]`  | `[A-Za-z0-9]`          | digits, uppercase and lowercase letters |
| `[:alpha:]`  | `[A-Za-z]`             | upper- and lowercase letters |
| `[:ascii:]`  | `[\x00-\x7F]`          | ASCII characters |
| `[:blank:]`  | `[ \t]`                | space and TAB characters only |
| `[:cntrl:]`  | `[\x00-\x1F\x7F]`   | Control characters |
| `[:digit:]`  | `[0-9]`                | digits |
| `[:graph:]`  | `[^[:cntrl:]]`         | graphic characters (all characters which have graphic representation) |
| `[:lower:]`  | `[a-z]`                | lowercase letters |
| `[:print:]`  | `[[:graph] ]`          | graphic characters and space |
| `[:punct:]`  | ``[-!"#$%&\'()\*+,./:;<=>?@[\]^_`{|}~]`` | all punctuation characters (all graphic characters except letters and digits) |
| `[:space:]`  | `[ \t\n\r\f\v]`        | all blank (whitespace) characters, including spaces, tabs, new lines, carriage returns, form feeds, and vertical tabs |
| `[:upper:]`  | `[A-Z]`                | uppercase letters |
| `[:word:]`   | `[A-Za-z0-9_]`         | word characters |
| `[:xdigit:]` | `[0-9A-Fa-f]`          | hexadecimal digits |

## Examples

- `a[[:digit:]]b` matches `a0b`, `a1b`, ..., `a9b`.
- `a[:digit:]b` is invalid, character classes must be enclosed in brackets
- `[[:digit:]abc]` matches any digit, as well as `a`, `b`, and `c`.
- `[abc[:digit:]]` is the same as the previous, matching any digit, as well as `a`, `b`, and `c`
- `[^ABZ[:lower:]]` matches any character except lowercase letters, `A`, `B`, and `Z`.

[^wiki]: table and examples are based on the WikiBooks page for [Regular Expressions/POSIX Basic Regular Expressions][wiki], which is available under the [Creative Commons Attribution-ShareAlike License][license]. 

[wiki]: https://en.wikibooks.org/wiki/Regular_Expressions/POSIX_Basic_Regular_Expressions
[license]: https://creativecommons.org/licenses/by-sa/3.0/