<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/health/notifications/smstools3/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/health/notifications/smstools3/metadata.yaml"
sidebar_label: "SMS"
learn_status: "Published"
learn_rel_path: "Alerts & Notifications/Notifications/Agent Dispatched Notifications"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE NOTIFICATION'S metadata.yaml FILE"
endmeta-->

# SMS


<img src="https://netdata.cloud/img/sms.svg" width="150"/>


Send notifications to `smstools3` using Netdata's Agent alert notification feature, which supports dozens of endpoints, user roles, and more.
The SMS Server Tools 3 is a SMS Gateway software which can send and receive short messages through GSM modems and mobile phones.



<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Setup

### Prerequisites

#### 

- [Install](http://smstools3.kekekasvi.com/index.php?p=compiling) and [configure](http://smstools3.kekekasvi.com/index.php?p=configure) `smsd`
- To ensure that the user `netdata` can execute `sendsms`. Any user executing `sendsms` needs to:
  - Have write permissions to /tmp and /var/spool/sms/outgoing
  - Be a member of group smsd
  - To ensure that the steps above are successful, just su netdata and execute sendsms phone message.
- Access to the terminal where Netdata Agent is running



### Configuration

#### File

The configuration file name for this integration is `health_alarm_notify.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config health_alarm_notify.conf
```
#### Options

The following options can be defined for this notification

<details open><summary>Config Options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| sendsms | Set the path for `sendsms`, otherwise Netdata will search for it in your system `$PATH:` | YES | yes |
| SEND_SMS | Set `SEND_SMS` to `YES`. |  | yes |
| DEFAULT_RECIPIENT_SMS | Set DEFAULT_RECIPIENT_SMS to the phone number you want the alert notifications to be sent to. You can define multiple phone numbers like this: PHONE1 PHONE2. |  | yes |

##### sendsms

# The full path of the sendsms command (smstools3).
# If empty, the system $PATH will be searched for it.
# If not found, SMS notifications will be silently disabled.
sendsms="/usr/bin/sendsms"


##### DEFAULT_RECIPIENT_SMS

All roles will default to this variable if left unconfigured.

You can then have different phone numbers per role, by editing `DEFAULT_RECIPIENT_SMS` with the phone number you want, in the following entries at the bottom of the same file:
```conf
role_recipients_sms[sysadmin]="PHONE1"
role_recipients_sms[domainadmin]="PHONE2"
role_recipients_sms[dba]="PHONE3"
role_recipients_sms[webmaster]="PHONE4"
role_recipients_sms[proxyadmin]="PHONE5"
role_recipients_sms[sitemgr]="PHONE6"
```


</details>

#### Examples

##### Basic Configuration



```yaml
#------------------------------------------------------------------------------
# SMS Server Tools 3 (smstools3) global notification options
SEND_SMS="YES"
DEFAULT_RECIPIENT_SMS="1234567890"

```


## Troubleshooting

### Test Notification

You can run the following command by hand, to test alerts configuration:

```bash
# become user netdata
sudo su -s /bin/bash netdata

# enable debugging info on the console
export NETDATA_ALARM_NOTIFY_DEBUG=1

# send test alarms to sysadmin
/usr/libexec/netdata/plugins.d/alarm-notify.sh test

# send test alarms to any role
/usr/libexec/netdata/plugins.d/alarm-notify.sh test "ROLE"
```

Note that this will test _all_ alert mechanisms for the selected role.


