<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/proc.plugin/integrations/entropy.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/proc.plugin/metadata.yaml"
sidebar_label: "Entropy"
learn_status: "Published"
learn_rel_path: "Data Collection/Linux Systems/System"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Entropy


<img src="https://netdata.cloud/img/syslog.png" width="150"/>


Plugin: proc.plugin
Module: /proc/sys/kernel/random/entropy_avail

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Entropy, a measure of the randomness or unpredictability of data.

In the context of cryptography, entropy is used to generate random numbers or keys that are essential for
secure communication and encryption. Without a good source of entropy, cryptographic protocols can become
vulnerable to attacks that exploit the predictability of the generated keys.

In most operating systems, entropy is generated by collecting random events from various sources, such as
hardware interrupts, mouse movements, keyboard presses, and disk activity. These events are fed into a pool
of entropy, which is then used to generate random numbers when needed.

The `/dev/random` device in Linux is one such source of entropy, and it provides an interface for programs
to access the pool of entropy. When a program requests random numbers, it reads from the `/dev/random` device,
which blocks until enough entropy is available to generate the requested numbers. This ensures that the
generated numbers are truly random and not predictable. 

However, if the pool of entropy gets depleted, the `/dev/random` device may block indefinitely, causing
programs that rely on random numbers to slow down or even freeze. This is especially problematic for
cryptographic protocols that require a continuous stream of random numbers, such as SSL/TLS and SSH.

To avoid this issue, some systems use a hardware random number generator (RNG) to generate high-quality
entropy. A hardware RNG generates random numbers by measuring physical phenomena, such as thermal noise or
radioactive decay. These sources of randomness are considered to be more reliable and unpredictable than
software-based sources.

One such hardware RNG is the Trusted Platform Module (TPM), which is a dedicated hardware chip that is used
for cryptographic operations and secure boot. The TPM contains a built-in hardware RNG that generates
high-quality entropy, which can be used to seed the pool of entropy in the operating system.

Alternatively, software-based solutions such as `Haveged` can be used to generate additional entropy by
exploiting sources of randomness in the system, such as CPU utilization and network traffic. These solutions
can help to mitigate the risk of entropy depletion, but they may not be as reliable as hardware-based solutions.




This collector is only supported on the following platforms:

- linux

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Entropy instance



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| system.entropy | entropy | entropy |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ lowest_entropy ](https://github.com/netdata/netdata/blob/master/health/health.d/entropy.conf) | system.entropy | minimum number of bits of entropy available for the kernel’s random number generator |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

There is no configuration file.
#### Options



There are no configuration options.

#### Examples
There are no configuration examples.


