/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.java.project;

import org.netbeans.api.project.libraries.Library;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.SwingUtilities;

import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.project.support.ant.ui.VariablesSupport;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.util.ImageUtilities;
import static org.netbeans.modules.java.project.Bundle.*;
import org.openide.util.NbBundle.Messages;
import org.openide.util.RequestProcessor;

/**
 *
 * @author  David Konecny
 */
public class BrokenReferencesCustomizer extends javax.swing.JPanel {

    private static final RequestProcessor RP = new RequestProcessor(BrokenReferencesCustomizer.class);
    private static final Logger LOG = Logger.getLogger(BrokenReferencesCustomizer.class.getName());

    private BrokenReferencesModel model;
    private File lastSelectedFile;
    
    /** Creates new form BrokenReferencesCustomizer */
    public BrokenReferencesCustomizer(BrokenReferencesModel model) {
        initComponents();
        this.model = model;
        errorList.setModel(model);
        errorList.setSelectedIndex(0);
        errorList.setCellRenderer(new ListCellRendererImpl(model));
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        errorListLabel = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        errorList = new javax.swing.JList();
        fix = new javax.swing.JButton();
        descriptionLabel = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        description = new javax.swing.JTextArea();

        setLayout(new java.awt.GridBagLayout());

        setPreferredSize(new java.awt.Dimension(450, 300));
        getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(BrokenReferencesCustomizer.class, "ACSN_BrokenReferencesCustomizer"));
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(BrokenReferencesCustomizer.class, "ACSD_BrokenReferencesCustomizer"));
        errorListLabel.setLabelFor(errorList);
        org.openide.awt.Mnemonics.setLocalizedText(errorListLabel, org.openide.util.NbBundle.getMessage(BrokenReferencesCustomizer.class, "LBL_BrokenLinksCustomizer_List"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 3, 0);
        add(errorListLabel, gridBagConstraints);
        errorListLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(BrokenReferencesCustomizer.class, "ACSD_BrokenLinksCustomizer_List"));

        errorList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        errorList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                errorListValueChanged(evt);
            }
        });

        jScrollPane1.setViewportView(errorList);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 0);
        add(jScrollPane1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(fix, org.openide.util.NbBundle.getMessage(BrokenReferencesCustomizer.class, "LBL_BrokenLinksCustomizer_Fix"));
        fix.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fixActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 12);
        add(fix, gridBagConstraints);
        fix.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(BrokenReferencesCustomizer.class, "ACSD_BrokenLinksCustomizer_Fix"));

        descriptionLabel.setLabelFor(description);
        org.openide.awt.Mnemonics.setLocalizedText(descriptionLabel, org.openide.util.NbBundle.getMessage(BrokenReferencesCustomizer.class, "LBL_BrokenLinksCustomizer_Description"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 3, 0);
        add(descriptionLabel, gridBagConstraints);
        descriptionLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(BrokenReferencesCustomizer.class, "ACSD_BrokenLinksCustomizer_Description"));

        description.setEditable(false);
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        jScrollPane2.setViewportView(description);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 60;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 5, 0);
        add(jScrollPane2, gridBagConstraints);

    }//GEN-END:initComponents

    private void errorListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_errorListValueChanged
        updateSelection();
    }//GEN-LAST:event_errorListValueChanged

    @Messages({
        "LBL_BrokenLinksCustomizer_Resolve_Project=Browse Project \"{0}\"",
        "LBL_BrokenLinksCustomizer_Resolve_File=Browse \"{0}\""
    })
    private void fixActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fixActionPerformed
        int index = errorList.getSelectedIndex();
        if (index==-1) {
            return;
        }
        final BrokenReferencesModel.OneReference or = model.getOneReference(index);
        if (or.getType() == BrokenReferencesModel.RefType.LIBRARY ||
            or.getType() == BrokenReferencesModel.RefType.LIBRARY_CONTENT) {
            fix.setEnabled(false);
            try {
                final LibraryManager lm = model.getProjectLibraryManager(or);
                if (lm == null) {
                    //Closed and freed project
                    return;
                }
                LibrariesCustomizer.showCustomizer(null,lm);
            } finally {
                fix.setEnabled(true);
            }
        } else if (or.getType() == BrokenReferencesModel.RefType.DEFINABLE_LIBRARY) {
            fix.setEnabled(false);
            RP.post(new Runnable() {
                public @Override void run() {
                    try {
                        Library lib = or.define();
                        LOG.log(Level.FINE, "found {0}", lib);
                        EventQueue.invokeLater(new Runnable() {
                            public @Override void run() {
                                model.refresh();
                                updateSelection();
                            }
                        });
                    } catch (Exception x) {
                        LOG.log(Level.INFO, null, x);
                        // fallback: user may need to create library manually
                        final LibraryManager lm = model.getProjectLibraryManager(or);
                        if (lm == null) {
                            //Closed and freed project
                            return;
                        }
                        LibrariesCustomizer.showCustomizer(null, lm);
                    } finally {
                        SwingUtilities.invokeLater(new Runnable() {
                            @Override
                            public void run() {
                                fix.setEnabled(true);
                            }
                        });
                    }
                }
            });
            return;
        } else if (or.getType() == BrokenReferencesModel.RefType.PLATFORM) {
            fix.setEnabled(false);
            try {
                PlatformsCustomizer.showCustomizer(null);
            } finally {
                fix.setEnabled(true);
            }
        } else if (or.getType() == BrokenReferencesModel.RefType.VARIABLE || or.getType() == BrokenReferencesModel.RefType.VARIABLE_CONTENT) {
            fix.setEnabled(false);
            try {
                VariablesSupport.showVariablesCustomizer();
            } finally {
                fix.setEnabled(true);
            }
        } else {
            fix.setEnabled(false);
            try {
                JFileChooser chooser;
                if (or.getType() == BrokenReferencesModel.RefType.PROJECT) {
                    chooser = ProjectChooser.projectChooser();
                    chooser.setDialogTitle(LBL_BrokenLinksCustomizer_Resolve_Project(or.getDisplayID()));
                } else {
                    chooser = new JFileChooser();
                    chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
                    chooser.setDialogTitle(LBL_BrokenLinksCustomizer_Resolve_File(or.getDisplayID()));
                }
                if (lastSelectedFile != null) {
                    chooser.setSelectedFile(lastSelectedFile);
                }
                int option = chooser.showOpenDialog(null);
                if (option == JFileChooser.APPROVE_OPTION) {
                    model.updateReference(errorList.getSelectedIndex(), chooser.getSelectedFile());
                    lastSelectedFile = chooser.getSelectedFile();
                }
            } finally {
                fix.setEnabled(true);
            }
        }
        model.refresh();
        updateSelection();
    }//GEN-LAST:event_fixActionPerformed

    @Messages("LBL_BrokenLinksCustomizer_Problem_Was_Resolved=This problem was resolved")
    private void updateSelection() {
        if (errorList.getSelectedIndex() != -1 && errorList.getSelectedIndex() < model.getSize()) {
            if (model.isBroken(errorList.getSelectedIndex())) {
                description.setText(getDescription(errorList.getSelectedIndex()));
                fix.setEnabled(true);
            } else {
                description.setText(LBL_BrokenLinksCustomizer_Problem_Was_Resolved());
                // Leave the button always enabled so that user can alter 
                // resolved reference. Especially needed for automatically
                // resolved JAR references.
                fix.setEnabled(true);
            }
        } else {
            description.setText("");
            fix.setEnabled(false);
        }
    }
    
    @Messages({
        "LBL_BrokenLinksCustomizer_BrokenLibraryDesc=Problem: The project uses a class library called \"{0}\", but this class library was not found.\nSolution: Click Resolve to open the Library Manager and create a new class library called \"{0}\".",
        "LBL_BrokenLinksCustomizer_BrokenDefinableLibraryDesc=Problem: The project uses a class library called \"{0}\", but this class library is not currently defined locally.\nSolution: Click Resolve to download or otherwise automatically define this library.",
        "LBL_BrokenLinksCustomizer_BrokenLibraryContentDesc=Problem: The project uses the class library called \"{0}\" but the classpath items of this library are missing.\nSolution: Click Resolve to open the Library Manager and locate the missing classpath items of \"{0}\" library.",
        "LBL_BrokenLinksCustomizer_BrokenProjectReferenceDesc=Problem: The project classpath includes a reference to the project called \"{0}\", but this project was not found.\nSolution: Click Resolve and locate the missing project.",
        "LBL_BrokenLinksCustomizer_BrokenFileReferenceDesc=Problem: The project uses the file/folder called \"{0}\", but this file/folder was not found.\nSolution: Click Resolve and locate the missing file/folder.",
        "LBL_BrokenLinksCustomizer_BrokenVariableReferenceDesc=Problem: The project uses the variable called \"{0}\", but this variable was not found.\nSolution: Click Resolve and setup this variable there.",
        "LBL_BrokenLinksCustomizer_BrokenVariableContentDesc=Problem: The project uses the variable based file/folder \"{0}\", but this file/folder was not found.\nSolution: Click Resolve and update your variable to point to correct location.",
        "LBL_BrokenLinksCustomizer_BrokenPlatformDesc=Problem: The project uses the Java Platform called \"{0}\", but this platform was not found.\nSolution: Click Resolve and create new platform called \"{0}\"."
    })
    private String getDescription(int index) {
        BrokenReferencesModel.OneReference or = model.getOneReference(index);
        switch (or.getType()) {
            case LIBRARY:
                return LBL_BrokenLinksCustomizer_BrokenLibraryDesc(or.getDisplayID());
            case DEFINABLE_LIBRARY:
                return LBL_BrokenLinksCustomizer_BrokenDefinableLibraryDesc(or.getDisplayID());
            case LIBRARY_CONTENT:
                return LBL_BrokenLinksCustomizer_BrokenLibraryContentDesc(or.getDisplayID());
            case PROJECT:
                return LBL_BrokenLinksCustomizer_BrokenProjectReferenceDesc(or.getDisplayID());
            case FILE:
                return LBL_BrokenLinksCustomizer_BrokenFileReferenceDesc(or.getDisplayID());
            case VARIABLE:
                return LBL_BrokenLinksCustomizer_BrokenVariableReferenceDesc(or.getDisplayID());
            case VARIABLE_CONTENT:
                return LBL_BrokenLinksCustomizer_BrokenVariableContentDesc(or.getDisplayID());
            case PLATFORM:
                return LBL_BrokenLinksCustomizer_BrokenPlatformDesc(or.getDisplayID());
            default:
                assert false;
                return null;
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea description;
    private javax.swing.JLabel descriptionLabel;
    private javax.swing.JList errorList;
    private javax.swing.JLabel errorListLabel;
    private javax.swing.JButton fix;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    // End of variables declaration//GEN-END:variables

    private static Icon brokenRef = ImageUtilities.loadImageIcon("org/netbeans/modules/java/project/resources/broken-reference.gif", false); // NOI18N
    private static Icon resolvedRef = ImageUtilities.loadImageIcon("org/netbeans/modules/java/project/resources/resolved-reference.gif", false); // NOI18N

    private static class ListCellRendererImpl extends DefaultListCellRenderer {

        private BrokenReferencesModel model;
        
        public ListCellRendererImpl(BrokenReferencesModel model) {
            this.model = model;
        }
        
        public @Override Component getListCellRendererComponent( JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent( list, value, index, isSelected, cellHasFocus );            
            if (model.isBroken(index)) {
                setIcon(brokenRef);
            } else {
                setIcon(resolvedRef);
            }
            
            return this;
        }
    }
    
}
