#Common Mythbuntu makefile

ifneq (,$(wildcard /usr/bin/dh_python2))
py2=python2,
endif
ifneq (,$(wildcard /usr/bin/dh_python3sdfsf))
py3=python3
endif

DEB_SOURCE_PACKAGE+=$(shell egrep '^Source: ' debian/control | cut -f2 -d ' ')
DEB_UPSTREAM_VERSION+=$(shell dpkg-parsechangelog | egrep '^Version:' | cut -f 2 -d ' ' | cut -d: -f2- | sed 's/-[^-]*$$//')
BZR_BRANCH+=http://bazaar.launchpad.net/~mythbuntu-dev/mythbuntu/$(DEB_SOURCE_PACKAGE)
TARFILE+=$(DEB_SOURCE_PACKAGE)_$(DEB_UPSTREAM_VERSION).orig.tar.gz

get-orig-source:
	bzr export -r $(BZR_REVISION) $(DEB_SOURCE_PACKAGE)-$(DEB_UPSTREAM_VERSION) $(BZR_BRANCH)
	tar czf $(CURDIR)/../$(TARFILE) $(DEB_SOURCE_PACKAGE)-$(DEB_UPSTREAM_VERSION) --exclude debian
	rm -rf $(CURDIR)/$(DEB_SOURCE_PACKAGE)-$(DEB_UPSTREAM_VERSION)

%:
	dh $@ --with=$(py2)$(py3)
