Color files for MultiMail
=========================

The color file lets you specify the colors used by MultiMail (on color
terminals). When you run MultiMail for the first time, the file "colors"
will be automatically generated in the "mmail" directory, listing the
default colors.

The format for each line is "ItemName: \<foreground\>, \<background\>,
\<attribute\>", where foreground and background are one of Black, Blue,
Green, Cyan, Red, Magenta, Yellow, or White, and the attribute may be Bold
or Reverse. Only the first three letters are actually checked, and case
is not signifigant.

If no color for a given ItemName is defined, the default will be used.
Lines beginning with '#' are commented out.

"Bold" is mainly used to indicate a bright foreground color, but may also
(or alternatively) cause actual boldfacing on some terminals (like xterm).
"Reverse" is for the benefit of monochrome terminals (xterm again), so
that highlights still show up there. (Yes, color schemes are fairly
useless on a monochrome terminal; but with care, this feature lets you set
up the color file once, so you can use MultiMail from both color and mono
terminals without having to change anything.)

You can omit the foreground and background colors, as well as the
attribute. (If only one color is specified, it's taken as the foreground
color.) If omitted, the last-defined foreground or background color is
used. (Note that this does NOT work for the attribute, which is reset with
each color. So, if you have an item with the Bold attribute, and want the
next item to be exactly the same, you still have to specify "Bold".) I did
this because color schemes tend to have a lot of repeated values,
especially for the background color. See the included color schemes for
examples.

Also note that an ItemName with no values after it is NOT the same as an
ItemName that's commented out or removed. In the first case, the colors
will default to those defined for the previous item. In the second case,
the colors used will be the default colors for that item (as found in
tradit.col, or the autogenerated "colors" file).

You can switch between color schemes by changing the "ColorFile" keyword
in your .mmailrc to point to a new file. The example color files included
here are:

- aqua.col    -  This is the first color scheme I've made for myself, and
                 it's the one I'm using now. It's based on blue and cyan,
                 with white backgrounds for black text, and just a hint of
                 red. :-)

- gilmore.col -  Donated by Gary Gilmore.

- holger2.col -  Donated by Holger Granholm.

- ingo.col    -  Approximately the color scheme used by Ingo Brueckl in
                 his own version of MultiMail. It resembles the version
                 0.1 color scheme.

- tonys.col   -  Donated by Tony Summerfelt.

- toutant.col -  Donated by David Toutant.

- tradit.col  -  The standard color scheme used in versions 0.2 through
                 0.37, based on the version 0.1 scheme, with signifigant
		 alterations by John Zero.

- tuukka.col  -  A monochrome scheme, donated by Tuukka Lehtinen.

- ver01.col   -  Approximately, the original color scheme found in the
                 version 0.1 series, as devised by Kolossvary Tamas. (Some
                 things don't quite translate, due to differences in the
                 screen layout.)

I welcome additonal color schemes. If you have an interesting one, please
send it to <wmcbrine@gmail.com>.
