/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.sax.CommentHandler;
import com.jclark.xsl.sax.OutputStreamConverter;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLOutputHandler
implements DocumentHandler,
CommentHandler,
OutputStreamConverter {
    private OutputStream out = null;
    private boolean inStartTag = false;
    private static final int DEFAULT_BUF_LENGTH = 8192;
    private byte[] buf = new byte[8192];
    private int bufUsed = 0;
    private String lineSeparator = System.getProperty("line.separator");
    private byte minimize = 0;
    public static final byte MINIMIZE_NONE = 0;
    public static final byte MINIMIZE_EMPTY_ELEMENTS = 1;
    public static final byte MINIMIZE_EMPTY_ELEMENTS_HTML = 2;

    private final void writeSurrogatePair(char c, char c2) throws SAXException {
        if ((c & 0xFC00) != 55296 || (c2 & 0xFC00) != 56320) {
            throw new SAXException("invalid surrogate pair");
        }
        int n = (c & 0x3FF) << 10 | c2 & 0x3FF;
        this.put((byte)((n += 65536) >> 18 & 7 | 0xF0));
        this.put((byte)(n >> 12 & 0x3F | 0x80));
        this.put((byte)(n >> 6 & 0x3F | 0x80));
        this.put((byte)(n & 0x3F | 0x80));
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        while (n2 > 0) {
            this.put((byte)cArray[n]);
            --n2;
            ++n;
        }
    }

    public void setMinimize(byte by) {
        this.minimize = by;
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.put((byte)60);
        this.writeRaw(string);
        int n = attributeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            this.put((byte)32);
            this.writeRaw(attributeList.getName(n2));
            this.put((byte)61);
            this.put((byte)34);
            this.attributeValue(attributeList.getValue(n2));
            this.put((byte)34);
            ++n2;
        }
        this.inStartTag = true;
    }

    private final void put(byte by) throws SAXException {
        if (this.bufUsed == this.buf.length) {
            this.flushBuf();
        }
        this.buf[this.bufUsed++] = by;
    }

    private final void flushBuf() throws SAXException {
        try {
            this.out.write(this.buf, 0, this.bufUsed);
            this.bufUsed = 0;
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void startDocument() {
    }

    public void endElement(String string) throws SAXException {
        if (this.inStartTag) {
            this.inStartTag = false;
            if (this.minimize != 0) {
                if (this.minimize == 2) {
                    this.put((byte)32);
                }
                this.put((byte)47);
                this.put((byte)62);
                return;
            }
            this.put((byte)62);
        }
        this.put((byte)60);
        this.put((byte)47);
        this.writeRaw(string);
        this.put((byte)62);
    }

    public XMLOutputHandler() {
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public XMLOutputHandler(OutputStream outputStream, byte by) {
        this();
        this.setOutputStream(outputStream);
        this.setMinimize(by);
    }

    private final void finishStartTag() throws SAXException {
        this.inStartTag = false;
        this.put((byte)62);
    }

    private final void writeMB(char c) throws SAXException, CharConversionException {
        switch (c & 0xF800) {
            case 0: {
                this.put((byte)(c >> 6 & 0x1F | 0xC0));
                this.put((byte)(c & 0x3F | 0x80));
                return;
            }
            default: {
                this.put((byte)(c >> 12 & 0xF | 0xE0));
                this.put((byte)(c >> 6 & 0x3F | 0x80));
                this.put((byte)(c & 0x3F | 0x80));
                return;
            }
            case 55296: 
        }
        throw new CharConversionException("invalid surrogate pair");
    }

    public void endDocument() throws SAXException {
        if (this.bufUsed != 0) {
            this.flushBuf();
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        this.out = null;
        this.buf = null;
    }

    public void comment(String string) throws SAXException {
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.writeRaw("<!--");
        this.writeMarkup(string);
        this.writeRaw("-->");
    }

    private void writeRaw(String string) throws SAXException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c < '\u0080') {
                this.put((byte)c);
            } else {
                try {
                    this.writeMB(string.charAt(n2));
                }
                catch (CharConversionException charConversionException) {
                    if (++n2 == n) {
                        throw new SAXException(charConversionException.getMessage());
                    }
                    this.writeSurrogatePair(c, string.charAt(n2));
                }
            }
            ++n2;
        }
    }

    private void writeMarkup(String string) throws SAXException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\n') {
                this.writeRaw(this.lineSeparator);
            } else if (c < '\u0080') {
                this.put((byte)c);
            } else {
                try {
                    this.writeMB(c);
                }
                catch (CharConversionException charConversionException) {
                    if (++n2 == n) {
                        throw new SAXException(charConversionException);
                    }
                    this.writeSurrogatePair(c, string.charAt(n2));
                }
            }
            ++n2;
        }
    }

    public void markup(String string) throws SAXException {
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.writeMarkup(string);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (n2 == 0) {
            return;
        }
        if (this.inStartTag) {
            this.finishStartTag();
        }
        do {
            char c = cArray[n++];
            switch (c) {
                case '\n': {
                    this.writeRaw(this.lineSeparator);
                    break;
                }
                case '&': {
                    this.writeRaw("&amp;");
                    break;
                }
                case '<': {
                    this.writeRaw("&lt;");
                    break;
                }
                case '>': {
                    this.writeRaw("&gt;");
                    break;
                }
                default: {
                    if (c < '\u0080') {
                        this.put((byte)c);
                        break;
                    }
                    try {
                        this.writeMB(c);
                        break;
                    }
                    catch (CharConversionException charConversionException) {
                        if (n2-- == 0) {
                            throw new SAXException(charConversionException);
                        }
                        this.writeSurrogatePair(cArray[n - 1], cArray[n]);
                        ++n;
                    }
                }
            }
        } while (--n2 > 0);
    }

    protected void attributeValue(String string) throws SAXException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\n': {
                    this.writeRaw("&#10;");
                    break;
                }
                case '&': {
                    this.writeRaw("&amp;");
                    break;
                }
                case '<': {
                    this.writeRaw("&lt;");
                    break;
                }
                case '\"': {
                    this.writeRaw("&quot;");
                    break;
                }
                case '\r': {
                    this.writeRaw("&#13;");
                    break;
                }
                case '\t': {
                    this.writeRaw("&#9;");
                    break;
                }
                default: {
                    if (c < '\u0080') {
                        this.put((byte)c);
                        break;
                    }
                    try {
                        this.writeMB(c);
                        break;
                    }
                    catch (CharConversionException charConversionException) {
                        if (++n2 == n) {
                            throw new SAXException(charConversionException.getMessage());
                        }
                        this.writeSurrogatePair(string.charAt(n2 - 1), string.charAt(n2));
                    }
                }
            }
            ++n2;
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.put((byte)60);
        this.put((byte)63);
        this.writeRaw(string);
        if (string2.length() > 0) {
            this.put((byte)32);
            this.writeMarkup(string2);
        }
        this.put((byte)63);
        this.put((byte)62);
    }
}

