/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "Drop.h"

#include "Action.h"
#include "Task.h"
#include "IconClass.h"

Drop::Drop(const set<IconObject*>& icons,
		const Request& request,
		const string& service,const Request& mode):

	request_(request),
	service_(service),
	mode_(mode),
	error_(false),
	waiting_(0)
{
	for(set<IconObject*>::const_iterator j = icons.begin(); j != icons.end() ; ++j)
	{
		IconObjectH o = (*j);
		requests_[o] = o->request();
		Task* t = o->action( Action("prepare","*"));
		
		if(t) {
			tasks_[t] = o;
			waiting_++;
			t->add(this);

			// Add extra information about the target object
			MvRequest reqCont = request.getSubrequest("_CONTEXT");
			if ( reqCont )
				t->addContext(reqCont);
		}
	}
	check();
}

Drop::~Drop()
{
	cout << "Drop::~Drop()" << endl;
}

void Drop::success(Task* t,const Request& r)
{
	IconObjectH o = tasks_[t];
	requests_[o] = r;
	waiting_--;
	check();
}

void Drop::failure(Task*)
{
	error_ = true;
	waiting_--;
	check();
}

void Drop::check()
{
	if(waiting_) return;

	if(!error_)
	{

		// Request should be sorted
		const char* null = 0;
		map<int,vector<Request> > m;

		for(map<IconObjectH,Request>::iterator j = requests_.begin(); j != 
			requests_.end(); ++j)
	    {
			Request r     = (*j).second;
			IconObject* o = (*j).first;
			if(r && r.getVerb())
			{
				int priority = IconClass::find(r.getVerb()).priority();
				if(null == r("_NAME"))  r("_NAME")  = o->fullName().c_str();
				if(null == r("_CLASS")) r("_CLASS") = o->className().c_str();
				m[priority].push_back(r);
			}
	 	}

		Request req;

		for(map<int,vector<Request> >::iterator k = m.begin(); k != m.end(); ++k)
		{
			Request r;
			for(vector<Request>::iterator j = (*k).second.begin(); 
				j != (*k).second.end(); ++j)
					r = r + (*j) + req;
			req = r;
		}

		request_ = request_ + req;
		request_("_MODE") = mode_;

		request_.print();

		MvApplication::callService(service_.c_str(),request_,0);
	}
	delete this;
}
