#include "pdf/pilot.h"
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*                                                                   *
*     G R V  -  P R O T O N  - P A R A M E T R I Z A T I O N S      *
*                                                                   *
*                          1998 UPDATE                              *
*                                                                   *
*                  For a detailed explanation see                   *
*                   M. Glueck, E. Reya, A. Vogt :                   *
*        hep-ph/9806404  =  DO-TH 98/07  =  WUE-ITP-98-019          *
*                  (Eur. Phys. J. C5 (1998) 461)                    *
*                                                                   *
*   This package contains subroutines returning the light-parton    *
*   distributions in NLO (for the MSbar and DIS schemes) and LO;    * 
*   the respective light-parton, charm, and bottom contributions    *
*   to F2(electromagnetic); and the scale dependence of alpha_s.    *
*                                                                   *
*   The parton densities and F2 values are calculated from inter-   *
*   polation grids covering the regions                             *
*         Q^2/GeV^2  between   0.8   and  1.E6 ( 1.E4 for F2 )      *
*            x       between  1.E-9  and   1.                       *
*   Any call outside these regions stops the program execution.     *
*                                                                   *
*   At Q^2 = MZ^2, alpha_s reads  0.114 (0.125) in NLO (LO); the    *
*   heavy quark thresholds, QH^2 = mh^2, in the beta function are   *
*            mc = 1.4 GeV,  mb = 4.5 GeV,  mt = 175 GeV.            *
*   Note that the NLO alpha_s running is different from GRV(94).    * 
*                                                                   *
*    Questions, comments etc to:  avogt@physik.uni-wuerzburg.de     *
*                                                                   *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*
*
*
      SUBROUTINE GRV98_nld 
     +    (DX,DQ,DUV,DDV,DUSEA,DDSEA,DSTR,DCHM,DBOT,DTOP,DGL)
C      SUBROUTINE GRV98PA (ISET, X, Q2, UV, DV, US, DS, SS, GL)
*********************************************************************
*                                                                   *
*   THE PARTON ROUTINE.                                             *
*                                     __                            *
*   INPUT:   ISET =  1 (LO),  2 (NLO, MS), or  3 (NLO, DIS)         *
*            X  =  Bjorken-x        (between  1.E-9 and 1.)         *
*            Q2 =  scale in GeV**2  (between  0.8 and 1.E6)         *
*                                                                   *
*   OUTPUT:  UV = u - u(bar),  DV = d - d(bar),  US = u(bar),       *
*            DS = d(bar),  SS = s = s(bar),  GL = gluon.            *
*            Always x times the distribution is returned.           *
*                                                                   *
*   COMMON:  The main program or the calling routine has to have    *
*            a common block  COMMON / INTINIP / IINIP , and the     *
*            integer variable  IINIP  has always to be zero when    *
*            GRV98PA is called for the first time or when  ISET     *
*            has been changed.                                      *
*                                                                   *
*   GRIDS:   1. grv98lo.grid, 2. grv98nlm.grid, 3. grv98nld.grid,   *
*            (1+1809 lines with 6 columns, 4 significant figures)   *
*                                                                   *
*******************************************************i*************
*
#include "pdf/impdp.inc"
      PARAMETER (NPART=6, NX=68, NQ=27, NARG=2)
      DIMENSION XUVF(NX,NQ), XDVF(NX,NQ), XDEF(NX,NQ), XUDF(NX,NQ),
     1          XSF(NX,NQ), XGF(NX,NQ), PARTON (NPART,NQ,NX-1), 
     2          QS(NQ), XB(NX), XT(NARG), NA(NARG), ARRF(NX+NQ) 
      CHARACTER*80 LINE
C      COMMON / INTINIP / IINIP
      SAVE XUVF, XDVF, XDEF, XUDF, XSF, XGF, NA, ARRF
       DATA ZEROD/0.D0/
*
* ..BJORKEN-X AND Q**2 VALUES OF THE GRID :
       DATA QS / 0.8E0, 
     1           1.0E0, 1.3E0, 1.8E0, 2.7E0, 4.0E0, 6.4E0,
     2           1.0E1, 1.6E1, 2.5E1, 4.0E1, 6.4E1,
     3           1.0E2, 1.8E2, 3.2E2, 5.7E2,
     4           1.0E3, 1.8E3, 3.2E3, 5.7E3,
     5           1.0E4, 2.2E4, 4.6E4,
     6           1.0E5, 2.2E5, 4.6E5, 
     7           1.E6 /
       DATA XB / 1.0E-9, 1.8E-9, 3.2E-9, 5.7E-9, 
     A           1.0E-8, 1.8E-8, 3.2E-8, 5.7E-8, 
     B           1.0E-7, 1.8E-7, 3.2E-7, 5.7E-7, 
     C           1.0E-6, 1.4E-6, 2.0E-6, 3.0E-6, 4.5E-6, 6.7E-6,
     1           1.0E-5, 1.4E-5, 2.0E-5, 3.0E-5, 4.5E-5, 6.7E-5,
     2           1.0E-4, 1.4E-4, 2.0E-4, 3.0E-4, 4.5E-4, 6.7E-4,
     3           1.0E-3, 1.4E-3, 2.0E-3, 3.0E-3, 4.5E-3, 6.7E-3,
     4           1.0E-2, 1.4E-2, 2.0E-2, 3.0E-2, 4.5E-2, 0.06, 0.08,
     5           0.1, 0.125, 0.15, 0.175, 0.2, 0.225, 0.25, 0.275,
     6           0.3, 0.325, 0.35, 0.375, 0.4,  0.45, 0.5, 0.55,
     7           0.6, 0.65,  0.7,  0.75,  0.8,  0.85, 0.9, 0.95, 1. /
      DATA IINIP/0/
C
        DATA ((PARTON(I,N,1),I=1,6),N=1,8)/
     +   .1238E-03,  .7724E-04,  .3870E-04,  .1394E+01,  .6863E+00,
     +   .2562E+01,
     +   .1272E-03,  .7941E-04,  .3971E-04,  .2368E+01,  .1173E+01,
     +   .4551E+01,
     +   .1311E-03,  .8179E-04,  .4083E-04,  .3870E+01,  .1924E+01,
     +   .8354E+01,
     +   .1354E-03,  .8451E-04,  .4211E-04,  .6276E+01,  .3127E+01,
     +   .1620E+02,
     +   .1407E-03,  .8781E-04,  .4367E-04,  .8768E+01,  .4373E+01,
     +   .4161E+02,
     +   .1456E-03,  .9083E-04,  .4508E-04,  .1178E+02,  .5879E+01,
     +   .8035E+02,
     +   .1510E-03,  .9419E-04,  .4667E-04,  .1667E+02,  .8322E+01,
     +   .1449E+03,
     +   .1558E-03,  .9719E-04,  .4808E-04,  .2265E+02,  .1131E+02,
     +   .2270E+03 /
        DATA ((PARTON(I,N,1),I=1,6),N=9,16)/
     +   .1606E-03,  .1002E-03,  .4948E-04,  .3039E+02,  .1518E+02,
     +   .3375E+03,
     +   .1650E-03,  .1029E-03,  .5077E-04,  .3868E+02,  .1933E+02,
     +   .4699E+03,
     +   .1695E-03,  .1057E-03,  .5208E-04,  .4846E+02,  .2422E+02,
     +   .6414E+03,
     +   .1738E-03,  .1084E-03,  .5335E-04,  .5995E+02,  .2996E+02,
     +   .8449E+03,
     +   .1778E-03,  .1109E-03,  .5451E-04,  .7248E+02,  .3623E+02,
     +   .1069E+04,
     +   .1828E-03,  .1140E-03,  .5598E-04,  .9146E+02,  .4572E+02,
     +   .1412E+04,
     +   .1875E-03,  .1169E-03,  .5736E-04,  .1128E+03,  .5639E+02,
     +   .1803E+04,
     +   .1921E-03,  .1198E-03,  .5869E-04,  .1370E+03,  .6851E+02,
     +   .2250E+04 /
        DATA ((PARTON(I,N,1),I=1,6),N=17,24)/
     +   .1964E-03,  .1225E-03,  .5995E-04,  .1634E+03,  .8167E+02,
     +   .2740E+04,
     +   .2008E-03,  .1252E-03,  .6122E-04,  .1938E+03,  .9690E+02,
     +   .3311E+04,
     +   .2050E-03,  .1278E-03,  .6243E-04,  .2266E+03,  .1133E+03,
     +   .3929E+04,
     +   .2090E-03,  .1303E-03,  .6360E-04,  .2623E+03,  .1312E+03,
     +   .4607E+04,
     +   .2129E-03,  .1327E-03,  .6472E-04,  .3000E+03,  .1500E+03,
     +   .5323E+04,
     +   .2181E-03,  .1359E-03,  .6623E-04,  .3575E+03,  .1787E+03,
     +   .6422E+04,
     +   .2229E-03,  .1389E-03,  .6761E-04,  .4155E+03,  .2077E+03,
     +   .7550E+04,
     +   .2278E-03,  .1420E-03,  .6903E-04,  .4815E+03,  .2407E+03,
     +   .8851E+04 /
        DATA ((PARTON(I,N,1),I=1,6),N=25,27)/
     +   .2327E-03,  .1450E-03,  .7044E-04,  .5546E+03,  .2773E+03,
     +   .1029E+05,
     +   .2372E-03,  .1478E-03,  .7173E-04,  .6285E+03,  .3142E+03,
     +   .1173E+05,
     +   .2418E-03,  .1507E-03,  .7305E-04,  .7120E+03,  .3560E+03,
     +   .1336E+05 /
        DATA ((PARTON(I,N,2),I=1,6),N=1,8)/
     +   .1594E-03,  .9947E-04,  .4975E-04,  .1313E+01,  .6441E+00,
     +   .2684E+01,
     +   .1639E-03,  .1023E-03,  .5105E-04,  .2205E+01,  .1090E+01,
     +   .4776E+01,
     +   .1688E-03,  .1053E-03,  .5248E-04,  .3570E+01,  .1772E+01,
     +   .8694E+01,
     +   .1744E-03,  .1088E-03,  .5413E-04,  .5735E+01,  .2855E+01,
     +   .1657E+02,
     +   .1813E-03,  .1131E-03,  .5611E-04,  .8015E+01,  .3994E+01,
     +   .4022E+02,
     +   .1875E-03,  .1170E-03,  .5792E-04,  .1075E+02,  .5363E+01,
     +   .7557E+02,
     +   .1945E-03,  .1213E-03,  .5995E-04,  .1514E+02,  .7554E+01,
     +   .1338E+03,
     +   .2007E-03,  .1252E-03,  .6176E-04,  .2044E+02,  .1021E+02,
     +   .2070E+03 /
        DATA ((PARTON(I,N,2),I=1,6),N=9,16)/
     +   .2068E-03,  .1290E-03,  .6355E-04,  .2725E+02,  .1361E+02,
     +   .3048E+03,
     +   .2125E-03,  .1325E-03,  .6519E-04,  .3452E+02,  .1725E+02,
     +   .4209E+03,
     +   .2183E-03,  .1361E-03,  .6688E-04,  .4307E+02,  .2152E+02,
     +   .5701E+03,
     +   .2239E-03,  .1396E-03,  .6849E-04,  .5304E+02,  .2651E+02,
     +   .7461E+03,
     +   .2290E-03,  .1428E-03,  .6997E-04,  .6387E+02,  .3192E+02,
     +   .9389E+03,
     +   .2355E-03,  .1468E-03,  .7185E-04,  .8017E+02,  .4007E+02,
     +   .1232E+04,
     +   .2416E-03,  .1506E-03,  .7361E-04,  .9841E+02,  .4919E+02,
     +   .1564E+04,
     +   .2475E-03,  .1543E-03,  .7531E-04,  .1190E+03,  .5949E+02,
     +   .1942E+04 /
        DATA ((PARTON(I,N,2),I=1,6),N=17,24)/
     +   .2531E-03,  .1577E-03,  .7692E-04,  .1413E+03,  .7064E+02,
     +   .2355E+04,
     +   .2587E-03,  .1612E-03,  .7854E-04,  .1670E+03,  .8348E+02,
     +   .2833E+04,
     +   .2640E-03,  .1645E-03,  .8008E-04,  .1945E+03,  .9723E+02,
     +   .3348E+04,
     +   .2693E-03,  .1678E-03,  .8158E-04,  .2244E+03,  .1122E+03,
     +   .3911E+04,
     +   .2742E-03,  .1709E-03,  .8300E-04,  .2559E+03,  .1279E+03,
     +   .4504E+04,
     +   .2810E-03,  .1750E-03,  .8493E-04,  .3037E+03,  .1518E+03,
     +   .5410E+04,
     +   .2871E-03,  .1789E-03,  .8669E-04,  .3518E+03,  .1759E+03,
     +   .6336E+04,
     +   .2935E-03,  .1828E-03,  .8850E-04,  .4064E+03,  .2032E+03,
     +   .7399E+04 /
        DATA ((PARTON(I,N,2),I=1,6),N=25,27)/
     +   .2998E-03,  .1867E-03,  .9029E-04,  .4666E+03,  .2333E+03,
     +   .8567E+04,
     +   .3056E-03,  .1903E-03,  .9193E-04,  .5273E+03,  .2636E+03,
     +   .9740E+04,
     +   .3116E-03,  .1940E-03,  .9362E-04,  .5957E+03,  .2978E+03,
     +   .1106E+05 /
        DATA ((PARTON(I,N,3),I=1,6),N=1,8)/
     +   .2042E-03,  .1274E-03,  .6360E-04,  .1237E+01,  .6048E+00,
     +   .2779E+01,
     +   .2099E-03,  .1310E-03,  .6526E-04,  .2056E+01,  .1014E+01,
     +   .4940E+01,
     +   .2162E-03,  .1349E-03,  .6708E-04,  .3296E+01,  .1634E+01,
     +   .8915E+01,
     +   .2235E-03,  .1394E-03,  .6917E-04,  .5245E+01,  .2608E+01,
     +   .1672E+02,
     +   .2322E-03,  .1449E-03,  .7169E-04,  .7329E+01,  .3650E+01,
     +   .3869E+02,
     +   .2402E-03,  .1498E-03,  .7400E-04,  .9816E+01,  .4893E+01,
     +   .7091E+02,
     +   .2491E-03,  .1554E-03,  .7657E-04,  .1375E+02,  .6858E+01,
     +   .1234E+03,
     +   .2571E-03,  .1603E-03,  .7887E-04,  .1845E+02,  .9212E+01,
     +   .1887E+03 /
        DATA ((PARTON(I,N,3),I=1,6),N=9,16)/
     +   .2650E-03,  .1652E-03,  .8115E-04,  .2445E+02,  .1221E+02,
     +   .2752E+03,
     +   .2723E-03,  .1697E-03,  .8323E-04,  .3082E+02,  .1540E+02,
     +   .3770E+03,
     +   .2797E-03,  .1744E-03,  .8537E-04,  .3829E+02,  .1913E+02,
     +   .5069E+03,
     +   .2869E-03,  .1788E-03,  .8742E-04,  .4695E+02,  .2346E+02,
     +   .6590E+03,
     +   .2934E-03,  .1829E-03,  .8930E-04,  .5630E+02,  .2814E+02,
     +   .8248E+03,
     +   .3017E-03,  .1880E-03,  .9168E-04,  .7031E+02,  .3514E+02,
     +   .1076E+04,
     +   .3096E-03,  .1929E-03,  .9391E-04,  .8590E+02,  .4294E+02,
     +   .1358E+04,
     +   .3171E-03,  .1976E-03,  .9608E-04,  .1034E+03,  .5170E+02,
     +   .1678E+04 /
        DATA ((PARTON(I,N,3),I=1,6),N=17,24)/
     +   .3243E-03,  .2020E-03,  .9811E-04,  .1223E+03,  .6115E+02,
     +   .2025E+04,
     +   .3315E-03,  .2065E-03,  .1002E-03,  .1440E+03,  .7198E+02,
     +   .2425E+04,
     +   .3384E-03,  .2108E-03,  .1021E-03,  .1671E+03,  .8355E+02,
     +   .2855E+04,
     +   .3451E-03,  .2149E-03,  .1040E-03,  .1922E+03,  .9610E+02,
     +   .3323E+04,
     +   .3514E-03,  .2189E-03,  .1058E-03,  .2185E+03,  .1092E+03,
     +   .3814E+04,
     +   .3601E-03,  .2242E-03,  .1083E-03,  .2583E+03,  .1291E+03,
     +   .4561E+04,
     +   .3680E-03,  .2291E-03,  .1105E-03,  .2982E+03,  .1491E+03,
     +   .5321E+04,
     +   .3762E-03,  .2342E-03,  .1128E-03,  .3434E+03,  .1717E+03,
     +   .6191E+04 /
        DATA ((PARTON(I,N,3),I=1,6),N=25,27)/
     +   .3843E-03,  .2392E-03,  .1150E-03,  .3930E+03,  .1965E+03,
     +   .7142E+04,
     +   .3917E-03,  .2438E-03,  .1171E-03,  .4429E+03,  .2214E+03,
     +   .8095E+04,
     +   .3993E-03,  .2485E-03,  .1192E-03,  .4990E+03,  .2495E+03,
     +   .9161E+04 /
        DATA ((PARTON(I,N,4),I=1,6),N=1,8)/
     +   .2618E-03,  .1633E-03,  .8135E-04,  .1165E+01,  .5673E+00,
     +   .2851E+01,
     +   .2692E-03,  .1679E-03,  .8346E-04,  .1915E+01,  .9421E+00,
     +   .5055E+01,
     +   .2773E-03,  .1730E-03,  .8577E-04,  .3040E+01,  .1504E+01,
     +   .9039E+01,
     +   .2865E-03,  .1787E-03,  .8843E-04,  .4791E+01,  .2379E+01,
     +   .1671E+02,
     +   .2978E-03,  .1857E-03,  .9163E-04,  .6691E+01,  .3329E+01,
     +   .3703E+02,
     +   .3080E-03,  .1921E-03,  .9456E-04,  .8942E+01,  .4455E+01,
     +   .6631E+02,
     +   .3195E-03,  .1992E-03,  .9783E-04,  .1245E+02,  .6211E+01,
     +   .1134E+03,
     +   .3297E-03,  .2055E-03,  .1007E-03,  .1662E+02,  .8294E+01,
     +   .1715E+03 /
        DATA ((PARTON(I,N,4),I=1,6),N=9,16)/
     +   .3399E-03,  .2119E-03,  .1036E-03,  .2188E+02,  .1092E+02,
     +   .2478E+03,
     +   .3492E-03,  .2176E-03,  .1063E-03,  .2745E+02,  .1371E+02,
     +   .3368E+03,
     +   .3587E-03,  .2235E-03,  .1090E-03,  .3396E+02,  .1696E+02,
     +   .4494E+03,
     +   .3679E-03,  .2292E-03,  .1116E-03,  .4145E+02,  .2071E+02,
     +   .5805E+03,
     +   .3763E-03,  .2345E-03,  .1140E-03,  .4951E+02,  .2474E+02,
     +   .7225E+03,
     +   .3870E-03,  .2411E-03,  .1170E-03,  .6150E+02,  .3073E+02,
     +   .9362E+03,
     +   .3970E-03,  .2473E-03,  .1198E-03,  .7479E+02,  .3738E+02,
     +   .1175E+04,
     +   .4067E-03,  .2533E-03,  .1226E-03,  .8965E+02,  .4481E+02,
     +   .1444E+04 /
        DATA ((PARTON(I,N,4),I=1,6),N=17,24)/
     +   .4159E-03,  .2590E-03,  .1251E-03,  .1056E+03,  .5278E+02,
     +   .1735E+04,
     +   .4252E-03,  .2648E-03,  .1277E-03,  .1238E+03,  .6190E+02,
     +   .2070E+04,
     +   .4340E-03,  .2702E-03,  .1302E-03,  .1432E+03,  .7158E+02,
     +   .2427E+04,
     +   .4426E-03,  .2755E-03,  .1326E-03,  .1642E+03,  .8206E+02,
     +   .2814E+04,
     +   .4507E-03,  .2806E-03,  .1349E-03,  .1860E+03,  .9298E+02,
     +   .3219E+04,
     +   .4618E-03,  .2875E-03,  .1380E-03,  .2190E+03,  .1095E+03,
     +   .3832E+04,
     +   .4720E-03,  .2938E-03,  .1408E-03,  .2520E+03,  .1260E+03,
     +   .4454E+04,
     +   .4825E-03,  .3002E-03,  .1437E-03,  .2893E+03,  .1446E+03,
     +   .5162E+04 /
        DATA ((PARTON(I,N,4),I=1,6),N=25,27)/
     +   .4929E-03,  .3067E-03,  .1466E-03,  .3300E+03,  .1650E+03,
     +   .5933E+04,
     +   .5024E-03,  .3126E-03,  .1492E-03,  .3709E+03,  .1854E+03,
     +   .6702E+04,
     +   .5122E-03,  .3186E-03,  .1519E-03,  .4166E+03,  .2083E+03,
     +   .7561E+04 /
        DATA ((PARTON(I,N,5),I=1,6),N=1,8)/
     +   .3335E-03,  .2080E-03,  .1033E-03,  .1100E+01,  .5325E+00,
     +   .2902E+01,
     +   .3429E-03,  .2139E-03,  .1060E-03,  .1787E+01,  .8760E+00,
     +   .5124E+01,
     +   .3532E-03,  .2203E-03,  .1089E-03,  .2808E+01,  .1386E+01,
     +   .9078E+01,
     +   .3650E-03,  .2277E-03,  .1123E-03,  .4382E+01,  .2173E+01,
     +   .1654E+02,
     +   .3794E-03,  .2365E-03,  .1163E-03,  .6114E+01,  .3039E+01,
     +   .3533E+02,
     +   .3925E-03,  .2447E-03,  .1200E-03,  .8152E+01,  .4058E+01,
     +   .6192E+02,
     +   .4071E-03,  .2537E-03,  .1241E-03,  .1129E+02,  .5628E+01,
     +   .1043E+03,
     +   .4201E-03,  .2618E-03,  .1278E-03,  .1498E+02,  .7472E+01,
     +   .1559E+03 /
        DATA ((PARTON(I,N,5),I=1,6),N=9,16)/
     +   .4330E-03,  .2698E-03,  .1314E-03,  .1960E+02,  .9783E+01,
     +   .2232E+03,
     +   .4449E-03,  .2772E-03,  .1348E-03,  .2448E+02,  .1222E+02,
     +   .3010E+03,
     +   .4571E-03,  .2847E-03,  .1382E-03,  .3014E+02,  .1505E+02,
     +   .3987E+03,
     +   .4688E-03,  .2920E-03,  .1414E-03,  .3664E+02,  .1830E+02,
     +   .5118E+03,
     +   .4795E-03,  .2986E-03,  .1444E-03,  .4358E+02,  .2177E+02,
     +   .6336E+03,
     +   .4931E-03,  .3071E-03,  .1482E-03,  .5387E+02,  .2691E+02,
     +   .8158E+03,
     +   .5059E-03,  .3150E-03,  .1518E-03,  .6520E+02,  .3258E+02,
     +   .1018E+04,
     +   .5183E-03,  .3227E-03,  .1552E-03,  .7782E+02,  .3889E+02,
     +   .1245E+04 /
        DATA ((PARTON(I,N,5),I=1,6),N=17,24)/
     +   .5300E-03,  .3299E-03,  .1585E-03,  .9130E+02,  .4563E+02,
     +   .1490E+04,
     +   .5418E-03,  .3372E-03,  .1617E-03,  .1067E+03,  .5331E+02,
     +   .1769E+04,
     +   .5531E-03,  .3442E-03,  .1648E-03,  .1229E+03,  .6144E+02,
     +   .2066E+04,
     +   .5640E-03,  .3510E-03,  .1679E-03,  .1404E+03,  .7020E+02,
     +   .2387E+04,
     +   .5744E-03,  .3574E-03,  .1707E-03,  .1586E+03,  .7930E+02,
     +   .2721E+04,
     +   .5886E-03,  .3662E-03,  .1746E-03,  .1861E+03,  .9301E+02,
     +   .3225E+04,
     +   .6015E-03,  .3742E-03,  .1781E-03,  .2134E+03,  .1067E+03,
     +   .3734E+04,
     +   .6149E-03,  .3824E-03,  .1817E-03,  .2441E+03,  .1220E+03,
     +   .4311E+04 /
        DATA ((PARTON(I,N,5),I=1,6),N=25,27)/
     +   .6282E-03,  .3906E-03,  .1853E-03,  .2777E+03,  .1388E+03,
     +   .4938E+04,
     +   .6403E-03,  .3981E-03,  .1886E-03,  .3112E+03,  .1556E+03,
     +   .5560E+04,
     +   .6528E-03,  .4058E-03,  .1920E-03,  .3486E+03,  .1743E+03,
     +   .6253E+04 /
        DATA ((PARTON(I,N,6),I=1,6),N=1,8)/
     +   .4295E-03,  .2679E-03,  .1326E-03,  .1035E+01,  .4980E+00,
     +   .2935E+01,
     +   .4417E-03,  .2755E-03,  .1360E-03,  .1661E+01,  .8110E+00,
     +   .5156E+01,
     +   .4550E-03,  .2837E-03,  .1397E-03,  .2582E+01,  .1271E+01,
     +   .9042E+01,
     +   .4703E-03,  .2932E-03,  .1440E-03,  .3989E+01,  .1974E+01,
     +   .1624E+02,
     +   .4887E-03,  .3047E-03,  .1491E-03,  .5556E+01,  .2758E+01,
     +   .3348E+02,
     +   .5056E-03,  .3151E-03,  .1538E-03,  .7387E+01,  .3673E+01,
     +   .5746E+02,
     +   .5245E-03,  .3268E-03,  .1590E-03,  .1017E+02,  .5066E+01,
     +   .9518E+02,
     +   .5412E-03,  .3372E-03,  .1637E-03,  .1341E+02,  .6684E+01,
     +   .1408E+03 /
        DATA ((PARTON(I,N,6),I=1,6),N=9,16)/
     +   .5579E-03,  .3476E-03,  .1683E-03,  .1744E+02,  .8696E+01,
     +   .1995E+03,
     +   .5732E-03,  .3570E-03,  .1726E-03,  .2166E+02,  .1081E+02,
     +   .2669E+03,
     +   .5889E-03,  .3667E-03,  .1769E-03,  .2655E+02,  .1326E+02,
     +   .3509E+03,
     +   .6040E-03,  .3761E-03,  .1811E-03,  .3213E+02,  .1604E+02,
     +   .4474E+03,
     +   .6178E-03,  .3846E-03,  .1849E-03,  .3805E+02,  .1900E+02,
     +   .5508E+03,
     +   .6354E-03,  .3955E-03,  .1897E-03,  .4679E+02,  .2337E+02,
     +   .7045E+03,
     +   .6519E-03,  .4057E-03,  .1942E-03,  .5635E+02,  .2815E+02,
     +   .8743E+03,
     +   .6679E-03,  .4156E-03,  .1985E-03,  .6695E+02,  .3345E+02,
     +   .1064E+04 /
        DATA ((PARTON(I,N,6),I=1,6),N=17,24)/
     +   .6830E-03,  .4249E-03,  .2026E-03,  .7823E+02,  .3909E+02,
     +   .1266E+04,
     +   .6982E-03,  .4343E-03,  .2068E-03,  .9101E+02,  .4548E+02,
     +   .1497E+04,
     +   .7127E-03,  .4433E-03,  .2107E-03,  .1045E+03,  .5222E+02,
     +   .1741E+04,
     +   .7269E-03,  .4520E-03,  .2145E-03,  .1190E+03,  .5946E+02,
     +   .2003E+04,
     +   .7403E-03,  .4603E-03,  .2181E-03,  .1340E+03,  .6696E+02,
     +   .2276E+04,
     +   .7585E-03,  .4716E-03,  .2230E-03,  .1565E+03,  .7822E+02,
     +   .2685E+04,
     +   .7752E-03,  .4819E-03,  .2275E-03,  .1788E+03,  .8939E+02,
     +   .3096E+04,
     +   .7925E-03,  .4925E-03,  .2321E-03,  .2039E+03,  .1019E+03,
     +   .3560E+04 /
        DATA ((PARTON(I,N,6),I=1,6),N=25,27)/
     +   .8096E-03,  .5031E-03,  .2366E-03,  .2312E+03,  .1156E+03,
     +   .4062E+04,
     +   .8252E-03,  .5127E-03,  .2407E-03,  .2583E+03,  .1291E+03,
     +   .4558E+04,
     +   .8413E-03,  .5226E-03,  .2450E-03,  .2885E+03,  .1442E+03,
     +   .5109E+04 /
        DATA ((PARTON(I,N,7),I=1,6),N=1,8)/
     +   .5503E-03,  .3432E-03,  .1691E-03,  .9752E+00,  .4658E+00,
     +   .2950E+01,
     +   .5660E-03,  .3529E-03,  .1734E-03,  .1546E+01,  .7512E+00,
     +   .5150E+01,
     +   .5830E-03,  .3635E-03,  .1781E-03,  .2377E+01,  .1166E+01,
     +   .8942E+01,
     +   .6026E-03,  .3756E-03,  .1835E-03,  .3634E+01,  .1795E+01,
     +   .1585E+02,
     +   .6263E-03,  .3903E-03,  .1900E-03,  .5052E+01,  .2503E+01,
     +   .3164E+02,
     +   .6480E-03,  .4037E-03,  .1959E-03,  .6695E+01,  .3325E+01,
     +   .5323E+02,
     +   .6722E-03,  .4187E-03,  .2026E-03,  .9165E+01,  .4559E+01,
     +   .8683E+02,
     +   .6937E-03,  .4320E-03,  .2084E-03,  .1201E+02,  .5980E+01,
     +   .1270E+03 /
        DATA ((PARTON(I,N,7),I=1,6),N=9,16)/
     +   .7151E-03,  .4453E-03,  .2143E-03,  .1551E+02,  .7732E+01,
     +   .1784E+03,
     +   .7347E-03,  .4574E-03,  .2196E-03,  .1917E+02,  .9562E+01,
     +   .2367E+03,
     +   .7549E-03,  .4698E-03,  .2251E-03,  .2340E+02,  .1168E+02,
     +   .3088E+03,
     +   .7742E-03,  .4818E-03,  .2303E-03,  .2818E+02,  .1407E+02,
     +   .3912E+03,
     +   .7920E-03,  .4928E-03,  .2351E-03,  .3324E+02,  .1660E+02,
     +   .4789E+03,
     +   .8145E-03,  .5067E-03,  .2411E-03,  .4065E+02,  .2030E+02,
     +   .6086E+03,
     +   .8357E-03,  .5198E-03,  .2468E-03,  .4873E+02,  .2434E+02,
     +   .7509E+03,
     +   .8562E-03,  .5324E-03,  .2523E-03,  .5764E+02,  .2879E+02,
     +   .9087E+03 /
        DATA ((PARTON(I,N,7),I=1,6),N=17,24)/
     +   .8755E-03,  .5443E-03,  .2575E-03,  .6707E+02,  .3351E+02,
     +   .1077E+04,
     +   .8951E-03,  .5564E-03,  .2626E-03,  .7772E+02,  .3883E+02,
     +   .1267E+04,
     +   .9137E-03,  .5679E-03,  .2676E-03,  .8891E+02,  .4443E+02,
     +   .1467E+04,
     +   .9318E-03,  .5791E-03,  .2724E-03,  .1009E+03,  .5041E+02,
     +   .1682E+04,
     +   .9490E-03,  .5897E-03,  .2769E-03,  .1132E+03,  .5660E+02,
     +   .1904E+04,
     +   .9724E-03,  .6041E-03,  .2830E-03,  .1317E+03,  .6584E+02,
     +   .2236E+04,
     +   .9938E-03,  .6173E-03,  .2886E-03,  .1500E+03,  .7498E+02,
     +   .2568E+04,
     +   .1016E-02,  .6309E-03,  .2944E-03,  .1705E+03,  .8521E+02,
     +   .2941E+04 /
        DATA ((PARTON(I,N,7),I=1,6),N=25,27)/
     +   .1038E-02,  .6444E-03,  .3000E-03,  .1926E+03,  .9628E+02,
     +   .3343E+04,
     +   .1058E-02,  .6568E-03,  .3052E-03,  .2146E+03,  .1073E+03,
     +   .3739E+04,
     +   .1079E-02,  .6695E-03,  .3105E-03,  .2390E+03,  .1195E+03,
     +   .4177E+04 /
        DATA ((PARTON(I,N,8),I=1,6),N=1,8)/
     +   .7058E-03,  .4401E-03,  .2157E-03,  .9193E+00,  .4352E+00,
     +   .2950E+01,
     +   .7259E-03,  .4525E-03,  .2211E-03,  .1439E+01,  .6948E+00,
     +   .5113E+01,
     +   .7479E-03,  .4661E-03,  .2271E-03,  .2187E+01,  .1069E+01,
     +   .8785E+01,
     +   .7730E-03,  .4817E-03,  .2339E-03,  .3308E+01,  .1629E+01,
     +   .1536E+02,
     +   .8035E-03,  .5005E-03,  .2421E-03,  .4586E+01,  .2267E+01,
     +   .2977E+02,
     +   .8313E-03,  .5177E-03,  .2495E-03,  .6055E+01,  .3002E+01,
     +   .4916E+02,
     +   .8623E-03,  .5369E-03,  .2579E-03,  .8238E+01,  .4093E+01,
     +   .7896E+02,
     +   .8900E-03,  .5540E-03,  .2653E-03,  .1072E+02,  .5335E+01,
     +   .1142E+03 /
        DATA ((PARTON(I,N,8),I=1,6),N=9,16)/
     +   .9175E-03,  .5710E-03,  .2727E-03,  .1376E+02,  .6855E+01,
     +   .1589E+03,
     +   .9427E-03,  .5865E-03,  .2794E-03,  .1693E+02,  .8436E+01,
     +   .2092E+03,
     +   .9685E-03,  .6025E-03,  .2863E-03,  .2056E+02,  .1025E+02,
     +   .2710E+03,
     +   .9934E-03,  .6178E-03,  .2928E-03,  .2465E+02,  .1230E+02,
     +   .3410E+03,
     +   .1016E-02,  .6318E-03,  .2988E-03,  .2895E+02,  .1445E+02,
     +   .4151E+03,
     +   .1045E-02,  .6497E-03,  .3064E-03,  .3522E+02,  .1758E+02,
     +   .5239E+03,
     +   .1072E-02,  .6664E-03,  .3136E-03,  .4201E+02,  .2098E+02,
     +   .6426E+03,
     +   .1099E-02,  .6827E-03,  .3204E-03,  .4946E+02,  .2470E+02,
     +   .7736E+03 /
        DATA ((PARTON(I,N,8),I=1,6),N=17,24)/
     +   .1123E-02,  .6979E-03,  .3269E-03,  .5732E+02,  .2863E+02,
     +   .9121E+03,
     +   .1149E-02,  .7134E-03,  .3334E-03,  .6615E+02,  .3305E+02,
     +   .1068E+04,
     +   .1172E-02,  .7281E-03,  .3396E-03,  .7540E+02,  .3767E+02,
     +   .1232E+04,
     +   .1196E-02,  .7425E-03,  .3456E-03,  .8525E+02,  .4260E+02,
     +   .1407E+04,
     +   .1218E-02,  .7560E-03,  .3512E-03,  .9540E+02,  .4767E+02,
     +   .1587E+04,
     +   .1248E-02,  .7745E-03,  .3589E-03,  .1105E+03,  .5522E+02,
     +   .1855E+04,
     +   .1275E-02,  .7914E-03,  .3659E-03,  .1254E+03,  .6267E+02,
     +   .2122E+04,
     +   .1304E-02,  .8089E-03,  .3730E-03,  .1420E+03,  .7097E+02,
     +   .2420E+04 /
        DATA ((PARTON(I,N,8),I=1,6),N=25,27)/
     +   .1332E-02,  .8262E-03,  .3801E-03,  .1599E+03,  .7993E+02,
     +   .2740E+04,
     +   .1358E-02,  .8420E-03,  .3866E-03,  .1776E+03,  .8878E+02,
     +   .3054E+04,
     +   .1384E-02,  .8583E-03,  .3932E-03,  .1972E+03,  .9858E+02,
     +   .3400E+04 /
        DATA ((PARTON(I,N,9),I=1,6),N=1,8)/
     +   .8995E-03,  .5606E-03,  .2731E-03,  .8683E+00,  .4068E+00,
     +   .2936E+01,
     +   .9251E-03,  .5765E-03,  .2799E-03,  .1341E+01,  .6431E+00,
     +   .5051E+01,
     +   .9531E-03,  .5938E-03,  .2873E-03,  .2015E+01,  .9799E+00,
     +   .8587E+01,
     +   .9852E-03,  .6137E-03,  .2958E-03,  .3015E+01,  .1479E+01,
     +   .1481E+02,
     +   .1024E-02,  .6376E-03,  .3061E-03,  .4167E+01,  .2055E+01,
     +   .2796E+02,
     +   .1060E-02,  .6595E-03,  .3154E-03,  .5482E+01,  .2712E+01,
     +   .4535E+02,
     +   .1099E-02,  .6840E-03,  .3259E-03,  .7410E+01,  .3676E+01,
     +   .7179E+02,
     +   .1134E-02,  .7057E-03,  .3351E-03,  .9586E+01,  .4763E+01,
     +   .1028E+03 /
        DATA ((PARTON(I,N,9),I=1,6),N=9,16)/
     +   .1170E-02,  .7274E-03,  .3443E-03,  .1222E+02,  .6082E+01,
     +   .1417E+03,
     +   .1202E-02,  .7472E-03,  .3527E-03,  .1496E+02,  .7448E+01,
     +   .1851E+03,
     +   .1235E-02,  .7675E-03,  .3612E-03,  .1809E+02,  .9012E+01,
     +   .2379E+03,
     +   .1266E-02,  .7870E-03,  .3694E-03,  .2158E+02,  .1076E+02,
     +   .2974E+03,
     +   .1295E-02,  .8049E-03,  .3769E-03,  .2524E+02,  .1259E+02,
     +   .3600E+03,
     +   .1332E-02,  .8276E-03,  .3864E-03,  .3055E+02,  .1524E+02,
     +   .4515E+03,
     +   .1367E-02,  .8490E-03,  .3952E-03,  .3627E+02,  .1810E+02,
     +   .5506E+03,
     +   .1401E-02,  .8696E-03,  .4038E-03,  .4251E+02,  .2122E+02,
     +   .6593E+03 /
        DATA ((PARTON(I,N,9),I=1,6),N=17,24)/
     +   .1432E-02,  .8891E-03,  .4118E-03,  .4906E+02,  .2450E+02,
     +   .7737E+03,
     +   .1464E-02,  .9088E-03,  .4199E-03,  .5640E+02,  .2817E+02,
     +   .9021E+03,
     +   .1495E-02,  .9275E-03,  .4275E-03,  .6404E+02,  .3199E+02,
     +   .1036E+04,
     +   .1525E-02,  .9457E-03,  .4349E-03,  .7217E+02,  .3605E+02,
     +   .1179E+04,
     +   .1553E-02,  .9630E-03,  .4419E-03,  .8050E+02,  .4022E+02,
     +   .1325E+04,
     +   .1591E-02,  .9866E-03,  .4515E-03,  .9286E+02,  .4640E+02,
     +   .1541E+04,
     +   .1626E-02,  .1008E-02,  .4601E-03,  .1050E+03,  .5247E+02,
     +   .1755E+04,
     +   .1662E-02,  .1030E-02,  .4690E-03,  .1185E+03,  .5922E+02,
     +   .1994E+04 /
        DATA ((PARTON(I,N,9),I=1,6),N=25,27)/
     +   .1698E-02,  .1052E-02,  .4777E-03,  .1330E+03,  .6648E+02,
     +   .2249E+04,
     +   .1731E-02,  .1072E-02,  .4857E-03,  .1473E+03,  .7362E+02,
     +   .2499E+04,
     +   .1765E-02,  .1093E-02,  .4938E-03,  .1631E+03,  .8150E+02,
     +   .2772E+04 /
        DATA ((PARTON(I,N,10),I=1,6),N=1,8)/
     +   .1159E-02,  .7222E-03,  .3490E-03,  .8187E+00,  .3786E+00,
     +   .2907E+01,
     +   .1192E-02,  .7427E-03,  .3576E-03,  .1247E+01,  .5923E+00,
     +   .4960E+01,
     +   .1228E-02,  .7650E-03,  .3669E-03,  .1850E+01,  .8935E+00,
     +   .8339E+01,
     +   .1270E-02,  .7906E-03,  .3777E-03,  .2735E+01,  .1336E+01,
     +   .1419E+02,
     +   .1320E-02,  .8215E-03,  .3906E-03,  .3765E+01,  .1850E+01,
     +   .2608E+02,
     +   .1366E-02,  .8496E-03,  .4024E-03,  .4930E+01,  .2433E+01,
     +   .4155E+02,
     +   .1417E-02,  .8811E-03,  .4155E-03,  .6619E+01,  .3277E+01,
     +   .6480E+02,
     +   .1462E-02,  .9092E-03,  .4272E-03,  .8505E+01,  .4219E+01,
     +   .9173E+02 /
        DATA ((PARTON(I,N,10),I=1,6),N=9,16)/
     +   .1508E-02,  .9370E-03,  .4387E-03,  .1077E+02,  .5352E+01,
     +   .1252E+03,
     +   .1549E-02,  .9625E-03,  .4492E-03,  .1311E+02,  .6521E+01,
     +   .1623E+03,
     +   .1592E-02,  .9887E-03,  .4599E-03,  .1577E+02,  .7853E+01,
     +   .2070E+03,
     +   .1633E-02,  .1014E-02,  .4702E-03,  .1874E+02,  .9334E+01,
     +   .2570E+03,
     +   .1670E-02,  .1037E-02,  .4796E-03,  .2181E+02,  .1087E+02,
     +   .3093E+03,
     +   .1718E-02,  .1066E-02,  .4914E-03,  .2625E+02,  .1309E+02,
     +   .3851E+03,
     +   .1763E-02,  .1094E-02,  .5025E-03,  .3101E+02,  .1547E+02,
     +   .4668E+03,
     +   .1806E-02,  .1120E-02,  .5131E-03,  .3618E+02,  .1805E+02,
     +   .5559E+03 /
        DATA ((PARTON(I,N,10),I=1,6),N=17,24)/
     +   .1847E-02,  .1145E-02,  .5231E-03,  .4157E+02,  .2075E+02,
     +   .6491E+03,
     +   .1888E-02,  .1171E-02,  .5332E-03,  .4759E+02,  .2376E+02,
     +   .7532E+03,
     +   .1927E-02,  .1195E-02,  .5428E-03,  .5383E+02,  .2688E+02,
     +   .8612E+03,
     +   .1966E-02,  .1218E-02,  .5520E-03,  .6044E+02,  .3018E+02,
     +   .9756E+03,
     +   .2002E-02,  .1240E-02,  .5608E-03,  .6719E+02,  .3356E+02,
     +   .1092E+04,
     +   .2052E-02,  .1271E-02,  .5726E-03,  .7717E+02,  .3855E+02,
     +   .1265E+04,
     +   .2097E-02,  .1298E-02,  .5833E-03,  .8694E+02,  .4343E+02,
     +   .1434E+04,
     +   .2144E-02,  .1327E-02,  .5944E-03,  .9777E+02,  .4885E+02,
     +   .1622E+04 /
        DATA ((PARTON(I,N,10),I=1,6),N=25,27)/
     +   .2190E-02,  .1355E-02,  .6052E-03,  .1094E+03,  .5464E+02,
     +   .1822E+04,
     +   .2232E-02,  .1381E-02,  .6151E-03,  .1207E+03,  .6032E+02,
     +   .2017E+04,
     +   .2276E-02,  .1408E-02,  .6252E-03,  .1332E+03,  .6657E+02,
     +   .2230E+04 /
        DATA ((PARTON(I,N,11),I=1,6),N=1,8)/
     +   .1486E-02,  .9255E-03,  .4431E-03,  .7737E+00,  .3524E+00,
     +   .2868E+01,
     +   .1529E-02,  .9517E-03,  .4538E-03,  .1161E+01,  .5456E+00,
     +   .4849E+01,
     +   .1575E-02,  .9803E-03,  .4655E-03,  .1700E+01,  .8151E+00,
     +   .8063E+01,
     +   .1628E-02,  .1013E-02,  .4790E-03,  .2484E+01,  .1206E+01,
     +   .1354E+02,
     +   .1693E-02,  .1053E-02,  .4951E-03,  .3404E+01,  .1666E+01,
     +   .2428E+02,
     +   .1752E-02,  .1089E-02,  .5098E-03,  .4437E+01,  .2182E+01,
     +   .3802E+02,
     +   .1817E-02,  .1129E-02,  .5261E-03,  .5915E+01,  .2921E+01,
     +   .5843E+02,
     +   .1876E-02,  .1165E-02,  .5406E-03,  .7548E+01,  .3737E+01,
     +   .8183E+02 /
        DATA ((PARTON(I,N,11),I=1,6),N=9,16)/
     +   .1934E-02,  .1201E-02,  .5550E-03,  .9496E+01,  .4710E+01,
     +   .1107E+03,
     +   .1987E-02,  .1233E-02,  .5681E-03,  .1149E+02,  .5709E+01,
     +   .1422E+03,
     +   .2042E-02,  .1267E-02,  .5814E-03,  .1376E+02,  .6843E+01,
     +   .1800E+03,
     +   .2094E-02,  .1299E-02,  .5941E-03,  .1627E+02,  .8095E+01,
     +   .2220E+03,
     +   .2142E-02,  .1328E-02,  .6058E-03,  .1886E+02,  .9390E+01,
     +   .2657E+03,
     +   .2203E-02,  .1366E-02,  .6204E-03,  .2257E+02,  .1125E+02,
     +   .3285E+03,
     +   .2261E-02,  .1401E-02,  .6342E-03,  .2653E+02,  .1322E+02,
     +   .3958E+03,
     +   .2316E-02,  .1435E-02,  .6474E-03,  .3080E+02,  .1536E+02,
     +   .4687E+03 /
        DATA ((PARTON(I,N,11),I=1,6),N=17,24)/
     +   .2369E-02,  .1467E-02,  .6597E-03,  .3524E+02,  .1758E+02,
     +   .5446E+03,
     +   .2422E-02,  .1500E-02,  .6722E-03,  .4017E+02,  .2005E+02,
     +   .6288E+03,
     +   .2472E-02,  .1530E-02,  .6840E-03,  .4527E+02,  .2260E+02,
     +   .7159E+03,
     +   .2522E-02,  .1560E-02,  .6954E-03,  .5065E+02,  .2528E+02,
     +   .8076E+03,
     +   .2568E-02,  .1589E-02,  .7062E-03,  .5612E+02,  .2802E+02,
     +   .9009E+03,
     +   .2632E-02,  .1628E-02,  .7208E-03,  .6417E+02,  .3205E+02,
     +   .1038E+04,
     +   .2690E-02,  .1663E-02,  .7340E-03,  .7203E+02,  .3597E+02,
     +   .1172E+04,
     +   .2750E-02,  .1699E-02,  .7476E-03,  .8071E+02,  .4031E+02,
     +   .1320E+04 /
        DATA ((PARTON(I,N,11),I=1,6),N=25,27)/
     +   .2809E-02,  .1736E-02,  .7609E-03,  .8996E+02,  .4493E+02,
     +   .1477E+04,
     +   .2863E-02,  .1769E-02,  .7730E-03,  .9899E+02,  .4945E+02,
     +   .1629E+04,
     +   .2919E-02,  .1803E-02,  .7854E-03,  .1089E+03,  .5440E+02,
     +   .1794E+04 /
        DATA ((PARTON(I,N,12),I=1,6),N=1,8)/
     +   .1907E-02,  .1187E-02,  .5618E-03,  .7321E+00,  .3274E+00,
     +   .2818E+01,
     +   .1962E-02,  .1221E-02,  .5752E-03,  .1081E+01,  .5017E+00,
     +   .4720E+01,
     +   .2022E-02,  .1257E-02,  .5898E-03,  .1563E+01,  .7419E+00,
     +   .7758E+01,
     +   .2090E-02,  .1300E-02,  .6066E-03,  .2254E+01,  .1087E+01,
     +   .1285E+02,
     +   .2173E-02,  .1350E-02,  .6267E-03,  .3073E+01,  .1496E+01,
     +   .2251E+02,
     +   .2249E-02,  .1397E-02,  .6450E-03,  .3984E+01,  .1951E+01,
     +   .3467E+02,
     +   .2333E-02,  .1448E-02,  .6653E-03,  .5272E+01,  .2595E+01,
     +   .5252E+02,
     +   .2408E-02,  .1494E-02,  .6833E-03,  .6681E+01,  .3299E+01,
     +   .7275E+02 /
        DATA ((PARTON(I,N,12),I=1,6),N=9,16)/
     +   .2483E-02,  .1540E-02,  .7011E-03,  .8347E+01,  .4131E+01,
     +   .9743E+02,
     +   .2551E-02,  .1582E-02,  .7173E-03,  .1005E+02,  .4981E+01,
     +   .1242E+03,
     +   .2621E-02,  .1625E-02,  .7338E-03,  .1197E+02,  .5942E+01,
     +   .1560E+03,
     +   .2689E-02,  .1666E-02,  .7495E-03,  .1408E+02,  .6996E+01,
     +   .1911E+03,
     +   .2751E-02,  .1704E-02,  .7639E-03,  .1625E+02,  .8080E+01,
     +   .2273E+03,
     +   .2829E-02,  .1751E-02,  .7820E-03,  .1934E+02,  .9625E+01,
     +   .2791E+03,
     +   .2903E-02,  .1797E-02,  .7989E-03,  .2261E+02,  .1126E+02,
     +   .3342E+03,
     +   .2974E-02,  .1840E-02,  .8152E-03,  .2613E+02,  .1302E+02,
     +   .3935E+03 /
        DATA ((PARTON(I,N,12),I=1,6),N=17,24)/
     +   .3042E-02,  .1881E-02,  .8304E-03,  .2977E+02,  .1484E+02,
     +   .4549E+03,
     +   .3110E-02,  .1923E-02,  .8457E-03,  .3379E+02,  .1685E+02,
     +   .5227E+03,
     +   .3175E-02,  .1962E-02,  .8602E-03,  .3793E+02,  .1892E+02,
     +   .5924E+03,
     +   .3238E-02,  .2001E-02,  .8742E-03,  .4228E+02,  .2109E+02,
     +   .6655E+03,
     +   .3298E-02,  .2037E-02,  .8874E-03,  .4669E+02,  .2330E+02,
     +   .7394E+03,
     +   .3379E-02,  .2087E-02,  .9053E-03,  .5315E+02,  .2653E+02,
     +   .8475E+03,
     +   .3454E-02,  .2132E-02,  .9215E-03,  .5944E+02,  .2967E+02,
     +   .9528E+03,
     +   .3531E-02,  .2178E-02,  .9381E-03,  .6634E+02,  .3312E+02,
     +   .1069E+04 /
        DATA ((PARTON(I,N,12),I=1,6),N=25,27)/
     +   .3607E-02,  .2225E-02,  .9544E-03,  .7368E+02,  .3679E+02,
     +   .1190E+04,
     +   .3677E-02,  .2267E-02,  .9692E-03,  .8083E+02,  .4036E+02,
     +   .1308E+04,
     +   .3748E-02,  .2310E-02,  .9844E-03,  .8862E+02,  .4426E+02,
     +   .1436E+04 /
        DATA ((PARTON(I,N,13),I=1,6),N=1,8)/
     +   .2433E-02,  .1513E-02,  .7064E-03,  .6948E+00,  .3043E+00,
     +   .2760E+01,
     +   .2503E-02,  .1556E-02,  .7229E-03,  .1010E+01,  .4614E+00,
     +   .4579E+01,
     +   .2579E-02,  .1603E-02,  .7410E-03,  .1439E+01,  .6757E+00,
     +   .7441E+01,
     +   .2667E-02,  .1656E-02,  .7618E-03,  .2050E+01,  .9806E+00,
     +   .1216E+02,
     +   .2772E-02,  .1721E-02,  .7865E-03,  .2778E+01,  .1344E+01,
     +   .2084E+02,
     +   .2869E-02,  .1780E-02,  .8090E-03,  .3582E+01,  .1745E+01,
     +   .3159E+02,
     +   .2976E-02,  .1846E-02,  .8340E-03,  .4704E+01,  .2306E+01,
     +   .4718E+02,
     +   .3072E-02,  .1904E-02,  .8561E-03,  .5920E+01,  .2913E+01,
     +   .6467E+02 /
        DATA ((PARTON(I,N,13),I=1,6),N=9,16)/
     +   .3167E-02,  .1962E-02,  .8780E-03,  .7345E+01,  .3625E+01,
     +   .8580E+02,
     +   .3255E-02,  .2016E-02,  .8978E-03,  .8793E+01,  .4349E+01,
     +   .1085E+03,
     +   .3344E-02,  .2070E-02,  .9179E-03,  .1042E+02,  .5163E+01,
     +   .1352E+03,
     +   .3430E-02,  .2122E-02,  .9372E-03,  .1220E+02,  .6051E+01,
     +   .1645E+03,
     +   .3509E-02,  .2170E-02,  .9547E-03,  .1401E+02,  .6958E+01,
     +   .1946E+03,
     +   .3609E-02,  .2231E-02,  .9768E-03,  .1659E+02,  .8245E+01,
     +   .2373E+03,
     +   .3704E-02,  .2289E-02,  .9974E-03,  .1930E+02,  .9599E+01,
     +   .2824E+03,
     +   .3795E-02,  .2344E-02,  .1017E-02,  .2219E+02,  .1105E+02,
     +   .3306E+03 /
        DATA ((PARTON(I,N,13),I=1,6),N=17,24)/
     +   .3881E-02,  .2396E-02,  .1036E-02,  .2518E+02,  .1254E+02,
     +   .3802E+03,
     +   .3968E-02,  .2449E-02,  .1054E-02,  .2846E+02,  .1418E+02,
     +   .4348E+03,
     +   .4050E-02,  .2499E-02,  .1072E-02,  .3182E+02,  .1586E+02,
     +   .4906E+03,
     +   .4131E-02,  .2548E-02,  .1089E-02,  .3534E+02,  .1762E+02,
     +   .5488E+03,
     +   .4207E-02,  .2594E-02,  .1105E-02,  .3890E+02,  .1940E+02,
     +   .6075E+03,
     +   .4311E-02,  .2657E-02,  .1127E-02,  .4409E+02,  .2199E+02,
     +   .6927E+03,
     +   .4406E-02,  .2715E-02,  .1146E-02,  .4912E+02,  .2451E+02,
     +   .7755E+03,
     +   .4504E-02,  .2774E-02,  .1166E-02,  .5462E+02,  .2726E+02,
     +   .8659E+03 /
        DATA ((PARTON(I,N,13),I=1,6),N=25,27)/
     +   .4602E-02,  .2833E-02,  .1186E-02,  .6045E+02,  .3017E+02,
     +   .9607E+03,
     +   .4691E-02,  .2886E-02,  .1204E-02,  .6610E+02,  .3300E+02,
     +   .1052E+04,
     +   .4782E-02,  .2942E-02,  .1222E-02,  .7225E+02,  .3607E+02,
     +   .1150E+04 /
        DATA ((PARTON(I,N,14),I=1,6),N=1,8)/
     +   .2814E-02,  .1750E-02,  .8092E-03,  .6740E+00,  .2909E+00,
     +   .2722E+01,
     +   .2895E-02,  .1799E-02,  .8279E-03,  .9700E+00,  .4385E+00,
     +   .4488E+01,
     +   .2984E-02,  .1853E-02,  .8484E-03,  .1371E+01,  .6384E+00,
     +   .7243E+01,
     +   .3085E-02,  .1915E-02,  .8719E-03,  .1937E+01,  .9209E+00,
     +   .1174E+02,
     +   .3208E-02,  .1990E-02,  .8999E-03,  .2614E+01,  .1259E+01,
     +   .1986E+02,
     +   .3319E-02,  .2058E-02,  .9253E-03,  .3358E+01,  .1630E+01,
     +   .2984E+02,
     +   .3444E-02,  .2134E-02,  .9535E-03,  .4390E+01,  .2146E+01,
     +   .4419E+02,
     +   .3555E-02,  .2201E-02,  .9784E-03,  .5500E+01,  .2700E+01,
     +   .6018E+02 /
        DATA ((PARTON(I,N,14),I=1,6),N=9,16)/
     +   .3665E-02,  .2269E-02,  .1003E-02,  .6796E+01,  .3348E+01,
     +   .7938E+02,
     +   .3766E-02,  .2330E-02,  .1025E-02,  .8108E+01,  .4003E+01,
     +   .9992E+02,
     +   .3870E-02,  .2393E-02,  .1048E-02,  .9581E+01,  .4739E+01,
     +   .1240E+03,
     +   .3969E-02,  .2454E-02,  .1070E-02,  .1118E+02,  .5538E+01,
     +   .1502E+03,
     +   .4061E-02,  .2509E-02,  .1089E-02,  .1281E+02,  .6353E+01,
     +   .1770E+03,
     +   .4176E-02,  .2579E-02,  .1114E-02,  .1511E+02,  .7503E+01,
     +   .2149E+03,
     +   .4285E-02,  .2645E-02,  .1137E-02,  .1753E+02,  .8710E+01,
     +   .2548E+03,
     +   .4391E-02,  .2709E-02,  .1159E-02,  .2010E+02,  .9996E+01,
     +   .2973E+03 /
        DATA ((PARTON(I,N,14),I=1,6),N=17,24)/
     +   .4490E-02,  .2770E-02,  .1180E-02,  .2274E+02,  .1132E+02,
     +   .3409E+03,
     +   .4591E-02,  .2830E-02,  .1201E-02,  .2564E+02,  .1277E+02,
     +   .3886E+03,
     +   .4686E-02,  .2888E-02,  .1221E-02,  .2860E+02,  .1425E+02,
     +   .4373E+03,
     +   .4780E-02,  .2945E-02,  .1240E-02,  .3169E+02,  .1579E+02,
     +   .4880E+03,
     +   .4868E-02,  .2998E-02,  .1258E-02,  .3481E+02,  .1735E+02,
     +   .5389E+03,
     +   .4988E-02,  .3071E-02,  .1282E-02,  .3935E+02,  .1962E+02,
     +   .6127E+03,
     +   .5098E-02,  .3137E-02,  .1304E-02,  .4374E+02,  .2181E+02,
     +   .6840E+03,
     +   .5212E-02,  .3205E-02,  .1326E-02,  .4854E+02,  .2421E+02,
     +   .7617E+03 /
        DATA ((PARTON(I,N,14),I=1,6),N=25,27)/
     +   .5324E-02,  .3273E-02,  .1348E-02,  .5360E+02,  .2674E+02,
     +   .8430E+03,
     +   .5427E-02,  .3335E-02,  .1368E-02,  .5849E+02,  .2919E+02,
     +   .9210E+03,
     +   .5533E-02,  .3399E-02,  .1388E-02,  .6381E+02,  .3185E+02,
     +   .1005E+04 /
        DATA ((PARTON(I,N,15),I=1,6),N=1,8)/
     +   .3285E-02,  .2041E-02,  .9335E-03,  .6533E+00,  .2772E+00,
     +   .2678E+01,
     +   .3380E-02,  .2099E-02,  .9548E-03,  .9299E+00,  .4151E+00,
     +   .4387E+01,
     +   .3483E-02,  .2162E-02,  .9782E-03,  .1302E+01,  .6005E+00,
     +   .7027E+01,
     +   .3602E-02,  .2234E-02,  .1005E-02,  .1823E+01,  .8608E+00,
     +   .1129E+02,
     +   .3744E-02,  .2321E-02,  .1037E-02,  .2450E+01,  .1174E+01,
     +   .1885E+02,
     +   .3875E-02,  .2400E-02,  .1066E-02,  .3135E+01,  .1515E+01,
     +   .2804E+02,
     +   .4020E-02,  .2489E-02,  .1097E-02,  .4077E+01,  .1986E+01,
     +   .4117E+02,
     +   .4150E-02,  .2568E-02,  .1126E-02,  .5084E+01,  .2489E+01,
     +   .5568E+02 /
        DATA ((PARTON(I,N,15),I=1,6),N=9,16)/
     +   .4279E-02,  .2646E-02,  .1154E-02,  .6253E+01,  .3073E+01,
     +   .7301E+02,
     +   .4396E-02,  .2717E-02,  .1179E-02,  .7433E+01,  .3662E+01,
     +   .9143E+02,
     +   .4517E-02,  .2791E-02,  .1205E-02,  .8754E+01,  .4322E+01,
     +   .1129E+03,
     +   .4634E-02,  .2861E-02,  .1229E-02,  .1018E+02,  .5036E+01,
     +   .1361E+03,
     +   .4740E-02,  .2926E-02,  .1251E-02,  .1163E+02,  .5760E+01,
     +   .1598E+03,
     +   .4875E-02,  .3008E-02,  .1279E-02,  .1367E+02,  .6780E+01,
     +   .1932E+03,
     +   .5002E-02,  .3085E-02,  .1305E-02,  .1581E+02,  .7846E+01,
     +   .2281E+03,
     +   .5126E-02,  .3159E-02,  .1330E-02,  .1807E+02,  .8978E+01,
     +   .2652E+03 /
        DATA ((PARTON(I,N,15),I=1,6),N=17,24)/
     +   .5242E-02,  .3229E-02,  .1353E-02,  .2039E+02,  .1014E+02,
     +   .3031E+03,
     +   .5359E-02,  .3300E-02,  .1377E-02,  .2292E+02,  .1140E+02,
     +   .3445E+03,
     +   .5471E-02,  .3367E-02,  .1399E-02,  .2551E+02,  .1270E+02,
     +   .3865E+03,
     +   .5579E-02,  .3433E-02,  .1420E-02,  .2820E+02,  .1404E+02,
     +   .4301E+03,
     +   .5682E-02,  .3495E-02,  .1440E-02,  .3091E+02,  .1539E+02,
     +   .4738E+03,
     +   .5823E-02,  .3580E-02,  .1467E-02,  .3484E+02,  .1736E+02,
     +   .5369E+03,
     +   .5951E-02,  .3657E-02,  .1492E-02,  .3863E+02,  .1925E+02,
     +   .5977E+03,
     +   .6083E-02,  .3736E-02,  .1517E-02,  .4276E+02,  .2132E+02,
     +   .6637E+03 /
        DATA ((PARTON(I,N,15),I=1,6),N=25,27)/
     +   .6215E-02,  .3815E-02,  .1541E-02,  .4711E+02,  .2349E+02,
     +   .7326E+03,
     +   .6334E-02,  .3887E-02,  .1564E-02,  .5131E+02,  .2559E+02,
     +   .7984E+03,
     +   .6458E-02,  .3961E-02,  .1586E-02,  .5585E+02,  .2786E+02,
     +   .8691E+03 /
        DATA ((PARTON(I,N,16),I=1,6),N=1,8)/
     +   .3917E-02,  .2432E-02,  .1096E-02,  .6313E+00,  .2621E+00,
     +   .2625E+01,
     +   .4030E-02,  .2501E-02,  .1121E-02,  .8871E+00,  .3896E+00,
     +   .4268E+01,
     +   .4154E-02,  .2576E-02,  .1148E-02,  .1228E+01,  .5596E+00,
     +   .6777E+01,
     +   .4295E-02,  .2662E-02,  .1179E-02,  .1703E+01,  .7963E+00,
     +   .1078E+02,
     +   .4465E-02,  .2765E-02,  .1216E-02,  .2276E+01,  .1082E+01,
     +   .1774E+02,
     +   .4621E-02,  .2860E-02,  .1249E-02,  .2897E+01,  .1392E+01,
     +   .2610E+02,
     +   .4794E-02,  .2965E-02,  .1286E-02,  .3744E+01,  .1815E+01,
     +   .3792E+02,
     +   .4949E-02,  .3058E-02,  .1318E-02,  .4644E+01,  .2264E+01,
     +   .5090E+02 /
        DATA ((PARTON(I,N,16),I=1,6),N=9,16)/
     +   .5102E-02,  .3151E-02,  .1350E-02,  .5682E+01,  .2783E+01,
     +   .6627E+02,
     +   .5243E-02,  .3237E-02,  .1379E-02,  .6726E+01,  .3304E+01,
     +   .8250E+02,
     +   .5387E-02,  .3324E-02,  .1408E-02,  .7890E+01,  .3886E+01,
     +   .1013E+03,
     +   .5526E-02,  .3407E-02,  .1436E-02,  .9143E+01,  .4512E+01,
     +   .1215E+03,
     +   .5653E-02,  .3484E-02,  .1461E-02,  .1041E+02,  .5145E+01,
     +   .1420E+03,
     +   .5814E-02,  .3581E-02,  .1493E-02,  .1218E+02,  .6032E+01,
     +   .1708E+03,
     +   .5965E-02,  .3673E-02,  .1523E-02,  .1403E+02,  .6955E+01,
     +   .2008E+03,
     +   .6112E-02,  .3761E-02,  .1551E-02,  .1599E+02,  .7931E+01,
     +   .2324E+03 /
        DATA ((PARTON(I,N,16),I=1,6),N=17,24)/
     +   .6250E-02,  .3844E-02,  .1578E-02,  .1798E+02,  .8927E+01,
     +   .2647E+03,
     +   .6390E-02,  .3929E-02,  .1605E-02,  .2015E+02,  .1001E+02,
     +   .2997E+03,
     +   .6523E-02,  .4009E-02,  .1630E-02,  .2236E+02,  .1112E+02,
     +   .3351E+03,
     +   .6653E-02,  .4086E-02,  .1654E-02,  .2465E+02,  .1226E+02,
     +   .3717E+03,
     +   .6776E-02,  .4160E-02,  .1677E-02,  .2695E+02,  .1341E+02,
     +   .4083E+03,
     +   .6943E-02,  .4261E-02,  .1707E-02,  .3028E+02,  .1507E+02,
     +   .4609E+03,
     +   .7096E-02,  .4352E-02,  .1735E-02,  .3348E+02,  .1667E+02,
     +   .5114E+03,
     +   .7253E-02,  .4447E-02,  .1763E-02,  .3695E+02,  .1841E+02,
     +   .5661E+03 /
        DATA ((PARTON(I,N,16),I=1,6),N=25,27)/
     +   .7409E-02,  .4540E-02,  .1791E-02,  .4060E+02,  .2023E+02,
     +   .6228E+03,
     +   .7552E-02,  .4625E-02,  .1816E-02,  .4411E+02,  .2199E+02,
     +   .6770E+03,
     +   .7699E-02,  .4713E-02,  .1842E-02,  .4790E+02,  .2389E+02,
     +   .7349E+03 /
        DATA ((PARTON(I,N,17),I=1,6),N=1,8)/
     +   .4672E-02,  .2899E-02,  .1285E-02,  .6109E+00,  .2476E+00,
     +   .2568E+01,
     +   .4807E-02,  .2980E-02,  .1314E-02,  .8471E+00,  .3652E+00,
     +   .4144E+01,
     +   .4954E-02,  .3070E-02,  .1345E-02,  .1159E+01,  .5207E+00,
     +   .6522E+01,
     +   .5123E-02,  .3172E-02,  .1381E-02,  .1591E+01,  .7357E+00,
     +   .1028E+02,
     +   .5326E-02,  .3295E-02,  .1423E-02,  .2113E+01,  .9960E+00,
     +   .1666E+02,
     +   .5511E-02,  .3407E-02,  .1461E-02,  .2675E+01,  .1277E+01,
     +   .2424E+02,
     +   .5718E-02,  .3532E-02,  .1503E-02,  .3436E+01,  .1656E+01,
     +   .3487E+02,
     +   .5902E-02,  .3643E-02,  .1540E-02,  .4238E+01,  .2057E+01,
     +   .4643E+02 /
        DATA ((PARTON(I,N,17),I=1,6),N=9,16)/
     +   .6085E-02,  .3754E-02,  .1576E-02,  .5157E+01,  .2516E+01,
     +   .6004E+02,
     +   .6253E-02,  .3855E-02,  .1609E-02,  .6078E+01,  .2976E+01,
     +   .7429E+02,
     +   .6425E-02,  .3958E-02,  .1643E-02,  .7102E+01,  .3487E+01,
     +   .9067E+02,
     +   .6590E-02,  .4058E-02,  .1674E-02,  .8198E+01,  .4034E+01,
     +   .1083E+03,
     +   .6741E-02,  .4149E-02,  .1703E-02,  .9302E+01,  .4586E+01,
     +   .1260E+03,
     +   .6933E-02,  .4264E-02,  .1739E-02,  .1084E+02,  .5355E+01,
     +   .1507E+03,
     +   .7114E-02,  .4373E-02,  .1773E-02,  .1244E+02,  .6152E+01,
     +   .1763E+03,
     +   .7289E-02,  .4478E-02,  .1805E-02,  .1412E+02,  .6992E+01,
     +   .2032E+03 /
        DATA ((PARTON(I,N,17),I=1,6),N=17,24)/
     +   .7454E-02,  .4577E-02,  .1835E-02,  .1583E+02,  .7845E+01,
     +   .2305E+03,
     +   .7621E-02,  .4677E-02,  .1865E-02,  .1768E+02,  .8773E+01,
     +   .2600E+03,
     +   .7779E-02,  .4772E-02,  .1894E-02,  .1956E+02,  .9712E+01,
     +   .2898E+03,
     +   .7933E-02,  .4864E-02,  .1921E-02,  .2151E+02,  .1068E+02,
     +   .3204E+03,
     +   .8080E-02,  .4952E-02,  .1947E-02,  .2345E+02,  .1166E+02,
     +   .3509E+03,
     +   .8279E-02,  .5071E-02,  .1981E-02,  .2626E+02,  .1306E+02,
     +   .3946E+03,
     +   .8461E-02,  .5179E-02,  .2012E-02,  .2895E+02,  .1441E+02,
     +   .4364E+03,
     +   .8649E-02,  .5291E-02,  .2044E-02,  .3187E+02,  .1586E+02,
     +   .4814E+03 /
        DATA ((PARTON(I,N,17),I=1,6),N=25,27)/
     +   .8834E-02,  .5402E-02,  .2075E-02,  .3492E+02,  .1739E+02,
     +   .5281E+03,
     +   .9004E-02,  .5503E-02,  .2104E-02,  .3784E+02,  .1885E+02,
     +   .5723E+03,
     +   .9179E-02,  .5607E-02,  .2132E-02,  .4100E+02,  .2043E+02,
     +   .6196E+03 /
        DATA ((PARTON(I,N,18),I=1,6),N=1,8)/
     +   .5556E-02,  .3444E-02,  .1499E-02,  .5926E+00,  .2338E+00,
     +   .2509E+01,
     +   .5717E-02,  .3541E-02,  .1532E-02,  .8106E+00,  .3422E+00,
     +   .4018E+01,
     +   .5892E-02,  .3646E-02,  .1568E-02,  .1096E+01,  .4846E+00,
     +   .6269E+01,
     +   .6092E-02,  .3768E-02,  .1608E-02,  .1488E+01,  .6797E+00,
     +   .9779E+01,
     +   .6333E-02,  .3913E-02,  .1656E-02,  .1964E+01,  .9168E+00,
     +   .1563E+02,
     +   .6553E-02,  .4046E-02,  .1700E-02,  .2473E+01,  .1171E+01,
     +   .2250E+02,
     +   .6799E-02,  .4194E-02,  .1748E-02,  .3156E+01,  .1511E+01,
     +   .3205E+02,
     +   .7018E-02,  .4326E-02,  .1790E-02,  .3870E+01,  .1868E+01,
     +   .4235E+02 /
        DATA ((PARTON(I,N,18),I=1,6),N=9,16)/
     +   .7236E-02,  .4457E-02,  .1831E-02,  .4684E+01,  .2274E+01,
     +   .5438E+02,
     +   .7435E-02,  .4577E-02,  .1868E-02,  .5496E+01,  .2680E+01,
     +   .6689E+02,
     +   .7639E-02,  .4699E-02,  .1906E-02,  .6396E+01,  .3129E+01,
     +   .8118E+02,
     +   .7835E-02,  .4817E-02,  .1942E-02,  .7355E+01,  .3608E+01,
     +   .9644E+02,
     +   .8015E-02,  .4925E-02,  .1974E-02,  .8316E+01,  .4088E+01,
     +   .1117E+03,
     +   .8243E-02,  .5061E-02,  .2015E-02,  .9652E+01,  .4755E+01,
     +   .1330E+03,
     +   .8458E-02,  .5190E-02,  .2053E-02,  .1103E+02,  .5443E+01,
     +   .1548E+03,
     +   .8666E-02,  .5314E-02,  .2089E-02,  .1247E+02,  .6165E+01,
     +   .1777E+03 /
        DATA ((PARTON(I,N,18),I=1,6),N=17,24)/
     +   .8861E-02,  .5431E-02,  .2123E-02,  .1394E+02,  .6897E+01,
     +   .2008E+03,
     +   .9059E-02,  .5549E-02,  .2157E-02,  .1552E+02,  .7688E+01,
     +   .2256E+03,
     +   .9247E-02,  .5661E-02,  .2188E-02,  .1712E+02,  .8488E+01,
     +   .2506E+03,
     +   .9431E-02,  .5771E-02,  .2219E-02,  .1877E+02,  .9313E+01,
     +   .2762E+03,
     +   .9604E-02,  .5874E-02,  .2248E-02,  .2042E+02,  .1014E+02,
     +   .3016E+03,
     +   .9841E-02,  .6015E-02,  .2286E-02,  .2279E+02,  .1132E+02,
     +   .3379E+03,
     +   .1006E-01,  .6143E-02,  .2321E-02,  .2505E+02,  .1245E+02,
     +   .3724E+03,
     +   .1028E-01,  .6275E-02,  .2357E-02,  .2750E+02,  .1367E+02,
     +   .4095E+03 /
        DATA ((PARTON(I,N,18),I=1,6),N=25,27)/
     +   .1050E-01,  .6406E-02,  .2391E-02,  .3005E+02,  .1495E+02,
     +   .4477E+03,
     +   .1070E-01,  .6526E-02,  .2423E-02,  .3248E+02,  .1617E+02,
     +   .4839E+03,
     +   .1091E-01,  .6648E-02,  .2455E-02,  .3511E+02,  .1748E+02,
     +   .5224E+03 /
        DATA ((PARTON(I,N,19),I=1,6),N=1,8)/
     +   .6617E-02,  .4097E-02,  .1747E-02,  .5757E+00,  .2203E+00,
     +   .2448E+01,
     +   .6807E-02,  .4211E-02,  .1784E-02,  .7765E+00,  .3202E+00,
     +   .3887E+01,
     +   .7015E-02,  .4337E-02,  .1825E-02,  .1038E+01,  .4500E+00,
     +   .6012E+01,
     +   .7254E-02,  .4480E-02,  .1871E-02,  .1392E+01,  .6267E+00,
     +   .9284E+01,
     +   .7541E-02,  .4653E-02,  .1926E-02,  .1824E+01,  .8420E+00,
     +   .1463E+02,
     +   .7803E-02,  .4810E-02,  .1975E-02,  .2284E+01,  .1071E+01,
     +   .2085E+02,
     +   .8095E-02,  .4985E-02,  .2029E-02,  .2895E+01,  .1376E+01,
     +   .2939E+02,
     +   .8355E-02,  .5142E-02,  .2076E-02,  .3529E+01,  .1692E+01,
     +   .3854E+02 /
        DATA ((PARTON(I,N,19),I=1,6),N=9,16)/
     +   .8614E-02,  .5297E-02,  .2123E-02,  .4247E+01,  .2050E+01,
     +   .4913E+02,
     +   .8851E-02,  .5439E-02,  .2165E-02,  .4961E+01,  .2407E+01,
     +   .6007E+02,
     +   .9094E-02,  .5584E-02,  .2208E-02,  .5749E+01,  .2800E+01,
     +   .7248E+02,
     +   .9327E-02,  .5724E-02,  .2248E-02,  .6585E+01,  .3217E+01,
     +   .8565E+02,
     +   .9541E-02,  .5851E-02,  .2284E-02,  .7419E+01,  .3634E+01,
     +   .9880E+02,
     +   .9812E-02,  .6013E-02,  .2330E-02,  .8572E+01,  .4210E+01,
     +   .1169E+03,
     +   .1007E-01,  .6165E-02,  .2372E-02,  .9757E+01,  .4802E+01,
     +   .1355E+03,
     +   .1031E-01,  .6312E-02,  .2413E-02,  .1100E+02,  .5420E+01,
     +   .1549E+03 /
        DATA ((PARTON(I,N,19),I=1,6),N=17,24)/
     +   .1055E-01,  .6451E-02,  .2450E-02,  .1224E+02,  .6044E+01,
     +   .1743E+03,
     +   .1078E-01,  .6591E-02,  .2488E-02,  .1359E+02,  .6717E+01,
     +   .1951E+03,
     +   .1101E-01,  .6723E-02,  .2523E-02,  .1495E+02,  .7395E+01,
     +   .2160E+03,
     +   .1122E-01,  .6853E-02,  .2557E-02,  .1634E+02,  .8091E+01,
     +   .2373E+03,
     +   .1143E-01,  .6975E-02,  .2589E-02,  .1773E+02,  .8784E+01,
     +   .2583E+03,
     +   .1171E-01,  .7142E-02,  .2632E-02,  .1972E+02,  .9778E+01,
     +   .2882E+03,
     +   .1197E-01,  .7293E-02,  .2671E-02,  .2161E+02,  .1072E+02,
     +   .3166E+03,
     +   .1223E-01,  .7449E-02,  .2710E-02,  .2365E+02,  .1174E+02,
     +   .3469E+03 /
        DATA ((PARTON(I,N,19),I=1,6),N=25,27)/
     +   .1249E-01,  .7604E-02,  .2749E-02,  .2577E+02,  .1280E+02,
     +   .3781E+03,
     +   .1273E-01,  .7745E-02,  .2784E-02,  .2779E+02,  .1381E+02,
     +   .4075E+03,
     +   .1298E-01,  .7890E-02,  .2819E-02,  .2996E+02,  .1490E+02,
     +   .4386E+03 /
        DATA ((PARTON(I,N,20),I=1,6),N=1,8)/
     +   .7664E-02,  .4740E-02,  .1981E-02,  .5627E+00,  .2094E+00,
     +   .2394E+01,
     +   .7885E-02,  .4872E-02,  .2023E-02,  .7498E+00,  .3023E+00,
     +   .3776E+01,
     +   .8126E-02,  .5017E-02,  .2068E-02,  .9913E+00,  .4224E+00,
     +   .5795E+01,
     +   .8402E-02,  .5183E-02,  .2120E-02,  .1317E+01,  .5847E+00,
     +   .8873E+01,
     +   .8734E-02,  .5382E-02,  .2180E-02,  .1715E+01,  .7827E+00,
     +   .1383E+02,
     +   .9036E-02,  .5563E-02,  .2235E-02,  .2136E+01,  .9922E+00,
     +   .1952E+02,
     +   .9374E-02,  .5765E-02,  .2295E-02,  .2691E+01,  .1269E+01,
     +   .2729E+02,
     +   .9675E-02,  .5945E-02,  .2347E-02,  .3264E+01,  .1555E+01,
     +   .3554E+02 /
        DATA ((PARTON(I,N,20),I=1,6),N=9,16)/
     +   .9975E-02,  .6124E-02,  .2399E-02,  .3909E+01,  .1876E+01,
     +   .4503E+02,
     +   .1025E-01,  .6288E-02,  .2445E-02,  .4548E+01,  .2195E+01,
     +   .5478E+02,
     +   .1053E-01,  .6455E-02,  .2491E-02,  .5251E+01,  .2546E+01,
     +   .6577E+02,
     +   .1080E-01,  .6616E-02,  .2535E-02,  .5994E+01,  .2917E+01,
     +   .7738E+02,
     +   .1105E-01,  .6763E-02,  .2575E-02,  .6732E+01,  .3286E+01,
     +   .8892E+02,
     +   .1136E-01,  .6949E-02,  .2625E-02,  .7750E+01,  .3794E+01,
     +   .1048E+03,
     +   .1165E-01,  .7125E-02,  .2672E-02,  .8791E+01,  .4314E+01,
     +   .1209E+03,
     +   .1194E-01,  .7294E-02,  .2716E-02,  .9875E+01,  .4855E+01,
     +   .1377E+03 /
        DATA ((PARTON(I,N,20),I=1,6),N=17,24)/
     +   .1221E-01,  .7453E-02,  .2757E-02,  .1097E+02,  .5400E+01,
     +   .1544E+03,
     +   .1248E-01,  .7614E-02,  .2798E-02,  .1214E+02,  .5985E+01,
     +   .1723E+03,
     +   .1274E-01,  .7767E-02,  .2836E-02,  .1331E+02,  .6573E+01,
     +   .1902E+03,
     +   .1299E-01,  .7916E-02,  .2874E-02,  .1452E+02,  .7176E+01,
     +   .2083E+03,
     +   .1323E-01,  .8057E-02,  .2908E-02,  .1572E+02,  .7774E+01,
     +   .2262E+03,
     +   .1355E-01,  .8248E-02,  .2955E-02,  .1743E+02,  .8630E+01,
     +   .2516E+03,
     +   .1385E-01,  .8423E-02,  .2997E-02,  .1906E+02,  .9442E+01,
     +   .2755E+03,
     +   .1416E-01,  .8602E-02,  .3040E-02,  .2080E+02,  .1032E+02,
     +   .3010E+03 /
        DATA ((PARTON(I,N,20),I=1,6),N=25,27)/
     +   .1446E-01,  .8780E-02,  .3081E-02,  .2261E+02,  .1122E+02,
     +   .3272E+03,
     +   .1473E-01,  .8942E-02,  .3119E-02,  .2434E+02,  .1208E+02,
     +   .3517E+03,
     +   .1502E-01,  .9108E-02,  .3157E-02,  .2618E+02,  .1300E+02,
     +   .3777E+03 /
        DATA ((PARTON(I,N,21),I=1,6),N=1,8)/
     +   .8959E-02,  .5534E-02,  .2260E-02,  .5501E+00,  .1981E+00,
     +   .2335E+01,
     +   .9216E-02,  .5688E-02,  .2306E-02,  .7235E+00,  .2841E+00,
     +   .3655E+01,
     +   .9497E-02,  .5856E-02,  .2357E-02,  .9455E+00,  .3944E+00,
     +   .5564E+01,
     +   .9819E-02,  .6049E-02,  .2414E-02,  .1243E+01,  .5424E+00,
     +   .8443E+01,
     +   .1021E-01,  .6280E-02,  .2482E-02,  .1607E+01,  .7234E+00,
     +   .1300E+02,
     +   .1056E-01,  .6490E-02,  .2542E-02,  .1989E+01,  .9136E+00,
     +   .1817E+02,
     +   .1095E-01,  .6725E-02,  .2608E-02,  .2489E+01,  .1163E+01,
     +   .2518E+02,
     +   .1130E-01,  .6934E-02,  .2666E-02,  .3002E+01,  .1419E+01,
     +   .3256E+02 /
        DATA ((PARTON(I,N,21),I=1,6),N=9,16)/
     +   .1165E-01,  .7143E-02,  .2723E-02,  .3577E+01,  .1705E+01,
     +   .4099E+02,
     +   .1197E-01,  .7333E-02,  .2773E-02,  .4144E+01,  .1988E+01,
     +   .4959E+02,
     +   .1230E-01,  .7527E-02,  .2825E-02,  .4765E+01,  .2298E+01,
     +   .5923E+02,
     +   .1262E-01,  .7714E-02,  .2873E-02,  .5419E+01,  .2624E+01,
     +   .6936E+02,
     +   .1290E-01,  .7884E-02,  .2917E-02,  .6067E+01,  .2947E+01,
     +   .7937E+02,
     +   .1327E-01,  .8101E-02,  .2971E-02,  .6955E+01,  .3391E+01,
     +   .9307E+02,
     +   .1361E-01,  .8304E-02,  .3022E-02,  .7861E+01,  .3843E+01,
     +   .1069E+03,
     +   .1395E-01,  .8501E-02,  .3070E-02,  .8800E+01,  .4312E+01,
     +   .1213E+03 /
        DATA ((PARTON(I,N,21),I=1,6),N=17,24)/
     +   .1426E-01,  .8686E-02,  .3115E-02,  .9741E+01,  .4782E+01,
     +   .1355E+03,
     +   .1458E-01,  .8873E-02,  .3160E-02,  .1075E+02,  .5286E+01,
     +   .1507E+03,
     +   .1488E-01,  .9050E-02,  .3202E-02,  .1176E+02,  .5790E+01,
     +   .1658E+03,
     +   .1517E-01,  .9223E-02,  .3242E-02,  .1279E+02,  .6306E+01,
     +   .1811E+03,
     +   .1545E-01,  .9386E-02,  .3280E-02,  .1381E+02,  .6816E+01,
     +   .1961E+03,
     +   .1583E-01,  .9608E-02,  .3331E-02,  .1527E+02,  .7544E+01,
     +   .2173E+03,
     +   .1617E-01,  .9810E-02,  .3376E-02,  .1665E+02,  .8233E+01,
     +   .2372E+03,
     +   .1653E-01,  .1002E-01,  .3422E-02,  .1813E+02,  .8971E+01,
     +   .2583E+03 /
        DATA ((PARTON(I,N,21),I=1,6),N=25,27)/
     +   .1688E-01,  .1022E-01,  .3467E-02,  .1965E+02,  .9733E+01,
     +   .2799E+03,
     +   .1720E-01,  .1041E-01,  .3508E-02,  .2110E+02,  .1046E+02,
     +   .3002E+03,
     +   .1753E-01,  .1060E-01,  .3550E-02,  .2264E+02,  .1123E+02,
     +   .3215E+03 /
        DATA ((PARTON(I,N,22),I=1,6),N=1,8)/
     +   .1070E-01,  .6600E-02,  .2615E-02,  .5374E+00,  .1857E+00,
     +   .2266E+01,
     +   .1101E-01,  .6783E-02,  .2668E-02,  .6960E+00,  .2643E+00,
     +   .3517E+01,
     +   .1134E-01,  .6982E-02,  .2725E-02,  .8973E+00,  .3642E+00,
     +   .5303E+01,
     +   .1173E-01,  .7210E-02,  .2790E-02,  .1165E+01,  .4971E+00,
     +   .7963E+01,
     +   .1219E-01,  .7484E-02,  .2865E-02,  .1492E+01,  .6600E+00,
     +   .1209E+02,
     +   .1261E-01,  .7734E-02,  .2932E-02,  .1834E+01,  .8299E+00,
     +   .1672E+02,
     +   .1308E-01,  .8012E-02,  .3006E-02,  .2278E+01,  .1051E+01,
     +   .2293E+02,
     +   .1350E-01,  .8260E-02,  .3070E-02,  .2729E+01,  .1276E+01,
     +   .2941E+02 /
        DATA ((PARTON(I,N,22),I=1,6),N=9,16)/
     +   .1391E-01,  .8507E-02,  .3133E-02,  .3231E+01,  .1526E+01,
     +   .3675E+02,
     +   .1429E-01,  .8732E-02,  .3189E-02,  .3724E+01,  .1772E+01,
     +   .4418E+02,
     +   .1468E-01,  .8963E-02,  .3246E-02,  .4263E+01,  .2040E+01,
     +   .5245E+02,
     +   .1506E-01,  .9184E-02,  .3299E-02,  .4826E+01,  .2321E+01,
     +   .6109E+02,
     +   .1540E-01,  .9386E-02,  .3347E-02,  .5382E+01,  .2599E+01,
     +   .6957E+02,
     +   .1583E-01,  .9643E-02,  .3407E-02,  .6141E+01,  .2978E+01,
     +   .8112E+02,
     +   .1624E-01,  .9883E-02,  .3463E-02,  .6911E+01,  .3362E+01,
     +   .9275E+02,
     +   .1664E-01,  .1012E-01,  .3515E-02,  .7706E+01,  .3758E+01,
     +   .1047E+03 /
        DATA ((PARTON(I,N,22),I=1,6),N=17,24)/
     +   .1701E-01,  .1033E-01,  .3565E-02,  .8499E+01,  .4155E+01,
     +   .1165E+03,
     +   .1739E-01,  .1056E-01,  .3613E-02,  .9347E+01,  .4578E+01,
     +   .1290E+03,
     +   .1775E-01,  .1077E-01,  .3659E-02,  .1019E+02,  .5000E+01,
     +   .1414E+03,
     +   .1810E-01,  .1097E-01,  .3703E-02,  .1105E+02,  .5429E+01,
     +   .1539E+03,
     +   .1843E-01,  .1116E-01,  .3745E-02,  .1190E+02,  .5854E+01,
     +   .1661E+03,
     +   .1888E-01,  .1143E-01,  .3800E-02,  .1311E+02,  .6456E+01,
     +   .1833E+03,
     +   .1929E-01,  .1166E-01,  .3849E-02,  .1425E+02,  .7025E+01,
     +   .1994E+03,
     +   .1971E-01,  .1191E-01,  .3900E-02,  .1546E+02,  .7632E+01,
     +   .2164E+03 /
        DATA ((PARTON(I,N,22),I=1,6),N=25,27)/
     +   .2013E-01,  .1215E-01,  .3949E-02,  .1671E+02,  .8257E+01,
     +   .2336E+03,
     +   .2051E-01,  .1237E-01,  .3993E-02,  .1790E+02,  .8849E+01,
     +   .2497E+03,
     +   .2090E-01,  .1260E-01,  .4038E-02,  .1916E+02,  .9477E+01,
     +   .2667E+03 /
        DATA ((PARTON(I,N,23),I=1,6),N=1,8)/
     +   .1279E-01,  .7874E-02,  .3015E-02,  .5262E+00,  .1737E+00,
     +   .2195E+01,
     +   .1315E-01,  .8089E-02,  .3074E-02,  .6709E+00,  .2453E+00,
     +   .3376E+01,
     +   .1355E-01,  .8325E-02,  .3138E-02,  .8530E+00,  .3356E+00,
     +   .5043E+01,
     +   .1401E-01,  .8596E-02,  .3211E-02,  .1093E+01,  .4546E+00,
     +   .7492E+01,
     +   .1456E-01,  .8920E-02,  .3294E-02,  .1387E+01,  .6007E+00,
     +   .1122E+02,
     +   .1506E-01,  .9216E-02,  .3368E-02,  .1691E+01,  .7520E+00,
     +   .1535E+02,
     +   .1562E-01,  .9546E-02,  .3450E-02,  .2083E+01,  .9470E+00,
     +   .2084E+02,
     +   .1611E-01,  .9840E-02,  .3521E-02,  .2479E+01,  .1144E+01,
     +   .2650E+02 /
        DATA ((PARTON(I,N,23),I=1,6),N=9,16)/
     +   .1661E-01,  .1013E-01,  .3590E-02,  .2916E+01,  .1362E+01,
     +   .3287E+02,
     +   .1706E-01,  .1040E-01,  .3651E-02,  .3344E+01,  .1575E+01,
     +   .3926E+02,
     +   .1753E-01,  .1067E-01,  .3713E-02,  .3809E+01,  .1806E+01,
     +   .4632E+02,
     +   .1797E-01,  .1093E-01,  .3771E-02,  .4293E+01,  .2048E+01,
     +   .5365E+02,
     +   .1838E-01,  .1117E-01,  .3824E-02,  .4768E+01,  .2285E+01,
     +   .6081E+02,
     +   .1890E-01,  .1148E-01,  .3889E-02,  .5414E+01,  .2607E+01,
     +   .7049E+02,
     +   .1939E-01,  .1176E-01,  .3949E-02,  .6065E+01,  .2932E+01,
     +   .8018E+02,
     +   .1986E-01,  .1204E-01,  .4007E-02,  .6735E+01,  .3266E+01,
     +   .9006E+02 /
        DATA ((PARTON(I,N,23),I=1,6),N=17,24)/
     +   .2030E-01,  .1230E-01,  .4060E-02,  .7401E+01,  .3599E+01,
     +   .9980E+02,
     +   .2075E-01,  .1256E-01,  .4113E-02,  .8110E+01,  .3953E+01,
     +   .1101E+03,
     +   .2117E-01,  .1280E-01,  .4163E-02,  .8814E+01,  .4304E+01,
     +   .1202E+03,
     +   .2159E-01,  .1305E-01,  .4210E-02,  .9529E+01,  .4661E+01,
     +   .1303E+03,
     +   .2198E-01,  .1327E-01,  .4255E-02,  .1023E+02,  .5012E+01,
     +   .1402E+03,
     +   .2251E-01,  .1358E-01,  .4315E-02,  .1123E+02,  .5509E+01,
     +   .1541E+03,
     +   .2300E-01,  .1387E-01,  .4368E-02,  .1216E+02,  .5976E+01,
     +   .1669E+03,
     +   .2350E-01,  .1415E-01,  .4422E-02,  .1316E+02,  .6473E+01,
     +   .1805E+03 /
        DATA ((PARTON(I,N,23),I=1,6),N=25,27)/
     +   .2400E-01,  .1444E-01,  .4475E-02,  .1418E+02,  .6982E+01,
     +   .1942E+03,
     +   .2445E-01,  .1470E-01,  .4523E-02,  .1514E+02,  .7463E+01,
     +   .2070E+03,
     +   .2491E-01,  .1497E-01,  .4571E-02,  .1616E+02,  .7972E+01,
     +   .2203E+03 /
        DATA ((PARTON(I,N,24),I=1,6),N=1,8)/
     +   .1524E-01,  .9365E-02,  .3453E-02,  .5167E+00,  .1622E+00,
     +   .2123E+01,
     +   .1568E-01,  .9619E-02,  .3519E-02,  .6486E+00,  .2275E+00,
     +   .3237E+01,
     +   .1615E-01,  .9897E-02,  .3589E-02,  .8131E+00,  .3089E+00,
     +   .4789E+01,
     +   .1669E-01,  .1022E-01,  .3669E-02,  .1028E+01,  .4155E+00,
     +   .7040E+01,
     +   .1734E-01,  .1060E-01,  .3761E-02,  .1292E+01,  .5463E+00,
     +   .1040E+02,
     +   .1793E-01,  .1095E-01,  .3842E-02,  .1563E+01,  .6809E+00,
     +   .1409E+02,
     +   .1859E-01,  .1134E-01,  .3931E-02,  .1908E+01,  .8527E+00,
     +   .1892E+02,
     +   .1918E-01,  .1168E-01,  .4008E-02,  .2255E+01,  .1025E+01,
     +   .2387E+02 /
        DATA ((PARTON(I,N,24),I=1,6),N=9,16)/
     +   .1977E-01,  .1203E-01,  .4083E-02,  .2635E+01,  .1214E+01,
     +   .2938E+02,
     +   .2031E-01,  .1234E-01,  .4150E-02,  .3005E+01,  .1399E+01,
     +   .3486E+02,
     +   .2086E-01,  .1266E-01,  .4216E-02,  .3406E+01,  .1598E+01,
     +   .4088E+02,
     +   .2139E-01,  .1297E-01,  .4279E-02,  .3822E+01,  .1805E+01,
     +   .4709E+02,
     +   .2187E-01,  .1326E-01,  .4336E-02,  .4227E+01,  .2008E+01,
     +   .5311E+02,
     +   .2248E-01,  .1361E-01,  .4406E-02,  .4776E+01,  .2281E+01,
     +   .6121E+02,
     +   .2306E-01,  .1395E-01,  .4471E-02,  .5327E+01,  .2556E+01,
     +   .6927E+02,
     +   .2362E-01,  .1427E-01,  .4533E-02,  .5891E+01,  .2837E+01,
     +   .7744E+02 /
        DATA ((PARTON(I,N,24),I=1,6),N=17,24)/
     +   .2414E-01,  .1458E-01,  .4590E-02,  .6450E+01,  .3116E+01,
     +   .8545E+02,
     +   .2468E-01,  .1489E-01,  .4647E-02,  .7041E+01,  .3411E+01,
     +   .9384E+02,
     +   .2518E-01,  .1518E-01,  .4700E-02,  .7627E+01,  .3703E+01,
     +   .1021E+03,
     +   .2567E-01,  .1546E-01,  .4751E-02,  .8220E+01,  .3999E+01,
     +   .1103E+03,
     +   .2613E-01,  .1573E-01,  .4799E-02,  .8801E+01,  .4289E+01,
     +   .1183E+03,
     +   .2677E-01,  .1609E-01,  .4863E-02,  .9620E+01,  .4698E+01,
     +   .1294E+03,
     +   .2734E-01,  .1642E-01,  .4920E-02,  .1039E+02,  .5081E+01,
     +   .1397E+03,
     +   .2793E-01,  .1676E-01,  .4978E-02,  .1120E+02,  .5487E+01,
     +   .1505E+03 /
        DATA ((PARTON(I,N,24),I=1,6),N=25,27)/
     +   .2852E-01,  .1710E-01,  .5034E-02,  .1203E+02,  .5903E+01,
     +   .1614E+03,
     +   .2905E-01,  .1740E-01,  .5085E-02,  .1281E+02,  .6293E+01,
     +   .1714E+03,
     +   .2960E-01,  .1772E-01,  .5137E-02,  .1364E+02,  .6705E+01,
     +   .1819E+03 /
        DATA ((PARTON(I,N,25),I=1,6),N=1,8)/
     +   .1820E-01,  .1115E-01,  .3938E-02,  .5085E+00,  .1511E+00,
     +   .2049E+01,
     +   .1871E-01,  .1145E-01,  .4011E-02,  .6284E+00,  .2103E+00,
     +   .3097E+01,
     +   .1927E-01,  .1178E-01,  .4088E-02,  .7764E+00,  .2835E+00,
     +   .4536E+01,
     +   .1991E-01,  .1216E-01,  .4176E-02,  .9683E+00,  .3785E+00,
     +   .6596E+01,
     +   .2068E-01,  .1261E-01,  .4275E-02,  .1204E+01,  .4952E+00,
     +   .9616E+01,
     +   .2138E-01,  .1302E-01,  .4363E-02,  .1444E+01,  .6143E+00,
     +   .1288E+02,
     +   .2217E-01,  .1348E-01,  .4459E-02,  .1748E+01,  .7651E+00,
     +   .1713E+02,
     +   .2287E-01,  .1389E-01,  .4542E-02,  .2049E+01,  .9151E+00,
     +   .2142E+02 /
        DATA ((PARTON(I,N,25),I=1,6),N=9,16)/
     +   .2356E-01,  .1429E-01,  .4623E-02,  .2379E+01,  .1079E+01,
     +   .2616E+02,
     +   .2420E-01,  .1466E-01,  .4694E-02,  .2698E+01,  .1238E+01,
     +   .3085E+02,
     +   .2485E-01,  .1504E-01,  .4766E-02,  .3042E+01,  .1409E+01,
     +   .3594E+02,
     +   .2548E-01,  .1541E-01,  .4833E-02,  .3396E+01,  .1585E+01,
     +   .4116E+02,
     +   .2606E-01,  .1574E-01,  .4893E-02,  .3740E+01,  .1757E+01,
     +   .4621E+02,
     +   .2678E-01,  .1616E-01,  .4968E-02,  .4204E+01,  .1988E+01,
     +   .5294E+02,
     +   .2747E-01,  .1656E-01,  .5038E-02,  .4668E+01,  .2219E+01,
     +   .5959E+02,
     +   .2813E-01,  .1694E-01,  .5103E-02,  .5140E+01,  .2454E+01,
     +   .6629E+02 /
        DATA ((PARTON(I,N,25),I=1,6),N=17,24)/
     +   .2875E-01,  .1730E-01,  .5164E-02,  .5605E+01,  .2686E+01,
     +   .7282E+02,
     +   .2938E-01,  .1766E-01,  .5225E-02,  .6097E+01,  .2931E+01,
     +   .7963E+02,
     +   .2998E-01,  .1800E-01,  .5281E-02,  .6581E+01,  .3173E+01,
     +   .8627E+02,
     +   .3056E-01,  .1834E-01,  .5335E-02,  .7069E+01,  .3417E+01,
     +   .9289E+02,
     +   .3111E-01,  .1865E-01,  .5386E-02,  .7546E+01,  .3655E+01,
     +   .9927E+02,
     +   .3185E-01,  .1908E-01,  .5454E-02,  .8216E+01,  .3989E+01,
     +   .1081E+03,
     +   .3253E-01,  .1947E-01,  .5514E-02,  .8841E+01,  .4301E+01,
     +   .1163E+03,
     +   .3323E-01,  .1987E-01,  .5576E-02,  .9502E+01,  .4631E+01,
     +   .1248E+03 /
        DATA ((PARTON(I,N,25),I=1,6),N=25,27)/
     +   .3392E-01,  .2026E-01,  .5636E-02,  .1017E+02,  .4966E+01,
     +   .1333E+03,
     +   .3455E-01,  .2062E-01,  .5689E-02,  .1080E+02,  .5281E+01,
     +   .1412E+03,
     +   .3520E-01,  .2098E-01,  .5744E-02,  .1147E+02,  .5611E+01,
     +   .1493E+03 /
        DATA ((PARTON(I,N,26),I=1,6),N=1,8)/
     +   .2112E-01,  .1292E-01,  .4380E-02,  .5027E+00,  .1420E+00,
     +   .1986E+01,
     +   .2171E-01,  .1326E-01,  .4458E-02,  .6130E+00,  .1964E+00,
     +   .2978E+01,
     +   .2235E-01,  .1364E-01,  .4542E-02,  .7482E+00,  .2632E+00,
     +   .4326E+01,
     +   .2310E-01,  .1407E-01,  .4635E-02,  .9221E+00,  .3492E+00,
     +   .6233E+01,
     +   .2398E-01,  .1459E-01,  .4741E-02,  .1136E+01,  .4548E+00,
     +   .8984E+01,
     +   .2479E-01,  .1506E-01,  .4834E-02,  .1352E+01,  .5620E+00,
     +   .1193E+02,
     +   .2570E-01,  .1559E-01,  .4935E-02,  .1623E+01,  .6966E+00,
     +   .1572E+02,
     +   .2651E-01,  .1606E-01,  .5023E-02,  .1891E+01,  .8297E+00,
     +   .1952E+02 /
        DATA ((PARTON(I,N,26),I=1,6),N=9,16)/
     +   .2731E-01,  .1652E-01,  .5107E-02,  .2182E+01,  .9742E+00,
     +   .2368E+02,
     +   .2805E-01,  .1695E-01,  .5183E-02,  .2463E+01,  .1114E+01,
     +   .2776E+02,
     +   .2880E-01,  .1738E-01,  .5257E-02,  .2764E+01,  .1264E+01,
     +   .3218E+02,
     +   .2953E-01,  .1780E-01,  .5328E-02,  .3073E+01,  .1417E+01,
     +   .3667E+02,
     +   .3019E-01,  .1818E-01,  .5391E-02,  .3372E+01,  .1566E+01,
     +   .4099E+02,
     +   .3103E-01,  .1867E-01,  .5470E-02,  .3773E+01,  .1766E+01,
     +   .4672E+02,
     +   .3182E-01,  .1912E-01,  .5542E-02,  .4172E+01,  .1965E+01,
     +   .5235E+02,
     +   .3258E-01,  .1956E-01,  .5611E-02,  .4577E+01,  .2167E+01,
     +   .5800E+02 /
        DATA ((PARTON(I,N,26),I=1,6),N=17,24)/
     +   .3330E-01,  .1997E-01,  .5675E-02,  .4975E+01,  .2365E+01,
     +   .6347E+02,
     +   .3402E-01,  .2038E-01,  .5738E-02,  .5393E+01,  .2574E+01,
     +   .6915E+02,
     +   .3471E-01,  .2077E-01,  .5797E-02,  .5804E+01,  .2779E+01,
     +   .7467E+02,
     +   .3538E-01,  .2116E-01,  .5854E-02,  .6217E+01,  .2985E+01,
     +   .8014E+02,
     +   .3601E-01,  .2152E-01,  .5907E-02,  .6620E+01,  .3185E+01,
     +   .8540E+02,
     +   .3687E-01,  .2201E-01,  .5977E-02,  .7183E+01,  .3466E+01,
     +   .9266E+02,
     +   .3765E-01,  .2245E-01,  .6041E-02,  .7707E+01,  .3728E+01,
     +   .9932E+02,
     +   .3845E-01,  .2290E-01,  .6105E-02,  .8259E+01,  .4003E+01,
     +   .1062E+03 /
        DATA ((PARTON(I,N,26),I=1,6),N=25,27)/
     +   .3925E-01,  .2335E-01,  .6168E-02,  .8819E+01,  .4282E+01,
     +   .1131E+03,
     +   .3997E-01,  .2376E-01,  .6224E-02,  .9341E+01,  .4543E+01,
     +   .1195E+03,
     +   .4071E-01,  .2418E-01,  .6281E-02,  .9889E+01,  .4817E+01,
     +   .1260E+03 /
        DATA ((PARTON(I,N,27),I=1,6),N=1,8)/
     +   .2476E-01,  .1510E-01,  .4880E-02,  .4975E+00,  .1327E+00,
     +   .1919E+01,
     +   .2544E-01,  .1549E-01,  .4964E-02,  .5981E+00,  .1822E+00,
     +   .2852E+01,
     +   .2618E-01,  .1593E-01,  .5052E-02,  .7206E+00,  .2426E+00,
     +   .4106E+01,
     +   .2704E-01,  .1643E-01,  .5151E-02,  .8769E+00,  .3198E+00,
     +   .5857E+01,
     +   .2807E-01,  .1703E-01,  .5263E-02,  .1069E+01,  .4145E+00,
     +   .8342E+01,
     +   .2902E-01,  .1757E-01,  .5361E-02,  .1261E+01,  .5100E+00,
     +   .1097E+02,
     +   .3007E-01,  .1818E-01,  .5467E-02,  .1502E+01,  .6290E+00,
     +   .1432E+02,
     +   .3101E-01,  .1872E-01,  .5559E-02,  .1737E+01,  .7459E+00,
     +   .1764E+02 /
        DATA ((PARTON(I,N,27),I=1,6),N=9,16)/
     +   .3195E-01,  .1927E-01,  .5648E-02,  .1991E+01,  .8720E+00,
     +   .2125E+02,
     +   .3280E-01,  .1976E-01,  .5726E-02,  .2235E+01,  .9932E+00,
     +   .2477E+02,
     +   .3368E-01,  .2026E-01,  .5804E-02,  .2496E+01,  .1123E+01,
     +   .2854E+02,
     +   .3452E-01,  .2074E-01,  .5878E-02,  .2762E+01,  .1255E+01,
     +   .3235E+02,
     +   .3529E-01,  .2118E-01,  .5944E-02,  .3019E+01,  .1383E+01,
     +   .3600E+02,
     +   .3627E-01,  .2174E-01,  .6026E-02,  .3361E+01,  .1553E+01,
     +   .4081E+02,
     +   .3718E-01,  .2227E-01,  .6101E-02,  .3700E+01,  .1722E+01,
     +   .4550E+02,
     +   .3807E-01,  .2277E-01,  .6173E-02,  .4043E+01,  .1893E+01,
     +   .5018E+02 /
        DATA ((PARTON(I,N,27),I=1,6),N=17,24)/
     +   .3890E-01,  .2324E-01,  .6239E-02,  .4378E+01,  .2060E+01,
     +   .5469E+02,
     +   .3974E-01,  .2372E-01,  .6305E-02,  .4729E+01,  .2235E+01,
     +   .5935E+02,
     +   .4054E-01,  .2417E-01,  .6367E-02,  .5073E+01,  .2406E+01,
     +   .6385E+02,
     +   .4132E-01,  .2461E-01,  .6426E-02,  .5417E+01,  .2578E+01,
     +   .6829E+02,
     +   .4205E-01,  .2503E-01,  .6481E-02,  .5752E+01,  .2745E+01,
     +   .7255E+02,
     +   .4305E-01,  .2559E-01,  .6555E-02,  .6218E+01,  .2977E+01,
     +   .7839E+02,
     +   .4395E-01,  .2610E-01,  .6622E-02,  .6651E+01,  .3193E+01,
     +   .8373E+02,
     +   .4488E-01,  .2662E-01,  .6689E-02,  .7104E+01,  .3419E+01,
     +   .8923E+02 /
        DATA ((PARTON(I,N,27),I=1,6),N=25,27)/
     +   .4580E-01,  .2714E-01,  .6754E-02,  .7562E+01,  .3648E+01,
     +   .9470E+02,
     +   .4663E-01,  .2760E-01,  .6813E-02,  .7989E+01,  .3861E+01,
     +   .9970E+02,
     +   .4749E-01,  .2808E-01,  .6873E-02,  .8435E+01,  .4083E+01,
     +   .1048E+03 /
        DATA ((PARTON(I,N,28),I=1,6),N=1,8)/
     +   .2967E-01,  .1803E-01,  .5483E-02,  .4926E+00,  .1224E+00,
     +   .1840E+01,
     +   .3047E-01,  .1850E-01,  .5572E-02,  .5830E+00,  .1668E+00,
     +   .2709E+01,
     +   .3135E-01,  .1901E-01,  .5665E-02,  .6920E+00,  .2204E+00,
     +   .3859E+01,
     +   .3237E-01,  .1959E-01,  .5769E-02,  .8298E+00,  .2884E+00,
     +   .5442E+01,
     +   .3359E-01,  .2030E-01,  .5886E-02,  .9987E+00,  .3717E+00,
     +   .7646E+01,
     +   .3471E-01,  .2094E-01,  .5989E-02,  .1167E+01,  .4550E+00,
     +   .9945E+01,
     +   .3596E-01,  .2166E-01,  .6099E-02,  .1375E+01,  .5580E+00,
     +   .1284E+02,
     +   .3708E-01,  .2230E-01,  .6195E-02,  .1577E+01,  .6582E+00,
     +   .1568E+02 /
        DATA ((PARTON(I,N,28),I=1,6),N=9,16)/
     +   .3819E-01,  .2294E-01,  .6287E-02,  .1794E+01,  .7657E+00,
     +   .1873E+02,
     +   .3921E-01,  .2352E-01,  .6368E-02,  .2001E+01,  .8685E+00,
     +   .2168E+02,
     +   .4025E-01,  .2411E-01,  .6450E-02,  .2221E+01,  .9778E+00,
     +   .2481E+02,
     +   .4124E-01,  .2468E-01,  .6526E-02,  .2445E+01,  .1089E+01,
     +   .2796E+02,
     +   .4216E-01,  .2520E-01,  .6595E-02,  .2659E+01,  .1196E+01,
     +   .3094E+02,
     +   .4331E-01,  .2585E-01,  .6680E-02,  .2944E+01,  .1337E+01,
     +   .3485E+02,
     +   .4440E-01,  .2647E-01,  .6759E-02,  .3224E+01,  .1477E+01,
     +   .3863E+02,
     +   .4545E-01,  .2706E-01,  .6834E-02,  .3505E+01,  .1617E+01,
     +   .4238E+02 /
        DATA ((PARTON(I,N,28),I=1,6),N=17,24)/
     +   .4644E-01,  .2762E-01,  .6903E-02,  .3780E+01,  .1753E+01,
     +   .4597E+02,
     +   .4743E-01,  .2818E-01,  .6972E-02,  .4066E+01,  .1896E+01,
     +   .4966E+02,
     +   .4838E-01,  .2871E-01,  .7037E-02,  .4345E+01,  .2035E+01,
     +   .5319E+02,
     +   .4929E-01,  .2922E-01,  .7099E-02,  .4623E+01,  .2173E+01,
     +   .5667E+02,
     +   .5016E-01,  .2971E-01,  .7157E-02,  .4892E+01,  .2307E+01,
     +   .5998E+02,
     +   .5133E-01,  .3037E-01,  .7234E-02,  .5266E+01,  .2494E+01,
     +   .6450E+02,
     +   .5240E-01,  .3096E-01,  .7304E-02,  .5611E+01,  .2666E+01,
     +   .6860E+02,
     +   .5349E-01,  .3157E-01,  .7375E-02,  .5971E+01,  .2845E+01,
     +   .7281E+02 /
        DATA ((PARTON(I,N,28),I=1,6),N=25,27)/
     +   .5457E-01,  .3217E-01,  .7444E-02,  .6333E+01,  .3026E+01,
     +   .7697E+02,
     +   .5555E-01,  .3271E-01,  .7506E-02,  .6669E+01,  .3194E+01,
     +   .8074E+02,
     +   .5656E-01,  .3327E-01,  .7569E-02,  .7019E+01,  .3368E+01,
     +   .8461E+02 /
        DATA ((PARTON(I,N,29),I=1,6),N=1,8)/
     +   .3558E-01,  .2155E-01,  .6113E-02,  .4888E+00,  .1124E+00,
     +   .1761E+01,
     +   .3652E-01,  .2209E-01,  .6205E-02,  .5695E+00,  .1520E+00,
     +   .2567E+01,
     +   .3756E-01,  .2268E-01,  .6302E-02,  .6660E+00,  .1994E+00,
     +   .3617E+01,
     +   .3877E-01,  .2338E-01,  .6409E-02,  .7869E+00,  .2589E+00,
     +   .5041E+01,
     +   .4021E-01,  .2420E-01,  .6529E-02,  .9348E+00,  .3319E+00,
     +   .6986E+01,
     +   .4154E-01,  .2496E-01,  .6634E-02,  .1081E+01,  .4041E+00,
     +   .8986E+01,
     +   .4302E-01,  .2580E-01,  .6748E-02,  .1260E+01,  .4927E+00,
     +   .1147E+02,
     +   .4435E-01,  .2656E-01,  .6846E-02,  .1433E+01,  .5782E+00,
     +   .1388E+02 /
        DATA ((PARTON(I,N,29),I=1,6),N=9,16)/
     +   .4567E-01,  .2731E-01,  .6941E-02,  .1617E+01,  .6693E+00,
     +   .1645E+02,
     +   .4687E-01,  .2799E-01,  .7026E-02,  .1791E+01,  .7559E+00,
     +   .1889E+02,
     +   .4810E-01,  .2869E-01,  .7110E-02,  .1976E+01,  .8476E+00,
     +   .2148E+02,
     +   .4929E-01,  .2936E-01,  .7189E-02,  .2162E+01,  .9402E+00,
     +   .2405E+02,
     +   .5037E-01,  .2997E-01,  .7260E-02,  .2340E+01,  .1029E+01,
     +   .2647E+02,
     +   .5174E-01,  .3074E-01,  .7349E-02,  .2575E+01,  .1145E+01,
     +   .2962E+02,
     +   .5303E-01,  .3146E-01,  .7431E-02,  .2805E+01,  .1260E+01,
     +   .3264E+02,
     +   .5427E-01,  .3215E-01,  .7509E-02,  .3035E+01,  .1374E+01,
     +   .3562E+02 /
        DATA ((PARTON(I,N,29),I=1,6),N=17,24)/
     +   .5543E-01,  .3280E-01,  .7581E-02,  .3258E+01,  .1485E+01,
     +   .3844E+02,
     +   .5661E-01,  .3346E-01,  .7654E-02,  .3489E+01,  .1600E+01,
     +   .4133E+02,
     +   .5772E-01,  .3408E-01,  .7722E-02,  .3713E+01,  .1712E+01,
     +   .4408E+02,
     +   .5880E-01,  .3468E-01,  .7787E-02,  .3936E+01,  .1823E+01,
     +   .4677E+02,
     +   .5982E-01,  .3525E-01,  .7848E-02,  .4151E+01,  .1930E+01,
     +   .4931E+02,
     +   .6121E-01,  .3601E-01,  .7930E-02,  .4448E+01,  .2078E+01,
     +   .5277E+02,
     +   .6246E-01,  .3670E-01,  .8004E-02,  .4721E+01,  .2214E+01,
     +   .5588E+02,
     +   .6374E-01,  .3741E-01,  .8079E-02,  .5005E+01,  .2355E+01,
     +   .5906E+02 /
        DATA ((PARTON(I,N,29),I=1,6),N=25,27)/
     +   .6501E-01,  .3811E-01,  .8153E-02,  .5289E+01,  .2497E+01,
     +   .6217E+02,
     +   .6616E-01,  .3874E-01,  .8219E-02,  .5551E+01,  .2628E+01,
     +   .6499E+02,
     +   .6734E-01,  .3939E-01,  .8286E-02,  .5824E+01,  .2764E+01,
     +   .6785E+02 /
        DATA ((PARTON(I,N,30),I=1,6),N=1,8)/
     +   .4255E-01,  .2566E-01,  .6745E-02,  .4856E+00,  .1030E+00,
     +   .1683E+01,
     +   .4366E-01,  .2629E-01,  .6838E-02,  .5575E+00,  .1381E+00,
     +   .2427E+01,
     +   .4488E-01,  .2699E-01,  .6936E-02,  .6426E+00,  .1799E+00,
     +   .3383E+01,
     +   .4630E-01,  .2780E-01,  .7044E-02,  .7484E+00,  .2319E+00,
     +   .4660E+01,
     +   .4800E-01,  .2877E-01,  .7166E-02,  .8775E+00,  .2955E+00,
     +   .6372E+01,
     +   .4957E-01,  .2965E-01,  .7272E-02,  .1004E+01,  .3580E+00,
     +   .8106E+01,
     +   .5132E-01,  .3065E-01,  .7388E-02,  .1158E+01,  .4339E+00,
     +   .1023E+02,
     +   .5289E-01,  .3153E-01,  .7488E-02,  .1305E+01,  .5066E+00,
     +   .1227E+02 /
        DATA ((PARTON(I,N,30),I=1,6),N=9,16)/
     +   .5445E-01,  .3241E-01,  .7585E-02,  .1460E+01,  .5835E+00,
     +   .1441E+02,
     +   .5587E-01,  .3321E-01,  .7672E-02,  .1607E+01,  .6563E+00,
     +   .1644E+02,
     +   .5733E-01,  .3403E-01,  .7759E-02,  .1761E+01,  .7329E+00,
     +   .1856E+02,
     +   .5873E-01,  .3481E-01,  .7842E-02,  .1916E+01,  .8098E+00,
     +   .2065E+02,
     +   .6000E-01,  .3552E-01,  .7916E-02,  .2063E+01,  .8828E+00,
     +   .2261E+02,
     +   .6162E-01,  .3642E-01,  .8009E-02,  .2256E+01,  .9788E+00,
     +   .2513E+02,
     +   .6313E-01,  .3726E-01,  .8095E-02,  .2444E+01,  .1072E+01,
     +   .2753E+02,
     +   .6459E-01,  .3807E-01,  .8178E-02,  .2631E+01,  .1165E+01,
     +   .2987E+02 /
        DATA ((PARTON(I,N,30),I=1,6),N=17,24)/
     +   .6596E-01,  .3883E-01,  .8254E-02,  .2811E+01,  .1255E+01,
     +   .3208E+02,
     +   .6734E-01,  .3959E-01,  .8331E-02,  .2997E+01,  .1347E+01,
     +   .3433E+02,
     +   .6865E-01,  .4031E-01,  .8403E-02,  .3177E+01,  .1437E+01,
     +   .3645E+02,
     +   .6992E-01,  .4100E-01,  .8473E-02,  .3355E+01,  .1526E+01,
     +   .3851E+02,
     +   .7111E-01,  .4166E-01,  .8539E-02,  .3525E+01,  .1611E+01,
     +   .4045E+02,
     +   .7273E-01,  .4255E-01,  .8627E-02,  .3760E+01,  .1728E+01,
     +   .4307E+02,
     +   .7420E-01,  .4335E-01,  .8706E-02,  .3975E+01,  .1835E+01,
     +   .4541E+02,
     +   .7570E-01,  .4416E-01,  .8787E-02,  .4197E+01,  .1946E+01,
     +   .4779E+02 /
        DATA ((PARTON(I,N,30),I=1,6),N=25,27)/
     +   .7717E-01,  .4497E-01,  .8867E-02,  .4419E+01,  .2056E+01,
     +   .5010E+02,
     +   .7851E-01,  .4569E-01,  .8939E-02,  .4623E+01,  .2158E+01,
     +   .5218E+02,
     +   .7988E-01,  .4643E-01,  .9012E-02,  .4833E+01,  .2263E+01,
     +   .5428E+02 /
        DATA ((PARTON(I,N,31),I=1,6),N=1,8)/
     +   .5098E-01,  .3060E-01,  .7379E-02,  .4829E+00,  .9377E-01,
     +   .1603E+01,
     +   .5228E-01,  .3134E-01,  .7470E-02,  .5464E+00,  .1248E+00,
     +   .2288E+01,
     +   .5371E-01,  .3215E-01,  .7566E-02,  .6209E+00,  .1614E+00,
     +   .3154E+01,
     +   .5539E-01,  .3310E-01,  .7673E-02,  .7127E+00,  .2065E+00,
     +   .4292E+01,
     +   .5740E-01,  .3423E-01,  .7794E-02,  .8244E+00,  .2615E+00,
     +   .5787E+01,
     +   .5925E-01,  .3527E-01,  .7902E-02,  .9331E+00,  .3151E+00,
     +   .7279E+01,
     +   .6132E-01,  .3643E-01,  .8019E-02,  .1064E+01,  .3797E+00,
     +   .9082E+01,
     +   .6317E-01,  .3747E-01,  .8122E-02,  .1188E+01,  .4410E+00,
     +   .1079E+02 /
        DATA ((PARTON(I,N,31),I=1,6),N=9,16)/
     +   .6502E-01,  .3850E-01,  .8223E-02,  .1318E+01,  .5055E+00,
     +   .1257E+02,
     +   .6671E-01,  .3944E-01,  .8314E-02,  .1440E+01,  .5660E+00,
     +   .1423E+02,
     +   .6842E-01,  .4039E-01,  .8405E-02,  .1568E+01,  .6295E+00,
     +   .1594E+02,
     +   .7007E-01,  .4130E-01,  .8492E-02,  .1695E+01,  .6928E+00,
     +   .1763E+02,
     +   .7157E-01,  .4213E-01,  .8572E-02,  .1816E+01,  .7526E+00,
     +   .1919E+02,
     +   .7348E-01,  .4318E-01,  .8671E-02,  .1973E+01,  .8307E+00,
     +   .2118E+02,
     +   .7526E-01,  .4416E-01,  .8764E-02,  .2125E+01,  .9063E+00,
     +   .2306E+02,
     +   .7697E-01,  .4510E-01,  .8853E-02,  .2275E+01,  .9811E+00,
     +   .2488E+02 /
        DATA ((PARTON(I,N,31),I=1,6),N=17,24)/
     +   .7858E-01,  .4598E-01,  .8937E-02,  .2419E+01,  .1053E+01,
     +   .2659E+02,
     +   .8020E-01,  .4686E-01,  .9021E-02,  .2567E+01,  .1127E+01,
     +   .2830E+02,
     +   .8173E-01,  .4770E-01,  .9100E-02,  .2710E+01,  .1198E+01,
     +   .2992E+02,
     +   .8321E-01,  .4850E-01,  .9177E-02,  .2850E+01,  .1268E+01,
     +   .3147E+02,
     +   .8461E-01,  .4926E-01,  .9249E-02,  .2984E+01,  .1334E+01,
     +   .3293E+02,
     +   .8650E-01,  .5028E-01,  .9347E-02,  .3168E+01,  .1426E+01,
     +   .3488E+02,
     +   .8821E-01,  .5120E-01,  .9435E-02,  .3335E+01,  .1509E+01,
     +   .3661E+02,
     +   .8995E-01,  .5214E-01,  .9525E-02,  .3507E+01,  .1595E+01,
     +   .3835E+02 /
        DATA ((PARTON(I,N,31),I=1,6),N=25,27)/
     +   .9166E-01,  .5306E-01,  .9614E-02,  .3677E+01,  .1680E+01,
     +   .4003E+02,
     +   .9321E-01,  .5389E-01,  .9694E-02,  .3833E+01,  .1758E+01,
     +   .4153E+02,
     +   .9479E-01,  .5474E-01,  .9776E-02,  .3994E+01,  .1838E+01,
     +   .4304E+02 /
        DATA ((PARTON(I,N,32),I=1,6),N=1,8)/
     +   .5938E-01,  .3549E-01,  .7897E-02,  .4805E+00,  .8631E-01,
     +   .1535E+01,
     +   .6086E-01,  .3632E-01,  .7984E-02,  .5374E+00,  .1141E+00,
     +   .2172E+01,
     +   .6250E-01,  .3725E-01,  .8077E-02,  .6036E+00,  .1466E+00,
     +   .2965E+01,
     +   .6442E-01,  .3833E-01,  .8181E-02,  .6847E+00,  .1864E+00,
     +   .3993E+01,
     +   .6674E-01,  .3962E-01,  .8303E-02,  .7829E+00,  .2348E+00,
     +   .5321E+01,
     +   .6886E-01,  .4081E-01,  .8412E-02,  .8779E+00,  .2817E+00,
     +   .6628E+01,
     +   .7125E-01,  .4214E-01,  .8533E-02,  .9913E+00,  .3377E+00,
     +   .8189E+01,
     +   .7338E-01,  .4332E-01,  .8640E-02,  .1098E+01,  .3906E+00,
     +   .9650E+01 /
        DATA ((PARTON(I,N,32),I=1,6),N=9,16)/
     +   .7550E-01,  .4450E-01,  .8746E-02,  .1209E+01,  .4458E+00,
     +   .1115E+02,
     +   .7744E-01,  .4556E-01,  .8843E-02,  .1313E+01,  .4974E+00,
     +   .1255E+02,
     +   .7941E-01,  .4665E-01,  .8941E-02,  .1422E+01,  .5512E+00,
     +   .1398E+02,
     +   .8130E-01,  .4768E-01,  .9035E-02,  .1529E+01,  .6046E+00,
     +   .1536E+02,
     +   .8303E-01,  .4863E-01,  .9121E-02,  .1630E+01,  .6548E+00,
     +   .1664E+02,
     +   .8520E-01,  .4981E-01,  .9230E-02,  .1761E+01,  .7200E+00,
     +   .1826E+02,
     +   .8724E-01,  .5092E-01,  .9332E-02,  .1887E+01,  .7828E+00,
     +   .1978E+02,
     +   .8920E-01,  .5199E-01,  .9430E-02,  .2011E+01,  .8447E+00,
     +   .2123E+02 /
        DATA ((PARTON(I,N,32),I=1,6),N=17,24)/
     +   .9104E-01,  .5298E-01,  .9523E-02,  .2130E+01,  .9037E+00,
     +   .2259E+02,
     +   .9288E-01,  .5397E-01,  .9616E-02,  .2251E+01,  .9642E+00,
     +   .2394E+02,
     +   .9462E-01,  .5491E-01,  .9704E-02,  .2367E+01,  .1022E+01,
     +   .2521E+02,
     +   .9631E-01,  .5582E-01,  .9790E-02,  .2481E+01,  .1079E+01,
     +   .2642E+02,
     +   .9790E-01,  .5667E-01,  .9871E-02,  .2589E+01,  .1133E+01,
     +   .2755E+02,
     +   .1000E+00,  .5781E-01,  .9981E-02,  .2737E+01,  .1207E+01,
     +   .2905E+02,
     +   .1020E+00,  .5884E-01,  .1008E-01,  .2871E+01,  .1274E+01,
     +   .3037E+02,
     +   .1039E+00,  .5989E-01,  .1018E-01,  .3008E+01,  .1342E+01,
     +   .3169E+02 /
        DATA ((PARTON(I,N,32),I=1,6),N=25,27)/
     +   .1059E+00,  .6091E-01,  .1028E-01,  .3144E+01,  .1410E+01,
     +   .3295E+02,
     +   .1076E+00,  .6184E-01,  .1037E-01,  .3267E+01,  .1471E+01,
     +   .3408E+02,
     +   .1094E+00,  .6278E-01,  .1046E-01,  .3393E+01,  .1535E+01,
     +   .3520E+02 /
        DATA ((PARTON(I,N,33),I=1,6),N=1,8)/
     +   .6984E-01,  .4153E-01,  .8419E-02,  .4777E+00,  .7867E-01,
     +   .1464E+01,
     +   .7154E-01,  .4248E-01,  .8500E-02,  .5279E+00,  .1032E+00,
     +   .2050E+01,
     +   .7344E-01,  .4355E-01,  .8590E-02,  .5859E+00,  .1317E+00,
     +   .2769E+01,
     +   .7566E-01,  .4479E-01,  .8693E-02,  .6564E+00,  .1664E+00,
     +   .3687E+01,
     +   .7834E-01,  .4628E-01,  .8817E-02,  .7415E+00,  .2084E+00,
     +   .4852E+01,
     +   .8081E-01,  .4764E-01,  .8931E-02,  .8232E+00,  .2488E+00,
     +   .5981E+01,
     +   .8357E-01,  .4917E-01,  .9061E-02,  .9199E+00,  .2966E+00,
     +   .7310E+01,
     +   .8605E-01,  .5053E-01,  .9177E-02,  .1010E+01,  .3415E+00,
     +   .8538E+01 /
        DATA ((PARTON(I,N,33),I=1,6),N=9,16)/
     +   .8851E-01,  .5188E-01,  .9294E-02,  .1104E+01,  .3880E+00,
     +   .9789E+01,
     +   .9076E-01,  .5310E-01,  .9402E-02,  .1191E+01,  .4312E+00,
     +   .1093E+02,
     +   .9303E-01,  .5434E-01,  .9512E-02,  .1281E+01,  .4761E+00,
     +   .1210E+02,
     +   .9521E-01,  .5552E-01,  .9619E-02,  .1370E+01,  .5203E+00,
     +   .1322E+02,
     +   .9720E-01,  .5660E-01,  .9717E-02,  .1453E+01,  .5617E+00,
     +   .1424E+02,
     +   .9971E-01,  .5795E-01,  .9842E-02,  .1560E+01,  .6152E+00,
     +   .1553E+02,
     +   .1021E+00,  .5921E-01,  .9959E-02,  .1662E+01,  .6663E+00,
     +   .1672E+02,
     +   .1043E+00,  .6041E-01,  .1007E-01,  .1763E+01,  .7165E+00,
     +   .1785E+02 /
        DATA ((PARTON(I,N,33),I=1,6),N=17,24)/
     +   .1064E+00,  .6154E-01,  .1018E-01,  .1858E+01,  .7641E+00,
     +   .1890E+02,
     +   .1085E+00,  .6266E-01,  .1029E-01,  .1955E+01,  .8126E+00,
     +   .1994E+02,
     +   .1105E+00,  .6372E-01,  .1039E-01,  .2048E+01,  .8588E+00,
     +   .2090E+02,
     +   .1124E+00,  .6474E-01,  .1049E-01,  .2138E+01,  .9040E+00,
     +   .2181E+02,
     +   .1142E+00,  .6569E-01,  .1059E-01,  .2223E+01,  .9468E+00,
     +   .2266E+02,
     +   .1167E+00,  .6698E-01,  .1071E-01,  .2340E+01,  .1005E+01,
     +   .2377E+02,
     +   .1189E+00,  .6813E-01,  .1083E-01,  .2444E+01,  .1057E+01,
     +   .2475E+02,
     +   .1211E+00,  .6930E-01,  .1095E-01,  .2551E+01,  .1111E+01,
     +   .2571E+02 /
        DATA ((PARTON(I,N,33),I=1,6),N=25,27)/
     +   .1233E+00,  .7044E-01,  .1106E-01,  .2655E+01,  .1163E+01,
     +   .2663E+02,
     +   .1252E+00,  .7146E-01,  .1117E-01,  .2750E+01,  .1211E+01,
     +   .2744E+02,
     +   .1272E+00,  .7251E-01,  .1128E-01,  .2847E+01,  .1259E+01,
     +   .2824E+02 /
        DATA ((PARTON(I,N,34),I=1,6),N=1,8)/
     +   .8405E-01,  .4966E-01,  .8972E-02,  .4735E+00,  .7032E-01,
     +   .1382E+01,
     +   .8604E-01,  .5077E-01,  .9048E-02,  .5165E+00,  .9147E-01,
     +   .1913E+01,
     +   .8828E-01,  .5202E-01,  .9137E-02,  .5658E+00,  .1158E+00,
     +   .2552E+01,
     +   .9092E-01,  .5348E-01,  .9244E-02,  .6253E+00,  .1451E+00,
     +   .3353E+01,
     +   .9409E-01,  .5522E-01,  .9381E-02,  .6968E+00,  .1805E+00,
     +   .4348E+01,
     +   .9700E-01,  .5682E-01,  .9511E-02,  .7648E+00,  .2143E+00,
     +   .5295E+01,
     +   .1003E+00,  .5860E-01,  .9662E-02,  .8445E+00,  .2540E+00,
     +   .6392E+01,
     +   .1032E+00,  .6019E-01,  .9800E-02,  .9184E+00,  .2908E+00,
     +   .7389E+01 /
        DATA ((PARTON(I,N,34),I=1,6),N=9,16)/
     +   .1061E+00,  .6177E-01,  .9941E-02,  .9944E+00,  .3287E+00,
     +   .8390E+01,
     +   .1088E+00,  .6319E-01,  .1007E-01,  .1064E+01,  .3637E+00,
     +   .9294E+01,
     +   .1114E+00,  .6463E-01,  .1021E-01,  .1136E+01,  .3998E+00,
     +   .1020E+02,
     +   .1140E+00,  .6600E-01,  .1034E-01,  .1207E+01,  .4351E+00,
     +   .1107E+02,
     +   .1163E+00,  .6724E-01,  .1046E-01,  .1273E+01,  .4680E+00,
     +   .1185E+02,
     +   .1193E+00,  .6879E-01,  .1061E-01,  .1357E+01,  .5101E+00,
     +   .1282E+02,
     +   .1220E+00,  .7024E-01,  .1076E-01,  .1437E+01,  .5502E+00,
     +   .1371E+02,
     +   .1246E+00,  .7162E-01,  .1090E-01,  .1514E+01,  .5892E+00,
     +   .1455E+02 /
        DATA ((PARTON(I,N,34),I=1,6),N=17,24)/
     +   .1271E+00,  .7290E-01,  .1103E-01,  .1588E+01,  .6260E+00,
     +   .1531E+02,
     +   .1295E+00,  .7418E-01,  .1117E-01,  .1662E+01,  .6633E+00,
     +   .1606E+02,
     +   .1318E+00,  .7538E-01,  .1130E-01,  .1732E+01,  .6986E+00,
     +   .1675E+02,
     +   .1340E+00,  .7654E-01,  .1142E-01,  .1800E+01,  .7329E+00,
     +   .1740E+02,
     +   .1361E+00,  .7762E-01,  .1154E-01,  .1864E+01,  .7652E+00,
     +   .1799E+02,
     +   .1389E+00,  .7907E-01,  .1170E-01,  .1951E+01,  .8089E+00,
     +   .1877E+02,
     +   .1414E+00,  .8036E-01,  .1184E-01,  .2029E+01,  .8479E+00,
     +   .1944E+02,
     +   .1439E+00,  .8166E-01,  .1198E-01,  .2107E+01,  .8875E+00,
     +   .2009E+02 /
        DATA ((PARTON(I,N,34),I=1,6),N=25,27)/
     +   .1464E+00,  .8294E-01,  .1213E-01,  .2184E+01,  .9262E+00,
     +   .2071E+02,
     +   .1486E+00,  .8408E-01,  .1226E-01,  .2253E+01,  .9611E+00,
     +   .2125E+02,
     +   .1509E+00,  .8523E-01,  .1239E-01,  .2323E+01,  .9965E+00,
     +   .2178E+02 /
        DATA ((PARTON(I,N,35),I=1,6),N=1,8)/
     +   .1012E+00,  .5940E-01,  .9493E-02,  .4675E+00,  .6236E-01,
     +   .1301E+01,
     +   .1036E+00,  .6070E-01,  .9574E-02,  .5038E+00,  .8035E-01,
     +   .1779E+01,
     +   .1062E+00,  .6216E-01,  .9675E-02,  .5451E+00,  .1009E+00,
     +   .2343E+01,
     +   .1094E+00,  .6388E-01,  .9804E-02,  .5945E+00,  .1255E+00,
     +   .3035E+01,
     +   .1131E+00,  .6592E-01,  .9974E-02,  .6536E+00,  .1550E+00,
     +   .3876E+01,
     +   .1166E+00,  .6779E-01,  .1014E-01,  .7093E+00,  .1829E+00,
     +   .4662E+01,
     +   .1205E+00,  .6988E-01,  .1033E-01,  .7740E+00,  .2154E+00,
     +   .5554E+01,
     +   .1239E+00,  .7173E-01,  .1052E-01,  .8335E+00,  .2453E+00,
     +   .6352E+01 /
        DATA ((PARTON(I,N,35),I=1,6),N=9,16)/
     +   .1273E+00,  .7356E-01,  .1070E-01,  .8941E+00,  .2758E+00,
     +   .7140E+01,
     +   .1304E+00,  .7521E-01,  .1087E-01,  .9496E+00,  .3038E+00,
     +   .7842E+01,
     +   .1336E+00,  .7686E-01,  .1105E-01,  .1006E+01,  .3324E+00,
     +   .8539E+01,
     +   .1366E+00,  .7843E-01,  .1122E-01,  .1061E+01,  .3603E+00,
     +   .9193E+01,
     +   .1393E+00,  .7985E-01,  .1138E-01,  .1112E+01,  .3860E+00,
     +   .9776E+01,
     +   .1427E+00,  .8163E-01,  .1158E-01,  .1177E+01,  .4188E+00,
     +   .1049E+02,
     +   .1458E+00,  .8327E-01,  .1177E-01,  .1238E+01,  .4497E+00,
     +   .1114E+02,
     +   .1489E+00,  .8483E-01,  .1195E-01,  .1297E+01,  .4795E+00,
     +   .1174E+02 /
        DATA ((PARTON(I,N,35),I=1,6),N=17,24)/
     +   .1517E+00,  .8628E-01,  .1213E-01,  .1352E+01,  .5075E+00,
     +   .1229E+02,
     +   .1545E+00,  .8772E-01,  .1230E-01,  .1408E+01,  .5357E+00,
     +   .1281E+02,
     +   .1571E+00,  .8907E-01,  .1246E-01,  .1460E+01,  .5622E+00,
     +   .1329E+02,
     +   .1596E+00,  .9036E-01,  .1262E-01,  .1510E+01,  .5878E+00,
     +   .1374E+02,
     +   .1620E+00,  .9156E-01,  .1277E-01,  .1557E+01,  .6118E+00,
     +   .1414E+02,
     +   .1652E+00,  .9316E-01,  .1297E-01,  .1621E+01,  .6440E+00,
     +   .1466E+02,
     +   .1680E+00,  .9459E-01,  .1315E-01,  .1677E+01,  .6726E+00,
     +   .1510E+02,
     +   .1708E+00,  .9602E-01,  .1333E-01,  .1733E+01,  .7014E+00,
     +   .1553E+02 /
        DATA ((PARTON(I,N,35),I=1,6),N=25,27)/
     +   .1736E+00,  .9741E-01,  .1351E-01,  .1788E+01,  .7293E+00,
     +   .1593E+02,
     +   .1761E+00,  .9866E-01,  .1367E-01,  .1837E+01,  .7543E+00,
     +   .1627E+02,
     +   .1786E+00,  .9991E-01,  .1383E-01,  .1886E+01,  .7795E+00,
     +   .1659E+02 /
        DATA ((PARTON(I,N,36),I=1,6),N=1,8)/
     +   .1216E+00,  .7082E-01,  .1004E-01,  .4590E+00,  .5494E-01,
     +   .1224E+01,
     +   .1244E+00,  .7235E-01,  .1015E-01,  .4892E+00,  .7008E-01,
     +   .1650E+01,
     +   .1275E+00,  .7407E-01,  .1029E-01,  .5232E+00,  .8723E-01,
     +   .2145E+01,
     +   .1313E+00,  .7609E-01,  .1047E-01,  .5636E+00,  .1077E+00,
     +   .2739E+01,
     +   .1357E+00,  .7849E-01,  .1071E-01,  .6116E+00,  .1320E+00,
     +   .3444E+01,
     +   .1398E+00,  .8067E-01,  .1095E-01,  .6565E+00,  .1549E+00,
     +   .4088E+01,
     +   .1444E+00,  .8309E-01,  .1122E-01,  .7082E+00,  .1813E+00,
     +   .4806E+01,
     +   .1484E+00,  .8523E-01,  .1147E-01,  .7553E+00,  .2053E+00,
     +   .5436E+01 /
        DATA ((PARTON(I,N,36),I=1,6),N=9,16)/
     +   .1525E+00,  .8734E-01,  .1173E-01,  .8029E+00,  .2297E+00,
     +   .6048E+01,
     +   .1561E+00,  .8922E-01,  .1197E-01,  .8461E+00,  .2518E+00,
     +   .6584E+01,
     +   .1597E+00,  .9110E-01,  .1221E-01,  .8899E+00,  .2743E+00,
     +   .7108E+01,
     +   .1632E+00,  .9288E-01,  .1244E-01,  .9321E+00,  .2960E+00,
     +   .7594E+01,
     +   .1663E+00,  .9448E-01,  .1265E-01,  .9708E+00,  .3159E+00,
     +   .8021E+01,
     +   .1702E+00,  .9648E-01,  .1292E-01,  .1020E+01,  .3411E+00,
     +   .8538E+01,
     +   .1738E+00,  .9831E-01,  .1317E-01,  .1065E+01,  .3646E+00,
     +   .8999E+01,
     +   .1772E+00,  .1001E+00,  .1341E-01,  .1109E+01,  .3872E+00,
     +   .9420E+01 /
        DATA ((PARTON(I,N,36),I=1,6),N=17,24)/
     +   .1804E+00,  .1017E+00,  .1363E-01,  .1150E+01,  .4082E+00,
     +   .9795E+01,
     +   .1836E+00,  .1032E+00,  .1385E-01,  .1190E+01,  .4292E+00,
     +   .1015E+02,
     +   .1865E+00,  .1047E+00,  .1406E-01,  .1228E+01,  .4488E+00,
     +   .1047E+02,
     +   .1893E+00,  .1061E+00,  .1426E-01,  .1265E+01,  .4676E+00,
     +   .1077E+02,
     +   .1920E+00,  .1074E+00,  .1445E-01,  .1299E+01,  .4851E+00,
     +   .1103E+02,
     +   .1955E+00,  .1092E+00,  .1470E-01,  .1344E+01,  .5085E+00,
     +   .1136E+02,
     +   .1986E+00,  .1107E+00,  .1492E-01,  .1383E+01,  .5290E+00,
     +   .1164E+02,
     +   .2017E+00,  .1122E+00,  .1514E-01,  .1423E+01,  .5495E+00,
     +   .1191E+02 /
        DATA ((PARTON(I,N,36),I=1,6),N=25,27)/
     +   .2048E+00,  .1137E+00,  .1536E-01,  .1461E+01,  .5693E+00,
     +   .1215E+02,
     +   .2075E+00,  .1150E+00,  .1555E-01,  .1494E+01,  .5869E+00,
     +   .1235E+02,
     +   .2102E+00,  .1163E+00,  .1574E-01,  .1528E+01,  .6045E+00,
     +   .1254E+02 /
        DATA ((PARTON(I,N,37),I=1,6),N=1,8)/
     +   .1464E+00,  .8454E-01,  .1078E-01,  .4471E+00,  .4794E-01,
     +   .1149E+01,
     +   .1497E+00,  .8637E-01,  .1097E-01,  .4714E+00,  .6046E-01,
     +   .1527E+01,
     +   .1535E+00,  .8842E-01,  .1120E-01,  .4986E+00,  .7457E-01,
     +   .1955E+01,
     +   .1580E+00,  .9081E-01,  .1149E-01,  .5308E+00,  .9127E-01,
     +   .2457E+01,
     +   .1633E+00,  .9362E-01,  .1186E-01,  .5687E+00,  .1111E+00,
     +   .3039E+01,
     +   .1681E+00,  .9615E-01,  .1222E-01,  .6039E+00,  .1295E+00,
     +   .3558E+01,
     +   .1735E+00,  .9895E-01,  .1262E-01,  .6441E+00,  .1505E+00,
     +   .4124E+01,
     +   .1782E+00,  .1014E+00,  .1298E-01,  .6803E+00,  .1696E+00,
     +   .4610E+01 /
        DATA ((PARTON(I,N,37),I=1,6),N=9,16)/
     +   .1829E+00,  .1038E+00,  .1335E-01,  .7166E+00,  .1887E+00,
     +   .5072E+01,
     +   .1871E+00,  .1059E+00,  .1367E-01,  .7492E+00,  .2059E+00,
     +   .5471E+01,
     +   .1913E+00,  .1080E+00,  .1400E-01,  .7820E+00,  .2232E+00,
     +   .5853E+01,
     +   .1952E+00,  .1100E+00,  .1432E-01,  .8133E+00,  .2398E+00,
     +   .6201E+01,
     +   .1987E+00,  .1118E+00,  .1460E-01,  .8418E+00,  .2548E+00,
     +   .6503E+01,
     +   .2032E+00,  .1140E+00,  .1495E-01,  .8775E+00,  .2738E+00,
     +   .6862E+01,
     +   .2072E+00,  .1160E+00,  .1527E-01,  .9105E+00,  .2913E+00,
     +   .7175E+01,
     +   .2111E+00,  .1179E+00,  .1558E-01,  .9418E+00,  .3079E+00,
     +   .7456E+01 /
        DATA ((PARTON(I,N,37),I=1,6),N=17,24)/
     +   .2146E+00,  .1196E+00,  .1586E-01,  .9707E+00,  .3233E+00,
     +   .7702E+01,
     +   .2181E+00,  .1213E+00,  .1614E-01,  .9992E+00,  .3385E+00,
     +   .7932E+01,
     +   .2213E+00,  .1229E+00,  .1640E-01,  .1026E+01,  .3526E+00,
     +   .8134E+01,
     +   .2244E+00,  .1244E+00,  .1664E-01,  .1051E+01,  .3661E+00,
     +   .8317E+01,
     +   .2273E+00,  .1258E+00,  .1687E-01,  .1074E+01,  .3785E+00,
     +   .8476E+01,
     +   .2311E+00,  .1276E+00,  .1717E-01,  .1105E+01,  .3949E+00,
     +   .8674E+01,
     +   .2345E+00,  .1292E+00,  .1743E-01,  .1131E+01,  .4092E+00,
     +   .8834E+01,
     +   .2378E+00,  .1307E+00,  .1768E-01,  .1157E+01,  .4234E+00,
     +   .8982E+01 /
        DATA ((PARTON(I,N,37),I=1,6),N=25,27)/
     +   .2410E+00,  .1323E+00,  .1793E-01,  .1182E+01,  .4369E+00,
     +   .9113E+01,
     +   .2439E+00,  .1336E+00,  .1815E-01,  .1204E+01,  .4488E+00,
     +   .9218E+01,
     +   .2468E+00,  .1349E+00,  .1837E-01,  .1226E+01,  .4607E+00,
     +   .9315E+01 /
        DATA ((PARTON(I,N,38),I=1,6),N=1,8)/
     +   .1712E+00,  .9815E-01,  .1180E-01,  .4336E+00,  .4246E-01,
     +   .1091E+01,
     +   .1752E+00,  .1003E+00,  .1211E-01,  .4533E+00,  .5297E-01,
     +   .1429E+01,
     +   .1796E+00,  .1027E+00,  .1248E-01,  .4753E+00,  .6477E-01,
     +   .1805E+01,
     +   .1849E+00,  .1054E+00,  .1293E-01,  .5011E+00,  .7869E-01,
     +   .2236E+01,
     +   .1910E+00,  .1086E+00,  .1347E-01,  .5314E+00,  .9511E-01,
     +   .2724E+01,
     +   .1965E+00,  .1115E+00,  .1396E-01,  .5593E+00,  .1103E+00,
     +   .3150E+01,
     +   .2026E+00,  .1146E+00,  .1451E-01,  .5908E+00,  .1274E+00,
     +   .3604E+01,
     +   .2080E+00,  .1174E+00,  .1500E-01,  .6191E+00,  .1428E+00,
     +   .3986E+01 /
        DATA ((PARTON(I,N,38),I=1,6),N=9,16)/
     +   .2133E+00,  .1200E+00,  .1547E-01,  .6471E+00,  .1582E+00,
     +   .4342E+01,
     +   .2180E+00,  .1223E+00,  .1589E-01,  .6721E+00,  .1719E+00,
     +   .4644E+01,
     +   .2226E+00,  .1246E+00,  .1631E-01,  .6970E+00,  .1855E+00,
     +   .4929E+01,
     +   .2269E+00,  .1267E+00,  .1669E-01,  .7206E+00,  .1985E+00,
     +   .5183E+01,
     +   .2308E+00,  .1286E+00,  .1704E-01,  .7418E+00,  .2102E+00,
     +   .5400E+01,
     +   .2356E+00,  .1309E+00,  .1746E-01,  .7682E+00,  .2248E+00,
     +   .5653E+01,
     +   .2400E+00,  .1330E+00,  .1784E-01,  .7924E+00,  .2382E+00,
     +   .5870E+01,
     +   .2441E+00,  .1350E+00,  .1820E-01,  .8151E+00,  .2508E+00,
     +   .6060E+01 /
        DATA ((PARTON(I,N,38),I=1,6),N=17,24)/
     +   .2479E+00,  .1368E+00,  .1853E-01,  .8359E+00,  .2624E+00,
     +   .6223E+01,
     +   .2516E+00,  .1385E+00,  .1884E-01,  .8562E+00,  .2737E+00,
     +   .6372E+01,
     +   .2550E+00,  .1401E+00,  .1913E-01,  .8749E+00,  .2842E+00,
     +   .6500E+01,
     +   .2583E+00,  .1416E+00,  .1940E-01,  .8924E+00,  .2941E+00,
     +   .6612E+01,
     +   .2613E+00,  .1430E+00,  .1965E-01,  .9085E+00,  .3031E+00,
     +   .6708E+01,
     +   .2652E+00,  .1448E+00,  .1997E-01,  .9295E+00,  .3150E+00,
     +   .6823E+01,
     +   .2687E+00,  .1464E+00,  .2025E-01,  .9475E+00,  .3252E+00,
     +   .6913E+01,
     +   .2721E+00,  .1479E+00,  .2052E-01,  .9650E+00,  .3353E+00,
     +   .6992E+01 /
        DATA ((PARTON(I,N,38),I=1,6),N=25,27)/
     +   .2754E+00,  .1494E+00,  .2077E-01,  .9815E+00,  .3448E+00,
     +   .7058E+01,
     +   .2782E+00,  .1507E+00,  .2100E-01,  .9959E+00,  .3531E+00,
     +   .7108E+01,
     +   .2811E+00,  .1519E+00,  .2121E-01,  .1010E+01,  .3613E+00,
     +   .7151E+01 /
        DATA ((PARTON(I,N,39),I=1,6),N=1,8)/
     +   .2024E+00,  .1150E+00,  .1369E-01,  .4152E+00,  .3711E-01,
     +   .1038E+01,
     +   .2072E+00,  .1176E+00,  .1422E-01,  .4303E+00,  .4568E-01,
     +   .1335E+01,
     +   .2125E+00,  .1204E+00,  .1480E-01,  .4471E+00,  .5529E-01,
     +   .1657E+01,
     +   .2187E+00,  .1236E+00,  .1548E-01,  .4668E+00,  .6658E-01,
     +   .2017E+01,
     +   .2258E+00,  .1273E+00,  .1625E-01,  .4898E+00,  .7982E-01,
     +   .2414E+01,
     +   .2322E+00,  .1305E+00,  .1692E-01,  .5107E+00,  .9194E-01,
     +   .2752E+01,
     +   .2392E+00,  .1340E+00,  .1765E-01,  .5342E+00,  .1056E+00,
     +   .3102E+01,
     +   .2453E+00,  .1369E+00,  .1827E-01,  .5550E+00,  .1176E+00,
     +   .3389E+01 /
        DATA ((PARTON(I,N,39),I=1,6),N=9,16)/
     +   .2511E+00,  .1398E+00,  .1887E-01,  .5754E+00,  .1295E+00,
     +   .3651E+01,
     +   .2563E+00,  .1423E+00,  .1938E-01,  .5934E+00,  .1401E+00,
     +   .3867E+01,
     +   .2613E+00,  .1447E+00,  .1987E-01,  .6111E+00,  .1505E+00,
     +   .4066E+01,
     +   .2660E+00,  .1469E+00,  .2031E-01,  .6277E+00,  .1603E+00,
     +   .4240E+01,
     +   .2702E+00,  .1488E+00,  .2070E-01,  .6425E+00,  .1691E+00,
     +   .4385E+01,
     +   .2753E+00,  .1512E+00,  .2117E-01,  .6607E+00,  .1799E+00,
     +   .4550E+01,
     +   .2799E+00,  .1533E+00,  .2159E-01,  .6771E+00,  .1897E+00,
     +   .4686E+01,
     +   .2842E+00,  .1552E+00,  .2197E-01,  .6924E+00,  .1988E+00,
     +   .4802E+01 /
        DATA ((PARTON(I,N,39),I=1,6),N=17,24)/
     +   .2881E+00,  .1570E+00,  .2231E-01,  .7061E+00,  .2071E+00,
     +   .4897E+01,
     +   .2919E+00,  .1587E+00,  .2263E-01,  .7194E+00,  .2152E+00,
     +   .4982E+01,
     +   .2954E+00,  .1602E+00,  .2292E-01,  .7314E+00,  .2226E+00,
     +   .5051E+01,
     +   .2987E+00,  .1617E+00,  .2318E-01,  .7426E+00,  .2294E+00,
     +   .5109E+01,
     +   .3017E+00,  .1630E+00,  .2342E-01,  .7526E+00,  .2357E+00,
     +   .5156E+01,
     +   .3056E+00,  .1646E+00,  .2372E-01,  .7656E+00,  .2438E+00,
     +   .5209E+01,
     +   .3090E+00,  .1661E+00,  .2398E-01,  .7765E+00,  .2507E+00,
     +   .5246E+01,
     +   .3123E+00,  .1674E+00,  .2422E-01,  .7869E+00,  .2574E+00,
     +   .5274E+01 /
        DATA ((PARTON(I,N,39),I=1,6),N=25,27)/
     +   .3154E+00,  .1687E+00,  .2444E-01,  .7965E+00,  .2636E+00,
     +   .5294E+01,
     +   .3181E+00,  .1698E+00,  .2463E-01,  .8046E+00,  .2690E+00,
     +   .5305E+01,
     +   .3208E+00,  .1709E+00,  .2481E-01,  .8125E+00,  .2742E+00,
     +   .5309E+01 /
        DATA ((PARTON(I,N,40),I=1,6),N=1,8)/
     +   .2454E+00,  .1380E+00,  .1770E-01,  .3884E+00,  .3166E-01,
     +   .9927E+00,
     +   .2513E+00,  .1411E+00,  .1854E-01,  .3987E+00,  .3827E-01,
     +   .1244E+01,
     +   .2579E+00,  .1445E+00,  .1942E-01,  .4101E+00,  .4568E-01,
     +   .1508E+01,
     +   .2653E+00,  .1482E+00,  .2038E-01,  .4236E+00,  .5437E-01,
     +   .1793E+01,
     +   .2737E+00,  .1524E+00,  .2140E-01,  .4390E+00,  .6449E-01,
     +   .2096E+01,
     +   .2810E+00,  .1559E+00,  .2225E-01,  .4530E+00,  .7365E-01,
     +   .2345E+01,
     +   .2889E+00,  .1597E+00,  .2313E-01,  .4685E+00,  .8383E-01,
     +   .2593E+01,
     +   .2957E+00,  .1628E+00,  .2384E-01,  .4821E+00,  .9275E-01,
     +   .2789E+01 /
        DATA ((PARTON(I,N,40),I=1,6),N=9,16)/
     +   .3021E+00,  .1658E+00,  .2449E-01,  .4952E+00,  .1014E+00,
     +   .2961E+01,
     +   .3076E+00,  .1683E+00,  .2503E-01,  .5065E+00,  .1090E+00,
     +   .3098E+01,
     +   .3129E+00,  .1707E+00,  .2552E-01,  .5174E+00,  .1164E+00,
     +   .3220E+01,
     +   .3178E+00,  .1728E+00,  .2595E-01,  .5275E+00,  .1232E+00,
     +   .3322E+01,
     +   .3221E+00,  .1746E+00,  .2632E-01,  .5363E+00,  .1293E+00,
     +   .3404E+01,
     +   .3272E+00,  .1768E+00,  .2674E-01,  .5469E+00,  .1367E+00,
     +   .3491E+01,
     +   .3318E+00,  .1788E+00,  .2710E-01,  .5562E+00,  .1432E+00,
     +   .3560E+01,
     +   .3360E+00,  .1805E+00,  .2741E-01,  .5647E+00,  .1493E+00,
     +   .3614E+01 /
        DATA ((PARTON(I,N,40),I=1,6),N=17,24)/
     +   .3398E+00,  .1820E+00,  .2767E-01,  .5721E+00,  .1547E+00,
     +   .3654E+01,
     +   .3434E+00,  .1835E+00,  .2791E-01,  .5792E+00,  .1599E+00,
     +   .3687E+01,
     +   .3466E+00,  .1847E+00,  .2812E-01,  .5853E+00,  .1645E+00,
     +   .3710E+01,
     +   .3496E+00,  .1859E+00,  .2830E-01,  .5909E+00,  .1688E+00,
     +   .3726E+01,
     +   .3523E+00,  .1869E+00,  .2845E-01,  .5958E+00,  .1727E+00,
     +   .3735E+01,
     +   .3558E+00,  .1882E+00,  .2863E-01,  .6019E+00,  .1776E+00,
     +   .3741E+01,
     +   .3587E+00,  .1892E+00,  .2877E-01,  .6067E+00,  .1816E+00,
     +   .3739E+01,
     +   .3615E+00,  .1902E+00,  .2888E-01,  .6112E+00,  .1855E+00,
     +   .3732E+01 /
        DATA ((PARTON(I,N,40),I=1,6),N=25,27)/
     +   .3641E+00,  .1911E+00,  .2898E-01,  .6150E+00,  .1891E+00,
     +   .3719E+01,
     +   .3663E+00,  .1918E+00,  .2905E-01,  .6181E+00,  .1921E+00,
     +   .3703E+01,
     +   .3685E+00,  .1925E+00,  .2911E-01,  .6209E+00,  .1949E+00,
     +   .3683E+01 /
        DATA ((PARTON(I,N,41),I=1,6),N=1,8)/
     +   .2982E+00,  .1657E+00,  .2475E-01,  .3546E+00,  .2686E-01,
     +   .9724E+00,
     +   .3057E+00,  .1695E+00,  .2583E-01,  .3605E+00,  .3177E-01,
     +   .1176E+01,
     +   .3136E+00,  .1734E+00,  .2690E-01,  .3671E+00,  .3729E-01,
     +   .1382E+01,
     +   .3225E+00,  .1776E+00,  .2799E-01,  .3750E+00,  .4376E-01,
     +   .1596E+01,
     +   .3320E+00,  .1821E+00,  .2905E-01,  .3839E+00,  .5122E-01,
     +   .1814E+01,
     +   .3401E+00,  .1857E+00,  .2987E-01,  .3919E+00,  .5790E-01,
     +   .1983E+01,
     +   .3485E+00,  .1894E+00,  .3065E-01,  .4007E+00,  .6521E-01,
     +   .2145E+01,
     +   .3556E+00,  .1925E+00,  .3123E-01,  .4081E+00,  .7152E-01,
     +   .2265E+01 /
        DATA ((PARTON(I,N,41),I=1,6),N=9,16)/
     +   .3621E+00,  .1952E+00,  .3172E-01,  .4151E+00,  .7755E-01,
     +   .2364E+01,
     +   .3675E+00,  .1974E+00,  .3208E-01,  .4209E+00,  .8273E-01,
     +   .2439E+01,
     +   .3726E+00,  .1994E+00,  .3238E-01,  .4264E+00,  .8769E-01,
     +   .2500E+01,
     +   .3772E+00,  .2011E+00,  .3261E-01,  .4312E+00,  .9222E-01,
     +   .2548E+01,
     +   .3811E+00,  .2026E+00,  .3279E-01,  .4353E+00,  .9615E-01,
     +   .2583E+01,
     +   .3857E+00,  .2042E+00,  .3296E-01,  .4400E+00,  .1008E+00,
     +   .2615E+01,
     +   .3896E+00,  .2056E+00,  .3307E-01,  .4439E+00,  .1050E+00,
     +   .2635E+01,
     +   .3931E+00,  .2067E+00,  .3314E-01,  .4472E+00,  .1087E+00,
     +   .2647E+01 /
        DATA ((PARTON(I,N,41),I=1,6),N=17,24)/
     +   .3962E+00,  .2077E+00,  .3318E-01,  .4500E+00,  .1119E+00,
     +   .2651E+01,
     +   .3990E+00,  .2085E+00,  .3319E-01,  .4523E+00,  .1149E+00,
     +   .2649E+01,
     +   .4015E+00,  .2092E+00,  .3317E-01,  .4542E+00,  .1176E+00,
     +   .2643E+01,
     +   .4037E+00,  .2098E+00,  .3314E-01,  .4558E+00,  .1200E+00,
     +   .2632E+01,
     +   .4056E+00,  .2103E+00,  .3309E-01,  .4570E+00,  .1221E+00,
     +   .2620E+01,
     +   .4080E+00,  .2108E+00,  .3299E-01,  .4582E+00,  .1247E+00,
     +   .2598E+01,
     +   .4098E+00,  .2111E+00,  .3289E-01,  .4589E+00,  .1269E+00,
     +   .2575E+01,
     +   .4115E+00,  .2113E+00,  .3276E-01,  .4592E+00,  .1288E+00,
     +   .2548E+01 /
        DATA ((PARTON(I,N,41),I=1,6),N=25,27)/
     +   .4130E+00,  .2115E+00,  .3261E-01,  .4592E+00,  .1305E+00,
     +   .2518E+01,
     +   .4141E+00,  .2116E+00,  .3246E-01,  .4589E+00,  .1319E+00,
     +   .2490E+01,
     +   .4152E+00,  .2115E+00,  .3230E-01,  .4583E+00,  .1332E+00,
     +   .2459E+01 /
        DATA ((PARTON(I,N,42),I=1,6),N=1,8)/
     +   .3431E+00,  .1888E+00,  .3183E-01,  .3258E+00,  .2374E-01,
     +   .9760E+00,
     +   .3517E+00,  .1929E+00,  .3286E-01,  .3289E+00,  .2759E-01,
     +   .1144E+01,
     +   .3606E+00,  .1971E+00,  .3381E-01,  .3324E+00,  .3195E-01,
     +   .1308E+01,
     +   .3702E+00,  .2014E+00,  .3471E-01,  .3368E+00,  .3706E-01,
     +   .1473E+01,
     +   .3802E+00,  .2058E+00,  .3548E-01,  .3417E+00,  .4290E-01,
     +   .1633E+01,
     +   .3885E+00,  .2091E+00,  .3600E-01,  .3460E+00,  .4808E-01,
     +   .1752E+01,
     +   .3968E+00,  .2125E+00,  .3642E-01,  .3506E+00,  .5367E-01,
     +   .1859E+01,
     +   .4035E+00,  .2150E+00,  .3667E-01,  .3543E+00,  .5842E-01,
     +   .1933E+01 /
        DATA ((PARTON(I,N,42),I=1,6),N=9,16)/
     +   .4095E+00,  .2172E+00,  .3682E-01,  .3577E+00,  .6289E-01,
     +   .1990E+01,
     +   .4144E+00,  .2188E+00,  .3687E-01,  .3604E+00,  .6667E-01,
     +   .2029E+01,
     +   .4188E+00,  .2202E+00,  .3685E-01,  .3627E+00,  .7023E-01,
     +   .2057E+01,
     +   .4225E+00,  .2213E+00,  .3679E-01,  .3646E+00,  .7343E-01,
     +   .2075E+01,
     +   .4257E+00,  .2222E+00,  .3669E-01,  .3660E+00,  .7617E-01,
     +   .2085E+01,
     +   .4292E+00,  .2231E+00,  .3653E-01,  .3674E+00,  .7937E-01,
     +   .2089E+01,
     +   .4321E+00,  .2237E+00,  .3634E-01,  .3684E+00,  .8212E-01,
     +   .2085E+01,
     +   .4346E+00,  .2241E+00,  .3612E-01,  .3690E+00,  .8453E-01,
     +   .2076E+01 /
        DATA ((PARTON(I,N,42),I=1,6),N=17,24)/
     +   .4366E+00,  .2244E+00,  .3589E-01,  .3692E+00,  .8660E-01,
     +   .2062E+01,
     +   .4384E+00,  .2245E+00,  .3563E-01,  .3692E+00,  .8851E-01,
     +   .2045E+01,
     +   .4398E+00,  .2245E+00,  .3538E-01,  .3689E+00,  .9014E-01,
     +   .2026E+01,
     +   .4409E+00,  .2245E+00,  .3511E-01,  .3684E+00,  .9157E-01,
     +   .2005E+01,
     +   .4419E+00,  .2243E+00,  .3485E-01,  .3677E+00,  .9280E-01,
     +   .1983E+01,
     +   .4429E+00,  .2240E+00,  .3448E-01,  .3666E+00,  .9426E-01,
     +   .1951E+01,
     +   .4435E+00,  .2236E+00,  .3413E-01,  .3652E+00,  .9540E-01,
     +   .1920E+01,
     +   .4439E+00,  .2231E+00,  .3377E-01,  .3636E+00,  .9639E-01,
     +   .1887E+01 /
        DATA ((PARTON(I,N,42),I=1,6),N=25,27)/
     +   .4440E+00,  .2224E+00,  .3340E-01,  .3618E+00,  .9721E-01,
     +   .1853E+01,
     +   .4440E+00,  .2218E+00,  .3305E-01,  .3600E+00,  .9784E-01,
     +   .1821E+01,
     +   .4438E+00,  .2211E+00,  .3270E-01,  .3580E+00,  .9837E-01,
     +   .1788E+01 /
        DATA ((PARTON(I,N,43),I=1,6),N=1,8)/
     +   .3953E+00,  .2149E+00,  .3983E-01,  .2925E+00,  .2063E-01,
     +   .9931E+00,
     +   .4048E+00,  .2191E+00,  .4044E-01,  .2930E+00,  .2358E-01,
     +   .1122E+01,
     +   .4143E+00,  .2231E+00,  .4090E-01,  .2938E+00,  .2693E-01,
     +   .1244E+01,
     +   .4241E+00,  .2271E+00,  .4121E-01,  .2949E+00,  .3085E-01,
     +   .1359E+01,
     +   .4339E+00,  .2308E+00,  .4131E-01,  .2962E+00,  .3529E-01,
     +   .1464E+01,
     +   .4415E+00,  .2334E+00,  .4122E-01,  .2973E+00,  .3915E-01,
     +   .1536E+01,
     +   .4488E+00,  .2357E+00,  .4098E-01,  .2984E+00,  .4326E-01,
     +   .1594E+01,
     +   .4544E+00,  .2373E+00,  .4067E-01,  .2990E+00,  .4667E-01,
     +   .1629E+01 /
        DATA ((PARTON(I,N,43),I=1,6),N=9,16)/
     +   .4591E+00,  .2384E+00,  .4027E-01,  .2994E+00,  .4983E-01,
     +   .1650E+01,
     +   .4626E+00,  .2391E+00,  .3986E-01,  .2995E+00,  .5243E-01,
     +   .1659E+01,
     +   .4656E+00,  .2395E+00,  .3939E-01,  .2993E+00,  .5484E-01,
     +   .1661E+01,
     +   .4679E+00,  .2396E+00,  .3892E-01,  .2988E+00,  .5695E-01,
     +   .1656E+01,
     +   .4697E+00,  .2395E+00,  .3846E-01,  .2982E+00,  .5871E-01,
     +   .1647E+01,
     +   .4714E+00,  .2392E+00,  .3786E-01,  .2971E+00,  .6072E-01,
     +   .1630E+01,
     +   .4726E+00,  .2388E+00,  .3728E-01,  .2958E+00,  .6239E-01,
     +   .1610E+01,
     +   .4733E+00,  .2381E+00,  .3671E-01,  .2944E+00,  .6381E-01,
     +   .1586E+01 /
        DATA ((PARTON(I,N,43),I=1,6),N=17,24)/
     +   .4737E+00,  .2374E+00,  .3617E-01,  .2928E+00,  .6498E-01,
     +   .1562E+01,
     +   .4738E+00,  .2366E+00,  .3561E-01,  .2911E+00,  .6602E-01,
     +   .1535E+01,
     +   .4736E+00,  .2357E+00,  .3508E-01,  .2893E+00,  .6687E-01,
     +   .1509E+01,
     +   .4732E+00,  .2347E+00,  .3457E-01,  .2874E+00,  .6758E-01,
     +   .1482E+01,
     +   .4727E+00,  .2337E+00,  .3408E-01,  .2855E+00,  .6816E-01,
     +   .1456E+01,
     +   .4717E+00,  .2323E+00,  .3343E-01,  .2827E+00,  .6880E-01,
     +   .1419E+01,
     +   .4706E+00,  .2309E+00,  .3283E-01,  .2801E+00,  .6924E-01,
     +   .1386E+01,
     +   .4692E+00,  .2294E+00,  .3223E-01,  .2773E+00,  .6956E-01,
     +   .1351E+01 /
        DATA ((PARTON(I,N,43),I=1,6),N=25,27)/
     +   .4676E+00,  .2278E+00,  .3165E-01,  .2744E+00,  .6978E-01,
     +   .1317E+01,
     +   .4660E+00,  .2264E+00,  .3112E-01,  .2717E+00,  .6990E-01,
     +   .1286E+01,
     +   .4642E+00,  .2248E+00,  .3058E-01,  .2689E+00,  .6994E-01,
     +   .1255E+01 /
        DATA ((PARTON(I,N,44),I=1,6),N=1,8)/
     +   .4410E+00,  .2369E+00,  .4528E-01,  .2630E+00,  .1804E-01,
     +   .1011E+01,
     +   .4507E+00,  .2407E+00,  .4525E-01,  .2616E+00,  .2040E-01,
     +   .1108E+01,
     +   .4601E+00,  .2442E+00,  .4503E-01,  .2605E+00,  .2309E-01,
     +   .1194E+01,
     +   .4694E+00,  .2474E+00,  .4462E-01,  .2595E+00,  .2621E-01,
     +   .1271E+01,
     +   .4780E+00,  .2499E+00,  .4394E-01,  .2584E+00,  .2970E-01,
     +   .1335E+01,
     +   .4843E+00,  .2514E+00,  .4321E-01,  .2574E+00,  .3268E-01,
     +   .1374E+01,
     +   .4899E+00,  .2524E+00,  .4230E-01,  .2562E+00,  .3579E-01,
     +   .1398E+01,
     +   .4938E+00,  .2527E+00,  .4144E-01,  .2549E+00,  .3833E-01,
     +   .1406E+01 /
        DATA ((PARTON(I,N,44),I=1,6),N=9,16)/
     +   .4967E+00,  .2526E+00,  .4055E-01,  .2534E+00,  .4061E-01,
     +   .1404E+01,
     +   .4985E+00,  .2522E+00,  .3973E-01,  .2519E+00,  .4246E-01,
     +   .1395E+01,
     +   .4996E+00,  .2514E+00,  .3888E-01,  .2502E+00,  .4412E-01,
     +   .1381E+01,
     +   .5002E+00,  .2504E+00,  .3807E-01,  .2483E+00,  .4554E-01,
     +   .1363E+01,
     +   .5003E+00,  .2494E+00,  .3733E-01,  .2465E+00,  .4670E-01,
     +   .1343E+01,
     +   .5000E+00,  .2479E+00,  .3640E-01,  .2440E+00,  .4797E-01,
     +   .1315E+01,
     +   .4992E+00,  .2463E+00,  .3553E-01,  .2416E+00,  .4899E-01,
     +   .1286E+01,
     +   .4981E+00,  .2446E+00,  .3470E-01,  .2390E+00,  .4982E-01,
     +   .1256E+01 /
        DATA ((PARTON(I,N,44),I=1,6),N=17,24)/
     +   .4967E+00,  .2429E+00,  .3394E-01,  .2366E+00,  .5047E-01,
     +   .1227E+01,
     +   .4950E+00,  .2411E+00,  .3318E-01,  .2339E+00,  .5100E-01,
     +   .1197E+01,
     +   .4932E+00,  .2393E+00,  .3247E-01,  .2314E+00,  .5141E-01,
     +   .1168E+01,
     +   .4913E+00,  .2375E+00,  .3180E-01,  .2288E+00,  .5172E-01,
     +   .1140E+01,
     +   .4893E+00,  .2358E+00,  .3117E-01,  .2264E+00,  .5194E-01,
     +   .1113E+01,
     +   .4863E+00,  .2333E+00,  .3034E-01,  .2230E+00,  .5213E-01,
     +   .1076E+01,
     +   .4834E+00,  .2311E+00,  .2961E-01,  .2198E+00,  .5220E-01,
     +   .1044E+01,
     +   .4803E+00,  .2287E+00,  .2888E-01,  .2166E+00,  .5219E-01,
     +   .1011E+01 /
        DATA ((PARTON(I,N,44),I=1,6),N=25,27)/
     +   .4770E+00,  .2263E+00,  .2817E-01,  .2134E+00,  .5211E-01,
     +   .9790E+00,
     +   .4739E+00,  .2241E+00,  .2755E-01,  .2104E+00,  .5197E-01,
     +   .9506E+00,
     +   .4707E+00,  .2218E+00,  .2692E-01,  .2073E+00,  .5178E-01,
     +   .9220E+00 /
        DATA ((PARTON(I,N,45),I=1,6),N=1,8)/
     +   .4910E+00,  .2595E+00,  .4821E-01,  .2295E+00,  .1513E-01,
     +   .1023E+01,
     +   .5001E+00,  .2624E+00,  .4734E-01,  .2267E+00,  .1701E-01,
     +   .1086E+01,
     +   .5084E+00,  .2646E+00,  .4629E-01,  .2240E+00,  .1914E-01,
     +   .1137E+01,
     +   .5160E+00,  .2663E+00,  .4502E-01,  .2212E+00,  .2158E-01,
     +   .1177E+01,
     +   .5222E+00,  .2669E+00,  .4348E-01,  .2181E+00,  .2424E-01,
     +   .1202E+01,
     +   .5261E+00,  .2667E+00,  .4207E-01,  .2154E+00,  .2647E-01,
     +   .1210E+01,
     +   .5288E+00,  .2657E+00,  .4051E-01,  .2124E+00,  .2872E-01,
     +   .1205E+01,
     +   .5299E+00,  .2644E+00,  .3914E-01,  .2096E+00,  .3051E-01,
     +   .1190E+01 /
        DATA ((PARTON(I,N,45),I=1,6),N=9,16)/
     +   .5301E+00,  .2626E+00,  .3780E-01,  .2068E+00,  .3207E-01,
     +   .1170E+01,
     +   .5294E+00,  .2607E+00,  .3662E-01,  .2041E+00,  .3328E-01,
     +   .1147E+01,
     +   .5280E+00,  .2584E+00,  .3547E-01,  .2013E+00,  .3434E-01,
     +   .1121E+01,
     +   .5262E+00,  .2561E+00,  .3439E-01,  .1985E+00,  .3521E-01,
     +   .1093E+01,
     +   .5241E+00,  .2539E+00,  .3343E-01,  .1960E+00,  .3588E-01,
     +   .1067E+01,
     +   .5210E+00,  .2509E+00,  .3226E-01,  .1926E+00,  .3659E-01,
     +   .1032E+01,
     +   .5177E+00,  .2480E+00,  .3119E-01,  .1894E+00,  .3711E-01,
     +   .9981E+00,
     +   .5142E+00,  .2451E+00,  .3020E-01,  .1863E+00,  .3749E-01,
     +   .9654E+00 /
        DATA ((PARTON(I,N,45),I=1,6),N=17,24)/
     +   .5106E+00,  .2422E+00,  .2930E-01,  .1833E+00,  .3775E-01,
     +   .9346E+00,
     +   .5068E+00,  .2394E+00,  .2843E-01,  .1802E+00,  .3793E-01,
     +   .9037E+00,
     +   .5030E+00,  .2366E+00,  .2762E-01,  .1773E+00,  .3802E-01,
     +   .8748E+00,
     +   .4992E+00,  .2339E+00,  .2687E-01,  .1745E+00,  .3806E-01,
     +   .8472E+00,
     +   .4955E+00,  .2313E+00,  .2618E-01,  .1718E+00,  .3803E-01,
     +   .8215E+00,
     +   .4902E+00,  .2277E+00,  .2527E-01,  .1682E+00,  .3793E-01,
     +   .7875E+00,
     +   .4853E+00,  .2245E+00,  .2448E-01,  .1650E+00,  .3778E-01,
     +   .7578E+00,
     +   .4802E+00,  .2212E+00,  .2371E-01,  .1616E+00,  .3756E-01,
     +   .7284E+00 /
        DATA ((PARTON(I,N,45),I=1,6),N=25,27)/
     +   .4751E+00,  .2180E+00,  .2298E-01,  .1584E+00,  .3730E-01,
     +   .7003E+00,
     +   .4703E+00,  .2150E+00,  .2233E-01,  .1555E+00,  .3703E-01,
     +   .6756E+00,
     +   .4654E+00,  .2120E+00,  .2169E-01,  .1525E+00,  .3672E-01,
     +   .6511E+00 /
        DATA ((PARTON(I,N,46),I=1,6),N=1,8)/
     +   .5340E+00,  .2772E+00,  .4739E-01,  .1989E+00,  .1242E-01,
     +   .1021E+01,
     +   .5415E+00,  .2786E+00,  .4583E-01,  .1952E+00,  .1400E-01,
     +   .1055E+01,
     +   .5477E+00,  .2792E+00,  .4413E-01,  .1915E+00,  .1575E-01,
     +   .1077E+01,
     +   .5528E+00,  .2790E+00,  .4222E-01,  .1876E+00,  .1772E-01,
     +   .1088E+01,
     +   .5558E+00,  .2774E+00,  .4009E-01,  .1834E+00,  .1982E-01,
     +   .1084E+01,
     +   .5566E+00,  .2753E+00,  .3825E-01,  .1797E+00,  .2151E-01,
     +   .1070E+01,
     +   .5558E+00,  .2723E+00,  .3630E-01,  .1757E+00,  .2318E-01,
     +   .1045E+01,
     +   .5539E+00,  .2691E+00,  .3464E-01,  .1721E+00,  .2446E-01,
     +   .1016E+01 /
        DATA ((PARTON(I,N,46),I=1,6),N=9,16)/
     +   .5510E+00,  .2656E+00,  .3308E-01,  .1685E+00,  .2553E-01,
     +   .9843E+00,
     +   .5477E+00,  .2622E+00,  .3174E-01,  .1653E+00,  .2634E-01,
     +   .9532E+00,
     +   .5436E+00,  .2586E+00,  .3045E-01,  .1620E+00,  .2700E-01,
     +   .9207E+00,
     +   .5393E+00,  .2551E+00,  .2927E-01,  .1589E+00,  .2752E-01,
     +   .8887E+00,
     +   .5350E+00,  .2517E+00,  .2825E-01,  .1560E+00,  .2790E-01,
     +   .8592E+00,
     +   .5292E+00,  .2474E+00,  .2700E-01,  .1523E+00,  .2825E-01,
     +   .8219E+00,
     +   .5235E+00,  .2433E+00,  .2590E-01,  .1489E+00,  .2848E-01,
     +   .7873E+00,
     +   .5177E+00,  .2393E+00,  .2488E-01,  .1456E+00,  .2860E-01,
     +   .7545E+00 /
        DATA ((PARTON(I,N,46),I=1,6),N=17,24)/
     +   .5121E+00,  .2355E+00,  .2398E-01,  .1425E+00,  .2865E-01,
     +   .7245E+00,
     +   .5063E+00,  .2317E+00,  .2310E-01,  .1395E+00,  .2863E-01,
     +   .6950E+00,
     +   .5006E+00,  .2281E+00,  .2231E-01,  .1366E+00,  .2856E-01,
     +   .6679E+00,
     +   .4951E+00,  .2247E+00,  .2157E-01,  .1338E+00,  .2845E-01,
     +   .6424E+00,
     +   .4898E+00,  .2214E+00,  .2090E-01,  .1312E+00,  .2831E-01,
     +   .6190E+00,
     +   .4825E+00,  .2170E+00,  .2003E-01,  .1277E+00,  .2807E-01,
     +   .5886E+00,
     +   .4759E+00,  .2131E+00,  .1929E-01,  .1246E+00,  .2782E-01,
     +   .5624E+00,
     +   .4691E+00,  .2091E+00,  .1856E-01,  .1215E+00,  .2752E-01,
     +   .5368E+00 /
        DATA ((PARTON(I,N,46),I=1,6),N=25,27)/
     +   .4624E+00,  .2052E+00,  .1788E-01,  .1185E+00,  .2720E-01,
     +   .5127E+00,
     +   .4563E+00,  .2017E+00,  .1729E-01,  .1159E+00,  .2688E-01,
     +   .4917E+00,
     +   .4500E+00,  .1982E+00,  .1670E-01,  .1132E+00,  .2654E-01,
     +   .4712E+00 /
        DATA ((PARTON(I,N,47),I=1,6),N=1,8)/
     +   .5702E+00,  .2901E+00,  .4382E-01,  .1707E+00,  .9869E-02,
     +   .1002E+01,
     +   .5753E+00,  .2898E+00,  .4181E-01,  .1664E+00,  .1125E-01,
     +   .1012E+01,
     +   .5789E+00,  .2885E+00,  .3972E-01,  .1622E+00,  .1276E-01,
     +   .1012E+01,
     +   .5807E+00,  .2861E+00,  .3746E-01,  .1578E+00,  .1439E-01,
     +   .9996E+00,
     +   .5798E+00,  .2823E+00,  .3504E-01,  .1530E+00,  .1608E-01,
     +   .9750E+00,
     +   .5772E+00,  .2782E+00,  .3302E-01,  .1488E+00,  .1741E-01,
     +   .9455E+00,
     +   .5726E+00,  .2731E+00,  .3092E-01,  .1444E+00,  .1866E-01,
     +   .9068E+00,
     +   .5675E+00,  .2682E+00,  .2919E-01,  .1405E+00,  .1958E-01,
     +   .8694E+00 /
        DATA ((PARTON(I,N,47),I=1,6),N=9,16)/
     +   .5615E+00,  .2631E+00,  .2758E-01,  .1366E+00,  .2032E-01,
     +   .8307E+00,
     +   .5554E+00,  .2584E+00,  .2624E-01,  .1332E+00,  .2085E-01,
     +   .7954E+00,
     +   .5487E+00,  .2535E+00,  .2497E-01,  .1298E+00,  .2127E-01,
     +   .7600E+00,
     +   .5420E+00,  .2488E+00,  .2382E-01,  .1266E+00,  .2156E-01,
     +   .7264E+00,
     +   .5356E+00,  .2445E+00,  .2283E-01,  .1237E+00,  .2175E-01,
     +   .6963E+00,
     +   .5273E+00,  .2391E+00,  .2164E-01,  .1201E+00,  .2189E-01,
     +   .6592E+00,
     +   .5193E+00,  .2340E+00,  .2060E-01,  .1168E+00,  .2194E-01,
     +   .6257E+00,
     +   .5114E+00,  .2291E+00,  .1966E-01,  .1136E+00,  .2192E-01,
     +   .5945E+00 /
        DATA ((PARTON(I,N,47),I=1,6),N=17,24)/
     +   .5039E+00,  .2246E+00,  .1882E-01,  .1107E+00,  .2185E-01,
     +   .5665E+00,
     +   .4963E+00,  .2201E+00,  .1802E-01,  .1078E+00,  .2173E-01,
     +   .5394E+00,
     +   .4891E+00,  .2159E+00,  .1731E-01,  .1051E+00,  .2158E-01,
     +   .5149E+00,
     +   .4821E+00,  .2118E+00,  .1665E-01,  .1025E+00,  .2140E-01,
     +   .4921E+00,
     +   .4755E+00,  .2080E+00,  .1605E-01,  .1001E+00,  .2121E-01,
     +   .4715E+00,
     +   .4665E+00,  .2030E+00,  .1528E-01,  .9698E-01,  .2093E-01,
     +   .4449E+00,
     +   .4585E+00,  .1986E+00,  .1463E-01,  .9422E-01,  .2064E-01,
     +   .4223E+00,
     +   .4503E+00,  .1941E+00,  .1400E-01,  .9147E-01,  .2033E-01,
     +   .4005E+00 /
        DATA ((PARTON(I,N,47),I=1,6),N=25,27)/
     +   .4423E+00,  .1898E+00,  .1342E-01,  .8884E-01,  .2000E-01,
     +   .3801E+00,
     +   .4351E+00,  .1860E+00,  .1291E-01,  .8650E-01,  .1969E-01,
     +   .3626E+00,
     +   .4278E+00,  .1821E+00,  .1241E-01,  .8416E-01,  .1936E-01,
     +   .3456E+00 /
        DATA ((PARTON(I,N,48),I=1,6),N=1,8)/
     +   .5999E+00,  .2986E+00,  .3858E-01,  .1446E+00,  .7489E-02,
     +   .9676E+00,
     +   .6020E+00,  .2963E+00,  .3638E-01,  .1402E+00,  .8750E-02,
     +   .9585E+00,
     +   .6023E+00,  .2930E+00,  .3414E-01,  .1359E+00,  .1008E-01,
     +   .9402E+00,
     +   .6003E+00,  .2884E+00,  .3178E-01,  .1313E+00,  .1148E-01,
     +   .9112E+00,
     +   .5952E+00,  .2822E+00,  .2932E-01,  .1263E+00,  .1287E-01,
     +   .8713E+00,
     +   .5889E+00,  .2762E+00,  .2732E-01,  .1221E+00,  .1392E-01,
     +   .8314E+00,
     +   .5805E+00,  .2691E+00,  .2528E-01,  .1176E+00,  .1488E-01,
     +   .7844E+00,
     +   .5720E+00,  .2627E+00,  .2363E-01,  .1137E+00,  .1556E-01,
     +   .7419E+00 /
        DATA ((PARTON(I,N,48),I=1,6),N=9,16)/
     +   .5629E+00,  .2562E+00,  .2212E-01,  .1099E+00,  .1608E-01,
     +   .7001E+00,
     +   .5542E+00,  .2503E+00,  .2087E-01,  .1066E+00,  .1642E-01,
     +   .6633E+00,
     +   .5451E+00,  .2444E+00,  .1971E-01,  .1033E+00,  .1667E-01,
     +   .6274E+00,
     +   .5361E+00,  .2387E+00,  .1868E-01,  .1002E+00,  .1682E-01,
     +   .5941E+00,
     +   .5278E+00,  .2336E+00,  .1779E-01,  .9749E-01,  .1690E-01,
     +   .5649E+00,
     +   .5172E+00,  .2273E+00,  .1674E-01,  .9411E-01,  .1692E-01,
     +   .5296E+00,
     +   .5072E+00,  .2214E+00,  .1583E-01,  .9101E-01,  .1687E-01,
     +   .4983E+00,
     +   .4975E+00,  .2159E+00,  .1501E-01,  .8811E-01,  .1678E-01,
     +   .4697E+00 /
        DATA ((PARTON(I,N,48),I=1,6),N=17,24)/
     +   .4884E+00,  .2108E+00,  .1429E-01,  .8546E-01,  .1665E-01,
     +   .4443E+00,
     +   .4793E+00,  .2057E+00,  .1360E-01,  .8286E-01,  .1648E-01,
     +   .4201E+00,
     +   .4708E+00,  .2011E+00,  .1299E-01,  .8046E-01,  .1630E-01,
     +   .3984E+00,
     +   .4625E+00,  .1966E+00,  .1243E-01,  .7819E-01,  .1611E-01,
     +   .3785E+00,
     +   .4548E+00,  .1925E+00,  .1193E-01,  .7610E-01,  .1590E-01,
     +   .3606E+00,
     +   .4445E+00,  .1871E+00,  .1130E-01,  .7336E-01,  .1561E-01,
     +   .3379E+00,
     +   .4353E+00,  .1823E+00,  .1076E-01,  .7097E-01,  .1533E-01,
     +   .3187E+00,
     +   .4261E+00,  .1776E+00,  .1025E-01,  .6862E-01,  .1504E-01,
     +   .3004E+00 /
        DATA ((PARTON(I,N,48),I=1,6),N=25,27)/
     +   .4171E+00,  .1730E+00,  .9767E-02,  .6637E-01,  .1473E-01,
     +   .2835E+00,
     +   .4091E+00,  .1690E+00,  .9357E-02,  .6440E-01,  .1445E-01,
     +   .2690E+00,
     +   .4010E+00,  .1650E+00,  .8957E-02,  .6243E-01,  .1416E-01,
     +   .2551E+00 /
        DATA ((PARTON(I,N,49),I=1,6),N=1,8)/
     +   .6230E+00,  .3027E+00,  .3259E-01,  .1207E+00,  .5292E-02,
     +   .9198E+00,
     +   .6217E+00,  .2984E+00,  .3040E-01,  .1165E+00,  .6473E-02,
     +   .8957E+00,
     +   .6182E+00,  .2930E+00,  .2822E-01,  .1123E+00,  .7674E-02,
     +   .8638E+00,
     +   .6122E+00,  .2863E+00,  .2595E-01,  .1078E+00,  .8904E-02,
     +   .8226E+00,
     +   .6027E+00,  .2779E+00,  .2365E-01,  .1030E+00,  .1008E-01,
     +   .7724E+00,
     +   .5927E+00,  .2701E+00,  .2181E-01,  .9898E-01,  .1094E-01,
     +   .7260E+00,
     +   .5804E+00,  .2613E+00,  .1996E-01,  .9465E-01,  .1170E-01,
     +   .6745E+00,
     +   .5687E+00,  .2535E+00,  .1848E-01,  .9096E-01,  .1221E-01,
     +   .6299E+00 /
        DATA ((PARTON(I,N,49),I=1,6),N=9,16)/
     +   .5567E+00,  .2458E+00,  .1716E-01,  .8743E-01,  .1257E-01,
     +   .5874E+00,
     +   .5456E+00,  .2389E+00,  .1607E-01,  .8436E-01,  .1280E-01,
     +   .5509E+00,
     +   .5342E+00,  .2321E+00,  .1507E-01,  .8137E-01,  .1294E-01,
     +   .5161E+00,
     +   .5233E+00,  .2258E+00,  .1418E-01,  .7858E-01,  .1301E-01,
     +   .4844E+00,
     +   .5132E+00,  .2201E+00,  .1343E-01,  .7611E-01,  .1302E-01,
     +   .4570E+00,
     +   .5006E+00,  .2130E+00,  .1255E-01,  .7308E-01,  .1298E-01,
     +   .4245E+00,
     +   .4889E+00,  .2066E+00,  .1179E-01,  .7034E-01,  .1288E-01,
     +   .3960E+00,
     +   .4777E+00,  .2006E+00,  .1112E-01,  .6779E-01,  .1276E-01,
     +   .3705E+00 /
        DATA ((PARTON(I,N,49),I=1,6),N=17,24)/
     +   .4673E+00,  .1951E+00,  .1053E-01,  .6547E-01,  .1261E-01,
     +   .3480E+00,
     +   .4570E+00,  .1897E+00,  .9970E-02,  .6321E-01,  .1243E-01,
     +   .3268E+00,
     +   .4474E+00,  .1848E+00,  .9478E-02,  .6115E-01,  .1225E-01,
     +   .3081E+00,
     +   .4382E+00,  .1801E+00,  .9029E-02,  .5921E-01,  .1206E-01,
     +   .2910E+00,
     +   .4297E+00,  .1758E+00,  .8630E-02,  .5743E-01,  .1187E-01,
     +   .2758E+00,
     +   .4184E+00,  .1701E+00,  .8123E-02,  .5511E-01,  .1160E-01,
     +   .2566E+00,
     +   .4084E+00,  .1652E+00,  .7700E-02,  .5311E-01,  .1135E-01,
     +   .2406E+00,
     +   .3984E+00,  .1604E+00,  .7296E-02,  .5115E-01,  .1108E-01,
     +   .2254E+00 /
        DATA ((PARTON(I,N,49),I=1,6),N=25,27)/
     +   .3887E+00,  .1557E+00,  .6924E-02,  .4929E-01,  .1082E-01,
     +   .2116E+00,
     +   .3802E+00,  .1516E+00,  .6605E-02,  .4766E-01,  .1058E-01,
     +   .1998E+00,
     +   .3716E+00,  .1476E+00,  .6298E-02,  .4605E-01,  .1033E-01,
     +   .1885E+00 /
        DATA ((PARTON(I,N,50),I=1,6),N=1,8)/
     +   .6397E+00,  .3028E+00,  .2655E-01,  .9903E-01,  .3289E-02,
     +   .8609E+00,
     +   .6346E+00,  .2965E+00,  .2453E-01,  .9516E-01,  .4420E-02,
     +   .8254E+00,
     +   .6272E+00,  .2891E+00,  .2253E-01,  .9128E-01,  .5534E-02,
     +   .7838E+00,
     +   .6168E+00,  .2803E+00,  .2050E-01,  .8717E-01,  .6640E-02,
     +   .7345E+00,
     +   .6029E+00,  .2700E+00,  .1847E-01,  .8281E-01,  .7663E-02,
     +   .6780E+00,
     +   .5893E+00,  .2607E+00,  .1686E-01,  .7910E-01,  .8387E-02,
     +   .6283E+00,
     +   .5733E+00,  .2504E+00,  .1528E-01,  .7518E-01,  .9000E-02,
     +   .5753E+00,
     +   .5587E+00,  .2414E+00,  .1403E-01,  .7185E-01,  .9394E-02,
     +   .5308E+00 /
        DATA ((PARTON(I,N,50),I=1,6),N=9,16)/
     +   .5441E+00,  .2327E+00,  .1292E-01,  .6869E-01,  .9666E-02,
     +   .4894E+00,
     +   .5308E+00,  .2251E+00,  .1202E-01,  .6596E-01,  .9821E-02,
     +   .4546E+00,
     +   .5174E+00,  .2177E+00,  .1119E-01,  .6333E-01,  .9903E-02,
     +   .4219E+00,
     +   .5047E+00,  .2108E+00,  .1047E-01,  .6089E-01,  .9926E-02,
     +   .3926E+00,
     +   .4933E+00,  .2047E+00,  .9862E-02,  .5874E-01,  .9906E-02,
     +   .3677E+00,
     +   .4790E+00,  .1972E+00,  .9156E-02,  .5612E-01,  .9833E-02,
     +   .3384E+00,
     +   .4659E+00,  .1904E+00,  .8552E-02,  .5377E-01,  .9725E-02,
     +   .3132E+00,
     +   .4535E+00,  .1841E+00,  .8016E-02,  .5160E-01,  .9592E-02,
     +   .2907E+00 /
        DATA ((PARTON(I,N,50),I=1,6),N=17,24)/
     +   .4421E+00,  .1784E+00,  .7552E-02,  .4964E-01,  .9447E-02,
     +   .2713E+00,
     +   .4309E+00,  .1728E+00,  .7118E-02,  .4774E-01,  .9283E-02,
     +   .2531E+00,
     +   .4205E+00,  .1678E+00,  .6736E-02,  .4601E-01,  .9117E-02,
     +   .2372E+00,
     +   .4106E+00,  .1630E+00,  .6389E-02,  .4440E-01,  .8946E-02,
     +   .2227E+00,
     +   .4015E+00,  .1586E+00,  .6082E-02,  .4293E-01,  .8779E-02,
     +   .2100E+00,
     +   .3894E+00,  .1529E+00,  .5695E-02,  .4102E-01,  .8545E-02,
     +   .1941E+00,
     +   .3789E+00,  .1480E+00,  .5373E-02,  .3939E-01,  .8329E-02,
     +   .1810E+00,
     +   .3684E+00,  .1431E+00,  .5069E-02,  .3779E-01,  .8106E-02,
     +   .1686E+00 /
        DATA ((PARTON(I,N,50),I=1,6),N=25,27)/
     +   .3584E+00,  .1385E+00,  .4789E-02,  .3628E-01,  .7886E-02,
     +   .1573E+00,
     +   .3495E+00,  .1345E+00,  .4551E-02,  .3497E-01,  .7685E-02,
     +   .1479E+00,
     +   .3407E+00,  .1305E+00,  .4322E-02,  .3368E-01,  .7481E-02,
     +   .1389E+00 /
        DATA ((PARTON(I,N,51),I=1,6),N=1,8)/
     +   .6499E+00,  .2992E+00,  .2094E-01,  .7962E-01,  .1489E-02,
     +   .7934E+00,
     +   .6408E+00,  .2909E+00,  .1916E-01,  .7624E-01,  .2587E-02,
     +   .7499E+00,
     +   .6294E+00,  .2817E+00,  .1744E-01,  .7285E-01,  .3640E-02,
     +   .7020E+00,
     +   .6149E+00,  .2711E+00,  .1571E-01,  .6925E-01,  .4657E-02,
     +   .6480E+00,
     +   .5967E+00,  .2591E+00,  .1400E-01,  .6542E-01,  .5570E-02,
     +   .5885E+00,
     +   .5796E+00,  .2484E+00,  .1266E-01,  .6218E-01,  .6199E-02,
     +   .5381E+00,
     +   .5602E+00,  .2369E+00,  .1136E-01,  .5877E-01,  .6717E-02,
     +   .4858E+00,
     +   .5430E+00,  .2271E+00,  .1035E-01,  .5588E-01,  .7040E-02,
     +   .4430E+00 /
        DATA ((PARTON(I,N,51),I=1,6),N=9,16)/
     +   .5260E+00,  .2177E+00,  .9457E-02,  .5316E-01,  .7254E-02,
     +   .4040E+00,
     +   .5108E+00,  .2096E+00,  .8741E-02,  .5083E-01,  .7369E-02,
     +   .3718E+00,
     +   .4958E+00,  .2017E+00,  .8092E-02,  .4858E-01,  .7422E-02,
     +   .3419E+00,
     +   .4817E+00,  .1945E+00,  .7526E-02,  .4652E-01,  .7425E-02,
     +   .3155E+00,
     +   .4691E+00,  .1881E+00,  .7053E-02,  .4471E-01,  .7395E-02,
     +   .2933E+00,
     +   .4535E+00,  .1804E+00,  .6507E-02,  .4252E-01,  .7320E-02,
     +   .2675E+00,
     +   .4393E+00,  .1734E+00,  .6043E-02,  .4056E-01,  .7218E-02,
     +   .2456E+00,
     +   .4260E+00,  .1670E+00,  .5635E-02,  .3877E-01,  .7098E-02,
     +   .2264E+00 /
        DATA ((PARTON(I,N,51),I=1,6),N=17,24)/
     +   .4139E+00,  .1613E+00,  .5283E-02,  .3716E-01,  .6970E-02,
     +   .2098E+00,
     +   .4020E+00,  .1557E+00,  .4956E-02,  .3560E-01,  .6829E-02,
     +   .1945E+00,
     +   .3911E+00,  .1506E+00,  .4670E-02,  .3420E-01,  .6688E-02,
     +   .1812E+00,
     +   .3808E+00,  .1459E+00,  .4411E-02,  .3289E-01,  .6544E-02,
     +   .1692E+00,
     +   .3713E+00,  .1416E+00,  .4183E-02,  .3171E-01,  .6405E-02,
     +   .1587E+00,
     +   .3589E+00,  .1359E+00,  .3898E-02,  .3018E-01,  .6212E-02,
     +   .1458E+00,
     +   .3481E+00,  .1311E+00,  .3662E-02,  .2887E-01,  .6036E-02,
     +   .1351E+00,
     +   .3374E+00,  .1264E+00,  .3439E-02,  .2760E-01,  .5856E-02,
     +   .1251E+00 /
        DATA ((PARTON(I,N,51),I=1,6),N=25,27)/
     +   .3272E+00,  .1219E+00,  .3236E-02,  .2641E-01,  .5679E-02,
     +   .1162E+00,
     +   .3182E+00,  .1181E+00,  .3064E-02,  .2538E-01,  .5519E-02,
     +   .1087E+00,
     +   .3093E+00,  .1142E+00,  .2899E-02,  .2437E-01,  .5357E-02,
     +   .1016E+00 /
        DATA ((PARTON(I,N,52),I=1,6),N=1,8)/
     +   .6538E+00,  .2921E+00,  .1602E-01,  .6248E-01,  .0000E+00,
     +   .7197E+00,
     +   .6408E+00,  .2822E+00,  .1453E-01,  .5968E-01,  .9705E-03,
     +   .6713E+00,
     +   .6254E+00,  .2713E+00,  .1311E-01,  .5685E-01,  .1980E-02,
     +   .6201E+00,
     +   .6067E+00,  .2592E+00,  .1169E-01,  .5385E-01,  .2934E-02,
     +   .5641E+00,
     +   .5845E+00,  .2457E+00,  .1032E-01,  .5064E-01,  .3772E-02,
     +   .5045E+00,
     +   .5644E+00,  .2341E+00,  .9253E-02,  .4793E-01,  .4337E-02,
     +   .4553E+00,
     +   .5420E+00,  .2217E+00,  .8228E-02,  .4507E-01,  .4795E-02,
     +   .4054E+00,
     +   .5224E+00,  .2112E+00,  .7436E-02,  .4267E-01,  .5077E-02,
     +   .3655E+00 /
        DATA ((PARTON(I,N,52),I=1,6),N=9,16)/
     +   .5034E+00,  .2014E+00,  .6745E-02,  .4041E-01,  .5261E-02,
     +   .3298E+00,
     +   .4867E+00,  .1929E+00,  .6196E-02,  .3848E-01,  .5359E-02,
     +   .3006E+00,
     +   .4704E+00,  .1848E+00,  .5702E-02,  .3664E-01,  .5402E-02,
     +   .2740E+00,
     +   .4552E+00,  .1774E+00,  .5274E-02,  .3495E-01,  .5405E-02,
     +   .2507E+00,
     +   .4417E+00,  .1710E+00,  .4918E-02,  .3347E-01,  .5379E-02,
     +   .2314E+00,
     +   .4252E+00,  .1632E+00,  .4511E-02,  .3169E-01,  .5317E-02,
     +   .2092E+00,
     +   .4103E+00,  .1562E+00,  .4166E-02,  .3011E-01,  .5234E-02,
     +   .1905E+00,
     +   .3964E+00,  .1499E+00,  .3865E-02,  .2867E-01,  .5136E-02,
     +   .1743E+00 /
        DATA ((PARTON(I,N,52),I=1,6),N=17,24)/
     +   .3838E+00,  .1442E+00,  .3608E-02,  .2739E-01,  .5033E-02,
     +   .1604E+00,
     +   .3716E+00,  .1387E+00,  .3369E-02,  .2615E-01,  .4920E-02,
     +   .1477E+00,
     +   .3604E+00,  .1338E+00,  .3161E-02,  .2504E-01,  .4807E-02,
     +   .1368E+00,
     +   .3498E+00,  .1292E+00,  .2974E-02,  .2401E-01,  .4694E-02,
     +   .1271E+00,
     +   .3402E+00,  .1250E+00,  .2811E-02,  .2308E-01,  .4584E-02,
     +   .1186E+00,
     +   .3276E+00,  .1196E+00,  .2606E-02,  .2188E-01,  .4433E-02,
     +   .1082E+00,
     +   .3168E+00,  .1150E+00,  .2438E-02,  .2086E-01,  .4296E-02,
     +   .9971E-01,
     +   .3061E+00,  .1105E+00,  .2281E-02,  .1988E-01,  .4156E-02,
     +   .9182E-01 /
        DATA ((PARTON(I,N,52),I=1,6),N=25,27)/
     +   .2960E+00,  .1062E+00,  .2137E-02,  .1896E-01,  .4019E-02,
     +   .8477E-01,
     +   .2871E+00,  .1026E+00,  .2016E-02,  .1817E-01,  .3896E-02,
     +   .7892E-01,
     +   .2783E+00,  .9894E-01,  .1901E-02,  .1739E-01,  .3773E-02,
     +   .7342E-01 /
        DATA ((PARTON(I,N,53),I=1,6),N=1,8)/
     +   .6516E+00,  .2820E+00,  .1190E-01,  .4755E-01,  .0000E+00,
     +   .6423E+00,
     +   .6347E+00,  .2706E+00,  .1071E-01,  .4538E-01,  .0000E+00,
     +   .5917E+00,
     +   .6155E+00,  .2584E+00,  .9584E-02,  .4316E-01,  .5425E-03,
     +   .5394E+00,
     +   .5931E+00,  .2450E+00,  .8470E-02,  .4079E-01,  .1454E-02,
     +   .4840E+00,
     +   .5672E+00,  .2305E+00,  .7400E-02,  .3824E-01,  .2241E-02,
     +   .4263E+00,
     +   .5443E+00,  .2181E+00,  .6583E-02,  .3607E-01,  .2766E-02,
     +   .3798E+00,
     +   .5193E+00,  .2051E+00,  .5803E-02,  .3378E-01,  .3191E-02,
     +   .3337E+00,
     +   .4978E+00,  .1943E+00,  .5206E-02,  .3186E-01,  .3453E-02,
     +   .2974E+00 /
        DATA ((PARTON(I,N,53),I=1,6),N=9,16)/
     +   .4772E+00,  .1842E+00,  .4689E-02,  .3006E-01,  .3627E-02,
     +   .2654E+00,
     +   .4594E+00,  .1757E+00,  .4282E-02,  .2852E-01,  .3722E-02,
     +   .2397E+00,
     +   .4421E+00,  .1675E+00,  .3918E-02,  .2706E-01,  .3770E-02,
     +   .2164E+00,
     +   .4261E+00,  .1602E+00,  .3605E-02,  .2572E-01,  .3783E-02,
     +   .1964E+00,
     +   .4120E+00,  .1537E+00,  .3346E-02,  .2456E-01,  .3771E-02,
     +   .1799E+00,
     +   .3949E+00,  .1461E+00,  .3051E-02,  .2316E-01,  .3730E-02,
     +   .1612E+00,
     +   .3795E+00,  .1393E+00,  .2803E-02,  .2193E-01,  .3672E-02,
     +   .1456E+00,
     +   .3654E+00,  .1331E+00,  .2588E-02,  .2080E-01,  .3601E-02,
     +   .1322E+00 /
        DATA ((PARTON(I,N,53),I=1,6),N=17,24)/
     +   .3526E+00,  .1276E+00,  .2405E-02,  .1981E-01,  .3526E-02,
     +   .1208E+00,
     +   .3402E+00,  .1223E+00,  .2236E-02,  .1885E-01,  .3443E-02,
     +   .1105E+00,
     +   .3290E+00,  .1176E+00,  .2090E-02,  .1800E-01,  .3360E-02,
     +   .1017E+00,
     +   .3184E+00,  .1132E+00,  .1959E-02,  .1721E-01,  .3276E-02,
     +   .9396E-01,
     +   .3089E+00,  .1092E+00,  .1844E-02,  .1650E-01,  .3195E-02,
     +   .8725E-01,
     +   .2964E+00,  .1041E+00,  .1702E-02,  .1558E-01,  .3083E-02,
     +   .7905E-01,
     +   .2857E+00,  .9977E-01,  .1586E-02,  .1481E-01,  .2982E-02,
     +   .7242E-01,
     +   .2752E+00,  .9556E-01,  .1478E-02,  .1407E-01,  .2878E-02,
     +   .6629E-01 /
        DATA ((PARTON(I,N,53),I=1,6),N=25,27)/
     +   .2653E+00,  .9161E-01,  .1380E-02,  .1338E-01,  .2777E-02,
     +   .6085E-01,
     +   .2567E+00,  .8820E-01,  .1297E-02,  .1278E-01,  .2687E-02,
     +   .5637E-01,
     +   .2481E+00,  .8485E-01,  .1219E-02,  .1220E-01,  .2596E-02,
     +   .5219E-01 /
        DATA ((PARTON(I,N,54),I=1,6),N=1,8)/
     +   .6436E+00,  .2693E+00,  .8599E-02,  .3477E-01,  .0000E+00,
     +   .5634E+00,
     +   .6230E+00,  .2566E+00,  .7681E-02,  .3322E-01,  .0000E+00,
     +   .5127E+00,
     +   .6003E+00,  .2434E+00,  .6816E-02,  .3162E-01,  .0000E+00,
     +   .4616E+00,
     +   .5744E+00,  .2291E+00,  .5971E-02,  .2987E-01,  .2000E-03,
     +   .4085E+00,
     +   .5454E+00,  .2138E+00,  .5169E-02,  .2796E-01,  .9545E-03,
     +   .3545E+00,
     +   .5201E+00,  .2010E+00,  .4562E-02,  .2633E-01,  .1457E-02,
     +   .3117E+00,
     +   .4931E+00,  .1878E+00,  .3987E-02,  .2459E-01,  .1867E-02,
     +   .2701E+00,
     +   .4701E+00,  .1769E+00,  .3552E-02,  .2313E-01,  .2124E-02,
     +   .2380E+00 /
        DATA ((PARTON(I,N,54),I=1,6),N=9,16)/
     +   .4483E+00,  .1667E+00,  .3178E-02,  .2175E-01,  .2301E-02,
     +   .2101E+00,
     +   .4296E+00,  .1583E+00,  .2885E-02,  .2058E-01,  .2404E-02,
     +   .1879E+00,
     +   .4117E+00,  .1503E+00,  .2625E-02,  .1947E-01,  .2465E-02,
     +   .1680E+00,
     +   .3952E+00,  .1430E+00,  .2403E-02,  .1845E-01,  .2493E-02,
     +   .1511E+00,
     +   .3808E+00,  .1368E+00,  .2220E-02,  .1757E-01,  .2499E-02,
     +   .1373E+00,
     +   .3634E+00,  .1294E+00,  .2013E-02,  .1651E-01,  .2484E-02,
     +   .1219E+00,
     +   .3480E+00,  .1229E+00,  .1841E-02,  .1558E-01,  .2453E-02,
     +   .1091E+00,
     +   .3337E+00,  .1170E+00,  .1691E-02,  .1474E-01,  .2411E-02,
     +   .9828E-01 /
        DATA ((PARTON(I,N,54),I=1,6),N=17,24)/
     +   .3210E+00,  .1118E+00,  .1565E-02,  .1399E-01,  .2363E-02,
     +   .8922E-01,
     +   .3087E+00,  .1068E+00,  .1449E-02,  .1328E-01,  .2309E-02,
     +   .8105E-01,
     +   .2976E+00,  .1023E+00,  .1349E-02,  .1264E-01,  .2254E-02,
     +   .7411E-01,
     +   .2873E+00,  .9818E-01,  .1260E-02,  .1205E-01,  .2198E-02,
     +   .6803E-01,
     +   .2779E+00,  .9448E-01,  .1182E-02,  .1153E-01,  .2143E-02,
     +   .6283E-01,
     +   .2657E+00,  .8972E-01,  .1086E-02,  .1086E-01,  .2067E-02,
     +   .5652E-01,
     +   .2553E+00,  .8570E-01,  .1008E-02,  .1029E-01,  .1997E-02,
     +   .5145E-01,
     +   .2452E+00,  .8182E-01,  .9354E-03,  .9745E-02,  .1925E-02,
     +   .4679E-01 /
        DATA ((PARTON(I,N,54),I=1,6),N=25,27)/
     +   .2357E+00,  .7820E-01,  .8700E-03,  .9240E-02,  .1855E-02,
     +   .4270E-01,
     +   .2274E+00,  .7508E-01,  .8152E-03,  .8806E-02,  .1793E-02,
     +   .3934E-01,
     +   .2193E+00,  .7204E-01,  .7634E-03,  .8386E-02,  .1730E-02,
     +   .3624E-01 /
        DATA ((PARTON(I,N,55),I=1,6),N=1,8)/
     +   .6301E+00,  .2543E+00,  .6041E-02,  .2401E-01,  .0000E+00,
     +   .4849E+00,
     +   .6060E+00,  .2408E+00,  .5357E-02,  .2306E-01,  .0000E+00,
     +   .4360E+00,
     +   .5802E+00,  .2268E+00,  .4717E-02,  .2204E-01,  .0000E+00,
     +   .3876E+00,
     +   .5514E+00,  .2119E+00,  .4098E-02,  .2089E-01,  .0000E+00,
     +   .3384E+00,
     +   .5197E+00,  .1963E+00,  .3515E-02,  .1959E-01,  .0000E+00,
     +   .2891E+00,
     +   .4926E+00,  .1833E+00,  .3079E-02,  .1845E-01,  .3846E-03,
     +   .2509E+00,
     +   .4639E+00,  .1701E+00,  .2669E-02,  .1722E-01,  .7908E-03,
     +   .2143E+00,
     +   .4399E+00,  .1593E+00,  .2361E-02,  .1617E-01,  .1052E-02,
     +   .1866E+00 /
        DATA ((PARTON(I,N,55),I=1,6),N=9,16)/
     +   .4174E+00,  .1493E+00,  .2099E-02,  .1519E-01,  .1240E-02,
     +   .1628E+00,
     +   .3982E+00,  .1411E+00,  .1895E-02,  .1435E-01,  .1357E-02,
     +   .1441E+00,
     +   .3799E+00,  .1333E+00,  .1715E-02,  .1354E-01,  .1434E-02,
     +   .1276E+00,
     +   .3633E+00,  .1264E+00,  .1562E-02,  .1280E-01,  .1482E-02,
     +   .1137E+00,
     +   .3488E+00,  .1205E+00,  .1437E-02,  .1216E-01,  .1508E-02,
     +   .1024E+00,
     +   .3315E+00,  .1134E+00,  .1296E-02,  .1140E-01,  .1520E-02,
     +   .8993E-01,
     +   .3161E+00,  .1073E+00,  .1179E-02,  .1073E-01,  .1515E-02,
     +   .7979E-01,
     +   .3021E+00,  .1017E+00,  .1078E-02,  .1012E-01,  .1500E-02,
     +   .7122E-01 /
        DATA ((PARTON(I,N,55),I=1,6),N=17,24)/
     +   .2896E+00,  .9685E-01,  .9934E-03,  .9585E-02,  .1478E-02,
     +   .6414E-01,
     +   .2776E+00,  .9222E-01,  .9159E-03,  .9075E-02,  .1451E-02,
     +   .5782E-01,
     +   .2668E+00,  .8808E-01,  .8494E-03,  .8620E-02,  .1421E-02,
     +   .5250E-01,
     +   .2568E+00,  .8428E-01,  .7904E-03,  .8202E-02,  .1388E-02,
     +   .4787E-01,
     +   .2478E+00,  .8087E-01,  .7392E-03,  .7828E-02,  .1356E-02,
     +   .4394E-01,
     +   .2361E+00,  .7653E-01,  .6762E-03,  .7351E-02,  .1311E-02,
     +   .3922E-01,
     +   .2262E+00,  .7286E-01,  .6252E-03,  .6950E-02,  .1268E-02,
     +   .3544E-01,
     +   .2166E+00,  .6934E-01,  .5779E-03,  .6564E-02,  .1223E-02,
     +   .3200E-01 /
        DATA ((PARTON(I,N,55),I=1,6),N=25,27)/
     +   .2076E+00,  .6607E-01,  .5356E-03,  .6208E-02,  .1179E-02,
     +   .2900E-01,
     +   .1997E+00,  .6326E-01,  .5002E-03,  .5903E-02,  .1139E-02,
     +   .2657E-01,
     +   .1921E+00,  .6053E-01,  .4669E-03,  .5608E-02,  .1099E-02,
     +   .2433E-01 /
        DATA ((PARTON(I,N,56),I=1,6),N=1,8)/
     +   .6114E+00,  .2376E+00,  .4126E-02,  .1513E-01,  .0000E+00,
     +   .4086E+00,
     +   .5844E+00,  .2234E+00,  .3633E-02,  .1473E-01,  .0000E+00,
     +   .3630E+00,
     +   .5559E+00,  .2091E+00,  .3175E-02,  .1424E-01,  .0000E+00,
     +   .3186E+00,
     +   .5246E+00,  .1939E+00,  .2736E-02,  .1364E-01,  .0000E+00,
     +   .2743E+00,
     +   .4909E+00,  .1782E+00,  .2327E-02,  .1288E-01,  .0000E+00,
     +   .2306E+00,
     +   .4624E+00,  .1654E+00,  .2023E-02,  .1218E-01,  .0000E+00,
     +   .1973E+00,
     +   .4326E+00,  .1524E+00,  .1740E-02,  .1140E-01,  .0000E+00,
     +   .1660E+00,
     +   .4080E+00,  .1419E+00,  .1529E-02,  .1073E-01,  .2057E-03,
     +   .1426E+00 /
        DATA ((PARTON(I,N,56),I=1,6),N=9,16)/
     +   .3851E+00,  .1323E+00,  .1350E-02,  .1008E-01,  .4076E-03,
     +   .1229E+00,
     +   .3657E+00,  .1244E+00,  .1212E-02,  .9521E-02,  .5403E-03,
     +   .1075E+00,
     +   .3475E+00,  .1171E+00,  .1091E-02,  .8977E-02,  .6363E-03,
     +   .9411E-01,
     +   .3310E+00,  .1105E+00,  .9891E-03,  .8480E-02,  .7036E-03,
     +   .8295E-01,
     +   .3167E+00,  .1049E+00,  .9059E-03,  .8048E-02,  .7481E-03,
     +   .7402E-01,
     +   .2996E+00,  .9837E-01,  .8126E-03,  .7531E-02,  .7857E-03,
     +   .6424E-01,
     +   .2846E+00,  .9266E-01,  .7357E-03,  .7076E-02,  .8061E-03,
     +   .5638E-01,
     +   .2710E+00,  .8754E-01,  .6699E-03,  .6664E-02,  .8151E-03,
     +   .4982E-01 /
        DATA ((PARTON(I,N,56),I=1,6),N=17,24)/
     +   .2590E+00,  .8305E-01,  .6146E-03,  .6300E-02,  .8160E-03,
     +   .4446E-01,
     +   .2474E+00,  .7880E-01,  .5644E-03,  .5955E-02,  .8112E-03,
     +   .3971E-01,
     +   .2371E+00,  .7503E-01,  .5214E-03,  .5647E-02,  .8025E-03,
     +   .3575E-01,
     +   .2275E+00,  .7158E-01,  .4835E-03,  .5364E-02,  .7910E-03,
     +   .3235E-01,
     +   .2189E+00,  .6850E-01,  .4507E-03,  .5111E-02,  .7779E-03,
     +   .2948E-01,
     +   .2079E+00,  .6458E-01,  .4105E-03,  .4790E-02,  .7577E-03,
     +   .2607E-01,
     +   .1986E+00,  .6129E-01,  .3781E-03,  .4519E-02,  .7367E-03,
     +   .2336E-01,
     +   .1895E+00,  .5815E-01,  .3482E-03,  .4259E-02,  .7134E-03,
     +   .2091E-01 /
        DATA ((PARTON(I,N,56),I=1,6),N=25,27)/
     +   .1811E+00,  .5524E-01,  .3215E-03,  .4019E-02,  .6899E-03,
     +   .1879E-01,
     +   .1738E+00,  .5274E-01,  .2993E-03,  .3815E-02,  .6684E-03,
     +   .1709E-01,
     +   .1668E+00,  .5033E-01,  .2784E-03,  .3617E-02,  .6463E-03,
     +   .1554E-01 /
        DATA ((PARTON(I,N,57),I=1,6),N=1,8)/
     +   .5606E+00,  .2005E+00,  .1763E-02,  .2281E-02,  .0000E+00,
     +   .2684E+00,
     +   .5291E+00,  .1862E+00,  .1531E-02,  .2780E-02,  .0000E+00,
     +   .2322E+00,
     +   .4967E+00,  .1719E+00,  .1319E-02,  .3164E-02,  .0000E+00,
     +   .1981E+00,
     +   .4622E+00,  .1571E+00,  .1119E-02,  .3442E-02,  .0000E+00,
     +   .1652E+00,
     +   .4261E+00,  .1422E+00,  .9357E-03,  .3566E-02,  .0000E+00,
     +   .1338E+00,
     +   .3964E+00,  .1303E+00,  .8018E-03,  .3573E-02,  .0000E+00,
     +   .1106E+00,
     +   .3661E+00,  .1184E+00,  .6791E-03,  .3506E-02,  .0000E+00,
     +   .8965E-01,
     +   .3414E+00,  .1090E+00,  .5890E-03,  .3404E-02,  .0000E+00,
     +   .7453E-01 /
        DATA ((PARTON(I,N,57),I=1,6),N=9,16)/
     +   .3188E+00,  .1005E+00,  .5137E-03,  .3277E-02,  .0000E+00,
     +   .6217E-01,
     +   .3001E+00,  .9362E-01,  .4563E-03,  .3144E-02,  .0000E+00,
     +   .5282E-01,
     +   .2827E+00,  .8731E-01,  .4065E-03,  .2998E-02,  .0000E+00,
     +   .4479E-01,
     +   .2671E+00,  .8174E-01,  .3649E-03,  .2856E-02,  .0000E+00,
     +   .3831E-01,
     +   .2538E+00,  .7704E-01,  .3314E-03,  .2728E-02,  .0000E+00,
     +   .3326E-01,
     +   .2381E+00,  .7156E-01,  .2941E-03,  .2570E-02,  .0000E+00,
     +   .2788E-01,
     +   .2244E+00,  .6686E-01,  .2638E-03,  .2426E-02,  .0000E+00,
     +   .2368E-01,
     +   .2121E+00,  .6268E-01,  .2380E-03,  .2293E-02,  .0000E+00,
     +   .2028E-01 /
        DATA ((PARTON(I,N,57),I=1,6),N=17,24)/
     +   .2013E+00,  .5905E-01,  .2166E-03,  .2174E-02,  .0000E+00,
     +   .1758E-01,
     +   .1910E+00,  .5565E-01,  .1973E-03,  .2059E-02,  .1801E-04,
     +   .1525E-01,
     +   .1819E+00,  .5265E-01,  .1810E-03,  .1956E-02,  .4056E-04,
     +   .1336E-01,
     +   .1736E+00,  .4993E-01,  .1666E-03,  .1861E-02,  .5859E-04,
     +   .1178E-01,
     +   .1662E+00,  .4751E-01,  .1543E-03,  .1775E-02,  .7265E-04,
     +   .1048E-01,
     +   .1567E+00,  .4447E-01,  .1393E-03,  .1665E-02,  .8786E-04,
     +   .8971E-02,
     +   .1487E+00,  .4193E-01,  .1274E-03,  .1570E-02,  .9737E-04,
     +   .7796E-02,
     +   .1411E+00,  .3953E-01,  .1164E-03,  .1478E-02,  .1039E-03,
     +   .6753E-02 /
        DATA ((PARTON(I,N,57),I=1,6),N=25,27)/
     +   .1340E+00,  .3732E-01,  .1067E-03,  .1394E-02,  .1086E-03,
     +   .5879E-02,
     +   .1280E+00,  .3544E-01,  .9872E-04,  .1321E-02,  .1116E-03,
     +   .5198E-02,
     +   .1221E+00,  .3363E-01,  .9125E-04,  .1251E-02,  .1137E-03,
     +   .4595E-02 /
        DATA ((PARTON(I,N,58),I=1,6),N=1,8)/
     +   .4953E+00,  .1615E+00,  .6642E-03,  .0000E+00,  .0000E+00,
     +   .1514E+00,
     +   .4615E+00,  .1480E+00,  .5693E-03,  .0000E+00,  .0000E+00,
     +   .1265E+00,
     +   .4276E+00,  .1348E+00,  .4838E-03,  .0000E+00,  .0000E+00,
     +   .1037E+00,
     +   .3922E+00,  .1215E+00,  .4041E-03,  .0000E+00,  .0000E+00,
     +   .8261E-01,
     +   .3562E+00,  .1083E+00,  .3323E-03,  .0000E+00,  .0000E+00,
     +   .6304E-01,
     +   .3272E+00,  .9788E-01,  .2807E-03,  .0000E+00,  .0000E+00,
     +   .4924E-01,
     +   .2981E+00,  .8773E-01,  .2342E-03,  .0000E+00,  .0000E+00,
     +   .3730E-01,
     +   .2748E+00,  .7979E-01,  .2005E-03,  .0000E+00,  .0000E+00,
     +   .2909E-01 /
        DATA ((PARTON(I,N,58),I=1,6),N=9,16)/
     +   .2539E+00,  .7279E-01,  .1727E-03,  .0000E+00,  .0000E+00,
     +   .2269E-01,
     +   .2369E+00,  .6717E-01,  .1518E-03,  .0000E+00,  .0000E+00,
     +   .1800E-01,
     +   .2211E+00,  .6207E-01,  .1339E-03,  .0000E+00,  .0000E+00,
     +   .1410E-01,
     +   .2073E+00,  .5762E-01,  .1190E-03,  .0000E+00,  .0000E+00,
     +   .1108E-01,
     +   .1955E+00,  .5390E-01,  .1071E-03,  .4892E-04,  .0000E+00,
     +   .8842E-02,
     +   .1817E+00,  .4961E-01,  .9412E-04,  .9924E-04,  .0000E+00,
     +   .6574E-02,
     +   .1699E+00,  .4596E-01,  .8360E-04,  .1346E-03,  .0000E+00,
     +   .4909E-02,
     +   .1594E+00,  .4276E-01,  .7477E-04,  .1602E-03,  .0000E+00,
     +   .3641E-02 /
        DATA ((PARTON(I,N,58),I=1,6),N=17,24)/
     +   .1502E+00,  .4000E-01,  .6748E-04,  .1782E-03,  .0000E+00,
     +   .2694E-02,
     +   .1416E+00,  .3743E-01,  .6098E-04,  .1915E-03,  .0000E+00,
     +   .1931E-02,
     +   .1341E+00,  .3519E-01,  .5551E-04,  .2006E-03,  .0000E+00,
     +   .1356E-02,
     +   .1272E+00,  .3316E-01,  .5074E-04,  .2067E-03,  .0000E+00,
     +   .9081E-03,
     +   .1210E+00,  .3138E-01,  .4669E-04,  .2104E-03,  .0000E+00,
     +   .5683E-03,
     +   .1133E+00,  .2915E-01,  .4179E-04,  .2129E-03,  .0000E+00,
     +   .2126E-03,
     +   .1069E+00,  .2731E-01,  .3792E-04,  .2115E-03,  .0000E+00,
     +   .0000E+00,
     +   .1007E+00,  .2558E-01,  .3440E-04,  .2075E-03,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,58),I=1,6),N=25,27)/
     +   .9513E-01,  .2400E-01,  .3131E-04,  .2028E-03,  .0000E+00,
     +   .0000E+00,
     +   .9034E-01,  .2266E-01,  .2877E-04,  .1982E-03,  .0000E+00,
     +   .0000E+00,
     +   .8573E-01,  .2139E-01,  .2642E-04,  .1931E-03,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,59),I=1,6),N=1,8)/
     +   .4202E+00,  .1236E+00,  .2168E-03,  .0000E+00,  .0000E+00,
     +   .6232E-01,
     +   .3865E+00,  .1118E+00,  .1834E-03,  .0000E+00,  .0000E+00,
     +   .4824E-01,
     +   .3533E+00,  .1004E+00,  .1537E-03,  .0000E+00,  .0000E+00,
     +   .3604E-01,
     +   .3194E+00,  .8915E-01,  .1264E-03,  .0000E+00,  .0000E+00,
     +   .2533E-01,
     +   .2856E+00,  .7821E-01,  .1022E-03,  .0000E+00,  .0000E+00,
     +   .1583E-01,
     +   .2589E+00,  .6977E-01,  .8514E-04,  .0000E+00,  .0000E+00,
     +   .9591E-02,
     +   .2326E+00,  .6165E-01,  .6993E-04,  .0000E+00,  .0000E+00,
     +   .4673E-02,
     +   .2120E+00,  .5540E-01,  .5908E-04,  .0000E+00,  .0000E+00,
     +   .1634E-02 /
        DATA ((PARTON(I,N,59),I=1,6),N=9,16)/
     +   .1937E+00,  .4997E-01,  .5026E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1790E+00,  .4566E-01,  .4368E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1656E+00,  .4180E-01,  .3812E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1538E+00,  .3847E-01,  .3355E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1440E+00,  .3571E-01,  .2995E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1327E+00,  .3255E-01,  .2602E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1230E+00,  .2990E-01,  .2289E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1145E+00,  .2759E-01,  .2028E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,59),I=1,6),N=17,24)/
     +   .1071E+00,  .2562E-01,  .1815E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1003E+00,  .2381E-01,  .1626E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .9431E-01,  .2223E-01,  .1469E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .8891E-01,  .2082E-01,  .1333E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .8415E-01,  .1959E-01,  .1218E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .7818E-01,  .1805E-01,  .1080E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .7326E-01,  .1680E-01,  .9725E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .6862E-01,  .1563E-01,  .8754E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,59),I=1,6),N=25,27)/
     +   .6438E-01,  .1457E-01,  .7906E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .6080E-01,  .1368E-01,  .7217E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .5737E-01,  .1284E-01,  .6582E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,60),I=1,6),N=1,8)/
     +   .3405E+00,  .8909E-01,  .5965E-04,  .0000E+00,  .0000E+00,
     +   .1818E-02,
     +   .3090E+00,  .7951E-01,  .4977E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2786E+00,  .7046E-01,  .4110E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2480E+00,  .6159E-01,  .3326E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2182E+00,  .5316E-01,  .2643E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1951E+00,  .4677E-01,  .2167E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1728E+00,  .4072E-01,  .1751E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1556E+00,  .3614E-01,  .1458E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,60),I=1,6),N=9,16)/
     +   .1405E+00,  .3221E-01,  .1223E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1285E+00,  .2913E-01,  .1051E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1177E+00,  .2641E-01,  .9064E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1084E+00,  .2408E-01,  .7894E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1007E+00,  .2217E-01,  .6977E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .9188E-01,  .2002E-01,  .5991E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .8444E-01,  .1822E-01,  .5212E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .7795E-01,  .1667E-01,  .4572E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,60),I=1,6),N=17,24)/
     +   .7240E-01,  .1536E-01,  .4053E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .6728E-01,  .1417E-01,  .3599E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .6283E-01,  .1314E-01,  .3223E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .5885E-01,  .1222E-01,  .2901E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .5537E-01,  .1143E-01,  .2631E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .5103E-01,  .1045E-01,  .2310E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .4749E-01,  .9653E-02,  .2061E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .4417E-01,  .8918E-02,  .1839E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,60),I=1,6),N=25,27)/
     +   .4117E-01,  .8257E-02,  .1647E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .3865E-01,  .7706E-02,  .1492E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .3626E-01,  .7186E-02,  .1351E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,61),I=1,6),N=1,8)/
     +   .2613E+00,  .5981E-01,  .1324E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2338E+00,  .5265E-01,  .1087E-04,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2077E+00,  .4598E-01,  .8824E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1820E+00,  .3955E-01,  .7003E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1574E+00,  .3356E-01,  .5448E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1387E+00,  .2910E-01,  .4386E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1210E+00,  .2494E-01,  .3473E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1075E+00,  .2185E-01,  .2843E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,61),I=1,6),N=9,16)/
     +   .9588E-01,  .1923E-01,  .2347E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .8677E-01,  .1720E-01,  .1987E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .7870E-01,  .1543E-01,  .1690E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .7179E-01,  .1394E-01,  .1453E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .6611E-01,  .1272E-01,  .1269E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .5969E-01,  .1136E-01,  .1074E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .5434E-01,  .1025E-01,  .9225E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .4972E-01,  .9291E-02,  .7992E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,61),I=1,6),N=17,24)/
     +   .4581E-01,  .8491E-02,  .7006E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .4223E-01,  .7766E-02,  .6151E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .3915E-01,  .7148E-02,  .5452E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .3642E-01,  .6603E-02,  .4859E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .3404E-01,  .6133E-02,  .4367E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .3111E-01,  .5558E-02,  .3789E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2873E-01,  .5097E-02,  .3346E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2653E-01,  .4673E-02,  .2955E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,61),I=1,6),N=25,27)/
     +   .2455E-01,  .4296E-02,  .2621E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2290E-01,  .3983E-02,  .2354E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2135E-01,  .3690E-02,  .2112E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,62),I=1,6),N=1,8)/
     +   .1873E+00,  .3672E-01,  .2193E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1651E+00,  .3185E-01,  .1757E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1444E+00,  .2738E-01,  .1389E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1244E+00,  .2316E-01,  .1071E-05,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1056E+00,  .1929E-01,  .8071E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .9165E-01,  .1647E-01,  .6324E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .7860E-01,  .1388E-01,  .4864E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .6884E-01,  .1199E-01,  .3884E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,62),I=1,6),N=9,16)/
     +   .6058E-01,  .1041E-01,  .3130E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .5419E-01,  .9201E-02,  .2597E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .4860E-01,  .8162E-02,  .2168E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .4388E-01,  .7294E-02,  .1831E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .4004E-01,  .6596E-02,  .1575E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .3574E-01,  .5824E-02,  .1309E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .3220E-01,  .5196E-02,  .1105E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2918E-01,  .4666E-02,  .9434E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,62),I=1,6),N=17,24)/
     +   .2665E-01,  .4226E-02,  .8161E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2435E-01,  .3831E-02,  .7076E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2240E-01,  .3498E-02,  .6202E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2067E-01,  .3206E-02,  .5472E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1919E-01,  .2957E-02,  .4874E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1737E-01,  .2654E-02,  .4182E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1592E-01,  .2414E-02,  .3660E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1458E-01,  .2195E-02,  .3208E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,62),I=1,6),N=25,27)/
     +   .1338E-01,  .2002E-02,  .2826E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1240E-01,  .1843E-02,  .2524E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1147E-01,  .1695E-02,  .2254E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,63),I=1,6),N=1,8)/
     +   .1227E+00,  .2002E-01,  .2293E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1064E+00,  .1708E-01,  .1746E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .9150E-01,  .1444E-01,  .1309E-06,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .7735E-01,  .1199E-01,  .9545E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .6438E-01,  .9790E-02,  .6838E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .5489E-01,  .8213E-02,  .5163E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .4621E-01,  .6796E-02,  .3849E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .3984E-01,  .5776E-02,  .3020E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,63),I=1,6),N=9,16)/
     +   .3454E-01,  .4939E-02,  .2415E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .3050E-01,  .4311E-02,  .2008E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2701E-01,  .3776E-02,  .1695E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2410E-01,  .3335E-02,  .1456E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2177E-01,  .2985E-02,  .1280E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1918E-01,  .2602E-02,  .1100E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1709E-01,  .2294E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1531E-01,  .2038E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,63),I=1,6),N=17,24)/
     +   .1385E-01,  .1827E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1253E-01,  .1640E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1142E-01,  .1483E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1045E-01,  .1348E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .9624E-02,  .1233E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .8622E-02,  .1095E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .7826E-02,  .9868E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .7103E-02,  .8890E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,63),I=1,6),N=25,27)/
     +   .6465E-02,  .8035E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .5941E-02,  .7339E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .5455E-02,  .6696E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,64),I=1,6),N=1,8)/
     +   .7083E-01,  .9220E-02,  .1661E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .6032E-01,  .7729E-02,  .1399E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .5086E-01,  .6411E-02,  .1228E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .4209E-01,  .5211E-02,  .1114E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .3423E-01,  .4158E-02,  .1038E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2861E-01,  .3420E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2358E-01,  .2770E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1996E-01,  .2312E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,64),I=1,6),N=9,16)/
     +   .1701E-01,  .1943E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1479E-01,  .1671E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1291E-01,  .1442E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1137E-01,  .1257E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1014E-01,  .1111E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .8809E-02,  .9542E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .7740E-02,  .8301E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .6851E-02,  .7279E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,64),I=1,6),N=17,24)/
     +   .6123E-02,  .6451E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .5479E-02,  .5725E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .4941E-02,  .5124E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .4476E-02,  .4609E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .4083E-02,  .4176E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .3613E-02,  .3664E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .3245E-02,  .3265E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2913E-02,  .2910E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,64),I=1,6),N=25,27)/
     +   .2624E-02,  .2603E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2390E-02,  .2355E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2174E-02,  .2129E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,65),I=1,6),N=1,8)/
     +   .3357E-01,  .3266E-02,  .1300E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2797E-01,  .2680E-02,  .1359E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2305E-01,  .2173E-02,  .1364E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1859E-01,  .1722E-02,  .1320E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1470E-01,  .1337E-02,  .1224E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1200E-01,  .1074E-02,  .1124E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .9638E-02,  .8478E-03,  .1009E-07,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .7982E-02,  .6922E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,65),I=1,6),N=9,16)/
     +   .6658E-02,  .5696E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .5687E-02,  .4809E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .4878E-02,  .4079E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .4224E-02,  .3496E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .3714E-02,  .3046E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .3167E-02,  .2569E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2737E-02,  .2198E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2385E-02,  .1897E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,65),I=1,6),N=17,24)/
     +   .2102E-02,  .1658E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1854E-02,  .1450E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1651E-02,  .1281E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1477E-02,  .1138E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1332E-02,  .1020E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1161E-02,  .8809E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1029E-02,  .7747E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .9117E-03,  .6814E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,65),I=1,6),N=25,27)/
     +   .8109E-03,  .6017E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .7300E-03,  .5382E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .6565E-03,  .4809E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,66),I=1,6),N=1,8)/
     +   .1114E-01,  .7191E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .9024E-02,  .5738E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .7215E-02,  .4517E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .5629E-02,  .3464E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .4293E-02,  .2594E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .3395E-02,  .2019E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2636E-02,  .1542E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2120E-02,  .1223E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,66),I=1,6),N=9,16)/
     +   .1720E-02,  .9786E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1434E-02,  .8065E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1201E-02,  .6682E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1018E-02,  .5603E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .8773E-03,  .4787E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .7303E-03,  .3940E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .6174E-03,  .3298E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .5269E-03,  .2789E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,66),I=1,6),N=17,24)/
     +   .4555E-03,  .2390E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .3944E-03,  .2052E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .3450E-03,  .1782E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .3036E-03,  .1557E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2697E-03,  .1373E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2302E-03,  .1162E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2004E-03,  .1004E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1745E-03,  .8672E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,66),I=1,6),N=25,27)/
     +   .1525E-03,  .7526E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1352E-03,  .6629E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1197E-03,  .5832E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,67),I=1,6),N=1,8)/
     +   .1549E-02,  .4975E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1201E-02,  .3801E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .9157E-03,  .2857E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .6779E-03,  .2081E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .4882E-03,  .1473E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .3673E-03,  .1091E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2703E-03,  .7902E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2076E-03,  .5986E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,67),I=1,6),N=9,16)/
     +   .1611E-03,  .4583E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1292E-03,  .3634E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1042E-03,  .2900E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .8526E-04,  .2347E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .7123E-04,  .1943E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .5704E-04,  .1538E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .4654E-04,  .1242E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .3841E-04,  .1015E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,67),I=1,6),N=17,24)/
     +   .3220E-04,  .8438E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2705E-04,  .7026E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .2300E-04,  .5927E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1971E-04,  .5039E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1707E-04,  .4334E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1410E-04,  .3547E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1192E-04,  .2975E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1008E-04,  .2496E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
        DATA ((PARTON(I,N,67),I=1,6),N=25,27)/
     +   .8571E-05,  .2105E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .7411E-05,  .1808E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .6399E-05,  .1550E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00 /
C
       X  = DX
       Q  = DQ
       Q2 = DQ*DQ
*
* ..CHECK OF X AND Q2 VALUES : 
C      IF ( (X.LT.0.99D-9) .OR. (X.GT.1.D0) ) THEN
C         WRITE(6,91) 
C  91     FORMAT (2X,'PARTON INTERPOLATION: X OUT OF RANGE')
C         STOP
C      ENDIF
C      IF ( (Q2.LT.0.799) .OR. (Q2.GT.1.01E6) ) THEN
C         WRITE(6,92) 
C  92     FORMAT (2X,'PARTON INTERPOLATION: Q2 OUT OF RANGE')
C         STOP
C      ENDIF
      IF (IINIP .NE. 0) GOTO 16
*
* ..INITIALIZATION, IF REQUIRED :
*
*    SELECTION AND READING OF THE GRID : 
*    (COMMENT: FIRST NUMBER IN THE FIRST LINE OF THE GRID)
C      IF (ISET .EQ. 1) THEN
C        OPEN (11,FILE='grv98lo.grid',STATUS='old')   ! 7.332E-05
C      ELSE IF (ISET .EQ. 2) THEN
C        OPEN (11,FILE='grv98nlm.grid',STATUS='old')  ! 1.015E-04
C      ELSE IF (ISET .EQ. 3) THEN
C        OPEN (11,FILE='grv98nld.grid',STATUS='old')  ! 1.238E-04
C      ELSE
C        WRITE(6,93)
C  93    FORMAT (2X,'NO OR INVALID PARTON SET CHOICE')
C        STOP
C      END IF
C
      IINIP = 1
C
C      READ(11,89) LINE
C  89  FORMAT(A80)
C      DO 15 M = 1, NX-1 
C      DO 15 N = 1, NQ
C      READ(11,90) PARTON(1,N,M), PARTON(2,N,M), PARTON(3,N,M), 
C     1            PARTON(4,N,M), PARTON(5,N,M), PARTON(6,N,M) 
C  90  FORMAT (6(1PE10.3))
C  15  CONTINUE
C      CLOSE(11)
*
* ...ARRAYS FOR THE INTERPOLATION SUBROUTINE :
      DO 10 IQ = 1, NQ
      DO 20 IX = 1, NX-1
        XB0V = XB(IX)**0.5 
        XB0S = XB(IX)**(-0.2) 
        XB1 = 1.-XB(IX)
        XUVF(IX,IQ) = PARTON(1,IQ,IX) / (XB1**3 * XB0V)
        XDVF(IX,IQ) = PARTON(2,IQ,IX) / (XB1**4 * XB0V)
        XDEF(IX,IQ) = PARTON(3,IQ,IX) / (XB1**7 * XB0V) 
        XUDF(IX,IQ) = PARTON(4,IQ,IX) / (XB1**7 * XB0S)
        XSF(IX,IQ)  = PARTON(5,IQ,IX) / (XB1**7 * XB0S)
        XGF(IX,IQ)  = PARTON(6,IQ,IX) / (XB1**5 * XB0S)
  20  CONTINUE
        XUVF(NX,IQ) = 0.E0
        XDVF(NX,IQ) = 0.E0
        XDEF(NX,IQ) = 0.E0
        XUDF(NX,IQ) = 0.E0
        XSF(NX,IQ)  = 0.E0
        XGF(NX,IQ)  = 0.E0
  10  CONTINUE  
      NA(1) = NX
      NA(2) = NQ
      DO 30 IX = 1, NX
        ARRF(IX) =  LOG(XB(IX))
  30  CONTINUE
      DO 40 IQ = 1, NQ
        ARRF(NX+IQ) =  LOG(QS(IQ))
  40  CONTINUE
*
* ..CONTINUATION, IF INITIALIZATION WAS DONE PREVIOUSLY.
*
  16  CONTINUE
*
* ..INTERPOLATION :
      XT(1) =  LOG(X)
      XT(2) =  LOG(Q2)
      X1 = 1.- X
      XV = X**0.5
      XS = X**(-0.2)
      UV = DBFINT(NARG,XT,NA,ARRF,XUVF) * X1**3 * XV
      DUV = UV
      DV = DBFINT(NARG,XT,NA,ARRF,XDVF) * X1**4 * XV
      DDV = DV
      DE = DBFINT(NARG,XT,NA,ARRF,XDEF) * X1**7 * XV
      UD = DBFINT(NARG,XT,NA,ARRF,XUDF) * X1**7 * XS
      IF (DE. GT. UD) DE = ZEROD
      US = 0.5 * (UD - DE)
      DUSEA = US
      DS = 0.5 * (UD + DE)
      DDSEA = DS
      SS = DBFINT(NARG,XT,NA,ARRF,XSF)  * X1**7 * XS
      DSTR = SS
      DCHM = ZEROD
      DBOT = ZEROD
      DTOP = ZEROD
      GL = DBFINT(NARG,XT,NA,ARRF,XGF)  * X1**5 * XS 
      DGL = GL
*
 60   RETURN
      END
