# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.pass_input_type_algorithm import PassInputTypeAlgorithm


class AppendLocationAttributes(PassInputTypeAlgorithm):
    r"""
    AppendLocationAttributes - add point locations to point data
    and/or cell centers cell data, respectively
    
    Superclass: PassInputTypeAlgorithm
    
    AppendLocationAttributes is a filter that takes as input any
    dataset and optionally adds points as point data and optionally adds
    cell center locations as cell data in the output. The center of a
    cell is its parametric center, not necessarily the geometric or
    bounding box center. Point and cell attributes in the input can
    optionally be copied to the output.
    
    ote Empty cells will have their center set to (0, 0, 0).
    
    @sa
    CellCenters
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAppendLocationAttributes, obj, update, **traits)
    
    append_cell_centers = tvtk_base.true_bool_trait(desc=\
        r"""
        Enable/disable whether input cell center locations should be
        saved as a cell data array. Default is `true` i.e. the cell
        centers will be propagated as a cell data array named
        "cell_centers".
        """
    )

    def _append_cell_centers_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAppendCellCenters,
                        self.append_cell_centers_)

    append_point_locations = tvtk_base.true_bool_trait(desc=\
        r"""
        Enable/disable whether input point locations should be saved as a
        point data array. Default is `true` i.e. the points will be
        propagated as a point data array named "point_locations".
        """
    )

    def _append_point_locations_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAppendPointLocations,
                        self.append_point_locations_)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    _updateable_traits_ = \
    (('append_cell_centers', 'GetAppendCellCenters'),
    ('append_point_locations', 'GetAppendPointLocations'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'append_cell_centers', 'append_point_locations',
    'debug', 'global_warning_display', 'release_data_flag', 'object_name',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AppendLocationAttributes, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit AppendLocationAttributes properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['append_cell_centers', 'append_point_locations'], [],
            ['object_name']),
            title='Edit AppendLocationAttributes properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AppendLocationAttributes properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

