// license:BSD-3-Clause
// copyright-holders:

/*
KCPU30-BASS KOMAYA PCB

Circlun - kuru.kuru-count (2005) - さーくるん
mechanical medal game
https://www.youtube.com/watch?v=L8LYEyvYvIY

Very tiny and tidy PCB with the following main components:
TMP95C265P with AM27C040 program ROM
16 MHz resonator
LM358N
Sharp PQ05RR1
4x T062004AP (with 1 more empty space)
2x TC4050BP
8-DIP bank
6x connectors (with 2 more empty spaces)
*/

#include "emu.h"

#include "cpu/tlcs900/tmp95c061.h"

#include "speaker.h"


namespace {

class komaya_state : public driver_device
{
public:
	komaya_state(const machine_config &mconfig, device_type type, const char *tag)
		: driver_device(mconfig, type, tag),
		m_maincpu(*this, "maincpu")
	{}

	void kkcount(machine_config &config) ATTR_COLD;

private:
	required_device<cpu_device> m_maincpu;

	void program_map(address_map &map) ATTR_COLD;
};


void komaya_state::program_map(address_map &map)
{
}


static INPUT_PORTS_START( kkcount )
	PORT_START("IN0")
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNKNOWN )

	PORT_START("IN1")
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNKNOWN )

	PORT_START("DSW")
	PORT_DIPNAME( 0x01, 0x01, "DSW" )
	PORT_DIPSETTING(    0x01, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x02, 0x02, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x02, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x04, 0x04, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x08, 0x08, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x40, 0x40, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x80, 0x80, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
INPUT_PORTS_END


void komaya_state::kkcount(machine_config &config)
{
	TMP95C061(config, m_maincpu, 16_MHz_XTAL); // actually TMP95C265P
	m_maincpu->set_addrmap(AS_PROGRAM, &komaya_state::program_map);

	// sound
	SPEAKER(config, "mono").front_center();
	// TODO: ROM definitely contains samples, but how are they played?
}


ROM_START( kkcount )
	ROM_REGION( 0x80000, "maincpu", 0 )
	ROM_LOAD( "saakurun_a.ic7", 0x00000, 0x80000, CRC(9182015b) SHA1(0b4a47215656ef79374d83e99b5d3e048051cb91) ) // “ｻｰｸﾙﾝ Ａ
ROM_END

} // anonymous namespace


GAME( 2005, kkcount, 0, kkcount, kkcount, komaya_state, empty_init, ROT0, "Komaya", "Circlun - Kuru.Kuru-Count", MACHINE_IS_SKELETON_MECHANICAL )
