/*
 * libsysactivity
 * http://sourceforge.net/projects/libsysactivity/
 * Copyright (c) 2009-2011 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdio.h>
#include <unistd.h>
#include <pthread.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <inttypes.h>

int main() {
	int i;
	int ret;
	struct sa_memory memory;

#ifdef SA_OPEN_MEMORY
	ret = sa_open_memory();
	if (ret != 0) {
		printf("sa_open_memory(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif

	for (i = 0; i < 500000; i++) {
		ret = sa_get_memory(&memory);
		if (ret != 0) {
			printf("sa_get_memory(): %s\n", strerror(ret));
			exit(EXIT_FAILURE);
		}
	}

#ifdef SA_CLOSE_MEMORY
	ret = sa_close_memory();
	if (ret != 0) {
		printf("sa_close_memory(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif
	return EXIT_SUCCESS;
}
