#
# @file    TestReadFromFile3.py
# @brief   Reads tests/l1v1-rules.xml into memory and tests it.
#
# @author  Akiya Jouraku (Python conversion)
# @author  Ben Bornstein 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestReadFromFile3.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml


class TestReadFromFile3(unittest.TestCase):


  def test_read_l1v1_rules(self):
    filename = "../../sbml/test/test-data/l1v1-rules.xml"
    d = libsbml.readSBML(filename)
    if (d == None):
      pass    
    self.assertTrue( d.getLevel() == 1 )
    self.assertTrue( d.getVersion() == 1 )
    m = d.getModel()
    self.assertTrue( m.getNumCompartments() == 1 )
    c = m.getCompartment(0)
    self.assertTrue((  "cell" == c.getName() ))
    self.assertTrue( c.getVolume() == 1 )
    self.assertTrue( m.getNumSpecies() == 6 )
    s = m.getSpecies(0)
    self.assertTrue((  "s1"    == s.getName() ))
    self.assertTrue((  "cell"  == s.getCompartment() ))
    self.assertTrue( s.getInitialAmount() == 4 )
    self.assertTrue( s.getBoundaryCondition() == False )
    s = m.getSpecies(1)
    self.assertTrue((  "s2"    == s.getName() ))
    self.assertTrue((  "cell"  == s.getCompartment() ))
    self.assertTrue( s.getInitialAmount() == 2 )
    self.assertTrue( s.getBoundaryCondition() == False )
    s = m.getSpecies(2)
    self.assertTrue((  "x0"    == s.getName() ))
    self.assertTrue((  "cell"  == s.getCompartment() ))
    self.assertTrue( s.getInitialAmount() == 1 )
    self.assertTrue( s.getBoundaryCondition() == False )
    s = m.getSpecies(3)
    self.assertTrue((  "x1"    == s.getName() ))
    self.assertTrue((  "cell"  == s.getCompartment() ))
    self.assertTrue( s.getInitialAmount() == 0 )
    self.assertTrue( s.getBoundaryCondition() == False )
    s = m.getSpecies(4)
    self.assertTrue((  "x2"    == s.getName() ))
    self.assertTrue((  "cell"  == s.getCompartment() ))
    self.assertTrue( s.getInitialAmount() == 1 )
    self.assertTrue( s.getBoundaryCondition() == False )
    s = m.getSpecies(5)
    self.assertTrue((  "x3"    == s.getName() ))
    self.assertTrue((  "cell"  == s.getCompartment() ))
    self.assertTrue( s.getInitialAmount() == 0 )
    self.assertTrue( s.getBoundaryCondition() == False )
    self.assertTrue( m.getNumParameters() == 7 )
    p = m.getParameter(0)
    self.assertTrue((  "k1" == p.getName() ))
    self.assertTrue( p.getValue() == 1.2 )
    p = m.getParameter(1)
    self.assertTrue((  "k2" == p.getName() ))
    self.assertTrue( p.getValue() == 1000 )
    p = m.getParameter(2)
    self.assertTrue((  "k3" == p.getName() ))
    self.assertTrue( p.getValue() == 3000 )
    p = m.getParameter(3)
    self.assertTrue((  "k4" == p.getName() ))
    self.assertTrue( p.getValue() == 4.5 )
    self.assertTrue( m.getNumRules() == 4 )
    pr = m.getRule(0)
    self.assertTrue((  "t" == pr.getVariable() ))
    self.assertTrue((  "s1 + s2" == pr.getFormula() ))
    ud = pr.getDerivedUnitDefinition()
    self.assertTrue( ud.getNumUnits() == 2 )
    self.assertTrue( ud.getUnit(0).getKind() == libsbml.UNIT_KIND_MOLE )
    self.assertTrue( ud.getUnit(0).getExponent() == 1 )
    self.assertTrue( ud.getUnit(1).getKind() == libsbml.UNIT_KIND_LITRE )
    self.assertTrue( ud.getUnit(1).getExponent() == -1 )
    self.assertTrue( pr.containsUndeclaredUnits() == False )
    pr = m.getRule(1)
    self.assertTrue((  "k" == pr.getVariable() ))
    self.assertTrue((  "k3/k2" == pr.getFormula() ))
    ud = pr.getDerivedUnitDefinition()
    self.assertTrue( ud.getNumUnits() == 0 )
    self.assertTrue( pr.containsUndeclaredUnits() == True )
    scr = m.getRule(2)
    self.assertTrue((  "x2" == scr.getVariable() ))
    self.assertTrue((  "k * (s1+s2)/(1 + k)" == scr.getFormula() ))
    scr = m.getRule(3)
    self.assertTrue((  "x3" == scr.getVariable() ))
    self.assertTrue((  "p*(t - s2)" == scr.getFormula() ))
    self.assertTrue( m.getNumReactions() == 2 )
    r = m.getReaction(0)
    self.assertTrue((  "j1" == r.getName() ))
    self.assertTrue( r.getReversible() != False )
    self.assertTrue( r.getFast() == False )
    r = m.getReaction(1)
    self.assertTrue((  "j3" == r.getName() ))
    self.assertTrue( r.getReversible() != False )
    self.assertTrue( r.getFast() == False )
    r = m.getReaction(0)
    self.assertTrue( r.getNumReactants() == 1 )
    self.assertTrue( r.getNumProducts() == 1 )
    sr = r.getReactant(0)
    self.assertTrue((  "x0" == sr.getSpecies() ))
    self.assertTrue( sr.getStoichiometry() == 1 )
    self.assertTrue( sr.getDenominator() == 1 )
    sr = r.getProduct(0)
    self.assertTrue((  "s1" == sr.getSpecies() ))
    self.assertTrue( sr.getStoichiometry() == 1 )
    self.assertTrue( sr.getDenominator() == 1 )
    kl = r.getKineticLaw()
    self.assertTrue((  "k1 * x0" == kl.getFormula() ))
    r = m.getReaction(1)
    self.assertTrue( r.getNumReactants() == 1 )
    self.assertTrue( r.getNumProducts() == 1 )
    sr = r.getReactant(0)
    self.assertTrue((  "s2" == sr.getSpecies() ))
    self.assertTrue( sr.getStoichiometry() == 1 )
    self.assertTrue( sr.getDenominator() == 1 )
    sr = r.getProduct(0)
    self.assertTrue((  "x1" == sr.getSpecies() ))
    self.assertTrue( sr.getStoichiometry() == 1 )
    self.assertTrue( sr.getDenominator() == 1 )
    kl = r.getKineticLaw()
    self.assertTrue((  "k4 * s2" == kl.getFormula() ))
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.makeSuite(TestReadFromFile3))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)
