#include "osl/container/moveVector.h"
#include <boost/foreach.hpp>
#include <algorithm>
#include <iostream>

std::ostream& osl::container::operator<<(std::ostream& os,MoveVector const& mv)
{
  os<< "MoveVector" << std::endl;
  BOOST_FOREACH(Move m, mv) {
    os << m << std::endl;
  }
  return os<<std::endl;
}
bool osl::container::operator<(const MoveVector& l, const MoveVector& r)
{ 
  return std::lexicographical_compare(l.begin(), l.end(),
				      r.begin(), r.end()); 
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
