package org.jboss.cache.invocation;

import org.jboss.cache.InvocationContext;
import org.jboss.cache.factories.annotations.NonVolatile;

/**
 * Container and factory for thread locals
 *
 * @author Manik Surtani (<a href="mailto:manik@jboss.org">manik@jboss.org</a>)
 * @since 2.1.0
 */
@NonVolatile
public class InvocationContextContainer extends ThreadLocal<InvocationContext>
{
   @Override
   protected InvocationContext initialValue()
   {
      // create if this is initially unset
      return new InvocationContext();
   }
}
