/* iso_639.c generated by valac 0.18.1, the Vala compiler
 * generated from iso_639.vala, do not modify */

/* Copyright © 2012-2013 Tobias Quathamer
 *
 * This file is part of libisocodes.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/parser.h>
#include <gee.h>


#define LIBISOCODES_TYPE_ISO_CODES (libisocodes_iso_codes_get_type ())
#define LIBISOCODES_ISO_CODES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIBISOCODES_TYPE_ISO_CODES, libisocodesISO_Codes))
#define LIBISOCODES_ISO_CODES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIBISOCODES_TYPE_ISO_CODES, libisocodesISO_CodesClass))
#define LIBISOCODES_IS_ISO_CODES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIBISOCODES_TYPE_ISO_CODES))
#define LIBISOCODES_IS_ISO_CODES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIBISOCODES_TYPE_ISO_CODES))
#define LIBISOCODES_ISO_CODES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIBISOCODES_TYPE_ISO_CODES, libisocodesISO_CodesClass))

typedef struct _libisocodesISO_Codes libisocodesISO_Codes;
typedef struct _libisocodesISO_CodesClass libisocodesISO_CodesClass;
typedef struct _libisocodesISO_CodesPrivate libisocodesISO_CodesPrivate;

#define LIBISOCODES_TYPE_ISO_639 (libisocodes_iso_639_get_type ())
#define LIBISOCODES_ISO_639(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIBISOCODES_TYPE_ISO_639, libisocodesISO_639))
#define LIBISOCODES_ISO_639_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIBISOCODES_TYPE_ISO_639, libisocodesISO_639Class))
#define LIBISOCODES_IS_ISO_639(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIBISOCODES_TYPE_ISO_639))
#define LIBISOCODES_IS_ISO_639_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIBISOCODES_TYPE_ISO_639))
#define LIBISOCODES_ISO_639_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIBISOCODES_TYPE_ISO_639, libisocodesISO_639Class))

typedef struct _libisocodesISO_639 libisocodesISO_639;
typedef struct _libisocodesISO_639Class libisocodesISO_639Class;
typedef struct _libisocodesISO_639Private libisocodesISO_639Private;

#define LIBISOCODES_TYPE_ISO_639_ITEM (libisocodes_iso_639_item_get_type ())
#define LIBISOCODES_ISO_639_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIBISOCODES_TYPE_ISO_639_ITEM, libisocodesISO_639_Item))
#define LIBISOCODES_ISO_639_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIBISOCODES_TYPE_ISO_639_ITEM, libisocodesISO_639_ItemClass))
#define LIBISOCODES_IS_ISO_639_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIBISOCODES_TYPE_ISO_639_ITEM))
#define LIBISOCODES_IS_ISO_639_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIBISOCODES_TYPE_ISO_639_ITEM))
#define LIBISOCODES_ISO_639_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIBISOCODES_TYPE_ISO_639_ITEM, libisocodesISO_639_ItemClass))

typedef struct _libisocodesISO_639_Item libisocodesISO_639_Item;
typedef struct _libisocodesISO_639_ItemClass libisocodesISO_639_ItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _libisocodesISO_Codes {
	GObject parent_instance;
	libisocodesISO_CodesPrivate * priv;
};

struct _libisocodesISO_CodesClass {
	GObjectClass parent_class;
	gchar** (*_get_xpaths) (libisocodesISO_Codes* self, const gchar* code, int* result_length1);
	gchar** (*_get_fields) (libisocodesISO_Codes* self, int* result_length1);
};

struct _libisocodesISO_639 {
	libisocodesISO_Codes parent_instance;
	libisocodesISO_639Private * priv;
};

struct _libisocodesISO_639Class {
	libisocodesISO_CodesClass parent_class;
};

typedef enum  {
	LIBISOCODES_ISO_CODES_ERROR_FILE_DOES_NOT_EXIST,
	LIBISOCODES_ISO_CODES_ERROR_CANNOT_PARSE_FILE,
	LIBISOCODES_ISO_CODES_ERROR_FILE_DOES_NOT_CONTAIN_ISO_DATA,
	LIBISOCODES_ISO_CODES_ERROR_CODE_NOT_DEFINED
} libisocodesISOCodesError;
#define LIBISOCODES_ISO_CODES_ERROR libisocodes_iso_codes_error_quark ()

static gpointer libisocodes_iso_639_parent_class = NULL;

GType libisocodes_iso_codes_get_type (void) G_GNUC_CONST;
GType libisocodes_iso_639_get_type (void) G_GNUC_CONST;
enum  {
	LIBISOCODES_ISO_639_DUMMY_PROPERTY
};
libisocodesISO_639* libisocodes_iso_639_new (void);
libisocodesISO_639* libisocodes_iso_639_construct (GType object_type);
libisocodesISO_Codes* libisocodes_iso_codes_construct (GType object_type);
void libisocodes_iso_639_setup (libisocodesISO_639* self);
void _libisocodes_iso_codes_setup_i18n (libisocodesISO_Codes* self);
void libisocodes_iso_codes_set_standard (libisocodesISO_Codes* self, const gchar* value);
void libisocodes_iso_codes_set_filepath (libisocodesISO_Codes* self, const gchar* path);
GType libisocodes_iso_639_item_get_type (void) G_GNUC_CONST;
GQuark libisocodes_iso_codes_error_quark (void);
libisocodesISO_639_Item** libisocodes_iso_639_find_all (libisocodesISO_639* self, int* result_length1, GError** error);
GeeArrayList* _libisocodes_iso_codes_find_all (libisocodesISO_Codes* self, GError** error);
libisocodesISO_639_Item* libisocodes_iso_639_item_new (GeeHashMap* item);
libisocodesISO_639_Item* libisocodes_iso_639_item_construct (GType object_type, GeeHashMap* item);
static void _vala_array_add7 (libisocodesISO_639_Item*** array, int* length, int* size, libisocodesISO_639_Item* value);
libisocodesISO_639_Item* libisocodes_iso_639_find_code (libisocodesISO_639* self, const gchar* code, GError** error);
GeeHashMap* _libisocodes_iso_codes_find_code (libisocodesISO_Codes* self, const gchar* code, GError** error);
static gchar** libisocodes_iso_639_real__get_xpaths (libisocodesISO_Codes* base, const gchar* code, int* result_length1);
static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value);
static gchar** libisocodes_iso_639_real__get_fields (libisocodesISO_Codes* base, int* result_length1);
static void libisocodes_iso_639_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
         * Constructor of class.
         * 
         * Call the setup() method, see there for reasoning.
         */
libisocodesISO_639* libisocodes_iso_639_construct (GType object_type) {
	libisocodesISO_639 * self = NULL;
	self = (libisocodesISO_639*) libisocodes_iso_codes_construct (object_type);
	libisocodes_iso_639_setup (self);
	return self;
}


libisocodesISO_639* libisocodes_iso_639_new (void) {
	return libisocodes_iso_639_construct (LIBISOCODES_TYPE_ISO_639);
}


/**
         * Setup of the class.
         * 
         * Due to a bug somewhere in the GObject introspection routines
         * with vala, the constructor of a class is not called when
         * the class is instanciated. Therefore, we use a separate
         * setup method which can be called, if necessary.
         * 
         * For LibXML, it is needed to initialize the parser here.
         */
void libisocodes_iso_639_setup (libisocodesISO_639* self) {
	g_return_if_fail (self != NULL);
	_libisocodes_iso_codes_setup_i18n ((libisocodesISO_Codes*) self);
	xmlInitParser ();
	libisocodes_iso_codes_set_standard ((libisocodesISO_Codes*) self, "639");
	libisocodes_iso_codes_set_filepath ((libisocodesISO_Codes*) self, "/usr/share/xml/iso-codes/iso_639.xml");
}


/**
         * Return an array of all items in the ISO standard.
         * 
         * @return array All ISO 639 items.
         */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add7 (libisocodesISO_639_Item*** array, int* length, int* size, libisocodesISO_639_Item* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (libisocodesISO_639_Item*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


libisocodesISO_639_Item** libisocodes_iso_639_find_all (libisocodesISO_639* self, int* result_length1, GError** error) {
	libisocodesISO_639_Item** result = NULL;
	libisocodesISO_639_Item** _result_;
	gint _result__length1;
	gint __result__size_;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* items;
	libisocodesISO_639_Item** _tmp14_;
	gint _tmp14__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = NULL;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	_tmp0_ = _libisocodes_iso_codes_find_all ((libisocodesISO_Codes*) self, &_inner_error_);
	items = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == LIBISOCODES_ISO_CODES_ERROR) {
			g_propagate_error (error, _inner_error_);
			_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_object_unref), NULL);
			return NULL;
		} else {
			_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_object_unref), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		GeeArrayList* _tmp1_;
		GeeArrayList* _item_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _item_size;
		gint _item_index;
		_tmp1_ = _g_object_ref0 (items);
		_item_list = _tmp1_;
		_tmp2_ = _item_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_item_size = _tmp4_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			GeeHashMap* item;
			libisocodesISO_639_Item** _tmp11_;
			gint _tmp11__length1;
			GeeHashMap* _tmp12_;
			libisocodesISO_639_Item* _tmp13_;
			_tmp5_ = _item_index;
			_item_index = _tmp5_ + 1;
			_tmp6_ = _item_index;
			_tmp7_ = _item_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _item_list;
			_tmp9_ = _item_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			item = (GeeHashMap*) _tmp10_;
			_tmp11_ = _result_;
			_tmp11__length1 = _result__length1;
			_tmp12_ = item;
			_tmp13_ = libisocodes_iso_639_item_new (_tmp12_);
			_vala_array_add7 (&_result_, &_result__length1, &__result__size_, _tmp13_);
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_list);
	}
	_tmp14_ = _result_;
	_tmp14__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	_g_object_unref0 (items);
	return result;
}


/**
         * Try to locate the given code in the XML file.
         * 
         * @param string Code to search for.
         * 
         * @return struct A matching ISO 639 item, if found.
         */
libisocodesISO_639_Item* libisocodes_iso_639_find_code (libisocodesISO_639* self, const gchar* code, GError** error) {
	libisocodesISO_639_Item* result = NULL;
	const gchar* _tmp0_;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* res;
	libisocodesISO_639_Item* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (code != NULL, NULL);
	_tmp0_ = code;
	_tmp1_ = _libisocodes_iso_codes_find_code ((libisocodesISO_Codes*) self, _tmp0_, &_inner_error_);
	res = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == LIBISOCODES_ISO_CODES_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = libisocodes_iso_639_item_new (res);
	result = _tmp2_;
	_g_object_unref0 (res);
	return result;
}


/**
         * Set up the XPaths to try.
         * 
         * @param string Code to search for.
         */
static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** libisocodes_iso_639_real__get_xpaths (libisocodesISO_Codes* base, const gchar* code, int* result_length1) {
	libisocodesISO_639 * self;
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** xpaths;
	gint xpaths_length1;
	gint _xpaths_size_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	self = (libisocodesISO_639*) base;
	g_return_val_if_fail (code != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	xpaths = _tmp0_;
	xpaths_length1 = 0;
	_xpaths_size_ = xpaths_length1;
	_tmp1_ = code;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 2) {
		gchar** _tmp4_;
		gint _tmp4__length1;
		const gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp4_ = xpaths;
		_tmp4__length1 = xpaths_length1;
		_tmp5_ = code;
		_tmp6_ = g_utf8_strdown (_tmp5_, (gssize) (-1));
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat ("//iso_639_entry[@iso_639_1_code='", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp9_, "']", NULL);
		_vala_array_add8 (&xpaths, &xpaths_length1, &_xpaths_size_, _tmp10_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
	} else {
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar** _tmp18_;
		gint _tmp18__length1;
		const gchar* _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp11_ = xpaths;
		_tmp11__length1 = xpaths_length1;
		_tmp12_ = code;
		_tmp13_ = g_utf8_strdown (_tmp12_, (gssize) (-1));
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat ("//iso_639_entry[@iso_639_2B_code='", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, "']", NULL);
		_vala_array_add9 (&xpaths, &xpaths_length1, &_xpaths_size_, _tmp17_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_tmp18_ = xpaths;
		_tmp18__length1 = xpaths_length1;
		_tmp19_ = code;
		_tmp20_ = g_utf8_strdown (_tmp19_, (gssize) (-1));
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat ("//iso_639_entry[@iso_639_2T_code='", _tmp21_, NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp23_, "']", NULL);
		_vala_array_add10 (&xpaths, &xpaths_length1, &_xpaths_size_, _tmp24_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
	}
	_tmp25_ = xpaths;
	_tmp25__length1 = xpaths_length1;
	if (result_length1) {
		*result_length1 = _tmp25__length1;
	}
	result = _tmp25_;
	return result;
}


/**
         * @inheritDoc
         */
static gchar** libisocodes_iso_639_real__get_fields (libisocodesISO_Codes* base, int* result_length1) {
	libisocodesISO_639 * self;
	gchar** result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	self = (libisocodesISO_639*) base;
	_tmp0_ = g_strdup ("iso_639_2B_code");
	_tmp1_ = g_strdup ("iso_639_2T_code");
	_tmp2_ = g_strdup ("iso_639_1_code");
	_tmp3_ = g_strdup ("name");
	_tmp4_ = g_new0 (gchar*, 4 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 4;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}


static void libisocodes_iso_639_class_init (libisocodesISO_639Class * klass) {
	libisocodes_iso_639_parent_class = g_type_class_peek_parent (klass);
	LIBISOCODES_ISO_CODES_CLASS (klass)->_get_xpaths = libisocodes_iso_639_real__get_xpaths;
	LIBISOCODES_ISO_CODES_CLASS (klass)->_get_fields = libisocodes_iso_639_real__get_fields;
	G_OBJECT_CLASS (klass)->finalize = libisocodes_iso_639_finalize;
}


static void libisocodes_iso_639_instance_init (libisocodesISO_639 * self) {
}


static void libisocodes_iso_639_finalize (GObject* obj) {
	libisocodesISO_639 * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LIBISOCODES_TYPE_ISO_639, libisocodesISO_639);
	xmlCleanupParser ();
	G_OBJECT_CLASS (libisocodes_iso_639_parent_class)->finalize (obj);
}


GType libisocodes_iso_639_get_type (void) {
	static volatile gsize libisocodes_iso_639_type_id__volatile = 0;
	if (g_once_init_enter (&libisocodes_iso_639_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (libisocodesISO_639Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) libisocodes_iso_639_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (libisocodesISO_639), 0, (GInstanceInitFunc) libisocodes_iso_639_instance_init, NULL };
		GType libisocodes_iso_639_type_id;
		libisocodes_iso_639_type_id = g_type_register_static (LIBISOCODES_TYPE_ISO_CODES, "libisocodesISO_639", &g_define_type_info, 0);
		g_once_init_leave (&libisocodes_iso_639_type_id__volatile, libisocodes_iso_639_type_id);
	}
	return libisocodes_iso_639_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



