#if   !defined(__FOO_HPP)
#define  __FOO_HPP
/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

DECLARE_CLASS( Foo );

/**
Class Foo describes the target interface that we want to adapt other
objects or classes with different interfaces to behave like.

Foo is an abstract class that specifies a screen coordinate system that
is based on that 0,0 (X,Y) is the top left hand corner of the screen. We
mock up the max dimensions to assume Xmax is 5 and Ymax is 5 inclusive.
Attempting to fix to a point outside of the dimensions results in an
exception.

The minimum and maximum positions are fixed in static members because
the original developer once declared "Who needs more than 5 pixels?"
*/

class Foo
{

public:

                     /// Default Constructor

                     Foo( void );

                     /// Copy constructor

                     Foo( FooCref );

                     /// Destructor

   virtual           ~Foo( void );

   //
   // Operator overloads
   //

            /// Assignment operator

            FooRef   operator=( FooCref );

            /// Equality operator

            bool     operator==( FooCref );

   //
   // Accessors
   //

            /// Return the Y coordinate of the point

   virtual  CORELINUX(IntCref)  getVerticalPosition( void ) const = 0;

            /// Return the X coordinate of the point

   virtual  CORELINUX(IntCref)  getHorizontalPosition( void ) const = 0;
                     
   //
   // Mutators
   //
            /// Sets the Y coordinate

   virtual  void     setVerticalPosition( CORELINUX(Int) ) 
                        throw(CORELINUX(Exception)) = 0;

            /// Sets the X coordinate

   virtual  void     setHorizontalPosition( CORELINUX(Int) ) 
                        throw(CORELINUX(Exception)) = 0;


protected:

            /// Return minimum Y

   static   CORELINUX(IntCref)  getMinimumVerticalPosition( void );

            /// Return maximum Y

   static   CORELINUX(IntCref)  getMaximumVerticalPosition( void );

            /// Return minimum X

   static   CORELINUX(IntCref)  getMinimumHorizontalPosition( void );

            /// Return maximum X

   static   CORELINUX(IntCref)  getMaximumHorizontalPosition( void );

protected:

            /// Fixed minimum Y

   static   CORELINUX(Int)   theMinimumVertical;

            /// Fixed maximum Y

   static   CORELINUX(Int)   theMaximumVertical;

            /// Fixed minimum X

   static   CORELINUX(Int)   theMinimumHorizontal;

            /// Fixed maximum X

   static   CORELINUX(Int)   theMaximumHorizontal;

};

#endif

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.4 $
   $Date: 2000/02/10 14:32:20 $
   $Locker:  $
*/

