#ifndef __REPLACE_H__ /* file wrapper */
#define __REPLACE_H__

/*
 * Jeffrey Friedl
 * Omron Corporation			ʳ
 * Nagaokakyoshi, Japan			617Ĺ
 *
 * jfriedl@nff.ncl.omron.co.jp
 *
 * This work is placed under the terms of the GNU General Purpose License
 * (the "GNU Copyleft").
 */


#define APP_SUB_SUCCESS			  0
#define APP_SUB_PAREN_INFO_NOT_ENOUGH	100
#define APP_SUB_DID_NOT_MATCH		101

extern unsigned
apply_substitution(const regex_t *compiled,
		   unsigned char **new,
		   unsigned *matchcount,
		   const unsigned char *str,
		   unsigned str_len,
		   const unsigned char *replace,
		   unsigned count);

unsigned char *
sub(const unsigned char *str, unsigned stringlen,
    const unsigned char *pattern,
    const unsigned char *replace,
    unsigned flags,
    unsigned times);


#define constant_sub(RESULT, PAT, PATFLAGS, STR, LEN, REPL, TIMES, NEW)      \
macro_start {                                                                \
    static int is_compiled = 0;                                              \
    static regex_t compiled;                                                 \
                                                                             \
    if (is_compiled == 0) {                                                  \
	int i = regcomp(&compiled, (PAT), (PATFLAGS));                       \
	assert(i == 0);                                                      \
	is_compiled = 1;                                                     \
    }                                                                        \
    (RESULT) = apply_substitution(&compiled, &(NEW), 0, (STR),               \
				  (LEN), (REPL), (TIMES));                   \
} macro_end

#endif /* file wrapper */
