; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

declare void @use(i1)

define void @test_unsigned_too_large(i128 %x) {
; CHECK-LABEL: @test_unsigned_too_large(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C_1:%.*]] = icmp ule i128 [[X:%.*]], 12345678901234123123123
; CHECK-NEXT:    br i1 [[C_1]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[C_2:%.*]] = icmp ult i128 [[X]], -12345678901234123123123
; CHECK-NEXT:    call void @use(i1 [[C_2]])
; CHECK-NEXT:    [[C_3:%.*]] = icmp uge i128 [[X]], -12345678901234123123123
; CHECK-NEXT:    call void @use(i1 [[C_3]])
; CHECK-NEXT:    [[C_4:%.*]] = icmp uge i128 [[X]], -12345678901234123123123
; CHECK-NEXT:    call void @use(i1 [[C_4]])
; CHECK-NEXT:    ret void
; CHECK:       bb2:
; CHECK-NEXT:    ret void
;
entry:
  %c.1 = icmp ule i128 %x, 12345678901234123123123
  br i1 %c.1, label %bb1, label %bb2

bb1:
  %c.2 = icmp ult i128 %x, -12345678901234123123123
  call void @use(i1 %c.2)
  %c.3 = icmp uge i128 %x, -12345678901234123123123
  call void @use(i1 %c.3)
  %c.4 = icmp uge i128 %x, -12345678901234123123123
  call void @use(i1 %c.4)
  ret void

bb2:
  ret void
}

define void @test_signed_too_large(i128 %x) {
; CHECK-LABEL: @test_signed_too_large(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C_1:%.*]] = icmp sle i128 [[X:%.*]], 12345678901234123123123
; CHECK-NEXT:    br i1 [[C_1]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[C_2:%.*]] = icmp slt i128 [[X]], -12345678901234123123123
; CHECK-NEXT:    call void @use(i1 [[C_2]])
; CHECK-NEXT:    [[C_3:%.*]] = icmp sge i128 [[X]], -12345678901234123123123
; CHECK-NEXT:    call void @use(i1 [[C_3]])
; CHECK-NEXT:    [[C_4:%.*]] = icmp sge i128 [[X]], -12345678901234123123123
; CHECK-NEXT:    call void @use(i1 [[C_4]])
; CHECK-NEXT:    ret void
; CHECK:       bb2:
; CHECK-NEXT:    ret void
;
entry:
  %c.1 = icmp sle i128 %x, 12345678901234123123123
  br i1 %c.1, label %bb1, label %bb2

bb1:
  %c.2 = icmp slt i128 %x, -12345678901234123123123
  call void @use(i1 %c.2)
  %c.3 = icmp sge i128 %x, -12345678901234123123123
  call void @use(i1 %c.3)
  %c.4 = icmp sge i128 %x, -12345678901234123123123
  call void @use(i1 %c.4)
  ret void

bb2:
  ret void
}

define i1 @add_decomp_i80(i80 %a) {
; CHECK-LABEL: @add_decomp_i80(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i80 [[A:%.*]], -1973801615886922022913
; CHECK-NEXT:    [[C:%.*]] = icmp ult i80 [[ADD]], 1346612317380797267967
; CHECK-NEXT:    br i1 [[C]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[ADD_1:%.*]] = add nsw i80 [[A]], -1973801615886922022913
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i80 [[ADD_1]], 1346612317380797267967
; CHECK-NEXT:    ret i1 [[C_1]]
; CHECK:       else:
; CHECK-NEXT:    ret i1 false
;
entry:
  %add = add nsw i80 %a, -1973801615886922022913
  %c = icmp ult i80 %add, 1346612317380797267967
  br i1 %c, label %then, label %else

then:
  %add.1 = add nsw i80 %a, -1973801615886922022913
  %c.1 = icmp ult i80 %add.1, 1346612317380797267967
  ret i1 %c.1

else:
  ret i1 false
}

define i1 @sub_decomp_i80(i80 %a) {
; CHECK-LABEL: @sub_decomp_i80(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SUB:%.*]] = sub nuw i80 [[A:%.*]], 1973801615886922022913
; CHECK-NEXT:    [[C:%.*]] = icmp ult i80 [[SUB]], 1346612317380797267967
; CHECK-NEXT:    br i1 [[C]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[SUB_1:%.*]] = sub nuw i80 [[A]], 1973801615886922022913
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i80 [[SUB_1]], 1346612317380797267967
; CHECK-NEXT:    ret i1 [[C_1]]
; CHECK:       else:
; CHECK-NEXT:    ret i1 false
;
entry:
  %sub = sub nuw i80 %a, 1973801615886922022913
  %c = icmp ult i80 %sub, 1346612317380797267967
  br i1 %c, label %then, label %else

then:
  %sub.1 = sub nuw i80 %a, 1973801615886922022913
  %c.1 = icmp ult i80 %sub.1, 1346612317380797267967
  ret i1 %c.1

else:
  ret i1 false
}

define i1 @gep_decomp_i80(i8* %a) {
; CHECK-LABEL: @gep_decomp_i80(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds i8, i8* [[A:%.*]], i80 1973801615886922022913
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8* [[GEP]], null
; CHECK-NEXT:    br i1 [[C]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[GEP_1:%.*]] = getelementptr inbounds i8, i8* [[A]], i80 1973801615886922022913
; CHECK-NEXT:    [[C_1:%.*]] = icmp eq i8* [[GEP_1]], null
; CHECK-NEXT:    ret i1 [[C_1]]
; CHECK:       else:
; CHECK-NEXT:    ret i1 false
;
entry:
  %gep = getelementptr inbounds i8, i8* %a, i80 1973801615886922022913
  %c = icmp eq i8* %gep, null
  br i1 %c, label %then, label %else

then:
  %gep.1 = getelementptr inbounds i8, i8* %a, i80 1973801615886922022913
  %c.1 = icmp eq i8* %gep.1, null
  ret i1 %c.1

else:
  ret i1 false
}

define i1 @gep_zext_shl_decomp_i80(i8* %a, i80 %v) {
; CHECK-LABEL: @gep_zext_shl_decomp_i80(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SHL:%.*]] = shl nuw i80 [[V:%.*]], 1973801615886922022913
; CHECK-NEXT:    [[EXT:%.*]] = zext i80 [[SHL]] to i128
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds i8, i8* [[A:%.*]], i128 [[EXT]]
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8* [[GEP]], null
; CHECK-NEXT:    br i1 [[C]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[SHL_1:%.*]] = shl nuw i80 [[V]], 1973801615886922022913
; CHECK-NEXT:    [[EXT_1:%.*]] = zext i80 [[SHL_1]] to i128
; CHECK-NEXT:    [[GEP_1:%.*]] = getelementptr inbounds i8, i8* [[A]], i128 [[EXT_1]]
; CHECK-NEXT:    [[C_1:%.*]] = icmp eq i8* [[GEP_1]], null
; CHECK-NEXT:    ret i1 [[C_1]]
; CHECK:       else:
; CHECK-NEXT:    ret i1 false
;
entry:
  %shl = shl nuw i80 %v, 1973801615886922022913
  %ext = zext i80 %shl to i128
  %gep = getelementptr inbounds i8, i8* %a, i128 %ext
  %c = icmp eq i8* %gep, null
  br i1 %c, label %then, label %else

then:
  %shl.1 = shl nuw i80 %v, 1973801615886922022913
  %ext.1 = zext i80 %shl.1 to i128
  %gep.1 = getelementptr inbounds i8, i8* %a, i128 %ext.1
  %c.1 = icmp eq i8* %gep.1, null
  ret i1 %c.1

else:
  ret i1 false
}

define i1 @gep_zext_add_decomp_i80(i8* %a, i80 %v) {
; CHECK-LABEL: @gep_zext_add_decomp_i80(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i80 [[V:%.*]], 1973801615886922022913
; CHECK-NEXT:    [[EXT:%.*]] = zext i80 [[ADD]] to i128
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds i8, i8* [[A:%.*]], i128 [[EXT]]
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8* [[GEP]], null
; CHECK-NEXT:    br i1 [[C]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[ADD_1:%.*]] = add nsw i80 [[V]], 1973801615886922022913
; CHECK-NEXT:    [[EXT_1:%.*]] = zext i80 [[ADD_1]] to i128
; CHECK-NEXT:    [[GEP_1:%.*]] = getelementptr inbounds i8, i8* [[A]], i128 [[EXT_1]]
; CHECK-NEXT:    [[C_1:%.*]] = icmp eq i8* [[GEP_1]], null
; CHECK-NEXT:    ret i1 [[C_1]]
; CHECK:       else:
; CHECK-NEXT:    ret i1 false
;
entry:
  %add = add nsw i80 %v, 1973801615886922022913
  %ext = zext i80 %add to i128
  %gep = getelementptr inbounds i8, i8* %a, i128 %ext
  %c = icmp eq i8* %gep, null
  br i1 %c, label %then, label %else

then:
  %add.1 = add nsw i80 %v, 1973801615886922022913
  %ext.1 = zext i80 %add.1 to i128
  %gep.1 = getelementptr inbounds i8, i8* %a, i128 %ext.1
  %c.1 = icmp eq i8* %gep.1, null
  ret i1 %c.1

else:
  ret i1 false
}

define i1 @gep_shl_decomp_i80(i8* %a, i80 %v) {
; CHECK-LABEL: @gep_shl_decomp_i80(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SHL:%.*]] = shl nuw i80 [[V:%.*]], 1973801615886922022913
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds i8, i8* [[A:%.*]], i80 [[SHL]]
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8* [[GEP]], null
; CHECK-NEXT:    br i1 [[C]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[SHL_1:%.*]] = shl nuw i80 [[V]], 1973801615886922022913
; CHECK-NEXT:    [[GEP_1:%.*]] = getelementptr inbounds i8, i8* [[A]], i80 [[SHL_1]]
; CHECK-NEXT:    [[C_1:%.*]] = icmp eq i8* [[GEP_1]], null
; CHECK-NEXT:    ret i1 [[C_1]]
; CHECK:       else:
; CHECK-NEXT:    ret i1 false
;
entry:
  %shl = shl nuw i80 %v, 1973801615886922022913
  %gep = getelementptr inbounds i8, i8* %a, i80 %shl
  %c = icmp eq i8* %gep, null
  br i1 %c, label %then, label %else

then:
  %shl.1 = shl nuw i80 %v, 1973801615886922022913
  %gep.1 = getelementptr inbounds i8, i8* %a, i80 %shl.1
  %c.1 = icmp eq i8* %gep.1, null
  ret i1 %c.1

else:
  ret i1 false
}

define i1 @gep_add_decomp_i80(i8* %a, i80 %v) {
; CHECK-LABEL: @gep_add_decomp_i80(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i80 [[V:%.*]], 1973801615886922022913
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds i8, i8* [[A:%.*]], i80 [[ADD]]
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8* [[GEP]], null
; CHECK-NEXT:    br i1 [[C]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[ADD_1:%.*]] = add nsw i80 [[V]], 1973801615886922022913
; CHECK-NEXT:    [[GEP_1:%.*]] = getelementptr inbounds i8, i8* [[A]], i80 [[ADD_1]]
; CHECK-NEXT:    [[C_1:%.*]] = icmp eq i8* [[GEP_1]], null
; CHECK-NEXT:    ret i1 [[C_1]]
; CHECK:       else:
; CHECK-NEXT:    ret i1 false
;
entry:
  %add = add nsw i80 %v, 1973801615886922022913
  %gep = getelementptr inbounds i8, i8* %a, i80 %add
  %c = icmp eq i8* %gep, null
  br i1 %c, label %then, label %else

then:
  %add.1 = add nsw i80 %v, 1973801615886922022913
  %gep.1 = getelementptr inbounds i8, i8* %a, i80 %add.1
  %c.1 = icmp eq i8* %gep.1, null
  ret i1 %c.1

else:
  ret i1 false
}
