/* livi-window.h
 *
 * Copyright 2021 Purism SPC
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Author: Guido Günther <agx@sigxcpu.org>
 */

#pragma once

#include "livi-application.h"

#include <adwaita.h>

G_BEGIN_DECLS

#define LIVI_TYPE_WINDOW (livi_window_get_type())

G_DECLARE_FINAL_TYPE (LiviWindow, livi_window, LIVI, WINDOW, AdwApplicationWindow)

void livi_window_set_empty_state (LiviWindow *self);
void livi_window_set_error_state (LiviWindow *self, const char *description);
void livi_window_set_play (LiviWindow *self);
void livi_window_set_pause (LiviWindow *self);
void livi_window_play_uri (LiviWindow *self, const LiviUrlInfo *url, const char *ref_uri);
void livi_window_set_letterbox (LiviWindow *self, gboolean letterbox);
gboolean livi_window_get_letterbox (LiviWindow *self);
void livi_window_set_loop (LiviWindow *self, gboolean loop);
gboolean livi_window_get_loop (LiviWindow *self);

G_END_DECLS
