package latexDraw.ui.dialog;

import java.awt.*;
import java.io.File;

import javax.swing.*;

import latexDraw.lang.LaTeXDrawLang;


/** 
 * Define a JFileChooser that exports the drawing in a graphical format.<br>
 * <br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 * <br>
 * 04/08/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class ExportDialog extends JFileChooser
{
	private static final long serialVersionUID = 1L;

	/** The slide that allows to change the compression rate. */
	protected JSlider compressionSlide;
	
	/** The panel that contains the compression slider and its label. */
	protected JPanel pCompression;
	
	public static final String NAME_SLIDE_COMPRESSION = "slideComp";//$NON-NLS-1$
	
	public static final int DEFAULT_COMPRESSION_RATE = 20;
	
	
	public ExportDialog(String path)
	{
		super(path);
		
		setApproveButtonText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.171")); //$NON-NLS-1$
		setAcceptAllFileFilterUsed(true);
		setMultiSelectionEnabled(false);
 		setFileSelectionMode(JFileChooser.FILES_ONLY);
		setDragEnabled(true);
  
 		pCompression = new JPanel();
 		pCompression.setLayout(new BoxLayout(pCompression, BoxLayout.X_AXIS)); 
 		pCompression.add(new JLabel(LaTeXDrawLang.getDialogFrameString("ExportDialog.0"))); //$NON-NLS-1$
 		compressionSlide = new JSlider(0, 100, DEFAULT_COMPRESSION_RATE);
 		compressionSlide.setName(NAME_SLIDE_COMPRESSION);
 		compressionSlide.setMajorTickSpacing(10);
 		compressionSlide.setPaintTicks(true);
 		compressionSlide.setPaintLabels(true);

 		pCompression.add(compressionSlide);
 		
 		JPanel p = new JPanel();
 		Component c = getComponent(getComponentCount()-1);
 		
 		p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS)); 
 		p.add(pCompression);
 		p.add(c);
 		
 		add(p, BorderLayout.SOUTH);
 		
 		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
  		setLocation(dim.width/2-getWidth()/2, dim.height/2-getHeight()/2);
	}

	
	
	
	@Override
	public int showDialog(Component parent, String approveButtonText) throws HeadlessException
	{
		pCompression.setVisible(accept(new File("test.jpg")));//$NON-NLS-1$
		
		return super.showDialog(parent, approveButtonText);
	}



	/**
	 * @return The compression rate if the filter accepts jpg files, else return -1.
	 * @since 1.9.2
	 */
	public int getCompressionRate()
	{
		if(accept(new File("test.jpg")))//$NON-NLS-1$
			return compressionSlide.getValue();
		return -1;
	}
}
