package junit.test.svg;

import java.text.ParseException;

import junit.framework.TestCase;
import latexDraw.parsers.svg.elements.path.SVGPathSeg;
import latexDraw.parsers.svg.elements.path.SVGPathSegCurvetoCubicSmooth;
import latexDraw.parsers.svg.elements.path.SVGPathSegMoveto;
import latexDraw.parsers.svg.elements.path.SVGPathSeg.PathSeg;
import latexDraw.parsers.svg.parsers.SVGPathHandler;
import latexDraw.parsers.svg.parsers.SVGPathParser;

import org.junit.Test;

/** 
 * This class contains tests for the SVGPathSegCurvetoCubicSmooth class.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 10/22/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
@SuppressWarnings("nls")
public class TestSVGPathSegCurvetoCubicSmooth extends TestCase implements SVGPathHandler
{
	protected final SVGPathSegCurvetoCubicSmooth seg = new SVGPathSegCurvetoCubicSmooth(0.8E2, -2., -5.e-1, .5, false);
	protected int cpt = 0;
	
	@Test
	public void testGetters()
	{
		assertEquals(seg.getX(), 0.8E2);
		assertEquals(seg.getX2(), -5.e-1);
		assertEquals(seg.getY(), -2.);
		assertEquals(seg.getY2(), .5);
		assertFalse(seg.isRelative());
		assertEquals(seg.getType(), PathSeg.CURVETO_CUBIC_SMOOTH_ABS);
	}
	
	
	@Test
	public void testToString()
	{
		SVGPathSegMoveto m = new SVGPathSegMoveto(0, 0, false);
		SVGPathParser parser = new SVGPathParser(m.toString() + " " + seg.toString(), this);
		
		try { parser.parse(); }
		catch(ParseException e) { fail(); }
	}


	
	public void onPathSeg(SVGPathSeg pathSeg)
	{
		if((pathSeg instanceof SVGPathSegMoveto) && cpt==0)
		{
			cpt++;
			return ;
		}
		
		assertTrue(pathSeg instanceof SVGPathSegCurvetoCubicSmooth);
		
		SVGPathSegCurvetoCubicSmooth seg2 = (SVGPathSegCurvetoCubicSmooth)pathSeg;		
		
		assertEquals(seg.getX(), seg2.getX());
		assertEquals(seg.getX2(), seg2.getX2());
		assertEquals(seg.getY(), seg2.getY());
		assertEquals(seg.getY2(), seg2.getY2());
		assertEquals(seg.isRelative(), seg2.isRelative());
	}
}
