import time

from juju.lib.testing import TestCase
from juju.lib.cache import CachedValue


class CachedValueTest(TestCase):

    def test_cache_value(self):

        cache = CachedValue(10)
        cache.set(10)
        self.assertEqual(cache.get(), 10)

        n = time.time() + (3600 * 24)
        now = self.mocker.replace(time.time)
        now()
        self.mocker.result(n)
        self.mocker.replay()
        self.assertEqual(cache.get(), None)
