/*
 * File    : CheckBoxTree.java
 * Created : 15-jul-2004 14:12
 * By      : fbusquets
 *
 * JClic - Authoring and playing system for educational activities
 *
 * Copyright (C) 2000 - 2005 Francesc Busquets & Departament
 * d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 */

package edu.xtec.jclic.beans;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

/**
 *
 * @author Francesc Busquets (fbusquets@xtec.net)
 * @version 1.0
 */
public class CheckBoxTree extends javax.swing.JTree {
    
    /** Creates new form BeanForm */
    public CheckBoxTree() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents

        setCellRenderer(new CellRenderer());
        addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                treeMouseClicked(evt);
            }
        });

    }//GEN-END:initComponents

    private void treeMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_treeMouseClicked

        Point pt=evt.getPoint();
        TreePath tp=getPathForLocation(pt.x, pt.y);
        if(tp!=null && tp.getLastPathComponent() instanceof CheckBoxTreeObject){
            ((CheckBoxTreeObject)tp.getLastPathComponent()).switchSelected();
            repaint(getPathBounds(tp));
        }
        
    }//GEN-LAST:event_treeMouseClicked
    
            
    class CellRenderer extends DefaultTreeCellRenderer{
        JCheckBox checkBox=new JCheckBox(){
            public void paint(Graphics g){
                if(hasFocus){
                    Color bsColor=getBorderSelectionColor();
                    if(bsColor!=null){
                        g.setColor(bsColor);
                        g.drawRect(0, 0, getWidth()-1, getHeight()-1);
                    }
                }
                super.paint(g);
            }
        };
        
        public CellRenderer(){
            super();
            checkBox.setBackground(getBackground());
            checkBox.setOpaque(isOpaque());
            checkBox.setFont(getFont());
            checkBox.setForeground(getForeground());            
        }
        
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus){
            Component result=super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if(value instanceof CheckBoxTreeObject){
                CheckBoxTreeObject cho=(CheckBoxTreeObject)value;
                checkBox.setText(cho.getLabel());
                checkBox.setSelected(cho.isSelected());
                checkBox.setEnabled(tree.isEnabled());
                checkBox.setComponentOrientation(tree.getComponentOrientation());
                result=checkBox;
            }
            return result;                        
        }
        
    }
    
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    
}
