#!/bin/sh

set -e

BASE_REL=$(dpkg-parsechangelog 2>/dev/null | sed -ne 's/Version: \([0-9]\)~.*/\1/p')
OLDDIR=${PWD}
GOS_DIR=${OLDDIR}/get-orig-source
SVN_COMMIT='svn log http://svn.drobilla.net/lad/trunk/jalv/ -l 1 | sed -ne "s/r\([0-9]\+\).*/\1/p"'

if [ -z ${BASE_REL} ]; then
	echo 'Please run this script from the sources root directory.'
	exit 1
fi


rm -rf ${GOS_DIR}
mkdir ${GOS_DIR} && cd ${GOS_DIR}
JALV_SVN_COMMIT=$(eval "${SVN_COMMIT}")
svn export -r ${JALV_SVN_COMMIT} http://svn.drobilla.net/lad/trunk/jalv/ \
	jalv-${BASE_REL}~svn${JALV_SVN_COMMIT}
cd jalv-${BASE_REL}~svn${JALV_SVN_COMMIT}/
cd .. && tar cjf \
	${OLDDIR}/jalv_${BASE_REL}~svn${JALV_SVN_COMMIT}.orig.tar.bz2 \
	jalv-${BASE_REL}~svn${JALV_SVN_COMMIT} --exclude-vcs
rm -rf ${GOS_DIR}
