#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (C) 2008-2009 Alessio Treglia
# Copyright (C) 2008 Andrea Gasparini <gaspa@yattaweb.it>
#
# This file is part of installation-report-generator.
#
# installation-report-generator is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# installation-report-generator is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with installation-report-generator.  If not, see <http://www.gnu.org/licenses/>.

distributions = [
    'Ubuntu',
    'Kubuntu',
    'Xubuntu',
    'Edubuntu',
    'Ubuntu Studio'
    ]

releases = {
    '9.04' : 'Jaunty Jackalope',
    '8.10' : 'Intrepid Ibex',
    '8.04' : 'Hardy Heron',
    '7.10' : 'Gutsy Gibbon',
    '6.06' : 'Dapper Drake'
    }

notebook_it = \
"""#format wiki
#LANGUAGE it
[[BR]]
||<tablestyle="width:37%%; float:right; margin:12px 0px 0px 0px; font-size:10px" style="background-image: url(http://wiki.ubuntu-it.org/NotebookModello?action=AttachFile&amp;do=get&amp;target=template-indice-top-sx.png);  border:none;" 15%% >[[BR]] ||||<style="border:none; background-color:#eae5da;" : 35%%> {*} '''Scheda tecnica'''||<style="background-image: url(http://wiki.ubuntu-it.org/NotebookModello/?action=AttachFile&amp;do=get&amp;target=template-indice-top-dx.png); background-position: top right; border:none; " 15%%>[[BR]] ||
||<#eae5da : 15%% style="border: medium none ;">||<#eae5da : 35%% style="border: medium none ;"(> '''Marca:'''||<#eae5da : 35%% style="border: medium none ;"(> %(vendor)s||<#eae5da : 15%% style="border: medium none ;">||
||<#eae5da : 15%% style="border: medium none ;">||<#eae5da : 35%% style="border: medium none ;"(> '''Modello:'''||<#eae5da : 35%% style="border: medium none ;"(> %(model)s||<#eae5da : 15%% style="border: medium none ;">||
||<#eae5da : 15%% style="border: medium none ;">||<#eae5da : 35%% style="border: medium none ;"(> '''Memoria RAM:'''||<#eae5da : 35%% style="border: medium none ;"(> %(memory)s||<#eae5da : 15%% style="border: medium none ;">||
||<#eae5da : 15%% style="border: medium none ;">||<#eae5da : 35%% style="border: medium none ;"(> '''Processore:'''||<#eae5da : 35%% style="border: medium none ;"(> %(cpu)s||<#eae5da : 15%% style="border: medium none ;">||
||<#eae5da : 15%% style="border: medium none ;">||<#eae5da : 35%% style="border: medium none ;"(> '''Scheda video:'''||<#eae5da : 35%% style="border: medium none ;"(> %(vga)s||<#eae5da : 15%% style="border: medium none ;">||
||<#eae5da : 15%% style="border: medium none ;">||<#eae5da : 35%% style="border: medium none ;"(> '''Distribuzione utilizzata:'''||<#eae5da : 35%% style="border: medium none ;"(>Ubuntu %(release)s «%(codename)s» ||<#eae5da : 15%% style="border: medium none ;">||
||<style="background-image: url(http://wiki.ubuntu-it.org/NotebookModello/?action=AttachFile&amp;do=get&amp;target=template-indice-bot-sx.png); border:none;background-position: bottom left;" 15%% >[[BR]]  ||<style="border:none; background-color:#eae5da;" -2 >[[BR]] ||<style="background-image: url(http://wiki.ubuntu-it.org/NotebookModello/?action=AttachFile&amp;do=get&amp;target=template-indice-bot-dx.png); background-position: bottom right; border:none; " 15%% >[[BR]] ||

||<style="border:none;">[[Immagine(NotebookModello/notebookprova.png,150,)]] ||<style="border:none;">In questa pagina è riportato il resoconto dell'installazione di '''Ubuntu %(release)s''' «'''%(codename)s'''» sul portatile '''%(vendor)s %(model)s'''.||
Inoltre verranno riportate le informazioni generali sul riconoscimento dell'hardware e i possibili metodi di installazione.

= Installazione =

= Rilevamento dell'hardware =

== Dispositivi connessi ==

Per verificare il corretto rilevamento dell'hardware del portatile, digitare in un terminale il seguente comando:
{{{
lspci
}}}

Il comando precedente restituirà una schermata simile alla seguente:
{{{
%(peripherals)s
}}}

== Processore ==

Per visualizzare i dettagli sul processore, aprire in lettura il file `/proc/cpuinfo`, digitando in una finestra di terminale il seguente comando:
{{{
cat /proc/cpuinfo
}}}

Il risultato sarà simile al seguente:
{{{
%(cpuinfo)s
}}}

||<tablestyle="text-align: justify; width:100%%; " style="border:none;" 5%%>[[Immagine(Icone/Piccole/warning.png,100,left)]] ||<style="padding:0.5em; border:none;">'''I valori differiscono a seconda dei modelli di processori, qui si fa riferimento al ''%(cpu)s''.''' ||

= Configurazione dei componenti =

Inserire un elenco dei componenti con le relative istruzioni utili alla loro configurazione. A seconda della situazione, si potranno verificare due casi:
 * Se il componente è stato riconosciuto in modo automatico, inserire il seguente testo:
''Riconosciuto/a automaticamente'' {OK}
 * Se il componente non è stato riconosciuto (o lo è stato soltanto parzialmente), indicare la procedura per configurarlo affinché venga rilevato correttamente.

||<tablestyle="text-align: justify; width:100%%; " style="border:none;" 5%%>[[Immagine(Icone/Piccole/note.png,100,center)]] ||<style="padding:0.5em; border:none;">''Inserire solo i dispositivi il cui funzionamento è stato verificato.'' ||

== Scheda video ==

== Scheda audio ==

== Interfacce di rete ==

== Touchpad ==

== Tasti rapidi ==

== Bluetooth ==

= Ulteriori risorse =

 * [%(website)s Sito ufficiale del produttore]
----
CategoryHardware"""



notebook_en = \
"""#format wiki
#LANGUAGE en
[[BR]]
||<tablestyle="width:37%%; float:right; margin:12px 0px 0px 0px; font-size:10px" style="background-image: url(http://wiki.ubuntu-it.org/NotebookModello?action=AttachFile&amp;do=get&amp;target=template-indice-top-sx.png);  border:none;" 15%% >[[BR]] ||||<style="border:none; background-color:#eae5da;" : 35%%> {*} '''Data sheet'''||<style="background-image: url(http://wiki.ubuntu-it.org/NotebookModello/?action=AttachFile&amp;do=get&amp;target=template-indice-top-dx.png); background-position: top right; border:none; " 15%%>[[BR]] ||
||<#eae5da : 15%% style="border: medium none ;">||<#eae5da : 35%% style="border: medium none ;"(> '''Vendor:'''||<#eae5da : 35%% style="border: medium none ;"(> %(vendor)s||<#eae5da : 15%% style="border: medium none ;">||
||<#eae5da : 15%% style="border: medium none ;">||<#eae5da : 35%% style="border: medium none ;"(> '''Model:'''||<#eae5da : 35%% style="border: medium none ;"(> %(model)s||<#eae5da : 15%% style="border: medium none ;">||
||<#eae5da : 15%% style="border: medium none ;">||<#eae5da : 35%% style="border: medium none ;"(> '''Memory:'''||<#eae5da : 35%% style="border: medium none ;"(> %(memory)s||<#eae5da : 15%% style="border: medium none ;">||
||<#eae5da : 15%% style="border: medium none ;">||<#eae5da : 35%% style="border: medium none ;"(> '''Processor:'''||<#eae5da : 35%% style="border: medium none ;"(> %(cpu)s||<#eae5da : 15%% style="border: medium none ;">||
||<#eae5da : 15%% style="border: medium none ;">||<#eae5da : 35%% style="border: medium none ;"(> '''Video card:'''||<#eae5da : 35%% style="border: medium none ;"(> %(vga)s||<#eae5da : 15%% style="border: medium none ;">||
||<#eae5da : 15%% style="border: medium none ;">||<#eae5da : 35%% style="border: medium none ;"(> '''Distribution used:'''||<#eae5da : 35%% style="border: medium none ;"(>Ubuntu %(release)s «%(codename)s» ||<#eae5da : 15%% style="border: medium none ;">||
||<style="background-image: url(http://wiki.ubuntu-it.org/NotebookModello/?action=AttachFile&amp;do=get&amp;target=template-indice-bot-sx.png); border:none;background-position: bottom left;" 15%% >[[BR]]  ||<style="border:none; background-color:#eae5da;" -2 >[[BR]] ||<style="background-image: url(http://wiki.ubuntu-it.org/NotebookModello/?action=AttachFile&amp;do=get&amp;target=template-indice-bot-dx.png); background-position: bottom right; border:none; " 15%% >[[BR]] ||

||<style="border:none;">[[Immagine(NotebookModello/notebookprova.png,150,)]] ||<style="border:none;">This page reports the installation of '''Ubuntu %(release)s''' «'''%(codename)s'''» on a '''%(vendor)s %(model)s''' notebook.||
Are reported as wellgeneral informations about hardware and installation methods.

= Installation =

= Gathering hardware informations =

== Connectecd devices ==

Please verify the correct detection of the notebook devices, typing in a shell the following command:
{{{
lspci
}}}

Il comando precedente restituirà una schermata simile alla seguente:
It'll return an output like this:
{{{
%(peripherals)s
}}}

== Processor ==

In order to see processor details, you could read the file `/proc/cpuinfo`, typing in a shell the following command:
{{{
cat /proc/cpuinfo
}}}

The result should be like this:
{{{
%(cpuinfo)s
}}}

||<tablestyle="text-align: justify; width:100%%; " style="border:none;" 5%%>[[Immagine(Icone/Piccole/warning.png,100,left)]] ||<style="padding:0.5em; border:none;">'''Values could change on different models, values above are referring to ''%(cpu)s''.''' ||

= Components configuration =

Inserire un elenco dei componenti con le relative istruzioni utili alla loro configurazione. A seconda della situazione, si potranno verificare due casi:
Insert a list of components with some instruction related useful for his configuration. Depending on the situation, you could see two cases:
 * Se il componente è stato riconosciuto in modo automatico, inserire il seguente testo:
 * Il component went recognized automatically, inser the following text:
''Automatically recognized'' {OK}
 * Il the device was not recognized at all or partially, please insert the steps for configuring it correctly.

||<tablestyle="text-align: justify; width:100%%; " style="border:none;" 5%%>[[Immagine(Icone/Piccole/note.png,100,center)]] ||<style="padding:0.5em; border:none;">''Insert only those devices for which the functionality are virified.'' ||

== Video devices ==

== Audio devices ==

== Net interfaces ==

== Touchpad ==

== HotKey ==

== Bluetooth ==

= Other resources=

 * [%(website)s Official vendor site]
----
CategoryHardware"""
