/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_CL)


#include "iclinputchannel.h"


#include "ierror.h"
#include "isystem.h"

#include "iclshell.h"

#include <vtkCriticalSection.h>
#include <vtkIOStream.h>

#define USE_IO_THREAD

#ifdef USE_IO_THREAD
#include <vtkMultiThreader.h>
#endif


namespace iclInputChannel_Private
{
#ifdef USE_IO_THREAD
	VTK_THREAD_RETURN_TYPE ModalLineReader(void *data)
	{
		char c;
		vtkMultiThreader::ThreadInfo *ti = static_cast<vtkMultiThreader::ThreadInfo*>(data); IERROR_ASSERT(ti);
		char *out = static_cast<char*>(ti->UserData); IERROR_ASSERT(out);
		vtkSimpleCriticalSection mutex;

		while(1)
		{
			c = cin.get();
			while(*out != 0) iSystem::Sleep(10);

			mutex.Lock();
			*out = c;
			mutex.Unlock();
		}

		return VTK_THREAD_RETURN_VALUE;
	}
#endif
};


using namespace iParameter;
using namespace iclInputChannel_Private;


iclInputChannel::iclInputChannel()
{
	mInput = 0;

#ifdef USE_IO_THREAD
	mThreader = vtkMultiThreader::New(); IERROR_ASSERT(mThreader);
	mThreadId = mThreader->SpawnThread(ModalLineReader,&mInput);
#else
	mThreader = 0;
	mThreadId = 0;
#ifdef I_USE_CURSES
	initsrc();
#endif
#endif
}


iclInputChannel::~iclInputChannel()
{
#ifdef USE_IO_THREAD
	mThreader->TerminateThread(mThreadId);
	mThreader->Delete();
#else
#ifdef I_USE_CURSES
	endwin();
#endif
#endif
}


char iclInputChannel::NextChar()
{
#ifdef USE_IO_THREAD
	char ret = mInput;
	mInput = 0;
	return ret;
#else
#ifdef I_USE_CURSES
	return getch();
#else
	return cin.get();
#endif
#endif
}

#endif
