/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Routine;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementSchema;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.TableWorks;
import org.hsqldb.TextTable;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rights.User;
import org.hsqldb.scriptio.ScriptWriterText;
import org.hsqldb.store.BaseHashMap;

public class StatementCommand
extends Statement {
    Object[] parameters;

    StatementCommand(int n, Object[] objectArray) {
        this(n, objectArray, null, null);
    }

    StatementCommand(int n, Object[] objectArray, HsqlNameManager.HsqlName[] hsqlNameArray, HsqlNameManager.HsqlName[] hsqlNameArray2) {
        super(n);
        this.isTransactionStatement = true;
        this.parameters = objectArray;
        if (hsqlNameArray != null) {
            this.readTableNames = hsqlNameArray;
        }
        if (hsqlNameArray2 != null) {
            this.writeTableNames = hsqlNameArray2;
        }
        switch (n) {
            case 1205: {
                this.group = 2014;
                break;
            }
            case 1191: {
                this.group = 2009;
                this.statementReturnType = 2;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            case 1002: {
                this.group = 2014;
                this.isLogged = false;
                break;
            }
            case 1004: {
                String string = (String)this.parameters[0];
                if (string == null) {
                    this.statementReturnType = 2;
                }
                this.group = 2014;
                this.isLogged = false;
            }
            case 1001: {
                this.group = 2014;
                this.isLogged = false;
                break;
            }
            case 1025: 
            case 1026: 
            case 1052: {
                this.isTransactionStatement = false;
                this.group = 2013;
                break;
            }
            case 1015: {
                this.isTransactionStatement = false;
                this.group = 2013;
                break;
            }
            case 1011: 
            case 1012: 
            case 1013: 
            case 1014: 
            case 1016: 
            case 1018: 
            case 1019: 
            case 1020: 
            case 1023: 
            case 1024: 
            case 1031: 
            case 1032: 
            case 1033: 
            case 1034: 
            case 1035: 
            case 1036: 
            case 1040: 
            case 1041: 
            case 1046: 
            case 1047: 
            case 1048: 
            case 1049: 
            case 1050: 
            case 1051: {
                this.group = 2013;
                break;
            }
            case 1198: {
                this.group = 2012;
                break;
            }
            case 1196: {
                this.isLogged = false;
            }
            case 1195: {
                this.group = 2012;
                break;
            }
            case 1194: {
                this.group = 2012;
                break;
            }
            case 1003: {
                this.group = 2014;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            case 1197: {
                this.group = 2012;
                break;
            }
            case 1193: {
                this.group = 2013;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            case 1060: 
            case 1061: 
            case 1062: {
                this.group = 2013;
                this.isTransactionStatement = false;
                break;
            }
            case 1005: {
                this.group = 2011;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementCommand");
            }
        }
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(throwable, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
            return result;
        }
        try {
            if (this.isLogged) {
                session.database.logger.writeOtherStatement(session, this.sql);
            }
        }
        catch (Throwable throwable) {
            return Result.newErrorResult(throwable, this.sql);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result getResult(Session session) {
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        switch (this.type) {
            case 1205: {
                return this.getTruncateResult(session);
            }
            case 1191: {
                Statement statement = (Statement)this.parameters[0];
                return Result.newSingleColumnStringResult("OPERATION", statement.describe(session));
            }
            case 1001: {
                String string = (String)this.parameters[0];
                boolean bl = (Boolean)this.parameters[1];
                boolean bl2 = (Boolean)this.parameters[2];
                boolean bl3 = (Boolean)this.parameters[3];
                try {
                    session.checkAdmin();
                    if (!session.database.getType().equals("file:")) {
                        return Result.newErrorResult(Error.error(464));
                    }
                    if (session.database.isReadOnly()) {
                        return Result.newErrorResult(Error.error(459), null);
                    }
                    if (session.database.logger.isStoredFileAccess()) {
                        return Result.newErrorResult(Error.error(464), null);
                    }
                    session.database.logger.backup(string, bl2, bl, bl3);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1002: {
                boolean bl = (Boolean)this.parameters[0];
                session.database.lobManager.lock();
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.checkpoint(bl);
                    Result result = Result.updateZeroResult;
                    return result;
                }
                catch (HsqlException hsqlException) {
                    Result result = Result.newErrorResult(hsqlException, this.sql);
                    return result;
                }
                finally {
                    session.database.lobManager.unlock();
                }
            }
            case 1011: {
                try {
                    boolean bl = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setIncrementBackup(bl);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1012: {
                try {
                    int n = (Integer)this.parameters[0];
                    boolean bl = this.parameters[1] == null;
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (bl && !session.database.getProperties().validateProperty("hsqldb.cache_rows", n)) {
                        throw Error.error(5556);
                    }
                    session.database.logger.setCacheMaxRows(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1013: {
                try {
                    int n = (Integer)this.parameters[0];
                    boolean bl = this.parameters[1] == null;
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (bl && !session.database.getProperties().validateProperty("hsqldb.cache_size", n)) {
                        throw Error.error(5556);
                    }
                    session.database.logger.setCacheSize(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1016: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.isProcessingScript) {
                        session.database.logger.setLobFileScaleNoCheck(n);
                    } else {
                        session.database.logger.setLobFileScale(n);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1023: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.isProcessingScript) {
                        session.database.logger.setDataFileScaleNoCheck(n);
                    } else {
                        session.database.logger.setDataFileScale(n);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1014: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (!session.database.getProperties().validateProperty("hsqldb.defrag_limit", n)) {
                        throw Error.error(5556);
                    }
                    session.database.logger.setDefagLimit(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1015: {
                try {
                    int n = (Integer)this.parameters[0];
                    boolean bl = (Boolean)this.parameters[1];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setEventLogLevel(n, bl);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1020: {
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    Object object = this.parameters[0];
                    if (object instanceof Boolean) {
                        boolean bl = (Boolean)this.parameters[0];
                        session.database.logger.setNioDataFile(bl);
                    } else {
                        int n = (Integer)this.parameters[0];
                        session.database.logger.setNioMaxSize(n);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1018: {
                try {
                    boolean bl = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setLogData(bl);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1019: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setLogSize(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1025: {
                try {
                    String string = (String)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1024: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setScriptType(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1026: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setWriteDelay(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1033: {
                try {
                    Routine routine = (Routine)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.userManager.setExtAuthenticationFunction(routine);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1036: {
                try {
                    Routine routine = (Routine)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.userManager.setPasswordCheckFunction(routine);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1041: {
                try {
                    String string = (String)this.parameters[0];
                    boolean bl = (Boolean)this.parameters[1];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.collation.setCollation(string, bl);
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1046: {
                boolean bl = (Boolean)this.parameters[0];
                session.checkAdmin();
                session.checkDDLWrite();
                session.database.setReferentialIntegrity(bl);
                return Result.updateZeroResult;
            }
            case 1047: {
                String string = (String)this.parameters[0];
                boolean bl = (Boolean)this.parameters[1];
                int n = ((Number)this.parameters[2]).intValue();
                session.checkAdmin();
                session.checkDDLWrite();
                if (string == "sql.enforce_names") {
                    session.database.setStrictNames(bl);
                } else if (string == "sql.regular_names") {
                    session.database.setRegularNames(bl);
                } else if (string == "sql.enforce_size") {
                    session.database.setStrictColumnSize(bl);
                } else if (string == "sql.enforce_types") {
                    session.database.setStrictTypes(bl);
                } else if (string == "sql.enforce_refs") {
                    session.database.setStrictReferences(bl);
                } else if (string == "sql.enforce_tdc_delete") {
                    session.database.setStrictTDCD(bl);
                } else if (string == "sql.enforce_tdc_update") {
                    session.database.setStrictTDCU(bl);
                } else if (string == "jdbc.translate_tti_types") {
                    session.database.setTranslateTTI(bl);
                } else if (string == "sql.concat_nulls") {
                    session.database.setConcatNulls(bl);
                } else if (string == "sql.nulls_first") {
                    session.database.setNullsFirst(bl);
                } else if (string == "sql.unique_nulls") {
                    session.database.setUniqueNulls(bl);
                } else if (string == "sql.convert_trunc") {
                    session.database.setConvertTrunc(bl);
                } else if (string == "sql.avg_scale") {
                    session.database.setAvgScale(n);
                } else if (string == "sql.double_nan") {
                    session.database.setDoubleNaN(bl);
                } else if (string == "sql.longvar_is_lob") {
                    session.database.setLongVarIsLob(bl);
                } else if (string == "sql.syntax_db2") {
                    session.database.setSyntaxDb2(bl);
                } else if (string == "sql.syntax_mss") {
                    session.database.setSyntaxMss(bl);
                } else if (string == "sql.syntax_mys") {
                    session.database.setSyntaxMys(bl);
                } else if (string == "sql.syntax_ora") {
                    session.database.setSyntaxOra(bl);
                } else if (string == "sql.syntax_pgs") {
                    session.database.setSyntaxPgs(bl);
                }
                return Result.updateZeroResult;
            }
            case 1031: {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.parameters[0];
                session.checkAdmin();
                session.checkDDLWrite();
                session.database.schemaManager.setDefaultSchemaHsqlName(hsqlName);
                session.database.schemaManager.setSchemaChangeTimestamp();
                return Result.updateZeroResult;
            }
            case 1032: {
                Integer n = (Integer)this.parameters[0];
                session.checkAdmin();
                session.checkDDLWrite();
                session.database.schemaManager.setDefaultTableType(n);
                return Result.updateZeroResult;
            }
            case 1049: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.database.txManager.setTransactionControl(session, n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1050: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.database.defaultIsolationLevel = n;
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1051: {
                try {
                    boolean bl = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.database.txConflictRollback = bl;
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1034: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    JavaSystem.gcFrequency = n;
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1035: {
                try {
                    String string = (String)this.parameters[0];
                    Object object = this.parameters[1];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1040: {
                int n = (Integer)this.parameters[0];
                session.checkAdmin();
                session.database.setResultMaxMemoryRows(n);
                return Result.updateZeroResult;
            }
            case 1048: {
                try {
                    String string = (String)this.parameters[0];
                    HsqlProperties hsqlProperties = null;
                    session.checkAdmin();
                    if (string.length() > 0) {
                        hsqlProperties = HsqlProperties.delimitedArgPairsToProps(string, "=", ";", null);
                        if (hsqlProperties.getErrorKeys().length > 0) {
                            throw Error.error(482, hsqlProperties.getErrorKeys()[0]);
                        }
                        session.database.logger.setDefaultTextTableProperties(string, hsqlProperties);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1052: {
                try {
                    String string = (String)this.parameters[0];
                    session.checkAdmin();
                    session.database.setUniqueName(string);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1004: {
                ScriptWriterText scriptWriterText = null;
                String string = (String)this.parameters[0];
                try {
                    session.checkAdmin();
                    if (string == null) {
                        return session.database.getScript(false);
                    }
                    scriptWriterText = new ScriptWriterText(session.database, string, true, true, true);
                    scriptWriterText.writeAll();
                    scriptWriterText.close();
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1003: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.database.close(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1198: {
                try {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.parameters[0];
                    int[] nArray = (int[])this.parameters[1];
                    Table table = session.database.schemaManager.getTable(session, hsqlName.name, hsqlName.schema.name);
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    if (!table.isCached() && !table.isText()) {
                        throw Error.error(457);
                    }
                    Index index = table.getIndexForColumns(session, nArray);
                    if (index != null) {
                        Index[] indexArray = table.getIndexList();
                        for (int i = 0; i < indexArray.length; ++i) {
                            indexArray[i].setClustered(false);
                        }
                        index.setClustered(true);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1193: {
                try {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.parameters[0];
                    String string = (String)this.parameters[1];
                    Table table = session.database.schemaManager.getTable(session, hsqlName.name, hsqlName.schema.name);
                    if (session.isProcessingScript()) {
                        table.setIndexRoots(session, string);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1194: {
                try {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.parameters[0];
                    Table table = session.database.schemaManager.getTable(session, hsqlName.name, hsqlName.schema.name);
                    boolean bl = (Boolean)this.parameters[1];
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    table.setDataReadOnly(bl);
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1195: 
            case 1196: {
                try {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.parameters[0];
                    Table table = session.database.schemaManager.getTable(session, hsqlName.name, hsqlName.schema.name);
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    if (!table.isText()) {
                        HsqlException hsqlException = Error.error(321);
                        return Result.newErrorResult(hsqlException, this.sql);
                    }
                    if (this.parameters[1] != null) {
                        boolean bl = (Boolean)this.parameters[1];
                        if (bl) {
                            ((TextTable)table).connect(session);
                        } else {
                            ((TextTable)table).disconnect();
                        }
                        session.database.schemaManager.setSchemaChangeTimestamp();
                        return Result.updateZeroResult;
                    }
                    String string = (String)this.parameters[2];
                    boolean bl = (Boolean)this.parameters[3];
                    boolean bl4 = (Boolean)this.parameters[4];
                    if (bl4) {
                        ((TextTable)table).setHeader(string);
                    } else {
                        ((TextTable)table).setDataSource(session, string, bl, false);
                    }
                    return Result.updateZeroResult;
                }
                catch (Throwable throwable) {
                    HsqlException hsqlException;
                    if (!(throwable instanceof HsqlException)) {
                        hsqlException = Error.error(467, throwable.toString());
                    }
                    if (session.isProcessingLog() || session.isProcessingScript()) {
                        session.addWarning(hsqlException);
                        session.database.logger.logWarningEvent("Problem processing SET TABLE SOURCE", hsqlException);
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1197: {
                try {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.parameters[0];
                    int n = (Integer)this.parameters[1];
                    Table table = session.database.schemaManager.getUserTable(session, hsqlName.name, hsqlName.schema.name);
                    if (hsqlName.schema != SqlInvariants.LOBS_SCHEMA_HSQLNAME) {
                        StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    }
                    session.setScripting(true);
                    TableWorks tableWorks = new TableWorks(session, table);
                    tableWorks.setTableType(session, n);
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    if (hsqlName.schema == SqlInvariants.LOBS_SCHEMA_HSQLNAME) {
                        session.database.lobManager.compileStatements();
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1060: {
                User user = (User)this.parameters[0];
                boolean bl = (Boolean)this.parameters[1];
                session.checkAdmin();
                session.checkDDLWrite();
                user.isLocalOnly = bl;
                session.database.schemaManager.setSchemaChangeTimestamp();
                return Result.updateZeroResult;
            }
            case 1061: {
                try {
                    User user = (User)this.parameters[0];
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.parameters[1];
                    session.checkDDLWrite();
                    if (user == null) {
                        user = session.getUser();
                    } else {
                        session.checkAdmin();
                        session.checkDDLWrite();
                        user = session.database.userManager.get(user.getName().getNameString());
                    }
                    if (hsqlName != null) {
                        hsqlName = session.database.schemaManager.getSchemaHsqlName(hsqlName.name);
                    }
                    user.setInitialSchema(hsqlName);
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1062: {
                try {
                    User user = this.parameters[0] == null ? session.getUser() : (User)this.parameters[0];
                    String string = (String)this.parameters[1];
                    boolean bl = (Boolean)this.parameters[2];
                    session.checkDDLWrite();
                    session.setScripting(true);
                    session.database.userManager.setPassword(session, user, string, bl);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1005: {
                try {
                    long l = ((Number)this.parameters[0]).longValue();
                    int n = ((Number)this.parameters[1]).intValue();
                    Session session2 = session.database.sessionManager.getSession(l);
                    if (session2 == null) {
                        throw Error.error(4500);
                    }
                    switch (n) {
                        case 2: {
                            session2.resetSession();
                            break;
                        }
                        case 278: {
                            session2.sessionData.persistentStoreCollection.clearAllTables();
                            break;
                        }
                        case 236: {
                            session2.sessionData.closeAllNavigators();
                            break;
                        }
                        case 39: {
                            session2.abortTransaction = true;
                            session2.latch.setCount(0);
                            session2.close();
                            break;
                        }
                        case 233: {
                            session2.abortTransaction = true;
                            session2.latch.setCount(0);
                        }
                    }
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
                return Result.updateZeroResult;
            }
        }
        throw Error.runtimeError(201, "StatemntCommand");
    }

    Result getTruncateResult(Session session) {
        try {
            Object object;
            Object[] objectArray;
            Object object2;
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.parameters[0];
            boolean bl = (Boolean)this.parameters[1];
            boolean bl2 = (Boolean)this.parameters[2];
            if (hsqlName.type == 3) {
                object2 = session.database.schemaManager.getUserTable(session, hsqlName);
                objectArray = new Table[]{object2};
                session.getGrantee().checkDelete((SchemaObject)object2);
                if (!bl2) {
                    for (int i = 0; i < ((Table)object2).fkMainConstraints.length; ++i) {
                        HsqlNameManager.HsqlName hsqlName2;
                        if (((Table)object2).fkMainConstraints[i].getRef() == object2 || ((TableBase)(object = session.database.schemaManager.getUserTable(session, hsqlName2 = ((Table)object2).fkMainConstraints[i].getRef().getName()))).isEmpty(session)) continue;
                        throw Error.error(8, ((Table)object).getName().name);
                    }
                }
            } else {
                Object object3;
                session.database.schemaManager.getSchemaHsqlName(hsqlName.name);
                object2 = session.database.schemaManager.getTables(hsqlName.name);
                objectArray = new Table[((BaseHashMap)object2).size()];
                ((HashMappedList)object2).toValuesArray(objectArray);
                StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName);
                if (!bl2) {
                    object3 = new OrderedHashSet();
                    session.database.schemaManager.getCascadingReferencesToSchema(hsqlName, (OrderedHashSet)object3);
                    for (int i = 0; i < ((BaseHashMap)object3).size(); ++i) {
                        Table table;
                        object = (HsqlNameManager.HsqlName)((OrderedHashSet)object3).get(i);
                        if (((HsqlNameManager.HsqlName)object).type != 5 || ((HsqlNameManager.HsqlName)object).parent.type != 3 || (table = session.database.schemaManager.getUserTable(session, ((HsqlNameManager.HsqlName)object).parent)).isEmpty(session)) continue;
                        throw Error.error(8, table.getName().name);
                    }
                }
                if (bl) {
                    object3 = session.database.schemaManager.databaseObjectIterator(hsqlName.name, 7);
                    while (object3.hasNext()) {
                        NumberSequence numberSequence = (NumberSequence)object3.next();
                        numberSequence.reset();
                    }
                }
            }
            for (int i = 0; i < objectArray.length; ++i) {
                Object object4 = objectArray[i];
                PersistentStore persistentStore = ((Table)object4).getRowStore(session);
                persistentStore.removeAll();
                if (!bl || ((Table)object4).identitySequence == null) continue;
                ((Table)object4).identitySequence.reset();
            }
            return Result.updateZeroResult;
        }
        catch (HsqlException hsqlException) {
            return Result.newErrorResult(hsqlException, this.sql);
        }
    }

    @Override
    public ResultMetaData getResultMetaData() {
        switch (this.type) {
            case 1191: {
                return ResultMetaData.newSingleColumnMetaData("OPERATION");
            }
            case 1004: {
                if (this.statementReturnType != 2) break;
                return ResultMetaData.newSingleColumnMetaData("COMMANDS");
            }
        }
        return super.getResultMetaData();
    }

    @Override
    public boolean isAutoCommitStatement() {
        return this.isTransactionStatement;
    }

    @Override
    public String describe(Session session) {
        return this.sql;
    }
}

