<?php

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/function.filter-input.php )
   *
   *
   * @type       mixed   One of INPUT_GET, INPUT_POST, INPUT_COOKIE,
   *                     INPUT_SERVER, or INPUT_ENV.
   * @variable_name
   *             mixed   Name of a variable to get.
   * @filter     mixed   The ID of the filter to apply. The Types of filters
   *                     manual page lists the available filters.
   * @options    mixed   Associative array of options or bitwise disjunction
   *                     of flags. If filter accepts options, flags can be
   *                     provided in "flags" field of array.
   *
   * @return     mixed   Value of the requested variable on success, FALSE if
   *                     the filter fails, or NULL if the variable_name
   *                     variable is not set. If the flag
   *                     FILTER_NULL_ON_FAILURE is used, it returns FALSE if
   *                     the variable is not set and NULL if the filter
   *                     fails.
   */
function filter_input(int $type, $variable_name, $filter = FILTER_DEFAULT,
                      $options = null) {
  $var = __SystemLib_filter_input_get_var($type);

  if (!isset($var[$variable_name])) {
    if (is_array($options) && isset($options['options']) &&
        is_array($options['options']) &&
        isset($options['options']['default'])) {
      return $options['options']['default'];
    }
    return null;
  }
  return filter_var($var[$variable_name], $filter, $options);
}

<<__Native>>
function __SystemLib_filter_input_get_var(int $variable_name) : array;

/**
 * You almost never want this. It acts as though the request's globals
 * should be snapshotted now. Useful for unit tests that want to muck with
 * globals, and then lock them in.
 */
<<__Native>>
function _filter_snapshot_globals() : void;
