/*
 * Decompiled with CFR 0.152.
 */
package haxe.root;

import haxe.Exception;
import haxe.iterators.ArrayIterator;
import haxe.iterators.ArrayKeyValueIterator;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Function;
import haxe.jvm.Jvm;
import haxe.jvm.Object;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.root.Iterable;
import haxe.root.StringBuf;

@ClassReflectionInformation(hasSuperClass=false)
public final class Array<T>
extends Object
implements Iterable.Interface {
    public static int __hx_toString_depth = 0;
    public static int __hx_defaultCapacity = 4;
    public int length;
    public T[] __a;

    public static <X> Array<X> ofNative(X[] XArray) {
        Array a = new Array();
        a.length = XArray.length;
        a.__a = XArray;
        return a;
    }

    public static <Y> Array<Y> alloc(int size) {
        Array a = new Array();
        a.length = size;
        a.__a = new java.lang.Object[size];
        return a;
    }

    public T[] getNative() {
        java.lang.Object[] a = new java.lang.Object[this.length];
        System.arraycopy(this.__a, 0, a, 0, this.length);
        return a;
    }

    public Array<T> concat(Array<T> a) {
        int length = this.length;
        int len = length + a.length;
        java.lang.Object[] retarr = new java.lang.Object[len];
        System.arraycopy(this.__a, 0, retarr, 0, length);
        System.arraycopy(a.__a, 0, retarr, length, a.length);
        return Array.ofNative(retarr);
    }

    public void concatNative(T[] a) {
        T[] __a = this.__a;
        int length = this.length;
        int len = length + a.length;
        if (__a.length >= len) {
            System.arraycopy(a, 0, __a, length, length);
        } else {
            java.lang.Object[] newarr = new java.lang.Object[len];
            System.arraycopy(__a, 0, newarr, 0, length);
            System.arraycopy(a, 0, newarr, length, a.length);
            this.__a = newarr;
        }
        this.length = len;
    }

    public String join(String sep) {
        StringBuf buf = new StringBuf();
        int i = -1;
        boolean first = true;
        int length = this.length;
        while (++i < length) {
            if (first) {
                first = false;
            } else {
                buf.add(sep);
            }
            buf.add(this.__a[i]);
        }
        return buf.toString();
    }

    public T pop() {
        T[] __a = this.__a;
        int length = this.length;
        if (length > 0) {
            T val = __a[--length];
            __a[length] = null;
            this.length = length;
            return val;
        }
        return null;
    }

    public int push(T x) {
        int length = this.length;
        if (length >= this.__a.length) {
            int newLen = length == 0 ? 4 : length << 1;
            java.lang.Object[] newarr = new java.lang.Object[newLen];
            System.arraycopy(this.__a, 0, newarr, 0, this.__a.length);
            this.__a = newarr;
        }
        this.__a[length] = x;
        return ++this.length;
    }

    public void reverse() {
        int l = this.length;
        T[] a = this.__a;
        int half = l >> 1;
        --l;
        for (int i = 0; i < half; ++i) {
            T tmp = a[i];
            a[i] = a[l - i];
            a[l - i] = tmp;
        }
    }

    public T shift() {
        int l = this.length;
        if (l == 0) {
            return null;
        }
        T[] a = this.__a;
        T x = a[0];
        System.arraycopy(a, 1, a, 0, this.length - 1);
        a[--l] = null;
        this.length = l;
        return x;
    }

    public Array<T> slice(int pos, Integer end) {
        int len;
        if (pos < 0 && (pos = this.length + pos) < 0) {
            pos = 0;
        }
        if (end == null) {
            end = this.length;
        } else {
            Integer n = end;
            if (n == null ? false : Jvm.toInt(n) < 0) {
                end = this.length + Jvm.toInt(end);
            }
        }
        Integer n = end;
        if (n == null ? false : Jvm.toInt(n) > this.length) {
            end = this.length;
        }
        if ((len = Jvm.toInt(end) - pos) < 0) {
            return new Array<T>();
        }
        java.lang.Object[] newarr = new java.lang.Object[len];
        System.arraycopy(this.__a, pos, newarr, 0, len);
        return Array.ofNative(newarr);
    }

    public void sort(Function f) {
        if (this.length == 0) {
            return;
        }
        this.quicksort(0, this.length - 1, f);
    }

    public void quicksort(int lo, int hi, Function f) {
        T[] buf = this.__a;
        int i = lo;
        int j = hi;
        T p = buf[i + j >> 1];
        while (i <= j) {
            while (i < hi && f.invoke(buf[i], p) < 0) {
                ++i;
            }
            while (j > lo && f.invoke(buf[j], p) > 0) {
                --j;
            }
            if (i > j) continue;
            T t = buf[i];
            buf[i++] = buf[j];
            buf[j--] = t;
        }
        if (lo < j) {
            this.quicksort(lo, j, f);
        }
        if (i < hi) {
            this.quicksort(i, hi, f);
        }
    }

    public Array<T> splice(int pos, int len) {
        if (len < 0) {
            return new Array<T>();
        }
        if (pos < 0 && (pos = this.length + pos) < 0) {
            pos = 0;
        }
        if (pos > this.length) {
            pos = 0;
            len = 0;
        } else if (pos + len > this.length && (len = this.length - pos) < 0) {
            len = 0;
        }
        T[] a = this.__a;
        java.lang.Object[] ret = new java.lang.Object[len];
        System.arraycopy(a, pos, ret, 0, len);
        Array<java.lang.Object> ret2 = Array.ofNative(ret);
        int end = pos + len;
        System.arraycopy(a, end, a, pos, this.length - end);
        this.length -= len;
        while (--len >= 0) {
            a[this.length + len] = null;
        }
        return ret2;
    }

    public void spliceVoid(int pos, int len) {
        if (len < 0) {
            return;
        }
        if (pos < 0 && (pos = this.length + pos) < 0) {
            pos = 0;
        }
        if (pos > this.length) {
            pos = 0;
            len = 0;
        } else if (pos + len > this.length && (len = this.length - pos) < 0) {
            len = 0;
        }
        T[] a = this.__a;
        int end = pos + len;
        System.arraycopy(a, end, a, pos, this.length - end);
        this.length -= len;
        while (--len >= 0) {
            a[this.length + len] = null;
        }
    }

    public String toString() throws RuntimeException {
        if (__hx_toString_depth >= 5) {
            return "...";
        }
        ++__hx_toString_depth;
        try {
            String s = this.__hx_toString();
            --__hx_toString_depth;
            return s;
        }
        catch (Throwable _g) {
            java.lang.Object e = Exception.caught(_g).unwrap();
            --__hx_toString_depth;
            throw (RuntimeException)Exception.thrown(e);
        }
    }

    public String __hx_toString() {
        StringBuf ret = new StringBuf();
        T[] a = this.__a;
        ret.add("[");
        boolean first = true;
        int _g = 0;
        int _g1 = this.length;
        while (_g < _g1) {
            int i = _g++;
            if (first) {
                first = false;
            } else {
                ret.add(",");
            }
            ret.add(a[i]);
        }
        ret.add("]");
        return ret.toString();
    }

    public void unshift(T x) {
        int length = this.length;
        T[] __a = this.__a;
        if (length >= __a.length) {
            int newLen = (length << 1) + 1;
            java.lang.Object[] newarr = new java.lang.Object[newLen];
            System.arraycopy(__a, 0, newarr, 1, length);
            this.__a = newarr;
        } else {
            System.arraycopy(__a, 0, __a, 1, length);
        }
        this.__a[0] = x;
        ++this.length;
    }

    public void insert(int pos, T x) {
        int l = this.length;
        if (pos < 0 && (pos = l + pos) < 0) {
            pos = 0;
        }
        if (pos >= l) {
            this.push(x);
            return;
        }
        if (pos == 0) {
            this.unshift(x);
            return;
        }
        if (l >= this.__a.length) {
            int newLen = (this.length << 1) + 1;
            java.lang.Object[] newarr = new java.lang.Object[newLen];
            System.arraycopy(this.__a, 0, newarr, 0, pos);
            newarr[pos] = x;
            System.arraycopy(this.__a, pos, newarr, pos + 1, l - pos);
            this.__a = newarr;
            ++this.length;
            return;
        }
        T[] __a = this.__a;
        System.arraycopy(__a, pos, __a, pos + 1, l - pos);
        System.arraycopy(__a, 0, __a, 0, pos);
        __a[pos] = x;
        ++this.length;
    }

    public boolean remove(T x) {
        T[] __a = this.__a;
        int i = -1;
        int length = this.length;
        while (++i < length) {
            if (Jvm.compare(__a[i], x) != 0) continue;
            System.arraycopy(__a, i + 1, __a, i, length - i - 1);
            __a[--this.length] = null;
            return true;
        }
        return false;
    }

    public boolean contains(T x) {
        T[] __a = this.__a;
        int i = -1;
        int length = this.length;
        while (++i < length) {
            if (Jvm.compare(__a[i], x) != 0) continue;
            return true;
        }
        return false;
    }

    public int indexOf(T x, Integer fromIndex) {
        int i;
        int len = this.length;
        T[] a = this.__a;
        int n = i = fromIndex == null ? 0 : Jvm.toInt(fromIndex);
        if (i < 0 && (i += len) < 0) {
            i = 0;
        }
        while (i < len) {
            if (Jvm.compare(a[i], x) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(T x, Integer fromIndex) {
        int i;
        int len = this.length;
        T[] a = this.__a;
        int n = i = fromIndex == null ? len - 1 : Jvm.toInt(fromIndex);
        if (i >= len) {
            i = len - 1;
        } else if (i < 0) {
            i += len;
        }
        while (i >= 0) {
            if (Jvm.compare(a[i], x) == 0) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public Array<T> copy() {
        int len = this.length;
        T[] __a = this.__a;
        java.lang.Object[] newarr = new java.lang.Object[len];
        System.arraycopy(__a, 0, newarr, 0, len);
        return Array.ofNative(newarr);
    }

    @Override
    public ArrayIterator<T> iterator() {
        return new ArrayIterator(this);
    }

    public ArrayKeyValueIterator<T> keyValueIterator() {
        return new ArrayKeyValueIterator(this);
    }

    public void resize(int len) {
        if (this.length < len) {
            if (this.__a.length < len) {
                java.lang.Object[] newArr = new java.lang.Object[len];
                if (this.length > 0) {
                    System.arraycopy(this.__a, 0, newArr, 0, this.length);
                }
                this.__a = newArr;
                this.__a = newArr;
            }
            this.length = len;
            return;
        }
        if (this.length > len) {
            this.spliceVoid(len, this.length - len);
        }
    }

    public <S> Array<S> map(Function f) {
        Array ret = Array.alloc(this.length);
        int _g = 0;
        int _g1 = this.length;
        while (_g < _g1) {
            int i = _g++;
            ret.__set(i, f.invoke(this.__get(i)));
        }
        return ret;
    }

    public Array<T> filter(Function f) {
        Array<java.lang.Object> ret = Array.ofNative(new java.lang.Object[0]);
        int _g = 0;
        int _g1 = this.length;
        while (_g < _g1) {
            int i;
            T elt;
            if (!f.invoke(elt = this.__get(i = _g++))) continue;
            ret.push(elt);
        }
        return ret;
    }

    public T __get(int idx) {
        T[] __a = this.__a;
        if (idx >= __a.length || idx < 0) {
            return null;
        }
        return __a[idx];
    }

    public void __set(int idx, T v) {
        java.lang.Object[] __a = this.__a;
        if (idx >= __a.length) {
            int newl = idx + 1;
            if (idx == __a.length) {
                newl = (idx << 1) + 1;
            }
            java.lang.Object[] newArr = new java.lang.Object[newl];
            if (this.length > 0) {
                System.arraycopy(__a, 0, newArr, 0, this.length);
            }
            this.__a = __a = newArr;
        }
        if (idx >= this.length) {
            this.length = idx + 1;
        }
        __a[idx] = v;
    }

    public T __unsafe_get(int idx) {
        return this.__a[idx];
    }

    public T __unsafe_set(int idx, T val) {
        this.__a[idx] = val;
        return this.__a[idx];
    }

    public Array() {
        this.length = 0;
        this.__a = new java.lang.Object[0];
    }

    public /* synthetic */ Array(EmptyConstructor _) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public /* synthetic */ java.lang.Object _hx_getField(String name) {
        java.lang.Object object;
        if (name != null) {
            switch (name.hashCode()) {
                case -537840087: {
                    if (!name.equals("__unsafe_set")) break;
                    object = Jvm.readFieldClosure(this, "__unsafe_set", new Class[]{Integer.TYPE, java.lang.Object.class});
                    return object;
                }
                case -537851619: {
                    if (!name.equals("__unsafe_get")) break;
                    object = Jvm.readFieldClosure(this, "__unsafe_get", new Class[]{Integer.TYPE});
                    return object;
                }
                case 90678402: {
                    if (!name.equals("__set")) break;
                    object = Jvm.readFieldClosure(this, "__set", new Class[]{Integer.TYPE, java.lang.Object.class});
                    return object;
                }
                case 0x5677776: {
                    if (!name.equals("__get")) break;
                    object = Jvm.readFieldClosure(this, "__get", new Class[]{Integer.TYPE});
                    return object;
                }
                case -1274492040: {
                    if (!name.equals("filter")) break;
                    object = Jvm.readFieldClosure(this, "filter", new Class[]{Function.class});
                    return object;
                }
                case 107868: {
                    if (!name.equals("map")) break;
                    object = Jvm.readFieldClosure(this, "map", new Class[]{Function.class});
                    return object;
                }
                case -934437708: {
                    if (!name.equals("resize")) break;
                    object = Jvm.readFieldClosure(this, "resize", new Class[]{Integer.TYPE});
                    return object;
                }
                case -955047712: {
                    if (!name.equals("keyValueIterator")) break;
                    object = Jvm.readFieldClosure(this, "keyValueIterator", new Class[0]);
                    return object;
                }
                case 1182533742: {
                    if (!name.equals("iterator")) break;
                    object = Jvm.readFieldClosure(this, "iterator", new Class[0]);
                    return object;
                }
                case 3059573: {
                    if (!name.equals("copy")) break;
                    object = Jvm.readFieldClosure(this, "copy", new Class[0]);
                    return object;
                }
                case -467511597: {
                    if (!name.equals("lastIndexOf")) break;
                    object = Jvm.readFieldClosure(this, "lastIndexOf", new Class[]{java.lang.Object.class, Integer.class});
                    return object;
                }
                case 1943291465: {
                    if (!name.equals("indexOf")) break;
                    object = Jvm.readFieldClosure(this, "indexOf", new Class[]{java.lang.Object.class, Integer.class});
                    return object;
                }
                case -567445985: {
                    if (!name.equals("contains")) break;
                    object = Jvm.readFieldClosure(this, "contains", new Class[]{java.lang.Object.class});
                    return object;
                }
                case -934610812: {
                    if (!name.equals("remove")) break;
                    object = Jvm.readFieldClosure(this, "remove", new Class[]{java.lang.Object.class});
                    return object;
                }
                case -1183792455: {
                    if (!name.equals("insert")) break;
                    object = Jvm.readFieldClosure(this, "insert", new Class[]{Integer.TYPE, java.lang.Object.class});
                    return object;
                }
                case -277637751: {
                    if (!name.equals("unshift")) break;
                    object = Jvm.readFieldClosure(this, "unshift", new Class[]{java.lang.Object.class});
                    return object;
                }
                case -128126757: {
                    if (!name.equals("__hx_toString")) break;
                    object = Jvm.readFieldClosure(this, "__hx_toString", new Class[0]);
                    return object;
                }
                case -1776922004: {
                    if (!name.equals("toString")) break;
                    object = Jvm.readFieldClosure(this, "toString", new Class[0]);
                    return object;
                }
                case -821858768: {
                    if (!name.equals("spliceVoid")) break;
                    object = Jvm.readFieldClosure(this, "spliceVoid", new Class[]{Integer.TYPE, Integer.TYPE});
                    return object;
                }
                case -895859076: {
                    if (!name.equals("splice")) break;
                    object = Jvm.readFieldClosure(this, "splice", new Class[]{Integer.TYPE, Integer.TYPE});
                    return object;
                }
                case 1301699851: {
                    if (!name.equals("quicksort")) break;
                    object = Jvm.readFieldClosure(this, "quicksort", new Class[]{Integer.TYPE, Integer.TYPE, Function.class});
                    return object;
                }
                case 3536286: {
                    if (!name.equals("sort")) break;
                    object = Jvm.readFieldClosure(this, "sort", new Class[]{Function.class});
                    return object;
                }
                case 109526418: {
                    if (!name.equals("slice")) break;
                    object = Jvm.readFieldClosure(this, "slice", new Class[]{Integer.TYPE, Integer.class});
                    return object;
                }
                case 109407362: {
                    if (!name.equals("shift")) break;
                    object = Jvm.readFieldClosure(this, "shift", new Class[0]);
                    return object;
                }
                case 1099846370: {
                    if (!name.equals("reverse")) break;
                    object = Jvm.readFieldClosure(this, "reverse", new Class[0]);
                    return object;
                }
                case 3452698: {
                    if (!name.equals("push")) break;
                    object = Jvm.readFieldClosure(this, "push", new Class[]{java.lang.Object.class});
                    return object;
                }
                case 111185: {
                    if (!name.equals("pop")) break;
                    object = Jvm.readFieldClosure(this, "pop", new Class[0]);
                    return object;
                }
                case 3267882: {
                    if (!name.equals("join")) break;
                    object = Jvm.readFieldClosure(this, "join", new Class[]{String.class});
                    return object;
                }
                case -1238494133: {
                    if (!name.equals("concatNative")) break;
                    object = Jvm.readFieldClosure(this, "concatNative", new Class[]{java.lang.Object[].class});
                    return object;
                }
                case -1354795244: {
                    if (!name.equals("concat")) break;
                    object = Jvm.readFieldClosure(this, "concat", new Class[]{Array.class});
                    return object;
                }
                case 643396365: {
                    if (!name.equals("getNative")) break;
                    object = Jvm.readFieldClosure(this, "getNative", new Class[0]);
                    return object;
                }
                case 94337: {
                    if (!name.equals("__a")) break;
                    object = this.__a;
                    return object;
                }
                case -1106363674: {
                    if (!name.equals("length")) break;
                    object = this.length;
                    return object;
                }
            }
        }
        object = super._hx_getField(name);
        return object;
    }

    @Override
    public /* synthetic */ void _hx_setField(String name, java.lang.Object value) {
        switch (name.hashCode()) {
            default: {
                super._hx_setField(name, value);
                break;
            }
            case -1106363674: {
                this.length = Jvm.toInt(value);
                break;
            }
            case 94337: {
                this.__a = (java.lang.Object[])value;
            }
        }
    }
}

