// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package apigateway provides a client for Amazon API Gateway.
package apigateway

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateApiKey = "CreateApiKey"

// CreateApiKeyRequest generates a request for the CreateApiKey operation.
func (c *APIGateway) CreateApiKeyRequest(input *CreateApiKeyInput) (req *request.Request, output *ApiKey) {
	op := &request.Operation{
		Name:       opCreateApiKey,
		HTTPMethod: "POST",
		HTTPPath:   "/apikeys",
	}

	if input == nil {
		input = &CreateApiKeyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ApiKey{}
	req.Data = output
	return
}

func (c *APIGateway) CreateApiKey(input *CreateApiKeyInput) (*ApiKey, error) {
	req, out := c.CreateApiKeyRequest(input)
	err := req.Send()
	return out, err
}

const opCreateBasePathMapping = "CreateBasePathMapping"

// CreateBasePathMappingRequest generates a request for the CreateBasePathMapping operation.
func (c *APIGateway) CreateBasePathMappingRequest(input *CreateBasePathMappingInput) (req *request.Request, output *BasePathMapping) {
	op := &request.Operation{
		Name:       opCreateBasePathMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/domainnames/{domain_name}/basepathmappings",
	}

	if input == nil {
		input = &CreateBasePathMappingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &BasePathMapping{}
	req.Data = output
	return
}

// Creates a new BasePathMapping resource.
func (c *APIGateway) CreateBasePathMapping(input *CreateBasePathMappingInput) (*BasePathMapping, error) {
	req, out := c.CreateBasePathMappingRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDeployment = "CreateDeployment"

// CreateDeploymentRequest generates a request for the CreateDeployment operation.
func (c *APIGateway) CreateDeploymentRequest(input *CreateDeploymentInput) (req *request.Request, output *Deployment) {
	op := &request.Operation{
		Name:       opCreateDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/restapis/{restapi_id}/deployments",
	}

	if input == nil {
		input = &CreateDeploymentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Deployment{}
	req.Data = output
	return
}

// Creates a Deployment resource, which makes a specified RestApi callable over
// the internet.
func (c *APIGateway) CreateDeployment(input *CreateDeploymentInput) (*Deployment, error) {
	req, out := c.CreateDeploymentRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDomainName = "CreateDomainName"

// CreateDomainNameRequest generates a request for the CreateDomainName operation.
func (c *APIGateway) CreateDomainNameRequest(input *CreateDomainNameInput) (req *request.Request, output *DomainName) {
	op := &request.Operation{
		Name:       opCreateDomainName,
		HTTPMethod: "POST",
		HTTPPath:   "/domainnames",
	}

	if input == nil {
		input = &CreateDomainNameInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DomainName{}
	req.Data = output
	return
}

// Creates a new domain name.
func (c *APIGateway) CreateDomainName(input *CreateDomainNameInput) (*DomainName, error) {
	req, out := c.CreateDomainNameRequest(input)
	err := req.Send()
	return out, err
}

const opCreateModel = "CreateModel"

// CreateModelRequest generates a request for the CreateModel operation.
func (c *APIGateway) CreateModelRequest(input *CreateModelInput) (req *request.Request, output *Model) {
	op := &request.Operation{
		Name:       opCreateModel,
		HTTPMethod: "POST",
		HTTPPath:   "/restapis/{restapi_id}/models",
	}

	if input == nil {
		input = &CreateModelInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Model{}
	req.Data = output
	return
}

// Adds a new Model resource to an existing RestApi resource.
func (c *APIGateway) CreateModel(input *CreateModelInput) (*Model, error) {
	req, out := c.CreateModelRequest(input)
	err := req.Send()
	return out, err
}

const opCreateResource = "CreateResource"

// CreateResourceRequest generates a request for the CreateResource operation.
func (c *APIGateway) CreateResourceRequest(input *CreateResourceInput) (req *request.Request, output *Resource) {
	op := &request.Operation{
		Name:       opCreateResource,
		HTTPMethod: "POST",
		HTTPPath:   "/restapis/{restapi_id}/resources/{parent_id}",
	}

	if input == nil {
		input = &CreateResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Resource{}
	req.Data = output
	return
}

// Creates a Resource resource.
func (c *APIGateway) CreateResource(input *CreateResourceInput) (*Resource, error) {
	req, out := c.CreateResourceRequest(input)
	err := req.Send()
	return out, err
}

const opCreateRestApi = "CreateRestApi"

// CreateRestApiRequest generates a request for the CreateRestApi operation.
func (c *APIGateway) CreateRestApiRequest(input *CreateRestApiInput) (req *request.Request, output *RestApi) {
	op := &request.Operation{
		Name:       opCreateRestApi,
		HTTPMethod: "POST",
		HTTPPath:   "/restapis",
	}

	if input == nil {
		input = &CreateRestApiInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RestApi{}
	req.Data = output
	return
}

// Creates a new RestApi resource.
func (c *APIGateway) CreateRestApi(input *CreateRestApiInput) (*RestApi, error) {
	req, out := c.CreateRestApiRequest(input)
	err := req.Send()
	return out, err
}

const opCreateStage = "CreateStage"

// CreateStageRequest generates a request for the CreateStage operation.
func (c *APIGateway) CreateStageRequest(input *CreateStageInput) (req *request.Request, output *Stage) {
	op := &request.Operation{
		Name:       opCreateStage,
		HTTPMethod: "POST",
		HTTPPath:   "/restapis/{restapi_id}/stages",
	}

	if input == nil {
		input = &CreateStageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Stage{}
	req.Data = output
	return
}

// Creates a Stage resource.
func (c *APIGateway) CreateStage(input *CreateStageInput) (*Stage, error) {
	req, out := c.CreateStageRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteApiKey = "DeleteApiKey"

// DeleteApiKeyRequest generates a request for the DeleteApiKey operation.
func (c *APIGateway) DeleteApiKeyRequest(input *DeleteApiKeyInput) (req *request.Request, output *DeleteApiKeyOutput) {
	op := &request.Operation{
		Name:       opDeleteApiKey,
		HTTPMethod: "DELETE",
		HTTPPath:   "/apikeys/{api_Key}",
	}

	if input == nil {
		input = &DeleteApiKeyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteApiKeyOutput{}
	req.Data = output
	return
}

// Deletes the ApiKey resource.
func (c *APIGateway) DeleteApiKey(input *DeleteApiKeyInput) (*DeleteApiKeyOutput, error) {
	req, out := c.DeleteApiKeyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteBasePathMapping = "DeleteBasePathMapping"

// DeleteBasePathMappingRequest generates a request for the DeleteBasePathMapping operation.
func (c *APIGateway) DeleteBasePathMappingRequest(input *DeleteBasePathMappingInput) (req *request.Request, output *DeleteBasePathMappingOutput) {
	op := &request.Operation{
		Name:       opDeleteBasePathMapping,
		HTTPMethod: "DELETE",
		HTTPPath:   "/domainnames/{domain_name}/basepathmappings/{base_path}",
	}

	if input == nil {
		input = &DeleteBasePathMappingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteBasePathMappingOutput{}
	req.Data = output
	return
}

// Deletes the BasePathMapping resource.
func (c *APIGateway) DeleteBasePathMapping(input *DeleteBasePathMappingInput) (*DeleteBasePathMappingOutput, error) {
	req, out := c.DeleteBasePathMappingRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteClientCertificate = "DeleteClientCertificate"

// DeleteClientCertificateRequest generates a request for the DeleteClientCertificate operation.
func (c *APIGateway) DeleteClientCertificateRequest(input *DeleteClientCertificateInput) (req *request.Request, output *DeleteClientCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteClientCertificate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/clientcertificates/{clientcertificate_id}",
	}

	if input == nil {
		input = &DeleteClientCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteClientCertificateOutput{}
	req.Data = output
	return
}

func (c *APIGateway) DeleteClientCertificate(input *DeleteClientCertificateInput) (*DeleteClientCertificateOutput, error) {
	req, out := c.DeleteClientCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDeployment = "DeleteDeployment"

// DeleteDeploymentRequest generates a request for the DeleteDeployment operation.
func (c *APIGateway) DeleteDeploymentRequest(input *DeleteDeploymentInput) (req *request.Request, output *DeleteDeploymentOutput) {
	op := &request.Operation{
		Name:       opDeleteDeployment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/deployments/{deployment_id}",
	}

	if input == nil {
		input = &DeleteDeploymentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteDeploymentOutput{}
	req.Data = output
	return
}

// Deletes a Deployment resource. Deleting a deployment will only succeed if
// there are no Stage resources associated with it.
func (c *APIGateway) DeleteDeployment(input *DeleteDeploymentInput) (*DeleteDeploymentOutput, error) {
	req, out := c.DeleteDeploymentRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDomainName = "DeleteDomainName"

// DeleteDomainNameRequest generates a request for the DeleteDomainName operation.
func (c *APIGateway) DeleteDomainNameRequest(input *DeleteDomainNameInput) (req *request.Request, output *DeleteDomainNameOutput) {
	op := &request.Operation{
		Name:       opDeleteDomainName,
		HTTPMethod: "DELETE",
		HTTPPath:   "/domainnames/{domain_name}",
	}

	if input == nil {
		input = &DeleteDomainNameInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteDomainNameOutput{}
	req.Data = output
	return
}

// Deletes the DomainName resource.
func (c *APIGateway) DeleteDomainName(input *DeleteDomainNameInput) (*DeleteDomainNameOutput, error) {
	req, out := c.DeleteDomainNameRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteIntegration = "DeleteIntegration"

// DeleteIntegrationRequest generates a request for the DeleteIntegration operation.
func (c *APIGateway) DeleteIntegrationRequest(input *DeleteIntegrationInput) (req *request.Request, output *DeleteIntegrationOutput) {
	op := &request.Operation{
		Name:       opDeleteIntegration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration",
	}

	if input == nil {
		input = &DeleteIntegrationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteIntegrationOutput{}
	req.Data = output
	return
}

// Represents a delete integration.
func (c *APIGateway) DeleteIntegration(input *DeleteIntegrationInput) (*DeleteIntegrationOutput, error) {
	req, out := c.DeleteIntegrationRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteIntegrationResponse = "DeleteIntegrationResponse"

// DeleteIntegrationResponseRequest generates a request for the DeleteIntegrationResponse operation.
func (c *APIGateway) DeleteIntegrationResponseRequest(input *DeleteIntegrationResponseInput) (req *request.Request, output *DeleteIntegrationResponseOutput) {
	op := &request.Operation{
		Name:       opDeleteIntegrationResponse,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}",
	}

	if input == nil {
		input = &DeleteIntegrationResponseInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteIntegrationResponseOutput{}
	req.Data = output
	return
}

// Represents a delete integration response.
func (c *APIGateway) DeleteIntegrationResponse(input *DeleteIntegrationResponseInput) (*DeleteIntegrationResponseOutput, error) {
	req, out := c.DeleteIntegrationResponseRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteMethod = "DeleteMethod"

// DeleteMethodRequest generates a request for the DeleteMethod operation.
func (c *APIGateway) DeleteMethodRequest(input *DeleteMethodInput) (req *request.Request, output *DeleteMethodOutput) {
	op := &request.Operation{
		Name:       opDeleteMethod,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}",
	}

	if input == nil {
		input = &DeleteMethodInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteMethodOutput{}
	req.Data = output
	return
}

// Deletes an existing Method resource.
func (c *APIGateway) DeleteMethod(input *DeleteMethodInput) (*DeleteMethodOutput, error) {
	req, out := c.DeleteMethodRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteMethodResponse = "DeleteMethodResponse"

// DeleteMethodResponseRequest generates a request for the DeleteMethodResponse operation.
func (c *APIGateway) DeleteMethodResponseRequest(input *DeleteMethodResponseInput) (req *request.Request, output *DeleteMethodResponseOutput) {
	op := &request.Operation{
		Name:       opDeleteMethodResponse,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}",
	}

	if input == nil {
		input = &DeleteMethodResponseInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteMethodResponseOutput{}
	req.Data = output
	return
}

// Deletes an existing MethodResponse resource.
func (c *APIGateway) DeleteMethodResponse(input *DeleteMethodResponseInput) (*DeleteMethodResponseOutput, error) {
	req, out := c.DeleteMethodResponseRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteModel = "DeleteModel"

// DeleteModelRequest generates a request for the DeleteModel operation.
func (c *APIGateway) DeleteModelRequest(input *DeleteModelInput) (req *request.Request, output *DeleteModelOutput) {
	op := &request.Operation{
		Name:       opDeleteModel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/models/{model_name}",
	}

	if input == nil {
		input = &DeleteModelInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteModelOutput{}
	req.Data = output
	return
}

// Deletes a model.
func (c *APIGateway) DeleteModel(input *DeleteModelInput) (*DeleteModelOutput, error) {
	req, out := c.DeleteModelRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteResource = "DeleteResource"

// DeleteResourceRequest generates a request for the DeleteResource operation.
func (c *APIGateway) DeleteResourceRequest(input *DeleteResourceInput) (req *request.Request, output *DeleteResourceOutput) {
	op := &request.Operation{
		Name:       opDeleteResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}",
	}

	if input == nil {
		input = &DeleteResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteResourceOutput{}
	req.Data = output
	return
}

// Deletes a Resource resource.
func (c *APIGateway) DeleteResource(input *DeleteResourceInput) (*DeleteResourceOutput, error) {
	req, out := c.DeleteResourceRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteRestApi = "DeleteRestApi"

// DeleteRestApiRequest generates a request for the DeleteRestApi operation.
func (c *APIGateway) DeleteRestApiRequest(input *DeleteRestApiInput) (req *request.Request, output *DeleteRestApiOutput) {
	op := &request.Operation{
		Name:       opDeleteRestApi,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}",
	}

	if input == nil {
		input = &DeleteRestApiInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteRestApiOutput{}
	req.Data = output
	return
}

// Deletes the specified API.
func (c *APIGateway) DeleteRestApi(input *DeleteRestApiInput) (*DeleteRestApiOutput, error) {
	req, out := c.DeleteRestApiRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteStage = "DeleteStage"

// DeleteStageRequest generates a request for the DeleteStage operation.
func (c *APIGateway) DeleteStageRequest(input *DeleteStageInput) (req *request.Request, output *DeleteStageOutput) {
	op := &request.Operation{
		Name:       opDeleteStage,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/stages/{stage_name}",
	}

	if input == nil {
		input = &DeleteStageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteStageOutput{}
	req.Data = output
	return
}

// Deletes a Stage resource.
func (c *APIGateway) DeleteStage(input *DeleteStageInput) (*DeleteStageOutput, error) {
	req, out := c.DeleteStageRequest(input)
	err := req.Send()
	return out, err
}

const opFlushStageCache = "FlushStageCache"

// FlushStageCacheRequest generates a request for the FlushStageCache operation.
func (c *APIGateway) FlushStageCacheRequest(input *FlushStageCacheInput) (req *request.Request, output *FlushStageCacheOutput) {
	op := &request.Operation{
		Name:       opFlushStageCache,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/stages/{stage_name}/cache/data",
	}

	if input == nil {
		input = &FlushStageCacheInput{}
	}

	req = c.newRequest(op, input, output)
	output = &FlushStageCacheOutput{}
	req.Data = output
	return
}

// Flushes a stage's cache.
func (c *APIGateway) FlushStageCache(input *FlushStageCacheInput) (*FlushStageCacheOutput, error) {
	req, out := c.FlushStageCacheRequest(input)
	err := req.Send()
	return out, err
}

const opGenerateClientCertificate = "GenerateClientCertificate"

// GenerateClientCertificateRequest generates a request for the GenerateClientCertificate operation.
func (c *APIGateway) GenerateClientCertificateRequest(input *GenerateClientCertificateInput) (req *request.Request, output *ClientCertificate) {
	op := &request.Operation{
		Name:       opGenerateClientCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/clientcertificates",
	}

	if input == nil {
		input = &GenerateClientCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ClientCertificate{}
	req.Data = output
	return
}

func (c *APIGateway) GenerateClientCertificate(input *GenerateClientCertificateInput) (*ClientCertificate, error) {
	req, out := c.GenerateClientCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opGetAccount = "GetAccount"

// GetAccountRequest generates a request for the GetAccount operation.
func (c *APIGateway) GetAccountRequest(input *GetAccountInput) (req *request.Request, output *Account) {
	op := &request.Operation{
		Name:       opGetAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/account",
	}

	if input == nil {
		input = &GetAccountInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Account{}
	req.Data = output
	return
}

// Gets information about the current Account resource.
func (c *APIGateway) GetAccount(input *GetAccountInput) (*Account, error) {
	req, out := c.GetAccountRequest(input)
	err := req.Send()
	return out, err
}

const opGetApiKey = "GetApiKey"

// GetApiKeyRequest generates a request for the GetApiKey operation.
func (c *APIGateway) GetApiKeyRequest(input *GetApiKeyInput) (req *request.Request, output *ApiKey) {
	op := &request.Operation{
		Name:       opGetApiKey,
		HTTPMethod: "GET",
		HTTPPath:   "/apikeys/{api_Key}",
	}

	if input == nil {
		input = &GetApiKeyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ApiKey{}
	req.Data = output
	return
}

// Gets information about the current ApiKey resource.
func (c *APIGateway) GetApiKey(input *GetApiKeyInput) (*ApiKey, error) {
	req, out := c.GetApiKeyRequest(input)
	err := req.Send()
	return out, err
}

const opGetApiKeys = "GetApiKeys"

// GetApiKeysRequest generates a request for the GetApiKeys operation.
func (c *APIGateway) GetApiKeysRequest(input *GetApiKeysInput) (req *request.Request, output *GetApiKeysOutput) {
	op := &request.Operation{
		Name:       opGetApiKeys,
		HTTPMethod: "GET",
		HTTPPath:   "/apikeys",
		Paginator: &request.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetApiKeysInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetApiKeysOutput{}
	req.Data = output
	return
}

// Gets information about the current ApiKeys resource.
func (c *APIGateway) GetApiKeys(input *GetApiKeysInput) (*GetApiKeysOutput, error) {
	req, out := c.GetApiKeysRequest(input)
	err := req.Send()
	return out, err
}

func (c *APIGateway) GetApiKeysPages(input *GetApiKeysInput, fn func(p *GetApiKeysOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.GetApiKeysRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*GetApiKeysOutput), lastPage)
	})
}

const opGetBasePathMapping = "GetBasePathMapping"

// GetBasePathMappingRequest generates a request for the GetBasePathMapping operation.
func (c *APIGateway) GetBasePathMappingRequest(input *GetBasePathMappingInput) (req *request.Request, output *BasePathMapping) {
	op := &request.Operation{
		Name:       opGetBasePathMapping,
		HTTPMethod: "GET",
		HTTPPath:   "/domainnames/{domain_name}/basepathmappings/{base_path}",
	}

	if input == nil {
		input = &GetBasePathMappingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &BasePathMapping{}
	req.Data = output
	return
}

// Describe a BasePathMapping resource.
func (c *APIGateway) GetBasePathMapping(input *GetBasePathMappingInput) (*BasePathMapping, error) {
	req, out := c.GetBasePathMappingRequest(input)
	err := req.Send()
	return out, err
}

const opGetBasePathMappings = "GetBasePathMappings"

// GetBasePathMappingsRequest generates a request for the GetBasePathMappings operation.
func (c *APIGateway) GetBasePathMappingsRequest(input *GetBasePathMappingsInput) (req *request.Request, output *GetBasePathMappingsOutput) {
	op := &request.Operation{
		Name:       opGetBasePathMappings,
		HTTPMethod: "GET",
		HTTPPath:   "/domainnames/{domain_name}/basepathmappings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetBasePathMappingsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBasePathMappingsOutput{}
	req.Data = output
	return
}

// Represents a collection of BasePathMapping resources.
func (c *APIGateway) GetBasePathMappings(input *GetBasePathMappingsInput) (*GetBasePathMappingsOutput, error) {
	req, out := c.GetBasePathMappingsRequest(input)
	err := req.Send()
	return out, err
}

func (c *APIGateway) GetBasePathMappingsPages(input *GetBasePathMappingsInput, fn func(p *GetBasePathMappingsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.GetBasePathMappingsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*GetBasePathMappingsOutput), lastPage)
	})
}

const opGetClientCertificate = "GetClientCertificate"

// GetClientCertificateRequest generates a request for the GetClientCertificate operation.
func (c *APIGateway) GetClientCertificateRequest(input *GetClientCertificateInput) (req *request.Request, output *ClientCertificate) {
	op := &request.Operation{
		Name:       opGetClientCertificate,
		HTTPMethod: "GET",
		HTTPPath:   "/clientcertificates/{clientcertificate_id}",
	}

	if input == nil {
		input = &GetClientCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ClientCertificate{}
	req.Data = output
	return
}

func (c *APIGateway) GetClientCertificate(input *GetClientCertificateInput) (*ClientCertificate, error) {
	req, out := c.GetClientCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opGetClientCertificates = "GetClientCertificates"

// GetClientCertificatesRequest generates a request for the GetClientCertificates operation.
func (c *APIGateway) GetClientCertificatesRequest(input *GetClientCertificatesInput) (req *request.Request, output *GetClientCertificatesOutput) {
	op := &request.Operation{
		Name:       opGetClientCertificates,
		HTTPMethod: "GET",
		HTTPPath:   "/clientcertificates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetClientCertificatesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetClientCertificatesOutput{}
	req.Data = output
	return
}

func (c *APIGateway) GetClientCertificates(input *GetClientCertificatesInput) (*GetClientCertificatesOutput, error) {
	req, out := c.GetClientCertificatesRequest(input)
	err := req.Send()
	return out, err
}

func (c *APIGateway) GetClientCertificatesPages(input *GetClientCertificatesInput, fn func(p *GetClientCertificatesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.GetClientCertificatesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*GetClientCertificatesOutput), lastPage)
	})
}

const opGetDeployment = "GetDeployment"

// GetDeploymentRequest generates a request for the GetDeployment operation.
func (c *APIGateway) GetDeploymentRequest(input *GetDeploymentInput) (req *request.Request, output *Deployment) {
	op := &request.Operation{
		Name:       opGetDeployment,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/deployments/{deployment_id}",
	}

	if input == nil {
		input = &GetDeploymentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Deployment{}
	req.Data = output
	return
}

// Gets information about a Deployment resource.
func (c *APIGateway) GetDeployment(input *GetDeploymentInput) (*Deployment, error) {
	req, out := c.GetDeploymentRequest(input)
	err := req.Send()
	return out, err
}

const opGetDeployments = "GetDeployments"

// GetDeploymentsRequest generates a request for the GetDeployments operation.
func (c *APIGateway) GetDeploymentsRequest(input *GetDeploymentsInput) (req *request.Request, output *GetDeploymentsOutput) {
	op := &request.Operation{
		Name:       opGetDeployments,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/deployments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDeploymentsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDeploymentsOutput{}
	req.Data = output
	return
}

// Gets information about a Deployments collection.
func (c *APIGateway) GetDeployments(input *GetDeploymentsInput) (*GetDeploymentsOutput, error) {
	req, out := c.GetDeploymentsRequest(input)
	err := req.Send()
	return out, err
}

func (c *APIGateway) GetDeploymentsPages(input *GetDeploymentsInput, fn func(p *GetDeploymentsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.GetDeploymentsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*GetDeploymentsOutput), lastPage)
	})
}

const opGetDomainName = "GetDomainName"

// GetDomainNameRequest generates a request for the GetDomainName operation.
func (c *APIGateway) GetDomainNameRequest(input *GetDomainNameInput) (req *request.Request, output *DomainName) {
	op := &request.Operation{
		Name:       opGetDomainName,
		HTTPMethod: "GET",
		HTTPPath:   "/domainnames/{domain_name}",
	}

	if input == nil {
		input = &GetDomainNameInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DomainName{}
	req.Data = output
	return
}

// Represents a domain name that is contained in a simpler, more intuitive URL
// that can be called.
func (c *APIGateway) GetDomainName(input *GetDomainNameInput) (*DomainName, error) {
	req, out := c.GetDomainNameRequest(input)
	err := req.Send()
	return out, err
}

const opGetDomainNames = "GetDomainNames"

// GetDomainNamesRequest generates a request for the GetDomainNames operation.
func (c *APIGateway) GetDomainNamesRequest(input *GetDomainNamesInput) (req *request.Request, output *GetDomainNamesOutput) {
	op := &request.Operation{
		Name:       opGetDomainNames,
		HTTPMethod: "GET",
		HTTPPath:   "/domainnames",
		Paginator: &request.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDomainNamesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDomainNamesOutput{}
	req.Data = output
	return
}

// Represents a collection of DomainName resources.
func (c *APIGateway) GetDomainNames(input *GetDomainNamesInput) (*GetDomainNamesOutput, error) {
	req, out := c.GetDomainNamesRequest(input)
	err := req.Send()
	return out, err
}

func (c *APIGateway) GetDomainNamesPages(input *GetDomainNamesInput, fn func(p *GetDomainNamesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.GetDomainNamesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*GetDomainNamesOutput), lastPage)
	})
}

const opGetIntegration = "GetIntegration"

// GetIntegrationRequest generates a request for the GetIntegration operation.
func (c *APIGateway) GetIntegrationRequest(input *GetIntegrationInput) (req *request.Request, output *Integration) {
	op := &request.Operation{
		Name:       opGetIntegration,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration",
	}

	if input == nil {
		input = &GetIntegrationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Integration{}
	req.Data = output
	return
}

// Represents a get integration.
func (c *APIGateway) GetIntegration(input *GetIntegrationInput) (*Integration, error) {
	req, out := c.GetIntegrationRequest(input)
	err := req.Send()
	return out, err
}

const opGetIntegrationResponse = "GetIntegrationResponse"

// GetIntegrationResponseRequest generates a request for the GetIntegrationResponse operation.
func (c *APIGateway) GetIntegrationResponseRequest(input *GetIntegrationResponseInput) (req *request.Request, output *IntegrationResponse) {
	op := &request.Operation{
		Name:       opGetIntegrationResponse,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}",
	}

	if input == nil {
		input = &GetIntegrationResponseInput{}
	}

	req = c.newRequest(op, input, output)
	output = &IntegrationResponse{}
	req.Data = output
	return
}

// Represents a get integration response.
func (c *APIGateway) GetIntegrationResponse(input *GetIntegrationResponseInput) (*IntegrationResponse, error) {
	req, out := c.GetIntegrationResponseRequest(input)
	err := req.Send()
	return out, err
}

const opGetMethod = "GetMethod"

// GetMethodRequest generates a request for the GetMethod operation.
func (c *APIGateway) GetMethodRequest(input *GetMethodInput) (req *request.Request, output *Method) {
	op := &request.Operation{
		Name:       opGetMethod,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}",
	}

	if input == nil {
		input = &GetMethodInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Method{}
	req.Data = output
	return
}

// Describe an existing Method resource.
func (c *APIGateway) GetMethod(input *GetMethodInput) (*Method, error) {
	req, out := c.GetMethodRequest(input)
	err := req.Send()
	return out, err
}

const opGetMethodResponse = "GetMethodResponse"

// GetMethodResponseRequest generates a request for the GetMethodResponse operation.
func (c *APIGateway) GetMethodResponseRequest(input *GetMethodResponseInput) (req *request.Request, output *MethodResponse) {
	op := &request.Operation{
		Name:       opGetMethodResponse,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}",
	}

	if input == nil {
		input = &GetMethodResponseInput{}
	}

	req = c.newRequest(op, input, output)
	output = &MethodResponse{}
	req.Data = output
	return
}

// Describes a MethodResponse resource.
func (c *APIGateway) GetMethodResponse(input *GetMethodResponseInput) (*MethodResponse, error) {
	req, out := c.GetMethodResponseRequest(input)
	err := req.Send()
	return out, err
}

const opGetModel = "GetModel"

// GetModelRequest generates a request for the GetModel operation.
func (c *APIGateway) GetModelRequest(input *GetModelInput) (req *request.Request, output *Model) {
	op := &request.Operation{
		Name:       opGetModel,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/models/{model_name}",
	}

	if input == nil {
		input = &GetModelInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Model{}
	req.Data = output
	return
}

// Describes an existing model defined for a RestApi resource.
func (c *APIGateway) GetModel(input *GetModelInput) (*Model, error) {
	req, out := c.GetModelRequest(input)
	err := req.Send()
	return out, err
}

const opGetModelTemplate = "GetModelTemplate"

// GetModelTemplateRequest generates a request for the GetModelTemplate operation.
func (c *APIGateway) GetModelTemplateRequest(input *GetModelTemplateInput) (req *request.Request, output *GetModelTemplateOutput) {
	op := &request.Operation{
		Name:       opGetModelTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/models/{model_name}/default_template",
	}

	if input == nil {
		input = &GetModelTemplateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetModelTemplateOutput{}
	req.Data = output
	return
}

// Generates a sample mapping template that can be used to transform a payload
// into the structure of a model.
func (c *APIGateway) GetModelTemplate(input *GetModelTemplateInput) (*GetModelTemplateOutput, error) {
	req, out := c.GetModelTemplateRequest(input)
	err := req.Send()
	return out, err
}

const opGetModels = "GetModels"

// GetModelsRequest generates a request for the GetModels operation.
func (c *APIGateway) GetModelsRequest(input *GetModelsInput) (req *request.Request, output *GetModelsOutput) {
	op := &request.Operation{
		Name:       opGetModels,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/models",
		Paginator: &request.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetModelsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetModelsOutput{}
	req.Data = output
	return
}

// Describes existing Models defined for a RestApi resource.
func (c *APIGateway) GetModels(input *GetModelsInput) (*GetModelsOutput, error) {
	req, out := c.GetModelsRequest(input)
	err := req.Send()
	return out, err
}

func (c *APIGateway) GetModelsPages(input *GetModelsInput, fn func(p *GetModelsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.GetModelsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*GetModelsOutput), lastPage)
	})
}

const opGetResource = "GetResource"

// GetResourceRequest generates a request for the GetResource operation.
func (c *APIGateway) GetResourceRequest(input *GetResourceInput) (req *request.Request, output *Resource) {
	op := &request.Operation{
		Name:       opGetResource,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}",
	}

	if input == nil {
		input = &GetResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Resource{}
	req.Data = output
	return
}

// Lists information about a resource.
func (c *APIGateway) GetResource(input *GetResourceInput) (*Resource, error) {
	req, out := c.GetResourceRequest(input)
	err := req.Send()
	return out, err
}

const opGetResources = "GetResources"

// GetResourcesRequest generates a request for the GetResources operation.
func (c *APIGateway) GetResourcesRequest(input *GetResourcesInput) (req *request.Request, output *GetResourcesOutput) {
	op := &request.Operation{
		Name:       opGetResources,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/resources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourcesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetResourcesOutput{}
	req.Data = output
	return
}

// Lists information about a collection of Resource resources.
func (c *APIGateway) GetResources(input *GetResourcesInput) (*GetResourcesOutput, error) {
	req, out := c.GetResourcesRequest(input)
	err := req.Send()
	return out, err
}

func (c *APIGateway) GetResourcesPages(input *GetResourcesInput, fn func(p *GetResourcesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.GetResourcesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*GetResourcesOutput), lastPage)
	})
}

const opGetRestApi = "GetRestApi"

// GetRestApiRequest generates a request for the GetRestApi operation.
func (c *APIGateway) GetRestApiRequest(input *GetRestApiInput) (req *request.Request, output *RestApi) {
	op := &request.Operation{
		Name:       opGetRestApi,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}",
	}

	if input == nil {
		input = &GetRestApiInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RestApi{}
	req.Data = output
	return
}

// Lists the RestApi resource in the collection.
func (c *APIGateway) GetRestApi(input *GetRestApiInput) (*RestApi, error) {
	req, out := c.GetRestApiRequest(input)
	err := req.Send()
	return out, err
}

const opGetRestApis = "GetRestApis"

// GetRestApisRequest generates a request for the GetRestApis operation.
func (c *APIGateway) GetRestApisRequest(input *GetRestApisInput) (req *request.Request, output *GetRestApisOutput) {
	op := &request.Operation{
		Name:       opGetRestApis,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis",
		Paginator: &request.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetRestApisInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetRestApisOutput{}
	req.Data = output
	return
}

// Lists the RestApis resources for your collection.
func (c *APIGateway) GetRestApis(input *GetRestApisInput) (*GetRestApisOutput, error) {
	req, out := c.GetRestApisRequest(input)
	err := req.Send()
	return out, err
}

func (c *APIGateway) GetRestApisPages(input *GetRestApisInput, fn func(p *GetRestApisOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.GetRestApisRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*GetRestApisOutput), lastPage)
	})
}

const opGetSdk = "GetSdk"

// GetSdkRequest generates a request for the GetSdk operation.
func (c *APIGateway) GetSdkRequest(input *GetSdkInput) (req *request.Request, output *GetSdkOutput) {
	op := &request.Operation{
		Name:       opGetSdk,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/stages/{stage_name}/sdks/{sdk_type}",
	}

	if input == nil {
		input = &GetSdkInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetSdkOutput{}
	req.Data = output
	return
}

func (c *APIGateway) GetSdk(input *GetSdkInput) (*GetSdkOutput, error) {
	req, out := c.GetSdkRequest(input)
	err := req.Send()
	return out, err
}

const opGetStage = "GetStage"

// GetStageRequest generates a request for the GetStage operation.
func (c *APIGateway) GetStageRequest(input *GetStageInput) (req *request.Request, output *Stage) {
	op := &request.Operation{
		Name:       opGetStage,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/stages/{stage_name}",
	}

	if input == nil {
		input = &GetStageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Stage{}
	req.Data = output
	return
}

// Gets information about a Stage resource.
func (c *APIGateway) GetStage(input *GetStageInput) (*Stage, error) {
	req, out := c.GetStageRequest(input)
	err := req.Send()
	return out, err
}

const opGetStages = "GetStages"

// GetStagesRequest generates a request for the GetStages operation.
func (c *APIGateway) GetStagesRequest(input *GetStagesInput) (req *request.Request, output *GetStagesOutput) {
	op := &request.Operation{
		Name:       opGetStages,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/stages",
	}

	if input == nil {
		input = &GetStagesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetStagesOutput{}
	req.Data = output
	return
}

// Gets information about one or more Stage resources.
func (c *APIGateway) GetStages(input *GetStagesInput) (*GetStagesOutput, error) {
	req, out := c.GetStagesRequest(input)
	err := req.Send()
	return out, err
}

const opPutIntegration = "PutIntegration"

// PutIntegrationRequest generates a request for the PutIntegration operation.
func (c *APIGateway) PutIntegrationRequest(input *PutIntegrationInput) (req *request.Request, output *Integration) {
	op := &request.Operation{
		Name:       opPutIntegration,
		HTTPMethod: "PUT",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration",
	}

	if input == nil {
		input = &PutIntegrationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Integration{}
	req.Data = output
	return
}

// Represents a put integration.
func (c *APIGateway) PutIntegration(input *PutIntegrationInput) (*Integration, error) {
	req, out := c.PutIntegrationRequest(input)
	err := req.Send()
	return out, err
}

const opPutIntegrationResponse = "PutIntegrationResponse"

// PutIntegrationResponseRequest generates a request for the PutIntegrationResponse operation.
func (c *APIGateway) PutIntegrationResponseRequest(input *PutIntegrationResponseInput) (req *request.Request, output *IntegrationResponse) {
	op := &request.Operation{
		Name:       opPutIntegrationResponse,
		HTTPMethod: "PUT",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}",
	}

	if input == nil {
		input = &PutIntegrationResponseInput{}
	}

	req = c.newRequest(op, input, output)
	output = &IntegrationResponse{}
	req.Data = output
	return
}

// Represents a put integration.
func (c *APIGateway) PutIntegrationResponse(input *PutIntegrationResponseInput) (*IntegrationResponse, error) {
	req, out := c.PutIntegrationResponseRequest(input)
	err := req.Send()
	return out, err
}

const opPutMethod = "PutMethod"

// PutMethodRequest generates a request for the PutMethod operation.
func (c *APIGateway) PutMethodRequest(input *PutMethodInput) (req *request.Request, output *Method) {
	op := &request.Operation{
		Name:       opPutMethod,
		HTTPMethod: "PUT",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}",
	}

	if input == nil {
		input = &PutMethodInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Method{}
	req.Data = output
	return
}

// Add a method to an existing Resource resource.
func (c *APIGateway) PutMethod(input *PutMethodInput) (*Method, error) {
	req, out := c.PutMethodRequest(input)
	err := req.Send()
	return out, err
}

const opPutMethodResponse = "PutMethodResponse"

// PutMethodResponseRequest generates a request for the PutMethodResponse operation.
func (c *APIGateway) PutMethodResponseRequest(input *PutMethodResponseInput) (req *request.Request, output *MethodResponse) {
	op := &request.Operation{
		Name:       opPutMethodResponse,
		HTTPMethod: "PUT",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}",
	}

	if input == nil {
		input = &PutMethodResponseInput{}
	}

	req = c.newRequest(op, input, output)
	output = &MethodResponse{}
	req.Data = output
	return
}

// Adds a MethodResponse to an existing Method resource.
func (c *APIGateway) PutMethodResponse(input *PutMethodResponseInput) (*MethodResponse, error) {
	req, out := c.PutMethodResponseRequest(input)
	err := req.Send()
	return out, err
}

const opTestInvokeMethod = "TestInvokeMethod"

// TestInvokeMethodRequest generates a request for the TestInvokeMethod operation.
func (c *APIGateway) TestInvokeMethodRequest(input *TestInvokeMethodInput) (req *request.Request, output *TestInvokeMethodOutput) {
	op := &request.Operation{
		Name:       opTestInvokeMethod,
		HTTPMethod: "POST",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}",
	}

	if input == nil {
		input = &TestInvokeMethodInput{}
	}

	req = c.newRequest(op, input, output)
	output = &TestInvokeMethodOutput{}
	req.Data = output
	return
}

func (c *APIGateway) TestInvokeMethod(input *TestInvokeMethodInput) (*TestInvokeMethodOutput, error) {
	req, out := c.TestInvokeMethodRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateAccount = "UpdateAccount"

// UpdateAccountRequest generates a request for the UpdateAccount operation.
func (c *APIGateway) UpdateAccountRequest(input *UpdateAccountInput) (req *request.Request, output *Account) {
	op := &request.Operation{
		Name:       opUpdateAccount,
		HTTPMethod: "PATCH",
		HTTPPath:   "/account",
	}

	if input == nil {
		input = &UpdateAccountInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Account{}
	req.Data = output
	return
}

// Changes information about the current Account resource.
func (c *APIGateway) UpdateAccount(input *UpdateAccountInput) (*Account, error) {
	req, out := c.UpdateAccountRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateApiKey = "UpdateApiKey"

// UpdateApiKeyRequest generates a request for the UpdateApiKey operation.
func (c *APIGateway) UpdateApiKeyRequest(input *UpdateApiKeyInput) (req *request.Request, output *ApiKey) {
	op := &request.Operation{
		Name:       opUpdateApiKey,
		HTTPMethod: "PATCH",
		HTTPPath:   "/apikeys/{api_Key}",
	}

	if input == nil {
		input = &UpdateApiKeyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ApiKey{}
	req.Data = output
	return
}

// Changes information about an ApiKey resource.
func (c *APIGateway) UpdateApiKey(input *UpdateApiKeyInput) (*ApiKey, error) {
	req, out := c.UpdateApiKeyRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateBasePathMapping = "UpdateBasePathMapping"

// UpdateBasePathMappingRequest generates a request for the UpdateBasePathMapping operation.
func (c *APIGateway) UpdateBasePathMappingRequest(input *UpdateBasePathMappingInput) (req *request.Request, output *BasePathMapping) {
	op := &request.Operation{
		Name:       opUpdateBasePathMapping,
		HTTPMethod: "PATCH",
		HTTPPath:   "/domainnames/{domain_name}/basepathmappings/{base_path}",
	}

	if input == nil {
		input = &UpdateBasePathMappingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &BasePathMapping{}
	req.Data = output
	return
}

// Changes information about the BasePathMapping resource.
func (c *APIGateway) UpdateBasePathMapping(input *UpdateBasePathMappingInput) (*BasePathMapping, error) {
	req, out := c.UpdateBasePathMappingRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateClientCertificate = "UpdateClientCertificate"

// UpdateClientCertificateRequest generates a request for the UpdateClientCertificate operation.
func (c *APIGateway) UpdateClientCertificateRequest(input *UpdateClientCertificateInput) (req *request.Request, output *ClientCertificate) {
	op := &request.Operation{
		Name:       opUpdateClientCertificate,
		HTTPMethod: "PATCH",
		HTTPPath:   "/clientcertificates/{clientcertificate_id}",
	}

	if input == nil {
		input = &UpdateClientCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ClientCertificate{}
	req.Data = output
	return
}

func (c *APIGateway) UpdateClientCertificate(input *UpdateClientCertificateInput) (*ClientCertificate, error) {
	req, out := c.UpdateClientCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateDeployment = "UpdateDeployment"

// UpdateDeploymentRequest generates a request for the UpdateDeployment operation.
func (c *APIGateway) UpdateDeploymentRequest(input *UpdateDeploymentInput) (req *request.Request, output *Deployment) {
	op := &request.Operation{
		Name:       opUpdateDeployment,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/deployments/{deployment_id}",
	}

	if input == nil {
		input = &UpdateDeploymentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Deployment{}
	req.Data = output
	return
}

// Changes information about a Deployment resource.
func (c *APIGateway) UpdateDeployment(input *UpdateDeploymentInput) (*Deployment, error) {
	req, out := c.UpdateDeploymentRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateDomainName = "UpdateDomainName"

// UpdateDomainNameRequest generates a request for the UpdateDomainName operation.
func (c *APIGateway) UpdateDomainNameRequest(input *UpdateDomainNameInput) (req *request.Request, output *DomainName) {
	op := &request.Operation{
		Name:       opUpdateDomainName,
		HTTPMethod: "PATCH",
		HTTPPath:   "/domainnames/{domain_name}",
	}

	if input == nil {
		input = &UpdateDomainNameInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DomainName{}
	req.Data = output
	return
}

// Changes information about the DomainName resource.
func (c *APIGateway) UpdateDomainName(input *UpdateDomainNameInput) (*DomainName, error) {
	req, out := c.UpdateDomainNameRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateIntegration = "UpdateIntegration"

// UpdateIntegrationRequest generates a request for the UpdateIntegration operation.
func (c *APIGateway) UpdateIntegrationRequest(input *UpdateIntegrationInput) (req *request.Request, output *Integration) {
	op := &request.Operation{
		Name:       opUpdateIntegration,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration",
	}

	if input == nil {
		input = &UpdateIntegrationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Integration{}
	req.Data = output
	return
}

// Represents an update integration.
func (c *APIGateway) UpdateIntegration(input *UpdateIntegrationInput) (*Integration, error) {
	req, out := c.UpdateIntegrationRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateIntegrationResponse = "UpdateIntegrationResponse"

// UpdateIntegrationResponseRequest generates a request for the UpdateIntegrationResponse operation.
func (c *APIGateway) UpdateIntegrationResponseRequest(input *UpdateIntegrationResponseInput) (req *request.Request, output *IntegrationResponse) {
	op := &request.Operation{
		Name:       opUpdateIntegrationResponse,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}",
	}

	if input == nil {
		input = &UpdateIntegrationResponseInput{}
	}

	req = c.newRequest(op, input, output)
	output = &IntegrationResponse{}
	req.Data = output
	return
}

// Represents an update integration response.
func (c *APIGateway) UpdateIntegrationResponse(input *UpdateIntegrationResponseInput) (*IntegrationResponse, error) {
	req, out := c.UpdateIntegrationResponseRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateMethod = "UpdateMethod"

// UpdateMethodRequest generates a request for the UpdateMethod operation.
func (c *APIGateway) UpdateMethodRequest(input *UpdateMethodInput) (req *request.Request, output *Method) {
	op := &request.Operation{
		Name:       opUpdateMethod,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}",
	}

	if input == nil {
		input = &UpdateMethodInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Method{}
	req.Data = output
	return
}

// Updates an existing Method resource.
func (c *APIGateway) UpdateMethod(input *UpdateMethodInput) (*Method, error) {
	req, out := c.UpdateMethodRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateMethodResponse = "UpdateMethodResponse"

// UpdateMethodResponseRequest generates a request for the UpdateMethodResponse operation.
func (c *APIGateway) UpdateMethodResponseRequest(input *UpdateMethodResponseInput) (req *request.Request, output *MethodResponse) {
	op := &request.Operation{
		Name:       opUpdateMethodResponse,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}",
	}

	if input == nil {
		input = &UpdateMethodResponseInput{}
	}

	req = c.newRequest(op, input, output)
	output = &MethodResponse{}
	req.Data = output
	return
}

// Updates an existing MethodResponse resource.
func (c *APIGateway) UpdateMethodResponse(input *UpdateMethodResponseInput) (*MethodResponse, error) {
	req, out := c.UpdateMethodResponseRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateModel = "UpdateModel"

// UpdateModelRequest generates a request for the UpdateModel operation.
func (c *APIGateway) UpdateModelRequest(input *UpdateModelInput) (req *request.Request, output *Model) {
	op := &request.Operation{
		Name:       opUpdateModel,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/models/{model_name}",
	}

	if input == nil {
		input = &UpdateModelInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Model{}
	req.Data = output
	return
}

// Changes information about a model.
func (c *APIGateway) UpdateModel(input *UpdateModelInput) (*Model, error) {
	req, out := c.UpdateModelRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateResource = "UpdateResource"

// UpdateResourceRequest generates a request for the UpdateResource operation.
func (c *APIGateway) UpdateResourceRequest(input *UpdateResourceInput) (req *request.Request, output *Resource) {
	op := &request.Operation{
		Name:       opUpdateResource,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}",
	}

	if input == nil {
		input = &UpdateResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Resource{}
	req.Data = output
	return
}

// Changes information about a Resource resource.
func (c *APIGateway) UpdateResource(input *UpdateResourceInput) (*Resource, error) {
	req, out := c.UpdateResourceRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateRestApi = "UpdateRestApi"

// UpdateRestApiRequest generates a request for the UpdateRestApi operation.
func (c *APIGateway) UpdateRestApiRequest(input *UpdateRestApiInput) (req *request.Request, output *RestApi) {
	op := &request.Operation{
		Name:       opUpdateRestApi,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}",
	}

	if input == nil {
		input = &UpdateRestApiInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RestApi{}
	req.Data = output
	return
}

// Changes information about the specified API.
func (c *APIGateway) UpdateRestApi(input *UpdateRestApiInput) (*RestApi, error) {
	req, out := c.UpdateRestApiRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateStage = "UpdateStage"

// UpdateStageRequest generates a request for the UpdateStage operation.
func (c *APIGateway) UpdateStageRequest(input *UpdateStageInput) (req *request.Request, output *Stage) {
	op := &request.Operation{
		Name:       opUpdateStage,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/stages/{stage_name}",
	}

	if input == nil {
		input = &UpdateStageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Stage{}
	req.Data = output
	return
}

// Changes information about a Stage resource.
func (c *APIGateway) UpdateStage(input *UpdateStageInput) (*Stage, error) {
	req, out := c.UpdateStageRequest(input)
	err := req.Send()
	return out, err
}

// Represents an AWS account that is associated with Amazon API Gateway.
type Account struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon resource name (ARN) of an Amazon CloudWatch role for
	// the current Account resource.
	CloudwatchRoleArn *string `locationName:"cloudwatchRoleArn" type:"string"`

	// Specifies the application programming interface (API) throttle settings for
	// the current Account resource.
	ThrottleSettings *ThrottleSettings `locationName:"throttleSettings" type:"structure"`
}

// String returns the string representation
func (s Account) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Account) GoString() string {
	return s.String()
}

// A resource that can be distributed to callers for executing Method resources
// that require an API key. API keys can be mapped to any Stage on any RestApi,
// which indicates that the callers with the API key can make requests to that
// stage.
type ApiKey struct {
	_ struct{} `type:"structure"`

	// The date when the API Key was created, in ISO 8601 format.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"unix"`

	// The description of the API Key.
	Description *string `locationName:"description" type:"string"`

	// Specifies whether the API Key can be used by callers.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The identifier of the API Key.
	Id *string `locationName:"id" type:"string"`

	// When the API Key was last updated, in ISO 8601 format.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"unix"`

	// The name of the API Key.
	Name *string `locationName:"name" type:"string"`

	// A list of Stage resources that are associated with the ApiKey resource.
	StageKeys []*string `locationName:"stageKeys" type:"list"`
}

// String returns the string representation
func (s ApiKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApiKey) GoString() string {
	return s.String()
}

// Represents the base path that callers of the API that must provide as part
// of the URL after the domain name.
type BasePathMapping struct {
	_ struct{} `type:"structure"`

	// The base path name that callers of the API must provide as part of the URL
	// after the domain name.
	BasePath *string `locationName:"basePath" type:"string"`

	// The name of the API.
	RestApiId *string `locationName:"restApiId" type:"string"`

	// The name of the API's stage.
	Stage *string `locationName:"stage" type:"string"`
}

// String returns the string representation
func (s BasePathMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BasePathMapping) GoString() string {
	return s.String()
}

type ClientCertificate struct {
	_ struct{} `type:"structure"`

	ClientCertificateId *string `locationName:"clientCertificateId" type:"string"`

	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"unix"`

	Description *string `locationName:"description" type:"string"`

	ExpirationDate *time.Time `locationName:"expirationDate" type:"timestamp" timestampFormat:"unix"`

	PemEncodedCertificate *string `locationName:"pemEncodedCertificate" type:"string"`
}

// String returns the string representation
func (s ClientCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClientCertificate) GoString() string {
	return s.String()
}

type CreateApiKeyInput struct {
	_ struct{} `type:"structure"`

	// The description of the ApiKey.
	Description *string `locationName:"description" type:"string"`

	// Specifies whether the ApiKey can be used by callers.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The name of the ApiKey.
	Name *string `locationName:"name" type:"string"`

	// Specifies whether the ApiKey can be used by callers.
	StageKeys []*StageKey `locationName:"stageKeys" type:"list"`
}

// String returns the string representation
func (s CreateApiKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApiKeyInput) GoString() string {
	return s.String()
}

// Requests Amazon API Gateway to create a new BasePathMapping resource.
type CreateBasePathMappingInput struct {
	_ struct{} `type:"structure"`

	// The base path name that callers of the API must provide as part of the URL
	// after the domain name. This value must be unique for all of the mappings
	// across a single API. Leave this blank if you do not want callers to specify
	// a base path name after the domain name.
	BasePath *string `locationName:"basePath" type:"string"`

	// The domain name of the BasePathMapping resource to create.
	DomainName *string `location:"uri" locationName:"domain_name" type:"string" required:"true"`

	// The name of the API that you want to apply this mapping to.
	RestApiId *string `locationName:"restApiId" type:"string" required:"true"`

	// The name of the API's stage that you want to use for this mapping. Leave
	// this blank if you do not want callers to explicitly specify the stage name
	// after any base path name.
	Stage *string `locationName:"stage" type:"string"`
}

// String returns the string representation
func (s CreateBasePathMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBasePathMappingInput) GoString() string {
	return s.String()
}

// Requests Amazon API Gateway to create a Deployment resource.
type CreateDeploymentInput struct {
	_ struct{} `type:"structure"`

	// Enables a cache cluster for the Stage resource specified in the input.
	CacheClusterEnabled *bool `locationName:"cacheClusterEnabled" type:"boolean"`

	// Specifies the cache cluster size for the Stage resource specified in the
	// input, if a cache cluster is enabled.
	CacheClusterSize *string `locationName:"cacheClusterSize" type:"string" enum:"CacheClusterSize"`

	// The description for the Deployment resource to create.
	Description *string `locationName:"description" type:"string"`

	// The RestApi resource identifier for the Deployment resource to create.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// The description of the Stage resource for the Deployment resource to create.
	StageDescription *string `locationName:"stageDescription" type:"string"`

	// The name of the Stage resource for the Deployment resource to create.
	StageName *string `locationName:"stageName" type:"string" required:"true"`

	// A map that defines the stage variables for the Stage resource that is associated
	// with the new deployment. Variable names can have alphabetic characters, and
	// the values must match [A-Za-z0-9-._~:/?#&=,]+
	Variables map[string]*string `locationName:"variables" type:"map"`
}

// String returns the string representation
func (s CreateDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentInput) GoString() string {
	return s.String()
}

// A request to create a new domain name.
type CreateDomainNameInput struct {
	_ struct{} `type:"structure"`

	// The body of the server certificate provided by your certificate authority.
	CertificateBody *string `locationName:"certificateBody" type:"string" required:"true"`

	// The intermediate certificates and optionally the root certificate, one after
	// the other without any blank lines. If you include the root certificate, your
	// certificate chain must start with intermediate certificates and end with
	// the root certificate. Use the intermediate certificates that were provided
	// by your certificate authority. Do not include any intermediaries that are
	// not in the chain of trust path.
	CertificateChain *string `locationName:"certificateChain" type:"string" required:"true"`

	// The name of the certificate.
	CertificateName *string `locationName:"certificateName" type:"string" required:"true"`

	// Your certificate's private key.
	CertificatePrivateKey *string `locationName:"certificatePrivateKey" type:"string" required:"true"`

	// The name of the DomainName resource.
	DomainName *string `locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDomainNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainNameInput) GoString() string {
	return s.String()
}

// Request to add a new Model to an existing RestApi resource.
type CreateModelInput struct {
	_ struct{} `type:"structure"`

	// The content-type for the model.
	ContentType *string `locationName:"contentType" type:"string" required:"true"`

	// The description of the model.
	Description *string `locationName:"description" type:"string"`

	// The name of the model.
	Name *string `locationName:"name" type:"string" required:"true"`

	// The RestApi identifier under which the Model will be created.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// The schema for the model. For application/json models, this should be JSON-schema
	// draft v4 model.
	Schema *string `locationName:"schema" type:"string"`
}

// String returns the string representation
func (s CreateModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateModelInput) GoString() string {
	return s.String()
}

// Requests Amazon API Gateway to create a Resource resource.
type CreateResourceInput struct {
	_ struct{} `type:"structure"`

	// The parent resource's identifier.
	ParentId *string `location:"uri" locationName:"parent_id" type:"string" required:"true"`

	// The last path segment for this resource.
	PathPart *string `locationName:"pathPart" type:"string" required:"true"`

	// The identifier of the RestApi for the resource.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceInput) GoString() string {
	return s.String()
}

// Request to add a new RestApi resource to your collection.
type CreateRestApiInput struct {
	_ struct{} `type:"structure"`

	// The name of the RestApi that you want to clone from.
	CloneFrom *string `locationName:"cloneFrom" type:"string"`

	// The description of the RestApi.
	Description *string `locationName:"description" type:"string"`

	// The name of the RestApi.
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRestApiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRestApiInput) GoString() string {
	return s.String()
}

// Requests Amazon API Gateway to create a Stage resource.
type CreateStageInput struct {
	_ struct{} `type:"structure"`

	// Whether cache clustering is enabled for the stage.
	CacheClusterEnabled *bool `locationName:"cacheClusterEnabled" type:"boolean"`

	// The stage's cache cluster size.
	CacheClusterSize *string `locationName:"cacheClusterSize" type:"string" enum:"CacheClusterSize"`

	// The identifier of the Deployment resource for the Stage resource.
	DeploymentId *string `locationName:"deploymentId" type:"string" required:"true"`

	// The description of the Stage resource.
	Description *string `locationName:"description" type:"string"`

	// The identifier of the RestApi resource for the Stage resource to create.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// The name for the Stage resource.
	StageName *string `locationName:"stageName" type:"string" required:"true"`

	// A map that defines the stage variables for the new Stage resource. Variable
	// names can have alphabetic characters, and the values must match [A-Za-z0-9-._~:/?#&=,]+
	Variables map[string]*string `locationName:"variables" type:"map"`
}

// String returns the string representation
func (s CreateStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStageInput) GoString() string {
	return s.String()
}

// A request to delete the ApiKey resource.
type DeleteApiKeyInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the ApiKey resource to be deleted.
	ApiKey *string `location:"uri" locationName:"api_Key" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApiKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApiKeyInput) GoString() string {
	return s.String()
}

type DeleteApiKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApiKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApiKeyOutput) GoString() string {
	return s.String()
}

// A request to delete the BasePathMapping resource.
type DeleteBasePathMappingInput struct {
	_ struct{} `type:"structure"`

	// The base path name of the BasePathMapping resource to delete.
	BasePath *string `location:"uri" locationName:"base_path" type:"string" required:"true"`

	// The domain name of the BasePathMapping resource to delete.
	DomainName *string `location:"uri" locationName:"domain_name" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBasePathMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBasePathMappingInput) GoString() string {
	return s.String()
}

type DeleteBasePathMappingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBasePathMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBasePathMappingOutput) GoString() string {
	return s.String()
}

type DeleteClientCertificateInput struct {
	_ struct{} `type:"structure"`

	ClientCertificateId *string `location:"uri" locationName:"clientcertificate_id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClientCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClientCertificateInput) GoString() string {
	return s.String()
}

type DeleteClientCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteClientCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClientCertificateOutput) GoString() string {
	return s.String()
}

// Requests Amazon API Gateway to delete a Deployment resource.
type DeleteDeploymentInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Deployment resource to delete.
	DeploymentId *string `location:"uri" locationName:"deployment_id" type:"string" required:"true"`

	// The identifier of the RestApi resource for the Deployment resource to delete.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeploymentInput) GoString() string {
	return s.String()
}

type DeleteDeploymentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeploymentOutput) GoString() string {
	return s.String()
}

// A request to delete the DomainName resource.
type DeleteDomainNameInput struct {
	_ struct{} `type:"structure"`

	// The name of the DomainName resource to be deleted.
	DomainName *string `location:"uri" locationName:"domain_name" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDomainNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainNameInput) GoString() string {
	return s.String()
}

type DeleteDomainNameOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDomainNameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainNameOutput) GoString() string {
	return s.String()
}

// Represents a delete integration request.
type DeleteIntegrationInput struct {
	_ struct{} `type:"structure"`

	// Specifies a delete integration request's HTTP method.
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// Specifies a delete integration request's resource identifier.
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// Specifies a delete integration request's API identifier.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIntegrationInput) GoString() string {
	return s.String()
}

type DeleteIntegrationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIntegrationOutput) GoString() string {
	return s.String()
}

// Represents a delete integration response request.
type DeleteIntegrationResponseInput struct {
	_ struct{} `type:"structure"`

	// Specifies a delete integration response request's HTTP method.
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// Specifies a delete integration response request's resource identifier.
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// Specifies a delete integration response request's API identifier.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// Specifies a delete integration response request's status code.
	StatusCode *string `location:"uri" locationName:"status_code" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIntegrationResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIntegrationResponseInput) GoString() string {
	return s.String()
}

type DeleteIntegrationResponseOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIntegrationResponseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIntegrationResponseOutput) GoString() string {
	return s.String()
}

// Request to delete an existing Method resource.
type DeleteMethodInput struct {
	_ struct{} `type:"structure"`

	// The HTTP verb that identifies the Method resource.
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// The Resource identifier for the Method resource.
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// The RestApi identifier for the Method resource.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMethodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMethodInput) GoString() string {
	return s.String()
}

type DeleteMethodOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMethodOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMethodOutput) GoString() string {
	return s.String()
}

// A request to delete an existing MethodResponse resource.
type DeleteMethodResponseInput struct {
	_ struct{} `type:"structure"`

	// The HTTP verb identifier for the parent Method resource.
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// The Resource identifier for the MethodResponse resource.
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// The RestApi identifier for the MethodResponse resource.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// The status code identifier for the MethodResponse resource.
	StatusCode *string `location:"uri" locationName:"status_code" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMethodResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMethodResponseInput) GoString() string {
	return s.String()
}

type DeleteMethodResponseOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMethodResponseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMethodResponseOutput) GoString() string {
	return s.String()
}

// Request to delete an existing model in an existing RestApi resource.
type DeleteModelInput struct {
	_ struct{} `type:"structure"`

	// The name of the model to delete.
	ModelName *string `location:"uri" locationName:"model_name" type:"string" required:"true"`

	// The RestApi under which the model will be deleted.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteModelInput) GoString() string {
	return s.String()
}

type DeleteModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteModelOutput) GoString() string {
	return s.String()
}

// Request to delete a Resource.
type DeleteResourceInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Resource resource.
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// The RestApi identifier for the Resource resource.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourceInput) GoString() string {
	return s.String()
}

type DeleteResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourceOutput) GoString() string {
	return s.String()
}

// Request to delete the specified API from your collection.
type DeleteRestApiInput struct {
	_ struct{} `type:"structure"`

	// The ID of the RestApi you want to delete.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRestApiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRestApiInput) GoString() string {
	return s.String()
}

type DeleteRestApiOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRestApiOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRestApiOutput) GoString() string {
	return s.String()
}

// Requests Amazon API Gateway to delete a Stage resource.
type DeleteStageInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the RestApi resource for the Stage resource to delete.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// The name of the Stage resource to delete.
	StageName *string `location:"uri" locationName:"stage_name" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStageInput) GoString() string {
	return s.String()
}

type DeleteStageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStageOutput) GoString() string {
	return s.String()
}

// An immutable representation of a RestApi resource that can be called by users
// using Stages. A deployment must be associated with a Stage for it to be callable
// over the Internet.
type Deployment struct {
	_ struct{} `type:"structure"`

	// Gets a summary of the RestApi at the date and time that the deployment resource
	// was created.
	ApiSummary map[string]map[string]*MethodSnapshot `locationName:"apiSummary" type:"map"`

	// The date and time that the deployment resource was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"unix"`

	// The description for the deployment resource.
	Description *string `locationName:"description" type:"string"`

	// The identifier for the deployment resource.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s Deployment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Deployment) GoString() string {
	return s.String()
}

// Represents a domain name that is contained in a simpler, more intuitive URL
// that can be called.
type DomainName struct {
	_ struct{} `type:"structure"`

	// The name of the certificate.
	CertificateName *string `locationName:"certificateName" type:"string"`

	// The date when the certificate was uploaded, in ISO 8601 format.
	CertificateUploadDate *time.Time `locationName:"certificateUploadDate" type:"timestamp" timestampFormat:"unix"`

	// The domain name of the Amazon CloudFront distribution. For more information,
	// see the Amazon CloudFront documentation.
	DistributionDomainName *string `locationName:"distributionDomainName" type:"string"`

	// The name of the DomainName resource.
	DomainName *string `locationName:"domainName" type:"string"`
}

// String returns the string representation
func (s DomainName) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainName) GoString() string {
	return s.String()
}

// Requests Amazon API Gateway to flush a stage's cache.
type FlushStageCacheInput struct {
	_ struct{} `type:"structure"`

	// The API identifier of the stage to flush its cache.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// The name of the stage to flush its cache.
	StageName *string `location:"uri" locationName:"stage_name" type:"string" required:"true"`
}

// String returns the string representation
func (s FlushStageCacheInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FlushStageCacheInput) GoString() string {
	return s.String()
}

type FlushStageCacheOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s FlushStageCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FlushStageCacheOutput) GoString() string {
	return s.String()
}

type GenerateClientCertificateInput struct {
	_ struct{} `type:"structure"`

	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation
func (s GenerateClientCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateClientCertificateInput) GoString() string {
	return s.String()
}

// Requests Amazon API Gateway to get information about the current Account
// resource.
type GetAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountInput) GoString() string {
	return s.String()
}

// A request to get information about the current ApiKey resource.
type GetApiKeyInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the ApiKey resource.
	ApiKey *string `location:"uri" locationName:"api_Key" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApiKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApiKeyInput) GoString() string {
	return s.String()
}

// A request to get information about the current ApiKeys resource.
type GetApiKeysInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of ApiKeys to get information about.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The position of the current ApiKeys resource to get information about.
	Position *string `location:"querystring" locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetApiKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApiKeysInput) GoString() string {
	return s.String()
}

// Represents a collection of ApiKey resources.
type GetApiKeysOutput struct {
	_ struct{} `type:"structure"`

	// The current page of any ApiKey resources in the collection of ApiKey resources.
	Items []*ApiKey `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetApiKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApiKeysOutput) GoString() string {
	return s.String()
}

// Request to describe a BasePathMapping resource.
type GetBasePathMappingInput struct {
	_ struct{} `type:"structure"`

	// The base path name that callers of the API must provide as part of the URL
	// after the domain name. This value must be unique for all of the mappings
	// across a single API. Leave this blank if you do not want callers to specify
	// any base path name after the domain name.
	BasePath *string `location:"uri" locationName:"base_path" type:"string" required:"true"`

	// The domain name of the BasePathMapping resource to be described.
	DomainName *string `location:"uri" locationName:"domain_name" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBasePathMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBasePathMappingInput) GoString() string {
	return s.String()
}

// A request to get information about a collection of BasePathMapping resources.
type GetBasePathMappingsInput struct {
	_ struct{} `type:"structure"`

	// The domain name of a BasePathMapping resource.
	DomainName *string `location:"uri" locationName:"domain_name" type:"string" required:"true"`

	// The maximum number of BasePathMapping resources in the collection to get
	// information about. The default limit is 25. It should be an integer between
	// 1 - 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The position of the current BasePathMapping resource in the collection to
	// get information about.
	Position *string `location:"querystring" locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetBasePathMappingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBasePathMappingsInput) GoString() string {
	return s.String()
}

// Represents a collection of BasePathMapping resources.
type GetBasePathMappingsOutput struct {
	_ struct{} `type:"structure"`

	// The current page of any BasePathMapping resources in the collection of base
	// path mapping resources.
	Items []*BasePathMapping `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetBasePathMappingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBasePathMappingsOutput) GoString() string {
	return s.String()
}

type GetClientCertificateInput struct {
	_ struct{} `type:"structure"`

	ClientCertificateId *string `location:"uri" locationName:"clientcertificate_id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetClientCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetClientCertificateInput) GoString() string {
	return s.String()
}

type GetClientCertificatesInput struct {
	_ struct{} `type:"structure"`

	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	Position *string `location:"querystring" locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetClientCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetClientCertificatesInput) GoString() string {
	return s.String()
}

type GetClientCertificatesOutput struct {
	_ struct{} `type:"structure"`

	Items []*ClientCertificate `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetClientCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetClientCertificatesOutput) GoString() string {
	return s.String()
}

// Requests Amazon API Gateway to get information about a Deployment resource.
type GetDeploymentInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Deployment resource to get information about.
	DeploymentId *string `location:"uri" locationName:"deployment_id" type:"string" required:"true"`

	// The identifier of the RestApi resource for the Deployment resource to get
	// information about.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentInput) GoString() string {
	return s.String()
}

// Requests Amazon API Gateway to get information about a Deployments collection.
type GetDeploymentsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of Deployment resources in the collection to get information
	// about. The default limit is 25. It should be an integer between 1 - 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The position of the current Deployment resource in the collection to get
	// information about.
	Position *string `location:"querystring" locationName:"position" type:"string"`

	// The identifier of the RestApi resource for the collection of Deployment resources
	// to get information about.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentsInput) GoString() string {
	return s.String()
}

// Represents a collection resource that contains zero or more references to
// your existing deployments, and links that guide you on ways to interact with
// your collection. The collection offers a paginated view of the contained
// deployments.
type GetDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// The current page of any Deployment resources in the collection of deployment
	// resources.
	Items []*Deployment `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentsOutput) GoString() string {
	return s.String()
}

// Request to get the name of a DomainName resource.
type GetDomainNameInput struct {
	_ struct{} `type:"structure"`

	// The name of the DomainName resource.
	DomainName *string `location:"uri" locationName:"domain_name" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDomainNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainNameInput) GoString() string {
	return s.String()
}

// Request to describe a collection of DomainName resources.
type GetDomainNamesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of DomainName resources in the collection to get information
	// about. The default limit is 25. It should be an integer between 1 - 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The position of the current domain names to get information about.
	Position *string `location:"querystring" locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetDomainNamesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainNamesInput) GoString() string {
	return s.String()
}

// Represents a collection of DomainName resources.
type GetDomainNamesOutput struct {
	_ struct{} `type:"structure"`

	// The current page of any DomainName resources in the collection of DomainName
	// resources.
	Items []*DomainName `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetDomainNamesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainNamesOutput) GoString() string {
	return s.String()
}

// Represents a get integration request.
type GetIntegrationInput struct {
	_ struct{} `type:"structure"`

	// Specifies a get integration request's HTTP method.
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// Specifies a get integration request's resource identifier
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// Specifies a get integration request's API identifier.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIntegrationInput) GoString() string {
	return s.String()
}

// Represents a get integration response request.
type GetIntegrationResponseInput struct {
	_ struct{} `type:"structure"`

	// Specifies a get integration response request's HTTP method.
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// Specifies a get integration response request's resource identifier.
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// Specifies a get integration response request's API identifier.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// Specifies a get integration response request's status code.
	StatusCode *string `location:"uri" locationName:"status_code" type:"string" required:"true"`
}

// String returns the string representation
func (s GetIntegrationResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIntegrationResponseInput) GoString() string {
	return s.String()
}

// Request to describe an existing Method resource.
type GetMethodInput struct {
	_ struct{} `type:"structure"`

	// Specifies the put method request's HTTP method type.
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// The Resource identifier for the Method resource.
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// The RestApi identifier for the Method resource.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMethodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMethodInput) GoString() string {
	return s.String()
}

// Request to describe a MethodResponse resource.
type GetMethodResponseInput struct {
	_ struct{} `type:"structure"`

	// The HTTP verb identifier for the parent Method resource.
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// The Resource identifier for the MethodResponse resource.
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// The RestApi identifier for the MethodResponse resource.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// The status code identifier for the MethodResponse resource.
	StatusCode *string `location:"uri" locationName:"status_code" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMethodResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMethodResponseInput) GoString() string {
	return s.String()
}

// Request to list information about a model in an existing RestApi resource.
type GetModelInput struct {
	_ struct{} `type:"structure"`

	// Resolves all external model references and returns a flattened model schema.
	Flatten *bool `location:"querystring" locationName:"flatten" type:"boolean"`

	// The name of the model as an identifier.
	ModelName *string `location:"uri" locationName:"model_name" type:"string" required:"true"`

	// The RestApi identifier under which the Model exists.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetModelInput) GoString() string {
	return s.String()
}

// Request to generate a sample mapping template used to transform the payload.
type GetModelTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the model for which to generate a template.
	ModelName *string `location:"uri" locationName:"model_name" type:"string" required:"true"`

	// The ID of the RestApi under which the model exists.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetModelTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetModelTemplateInput) GoString() string {
	return s.String()
}

// Represents a mapping template used to transform a payload.
type GetModelTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The Apache Velocity Template Language (VTL) template content used for the
	// template resource.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s GetModelTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetModelTemplateOutput) GoString() string {
	return s.String()
}

// Request to list existing Models defined for a RestApi resource.
type GetModelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of models in the collection to get information about.
	// The default limit is 25. It should be an integer between 1 - 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The position of the next set of results in the Models resource to get information
	// about.
	Position *string `location:"querystring" locationName:"position" type:"string"`

	// The RestApi identifier.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetModelsInput) GoString() string {
	return s.String()
}

// Represents a collection of Model resources.
type GetModelsOutput struct {
	_ struct{} `type:"structure"`

	// Gets the current Model resource in the collection.
	Items []*Model `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetModelsOutput) GoString() string {
	return s.String()
}

// Request to list information about a resource.
type GetResourceInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Resource resource.
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// The RestApi identifier for the resource.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceInput) GoString() string {
	return s.String()
}

// Request to list information about a collection of resources.
type GetResourcesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of Resource resources in the collection to get information
	// about. The default limit is 25. It should be an integer between 1 - 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The position of the next set of results in the current Resources resource
	// to get information about.
	Position *string `location:"querystring" locationName:"position" type:"string"`

	// The RestApi identifier for the Resource.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourcesInput) GoString() string {
	return s.String()
}

// Represents a collection of Resource resources.
type GetResourcesOutput struct {
	_ struct{} `type:"structure"`

	// Gets the current Resource resource in the collection.
	Items []*Resource `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourcesOutput) GoString() string {
	return s.String()
}

// Request to list an existing RestApi defined for your collection.
type GetRestApiInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the RestApi resource.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRestApiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRestApiInput) GoString() string {
	return s.String()
}

// Request to list existing RestApis defined for your collection.
type GetRestApisInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of RestApi resources in the collection to get information
	// about. The default limit is 25. It should be an integer between 1 - 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The position of the current RestApis resource in the collection to get information
	// about.
	Position *string `location:"querystring" locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetRestApisInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRestApisInput) GoString() string {
	return s.String()
}

// Contains references to your APIs and links that guide you in ways to interact
// with your collection. A collection offers a paginated view of your APIs.
type GetRestApisOutput struct {
	_ struct{} `type:"structure"`

	// An array of links to the current page of RestApi resources.
	Items []*RestApi `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetRestApisOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRestApisOutput) GoString() string {
	return s.String()
}

type GetSdkInput struct {
	_ struct{} `type:"structure"`

	Parameters map[string]*string `location:"querystring" locationName:"parameters" type:"map"`

	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	SdkType *string `location:"uri" locationName:"sdk_type" type:"string" required:"true"`

	StageName *string `location:"uri" locationName:"stage_name" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSdkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSdkInput) GoString() string {
	return s.String()
}

type GetSdkOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	Body []byte `locationName:"body" type:"blob"`

	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`
}

// String returns the string representation
func (s GetSdkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSdkOutput) GoString() string {
	return s.String()
}

// Requests Amazon API Gateway to get information about a Stage resource.
type GetStageInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the RestApi resource for the Stage resource to get information
	// about.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// The name of the Stage resource to get information about.
	StageName *string `location:"uri" locationName:"stage_name" type:"string" required:"true"`
}

// String returns the string representation
func (s GetStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStageInput) GoString() string {
	return s.String()
}

// Requests Amazon API Gateway to get information about one or more Stage resources.
type GetStagesInput struct {
	_ struct{} `type:"structure"`

	// The stages' deployment identifiers.
	DeploymentId *string `location:"querystring" locationName:"deploymentId" type:"string"`

	// The stages' API identifiers.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetStagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStagesInput) GoString() string {
	return s.String()
}

// A list of Stage resource that are associated with the ApiKey resource.
type GetStagesOutput struct {
	_ struct{} `type:"structure"`

	// An individual Stage resource.
	Item []*Stage `locationName:"item" type:"list"`
}

// String returns the string representation
func (s GetStagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStagesOutput) GoString() string {
	return s.String()
}

// Represents a HTTP, AWS, or Mock integration.
type Integration struct {
	_ struct{} `type:"structure"`

	// Specifies the integration's cache key parameters.
	CacheKeyParameters []*string `locationName:"cacheKeyParameters" type:"list"`

	// Specifies the integration's cache namespace.
	CacheNamespace *string `locationName:"cacheNamespace" type:"string"`

	// Specifies the credentials required for the integration, if any. For AWS integrations,
	// three options are available. To specify an IAM Role for Amazon API Gateway
	// to assume, use the role's Amazon Resource Name (ARN). To require that the
	// caller's identity be passed through from the request, specify the string
	// arn:aws:iam::\*:user/\*. To use resource-based permissions on supported AWS
	// services, specify null.
	Credentials *string `locationName:"credentials" type:"string"`

	// Specifies the integration's HTTP method type.
	HttpMethod *string `locationName:"httpMethod" type:"string"`

	// Specifies the integration's responses.
	IntegrationResponses map[string]*IntegrationResponse `locationName:"integrationResponses" type:"map"`

	// Represents requests parameters that are sent with the backend request. Request
	// parameters are represented as a key/value map, with a destination as the
	// key and a source as the value. A source must match an existing method request
	// parameter, or a static value. Static values must be enclosed with single
	// quotes, and be pre-encoded based on their destination in the request. The
	// destination must match the pattern integration.request.{location}.{name},
	// where location is either querystring, path, or header. name must be a valid,
	// unique parameter name.
	RequestParameters map[string]*string `locationName:"requestParameters" type:"map"`

	// Specifies the integration's request templates.
	RequestTemplates map[string]*string `locationName:"requestTemplates" type:"map"`

	// Specifies the integration's type.
	Type *string `locationName:"type" type:"string" enum:"IntegrationType"`

	// Specifies the integration's Uniform Resource Identifier (URI). For HTTP integrations,
	// the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986
	// specification. For AWS integrations, the URI should be of the form arn:aws:apigateway:{region}:{service}:{path|action}/{service_api}.
	// Region and service are used to determine the right endpoint. For AWS services
	// that use the Action= query string parameter, service_api should be a valid
	// action for the desired service. For RESTful AWS service APIs, path is used
	// to indicate that the remaining substring in the URI should be treated as
	// the path to the resource, including the initial /.
	Uri *string `locationName:"uri" type:"string"`
}

// String returns the string representation
func (s Integration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Integration) GoString() string {
	return s.String()
}

// Represents an integration response. The status code must map to an existing
// MethodResponse, and parameters and templates can be used to transform the
// backend response.
type IntegrationResponse struct {
	_ struct{} `type:"structure"`

	// Represents response parameters that can be read from the backend response.
	// Response parameters are represented as a key/value map, with a destination
	// as the key and a source as the value. A destination must match an existing
	// response parameter in the Method. The source can be a header from the backend
	// response, or a static value. Static values are specified using enclosing
	// single quotes, and backend response headers can be read using the pattern
	// integration.response.header.{name}.
	ResponseParameters map[string]*string `locationName:"responseParameters" type:"map"`

	// Specifies the templates used to transform the integration response body.
	// Response templates are represented as a key/value map, with a content-type
	// as the key and a template as the value.
	ResponseTemplates map[string]*string `locationName:"responseTemplates" type:"map"`

	// Specifies the regular expression (regex) pattern used to choose an integration
	// response based on the response from the backend. If the backend is an AWS
	// Lambda function, the AWS Lambda function error header is matched. For all
	// other HTTP and AWS backends, the HTTP status code is matched.
	SelectionPattern *string `locationName:"selectionPattern" type:"string"`

	// Specifies the status code that is used to map the integration response to
	// an existing MethodResponse.
	StatusCode *string `locationName:"statusCode" type:"string"`
}

// String returns the string representation
func (s IntegrationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IntegrationResponse) GoString() string {
	return s.String()
}

// Represents a method.
type Method struct {
	_ struct{} `type:"structure"`

	// Specifies whether the method requires a valid ApiKey.
	ApiKeyRequired *bool `locationName:"apiKeyRequired" type:"boolean"`

	// The method's authorization type.
	AuthorizationType *string `locationName:"authorizationType" type:"string"`

	// The HTTP method.
	HttpMethod *string `locationName:"httpMethod" type:"string"`

	// The method's integration.
	MethodIntegration *Integration `locationName:"methodIntegration" type:"structure"`

	// Represents available responses that can be sent to the caller. Method responses
	// are represented as a key/value map, with an HTTP status code as the key and
	// a MethodResponse as the value. The status codes are available for the Integration
	// responses to map to.
	MethodResponses map[string]*MethodResponse `locationName:"methodResponses" type:"map"`

	// Specifies the Model resources used for the request's content type. Request
	// models are represented as a key/value map, with a content type as the key
	// and a Model name as the value.
	RequestModels map[string]*string `locationName:"requestModels" type:"map"`

	// Represents request parameters that can be accepted by Amazon API Gateway.
	// Request parameters are represented as a key/value map, with a source as the
	// key and a Boolean flag as the value. The Boolean flag is used to specify
	// whether the parameter is required. A source must match the pattern method.request.{location}.{name},
	// where location is either querystring, path, or header. name is a valid, unique
	// parameter name. Sources specified here are available to the integration for
	// mapping to integration request parameters or templates.
	RequestParameters map[string]*bool `locationName:"requestParameters" type:"map"`
}

// String returns the string representation
func (s Method) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Method) GoString() string {
	return s.String()
}

// Represents a method response. Amazon API Gateway sends back the status code
// to the caller as the HTTP status code. Parameters and models can be used
// to transform the response from the method's integration.
type MethodResponse struct {
	_ struct{} `type:"structure"`

	// Specifies the Model resources used for the response's content-type. Response
	// models are represented as a key/value map, with a content-type as the key
	// and a Model name as the value.
	ResponseModels map[string]*string `locationName:"responseModels" type:"map"`

	// Represents response parameters that can be sent back to the caller by Amazon
	// API Gateway. Response parameters are represented as a key/value map, with
	// a destination as the key and a boolean flag as the value, which is used to
	// specify whether the parameter is required. A destination must match the pattern
	// method.response.header.{name}, where name is a valid, unique header name.
	// Destinations specified here are available to the integration for mapping
	// from integration response parameters.
	ResponseParameters map[string]*bool `locationName:"responseParameters" type:"map"`

	// The method response's status code.
	StatusCode *string `locationName:"statusCode" type:"string"`
}

// String returns the string representation
func (s MethodResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MethodResponse) GoString() string {
	return s.String()
}

// Specifies the method setting properties.
type MethodSetting struct {
	_ struct{} `type:"structure"`

	// Specifies whether the cached responses are encrypted. The PATCH path for
	// this setting is /{method_setting_key}/caching/dataEncrypted, and the value
	// is a Boolean.
	CacheDataEncrypted *bool `locationName:"cacheDataEncrypted" type:"boolean"`

	// Specifies the time to live (TTL) in seconds, for cached responses. The higher
	// a the TTL, the longer the response will be cached. The PATCH path for this
	// setting is /{method_setting_key}/caching/ttlInSeconds, and the value is an
	// integer.
	CacheTtlInSeconds *int64 `locationName:"cacheTtlInSeconds" type:"integer"`

	// Specifies whether responses should be cached and returned for requests. A
	// cache cluster must be enabled on the stage for responses to be cached. The
	// PATCH path for this setting is /{method_setting_key}/caching/enabled, and
	// the value is a Boolean.
	CachingEnabled *bool `locationName:"cachingEnabled" type:"boolean"`

	// Specifies the whether data trace logging is enabled for this method, which
	// effects the log entries pushed to Amazon CloudWatch Logs. The PATCH path
	// for this setting is /{method_setting_key}/logging/dataTrace, and the value
	// is a Boolean.
	DataTraceEnabled *bool `locationName:"dataTraceEnabled" type:"boolean"`

	// Specifies the logging level for this method, which effects the log entries
	// pushed to Amazon CloudWatch Logs. The PATCH path for this setting is /{method_setting_key}/logging/loglevel,
	// and the available levels are OFF, ERROR, and INFO.
	LoggingLevel *string `locationName:"loggingLevel" type:"string"`

	// Specifies whether Amazon CloudWatch metrics are enabled for this method.
	// The PATCH path for this setting is /{method_setting_key}/metrics/enabled,
	// and the value is a Boolean.
	MetricsEnabled *bool `locationName:"metricsEnabled" type:"boolean"`

	// Specifies the throttling burst limit. The PATCH path for this setting is
	// /{method_setting_key}/throttling/burstLimit, and the value is an integer.
	ThrottlingBurstLimit *int64 `locationName:"throttlingBurstLimit" type:"integer"`

	// Specifies the throttling rate limit. The PATCH path for this setting is /{method_setting_key}/throttling/rateLimit,
	// and the value is a double.
	ThrottlingRateLimit *float64 `locationName:"throttlingRateLimit" type:"double"`
}

// String returns the string representation
func (s MethodSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MethodSetting) GoString() string {
	return s.String()
}

// Represents a summary of a Method resource, given a particular date and time.
type MethodSnapshot struct {
	_ struct{} `type:"structure"`

	// Specifies whether the method requires a valid ApiKey.
	ApiKeyRequired *bool `locationName:"apiKeyRequired" type:"boolean"`

	// Specifies the type of authorization used for the method.
	AuthorizationType *string `locationName:"authorizationType" type:"string"`
}

// String returns the string representation
func (s MethodSnapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MethodSnapshot) GoString() string {
	return s.String()
}

// Represents the structure of a request or response payload for a method.
type Model struct {
	_ struct{} `type:"structure"`

	// The content-type for the model.
	ContentType *string `locationName:"contentType" type:"string"`

	// The description of the model.
	Description *string `locationName:"description" type:"string"`

	// The identifier for the model resource.
	Id *string `locationName:"id" type:"string"`

	// The name of the model.
	Name *string `locationName:"name" type:"string"`

	// The schema for the model. For application/json models, this should be JSON-schema
	// draft v4 model.
	Schema *string `locationName:"schema" type:"string"`
}

// String returns the string representation
func (s Model) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Model) GoString() string {
	return s.String()
}

// A single patch operation to apply to the specified resource. Please refer
// to http://tools.ietf.org/html/rfc6902#section-4 for an explanation of how
// each operation is used.
type PatchOperation struct {
	_ struct{} `type:"structure"`

	// The "move" and "copy" operation object MUST contain a "from" member, which
	// is a string containing a JSON Pointer value that references the location
	// in the target document to move the value from.
	From *string `locationName:"from" type:"string"`

	// A patch operation whose value indicates the operation to perform. Its value
	// MUST be one of "add", "remove", "replace", "move", "copy", or "test"; other
	// values are errors.
	Op *string `locationName:"op" type:"string" enum:"op"`

	// Operation objects MUST have exactly one "path" member. That member's value
	// is a string containing a `JSON-Pointer` value that references a location
	// within the target document (the "target location") where the operation is
	// performed.
	Path *string `locationName:"path" type:"string"`

	// The actual value content.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s PatchOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PatchOperation) GoString() string {
	return s.String()
}

// Represents a put integration request.
type PutIntegrationInput struct {
	_ struct{} `type:"structure"`

	// Specifies a put integration input's cache key parameters.
	CacheKeyParameters []*string `locationName:"cacheKeyParameters" type:"list"`

	// Specifies a put integration input's cache namespace.
	CacheNamespace *string `locationName:"cacheNamespace" type:"string"`

	// Specifies whether credentials are required for a put integration.
	Credentials *string `locationName:"credentials" type:"string"`

	// Specifies a put integration request's HTTP method.
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// Specifies a put integration HTTP method.
	IntegrationHttpMethod *string `locationName:"httpMethod" type:"string"`

	// Represents request parameters that are sent with the backend request. Request
	// parameters are represented as a key/value map, with a destination as the
	// key and a source as the value. A source must match an existing method request
	// parameter, or a static value. Static values must be enclosed with single
	// quotes, and be pre-encoded based on their destination in the request. The
	// destination must match the pattern integration.request.{location}.{name},
	// where location is either querystring, path, or header. name must be a valid,
	// unique parameter name.
	RequestParameters map[string]*string `locationName:"requestParameters" type:"map"`

	// Specifies the templates used to transform the method request body. Request
	// templates are represented as a key/value map, with a content-type as the
	// key and a template as the value.
	RequestTemplates map[string]*string `locationName:"requestTemplates" type:"map"`

	// Specifies a put integration request's resource ID.
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// Specifies a put integration request's API identifier.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// Specifies a put integration input's type.
	Type *string `locationName:"type" type:"string" required:"true" enum:"IntegrationType"`

	// Specifies a put integration input's Uniform Resource Identifier (URI).
	Uri *string `locationName:"uri" type:"string"`
}

// String returns the string representation
func (s PutIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutIntegrationInput) GoString() string {
	return s.String()
}

// Represents a put integration response request.
type PutIntegrationResponseInput struct {
	_ struct{} `type:"structure"`

	// Specifies a put integration response request's HTTP method.
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// Specifies a put integration response request's resource identifier.
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// Represents response parameters that can be read from the backend response.
	// Response parameters are represented as a key/value map, with a destination
	// as the key and a source as the value. A destination must match an existing
	// response parameter in the Method. The source can be a header from the backend
	// response, or a static value. Static values are specified using enclosing
	// single quotes, and backend response headers can be read using the pattern
	// integration.response.header.{name}.
	ResponseParameters map[string]*string `locationName:"responseParameters" type:"map"`

	// Specifies a put integration response's templates.
	ResponseTemplates map[string]*string `locationName:"responseTemplates" type:"map"`

	// Specifies a put integration response request's API identifier.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// Specifies the selection pattern of a put integration response.
	SelectionPattern *string `locationName:"selectionPattern" type:"string"`

	// Specifies the status code that is used to map the integration response to
	// an existing MethodResponse.
	StatusCode *string `location:"uri" locationName:"status_code" type:"string" required:"true"`
}

// String returns the string representation
func (s PutIntegrationResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutIntegrationResponseInput) GoString() string {
	return s.String()
}

// Request to add a method to an existing Resource resource.
type PutMethodInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the method required a valid ApiKey.
	ApiKeyRequired *bool `locationName:"apiKeyRequired" type:"boolean"`

	// Specifies the type of authorization used for the method.
	AuthorizationType *string `locationName:"authorizationType" type:"string" required:"true"`

	// Specifies the put method request's HTTP method type.
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// Specifies the Model resources used for the request's content type. Request
	// models are represented as a key/value map, with a content type as the key
	// and a Model name as the value.
	RequestModels map[string]*string `locationName:"requestModels" type:"map"`

	// Represents requests parameters that are sent with the backend request. Request
	// parameters are represented as a key/value map, with a destination as the
	// key and a source as the value. A source must match an existing method request
	// parameter, or a static value. Static values must be enclosed with single
	// quotes, and be pre-encoded based on their destination in the request. The
	// destination must match the pattern integration.request.{location}.{name},
	// where location is either querystring, path, or header. name must be a valid,
	// unique parameter name.
	RequestParameters map[string]*bool `locationName:"requestParameters" type:"map"`

	// The Resource identifier for the new Method resource.
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// The RestApi identifier for the new Method resource.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s PutMethodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMethodInput) GoString() string {
	return s.String()
}

// Request to add a MethodResponse to an existing Method resource.
type PutMethodResponseInput struct {
	_ struct{} `type:"structure"`

	// The HTTP verb that identifies the Method resource.
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// The Resource identifier for the Method resource.
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// Specifies the Model resources used for the response's content type. Response
	// models are represented as a key/value map, with a content type as the key
	// and a Model name as the value.
	ResponseModels map[string]*string `locationName:"responseModels" type:"map"`

	// Represents response parameters that can be sent back to the caller by Amazon
	// API Gateway. Response parameters are represented as a key/value map, with
	// a destination as the key and a Boolean flag as the value. The Boolean flag
	// is used to specify whether the parameter is required. A destination must
	// match the pattern method.response.header.{name}, where name is a valid, unique
	// header name. Destinations specified here are available to the integration
	// for mapping from integration response parameters.
	ResponseParameters map[string]*bool `locationName:"responseParameters" type:"map"`

	// The RestApi identifier for the Method resource.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// The method response's status code.
	StatusCode *string `location:"uri" locationName:"status_code" type:"string" required:"true"`
}

// String returns the string representation
func (s PutMethodResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMethodResponseInput) GoString() string {
	return s.String()
}

// Represents a resource.
type Resource struct {
	_ struct{} `type:"structure"`

	// The resource's identifier.
	Id *string `locationName:"id" type:"string"`

	// The parent resource's identifier.
	ParentId *string `locationName:"parentId" type:"string"`

	// The full path for this resource.
	Path *string `locationName:"path" type:"string"`

	// The last path segment for this resource.
	PathPart *string `locationName:"pathPart" type:"string"`

	// Map of methods for this resource, which is included only if requested using
	// the embed option.
	ResourceMethods map[string]*Method `locationName:"resourceMethods" type:"map"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Resource) GoString() string {
	return s.String()
}

// Represents a REST API.
type RestApi struct {
	_ struct{} `type:"structure"`

	// The date when the API was created, in ISO 8601 format.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"unix"`

	// The API's description.
	Description *string `locationName:"description" type:"string"`

	// The API's identifier. This identifier is unique across all of your APIs in
	// Amazon API Gateway.
	Id *string `locationName:"id" type:"string"`

	// The API's name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s RestApi) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestApi) GoString() string {
	return s.String()
}

// Represents a unique identifier for a version of a deployed RestApi that is
// callable by users.
type Stage struct {
	_ struct{} `type:"structure"`

	// Specifies whether a cache cluster is enabled for the stage.
	CacheClusterEnabled *bool `locationName:"cacheClusterEnabled" type:"boolean"`

	// The size of the cache cluster for the stage, if enabled.
	CacheClusterSize *string `locationName:"cacheClusterSize" type:"string" enum:"CacheClusterSize"`

	// The status of the cache cluster for the stage, if enabled.
	CacheClusterStatus *string `locationName:"cacheClusterStatus" type:"string" enum:"CacheClusterStatus"`

	ClientCertificateId *string `locationName:"clientCertificateId" type:"string"`

	// The date and time that the stage was created, in ISO 8601 format.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"unix"`

	// The identifier of the Deployment that the stage points to.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// The stage's description.
	Description *string `locationName:"description" type:"string"`

	// The date and time that information about the stage was last updated, in ISO
	// 8601 format.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"unix"`

	// A map that defines the method settings for a Stage resource. Keys are defined
	// as {resource_path}/{http_method} for an individual method override, or \*/\*
	// for the settings applied to all methods in the stage.
	MethodSettings map[string]*MethodSetting `locationName:"methodSettings" type:"map"`

	// The name of the stage is the first path segment in the Uniform Resource Identifier
	// (URI) of a call to Amazon API Gateway.
	StageName *string `locationName:"stageName" type:"string"`

	// A map that defines the stage variables for a Stage resource. Variable names
	// can have alphabetic characters, and the values must match [A-Za-z0-9-._~:/?#&=,]+
	Variables map[string]*string `locationName:"variables" type:"map"`
}

// String returns the string representation
func (s Stage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Stage) GoString() string {
	return s.String()
}

// A reference to a unique stage identified in the format {restApiId}/{stage}.
type StageKey struct {
	_ struct{} `type:"structure"`

	// A list of Stage resources that are associated with the ApiKey resource.
	RestApiId *string `locationName:"restApiId" type:"string"`

	// The stage name in the RestApi that the stage key references.
	StageName *string `locationName:"stageName" type:"string"`
}

// String returns the string representation
func (s StageKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StageKey) GoString() string {
	return s.String()
}

type TestInvokeMethodInput struct {
	_ struct{} `type:"structure"`

	Body *string `locationName:"body" type:"string"`

	ClientCertificateId *string `locationName:"clientCertificateId" type:"string"`

	Headers map[string]*string `locationName:"headers" type:"map"`

	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	PathWithQueryString *string `locationName:"pathWithQueryString" type:"string"`

	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	StageVariables map[string]*string `locationName:"stageVariables" type:"map"`
}

// String returns the string representation
func (s TestInvokeMethodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestInvokeMethodInput) GoString() string {
	return s.String()
}

// Represents the response of the test invoke request in HTTP method.
type TestInvokeMethodOutput struct {
	_ struct{} `type:"structure"`

	// The body of HTTP response.
	Body *string `locationName:"body" type:"string"`

	// The headers of HTTP response.
	Headers map[string]*string `locationName:"headers" type:"map"`

	// The execution latency of the test invoke request.
	Latency *int64 `locationName:"latency" type:"long"`

	// The Amazon API Gateway execution log for the test invoke request.
	Log *string `locationName:"log" type:"string"`

	// The HTTP status code.
	Status *int64 `locationName:"status" type:"integer"`
}

// String returns the string representation
func (s TestInvokeMethodOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestInvokeMethodOutput) GoString() string {
	return s.String()
}

// Returns the throttle settings.
type ThrottleSettings struct {
	_ struct{} `type:"structure"`

	// Returns the burstLimit when ThrottleSettings is called.
	BurstLimit *int64 `locationName:"burstLimit" type:"integer"`

	// Returns the rateLimit when ThrottleSettings is called.
	RateLimit *float64 `locationName:"rateLimit" type:"double"`
}

// String returns the string representation
func (s ThrottleSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottleSettings) GoString() string {
	return s.String()
}

// Requests Amazon API Gateway to change information about the current Account
// resource.
type UpdateAccountInput struct {
	_ struct{} `type:"structure"`

	// A list of operations describing the updates to apply to the specified resource.
	// The patches are applied in the order specified in the list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`
}

// String returns the string representation
func (s UpdateAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAccountInput) GoString() string {
	return s.String()
}

// A request to change information about an ApiKey resource.
type UpdateApiKeyInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the ApiKey resource to be updated.
	ApiKey *string `location:"uri" locationName:"api_Key" type:"string" required:"true"`

	// A list of operations describing the updates to apply to the specified resource.
	// The patches are applied in the order specified in the list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`
}

// String returns the string representation
func (s UpdateApiKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApiKeyInput) GoString() string {
	return s.String()
}

// A request to change information about the BasePathMapping resource.
type UpdateBasePathMappingInput struct {
	_ struct{} `type:"structure"`

	// The base path of the BasePathMapping resource to change.
	BasePath *string `location:"uri" locationName:"base_path" type:"string" required:"true"`

	// The domain name of the BasePathMapping resource to change.
	DomainName *string `location:"uri" locationName:"domain_name" type:"string" required:"true"`

	// A list of operations describing the updates to apply to the specified resource.
	// The patches are applied in the order specified in the list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`
}

// String returns the string representation
func (s UpdateBasePathMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBasePathMappingInput) GoString() string {
	return s.String()
}

type UpdateClientCertificateInput struct {
	_ struct{} `type:"structure"`

	ClientCertificateId *string `location:"uri" locationName:"clientcertificate_id" type:"string" required:"true"`

	// A list of operations describing the updates to apply to the specified resource.
	// The patches are applied in the order specified in the list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`
}

// String returns the string representation
func (s UpdateClientCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateClientCertificateInput) GoString() string {
	return s.String()
}

// Requests Amazon API Gateway to change information about a Deployment resource.
type UpdateDeploymentInput struct {
	_ struct{} `type:"structure"`

	// The replacment identifier for the Deployment resource to change information
	// about.
	DeploymentId *string `location:"uri" locationName:"deployment_id" type:"string" required:"true"`

	// A list of operations describing the updates to apply to the specified resource.
	// The patches are applied in the order specified in the list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// The replacement identifier of the RestApi resource for the Deployment resource
	// to change information about.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeploymentInput) GoString() string {
	return s.String()
}

// A request to change information about the DomainName resource.
type UpdateDomainNameInput struct {
	_ struct{} `type:"structure"`

	// The name of the DomainName resource to be changed.
	DomainName *string `location:"uri" locationName:"domain_name" type:"string" required:"true"`

	// A list of operations describing the updates to apply to the specified resource.
	// The patches are applied in the order specified in the list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`
}

// String returns the string representation
func (s UpdateDomainNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainNameInput) GoString() string {
	return s.String()
}

// Represents an update integration request.
type UpdateIntegrationInput struct {
	_ struct{} `type:"structure"`

	// Represents an update integration request's HTTP method.
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// A list of operations describing the updates to apply to the specified resource.
	// The patches are applied in the order specified in the list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// Represents an update integration request's resource identifier.
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// Represents an update integration request's API identifier.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIntegrationInput) GoString() string {
	return s.String()
}

// Represents an update integration response request.
type UpdateIntegrationResponseInput struct {
	_ struct{} `type:"structure"`

	// Specifies an update integration response request's HTTP method.
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// A list of operations describing the updates to apply to the specified resource.
	// The patches are applied in the order specified in the list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// Specifies an update integration response request's resource identifier.
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// Specifies an update integration response request's API identifier.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// Specifies an update integration response request's status code.
	StatusCode *string `location:"uri" locationName:"status_code" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateIntegrationResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIntegrationResponseInput) GoString() string {
	return s.String()
}

// Request to update an existing Method resource.
type UpdateMethodInput struct {
	_ struct{} `type:"structure"`

	// The HTTP verb that identifies the Method resource.
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// A list of operations describing the updates to apply to the specified resource.
	// The patches are applied in the order specified in the list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// The Resource identifier for the Method resource.
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// The RestApi identifier for the Method resource.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateMethodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMethodInput) GoString() string {
	return s.String()
}

// A request to update an existing MethodResponse resource.
type UpdateMethodResponseInput struct {
	_ struct{} `type:"structure"`

	// The HTTP verb identifier for the parent Method resource.
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// A list of operations describing the updates to apply to the specified resource.
	// The patches are applied in the order specified in the list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// The Resource identifier for the MethodResponse resource.
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// The RestApi identifier for the MethodResponse resource.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// The status code identifier for the MethodResponse resource.
	StatusCode *string `location:"uri" locationName:"status_code" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateMethodResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMethodResponseInput) GoString() string {
	return s.String()
}

// Request to update an existing model in an existing RestApi resource.
type UpdateModelInput struct {
	_ struct{} `type:"structure"`

	// The name of the model to update.
	ModelName *string `location:"uri" locationName:"model_name" type:"string" required:"true"`

	// A list of operations describing the updates to apply to the specified resource.
	// The patches are applied in the order specified in the list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// The RestApi identifier under which the model exists.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateModelInput) GoString() string {
	return s.String()
}

// Request to change information about a Resource resource.
type UpdateResourceInput struct {
	_ struct{} `type:"structure"`

	// A list of operations describing the updates to apply to the specified resource.
	// The patches are applied in the order specified in the list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// The identifier of the Resource resource.
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// The RestApi identifier for the Resource resource.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceInput) GoString() string {
	return s.String()
}

// Request to update an existing RestApi resource in your collection.
type UpdateRestApiInput struct {
	_ struct{} `type:"structure"`

	// A list of operations describing the updates to apply to the specified resource.
	// The patches are applied in the order specified in the list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// The ID of the RestApi you want to update.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRestApiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRestApiInput) GoString() string {
	return s.String()
}

// Requests Amazon API Gateway to change information about a Stage resource.
type UpdateStageInput struct {
	_ struct{} `type:"structure"`

	// A list of operations describing the updates to apply to the specified resource.
	// The patches are applied in the order specified in the list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// The identifier of the RestApi resource for the Stage resource to change information
	// about.
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// The name of the Stage resource to change information about.
	StageName *string `location:"uri" locationName:"stage_name" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStageInput) GoString() string {
	return s.String()
}

// Returns the size of the CacheCluster.
const (
	// @enum CacheClusterSize
	CacheClusterSize05 = "0.5"
	// @enum CacheClusterSize
	CacheClusterSize16 = "1.6"
	// @enum CacheClusterSize
	CacheClusterSize61 = "6.1"
	// @enum CacheClusterSize
	CacheClusterSize135 = "13.5"
	// @enum CacheClusterSize
	CacheClusterSize284 = "28.4"
	// @enum CacheClusterSize
	CacheClusterSize582 = "58.2"
	// @enum CacheClusterSize
	CacheClusterSize118 = "118"
	// @enum CacheClusterSize
	CacheClusterSize237 = "237"
)

// Returns the status of the CacheCluster.
const (
	// @enum CacheClusterStatus
	CacheClusterStatusCreateInProgress = "CREATE_IN_PROGRESS"
	// @enum CacheClusterStatus
	CacheClusterStatusAvailable = "AVAILABLE"
	// @enum CacheClusterStatus
	CacheClusterStatusDeleteInProgress = "DELETE_IN_PROGRESS"
	// @enum CacheClusterStatus
	CacheClusterStatusNotAvailable = "NOT_AVAILABLE"
	// @enum CacheClusterStatus
	CacheClusterStatusFlushInProgress = "FLUSH_IN_PROGRESS"
)

// The integration type. Possible values are HTTP, AWS, or Mock.
const (
	// @enum IntegrationType
	IntegrationTypeHttp = "HTTP"
	// @enum IntegrationType
	IntegrationTypeAws = "AWS"
	// @enum IntegrationType
	IntegrationTypeMock = "MOCK"
)

const (
	// @enum op
	OpAdd = "add"
	// @enum op
	OpRemove = "remove"
	// @enum op
	OpReplace = "replace"
	// @enum op
	OpMove = "move"
	// @enum op
	OpCopy = "copy"
	// @enum op
	OpTest = "test"
)
