/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gnome-scan
 * Copyright (C) Étienne Bersac 2007 <bersace03@laposte.net>
 * 
 * gnome-scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#include <glib/gi18n.h>
#include "gnome-scan-param-specs.h"
#include "flegita-output-filename-widget.h"
#include "flegita-pspec.h"

#define	GET_PRIVATE(o)	(G_TYPE_INSTANCE_GET_PRIVATE ((o), FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET, FlegitaOutputFilenameWidgetPrivate))

typedef struct _FlegitaOutputFilenameWidgetPrivate FlegitaOutputFilenameWidgetPrivate;
struct _FlegitaOutputFilenameWidgetPrivate
{
	GtkWidget		*filechooser;
	GtkWidget		*entry;
	GtkWidget		*combo;
	GtkListStore	*liststore;
};

enum {
	SUFFIX_ICON,
	SUFFIX_DESC,
	SUFFIX_NAME,
	SUFFIX_N_COLUMNS
};

GS_DEFINE_PARAM_WIDGET (FlegitaOutputFilenameWidget, flegita_output_filename_widget)

static gboolean	fofw_output_filename_changed (FlegitaOutputFilenameWidget *widget);

static void
flegita_output_filename_widget_init (FlegitaOutputFilenameWidget *object)
{
	/* TODO: Add initialization code here */
}

static void
flegita_output_filename_widget_finalize (GObject *object)
{
	/* TODO: Add deinitalization code here */

	G_OBJECT_CLASS (flegita_output_filename_widget_parent_class)->finalize (object);
}

static void
flegita_output_filename_widget_build (GnomeScanParamWidget *widget)
{
	FlegitaOutputFilenameWidget *fofw = FLEGITA_OUTPUT_FILENAME_WIDGET (widget);
	FlegitaOutputFilenameWidgetPrivate *priv = GET_PRIVATE (fofw);
	GtkTreeIter iter;
	GtkCellRenderer *renderer;
	GSList *node;
	GnomeScanFormat *format;
	widget->shows_label = FALSE;
	widget->expands = FALSE;
	
	/* directory */
	priv->filechooser = gtk_file_chooser_button_new (_("Select directory"),
													 GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
	gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (priv->filechooser),
										 g_get_user_special_dir (G_USER_DIRECTORY_PICTURES));
	g_signal_connect_swapped (priv->filechooser, "selection-changed",
							  (GCallback) fofw_output_filename_changed,
							  fofw);
	gtk_box_pack_start (GTK_BOX (widget), priv->filechooser, FALSE, TRUE, 0);
	
	/* filename */
	priv->entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (priv->entry), _("Scanned image"));
	g_signal_connect_swapped (priv->entry, "focus-out-event",
							  (GCallback) fofw_output_filename_changed,
							  fofw);
	gtk_box_pack_start (GTK_BOX (widget), priv->entry, TRUE, TRUE, 0);
	
	
	/* suffixes */
	priv->liststore = gtk_list_store_new (SUFFIX_N_COLUMNS,
										  G_TYPE_STRING,
										  G_TYPE_STRING,
										  G_TYPE_STRING);
	
	priv->combo = gtk_combo_box_new_with_model (GTK_TREE_MODEL (priv->liststore));
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer,
				  "stock-size", GTK_ICON_SIZE_BUTTON,
				  NULL);
	gtk_cell_layout_pack_start (GTK_CELL_LAYOUT(priv->combo), renderer, FALSE);
	gtk_cell_layout_set_attributes (GTK_CELL_LAYOUT (priv->combo), renderer,
									"icon-name", SUFFIX_ICON,
									NULL);
	
	renderer = gtk_cell_renderer_text_new ();
	gtk_cell_layout_pack_start (GTK_CELL_LAYOUT (priv->combo), renderer, TRUE);
	gtk_cell_layout_set_attributes (GTK_CELL_LAYOUT (priv->combo), renderer,
									"text", SUFFIX_DESC,
									NULL);
	
	node = flegita_param_output_filename_get_formats (widget->pspec);
	for (; node ; node = node->next) {
		format = node->data;
		gtk_list_store_insert_with_values (priv->liststore, &iter, -1,
										   SUFFIX_ICON, "gnome-mime-image",
										   SUFFIX_DESC, format->extensions[0],
										   SUFFIX_NAME, format->name,
										   -1);
	}
	gtk_box_pack_start (GTK_BOX (widget), priv->combo, FALSE, FALSE, 0);
	
	gtk_combo_box_set_active (GTK_COMBO_BOX (priv->combo), 0);
	
	g_signal_connect_swapped (priv->combo, "changed",
							  (GCallback) fofw_output_filename_changed,
							  FLEGITA_OUTPUT_FILENAME_WIDGET (widget));
}

static void
flegita_output_filename_widget_set (GnomeScanParamWidget *widget,
									GValue *value)
{
	FlegitaOutputFilenameWidgetPrivate *priv = GET_PRIVATE(widget);
	const gchar *path = g_value_get_string(value);
	gchar *dir = g_path_get_dirname (path);
	gchar *file = g_path_get_basename (path);
	gchar **parts = g_strsplit (file, ".", 2);
	
	gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER(priv->filechooser),
								   dir);
	gtk_entry_set_text (GTK_ENTRY(priv->entry), parts[0]);
}


/* OUTPUT_FILENAME */

static gboolean
fofw_output_filename_changed (FlegitaOutputFilenameWidget *fofw)
{
	GnomeScanParamWidget *gspw = GNOME_SCAN_PARAM_WIDGET (fofw);
	FlegitaOutputFilenameWidgetPrivate *priv = GET_PRIVATE (fofw);
	GtkTreeIter iter;
	gchar*suffix;
	
	gtk_combo_box_get_active_iter (GTK_COMBO_BOX (priv->combo), &iter);
	if (!gtk_list_store_iter_is_valid (priv->liststore, &iter))
		return FALSE;
	
	gtk_tree_model_get (GTK_TREE_MODEL (priv->liststore), &iter,
						SUFFIX_NAME, &suffix,
						-1);
	
	gchar *path = g_strdup_printf ("%s%c%s.%s",
								   gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (priv->filechooser)),
								   G_DIR_SEPARATOR,
								   gtk_entry_get_text (GTK_ENTRY (priv->entry)),
								   suffix);
	
	if (!g_str_equal (path, g_value_get_string(gspw->value))) {
		g_value_set_string (gspw->value,
							path);
		
		gnome_scan_param_widget_changed (gspw);
	}
	
	g_free (path);
	return FALSE;
}
