/* wii-header.c generated by valac 0.36.9, the Vala compiler
 * generated from wii-header.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/
/* Documentation: http://wiibrew.org/wiki/Wii_Disc*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define GAMES_TYPE_WII_HEADER (games_wii_header_get_type ())
#define GAMES_WII_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_WII_HEADER, GamesWiiHeader))
#define GAMES_WII_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_WII_HEADER, GamesWiiHeaderClass))
#define GAMES_IS_WII_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_WII_HEADER))
#define GAMES_IS_WII_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_WII_HEADER))
#define GAMES_WII_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_WII_HEADER, GamesWiiHeaderClass))

typedef struct _GamesWiiHeader GamesWiiHeader;
typedef struct _GamesWiiHeaderClass GamesWiiHeaderClass;
typedef struct _GamesWiiHeaderPrivate GamesWiiHeaderPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GamesWiiHeader {
	GObject parent_instance;
	GamesWiiHeaderPrivate * priv;
};

struct _GamesWiiHeaderClass {
	GObjectClass parent_class;
};

struct _GamesWiiHeaderPrivate {
	GFile* file;
};

typedef enum  {
	GAMES_WII_ERROR_CANT_READ_FILE,
	GAMES_WII_ERROR_INVALID_SIZE,
	GAMES_WII_ERROR_INVALID_HEADER
} GamesWiiError;
#define GAMES_WII_ERROR games_wii_error_quark ()

static gpointer games_wii_header_parent_class = NULL;
static GType games_wii_header_type_id = 0;

GType games_wii_header_get_type (void) G_GNUC_CONST;
#define GAMES_WII_HEADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_WII_HEADER, GamesWiiHeaderPrivate))
enum  {
	GAMES_WII_HEADER_0_PROPERTY
};
#define GAMES_WII_HEADER_MAGIC_OFFSET ((gsize) 0x18)
#define GAMES_WII_HEADER_MAGIC_VALUE "\x5d\x1c\x9e\xa3"
GamesWiiHeader* games_wii_header_new (GFile* file);
GamesWiiHeader* games_wii_header_construct (GType object_type, GFile* file);
GQuark games_wii_error_quark (void);
void games_wii_header_check_validity (GamesWiiHeader* self, GError** error);
static GFileInputStream* games_wii_header_get_stream (GamesWiiHeader* self, GError** error);
gchar* games_wii_header_get_game_id (GamesWiiHeader* self, GError** error);
static void games_wii_header_finalize (GObject * obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GamesWiiHeader* games_wii_header_construct (GType object_type, GFile* file) {
	GamesWiiHeader * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (GamesWiiHeader*) g_object_new (object_type, NULL);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	return self;
}


GamesWiiHeader* games_wii_header_new (GFile* file) {
	return games_wii_header_construct (GAMES_TYPE_WII_HEADER, file);
}


void games_wii_header_check_validity (GamesWiiHeader* self, GError** error) {
	GFileInputStream* stream = NULL;
	GFileInputStream* _tmp0_;
	guint8* buffer = NULL;
	gint _tmp5_;
	gint _tmp6_;
	guint8* _tmp7_;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* magic = NULL;
	guint8* _tmp13_;
	gint _tmp13__length1;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_wii_header_get_stream (self, &_inner_error_);
	stream = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == GAMES_WII_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		GFileInputStream* _tmp1_;
		_tmp1_ = stream;
		G_FILE_INPUT_STREAM_GET_CLASS (_tmp1_)->seek (_tmp1_, (gint64) GAMES_WII_HEADER_MAGIC_OFFSET, G_SEEK_SET, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		GError* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		_tmp4_ = g_error_new (GAMES_WII_ERROR, GAMES_WII_ERROR_INVALID_SIZE, _ ("Invalid Wii header size: %s"), _tmp3_);
		_inner_error_ = _tmp4_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == GAMES_WII_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (stream);
			return;
		} else {
			_g_object_unref0 (stream);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp5_ = strlen (GAMES_WII_HEADER_MAGIC_VALUE);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_new0 (guint8, _tmp6_);
	buffer = _tmp7_;
	buffer_length1 = _tmp6_;
	_buffer_size_ = buffer_length1;
	{
		GFileInputStream* _tmp8_;
		guint8* _tmp9_;
		gint _tmp9__length1;
		_tmp8_ = stream;
		_tmp9_ = buffer;
		_tmp9__length1 = buffer_length1;
		g_input_stream_read ((GInputStream*) _tmp8_, _tmp9_, (gsize) _tmp9__length1, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		GError* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		_tmp12_ = g_error_new_literal (GAMES_WII_ERROR, GAMES_WII_ERROR_INVALID_SIZE, _tmp11_);
		_inner_error_ = _tmp12_;
		_g_error_free0 (e);
		goto __finally1;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == GAMES_WII_ERROR) {
			g_propagate_error (error, _inner_error_);
			buffer = (g_free (buffer), NULL);
			_g_object_unref0 (stream);
			return;
		} else {
			buffer = (g_free (buffer), NULL);
			_g_object_unref0 (stream);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp13_ = buffer;
	_tmp13__length1 = buffer_length1;
	_tmp14_ = g_strdup ((const gchar*) _tmp13_);
	magic = _tmp14_;
	_tmp15_ = magic;
	if (g_strcmp0 (_tmp15_, GAMES_WII_HEADER_MAGIC_VALUE) != 0) {
		GError* _tmp16_;
		_tmp16_ = g_error_new_literal (GAMES_WII_ERROR, GAMES_WII_ERROR_INVALID_HEADER, _ ("The file doesn’t have a Wii header."));
		_inner_error_ = _tmp16_;
		if (_inner_error_->domain == GAMES_WII_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (magic);
			buffer = (g_free (buffer), NULL);
			_g_object_unref0 (stream);
			return;
		} else {
			_g_free0 (magic);
			buffer = (g_free (buffer), NULL);
			_g_object_unref0 (stream);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (magic);
	buffer = (g_free (buffer), NULL);
	_g_object_unref0 (stream);
}


gchar* games_wii_header_get_game_id (GamesWiiHeader* self, GError** error) {
	gchar* result = NULL;
	guint8 buffer[6] = {0};
	GFileInputStream* stream = NULL;
	GFileInputStream* _tmp0_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = games_wii_header_get_stream (self, &_inner_error_);
	stream = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == GAMES_WII_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		GFileInputStream* _tmp1_;
		_tmp1_ = stream;
		g_input_stream_read ((GInputStream*) _tmp1_, buffer, (gsize) 6, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = g_error_new_literal (GAMES_WII_ERROR, GAMES_WII_ERROR_INVALID_HEADER, _ ("The file doesn’t have a Wii header."));
		_inner_error_ = _tmp2_;
		_g_error_free0 (e);
		goto __finally2;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == GAMES_WII_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (stream);
			return NULL;
		} else {
			_g_object_unref0 (stream);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = g_strdup ((const gchar*) buffer);
	result = _tmp3_;
	_g_object_unref0 (stream);
	return result;
}


static GFileInputStream* games_wii_header_get_stream (GamesWiiHeader* self, GError** error) {
	GFileInputStream* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GFileInputStream* _tmp0_ = NULL;
		GFile* _tmp1_;
		GFileInputStream* _tmp2_;
		GFileInputStream* _tmp3_;
		_tmp1_ = self->priv->file;
		_tmp2_ = g_file_read (_tmp1_, NULL, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp3_;
		_g_object_unref0 (_tmp0_);
		return result;
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		GError* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = g_error_new (GAMES_WII_ERROR, GAMES_WII_ERROR_CANT_READ_FILE, _ ("Couldn’t read file: %s"), _tmp5_);
		_inner_error_ = _tmp6_;
		_g_error_free0 (e);
		goto __finally3;
	}
	__finally3:
	if (_inner_error_->domain == GAMES_WII_ERROR) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void games_wii_header_class_init (GamesWiiHeaderClass * klass) {
	games_wii_header_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesWiiHeaderPrivate));
	G_OBJECT_CLASS (klass)->finalize = games_wii_header_finalize;
}


static void games_wii_header_instance_init (GamesWiiHeader * self) {
	self->priv = GAMES_WII_HEADER_GET_PRIVATE (self);
}


static void games_wii_header_finalize (GObject * obj) {
	GamesWiiHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_WII_HEADER, GamesWiiHeader);
	_g_object_unref0 (self->priv->file);
	G_OBJECT_CLASS (games_wii_header_parent_class)->finalize (obj);
}


GType games_wii_header_get_type (void) {
	return games_wii_header_type_id;
}


GType games_wii_header_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GamesWiiHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_wii_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesWiiHeader), 0, (GInstanceInitFunc) games_wii_header_instance_init, NULL };
	games_wii_header_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesWiiHeader", &g_define_type_info, 0);
	return games_wii_header_type_id;
}


GQuark games_wii_error_quark (void) {
	return g_quark_from_static_string ("games_wii_error-quark");
}



