/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.sun.enterprise.deployment.xml;

/** 
 * I hold the XML tag names common to the dtds across the J2EE platform.
 * @author Jerome Dochez
 */

public interface TagNames {

    public static final String NAME = "display-name";
    public static final String ID = "id";
    public static final String DESCRIPTION = "description";
    public static final String VERSION = "version";
    public static final String METADATA_COMPLETE = "metadata-complete";
 
    public static final String ICON = "icon";
    public static final String LARGE_ICON = "large-icon";
    public static final String SMALL_ICON = "small-icon";

    public static final String ENVIRONMENT_PROPERTY = "env-entry";
    public static final String ENVIRONMENT_PROPERTY_NAME = "env-entry-name";
    public static final String ENVIRONMENT_PROPERTY_VALUE = "env-entry-value";
    public static final String ENVIRONMENT_PROPERTY_TYPE = "env-entry-type";

    public static final String EJB_REFERENCE = "ejb-ref";
    public static final String EJB_REFERENCE_NAME = "ejb-ref-name";
    public static final String EJB_REFERENCE_TYPE = "ejb-ref-type";
    public static final String EJB_LINK = "ejb-link";
    
    public static final String EJB_LOCAL_REFERENCE = "ejb-local-ref";
    
    public static final String RESOURCE_REFERENCE = "resource-ref";
    public static final String RESOURCE_REFERENCE_NAME = "res-ref-name";
    public static final String RESOURCE_SHARING_SCOPE = "res-sharing-scope";

    public static final String MESSAGE_DESTINATION_REFERENCE = "message-destination-ref";
    public static final String MESSAGE_DESTINATION_REFERENCE_NAME = "message-destination-ref-name";
    public static final String MESSAGE_DESTINATION = "message-destination";
    public static final String MESSAGE_DESTINATION_NAME = "message-destination-name";
    public static final String MESSAGE_DESTINATION_TYPE = "message-destination-type";
    public static final String MESSAGE_DESTINATION_USAGE = "message-destination-usage";
    public static final String MESSAGE_DESTINATION_LINK = "message-destination-link";

    public static final String RESOURCE_ENV_REFERENCE = "resource-env-ref";
    public static final String RESOURCE_ENV_REFERENCE_NAME = "resource-env-ref-name";
    public static final String RESOURCE_ENV_REFERENCE_TYPE = "resource-env-ref-type";

    public static final String PERSISTENCE_CONTEXT_REF = "persistence-context-ref";
    public static final String PERSISTENCE_CONTEXT_REF_NAME = "persistence-context-ref-name";

    public static final String PERSISTENCE_PROPERTY = "persistence-property";

    public static final String PERSISTENCE_UNIT_NAME = "persistence-unit-name";
    public static final String PERSISTENCE_CONTEXT_TYPE = "persistence-context-type";
    public static final String PERSISTENCE_UNIT_REF = "persistence-unit-ref";
    public static final String PERSISTENCE_UNIT_REF_NAME = "persistence-unit-ref-name";

    public static final String JMS_QUEUE_DEST_TYPE = "javax.jms.Queue";
    public static final String JMS_TOPIC_DEST_TYPE = "javax.jms.Topic";

    public static final String RESOURCE_TYPE = "res-type";
    public static final String RESOURCE_AUTHORIZATION = "res-auth";
    
    public static final String ROLE = "security-role";
    public static final String ROLE_NAME = "role-name";    
    public static final String ROLE_REFERENCE = "security-role-ref";
    public static final String ROLE_LINK = "role-link";    
    public static final String RUNAS_SPECIFIED_IDENTITY = "run-as";

    public static final String ENCODING_STYLE = "encoding-style";
    public static final String JAVA_TYPE = "java-type";

    public static final String WEB_SERVICE_ENDPOINT = "web-service-endpoint";
    public static final String XML_NAMESPACE_PREFIX = "xml:";
    public static final String LANG = "lang";

    public static final String NAME_VALUE_PAIR_NAME = "name";
    public static final String NAME_VALUE_PAIR_VALUE = "value";

    // injection tags
    public static final String INJECTION_TARGET = "injection-target";
    public static final String INJECTION_TARGET_CLASS = "injection-target-class";
    public static final String INJECTION_TARGET_NAME = "injection-target-name";
    public static final String MAPPED_NAME = "mapped-name";

    public static final String POST_CONSTRUCT = "post-construct";
    public static final String PRE_DESTROY = "pre-destroy";
    public static final String LIFECYCLE_CALLBACK_CLASS = "lifecycle-callback-class";  
    public static final String LIFECYCLE_CALLBACK_METHOD = "lifecycle-callback-method";  

    // deployment extension related tags
    public static final String DEPLOYMENT_EXTENSION = "deployment-extension";
    public static final String EXTENSION_ELEMENT = "extension-element";
    public static final String NAMESPACE = "namespace";
    public static final String MUST_UNDERSTAND = "mustUnderstand";

    public static final String J2EE_DEFAULTNAMESPACEPREFIX = "j2ee";
    public static final String J2EE_NAMESPACE = "http://java.sun.com/xml/ns/j2ee";
    public static final String JAVAEE_DEFAULTNAMESPACEPREFIX = "javaee";
    public static final String JAVAEE_NAMESPACE = "http://java.sun.com/xml/ns/javaee";
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";

    public static final String PERSISTENCE_XML_NAMESPACE = "urn:ejb3-namespace";
}
