#![allow(clippy::too_many_arguments)]

/// Log warning only if type in generated library
macro_rules! warn_main {
    ($tid: expr, $target:expr, $($arg:tt)*) => (
        if $tid.ns_id == crate::library::MAIN_NAMESPACE {
            log::warn!($target, $($arg)*);
        }
    );
}

// generated by build.rs
mod gir_version;

pub mod analysis;
mod case;
mod chunk;
mod codegen;
mod config;
mod consts;
mod custom_type_glib_priority;
mod env;
mod file_saver;
pub mod fmt;
mod git;
pub mod library;
mod library_postprocessing;
mod library_preprocessing;
mod nameutil;
mod parser;
mod traits;
pub mod update_version;
mod version;
mod visitors;
mod writer;
mod xmlparser;

pub use crate::{
    analysis::{
        class_hierarchy::run as class_hierarchy_run, namespaces::run as namespaces_run,
        run as analysis_run, symbols::run as symbols_run,
    },
    codegen::generate as codegen_generate,
    config::{Config, WorkMode},
    env::Env,
    library::Library,
};
