static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (dampness, _(\"Dampness\"), 0.95)                             \n"
"    description (_(\"The value represents the contribution of the past to the new frame.\"))\n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_C_SOURCE mblur.c                                              \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  GeglBuffer *acc;                                                            \n"
"} Priv;                                                                       \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"init (GeglProperties *o)                                                      \n"
"{                                                                             \n"
"  Priv         *priv = (Priv*)o->user_data;                                   \n"
"  GeglRectangle extent = {0,0,1024,1024};                                     \n"
"                                                                              \n"
"  g_assert (priv == NULL);                                                    \n"
"                                                                              \n"
"  priv = g_new0 (Priv, 1);                                                    \n"
"  o->user_data = (void*) priv;                                                \n"
"                                                                              \n"
"  priv->acc = gegl_buffer_new (&extent, babl_format (\"RGBA float\"));        \n"
"}                                                                             \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o;                                                          \n"
"  Priv           *p;                                                          \n"
"                                                                              \n"
"  o = GEGL_PROPERTIES (operation);                                            \n"
"  p = (Priv*)o->user_data;                                                    \n"
"  if (p == NULL)                                                              \n"
"    init (o);                                                                 \n"
"  p = (Priv*)o->user_data;                                                    \n"
"                                                                              \n"
"    {                                                                         \n"
"      GeglBuffer *temp_in;                                                    \n"
"                                                                              \n"
"      temp_in = gegl_buffer_create_sub_buffer (input, result);                \n"
"                                                                              \n"
"      {                                                                       \n"
"        gint pixels = result->width * result->height;                         \n"
"        gfloat *buf = g_new (gfloat, pixels * 4);                             \n"
"        gfloat *acc = g_new (gfloat, pixels * 4);                             \n"
"        gfloat dampness;                                                      \n"
"        gint i;                                                               \n"
"        gegl_buffer_get (p->acc, result, 1.0, babl_format (\"RGBA float\"), acc, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);\n"
"        gegl_buffer_get (temp_in, result, 1.0, babl_format (\"RGBA float\"), buf, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);\n"
"        dampness = o->dampness;                                               \n"
"        for (i=0;i<pixels;i++)                                                \n"
"          {                                                                   \n"
"            gint c;                                                           \n"
"            for (c=0;c<4;c++)                                                 \n"
"              acc[i*4+c]=acc[i*4+c]*dampness + buf[i*4+c]*(1.0-dampness);     \n"
"          }                                                                   \n"
"        gegl_buffer_set (p->acc, result, 0, babl_format (\"RGBA float\"), acc, GEGL_AUTO_ROWSTRIDE);\n"
"        gegl_buffer_set (output, result, 0, babl_format (\"RGBA float\"), acc, GEGL_AUTO_ROWSTRIDE);\n"
"        g_free (buf);                                                         \n"
"        g_free (acc);                                                         \n"
"      }                                                                       \n"
"      g_object_unref (temp_in);                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (object);                               \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      Priv *p = (Priv*)o->user_data;                                          \n"
"                                                                              \n"
"      g_object_unref (p->acc);                                                \n"
"                                                                              \n"
"      g_free (o->user_data);                                                  \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  G_OBJECT_CLASS (klass)->finalize = finalize;                                \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process = process;                                            \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:mblur\",                                          \n"
"    \"title\",       _(\"Temporal blur\"),                                    \n"
"    \"categories\" , \"blur:video\",                                          \n"
"    \"description\", _(\"Accumulating motion blur using a kalman filter, for use with video sequences of frames.\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
